// generated by diplomat-tool
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * Thin wrapper around a vector that maps visual indices to source indices
 *
 * `map[visualIndex] = sourceIndex`
 *
 * Produced by `reorder_visual()` on [`Bidi`].
 */
const ReorderedIndexMap_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_ReorderedIndexMap_destroy_mv1(ptr);
});

export class ReorderedIndexMap {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("ReorderedIndexMap is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            ReorderedIndexMap_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Get this as a slice/array of indices
     */
    get asSlice() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 8, 4, false);

        // This lifetime edge depends on lifetimes 'a
        let aEdges = [this];


        const result = wasm.icu4x_ReorderedIndexMap_as_slice_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            return Array.from(new diplomatRuntime.DiplomatSlicePrimitive(wasm, diplomatReceive.buffer, "u32", aEdges).getValue());
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * The length of this map
     */
    get length() {

        const result = wasm.icu4x_ReorderedIndexMap_len_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Whether this map is empty
     */
    get isEmpty() {

        const result = wasm.icu4x_ReorderedIndexMap_is_empty_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Get element at `index`. Returns 0 when out of bounds
     * (note that 0 is also a valid in-bounds value, please use `len()`
     * to avoid out-of-bounds)
     */
    get(index) {

        const result = wasm.icu4x_ReorderedIndexMap_get_mv1(this.ffiValue, index);

        try {
            return result;
        }

        finally {
        }
    }

    constructor(symbol, ptr, selfEdge) {
        return this.#internalConstructor(...arguments)
    }
}