import { CffWriteContext } from "../../../context/write";
import { CffBlendPrimitive, CffDrawCall } from "../draw-call";
export declare function argIsZero(x: number | CffBlendPrimitive): boolean;
export declare abstract class DrawCallOptimizationPass<State> {
    protected ctx: CffWriteContext;
    constructor(ctx: CffWriteContext);
    protected state: State | null;
    protected abstract doFlush(state: State): Iterable<CffDrawCall>;
    protected abstract tryUpdateState(state: State, incoming: CffDrawCall): null | State;
    protected abstract tryInitState(incoming: CffDrawCall): null | State;
    update(dc: CffDrawCall): Generator<CffDrawCall, void, any>;
    end(): Generator<CffDrawCall, void, any>;
}
export declare abstract class DrawCallOmit extends DrawCallOptimizationPass<boolean> {
    protected abstract match(dc: CffDrawCall): boolean;
    protected doFlush(): never[];
    protected tryInitState(dc: CffDrawCall): true | null;
    protected tryUpdateState(): null;
}
export declare function cffOptimizeDrawCall(dcSeq: Iterable<CffDrawCall>, passes: DrawCallOptimizationPass<unknown>[]): IterableIterator<CffDrawCall>;
//# sourceMappingURL=general.d.ts.map