"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GposPairReader = void 0;
const errors_1 = require("@ot-builder/errors");
const ot_layout_1 = require("@ot-builder/ot-layout");
const class_def_1 = require("../shared/class-def");
const coverage_1 = require("../shared/coverage");
const gpos_adjust_1 = require("../shared/gpos-adjust");
const SubtableFormat1 = {
    read(view, lookup, context) {
        const format = view.uint16();
        errors_1.Assert.FormatSupported(`PairPosFormat1`, format, 1);
        const cov = view.next(coverage_1.Ptr16GidCoverage);
        const valueFormat1 = view.uint16();
        const valueFormat2 = view.uint16();
        const pairSetCount = view.uint16();
        errors_1.Assert.SizeMatch("PairPosFormat1::pairSetCount", pairSetCount, cov.length);
        for (const glyph1 of coverage_1.CovUtils.glyphsFromGidList(cov, context.gOrd)) {
            const vPairSet = view.ptr16();
            const pairValueCount = vPairSet.uint16();
            for (let pvi = 0; pvi < pairValueCount; pvi++) {
                const glyph2 = context.gOrd.at(vPairSet.uint16());
                const value1 = vPairSet.next(gpos_adjust_1.GposAdjustment, valueFormat1, context.ivs);
                const value2 = vPairSet.next(gpos_adjust_1.GposAdjustment, valueFormat2, context.ivs);
                lookup.adjustments.setIfAbsent(new Set([glyph1]), new Set([glyph2]), [
                    value1,
                    value2
                ]);
            }
        }
    }
};
const SubtableFormat2 = {
    read(view, lookup, context) {
        const format = view.uint16();
        errors_1.Assert.FormatSupported(`PairPosFormat2`, format, 2);
        const cov = view.next(coverage_1.Ptr16GidCoverage);
        const valueFormat1 = view.uint16();
        const valueFormat2 = view.uint16();
        const cd1 = view.next(class_def_1.Ptr16ClassDef, context.gOrd);
        const cd2 = view.next(class_def_1.Ptr16ClassDef, context.gOrd);
        const class1Count = view.uint16();
        const class2Count = view.uint16();
        class_def_1.ClassDefUtil.limitToCov(cd1, coverage_1.CovUtils.glyphSetFromGidList(cov, context.gOrd));
        class_def_1.ClassDefUtil.padClass0(cd2, context.gOrd);
        const scd1 = class_def_1.ClassDefUtil.SplitClassDef(cd1);
        const scd2 = class_def_1.ClassDefUtil.SplitClassDef(cd2);
        for (let c1 = 0; c1 < class1Count; c1++) {
            const gs1 = scd1[c1] || [];
            for (let c2 = 0; c2 < class2Count; c2++) {
                const gs2 = scd2[c2] || [];
                const value1 = view.next(gpos_adjust_1.GposAdjustment, valueFormat1, context.ivs);
                const value2 = view.next(gpos_adjust_1.GposAdjustment, valueFormat2, context.ivs);
                lookup.adjustments.setIfAbsent(gs1, gs2, [value1, value2]);
            }
        }
    }
};
class GposPairReader {
    createLookup() {
        return new ot_layout_1.Gpos.Pair();
    }
    parseSubtable(view, lookup, context) {
        const format = view.lift(0).uint16();
        switch (format) {
            case 1:
                view.next(SubtableFormat1, lookup, context);
                break;
            case 2:
                view.next(SubtableFormat2, lookup, context);
                break;
            default:
                throw errors_1.Errors.FormatNotSupported(`PairPos`, format);
        }
    }
}
exports.GposPairReader = GposPairReader;
//# sourceMappingURL=gpos-pair-read.js.map