#!/bin/csh -f
#       $Id$
#   summary of shell scripts
#
echo ' '
echo 'GMTSAR version 6.2 - list of shell scripts'
echo ' '
echo 'align.csh                             - align a pair of SAR images'
echo 'align_ALOS2_SCAN.csh                  - align ALOS2 ScanSAR images'
echo 'align_ALOS_SLC.csh                    - align ALOS SLC images'
echo 'align_batch.csh                       - align a stack of ERS/ENVISAR/ALOS1 images'
echo 'align_batch_ALOS2_SCAN.csh            - align a stack of ALOS2 ScanSAR images'
echo 'align_batch_ALOS_SLC.csh              - align a stack of ALOS SLC images'
echo 'align_tops.csh                        - align Sentinel-1 TOPS images'
echo 'align_tops_esd.csh                    - align Sentinel-1 TOPS images with enhance spectral diversity'
echo 'baseline_table.csh                    - create a baseline table for a pair of images'
echo 'cleanup.csh                           - remove processed data in raw/SLC/intf directory'
echo 'correct_insar_with_gnss.csh           - correct interferogram with GNSS displacement'
echo 'correct_merge_offset.csh              - correct offset between subswaths after merging'
echo 'create_frame_tops.csh                 - re-assemble TOPS bursts to create a new frame'
echo 'create_merge_input.csh                - create inputlist for merge_batch.csh'
echo 'dem2topo_ra.csh                       - back geocode the topography to radar coordinates'
echo 'dem2topo_ra_ALOS2.csh                 - back geocode the topography for ALOS2 data'
echo 'download_sentinel_orbits.csh          - Downloads precise or restituted orbits for a list of Sentinel-1 data on Mac'
echo 'download_sentinel_orbits_linux.csh    - Downloads precise or restituted orbits for a list of Sentinel-1 data on Linux'
echo 'estimate_ionospheric_phase.csh        - estimate ionosphere based on split spectrum method'
echo 'extract_one_time_series.csh           - extract for a given position the SBAS time series'
echo 'filter.csh                            - Apply gaussian filter to amplitude and phase images'
echo 'fitoffset.csh                         - fit resampling parameters using offset estimates from xcorr'
echo 'geocode.csh                           - geocode the product in intf/day1_day2 directory'
echo 'get_baseline_table.csh                - create a baseline_table.dat for time-series analysis'
echo 'gmtsar.csh                            - list shell scripts in GMTSAR'
echo 'gmtsar_sharedir.csh                   - print the path of the shared directory of GMTSAR'
echo 'gnss_enu2los.csh                      - project E N U displacement into line of sight'
echo 'grd2geotiff.csh                       - convert grids into geotiff format for viewing'
echo 'grd2kml.csh                           - convert grids into kml(+png) format for viewing'
echo 'intf.csh                              - perform interferometry for a pair of SAR images'
echo 'intf_batch.csh                        - perform interferometry for a stack of ERS/ENVISAR/ALOS1 images'
echo 'intf_batch_ALOS2_SCAN.csh             - perform interferometry for a stack of ALOS2 ScanSAR images'
echo 'intf_tops.csh                         - perform interferometry for a stack of Sentinel-1 TOPS images'
echo 'intf_tops_parallel.csh                - perform interferometry for a stack of Sentinel-1 TOPS images using GNU parallel'
echo 'landmask.csh                          - make a landmask (remove wet region) in radar coordinates'
echo 'landmask_ALOS2.csh                    - make a landmask (remove wet region) in radar coordinates for ALOS2 data'
echo 'MAI_processing.csh                    - perform Multi-Aperture Interferometry'
echo 'm2s.csh                               - convert pixel dimension in meters to dx/dy in arc seconds at mean latitude'
echo 'make_a_offset.csh                     - use xcorr to compute azimuth(range) offset and make a grid/plot'
echo 'make_dem.csh                          - Uses GMT server to download SRTM 1-arcsec data'
echo 'make_los_ascii.csh                    - subsample LOS grid and add the look vector '
echo 'merge_batch.csh                       - combine data from multiple subswaths for a stack of TOPS data'
echo 'merge_unwrap_geocode_tops.csh         - combine data from multiple subswaths of TOPS data, unwrap and geocode the results'
echo 'organize_files_tops.csh               - organize one track of S1A TOPS data, redefine frames, auto-download precise orbits on Mac'
echo 'organize_files_tops_linux.csh         - organize one track of S1A TOPS data, redefine frames, auto-download precise orbits on Linux'
echo 'p2p_ALOS2_SCAN_Frame.csh              - process a pair of ALOS2 ScanSAR images'
echo 'p2p_ALOS2_SCAN_SLC.csh                - process a pair of ALOS2 ScanSAR subswath images'
echo 'p2p_ENVI.csh                          - process a pair of ENVISAR images using re-focusing'
echo 'p2p_ERS.csh                           - process a pair of ERS images using re-focusing'
echo 'p2p_S1_TOPS_Frame.csh                 - process a pair of Sentinel-1 TOPS images'
echo 'p2p_processing.csh                    - process a pair of any SAR images'
echo 'pop_config.csh                        - print config file for data from a specific satellite'
echo 'pre_proc.csh                          - preprocess satellite data and convert to GMTSAR format'
echo 'pre_proc_batch.csh                    - preprocess a stack of ERS/ENVISAR/ALOS1 data and convert to GMTSAR format'
echo 'pre_proc_batch_ALOS2_SCAN.csh         - preprocess a stack of ALOS2 ScanSAR data'
echo 'pre_proc_batch_ALOS_SLC.csh           - preprocess a stack of ALOS SLC data'
echo 'prep_data.csh                         - prepare an inputlist for preproc_batch_tops.csh automatically on Mac'
echo 'prep_data_linux.csh                   - prepare an inputlist for preproc_batch_tops.csh automatically on Linux'
echo 'prep_sbas.csh                         - prepare an inputlist for sbas'
echo 'preproc_batch_tops.csh                - preprocess and align a stack of Sentinel-1 TOPS data'
echo 'preproc_batch_tops_esd.csh            - preprocess and align a stack of Sentinel-1 TOPS data using enhance spectral diversity'
echo 'proj_ll2ra.csh                        - project a grid in geocoordinates to radar coordinates'
echo 'proj_ll2ra_ascii.csh                  - project records (3 or more) in geocoordinates to radar coordiantes'
echo 'proj_model.csh                        - project a simulated crust motion model into radar look directions '
echo 'proj_ra2ll.csh                        - project a grid in radar coordiantes to geocoordinates'
echo 'proj_ra2ll_ascii.csh                  - project records (3 or more) in radar coordinates to geocoordinates'
echo 'samp_slc.csh                          - resample SLC data to a new PRF and rng_samp_rate'
echo 'sarp.csh                              - focus a raw SAR image to form a SLC image'
echo 'select_pairs.csh                      - generate the input file for intf_tops.csh with given threshold of time and baseline'
echo 'shift_atime_PRM.csh                   - shift the PRM file with a given number of lines along azimuth'
echo 'slc2amp.csh                           - convert a SLC image to an amplitude grid'
echo 'snaphu.csh                            - unwrap interferogram'
echo 'snaphu_interp.csh                     - unwrap interferogram assuming smooth deformation'
echo 'stack.csh                             - compute mean and standard deviation for a list of grids'
echo 'stack_coherence_mask.csh              - stack the coherence and create a mask for data below a certain mean coherence'
echo 'stack_corr.csh                        - compute mean for a list of coherence grids'
echo 'tide_correction.csh                   - compute solid earth tide for a given grid'
echo 'unwrap_parallel.csh                   - run a customized unwrap_intf.csh using GNU parallel'
echo ' '
