// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// The results of a COMPLETED analysis report generated with StartAnalysisReport.
//
// For more information, see AnalysisTypeReportResult.
func (c *Client) GetAnalysisReportResults(ctx context.Context, params *GetAnalysisReportResultsInput, optFns ...func(*Options)) (*GetAnalysisReportResultsOutput, error) {
	if params == nil {
		params = &GetAnalysisReportResultsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAnalysisReportResults", params, optFns, c.addOperationGetAnalysisReportResultsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAnalysisReportResultsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAnalysisReportResultsInput struct {

	// The unique ID of the query that ran when you requested an analysis report.
	//
	// This member is required.
	AnalysisReportId *string

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallArn *string

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	FirewallName *string

	// The maximum number of objects that you want Network Firewall to return for this
	// request. If more objects are available, in the response, Network Firewall
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	MaxResults *int32

	// When you request a list of objects with a MaxResults setting, if the number of
	// objects that are still available for retrieval exceeds the maximum you
	// requested, Network Firewall returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string

	noSmithyDocumentSerde
}

type GetAnalysisReportResultsOutput struct {

	// Retrieves the results of a traffic analysis report.
	AnalysisReportResults []types.AnalysisTypeReportResult

	// The type of traffic that will be used to generate a report.
	AnalysisType types.EnabledAnalysisType

	// The date and time, up to the current date, from which to stop retrieving
	// analysis data, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ ).
	EndTime *time.Time

	// When you request a list of objects with a MaxResults setting, if the number of
	// objects that are still available for retrieval exceeds the maximum you
	// requested, Network Firewall returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string

	// The date and time the analysis report was ran.
	ReportTime *time.Time

	//  The date and time within the last 30 days from which to start retrieving
	// analysis data, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ .
	StartTime *time.Time

	// The status of the analysis report you specify. Statuses include RUNNING ,
	// COMPLETED , or FAILED .
	Status *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAnalysisReportResultsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetAnalysisReportResults{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetAnalysisReportResults{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAnalysisReportResults"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetAnalysisReportResultsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAnalysisReportResults(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetAnalysisReportResultsPaginatorOptions is the paginator options for
// GetAnalysisReportResults
type GetAnalysisReportResultsPaginatorOptions struct {
	// The maximum number of objects that you want Network Firewall to return for this
	// request. If more objects are available, in the response, Network Firewall
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetAnalysisReportResultsPaginator is a paginator for GetAnalysisReportResults
type GetAnalysisReportResultsPaginator struct {
	options   GetAnalysisReportResultsPaginatorOptions
	client    GetAnalysisReportResultsAPIClient
	params    *GetAnalysisReportResultsInput
	nextToken *string
	firstPage bool
}

// NewGetAnalysisReportResultsPaginator returns a new
// GetAnalysisReportResultsPaginator
func NewGetAnalysisReportResultsPaginator(client GetAnalysisReportResultsAPIClient, params *GetAnalysisReportResultsInput, optFns ...func(*GetAnalysisReportResultsPaginatorOptions)) *GetAnalysisReportResultsPaginator {
	if params == nil {
		params = &GetAnalysisReportResultsInput{}
	}

	options := GetAnalysisReportResultsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetAnalysisReportResultsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetAnalysisReportResultsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetAnalysisReportResults page.
func (p *GetAnalysisReportResultsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetAnalysisReportResultsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetAnalysisReportResults(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetAnalysisReportResultsAPIClient is a client that implements the
// GetAnalysisReportResults operation.
type GetAnalysisReportResultsAPIClient interface {
	GetAnalysisReportResults(context.Context, *GetAnalysisReportResultsInput, ...func(*Options)) (*GetAnalysisReportResultsOutput, error)
}

var _ GetAnalysisReportResultsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetAnalysisReportResults(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAnalysisReportResults",
	}
}
