//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork

// AuthenticationMethod - VPN client Authentication Method. Possible values are: 'EAPTLS' and 'EAPMSCHAPv2'.
type AuthenticationMethod string

const (
	AuthenticationMethodEAPMSCHAPv2 AuthenticationMethod = "EAPMSCHAPv2"
	AuthenticationMethodEAPTLS      AuthenticationMethod = "EAPTLS"
)

// PossibleAuthenticationMethodValues returns the possible values for the AuthenticationMethod const type.
func PossibleAuthenticationMethodValues() []AuthenticationMethod {
	return []AuthenticationMethod{
		AuthenticationMethodEAPMSCHAPv2,
		AuthenticationMethodEAPTLS,
	}
}

// BgpPeerState - The BGP peer state
type BgpPeerState string

const (
	BgpPeerStateConnected  BgpPeerState = "Connected"
	BgpPeerStateConnecting BgpPeerState = "Connecting"
	BgpPeerStateIdle       BgpPeerState = "Idle"
	BgpPeerStateStopped    BgpPeerState = "Stopped"
	BgpPeerStateUnknown    BgpPeerState = "Unknown"
)

// PossibleBgpPeerStateValues returns the possible values for the BgpPeerState const type.
func PossibleBgpPeerStateValues() []BgpPeerState {
	return []BgpPeerState{
		BgpPeerStateConnected,
		BgpPeerStateConnecting,
		BgpPeerStateIdle,
		BgpPeerStateStopped,
		BgpPeerStateUnknown,
	}
}

// DdosSettingsProtectionCoverage - The DDoS protection policy customizability of the public IP. Only standard coverage will
// have the ability to be customized.
type DdosSettingsProtectionCoverage string

const (
	DdosSettingsProtectionCoverageBasic    DdosSettingsProtectionCoverage = "Basic"
	DdosSettingsProtectionCoverageStandard DdosSettingsProtectionCoverage = "Standard"
)

// PossibleDdosSettingsProtectionCoverageValues returns the possible values for the DdosSettingsProtectionCoverage const type.
func PossibleDdosSettingsProtectionCoverageValues() []DdosSettingsProtectionCoverage {
	return []DdosSettingsProtectionCoverage{
		DdosSettingsProtectionCoverageBasic,
		DdosSettingsProtectionCoverageStandard,
	}
}

// DhGroup - The DH Groups used in IKE Phase 1 for initial SA.
type DhGroup string

const (
	DhGroupDHGroup1    DhGroup = "DHGroup1"
	DhGroupDHGroup14   DhGroup = "DHGroup14"
	DhGroupDHGroup2    DhGroup = "DHGroup2"
	DhGroupDHGroup2048 DhGroup = "DHGroup2048"
	DhGroupDHGroup24   DhGroup = "DHGroup24"
	DhGroupECP256      DhGroup = "ECP256"
	DhGroupECP384      DhGroup = "ECP384"
	DhGroupNone        DhGroup = "None"
)

// PossibleDhGroupValues returns the possible values for the DhGroup const type.
func PossibleDhGroupValues() []DhGroup {
	return []DhGroup{
		DhGroupDHGroup1,
		DhGroupDHGroup14,
		DhGroupDHGroup2,
		DhGroupDHGroup2048,
		DhGroupDHGroup24,
		DhGroupECP256,
		DhGroupECP384,
		DhGroupNone,
	}
}

// EffectiveRouteSource - Who created the route. Possible values are: 'Unknown', 'User', 'VirtualNetworkGateway', and 'Default'.
type EffectiveRouteSource string

const (
	EffectiveRouteSourceDefault               EffectiveRouteSource = "Default"
	EffectiveRouteSourceUnknown               EffectiveRouteSource = "Unknown"
	EffectiveRouteSourceUser                  EffectiveRouteSource = "User"
	EffectiveRouteSourceVirtualNetworkGateway EffectiveRouteSource = "VirtualNetworkGateway"
)

// PossibleEffectiveRouteSourceValues returns the possible values for the EffectiveRouteSource const type.
func PossibleEffectiveRouteSourceValues() []EffectiveRouteSource {
	return []EffectiveRouteSource{
		EffectiveRouteSourceDefault,
		EffectiveRouteSourceUnknown,
		EffectiveRouteSourceUser,
		EffectiveRouteSourceVirtualNetworkGateway,
	}
}

// EffectiveRouteState - The value of effective route. Possible values are: 'Active' and 'Invalid'.
type EffectiveRouteState string

const (
	EffectiveRouteStateActive  EffectiveRouteState = "Active"
	EffectiveRouteStateInvalid EffectiveRouteState = "Invalid"
)

// PossibleEffectiveRouteStateValues returns the possible values for the EffectiveRouteState const type.
func PossibleEffectiveRouteStateValues() []EffectiveRouteState {
	return []EffectiveRouteState{
		EffectiveRouteStateActive,
		EffectiveRouteStateInvalid,
	}
}

// EffectiveSecurityRuleProtocol - The network protocol this rule applies to. Possible values are: 'Tcp', 'Udp', and 'All'.
type EffectiveSecurityRuleProtocol string

const (
	EffectiveSecurityRuleProtocolAll EffectiveSecurityRuleProtocol = "All"
	EffectiveSecurityRuleProtocolTCP EffectiveSecurityRuleProtocol = "Tcp"
	EffectiveSecurityRuleProtocolUDP EffectiveSecurityRuleProtocol = "Udp"
)

// PossibleEffectiveSecurityRuleProtocolValues returns the possible values for the EffectiveSecurityRuleProtocol const type.
func PossibleEffectiveSecurityRuleProtocolValues() []EffectiveSecurityRuleProtocol {
	return []EffectiveSecurityRuleProtocol{
		EffectiveSecurityRuleProtocolAll,
		EffectiveSecurityRuleProtocolTCP,
		EffectiveSecurityRuleProtocolUDP,
	}
}

// IPAllocationMethod - The private IP allocation method. Possible values are: 'Static' and 'Dynamic'.
type IPAllocationMethod string

const (
	IPAllocationMethodDynamic IPAllocationMethod = "Dynamic"
	IPAllocationMethodStatic  IPAllocationMethod = "Static"
)

// PossibleIPAllocationMethodValues returns the possible values for the IPAllocationMethod const type.
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return []IPAllocationMethod{
		IPAllocationMethodDynamic,
		IPAllocationMethodStatic,
	}
}

// IPSecEncryption - The IPSec encryption algorithm (IKE phase 1).
type IPSecEncryption string

const (
	IPSecEncryptionAES128    IPSecEncryption = "AES128"
	IPSecEncryptionAES192    IPSecEncryption = "AES192"
	IPSecEncryptionAES256    IPSecEncryption = "AES256"
	IPSecEncryptionDES       IPSecEncryption = "DES"
	IPSecEncryptionDES3      IPSecEncryption = "DES3"
	IPSecEncryptionGCMAES128 IPSecEncryption = "GCMAES128"
	IPSecEncryptionGCMAES192 IPSecEncryption = "GCMAES192"
	IPSecEncryptionGCMAES256 IPSecEncryption = "GCMAES256"
	IPSecEncryptionNone      IPSecEncryption = "None"
)

// PossibleIPSecEncryptionValues returns the possible values for the IPSecEncryption const type.
func PossibleIPSecEncryptionValues() []IPSecEncryption {
	return []IPSecEncryption{
		IPSecEncryptionAES128,
		IPSecEncryptionAES192,
		IPSecEncryptionAES256,
		IPSecEncryptionDES,
		IPSecEncryptionDES3,
		IPSecEncryptionGCMAES128,
		IPSecEncryptionGCMAES192,
		IPSecEncryptionGCMAES256,
		IPSecEncryptionNone,
	}
}

// IPSecIntegrity - The IPSec integrity algorithm (IKE phase 1).
type IPSecIntegrity string

const (
	IPSecIntegrityGCMAES128 IPSecIntegrity = "GCMAES128"
	IPSecIntegrityGCMAES192 IPSecIntegrity = "GCMAES192"
	IPSecIntegrityGCMAES256 IPSecIntegrity = "GCMAES256"
	IPSecIntegrityMD5       IPSecIntegrity = "MD5"
	IPSecIntegritySHA1      IPSecIntegrity = "SHA1"
	IPSecIntegritySHA256    IPSecIntegrity = "SHA256"
)

// PossibleIPSecIntegrityValues returns the possible values for the IPSecIntegrity const type.
func PossibleIPSecIntegrityValues() []IPSecIntegrity {
	return []IPSecIntegrity{
		IPSecIntegrityGCMAES128,
		IPSecIntegrityGCMAES192,
		IPSecIntegrityGCMAES256,
		IPSecIntegrityMD5,
		IPSecIntegritySHA1,
		IPSecIntegritySHA256,
	}
}

// IPVersion - Available from Api-Version 2016-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or
// IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
type IPVersion string

const (
	IPVersionIPv4 IPVersion = "IPv4"
	IPVersionIPv6 IPVersion = "IPv6"
)

// PossibleIPVersionValues returns the possible values for the IPVersion const type.
func PossibleIPVersionValues() []IPVersion {
	return []IPVersion{
		IPVersionIPv4,
		IPVersionIPv6,
	}
}

// IkeEncryption - The IKE encryption algorithm (IKE phase 2).
type IkeEncryption string

const (
	IkeEncryptionAES128    IkeEncryption = "AES128"
	IkeEncryptionAES192    IkeEncryption = "AES192"
	IkeEncryptionAES256    IkeEncryption = "AES256"
	IkeEncryptionDES       IkeEncryption = "DES"
	IkeEncryptionDES3      IkeEncryption = "DES3"
	IkeEncryptionGCMAES128 IkeEncryption = "GCMAES128"
	IkeEncryptionGCMAES256 IkeEncryption = "GCMAES256"
)

// PossibleIkeEncryptionValues returns the possible values for the IkeEncryption const type.
func PossibleIkeEncryptionValues() []IkeEncryption {
	return []IkeEncryption{
		IkeEncryptionAES128,
		IkeEncryptionAES192,
		IkeEncryptionAES256,
		IkeEncryptionDES,
		IkeEncryptionDES3,
		IkeEncryptionGCMAES128,
		IkeEncryptionGCMAES256,
	}
}

// IkeIntegrity - The IKE integrity algorithm (IKE phase 2).
type IkeIntegrity string

const (
	IkeIntegrityGCMAES128 IkeIntegrity = "GCMAES128"
	IkeIntegrityGCMAES256 IkeIntegrity = "GCMAES256"
	IkeIntegrityMD5       IkeIntegrity = "MD5"
	IkeIntegritySHA1      IkeIntegrity = "SHA1"
	IkeIntegritySHA256    IkeIntegrity = "SHA256"
	IkeIntegritySHA384    IkeIntegrity = "SHA384"
)

// PossibleIkeIntegrityValues returns the possible values for the IkeIntegrity const type.
func PossibleIkeIntegrityValues() []IkeIntegrity {
	return []IkeIntegrity{
		IkeIntegrityGCMAES128,
		IkeIntegrityGCMAES256,
		IkeIntegrityMD5,
		IkeIntegritySHA1,
		IkeIntegritySHA256,
		IkeIntegritySHA384,
	}
}

// LoadBalancerSKUName - Name of a load balancer SKU.
type LoadBalancerSKUName string

const (
	LoadBalancerSKUNameBasic    LoadBalancerSKUName = "Basic"
	LoadBalancerSKUNameStandard LoadBalancerSKUName = "Standard"
)

// PossibleLoadBalancerSKUNameValues returns the possible values for the LoadBalancerSKUName const type.
func PossibleLoadBalancerSKUNameValues() []LoadBalancerSKUName {
	return []LoadBalancerSKUName{
		LoadBalancerSKUNameBasic,
		LoadBalancerSKUNameStandard,
	}
}

// LoadDistribution - The load distribution policy for this rule. Possible values are 'Default', 'SourceIP', and 'SourceIPProtocol'.
type LoadDistribution string

const (
	LoadDistributionDefault          LoadDistribution = "Default"
	LoadDistributionSourceIP         LoadDistribution = "SourceIP"
	LoadDistributionSourceIPProtocol LoadDistribution = "SourceIPProtocol"
)

// PossibleLoadDistributionValues returns the possible values for the LoadDistribution const type.
func PossibleLoadDistributionValues() []LoadDistribution {
	return []LoadDistribution{
		LoadDistributionDefault,
		LoadDistributionSourceIP,
		LoadDistributionSourceIPProtocol,
	}
}

// NetworkOperationStatus - Status of the Azure async operation. Possible values are: 'InProgress', 'Succeeded', and 'Failed'.
type NetworkOperationStatus string

const (
	NetworkOperationStatusFailed     NetworkOperationStatus = "Failed"
	NetworkOperationStatusInProgress NetworkOperationStatus = "InProgress"
	NetworkOperationStatusSucceeded  NetworkOperationStatus = "Succeeded"
)

// PossibleNetworkOperationStatusValues returns the possible values for the NetworkOperationStatus const type.
func PossibleNetworkOperationStatusValues() []NetworkOperationStatus {
	return []NetworkOperationStatus{
		NetworkOperationStatusFailed,
		NetworkOperationStatusInProgress,
		NetworkOperationStatusSucceeded,
	}
}

// OutboundRulePropertiesFormatProtocol - Protocol - TCP, UDP or All
type OutboundRulePropertiesFormatProtocol string

const (
	OutboundRulePropertiesFormatProtocolAll OutboundRulePropertiesFormatProtocol = "All"
	OutboundRulePropertiesFormatProtocolTCP OutboundRulePropertiesFormatProtocol = "Tcp"
	OutboundRulePropertiesFormatProtocolUDP OutboundRulePropertiesFormatProtocol = "Udp"
)

// PossibleOutboundRulePropertiesFormatProtocolValues returns the possible values for the OutboundRulePropertiesFormatProtocol const type.
func PossibleOutboundRulePropertiesFormatProtocolValues() []OutboundRulePropertiesFormatProtocol {
	return []OutboundRulePropertiesFormatProtocol{
		OutboundRulePropertiesFormatProtocolAll,
		OutboundRulePropertiesFormatProtocolTCP,
		OutboundRulePropertiesFormatProtocolUDP,
	}
}

// PfsGroup - The Pfs Groups used in IKE Phase 2 for new child SA.
type PfsGroup string

const (
	PfsGroupECP256  PfsGroup = "ECP256"
	PfsGroupECP384  PfsGroup = "ECP384"
	PfsGroupNone    PfsGroup = "None"
	PfsGroupPFS1    PfsGroup = "PFS1"
	PfsGroupPFS14   PfsGroup = "PFS14"
	PfsGroupPFS2    PfsGroup = "PFS2"
	PfsGroupPFS2048 PfsGroup = "PFS2048"
	PfsGroupPFS24   PfsGroup = "PFS24"
	PfsGroupPFSMM   PfsGroup = "PFSMM"
)

// PossiblePfsGroupValues returns the possible values for the PfsGroup const type.
func PossiblePfsGroupValues() []PfsGroup {
	return []PfsGroup{
		PfsGroupECP256,
		PfsGroupECP384,
		PfsGroupNone,
		PfsGroupPFS1,
		PfsGroupPFS14,
		PfsGroupPFS2,
		PfsGroupPFS2048,
		PfsGroupPFS24,
		PfsGroupPFSMM,
	}
}

// ProbeProtocol - The protocol of the end point. Possible values are: 'Http', 'Tcp', or 'Https'. If 'Tcp' is specified, a
// received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a
// 200 OK response from the specifies URI is required for the probe to be successful.
type ProbeProtocol string

const (
	ProbeProtocolHTTP  ProbeProtocol = "Http"
	ProbeProtocolHTTPS ProbeProtocol = "Https"
	ProbeProtocolTCP   ProbeProtocol = "Tcp"
)

// PossibleProbeProtocolValues returns the possible values for the ProbeProtocol const type.
func PossibleProbeProtocolValues() []ProbeProtocol {
	return []ProbeProtocol{
		ProbeProtocolHTTP,
		ProbeProtocolHTTPS,
		ProbeProtocolTCP,
	}
}

// ProcessorArchitecture - VPN client Processor Architecture. Possible values are: 'AMD64' and 'X86'.
type ProcessorArchitecture string

const (
	ProcessorArchitectureAmd64 ProcessorArchitecture = "Amd64"
	ProcessorArchitectureX86   ProcessorArchitecture = "X86"
)

// PossibleProcessorArchitectureValues returns the possible values for the ProcessorArchitecture const type.
func PossibleProcessorArchitectureValues() []ProcessorArchitecture {
	return []ProcessorArchitecture{
		ProcessorArchitectureAmd64,
		ProcessorArchitectureX86,
	}
}

// PublicIPAddressSKUName - Name of a public IP address SKU.
type PublicIPAddressSKUName string

const (
	PublicIPAddressSKUNameBasic    PublicIPAddressSKUName = "Basic"
	PublicIPAddressSKUNameStandard PublicIPAddressSKUName = "Standard"
)

// PossiblePublicIPAddressSKUNameValues returns the possible values for the PublicIPAddressSKUName const type.
func PossiblePublicIPAddressSKUNameValues() []PublicIPAddressSKUName {
	return []PublicIPAddressSKUName{
		PublicIPAddressSKUNameBasic,
		PublicIPAddressSKUNameStandard,
	}
}

// ResourceIdentityType - The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both
// an implicitly created identity and a set of user assigned identities. The type 'None' will remove any
// identities from the virtual machine.
type ResourceIdentityType string

const (
	ResourceIdentityTypeSystemAssigned             ResourceIdentityType = "SystemAssigned"
	ResourceIdentityTypeUserAssigned               ResourceIdentityType = "UserAssigned"
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	ResourceIdentityTypeNone                       ResourceIdentityType = "None"
)

// PossibleResourceIdentityTypeValues returns the possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{
		ResourceIdentityTypeSystemAssigned,
		ResourceIdentityTypeUserAssigned,
		ResourceIdentityTypeSystemAssignedUserAssigned,
		ResourceIdentityTypeNone,
	}
}

// RouteNextHopType - The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal',
// 'Internet', 'VirtualAppliance', and 'None'.
type RouteNextHopType string

const (
	RouteNextHopTypeInternet              RouteNextHopType = "Internet"
	RouteNextHopTypeNone                  RouteNextHopType = "None"
	RouteNextHopTypeVirtualAppliance      RouteNextHopType = "VirtualAppliance"
	RouteNextHopTypeVirtualNetworkGateway RouteNextHopType = "VirtualNetworkGateway"
	RouteNextHopTypeVnetLocal             RouteNextHopType = "VnetLocal"
)

// PossibleRouteNextHopTypeValues returns the possible values for the RouteNextHopType const type.
func PossibleRouteNextHopTypeValues() []RouteNextHopType {
	return []RouteNextHopType{
		RouteNextHopTypeInternet,
		RouteNextHopTypeNone,
		RouteNextHopTypeVirtualAppliance,
		RouteNextHopTypeVirtualNetworkGateway,
		RouteNextHopTypeVnetLocal,
	}
}

// SecurityRuleAccess - Whether network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'.
type SecurityRuleAccess string

const (
	SecurityRuleAccessAllow SecurityRuleAccess = "Allow"
	SecurityRuleAccessDeny  SecurityRuleAccess = "Deny"
)

// PossibleSecurityRuleAccessValues returns the possible values for the SecurityRuleAccess const type.
func PossibleSecurityRuleAccessValues() []SecurityRuleAccess {
	return []SecurityRuleAccess{
		SecurityRuleAccessAllow,
		SecurityRuleAccessDeny,
	}
}

// SecurityRuleDirection - The direction of the rule. Possible values are: 'Inbound and Outbound'.
type SecurityRuleDirection string

const (
	SecurityRuleDirectionInbound  SecurityRuleDirection = "Inbound"
	SecurityRuleDirectionOutbound SecurityRuleDirection = "Outbound"
)

// PossibleSecurityRuleDirectionValues returns the possible values for the SecurityRuleDirection const type.
func PossibleSecurityRuleDirectionValues() []SecurityRuleDirection {
	return []SecurityRuleDirection{
		SecurityRuleDirectionInbound,
		SecurityRuleDirectionOutbound,
	}
}

// SecurityRuleProtocol - Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'.
type SecurityRuleProtocol string

const (
	SecurityRuleProtocolAsterisk SecurityRuleProtocol = "*"
	SecurityRuleProtocolTCP      SecurityRuleProtocol = "Tcp"
	SecurityRuleProtocolUDP      SecurityRuleProtocol = "Udp"
)

// PossibleSecurityRuleProtocolValues returns the possible values for the SecurityRuleProtocol const type.
func PossibleSecurityRuleProtocolValues() []SecurityRuleProtocol {
	return []SecurityRuleProtocol{
		SecurityRuleProtocolAsterisk,
		SecurityRuleProtocolTCP,
		SecurityRuleProtocolUDP,
	}
}

// TransportProtocol - The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'.
type TransportProtocol string

const (
	TransportProtocolAll TransportProtocol = "All"
	TransportProtocolTCP TransportProtocol = "Tcp"
	TransportProtocolUDP TransportProtocol = "Udp"
)

// PossibleTransportProtocolValues returns the possible values for the TransportProtocol const type.
func PossibleTransportProtocolValues() []TransportProtocol {
	return []TransportProtocol{
		TransportProtocolAll,
		TransportProtocolTCP,
		TransportProtocolUDP,
	}
}

// VPNClientProtocol - VPN client protocol enabled for the virtual network gateway.
type VPNClientProtocol string

const (
	VPNClientProtocolIkeV2   VPNClientProtocol = "IkeV2"
	VPNClientProtocolOpenVPN VPNClientProtocol = "OpenVPN"
	VPNClientProtocolSSTP    VPNClientProtocol = "SSTP"
)

// PossibleVPNClientProtocolValues returns the possible values for the VPNClientProtocol const type.
func PossibleVPNClientProtocolValues() []VPNClientProtocol {
	return []VPNClientProtocol{
		VPNClientProtocolIkeV2,
		VPNClientProtocolOpenVPN,
		VPNClientProtocolSSTP,
	}
}

// VPNType - The type of this virtual network gateway. Possible values are: 'PolicyBased' and 'RouteBased'.
type VPNType string

const (
	VPNTypePolicyBased VPNType = "PolicyBased"
	VPNTypeRouteBased  VPNType = "RouteBased"
)

// PossibleVPNTypeValues returns the possible values for the VPNType const type.
func PossibleVPNTypeValues() []VPNType {
	return []VPNType{
		VPNTypePolicyBased,
		VPNTypeRouteBased,
	}
}

// VirtualNetworkGatewayConnectionProtocol - Gateway connection protocol. Possible values are: 'IKEv2', 'IKEv1'.
type VirtualNetworkGatewayConnectionProtocol string

const (
	VirtualNetworkGatewayConnectionProtocolIKEv1 VirtualNetworkGatewayConnectionProtocol = "IKEv1"
	VirtualNetworkGatewayConnectionProtocolIKEv2 VirtualNetworkGatewayConnectionProtocol = "IKEv2"
)

// PossibleVirtualNetworkGatewayConnectionProtocolValues returns the possible values for the VirtualNetworkGatewayConnectionProtocol const type.
func PossibleVirtualNetworkGatewayConnectionProtocolValues() []VirtualNetworkGatewayConnectionProtocol {
	return []VirtualNetworkGatewayConnectionProtocol{
		VirtualNetworkGatewayConnectionProtocolIKEv1,
		VirtualNetworkGatewayConnectionProtocolIKEv2,
	}
}

// VirtualNetworkGatewayConnectionStatus - Virtual network Gateway connection status
type VirtualNetworkGatewayConnectionStatus string

const (
	VirtualNetworkGatewayConnectionStatusConnected    VirtualNetworkGatewayConnectionStatus = "Connected"
	VirtualNetworkGatewayConnectionStatusConnecting   VirtualNetworkGatewayConnectionStatus = "Connecting"
	VirtualNetworkGatewayConnectionStatusNotConnected VirtualNetworkGatewayConnectionStatus = "NotConnected"
	VirtualNetworkGatewayConnectionStatusUnknown      VirtualNetworkGatewayConnectionStatus = "Unknown"
)

// PossibleVirtualNetworkGatewayConnectionStatusValues returns the possible values for the VirtualNetworkGatewayConnectionStatus const type.
func PossibleVirtualNetworkGatewayConnectionStatusValues() []VirtualNetworkGatewayConnectionStatus {
	return []VirtualNetworkGatewayConnectionStatus{
		VirtualNetworkGatewayConnectionStatusConnected,
		VirtualNetworkGatewayConnectionStatusConnecting,
		VirtualNetworkGatewayConnectionStatusNotConnected,
		VirtualNetworkGatewayConnectionStatusUnknown,
	}
}

// VirtualNetworkGatewayConnectionType - Gateway connection type. Possible values are: 'Ipsec','Vnet2Vnet','ExpressRoute',
// and 'VPNClient.
type VirtualNetworkGatewayConnectionType string

const (
	VirtualNetworkGatewayConnectionTypeExpressRoute VirtualNetworkGatewayConnectionType = "ExpressRoute"
	VirtualNetworkGatewayConnectionTypeIPsec        VirtualNetworkGatewayConnectionType = "IPsec"
	VirtualNetworkGatewayConnectionTypeVPNClient    VirtualNetworkGatewayConnectionType = "VPNClient"
	VirtualNetworkGatewayConnectionTypeVnet2Vnet    VirtualNetworkGatewayConnectionType = "Vnet2Vnet"
)

// PossibleVirtualNetworkGatewayConnectionTypeValues returns the possible values for the VirtualNetworkGatewayConnectionType const type.
func PossibleVirtualNetworkGatewayConnectionTypeValues() []VirtualNetworkGatewayConnectionType {
	return []VirtualNetworkGatewayConnectionType{
		VirtualNetworkGatewayConnectionTypeExpressRoute,
		VirtualNetworkGatewayConnectionTypeIPsec,
		VirtualNetworkGatewayConnectionTypeVPNClient,
		VirtualNetworkGatewayConnectionTypeVnet2Vnet,
	}
}

// VirtualNetworkGatewaySKUName - Gateway SKU name.
type VirtualNetworkGatewaySKUName string

const (
	VirtualNetworkGatewaySKUNameBasic            VirtualNetworkGatewaySKUName = "Basic"
	VirtualNetworkGatewaySKUNameErGw1AZ          VirtualNetworkGatewaySKUName = "ErGw1AZ"
	VirtualNetworkGatewaySKUNameErGw2AZ          VirtualNetworkGatewaySKUName = "ErGw2AZ"
	VirtualNetworkGatewaySKUNameErGw3AZ          VirtualNetworkGatewaySKUName = "ErGw3AZ"
	VirtualNetworkGatewaySKUNameHighPerformance  VirtualNetworkGatewaySKUName = "HighPerformance"
	VirtualNetworkGatewaySKUNameStandard         VirtualNetworkGatewaySKUName = "Standard"
	VirtualNetworkGatewaySKUNameUltraPerformance VirtualNetworkGatewaySKUName = "UltraPerformance"
	VirtualNetworkGatewaySKUNameVPNGw1           VirtualNetworkGatewaySKUName = "VpnGw1"
	VirtualNetworkGatewaySKUNameVPNGw1AZ         VirtualNetworkGatewaySKUName = "VpnGw1AZ"
	VirtualNetworkGatewaySKUNameVPNGw2           VirtualNetworkGatewaySKUName = "VpnGw2"
	VirtualNetworkGatewaySKUNameVPNGw2AZ         VirtualNetworkGatewaySKUName = "VpnGw2AZ"
	VirtualNetworkGatewaySKUNameVPNGw3           VirtualNetworkGatewaySKUName = "VpnGw3"
	VirtualNetworkGatewaySKUNameVPNGw3AZ         VirtualNetworkGatewaySKUName = "VpnGw3AZ"
)

// PossibleVirtualNetworkGatewaySKUNameValues returns the possible values for the VirtualNetworkGatewaySKUName const type.
func PossibleVirtualNetworkGatewaySKUNameValues() []VirtualNetworkGatewaySKUName {
	return []VirtualNetworkGatewaySKUName{
		VirtualNetworkGatewaySKUNameBasic,
		VirtualNetworkGatewaySKUNameErGw1AZ,
		VirtualNetworkGatewaySKUNameErGw2AZ,
		VirtualNetworkGatewaySKUNameErGw3AZ,
		VirtualNetworkGatewaySKUNameHighPerformance,
		VirtualNetworkGatewaySKUNameStandard,
		VirtualNetworkGatewaySKUNameUltraPerformance,
		VirtualNetworkGatewaySKUNameVPNGw1,
		VirtualNetworkGatewaySKUNameVPNGw1AZ,
		VirtualNetworkGatewaySKUNameVPNGw2,
		VirtualNetworkGatewaySKUNameVPNGw2AZ,
		VirtualNetworkGatewaySKUNameVPNGw3,
		VirtualNetworkGatewaySKUNameVPNGw3AZ,
	}
}

// VirtualNetworkGatewaySKUTier - Gateway SKU tier.
type VirtualNetworkGatewaySKUTier string

const (
	VirtualNetworkGatewaySKUTierBasic            VirtualNetworkGatewaySKUTier = "Basic"
	VirtualNetworkGatewaySKUTierErGw1AZ          VirtualNetworkGatewaySKUTier = "ErGw1AZ"
	VirtualNetworkGatewaySKUTierErGw2AZ          VirtualNetworkGatewaySKUTier = "ErGw2AZ"
	VirtualNetworkGatewaySKUTierErGw3AZ          VirtualNetworkGatewaySKUTier = "ErGw3AZ"
	VirtualNetworkGatewaySKUTierHighPerformance  VirtualNetworkGatewaySKUTier = "HighPerformance"
	VirtualNetworkGatewaySKUTierStandard         VirtualNetworkGatewaySKUTier = "Standard"
	VirtualNetworkGatewaySKUTierUltraPerformance VirtualNetworkGatewaySKUTier = "UltraPerformance"
	VirtualNetworkGatewaySKUTierVPNGw1           VirtualNetworkGatewaySKUTier = "VpnGw1"
	VirtualNetworkGatewaySKUTierVPNGw1AZ         VirtualNetworkGatewaySKUTier = "VpnGw1AZ"
	VirtualNetworkGatewaySKUTierVPNGw2           VirtualNetworkGatewaySKUTier = "VpnGw2"
	VirtualNetworkGatewaySKUTierVPNGw2AZ         VirtualNetworkGatewaySKUTier = "VpnGw2AZ"
	VirtualNetworkGatewaySKUTierVPNGw3           VirtualNetworkGatewaySKUTier = "VpnGw3"
	VirtualNetworkGatewaySKUTierVPNGw3AZ         VirtualNetworkGatewaySKUTier = "VpnGw3AZ"
)

// PossibleVirtualNetworkGatewaySKUTierValues returns the possible values for the VirtualNetworkGatewaySKUTier const type.
func PossibleVirtualNetworkGatewaySKUTierValues() []VirtualNetworkGatewaySKUTier {
	return []VirtualNetworkGatewaySKUTier{
		VirtualNetworkGatewaySKUTierBasic,
		VirtualNetworkGatewaySKUTierErGw1AZ,
		VirtualNetworkGatewaySKUTierErGw2AZ,
		VirtualNetworkGatewaySKUTierErGw3AZ,
		VirtualNetworkGatewaySKUTierHighPerformance,
		VirtualNetworkGatewaySKUTierStandard,
		VirtualNetworkGatewaySKUTierUltraPerformance,
		VirtualNetworkGatewaySKUTierVPNGw1,
		VirtualNetworkGatewaySKUTierVPNGw1AZ,
		VirtualNetworkGatewaySKUTierVPNGw2,
		VirtualNetworkGatewaySKUTierVPNGw2AZ,
		VirtualNetworkGatewaySKUTierVPNGw3,
		VirtualNetworkGatewaySKUTierVPNGw3AZ,
	}
}

// VirtualNetworkGatewayType - The type of this virtual network gateway. Possible values are: 'Vpn' and 'ExpressRoute'.
type VirtualNetworkGatewayType string

const (
	VirtualNetworkGatewayTypeExpressRoute VirtualNetworkGatewayType = "ExpressRoute"
	VirtualNetworkGatewayTypeVPN          VirtualNetworkGatewayType = "Vpn"
)

// PossibleVirtualNetworkGatewayTypeValues returns the possible values for the VirtualNetworkGatewayType const type.
func PossibleVirtualNetworkGatewayTypeValues() []VirtualNetworkGatewayType {
	return []VirtualNetworkGatewayType{
		VirtualNetworkGatewayTypeExpressRoute,
		VirtualNetworkGatewayTypeVPN,
	}
}

// VirtualNetworkPeeringState - The status of the virtual network peering. Possible values are 'Initiated', 'Connected', and
// 'Disconnected'.
type VirtualNetworkPeeringState string

const (
	VirtualNetworkPeeringStateConnected    VirtualNetworkPeeringState = "Connected"
	VirtualNetworkPeeringStateDisconnected VirtualNetworkPeeringState = "Disconnected"
	VirtualNetworkPeeringStateInitiated    VirtualNetworkPeeringState = "Initiated"
)

// PossibleVirtualNetworkPeeringStateValues returns the possible values for the VirtualNetworkPeeringState const type.
func PossibleVirtualNetworkPeeringStateValues() []VirtualNetworkPeeringState {
	return []VirtualNetworkPeeringState{
		VirtualNetworkPeeringStateConnected,
		VirtualNetworkPeeringStateDisconnected,
		VirtualNetworkPeeringStateInitiated,
	}
}
