//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmachinelearning_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/machinelearning/armmachinelearning/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/OnlineDeployment/list.json
func ExampleOnlineDeploymentsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOnlineDeploymentsClient().NewListPager("test-rg", "my-aml-workspace", "testEndpointName", &armmachinelearning.OnlineDeploymentsClientListOptions{OrderBy: to.Ptr("string"),
		Top:  to.Ptr[int32](1),
		Skip: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OnlineDeploymentTrackedResourceArmPaginatedResult = armmachinelearning.OnlineDeploymentTrackedResourceArmPaginatedResult{
		// 	Value: []*armmachinelearning.OnlineDeployment{
		// 		{
		// 			Name: to.Ptr("string"),
		// 			Type: to.Ptr("string"),
		// 			ID: to.Ptr("string"),
		// 			SystemData: &armmachinelearning.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("string"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Identity: &armmachinelearning.ManagedServiceIdentity{
		// 				Type: to.Ptr(armmachinelearning.ManagedServiceIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
		// 				TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
		// 				UserAssignedIdentities: map[string]*armmachinelearning.UserAssignedIdentity{
		// 					"string": &armmachinelearning.UserAssignedIdentity{
		// 						ClientID: to.Ptr("00000000-1111-2222-3333-444444444444"),
		// 						PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
		// 					},
		// 				},
		// 			},
		// 			Kind: to.Ptr("string"),
		// 			Properties: &armmachinelearning.KubernetesOnlineDeployment{
		// 				Description: to.Ptr("string"),
		// 				CodeConfiguration: &armmachinelearning.CodeConfiguration{
		// 					CodeID: to.Ptr("string"),
		// 					ScoringScript: to.Ptr("string"),
		// 				},
		// 				EnvironmentID: to.Ptr("string"),
		// 				EnvironmentVariables: map[string]*string{
		// 					"string": to.Ptr("string"),
		// 				},
		// 				Properties: map[string]*string{
		// 					"string": to.Ptr("string"),
		// 				},
		// 				AppInsightsEnabled: to.Ptr(false),
		// 				EndpointComputeType: to.Ptr(armmachinelearning.EndpointComputeTypeKubernetes),
		// 				InstanceType: to.Ptr("string"),
		// 				LivenessProbe: &armmachinelearning.ProbeSettings{
		// 					FailureThreshold: to.Ptr[int32](1),
		// 					InitialDelay: to.Ptr("PT5M"),
		// 					Period: to.Ptr("PT5M"),
		// 					SuccessThreshold: to.Ptr[int32](1),
		// 					Timeout: to.Ptr("PT5M"),
		// 				},
		// 				Model: to.Ptr("string"),
		// 				ModelMountPath: to.Ptr("string"),
		// 				ProvisioningState: to.Ptr(armmachinelearning.DeploymentProvisioningStateSucceeded),
		// 				RequestSettings: &armmachinelearning.OnlineRequestSettings{
		// 					MaxConcurrentRequestsPerInstance: to.Ptr[int32](1),
		// 					MaxQueueWait: to.Ptr("PT5M"),
		// 					RequestTimeout: to.Ptr("PT5M"),
		// 				},
		// 				ScaleSettings: &armmachinelearning.DefaultScaleSettings{
		// 					ScaleType: to.Ptr(armmachinelearning.ScaleTypeDefault),
		// 				},
		// 				ContainerResourceRequirements: &armmachinelearning.ContainerResourceRequirements{
		// 					ContainerResourceLimits: &armmachinelearning.ContainerResourceSettings{
		// 						CPU: to.Ptr("\"1\""),
		// 						Gpu: to.Ptr("\"1\""),
		// 						Memory: to.Ptr("\"2Gi\""),
		// 					},
		// 					ContainerResourceRequests: &armmachinelearning.ContainerResourceSettings{
		// 						CPU: to.Ptr("\"1\""),
		// 						Gpu: to.Ptr("\"1\""),
		// 						Memory: to.Ptr("\"2Gi\""),
		// 					},
		// 				},
		// 			},
		// 			SKU: &armmachinelearning.SKU{
		// 				Name: to.Ptr("string"),
		// 				Capacity: to.Ptr[int32](1),
		// 				Family: to.Ptr("string"),
		// 				Size: to.Ptr("string"),
		// 				Tier: to.Ptr(armmachinelearning.SKUTierFree),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/OnlineDeployment/delete.json
func ExampleOnlineDeploymentsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewOnlineDeploymentsClient().BeginDelete(ctx, "testrg123", "workspace123", "testEndpoint", "testDeployment", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/OnlineDeployment/KubernetesOnlineDeployment/get.json
func ExampleOnlineDeploymentsClient_Get_getKubernetesOnlineDeployment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOnlineDeploymentsClient().Get(ctx, "test-rg", "my-aml-workspace", "testEndpointName", "testDeploymentName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OnlineDeployment = armmachinelearning.OnlineDeployment{
	// 	Name: to.Ptr("string"),
	// 	Type: to.Ptr("string"),
	// 	ID: to.Ptr("string"),
	// 	SystemData: &armmachinelearning.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("string"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armmachinelearning.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmachinelearning.ManagedServiceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		UserAssignedIdentities: map[string]*armmachinelearning.UserAssignedIdentity{
	// 			"string": &armmachinelearning.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 				PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr("string"),
	// 	Properties: &armmachinelearning.KubernetesOnlineDeployment{
	// 		Description: to.Ptr("string"),
	// 		CodeConfiguration: &armmachinelearning.CodeConfiguration{
	// 			CodeID: to.Ptr("string"),
	// 			ScoringScript: to.Ptr("string"),
	// 		},
	// 		EnvironmentID: to.Ptr("string"),
	// 		EnvironmentVariables: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		Properties: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		AppInsightsEnabled: to.Ptr(false),
	// 		EndpointComputeType: to.Ptr(armmachinelearning.EndpointComputeTypeKubernetes),
	// 		InstanceType: to.Ptr("string"),
	// 		LivenessProbe: &armmachinelearning.ProbeSettings{
	// 			FailureThreshold: to.Ptr[int32](1),
	// 			InitialDelay: to.Ptr("PT5M"),
	// 			Period: to.Ptr("PT5M"),
	// 			SuccessThreshold: to.Ptr[int32](1),
	// 			Timeout: to.Ptr("PT5M"),
	// 		},
	// 		Model: to.Ptr("string"),
	// 		ModelMountPath: to.Ptr("string"),
	// 		ProvisioningState: to.Ptr(armmachinelearning.DeploymentProvisioningStateSucceeded),
	// 		RequestSettings: &armmachinelearning.OnlineRequestSettings{
	// 			MaxConcurrentRequestsPerInstance: to.Ptr[int32](1),
	// 			MaxQueueWait: to.Ptr("PT5M"),
	// 			RequestTimeout: to.Ptr("PT5M"),
	// 		},
	// 		ScaleSettings: &armmachinelearning.DefaultScaleSettings{
	// 			ScaleType: to.Ptr(armmachinelearning.ScaleTypeDefault),
	// 		},
	// 		ContainerResourceRequirements: &armmachinelearning.ContainerResourceRequirements{
	// 			ContainerResourceLimits: &armmachinelearning.ContainerResourceSettings{
	// 				CPU: to.Ptr("\"1\""),
	// 				Gpu: to.Ptr("\"1\""),
	// 				Memory: to.Ptr("\"2Gi\""),
	// 			},
	// 			ContainerResourceRequests: &armmachinelearning.ContainerResourceSettings{
	// 				CPU: to.Ptr("\"1\""),
	// 				Gpu: to.Ptr("\"1\""),
	// 				Memory: to.Ptr("\"2Gi\""),
	// 			},
	// 		},
	// 	},
	// 	SKU: &armmachinelearning.SKU{
	// 		Name: to.Ptr("string"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Family: to.Ptr("string"),
	// 		Size: to.Ptr("string"),
	// 		Tier: to.Ptr(armmachinelearning.SKUTierFree),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/OnlineDeployment/ManagedOnlineDeployment/get.json
func ExampleOnlineDeploymentsClient_Get_getManagedOnlineDeployment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOnlineDeploymentsClient().Get(ctx, "test-rg", "my-aml-workspace", "testEndpointName", "testDeploymentName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OnlineDeployment = armmachinelearning.OnlineDeployment{
	// 	Name: to.Ptr("string"),
	// 	Type: to.Ptr("string"),
	// 	ID: to.Ptr("string"),
	// 	SystemData: &armmachinelearning.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("string"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armmachinelearning.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmachinelearning.ManagedServiceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		UserAssignedIdentities: map[string]*armmachinelearning.UserAssignedIdentity{
	// 			"string": &armmachinelearning.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 				PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr("string"),
	// 	Properties: &armmachinelearning.ManagedOnlineDeployment{
	// 		Description: to.Ptr("string"),
	// 		CodeConfiguration: &armmachinelearning.CodeConfiguration{
	// 			CodeID: to.Ptr("string"),
	// 			ScoringScript: to.Ptr("string"),
	// 		},
	// 		EnvironmentID: to.Ptr("string"),
	// 		EnvironmentVariables: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		Properties: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		AppInsightsEnabled: to.Ptr(false),
	// 		EndpointComputeType: to.Ptr(armmachinelearning.EndpointComputeTypeManaged),
	// 		InstanceType: to.Ptr("string"),
	// 		LivenessProbe: &armmachinelearning.ProbeSettings{
	// 			FailureThreshold: to.Ptr[int32](1),
	// 			InitialDelay: to.Ptr("PT5M"),
	// 			Period: to.Ptr("PT5M"),
	// 			SuccessThreshold: to.Ptr[int32](1),
	// 			Timeout: to.Ptr("PT5M"),
	// 		},
	// 		Model: to.Ptr("string"),
	// 		ModelMountPath: to.Ptr("string"),
	// 		ProvisioningState: to.Ptr(armmachinelearning.DeploymentProvisioningStateSucceeded),
	// 		ReadinessProbe: &armmachinelearning.ProbeSettings{
	// 			FailureThreshold: to.Ptr[int32](30),
	// 			InitialDelay: to.Ptr("PT1S"),
	// 			Period: to.Ptr("PT10S"),
	// 			SuccessThreshold: to.Ptr[int32](1),
	// 			Timeout: to.Ptr("PT2S"),
	// 		},
	// 		RequestSettings: &armmachinelearning.OnlineRequestSettings{
	// 			MaxConcurrentRequestsPerInstance: to.Ptr[int32](1),
	// 			MaxQueueWait: to.Ptr("PT5M"),
	// 			RequestTimeout: to.Ptr("PT5M"),
	// 		},
	// 		ScaleSettings: &armmachinelearning.DefaultScaleSettings{
	// 			ScaleType: to.Ptr(armmachinelearning.ScaleTypeDefault),
	// 		},
	// 	},
	// 	SKU: &armmachinelearning.SKU{
	// 		Name: to.Ptr("string"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Family: to.Ptr("string"),
	// 		Size: to.Ptr("string"),
	// 		Tier: to.Ptr(armmachinelearning.SKUTierFree),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/OnlineDeployment/KubernetesOnlineDeployment/update.json
func ExampleOnlineDeploymentsClient_BeginUpdate_updateKubernetesOnlineDeployment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewOnlineDeploymentsClient().BeginUpdate(ctx, "test-rg", "my-aml-workspace", "testEndpointName", "testDeploymentName", armmachinelearning.PartialMinimalTrackedResourceWithSKU{
		Tags: map[string]*string{},
		SKU: &armmachinelearning.PartialSKU{
			Name:     to.Ptr("string"),
			Capacity: to.Ptr[int32](1),
			Family:   to.Ptr("string"),
			Size:     to.Ptr("string"),
			Tier:     to.Ptr(armmachinelearning.SKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OnlineDeployment = armmachinelearning.OnlineDeployment{
	// 	Name: to.Ptr("string"),
	// 	Type: to.Ptr("string"),
	// 	ID: to.Ptr("string"),
	// 	SystemData: &armmachinelearning.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("string"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armmachinelearning.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmachinelearning.ManagedServiceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		UserAssignedIdentities: map[string]*armmachinelearning.UserAssignedIdentity{
	// 			"string": &armmachinelearning.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 				PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr("string"),
	// 	Properties: &armmachinelearning.KubernetesOnlineDeployment{
	// 		Description: to.Ptr("string"),
	// 		CodeConfiguration: &armmachinelearning.CodeConfiguration{
	// 			CodeID: to.Ptr("string"),
	// 			ScoringScript: to.Ptr("string"),
	// 		},
	// 		EnvironmentID: to.Ptr("string"),
	// 		EnvironmentVariables: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		Properties: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		AppInsightsEnabled: to.Ptr(false),
	// 		EndpointComputeType: to.Ptr(armmachinelearning.EndpointComputeTypeKubernetes),
	// 		InstanceType: to.Ptr("string"),
	// 		LivenessProbe: &armmachinelearning.ProbeSettings{
	// 			FailureThreshold: to.Ptr[int32](1),
	// 			InitialDelay: to.Ptr("PT5M"),
	// 			Period: to.Ptr("PT5M"),
	// 			SuccessThreshold: to.Ptr[int32](1),
	// 			Timeout: to.Ptr("PT5M"),
	// 		},
	// 		Model: to.Ptr("string"),
	// 		ModelMountPath: to.Ptr("string"),
	// 		ProvisioningState: to.Ptr(armmachinelearning.DeploymentProvisioningStateSucceeded),
	// 		RequestSettings: &armmachinelearning.OnlineRequestSettings{
	// 			MaxConcurrentRequestsPerInstance: to.Ptr[int32](1),
	// 			MaxQueueWait: to.Ptr("PT5M"),
	// 			RequestTimeout: to.Ptr("PT5M"),
	// 		},
	// 		ScaleSettings: &armmachinelearning.DefaultScaleSettings{
	// 			ScaleType: to.Ptr(armmachinelearning.ScaleTypeDefault),
	// 		},
	// 		ContainerResourceRequirements: &armmachinelearning.ContainerResourceRequirements{
	// 			ContainerResourceLimits: &armmachinelearning.ContainerResourceSettings{
	// 				CPU: to.Ptr("\"1\""),
	// 				Gpu: to.Ptr("\"1\""),
	// 				Memory: to.Ptr("\"2Gi\""),
	// 			},
	// 			ContainerResourceRequests: &armmachinelearning.ContainerResourceSettings{
	// 				CPU: to.Ptr("\"1\""),
	// 				Gpu: to.Ptr("\"1\""),
	// 				Memory: to.Ptr("\"2Gi\""),
	// 			},
	// 		},
	// 	},
	// 	SKU: &armmachinelearning.SKU{
	// 		Name: to.Ptr("string"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Family: to.Ptr("string"),
	// 		Size: to.Ptr("string"),
	// 		Tier: to.Ptr(armmachinelearning.SKUTierFree),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/OnlineDeployment/ManagedOnlineDeployment/update.json
func ExampleOnlineDeploymentsClient_BeginUpdate_updateManagedOnlineDeployment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewOnlineDeploymentsClient().BeginUpdate(ctx, "test-rg", "my-aml-workspace", "testEndpointName", "testDeploymentName", armmachinelearning.PartialMinimalTrackedResourceWithSKU{
		Tags: map[string]*string{},
		SKU: &armmachinelearning.PartialSKU{
			Name:     to.Ptr("string"),
			Capacity: to.Ptr[int32](1),
			Family:   to.Ptr("string"),
			Size:     to.Ptr("string"),
			Tier:     to.Ptr(armmachinelearning.SKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OnlineDeployment = armmachinelearning.OnlineDeployment{
	// 	Name: to.Ptr("string"),
	// 	Type: to.Ptr("string"),
	// 	ID: to.Ptr("string"),
	// 	SystemData: &armmachinelearning.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("string"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armmachinelearning.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmachinelearning.ManagedServiceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		UserAssignedIdentities: map[string]*armmachinelearning.UserAssignedIdentity{
	// 			"string": &armmachinelearning.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 				PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr("string"),
	// 	Properties: &armmachinelearning.ManagedOnlineDeployment{
	// 		Description: to.Ptr("string"),
	// 		CodeConfiguration: &armmachinelearning.CodeConfiguration{
	// 			CodeID: to.Ptr("string"),
	// 			ScoringScript: to.Ptr("string"),
	// 		},
	// 		EnvironmentID: to.Ptr("string"),
	// 		EnvironmentVariables: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		Properties: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		AppInsightsEnabled: to.Ptr(false),
	// 		EndpointComputeType: to.Ptr(armmachinelearning.EndpointComputeTypeManaged),
	// 		InstanceType: to.Ptr("string"),
	// 		LivenessProbe: &armmachinelearning.ProbeSettings{
	// 			FailureThreshold: to.Ptr[int32](1),
	// 			InitialDelay: to.Ptr("PT5M"),
	// 			Period: to.Ptr("PT5M"),
	// 			SuccessThreshold: to.Ptr[int32](1),
	// 			Timeout: to.Ptr("PT5M"),
	// 		},
	// 		Model: to.Ptr("string"),
	// 		ModelMountPath: to.Ptr("string"),
	// 		ProvisioningState: to.Ptr(armmachinelearning.DeploymentProvisioningStateSucceeded),
	// 		ReadinessProbe: &armmachinelearning.ProbeSettings{
	// 			FailureThreshold: to.Ptr[int32](30),
	// 			InitialDelay: to.Ptr("PT1S"),
	// 			Period: to.Ptr("PT10S"),
	// 			SuccessThreshold: to.Ptr[int32](1),
	// 			Timeout: to.Ptr("PT2S"),
	// 		},
	// 		RequestSettings: &armmachinelearning.OnlineRequestSettings{
	// 			MaxConcurrentRequestsPerInstance: to.Ptr[int32](1),
	// 			MaxQueueWait: to.Ptr("PT5M"),
	// 			RequestTimeout: to.Ptr("PT5M"),
	// 		},
	// 		ScaleSettings: &armmachinelearning.DefaultScaleSettings{
	// 			ScaleType: to.Ptr(armmachinelearning.ScaleTypeDefault),
	// 		},
	// 	},
	// 	SKU: &armmachinelearning.SKU{
	// 		Name: to.Ptr("string"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Family: to.Ptr("string"),
	// 		Size: to.Ptr("string"),
	// 		Tier: to.Ptr(armmachinelearning.SKUTierFree),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/OnlineDeployment/KubernetesOnlineDeployment/createOrUpdate.json
func ExampleOnlineDeploymentsClient_BeginCreateOrUpdate_createOrUpdateKubernetesOnlineDeployment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewOnlineDeploymentsClient().BeginCreateOrUpdate(ctx, "test-rg", "my-aml-workspace", "testEndpointName", "testDeploymentName", armmachinelearning.OnlineDeployment{
		Location: to.Ptr("string"),
		Tags:     map[string]*string{},
		Identity: &armmachinelearning.ManagedServiceIdentity{
			Type: to.Ptr(armmachinelearning.ManagedServiceIdentityTypeSystemAssigned),
			UserAssignedIdentities: map[string]*armmachinelearning.UserAssignedIdentity{
				"string": {},
			},
		},
		Kind: to.Ptr("string"),
		Properties: &armmachinelearning.KubernetesOnlineDeployment{
			Description: to.Ptr("string"),
			CodeConfiguration: &armmachinelearning.CodeConfiguration{
				CodeID:        to.Ptr("string"),
				ScoringScript: to.Ptr("string"),
			},
			EnvironmentID: to.Ptr("string"),
			EnvironmentVariables: map[string]*string{
				"string": to.Ptr("string"),
			},
			Properties: map[string]*string{
				"string": to.Ptr("string"),
			},
			AppInsightsEnabled:  to.Ptr(false),
			EndpointComputeType: to.Ptr(armmachinelearning.EndpointComputeTypeKubernetes),
			InstanceType:        to.Ptr("string"),
			LivenessProbe: &armmachinelearning.ProbeSettings{
				FailureThreshold: to.Ptr[int32](1),
				InitialDelay:     to.Ptr("PT5M"),
				Period:           to.Ptr("PT5M"),
				SuccessThreshold: to.Ptr[int32](1),
				Timeout:          to.Ptr("PT5M"),
			},
			Model:          to.Ptr("string"),
			ModelMountPath: to.Ptr("string"),
			RequestSettings: &armmachinelearning.OnlineRequestSettings{
				MaxConcurrentRequestsPerInstance: to.Ptr[int32](1),
				MaxQueueWait:                     to.Ptr("PT5M"),
				RequestTimeout:                   to.Ptr("PT5M"),
			},
			ScaleSettings: &armmachinelearning.DefaultScaleSettings{
				ScaleType: to.Ptr(armmachinelearning.ScaleTypeDefault),
			},
			ContainerResourceRequirements: &armmachinelearning.ContainerResourceRequirements{
				ContainerResourceLimits: &armmachinelearning.ContainerResourceSettings{
					CPU:    to.Ptr("\"1\""),
					Gpu:    to.Ptr("\"1\""),
					Memory: to.Ptr("\"2Gi\""),
				},
				ContainerResourceRequests: &armmachinelearning.ContainerResourceSettings{
					CPU:    to.Ptr("\"1\""),
					Gpu:    to.Ptr("\"1\""),
					Memory: to.Ptr("\"2Gi\""),
				},
			},
		},
		SKU: &armmachinelearning.SKU{
			Name:     to.Ptr("string"),
			Capacity: to.Ptr[int32](1),
			Family:   to.Ptr("string"),
			Size:     to.Ptr("string"),
			Tier:     to.Ptr(armmachinelearning.SKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OnlineDeployment = armmachinelearning.OnlineDeployment{
	// 	Name: to.Ptr("string"),
	// 	Type: to.Ptr("string"),
	// 	ID: to.Ptr("string"),
	// 	SystemData: &armmachinelearning.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("string"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armmachinelearning.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmachinelearning.ManagedServiceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		UserAssignedIdentities: map[string]*armmachinelearning.UserAssignedIdentity{
	// 			"string": &armmachinelearning.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 				PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr("string"),
	// 	Properties: &armmachinelearning.KubernetesOnlineDeployment{
	// 		Description: to.Ptr("string"),
	// 		CodeConfiguration: &armmachinelearning.CodeConfiguration{
	// 			CodeID: to.Ptr("string"),
	// 			ScoringScript: to.Ptr("string"),
	// 		},
	// 		EnvironmentID: to.Ptr("string"),
	// 		EnvironmentVariables: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		Properties: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		AppInsightsEnabled: to.Ptr(false),
	// 		EndpointComputeType: to.Ptr(armmachinelearning.EndpointComputeTypeKubernetes),
	// 		InstanceType: to.Ptr("string"),
	// 		LivenessProbe: &armmachinelearning.ProbeSettings{
	// 			FailureThreshold: to.Ptr[int32](1),
	// 			InitialDelay: to.Ptr("PT5M"),
	// 			Period: to.Ptr("PT5M"),
	// 			SuccessThreshold: to.Ptr[int32](1),
	// 			Timeout: to.Ptr("PT5M"),
	// 		},
	// 		Model: to.Ptr("string"),
	// 		ModelMountPath: to.Ptr("string"),
	// 		ProvisioningState: to.Ptr(armmachinelearning.DeploymentProvisioningStateSucceeded),
	// 		RequestSettings: &armmachinelearning.OnlineRequestSettings{
	// 			MaxConcurrentRequestsPerInstance: to.Ptr[int32](1),
	// 			MaxQueueWait: to.Ptr("PT5M"),
	// 			RequestTimeout: to.Ptr("PT5M"),
	// 		},
	// 		ScaleSettings: &armmachinelearning.DefaultScaleSettings{
	// 			ScaleType: to.Ptr(armmachinelearning.ScaleTypeDefault),
	// 		},
	// 		ContainerResourceRequirements: &armmachinelearning.ContainerResourceRequirements{
	// 			ContainerResourceLimits: &armmachinelearning.ContainerResourceSettings{
	// 				CPU: to.Ptr("\"1\""),
	// 				Gpu: to.Ptr("\"1\""),
	// 				Memory: to.Ptr("\"2Gi\""),
	// 			},
	// 			ContainerResourceRequests: &armmachinelearning.ContainerResourceSettings{
	// 				CPU: to.Ptr("\"1\""),
	// 				Gpu: to.Ptr("\"1\""),
	// 				Memory: to.Ptr("\"2Gi\""),
	// 			},
	// 		},
	// 	},
	// 	SKU: &armmachinelearning.SKU{
	// 		Name: to.Ptr("string"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Family: to.Ptr("string"),
	// 		Size: to.Ptr("string"),
	// 		Tier: to.Ptr(armmachinelearning.SKUTierFree),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/OnlineDeployment/ManagedOnlineDeployment/createOrUpdate.json
func ExampleOnlineDeploymentsClient_BeginCreateOrUpdate_createOrUpdateManagedOnlineDeployment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewOnlineDeploymentsClient().BeginCreateOrUpdate(ctx, "test-rg", "my-aml-workspace", "testEndpointName", "testDeploymentName", armmachinelearning.OnlineDeployment{
		Location: to.Ptr("string"),
		Tags:     map[string]*string{},
		Identity: &armmachinelearning.ManagedServiceIdentity{
			Type: to.Ptr(armmachinelearning.ManagedServiceIdentityTypeSystemAssigned),
			UserAssignedIdentities: map[string]*armmachinelearning.UserAssignedIdentity{
				"string": {},
			},
		},
		Kind: to.Ptr("string"),
		Properties: &armmachinelearning.ManagedOnlineDeployment{
			Description: to.Ptr("string"),
			CodeConfiguration: &armmachinelearning.CodeConfiguration{
				CodeID:        to.Ptr("string"),
				ScoringScript: to.Ptr("string"),
			},
			EnvironmentID: to.Ptr("string"),
			EnvironmentVariables: map[string]*string{
				"string": to.Ptr("string"),
			},
			Properties: map[string]*string{
				"string": to.Ptr("string"),
			},
			AppInsightsEnabled:  to.Ptr(false),
			EndpointComputeType: to.Ptr(armmachinelearning.EndpointComputeTypeManaged),
			InstanceType:        to.Ptr("string"),
			LivenessProbe: &armmachinelearning.ProbeSettings{
				FailureThreshold: to.Ptr[int32](1),
				InitialDelay:     to.Ptr("PT5M"),
				Period:           to.Ptr("PT5M"),
				SuccessThreshold: to.Ptr[int32](1),
				Timeout:          to.Ptr("PT5M"),
			},
			Model:          to.Ptr("string"),
			ModelMountPath: to.Ptr("string"),
			ReadinessProbe: &armmachinelearning.ProbeSettings{
				FailureThreshold: to.Ptr[int32](30),
				InitialDelay:     to.Ptr("PT1S"),
				Period:           to.Ptr("PT10S"),
				SuccessThreshold: to.Ptr[int32](1),
				Timeout:          to.Ptr("PT2S"),
			},
			RequestSettings: &armmachinelearning.OnlineRequestSettings{
				MaxConcurrentRequestsPerInstance: to.Ptr[int32](1),
				MaxQueueWait:                     to.Ptr("PT5M"),
				RequestTimeout:                   to.Ptr("PT5M"),
			},
			ScaleSettings: &armmachinelearning.DefaultScaleSettings{
				ScaleType: to.Ptr(armmachinelearning.ScaleTypeDefault),
			},
		},
		SKU: &armmachinelearning.SKU{
			Name:     to.Ptr("string"),
			Capacity: to.Ptr[int32](1),
			Family:   to.Ptr("string"),
			Size:     to.Ptr("string"),
			Tier:     to.Ptr(armmachinelearning.SKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OnlineDeployment = armmachinelearning.OnlineDeployment{
	// 	Name: to.Ptr("string"),
	// 	Type: to.Ptr("string"),
	// 	ID: to.Ptr("string"),
	// 	SystemData: &armmachinelearning.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("string"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armmachinelearning.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmachinelearning.ManagedServiceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		UserAssignedIdentities: map[string]*armmachinelearning.UserAssignedIdentity{
	// 			"string": &armmachinelearning.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 				PrincipalID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr("string"),
	// 	Properties: &armmachinelearning.ManagedOnlineDeployment{
	// 		Description: to.Ptr("string"),
	// 		CodeConfiguration: &armmachinelearning.CodeConfiguration{
	// 			CodeID: to.Ptr("string"),
	// 			ScoringScript: to.Ptr("string"),
	// 		},
	// 		EnvironmentID: to.Ptr("string"),
	// 		EnvironmentVariables: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		Properties: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		AppInsightsEnabled: to.Ptr(false),
	// 		EndpointComputeType: to.Ptr(armmachinelearning.EndpointComputeTypeManaged),
	// 		InstanceType: to.Ptr("string"),
	// 		LivenessProbe: &armmachinelearning.ProbeSettings{
	// 			FailureThreshold: to.Ptr[int32](1),
	// 			InitialDelay: to.Ptr("PT5M"),
	// 			Period: to.Ptr("PT5M"),
	// 			SuccessThreshold: to.Ptr[int32](1),
	// 			Timeout: to.Ptr("PT5M"),
	// 		},
	// 		Model: to.Ptr("string"),
	// 		ModelMountPath: to.Ptr("string"),
	// 		ProvisioningState: to.Ptr(armmachinelearning.DeploymentProvisioningStateSucceeded),
	// 		ReadinessProbe: &armmachinelearning.ProbeSettings{
	// 			FailureThreshold: to.Ptr[int32](30),
	// 			InitialDelay: to.Ptr("PT1S"),
	// 			Period: to.Ptr("PT10S"),
	// 			SuccessThreshold: to.Ptr[int32](1),
	// 			Timeout: to.Ptr("PT2S"),
	// 		},
	// 		RequestSettings: &armmachinelearning.OnlineRequestSettings{
	// 			MaxConcurrentRequestsPerInstance: to.Ptr[int32](1),
	// 			MaxQueueWait: to.Ptr("PT5M"),
	// 			RequestTimeout: to.Ptr("PT5M"),
	// 		},
	// 		ScaleSettings: &armmachinelearning.DefaultScaleSettings{
	// 			ScaleType: to.Ptr(armmachinelearning.ScaleTypeDefault),
	// 		},
	// 	},
	// 	SKU: &armmachinelearning.SKU{
	// 		Name: to.Ptr("string"),
	// 		Capacity: to.Ptr[int32](1),
	// 		Family: to.Ptr("string"),
	// 		Size: to.Ptr("string"),
	// 		Tier: to.Ptr(armmachinelearning.SKUTierFree),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/OnlineDeployment/getLogs.json
func ExampleOnlineDeploymentsClient_GetLogs() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOnlineDeploymentsClient().GetLogs(ctx, "testrg123", "workspace123", "testEndpoint", "testDeployment", armmachinelearning.DeploymentLogsRequest{
		ContainerType: to.Ptr(armmachinelearning.ContainerTypeStorageInitializer),
		Tail:          to.Ptr[int32](0),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentLogs = armmachinelearning.DeploymentLogs{
	// 	Content: to.Ptr("string"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/OnlineDeployment/KubernetesOnlineDeployment/listSkus.json
func ExampleOnlineDeploymentsClient_NewListSKUsPager_listKubernetesOnlineDeploymentSkus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOnlineDeploymentsClient().NewListSKUsPager("test-rg", "my-aml-workspace", "testEndpointName", "testDeploymentName", &armmachinelearning.OnlineDeploymentsClientListSKUsOptions{Count: to.Ptr[int32](1),
		Skip: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SKUResourceArmPaginatedResult = armmachinelearning.SKUResourceArmPaginatedResult{
		// 	Value: []*armmachinelearning.SKUResource{
		// 		{
		// 			Capacity: &armmachinelearning.SKUCapacity{
		// 				Default: to.Ptr[int32](1),
		// 				Maximum: to.Ptr[int32](1),
		// 				Minimum: to.Ptr[int32](1),
		// 				ScaleType: to.Ptr(armmachinelearning.SKUScaleTypeAutomatic),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.MachineLearning.Services/endpoints/deployments"),
		// 			SKU: &armmachinelearning.SKUSetting{
		// 				Name: to.Ptr("string"),
		// 				Tier: to.Ptr(armmachinelearning.SKUTierFree),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/OnlineDeployment/ManagedOnlineDeployment/listSkus.json
func ExampleOnlineDeploymentsClient_NewListSKUsPager_listManagedOnlineDeploymentSkus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOnlineDeploymentsClient().NewListSKUsPager("test-rg", "my-aml-workspace", "testEndpointName", "testDeploymentName", &armmachinelearning.OnlineDeploymentsClientListSKUsOptions{Count: to.Ptr[int32](1),
		Skip: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SKUResourceArmPaginatedResult = armmachinelearning.SKUResourceArmPaginatedResult{
		// 	Value: []*armmachinelearning.SKUResource{
		// 		{
		// 			Capacity: &armmachinelearning.SKUCapacity{
		// 				Default: to.Ptr[int32](1),
		// 				Maximum: to.Ptr[int32](1),
		// 				Minimum: to.Ptr[int32](1),
		// 				ScaleType: to.Ptr(armmachinelearning.SKUScaleTypeAutomatic),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.MachineLearning.Services/endpoints/deployments"),
		// 			SKU: &armmachinelearning.SKUSetting{
		// 				Name: to.Ptr("string"),
		// 				Tier: to.Ptr(armmachinelearning.SKUTierFree),
		// 			},
		// 	}},
		// }
	}
}
