// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package networkservices

import (
	"bytes"
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"
	"time"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	networkservicespb "cloud.google.com/go/networkservices/apiv1/networkservicespb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	ListEndpointPolicies []gax.CallOption
	GetEndpointPolicy    []gax.CallOption
	CreateEndpointPolicy []gax.CallOption
	UpdateEndpointPolicy []gax.CallOption
	DeleteEndpointPolicy []gax.CallOption
	ListGateways         []gax.CallOption
	GetGateway           []gax.CallOption
	CreateGateway        []gax.CallOption
	UpdateGateway        []gax.CallOption
	DeleteGateway        []gax.CallOption
	ListGrpcRoutes       []gax.CallOption
	GetGrpcRoute         []gax.CallOption
	CreateGrpcRoute      []gax.CallOption
	UpdateGrpcRoute      []gax.CallOption
	DeleteGrpcRoute      []gax.CallOption
	ListHttpRoutes       []gax.CallOption
	GetHttpRoute         []gax.CallOption
	CreateHttpRoute      []gax.CallOption
	UpdateHttpRoute      []gax.CallOption
	DeleteHttpRoute      []gax.CallOption
	ListTcpRoutes        []gax.CallOption
	GetTcpRoute          []gax.CallOption
	CreateTcpRoute       []gax.CallOption
	UpdateTcpRoute       []gax.CallOption
	DeleteTcpRoute       []gax.CallOption
	ListTlsRoutes        []gax.CallOption
	GetTlsRoute          []gax.CallOption
	CreateTlsRoute       []gax.CallOption
	UpdateTlsRoute       []gax.CallOption
	DeleteTlsRoute       []gax.CallOption
	ListServiceBindings  []gax.CallOption
	GetServiceBinding    []gax.CallOption
	CreateServiceBinding []gax.CallOption
	DeleteServiceBinding []gax.CallOption
	ListMeshes           []gax.CallOption
	GetMesh              []gax.CallOption
	CreateMesh           []gax.CallOption
	UpdateMesh           []gax.CallOption
	DeleteMesh           []gax.CallOption
	GetLocation          []gax.CallOption
	ListLocations        []gax.CallOption
	GetIamPolicy         []gax.CallOption
	SetIamPolicy         []gax.CallOption
	TestIamPermissions   []gax.CallOption
	CancelOperation      []gax.CallOption
	DeleteOperation      []gax.CallOption
	GetOperation         []gax.CallOption
	ListOperations       []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("networkservices.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("networkservices.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("networkservices.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://networkservices.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		ListEndpointPolicies: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetEndpointPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateEndpointPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateEndpointPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteEndpointPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListGateways: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetGateway: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateGateway: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateGateway: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteGateway: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListGrpcRoutes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetGrpcRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateGrpcRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateGrpcRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteGrpcRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListHttpRoutes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetHttpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateHttpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateHttpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteHttpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListTcpRoutes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetTcpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateTcpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateTcpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteTcpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListTlsRoutes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetTlsRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateTlsRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateTlsRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteTlsRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListServiceBindings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetServiceBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateServiceBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteServiceBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListMeshes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetMesh: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateMesh: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateMesh: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteMesh: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLocation:        []gax.CallOption{},
		ListLocations:      []gax.CallOption{},
		GetIamPolicy:       []gax.CallOption{},
		SetIamPolicy:       []gax.CallOption{},
		TestIamPermissions: []gax.CallOption{},
		CancelOperation:    []gax.CallOption{},
		DeleteOperation:    []gax.CallOption{},
		GetOperation:       []gax.CallOption{},
		ListOperations:     []gax.CallOption{},
	}
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		ListEndpointPolicies: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetEndpointPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateEndpointPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateEndpointPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteEndpointPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListGateways: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetGateway: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateGateway: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateGateway: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteGateway: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListGrpcRoutes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetGrpcRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateGrpcRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateGrpcRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteGrpcRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListHttpRoutes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetHttpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateHttpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateHttpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteHttpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListTcpRoutes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetTcpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateTcpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateTcpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteTcpRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListTlsRoutes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetTlsRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateTlsRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateTlsRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteTlsRoute: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListServiceBindings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetServiceBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateServiceBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteServiceBinding: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListMeshes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetMesh: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateMesh: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateMesh: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteMesh: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLocation:        []gax.CallOption{},
		ListLocations:      []gax.CallOption{},
		GetIamPolicy:       []gax.CallOption{},
		SetIamPolicy:       []gax.CallOption{},
		TestIamPermissions: []gax.CallOption{},
		CancelOperation:    []gax.CallOption{},
		DeleteOperation:    []gax.CallOption{},
		GetOperation:       []gax.CallOption{},
		ListOperations:     []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods available from Network Services API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListEndpointPolicies(context.Context, *networkservicespb.ListEndpointPoliciesRequest, ...gax.CallOption) *EndpointPolicyIterator
	GetEndpointPolicy(context.Context, *networkservicespb.GetEndpointPolicyRequest, ...gax.CallOption) (*networkservicespb.EndpointPolicy, error)
	CreateEndpointPolicy(context.Context, *networkservicespb.CreateEndpointPolicyRequest, ...gax.CallOption) (*CreateEndpointPolicyOperation, error)
	CreateEndpointPolicyOperation(name string) *CreateEndpointPolicyOperation
	UpdateEndpointPolicy(context.Context, *networkservicespb.UpdateEndpointPolicyRequest, ...gax.CallOption) (*UpdateEndpointPolicyOperation, error)
	UpdateEndpointPolicyOperation(name string) *UpdateEndpointPolicyOperation
	DeleteEndpointPolicy(context.Context, *networkservicespb.DeleteEndpointPolicyRequest, ...gax.CallOption) (*DeleteEndpointPolicyOperation, error)
	DeleteEndpointPolicyOperation(name string) *DeleteEndpointPolicyOperation
	ListGateways(context.Context, *networkservicespb.ListGatewaysRequest, ...gax.CallOption) *GatewayIterator
	GetGateway(context.Context, *networkservicespb.GetGatewayRequest, ...gax.CallOption) (*networkservicespb.Gateway, error)
	CreateGateway(context.Context, *networkservicespb.CreateGatewayRequest, ...gax.CallOption) (*CreateGatewayOperation, error)
	CreateGatewayOperation(name string) *CreateGatewayOperation
	UpdateGateway(context.Context, *networkservicespb.UpdateGatewayRequest, ...gax.CallOption) (*UpdateGatewayOperation, error)
	UpdateGatewayOperation(name string) *UpdateGatewayOperation
	DeleteGateway(context.Context, *networkservicespb.DeleteGatewayRequest, ...gax.CallOption) (*DeleteGatewayOperation, error)
	DeleteGatewayOperation(name string) *DeleteGatewayOperation
	ListGrpcRoutes(context.Context, *networkservicespb.ListGrpcRoutesRequest, ...gax.CallOption) *GrpcRouteIterator
	GetGrpcRoute(context.Context, *networkservicespb.GetGrpcRouteRequest, ...gax.CallOption) (*networkservicespb.GrpcRoute, error)
	CreateGrpcRoute(context.Context, *networkservicespb.CreateGrpcRouteRequest, ...gax.CallOption) (*CreateGrpcRouteOperation, error)
	CreateGrpcRouteOperation(name string) *CreateGrpcRouteOperation
	UpdateGrpcRoute(context.Context, *networkservicespb.UpdateGrpcRouteRequest, ...gax.CallOption) (*UpdateGrpcRouteOperation, error)
	UpdateGrpcRouteOperation(name string) *UpdateGrpcRouteOperation
	DeleteGrpcRoute(context.Context, *networkservicespb.DeleteGrpcRouteRequest, ...gax.CallOption) (*DeleteGrpcRouteOperation, error)
	DeleteGrpcRouteOperation(name string) *DeleteGrpcRouteOperation
	ListHttpRoutes(context.Context, *networkservicespb.ListHttpRoutesRequest, ...gax.CallOption) *HttpRouteIterator
	GetHttpRoute(context.Context, *networkservicespb.GetHttpRouteRequest, ...gax.CallOption) (*networkservicespb.HttpRoute, error)
	CreateHttpRoute(context.Context, *networkservicespb.CreateHttpRouteRequest, ...gax.CallOption) (*CreateHttpRouteOperation, error)
	CreateHttpRouteOperation(name string) *CreateHttpRouteOperation
	UpdateHttpRoute(context.Context, *networkservicespb.UpdateHttpRouteRequest, ...gax.CallOption) (*UpdateHttpRouteOperation, error)
	UpdateHttpRouteOperation(name string) *UpdateHttpRouteOperation
	DeleteHttpRoute(context.Context, *networkservicespb.DeleteHttpRouteRequest, ...gax.CallOption) (*DeleteHttpRouteOperation, error)
	DeleteHttpRouteOperation(name string) *DeleteHttpRouteOperation
	ListTcpRoutes(context.Context, *networkservicespb.ListTcpRoutesRequest, ...gax.CallOption) *TcpRouteIterator
	GetTcpRoute(context.Context, *networkservicespb.GetTcpRouteRequest, ...gax.CallOption) (*networkservicespb.TcpRoute, error)
	CreateTcpRoute(context.Context, *networkservicespb.CreateTcpRouteRequest, ...gax.CallOption) (*CreateTcpRouteOperation, error)
	CreateTcpRouteOperation(name string) *CreateTcpRouteOperation
	UpdateTcpRoute(context.Context, *networkservicespb.UpdateTcpRouteRequest, ...gax.CallOption) (*UpdateTcpRouteOperation, error)
	UpdateTcpRouteOperation(name string) *UpdateTcpRouteOperation
	DeleteTcpRoute(context.Context, *networkservicespb.DeleteTcpRouteRequest, ...gax.CallOption) (*DeleteTcpRouteOperation, error)
	DeleteTcpRouteOperation(name string) *DeleteTcpRouteOperation
	ListTlsRoutes(context.Context, *networkservicespb.ListTlsRoutesRequest, ...gax.CallOption) *TlsRouteIterator
	GetTlsRoute(context.Context, *networkservicespb.GetTlsRouteRequest, ...gax.CallOption) (*networkservicespb.TlsRoute, error)
	CreateTlsRoute(context.Context, *networkservicespb.CreateTlsRouteRequest, ...gax.CallOption) (*CreateTlsRouteOperation, error)
	CreateTlsRouteOperation(name string) *CreateTlsRouteOperation
	UpdateTlsRoute(context.Context, *networkservicespb.UpdateTlsRouteRequest, ...gax.CallOption) (*UpdateTlsRouteOperation, error)
	UpdateTlsRouteOperation(name string) *UpdateTlsRouteOperation
	DeleteTlsRoute(context.Context, *networkservicespb.DeleteTlsRouteRequest, ...gax.CallOption) (*DeleteTlsRouteOperation, error)
	DeleteTlsRouteOperation(name string) *DeleteTlsRouteOperation
	ListServiceBindings(context.Context, *networkservicespb.ListServiceBindingsRequest, ...gax.CallOption) *ServiceBindingIterator
	GetServiceBinding(context.Context, *networkservicespb.GetServiceBindingRequest, ...gax.CallOption) (*networkservicespb.ServiceBinding, error)
	CreateServiceBinding(context.Context, *networkservicespb.CreateServiceBindingRequest, ...gax.CallOption) (*CreateServiceBindingOperation, error)
	CreateServiceBindingOperation(name string) *CreateServiceBindingOperation
	DeleteServiceBinding(context.Context, *networkservicespb.DeleteServiceBindingRequest, ...gax.CallOption) (*DeleteServiceBindingOperation, error)
	DeleteServiceBindingOperation(name string) *DeleteServiceBindingOperation
	ListMeshes(context.Context, *networkservicespb.ListMeshesRequest, ...gax.CallOption) *MeshIterator
	GetMesh(context.Context, *networkservicespb.GetMeshRequest, ...gax.CallOption) (*networkservicespb.Mesh, error)
	CreateMesh(context.Context, *networkservicespb.CreateMeshRequest, ...gax.CallOption) (*CreateMeshOperation, error)
	CreateMeshOperation(name string) *CreateMeshOperation
	UpdateMesh(context.Context, *networkservicespb.UpdateMeshRequest, ...gax.CallOption) (*UpdateMeshOperation, error)
	UpdateMeshOperation(name string) *UpdateMeshOperation
	DeleteMesh(context.Context, *networkservicespb.DeleteMeshRequest, ...gax.CallOption) (*DeleteMeshOperation, error)
	DeleteMeshOperation(name string) *DeleteMeshOperation
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest, ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// Client is a client for interacting with Network Services API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service describing handlers for resources.
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListEndpointPolicies lists EndpointPolicies in a given project and location.
func (c *Client) ListEndpointPolicies(ctx context.Context, req *networkservicespb.ListEndpointPoliciesRequest, opts ...gax.CallOption) *EndpointPolicyIterator {
	return c.internalClient.ListEndpointPolicies(ctx, req, opts...)
}

// GetEndpointPolicy gets details of a single EndpointPolicy.
func (c *Client) GetEndpointPolicy(ctx context.Context, req *networkservicespb.GetEndpointPolicyRequest, opts ...gax.CallOption) (*networkservicespb.EndpointPolicy, error) {
	return c.internalClient.GetEndpointPolicy(ctx, req, opts...)
}

// CreateEndpointPolicy creates a new EndpointPolicy in a given project and location.
func (c *Client) CreateEndpointPolicy(ctx context.Context, req *networkservicespb.CreateEndpointPolicyRequest, opts ...gax.CallOption) (*CreateEndpointPolicyOperation, error) {
	return c.internalClient.CreateEndpointPolicy(ctx, req, opts...)
}

// CreateEndpointPolicyOperation returns a new CreateEndpointPolicyOperation from a given name.
// The name must be that of a previously created CreateEndpointPolicyOperation, possibly from a different process.
func (c *Client) CreateEndpointPolicyOperation(name string) *CreateEndpointPolicyOperation {
	return c.internalClient.CreateEndpointPolicyOperation(name)
}

// UpdateEndpointPolicy updates the parameters of a single EndpointPolicy.
func (c *Client) UpdateEndpointPolicy(ctx context.Context, req *networkservicespb.UpdateEndpointPolicyRequest, opts ...gax.CallOption) (*UpdateEndpointPolicyOperation, error) {
	return c.internalClient.UpdateEndpointPolicy(ctx, req, opts...)
}

// UpdateEndpointPolicyOperation returns a new UpdateEndpointPolicyOperation from a given name.
// The name must be that of a previously created UpdateEndpointPolicyOperation, possibly from a different process.
func (c *Client) UpdateEndpointPolicyOperation(name string) *UpdateEndpointPolicyOperation {
	return c.internalClient.UpdateEndpointPolicyOperation(name)
}

// DeleteEndpointPolicy deletes a single EndpointPolicy.
func (c *Client) DeleteEndpointPolicy(ctx context.Context, req *networkservicespb.DeleteEndpointPolicyRequest, opts ...gax.CallOption) (*DeleteEndpointPolicyOperation, error) {
	return c.internalClient.DeleteEndpointPolicy(ctx, req, opts...)
}

// DeleteEndpointPolicyOperation returns a new DeleteEndpointPolicyOperation from a given name.
// The name must be that of a previously created DeleteEndpointPolicyOperation, possibly from a different process.
func (c *Client) DeleteEndpointPolicyOperation(name string) *DeleteEndpointPolicyOperation {
	return c.internalClient.DeleteEndpointPolicyOperation(name)
}

// ListGateways lists Gateways in a given project and location.
func (c *Client) ListGateways(ctx context.Context, req *networkservicespb.ListGatewaysRequest, opts ...gax.CallOption) *GatewayIterator {
	return c.internalClient.ListGateways(ctx, req, opts...)
}

// GetGateway gets details of a single Gateway.
func (c *Client) GetGateway(ctx context.Context, req *networkservicespb.GetGatewayRequest, opts ...gax.CallOption) (*networkservicespb.Gateway, error) {
	return c.internalClient.GetGateway(ctx, req, opts...)
}

// CreateGateway creates a new Gateway in a given project and location.
func (c *Client) CreateGateway(ctx context.Context, req *networkservicespb.CreateGatewayRequest, opts ...gax.CallOption) (*CreateGatewayOperation, error) {
	return c.internalClient.CreateGateway(ctx, req, opts...)
}

// CreateGatewayOperation returns a new CreateGatewayOperation from a given name.
// The name must be that of a previously created CreateGatewayOperation, possibly from a different process.
func (c *Client) CreateGatewayOperation(name string) *CreateGatewayOperation {
	return c.internalClient.CreateGatewayOperation(name)
}

// UpdateGateway updates the parameters of a single Gateway.
func (c *Client) UpdateGateway(ctx context.Context, req *networkservicespb.UpdateGatewayRequest, opts ...gax.CallOption) (*UpdateGatewayOperation, error) {
	return c.internalClient.UpdateGateway(ctx, req, opts...)
}

// UpdateGatewayOperation returns a new UpdateGatewayOperation from a given name.
// The name must be that of a previously created UpdateGatewayOperation, possibly from a different process.
func (c *Client) UpdateGatewayOperation(name string) *UpdateGatewayOperation {
	return c.internalClient.UpdateGatewayOperation(name)
}

// DeleteGateway deletes a single Gateway.
func (c *Client) DeleteGateway(ctx context.Context, req *networkservicespb.DeleteGatewayRequest, opts ...gax.CallOption) (*DeleteGatewayOperation, error) {
	return c.internalClient.DeleteGateway(ctx, req, opts...)
}

// DeleteGatewayOperation returns a new DeleteGatewayOperation from a given name.
// The name must be that of a previously created DeleteGatewayOperation, possibly from a different process.
func (c *Client) DeleteGatewayOperation(name string) *DeleteGatewayOperation {
	return c.internalClient.DeleteGatewayOperation(name)
}

// ListGrpcRoutes lists GrpcRoutes in a given project and location.
func (c *Client) ListGrpcRoutes(ctx context.Context, req *networkservicespb.ListGrpcRoutesRequest, opts ...gax.CallOption) *GrpcRouteIterator {
	return c.internalClient.ListGrpcRoutes(ctx, req, opts...)
}

// GetGrpcRoute gets details of a single GrpcRoute.
func (c *Client) GetGrpcRoute(ctx context.Context, req *networkservicespb.GetGrpcRouteRequest, opts ...gax.CallOption) (*networkservicespb.GrpcRoute, error) {
	return c.internalClient.GetGrpcRoute(ctx, req, opts...)
}

// CreateGrpcRoute creates a new GrpcRoute in a given project and location.
func (c *Client) CreateGrpcRoute(ctx context.Context, req *networkservicespb.CreateGrpcRouteRequest, opts ...gax.CallOption) (*CreateGrpcRouteOperation, error) {
	return c.internalClient.CreateGrpcRoute(ctx, req, opts...)
}

// CreateGrpcRouteOperation returns a new CreateGrpcRouteOperation from a given name.
// The name must be that of a previously created CreateGrpcRouteOperation, possibly from a different process.
func (c *Client) CreateGrpcRouteOperation(name string) *CreateGrpcRouteOperation {
	return c.internalClient.CreateGrpcRouteOperation(name)
}

// UpdateGrpcRoute updates the parameters of a single GrpcRoute.
func (c *Client) UpdateGrpcRoute(ctx context.Context, req *networkservicespb.UpdateGrpcRouteRequest, opts ...gax.CallOption) (*UpdateGrpcRouteOperation, error) {
	return c.internalClient.UpdateGrpcRoute(ctx, req, opts...)
}

// UpdateGrpcRouteOperation returns a new UpdateGrpcRouteOperation from a given name.
// The name must be that of a previously created UpdateGrpcRouteOperation, possibly from a different process.
func (c *Client) UpdateGrpcRouteOperation(name string) *UpdateGrpcRouteOperation {
	return c.internalClient.UpdateGrpcRouteOperation(name)
}

// DeleteGrpcRoute deletes a single GrpcRoute.
func (c *Client) DeleteGrpcRoute(ctx context.Context, req *networkservicespb.DeleteGrpcRouteRequest, opts ...gax.CallOption) (*DeleteGrpcRouteOperation, error) {
	return c.internalClient.DeleteGrpcRoute(ctx, req, opts...)
}

// DeleteGrpcRouteOperation returns a new DeleteGrpcRouteOperation from a given name.
// The name must be that of a previously created DeleteGrpcRouteOperation, possibly from a different process.
func (c *Client) DeleteGrpcRouteOperation(name string) *DeleteGrpcRouteOperation {
	return c.internalClient.DeleteGrpcRouteOperation(name)
}

// ListHttpRoutes lists HttpRoute in a given project and location.
func (c *Client) ListHttpRoutes(ctx context.Context, req *networkservicespb.ListHttpRoutesRequest, opts ...gax.CallOption) *HttpRouteIterator {
	return c.internalClient.ListHttpRoutes(ctx, req, opts...)
}

// GetHttpRoute gets details of a single HttpRoute.
func (c *Client) GetHttpRoute(ctx context.Context, req *networkservicespb.GetHttpRouteRequest, opts ...gax.CallOption) (*networkservicespb.HttpRoute, error) {
	return c.internalClient.GetHttpRoute(ctx, req, opts...)
}

// CreateHttpRoute creates a new HttpRoute in a given project and location.
func (c *Client) CreateHttpRoute(ctx context.Context, req *networkservicespb.CreateHttpRouteRequest, opts ...gax.CallOption) (*CreateHttpRouteOperation, error) {
	return c.internalClient.CreateHttpRoute(ctx, req, opts...)
}

// CreateHttpRouteOperation returns a new CreateHttpRouteOperation from a given name.
// The name must be that of a previously created CreateHttpRouteOperation, possibly from a different process.
func (c *Client) CreateHttpRouteOperation(name string) *CreateHttpRouteOperation {
	return c.internalClient.CreateHttpRouteOperation(name)
}

// UpdateHttpRoute updates the parameters of a single HttpRoute.
func (c *Client) UpdateHttpRoute(ctx context.Context, req *networkservicespb.UpdateHttpRouteRequest, opts ...gax.CallOption) (*UpdateHttpRouteOperation, error) {
	return c.internalClient.UpdateHttpRoute(ctx, req, opts...)
}

// UpdateHttpRouteOperation returns a new UpdateHttpRouteOperation from a given name.
// The name must be that of a previously created UpdateHttpRouteOperation, possibly from a different process.
func (c *Client) UpdateHttpRouteOperation(name string) *UpdateHttpRouteOperation {
	return c.internalClient.UpdateHttpRouteOperation(name)
}

// DeleteHttpRoute deletes a single HttpRoute.
func (c *Client) DeleteHttpRoute(ctx context.Context, req *networkservicespb.DeleteHttpRouteRequest, opts ...gax.CallOption) (*DeleteHttpRouteOperation, error) {
	return c.internalClient.DeleteHttpRoute(ctx, req, opts...)
}

// DeleteHttpRouteOperation returns a new DeleteHttpRouteOperation from a given name.
// The name must be that of a previously created DeleteHttpRouteOperation, possibly from a different process.
func (c *Client) DeleteHttpRouteOperation(name string) *DeleteHttpRouteOperation {
	return c.internalClient.DeleteHttpRouteOperation(name)
}

// ListTcpRoutes lists TcpRoute in a given project and location.
func (c *Client) ListTcpRoutes(ctx context.Context, req *networkservicespb.ListTcpRoutesRequest, opts ...gax.CallOption) *TcpRouteIterator {
	return c.internalClient.ListTcpRoutes(ctx, req, opts...)
}

// GetTcpRoute gets details of a single TcpRoute.
func (c *Client) GetTcpRoute(ctx context.Context, req *networkservicespb.GetTcpRouteRequest, opts ...gax.CallOption) (*networkservicespb.TcpRoute, error) {
	return c.internalClient.GetTcpRoute(ctx, req, opts...)
}

// CreateTcpRoute creates a new TcpRoute in a given project and location.
func (c *Client) CreateTcpRoute(ctx context.Context, req *networkservicespb.CreateTcpRouteRequest, opts ...gax.CallOption) (*CreateTcpRouteOperation, error) {
	return c.internalClient.CreateTcpRoute(ctx, req, opts...)
}

// CreateTcpRouteOperation returns a new CreateTcpRouteOperation from a given name.
// The name must be that of a previously created CreateTcpRouteOperation, possibly from a different process.
func (c *Client) CreateTcpRouteOperation(name string) *CreateTcpRouteOperation {
	return c.internalClient.CreateTcpRouteOperation(name)
}

// UpdateTcpRoute updates the parameters of a single TcpRoute.
func (c *Client) UpdateTcpRoute(ctx context.Context, req *networkservicespb.UpdateTcpRouteRequest, opts ...gax.CallOption) (*UpdateTcpRouteOperation, error) {
	return c.internalClient.UpdateTcpRoute(ctx, req, opts...)
}

// UpdateTcpRouteOperation returns a new UpdateTcpRouteOperation from a given name.
// The name must be that of a previously created UpdateTcpRouteOperation, possibly from a different process.
func (c *Client) UpdateTcpRouteOperation(name string) *UpdateTcpRouteOperation {
	return c.internalClient.UpdateTcpRouteOperation(name)
}

// DeleteTcpRoute deletes a single TcpRoute.
func (c *Client) DeleteTcpRoute(ctx context.Context, req *networkservicespb.DeleteTcpRouteRequest, opts ...gax.CallOption) (*DeleteTcpRouteOperation, error) {
	return c.internalClient.DeleteTcpRoute(ctx, req, opts...)
}

// DeleteTcpRouteOperation returns a new DeleteTcpRouteOperation from a given name.
// The name must be that of a previously created DeleteTcpRouteOperation, possibly from a different process.
func (c *Client) DeleteTcpRouteOperation(name string) *DeleteTcpRouteOperation {
	return c.internalClient.DeleteTcpRouteOperation(name)
}

// ListTlsRoutes lists TlsRoute in a given project and location.
func (c *Client) ListTlsRoutes(ctx context.Context, req *networkservicespb.ListTlsRoutesRequest, opts ...gax.CallOption) *TlsRouteIterator {
	return c.internalClient.ListTlsRoutes(ctx, req, opts...)
}

// GetTlsRoute gets details of a single TlsRoute.
func (c *Client) GetTlsRoute(ctx context.Context, req *networkservicespb.GetTlsRouteRequest, opts ...gax.CallOption) (*networkservicespb.TlsRoute, error) {
	return c.internalClient.GetTlsRoute(ctx, req, opts...)
}

// CreateTlsRoute creates a new TlsRoute in a given project and location.
func (c *Client) CreateTlsRoute(ctx context.Context, req *networkservicespb.CreateTlsRouteRequest, opts ...gax.CallOption) (*CreateTlsRouteOperation, error) {
	return c.internalClient.CreateTlsRoute(ctx, req, opts...)
}

// CreateTlsRouteOperation returns a new CreateTlsRouteOperation from a given name.
// The name must be that of a previously created CreateTlsRouteOperation, possibly from a different process.
func (c *Client) CreateTlsRouteOperation(name string) *CreateTlsRouteOperation {
	return c.internalClient.CreateTlsRouteOperation(name)
}

// UpdateTlsRoute updates the parameters of a single TlsRoute.
func (c *Client) UpdateTlsRoute(ctx context.Context, req *networkservicespb.UpdateTlsRouteRequest, opts ...gax.CallOption) (*UpdateTlsRouteOperation, error) {
	return c.internalClient.UpdateTlsRoute(ctx, req, opts...)
}

// UpdateTlsRouteOperation returns a new UpdateTlsRouteOperation from a given name.
// The name must be that of a previously created UpdateTlsRouteOperation, possibly from a different process.
func (c *Client) UpdateTlsRouteOperation(name string) *UpdateTlsRouteOperation {
	return c.internalClient.UpdateTlsRouteOperation(name)
}

// DeleteTlsRoute deletes a single TlsRoute.
func (c *Client) DeleteTlsRoute(ctx context.Context, req *networkservicespb.DeleteTlsRouteRequest, opts ...gax.CallOption) (*DeleteTlsRouteOperation, error) {
	return c.internalClient.DeleteTlsRoute(ctx, req, opts...)
}

// DeleteTlsRouteOperation returns a new DeleteTlsRouteOperation from a given name.
// The name must be that of a previously created DeleteTlsRouteOperation, possibly from a different process.
func (c *Client) DeleteTlsRouteOperation(name string) *DeleteTlsRouteOperation {
	return c.internalClient.DeleteTlsRouteOperation(name)
}

// ListServiceBindings lists ServiceBinding in a given project and location.
func (c *Client) ListServiceBindings(ctx context.Context, req *networkservicespb.ListServiceBindingsRequest, opts ...gax.CallOption) *ServiceBindingIterator {
	return c.internalClient.ListServiceBindings(ctx, req, opts...)
}

// GetServiceBinding gets details of a single ServiceBinding.
func (c *Client) GetServiceBinding(ctx context.Context, req *networkservicespb.GetServiceBindingRequest, opts ...gax.CallOption) (*networkservicespb.ServiceBinding, error) {
	return c.internalClient.GetServiceBinding(ctx, req, opts...)
}

// CreateServiceBinding creates a new ServiceBinding in a given project and location.
func (c *Client) CreateServiceBinding(ctx context.Context, req *networkservicespb.CreateServiceBindingRequest, opts ...gax.CallOption) (*CreateServiceBindingOperation, error) {
	return c.internalClient.CreateServiceBinding(ctx, req, opts...)
}

// CreateServiceBindingOperation returns a new CreateServiceBindingOperation from a given name.
// The name must be that of a previously created CreateServiceBindingOperation, possibly from a different process.
func (c *Client) CreateServiceBindingOperation(name string) *CreateServiceBindingOperation {
	return c.internalClient.CreateServiceBindingOperation(name)
}

// DeleteServiceBinding deletes a single ServiceBinding.
func (c *Client) DeleteServiceBinding(ctx context.Context, req *networkservicespb.DeleteServiceBindingRequest, opts ...gax.CallOption) (*DeleteServiceBindingOperation, error) {
	return c.internalClient.DeleteServiceBinding(ctx, req, opts...)
}

// DeleteServiceBindingOperation returns a new DeleteServiceBindingOperation from a given name.
// The name must be that of a previously created DeleteServiceBindingOperation, possibly from a different process.
func (c *Client) DeleteServiceBindingOperation(name string) *DeleteServiceBindingOperation {
	return c.internalClient.DeleteServiceBindingOperation(name)
}

// ListMeshes lists Meshes in a given project and location.
func (c *Client) ListMeshes(ctx context.Context, req *networkservicespb.ListMeshesRequest, opts ...gax.CallOption) *MeshIterator {
	return c.internalClient.ListMeshes(ctx, req, opts...)
}

// GetMesh gets details of a single Mesh.
func (c *Client) GetMesh(ctx context.Context, req *networkservicespb.GetMeshRequest, opts ...gax.CallOption) (*networkservicespb.Mesh, error) {
	return c.internalClient.GetMesh(ctx, req, opts...)
}

// CreateMesh creates a new Mesh in a given project and location.
func (c *Client) CreateMesh(ctx context.Context, req *networkservicespb.CreateMeshRequest, opts ...gax.CallOption) (*CreateMeshOperation, error) {
	return c.internalClient.CreateMesh(ctx, req, opts...)
}

// CreateMeshOperation returns a new CreateMeshOperation from a given name.
// The name must be that of a previously created CreateMeshOperation, possibly from a different process.
func (c *Client) CreateMeshOperation(name string) *CreateMeshOperation {
	return c.internalClient.CreateMeshOperation(name)
}

// UpdateMesh updates the parameters of a single Mesh.
func (c *Client) UpdateMesh(ctx context.Context, req *networkservicespb.UpdateMeshRequest, opts ...gax.CallOption) (*UpdateMeshOperation, error) {
	return c.internalClient.UpdateMesh(ctx, req, opts...)
}

// UpdateMeshOperation returns a new UpdateMeshOperation from a given name.
// The name must be that of a previously created UpdateMeshOperation, possibly from a different process.
func (c *Client) UpdateMeshOperation(name string) *UpdateMeshOperation {
	return c.internalClient.UpdateMeshOperation(name)
}

// DeleteMesh deletes a single Mesh.
func (c *Client) DeleteMesh(ctx context.Context, req *networkservicespb.DeleteMeshRequest, opts ...gax.CallOption) (*DeleteMeshOperation, error) {
	return c.internalClient.DeleteMesh(ctx, req, opts...)
}

// DeleteMeshOperation returns a new DeleteMeshOperation from a given name.
// The name must be that of a previously created DeleteMeshOperation, possibly from a different process.
func (c *Client) DeleteMeshOperation(name string) *DeleteMeshOperation {
	return c.internalClient.DeleteMeshOperation(name)
}

// GetLocation gets information about a location.
func (c *Client) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *Client) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// GetIamPolicy gets the access control policy for a resource. Returns an empty policy
// if the resource exists and does not have a policy set.
func (c *Client) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.GetIamPolicy(ctx, req, opts...)
}

// SetIamPolicy sets the access control policy on the specified resource. Replaces
// any existing policy.
//
// Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED
// errors.
func (c *Client) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.SetIamPolicy(ctx, req, opts...)
}

// TestIamPermissions returns permissions that a caller has on the specified resource. If the
// resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.
//
// Note: This operation is designed to be used for building
// permission-aware UIs and command-line tools, not for authorization
// checking. This operation may “fail open” without warning.
func (c *Client) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	return c.internalClient.TestIamPermissions(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *Client) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *Client) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *Client) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *Client) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// gRPCClient is a client for interacting with Network Services API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client networkservicespb.NetworkServicesClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	iamPolicyClient iampb.IAMPolicyClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewClient creates a new network services client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service describing handlers for resources.
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:         connPool,
		client:           networkservicespb.NewNetworkServicesClient(connPool),
		CallOptions:      &client.CallOptions,
		operationsClient: longrunningpb.NewOperationsClient(connPool),
		iamPolicyClient:  iampb.NewIAMPolicyClient(connPool),
		locationsClient:  locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions
}

// NewRESTClient creates a new network services rest client.
//
// Service describing handlers for resources.
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://networkservices.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://networkservices.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://networkservices.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://networkservices.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *gRPCClient) ListEndpointPolicies(ctx context.Context, req *networkservicespb.ListEndpointPoliciesRequest, opts ...gax.CallOption) *EndpointPolicyIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListEndpointPolicies[0:len((*c.CallOptions).ListEndpointPolicies):len((*c.CallOptions).ListEndpointPolicies)], opts...)
	it := &EndpointPolicyIterator{}
	req = proto.Clone(req).(*networkservicespb.ListEndpointPoliciesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.EndpointPolicy, string, error) {
		resp := &networkservicespb.ListEndpointPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListEndpointPolicies(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetEndpointPolicies(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetEndpointPolicy(ctx context.Context, req *networkservicespb.GetEndpointPolicyRequest, opts ...gax.CallOption) (*networkservicespb.EndpointPolicy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetEndpointPolicy[0:len((*c.CallOptions).GetEndpointPolicy):len((*c.CallOptions).GetEndpointPolicy)], opts...)
	var resp *networkservicespb.EndpointPolicy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetEndpointPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateEndpointPolicy(ctx context.Context, req *networkservicespb.CreateEndpointPolicyRequest, opts ...gax.CallOption) (*CreateEndpointPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateEndpointPolicy[0:len((*c.CallOptions).CreateEndpointPolicy):len((*c.CallOptions).CreateEndpointPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateEndpointPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateEndpointPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateEndpointPolicy(ctx context.Context, req *networkservicespb.UpdateEndpointPolicyRequest, opts ...gax.CallOption) (*UpdateEndpointPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "endpoint_policy.name", url.QueryEscape(req.GetEndpointPolicy().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateEndpointPolicy[0:len((*c.CallOptions).UpdateEndpointPolicy):len((*c.CallOptions).UpdateEndpointPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateEndpointPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateEndpointPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteEndpointPolicy(ctx context.Context, req *networkservicespb.DeleteEndpointPolicyRequest, opts ...gax.CallOption) (*DeleteEndpointPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteEndpointPolicy[0:len((*c.CallOptions).DeleteEndpointPolicy):len((*c.CallOptions).DeleteEndpointPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteEndpointPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteEndpointPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListGateways(ctx context.Context, req *networkservicespb.ListGatewaysRequest, opts ...gax.CallOption) *GatewayIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListGateways[0:len((*c.CallOptions).ListGateways):len((*c.CallOptions).ListGateways)], opts...)
	it := &GatewayIterator{}
	req = proto.Clone(req).(*networkservicespb.ListGatewaysRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.Gateway, string, error) {
		resp := &networkservicespb.ListGatewaysResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListGateways(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetGateways(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetGateway(ctx context.Context, req *networkservicespb.GetGatewayRequest, opts ...gax.CallOption) (*networkservicespb.Gateway, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetGateway[0:len((*c.CallOptions).GetGateway):len((*c.CallOptions).GetGateway)], opts...)
	var resp *networkservicespb.Gateway
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetGateway(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateGateway(ctx context.Context, req *networkservicespb.CreateGatewayRequest, opts ...gax.CallOption) (*CreateGatewayOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateGateway[0:len((*c.CallOptions).CreateGateway):len((*c.CallOptions).CreateGateway)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateGateway(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateGatewayOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateGateway(ctx context.Context, req *networkservicespb.UpdateGatewayRequest, opts ...gax.CallOption) (*UpdateGatewayOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "gateway.name", url.QueryEscape(req.GetGateway().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateGateway[0:len((*c.CallOptions).UpdateGateway):len((*c.CallOptions).UpdateGateway)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateGateway(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateGatewayOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteGateway(ctx context.Context, req *networkservicespb.DeleteGatewayRequest, opts ...gax.CallOption) (*DeleteGatewayOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteGateway[0:len((*c.CallOptions).DeleteGateway):len((*c.CallOptions).DeleteGateway)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteGateway(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteGatewayOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListGrpcRoutes(ctx context.Context, req *networkservicespb.ListGrpcRoutesRequest, opts ...gax.CallOption) *GrpcRouteIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListGrpcRoutes[0:len((*c.CallOptions).ListGrpcRoutes):len((*c.CallOptions).ListGrpcRoutes)], opts...)
	it := &GrpcRouteIterator{}
	req = proto.Clone(req).(*networkservicespb.ListGrpcRoutesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.GrpcRoute, string, error) {
		resp := &networkservicespb.ListGrpcRoutesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListGrpcRoutes(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetGrpcRoutes(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetGrpcRoute(ctx context.Context, req *networkservicespb.GetGrpcRouteRequest, opts ...gax.CallOption) (*networkservicespb.GrpcRoute, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetGrpcRoute[0:len((*c.CallOptions).GetGrpcRoute):len((*c.CallOptions).GetGrpcRoute)], opts...)
	var resp *networkservicespb.GrpcRoute
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetGrpcRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateGrpcRoute(ctx context.Context, req *networkservicespb.CreateGrpcRouteRequest, opts ...gax.CallOption) (*CreateGrpcRouteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateGrpcRoute[0:len((*c.CallOptions).CreateGrpcRoute):len((*c.CallOptions).CreateGrpcRoute)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateGrpcRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateGrpcRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateGrpcRoute(ctx context.Context, req *networkservicespb.UpdateGrpcRouteRequest, opts ...gax.CallOption) (*UpdateGrpcRouteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "grpc_route.name", url.QueryEscape(req.GetGrpcRoute().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateGrpcRoute[0:len((*c.CallOptions).UpdateGrpcRoute):len((*c.CallOptions).UpdateGrpcRoute)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateGrpcRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateGrpcRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteGrpcRoute(ctx context.Context, req *networkservicespb.DeleteGrpcRouteRequest, opts ...gax.CallOption) (*DeleteGrpcRouteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteGrpcRoute[0:len((*c.CallOptions).DeleteGrpcRoute):len((*c.CallOptions).DeleteGrpcRoute)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteGrpcRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteGrpcRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListHttpRoutes(ctx context.Context, req *networkservicespb.ListHttpRoutesRequest, opts ...gax.CallOption) *HttpRouteIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListHttpRoutes[0:len((*c.CallOptions).ListHttpRoutes):len((*c.CallOptions).ListHttpRoutes)], opts...)
	it := &HttpRouteIterator{}
	req = proto.Clone(req).(*networkservicespb.ListHttpRoutesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.HttpRoute, string, error) {
		resp := &networkservicespb.ListHttpRoutesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListHttpRoutes(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetHttpRoutes(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetHttpRoute(ctx context.Context, req *networkservicespb.GetHttpRouteRequest, opts ...gax.CallOption) (*networkservicespb.HttpRoute, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetHttpRoute[0:len((*c.CallOptions).GetHttpRoute):len((*c.CallOptions).GetHttpRoute)], opts...)
	var resp *networkservicespb.HttpRoute
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetHttpRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateHttpRoute(ctx context.Context, req *networkservicespb.CreateHttpRouteRequest, opts ...gax.CallOption) (*CreateHttpRouteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateHttpRoute[0:len((*c.CallOptions).CreateHttpRoute):len((*c.CallOptions).CreateHttpRoute)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateHttpRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateHttpRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateHttpRoute(ctx context.Context, req *networkservicespb.UpdateHttpRouteRequest, opts ...gax.CallOption) (*UpdateHttpRouteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "http_route.name", url.QueryEscape(req.GetHttpRoute().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateHttpRoute[0:len((*c.CallOptions).UpdateHttpRoute):len((*c.CallOptions).UpdateHttpRoute)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateHttpRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateHttpRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteHttpRoute(ctx context.Context, req *networkservicespb.DeleteHttpRouteRequest, opts ...gax.CallOption) (*DeleteHttpRouteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteHttpRoute[0:len((*c.CallOptions).DeleteHttpRoute):len((*c.CallOptions).DeleteHttpRoute)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteHttpRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteHttpRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListTcpRoutes(ctx context.Context, req *networkservicespb.ListTcpRoutesRequest, opts ...gax.CallOption) *TcpRouteIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListTcpRoutes[0:len((*c.CallOptions).ListTcpRoutes):len((*c.CallOptions).ListTcpRoutes)], opts...)
	it := &TcpRouteIterator{}
	req = proto.Clone(req).(*networkservicespb.ListTcpRoutesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.TcpRoute, string, error) {
		resp := &networkservicespb.ListTcpRoutesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListTcpRoutes(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTcpRoutes(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetTcpRoute(ctx context.Context, req *networkservicespb.GetTcpRouteRequest, opts ...gax.CallOption) (*networkservicespb.TcpRoute, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetTcpRoute[0:len((*c.CallOptions).GetTcpRoute):len((*c.CallOptions).GetTcpRoute)], opts...)
	var resp *networkservicespb.TcpRoute
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetTcpRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateTcpRoute(ctx context.Context, req *networkservicespb.CreateTcpRouteRequest, opts ...gax.CallOption) (*CreateTcpRouteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateTcpRoute[0:len((*c.CallOptions).CreateTcpRoute):len((*c.CallOptions).CreateTcpRoute)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateTcpRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateTcpRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateTcpRoute(ctx context.Context, req *networkservicespb.UpdateTcpRouteRequest, opts ...gax.CallOption) (*UpdateTcpRouteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "tcp_route.name", url.QueryEscape(req.GetTcpRoute().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateTcpRoute[0:len((*c.CallOptions).UpdateTcpRoute):len((*c.CallOptions).UpdateTcpRoute)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateTcpRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateTcpRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteTcpRoute(ctx context.Context, req *networkservicespb.DeleteTcpRouteRequest, opts ...gax.CallOption) (*DeleteTcpRouteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteTcpRoute[0:len((*c.CallOptions).DeleteTcpRoute):len((*c.CallOptions).DeleteTcpRoute)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteTcpRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteTcpRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListTlsRoutes(ctx context.Context, req *networkservicespb.ListTlsRoutesRequest, opts ...gax.CallOption) *TlsRouteIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListTlsRoutes[0:len((*c.CallOptions).ListTlsRoutes):len((*c.CallOptions).ListTlsRoutes)], opts...)
	it := &TlsRouteIterator{}
	req = proto.Clone(req).(*networkservicespb.ListTlsRoutesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.TlsRoute, string, error) {
		resp := &networkservicespb.ListTlsRoutesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListTlsRoutes(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTlsRoutes(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetTlsRoute(ctx context.Context, req *networkservicespb.GetTlsRouteRequest, opts ...gax.CallOption) (*networkservicespb.TlsRoute, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetTlsRoute[0:len((*c.CallOptions).GetTlsRoute):len((*c.CallOptions).GetTlsRoute)], opts...)
	var resp *networkservicespb.TlsRoute
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetTlsRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateTlsRoute(ctx context.Context, req *networkservicespb.CreateTlsRouteRequest, opts ...gax.CallOption) (*CreateTlsRouteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateTlsRoute[0:len((*c.CallOptions).CreateTlsRoute):len((*c.CallOptions).CreateTlsRoute)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateTlsRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateTlsRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateTlsRoute(ctx context.Context, req *networkservicespb.UpdateTlsRouteRequest, opts ...gax.CallOption) (*UpdateTlsRouteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "tls_route.name", url.QueryEscape(req.GetTlsRoute().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateTlsRoute[0:len((*c.CallOptions).UpdateTlsRoute):len((*c.CallOptions).UpdateTlsRoute)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateTlsRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateTlsRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteTlsRoute(ctx context.Context, req *networkservicespb.DeleteTlsRouteRequest, opts ...gax.CallOption) (*DeleteTlsRouteOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteTlsRoute[0:len((*c.CallOptions).DeleteTlsRoute):len((*c.CallOptions).DeleteTlsRoute)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteTlsRoute(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteTlsRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListServiceBindings(ctx context.Context, req *networkservicespb.ListServiceBindingsRequest, opts ...gax.CallOption) *ServiceBindingIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListServiceBindings[0:len((*c.CallOptions).ListServiceBindings):len((*c.CallOptions).ListServiceBindings)], opts...)
	it := &ServiceBindingIterator{}
	req = proto.Clone(req).(*networkservicespb.ListServiceBindingsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.ServiceBinding, string, error) {
		resp := &networkservicespb.ListServiceBindingsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListServiceBindings(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetServiceBindings(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetServiceBinding(ctx context.Context, req *networkservicespb.GetServiceBindingRequest, opts ...gax.CallOption) (*networkservicespb.ServiceBinding, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetServiceBinding[0:len((*c.CallOptions).GetServiceBinding):len((*c.CallOptions).GetServiceBinding)], opts...)
	var resp *networkservicespb.ServiceBinding
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetServiceBinding(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateServiceBinding(ctx context.Context, req *networkservicespb.CreateServiceBindingRequest, opts ...gax.CallOption) (*CreateServiceBindingOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateServiceBinding[0:len((*c.CallOptions).CreateServiceBinding):len((*c.CallOptions).CreateServiceBinding)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateServiceBinding(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateServiceBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteServiceBinding(ctx context.Context, req *networkservicespb.DeleteServiceBindingRequest, opts ...gax.CallOption) (*DeleteServiceBindingOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteServiceBinding[0:len((*c.CallOptions).DeleteServiceBinding):len((*c.CallOptions).DeleteServiceBinding)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteServiceBinding(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteServiceBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListMeshes(ctx context.Context, req *networkservicespb.ListMeshesRequest, opts ...gax.CallOption) *MeshIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListMeshes[0:len((*c.CallOptions).ListMeshes):len((*c.CallOptions).ListMeshes)], opts...)
	it := &MeshIterator{}
	req = proto.Clone(req).(*networkservicespb.ListMeshesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.Mesh, string, error) {
		resp := &networkservicespb.ListMeshesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListMeshes(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetMeshes(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetMesh(ctx context.Context, req *networkservicespb.GetMeshRequest, opts ...gax.CallOption) (*networkservicespb.Mesh, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetMesh[0:len((*c.CallOptions).GetMesh):len((*c.CallOptions).GetMesh)], opts...)
	var resp *networkservicespb.Mesh
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetMesh(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateMesh(ctx context.Context, req *networkservicespb.CreateMeshRequest, opts ...gax.CallOption) (*CreateMeshOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateMesh[0:len((*c.CallOptions).CreateMesh):len((*c.CallOptions).CreateMesh)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateMesh(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateMeshOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateMesh(ctx context.Context, req *networkservicespb.UpdateMeshRequest, opts ...gax.CallOption) (*UpdateMeshOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "mesh.name", url.QueryEscape(req.GetMesh().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateMesh[0:len((*c.CallOptions).UpdateMesh):len((*c.CallOptions).UpdateMesh)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateMesh(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateMeshOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteMesh(ctx context.Context, req *networkservicespb.DeleteMeshRequest, opts ...gax.CallOption) (*DeleteMeshOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteMesh[0:len((*c.CallOptions).DeleteMesh):len((*c.CallOptions).DeleteMesh)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteMesh(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteMeshOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.locationsClient.GetLocation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.locationsClient.ListLocations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.iamPolicyClient.GetIamPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.iamPolicyClient.SetIamPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	var resp *iampb.TestIamPermissionsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.iamPolicyClient.TestIamPermissions(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.CancelOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.DeleteOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.operationsClient.GetOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.operationsClient.ListOperations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListEndpointPolicies lists EndpointPolicies in a given project and location.
func (c *restClient) ListEndpointPolicies(ctx context.Context, req *networkservicespb.ListEndpointPoliciesRequest, opts ...gax.CallOption) *EndpointPolicyIterator {
	it := &EndpointPolicyIterator{}
	req = proto.Clone(req).(*networkservicespb.ListEndpointPoliciesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.EndpointPolicy, string, error) {
		resp := &networkservicespb.ListEndpointPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/endpointPolicies", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetEndpointPolicies(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetEndpointPolicy gets details of a single EndpointPolicy.
func (c *restClient) GetEndpointPolicy(ctx context.Context, req *networkservicespb.GetEndpointPolicyRequest, opts ...gax.CallOption) (*networkservicespb.EndpointPolicy, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetEndpointPolicy[0:len((*c.CallOptions).GetEndpointPolicy):len((*c.CallOptions).GetEndpointPolicy)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &networkservicespb.EndpointPolicy{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateEndpointPolicy creates a new EndpointPolicy in a given project and location.
func (c *restClient) CreateEndpointPolicy(ctx context.Context, req *networkservicespb.CreateEndpointPolicyRequest, opts ...gax.CallOption) (*CreateEndpointPolicyOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetEndpointPolicy()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/endpointPolicies", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("endpointPolicyId", fmt.Sprintf("%v", req.GetEndpointPolicyId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateEndpointPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateEndpointPolicy updates the parameters of a single EndpointPolicy.
func (c *restClient) UpdateEndpointPolicy(ctx context.Context, req *networkservicespb.UpdateEndpointPolicyRequest, opts ...gax.CallOption) (*UpdateEndpointPolicyOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetEndpointPolicy()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetEndpointPolicy().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "endpoint_policy.name", url.QueryEscape(req.GetEndpointPolicy().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateEndpointPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteEndpointPolicy deletes a single EndpointPolicy.
func (c *restClient) DeleteEndpointPolicy(ctx context.Context, req *networkservicespb.DeleteEndpointPolicyRequest, opts ...gax.CallOption) (*DeleteEndpointPolicyOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteEndpointPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListGateways lists Gateways in a given project and location.
func (c *restClient) ListGateways(ctx context.Context, req *networkservicespb.ListGatewaysRequest, opts ...gax.CallOption) *GatewayIterator {
	it := &GatewayIterator{}
	req = proto.Clone(req).(*networkservicespb.ListGatewaysRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.Gateway, string, error) {
		resp := &networkservicespb.ListGatewaysResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/gateways", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetGateways(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetGateway gets details of a single Gateway.
func (c *restClient) GetGateway(ctx context.Context, req *networkservicespb.GetGatewayRequest, opts ...gax.CallOption) (*networkservicespb.Gateway, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetGateway[0:len((*c.CallOptions).GetGateway):len((*c.CallOptions).GetGateway)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &networkservicespb.Gateway{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateGateway creates a new Gateway in a given project and location.
func (c *restClient) CreateGateway(ctx context.Context, req *networkservicespb.CreateGatewayRequest, opts ...gax.CallOption) (*CreateGatewayOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetGateway()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/gateways", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("gatewayId", fmt.Sprintf("%v", req.GetGatewayId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateGatewayOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateGateway updates the parameters of a single Gateway.
func (c *restClient) UpdateGateway(ctx context.Context, req *networkservicespb.UpdateGatewayRequest, opts ...gax.CallOption) (*UpdateGatewayOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetGateway()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetGateway().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "gateway.name", url.QueryEscape(req.GetGateway().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateGatewayOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteGateway deletes a single Gateway.
func (c *restClient) DeleteGateway(ctx context.Context, req *networkservicespb.DeleteGatewayRequest, opts ...gax.CallOption) (*DeleteGatewayOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteGatewayOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListGrpcRoutes lists GrpcRoutes in a given project and location.
func (c *restClient) ListGrpcRoutes(ctx context.Context, req *networkservicespb.ListGrpcRoutesRequest, opts ...gax.CallOption) *GrpcRouteIterator {
	it := &GrpcRouteIterator{}
	req = proto.Clone(req).(*networkservicespb.ListGrpcRoutesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.GrpcRoute, string, error) {
		resp := &networkservicespb.ListGrpcRoutesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/grpcRoutes", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetGrpcRoutes(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetGrpcRoute gets details of a single GrpcRoute.
func (c *restClient) GetGrpcRoute(ctx context.Context, req *networkservicespb.GetGrpcRouteRequest, opts ...gax.CallOption) (*networkservicespb.GrpcRoute, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetGrpcRoute[0:len((*c.CallOptions).GetGrpcRoute):len((*c.CallOptions).GetGrpcRoute)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &networkservicespb.GrpcRoute{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateGrpcRoute creates a new GrpcRoute in a given project and location.
func (c *restClient) CreateGrpcRoute(ctx context.Context, req *networkservicespb.CreateGrpcRouteRequest, opts ...gax.CallOption) (*CreateGrpcRouteOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetGrpcRoute()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/grpcRoutes", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("grpcRouteId", fmt.Sprintf("%v", req.GetGrpcRouteId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateGrpcRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateGrpcRoute updates the parameters of a single GrpcRoute.
func (c *restClient) UpdateGrpcRoute(ctx context.Context, req *networkservicespb.UpdateGrpcRouteRequest, opts ...gax.CallOption) (*UpdateGrpcRouteOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetGrpcRoute()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetGrpcRoute().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "grpc_route.name", url.QueryEscape(req.GetGrpcRoute().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateGrpcRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteGrpcRoute deletes a single GrpcRoute.
func (c *restClient) DeleteGrpcRoute(ctx context.Context, req *networkservicespb.DeleteGrpcRouteRequest, opts ...gax.CallOption) (*DeleteGrpcRouteOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteGrpcRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListHttpRoutes lists HttpRoute in a given project and location.
func (c *restClient) ListHttpRoutes(ctx context.Context, req *networkservicespb.ListHttpRoutesRequest, opts ...gax.CallOption) *HttpRouteIterator {
	it := &HttpRouteIterator{}
	req = proto.Clone(req).(*networkservicespb.ListHttpRoutesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.HttpRoute, string, error) {
		resp := &networkservicespb.ListHttpRoutesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/httpRoutes", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetHttpRoutes(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetHttpRoute gets details of a single HttpRoute.
func (c *restClient) GetHttpRoute(ctx context.Context, req *networkservicespb.GetHttpRouteRequest, opts ...gax.CallOption) (*networkservicespb.HttpRoute, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetHttpRoute[0:len((*c.CallOptions).GetHttpRoute):len((*c.CallOptions).GetHttpRoute)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &networkservicespb.HttpRoute{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateHttpRoute creates a new HttpRoute in a given project and location.
func (c *restClient) CreateHttpRoute(ctx context.Context, req *networkservicespb.CreateHttpRouteRequest, opts ...gax.CallOption) (*CreateHttpRouteOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetHttpRoute()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/httpRoutes", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("httpRouteId", fmt.Sprintf("%v", req.GetHttpRouteId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateHttpRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateHttpRoute updates the parameters of a single HttpRoute.
func (c *restClient) UpdateHttpRoute(ctx context.Context, req *networkservicespb.UpdateHttpRouteRequest, opts ...gax.CallOption) (*UpdateHttpRouteOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetHttpRoute()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetHttpRoute().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "http_route.name", url.QueryEscape(req.GetHttpRoute().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateHttpRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteHttpRoute deletes a single HttpRoute.
func (c *restClient) DeleteHttpRoute(ctx context.Context, req *networkservicespb.DeleteHttpRouteRequest, opts ...gax.CallOption) (*DeleteHttpRouteOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteHttpRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListTcpRoutes lists TcpRoute in a given project and location.
func (c *restClient) ListTcpRoutes(ctx context.Context, req *networkservicespb.ListTcpRoutesRequest, opts ...gax.CallOption) *TcpRouteIterator {
	it := &TcpRouteIterator{}
	req = proto.Clone(req).(*networkservicespb.ListTcpRoutesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.TcpRoute, string, error) {
		resp := &networkservicespb.ListTcpRoutesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/tcpRoutes", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetTcpRoutes(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetTcpRoute gets details of a single TcpRoute.
func (c *restClient) GetTcpRoute(ctx context.Context, req *networkservicespb.GetTcpRouteRequest, opts ...gax.CallOption) (*networkservicespb.TcpRoute, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetTcpRoute[0:len((*c.CallOptions).GetTcpRoute):len((*c.CallOptions).GetTcpRoute)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &networkservicespb.TcpRoute{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateTcpRoute creates a new TcpRoute in a given project and location.
func (c *restClient) CreateTcpRoute(ctx context.Context, req *networkservicespb.CreateTcpRouteRequest, opts ...gax.CallOption) (*CreateTcpRouteOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetTcpRoute()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/tcpRoutes", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("tcpRouteId", fmt.Sprintf("%v", req.GetTcpRouteId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateTcpRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateTcpRoute updates the parameters of a single TcpRoute.
func (c *restClient) UpdateTcpRoute(ctx context.Context, req *networkservicespb.UpdateTcpRouteRequest, opts ...gax.CallOption) (*UpdateTcpRouteOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetTcpRoute()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetTcpRoute().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "tcp_route.name", url.QueryEscape(req.GetTcpRoute().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateTcpRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteTcpRoute deletes a single TcpRoute.
func (c *restClient) DeleteTcpRoute(ctx context.Context, req *networkservicespb.DeleteTcpRouteRequest, opts ...gax.CallOption) (*DeleteTcpRouteOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteTcpRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListTlsRoutes lists TlsRoute in a given project and location.
func (c *restClient) ListTlsRoutes(ctx context.Context, req *networkservicespb.ListTlsRoutesRequest, opts ...gax.CallOption) *TlsRouteIterator {
	it := &TlsRouteIterator{}
	req = proto.Clone(req).(*networkservicespb.ListTlsRoutesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.TlsRoute, string, error) {
		resp := &networkservicespb.ListTlsRoutesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/tlsRoutes", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetTlsRoutes(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetTlsRoute gets details of a single TlsRoute.
func (c *restClient) GetTlsRoute(ctx context.Context, req *networkservicespb.GetTlsRouteRequest, opts ...gax.CallOption) (*networkservicespb.TlsRoute, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetTlsRoute[0:len((*c.CallOptions).GetTlsRoute):len((*c.CallOptions).GetTlsRoute)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &networkservicespb.TlsRoute{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateTlsRoute creates a new TlsRoute in a given project and location.
func (c *restClient) CreateTlsRoute(ctx context.Context, req *networkservicespb.CreateTlsRouteRequest, opts ...gax.CallOption) (*CreateTlsRouteOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetTlsRoute()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/tlsRoutes", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("tlsRouteId", fmt.Sprintf("%v", req.GetTlsRouteId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateTlsRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateTlsRoute updates the parameters of a single TlsRoute.
func (c *restClient) UpdateTlsRoute(ctx context.Context, req *networkservicespb.UpdateTlsRouteRequest, opts ...gax.CallOption) (*UpdateTlsRouteOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetTlsRoute()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetTlsRoute().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "tls_route.name", url.QueryEscape(req.GetTlsRoute().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateTlsRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteTlsRoute deletes a single TlsRoute.
func (c *restClient) DeleteTlsRoute(ctx context.Context, req *networkservicespb.DeleteTlsRouteRequest, opts ...gax.CallOption) (*DeleteTlsRouteOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteTlsRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListServiceBindings lists ServiceBinding in a given project and location.
func (c *restClient) ListServiceBindings(ctx context.Context, req *networkservicespb.ListServiceBindingsRequest, opts ...gax.CallOption) *ServiceBindingIterator {
	it := &ServiceBindingIterator{}
	req = proto.Clone(req).(*networkservicespb.ListServiceBindingsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.ServiceBinding, string, error) {
		resp := &networkservicespb.ListServiceBindingsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/serviceBindings", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetServiceBindings(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetServiceBinding gets details of a single ServiceBinding.
func (c *restClient) GetServiceBinding(ctx context.Context, req *networkservicespb.GetServiceBindingRequest, opts ...gax.CallOption) (*networkservicespb.ServiceBinding, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetServiceBinding[0:len((*c.CallOptions).GetServiceBinding):len((*c.CallOptions).GetServiceBinding)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &networkservicespb.ServiceBinding{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateServiceBinding creates a new ServiceBinding in a given project and location.
func (c *restClient) CreateServiceBinding(ctx context.Context, req *networkservicespb.CreateServiceBindingRequest, opts ...gax.CallOption) (*CreateServiceBindingOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetServiceBinding()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/serviceBindings", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("serviceBindingId", fmt.Sprintf("%v", req.GetServiceBindingId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateServiceBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteServiceBinding deletes a single ServiceBinding.
func (c *restClient) DeleteServiceBinding(ctx context.Context, req *networkservicespb.DeleteServiceBindingRequest, opts ...gax.CallOption) (*DeleteServiceBindingOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteServiceBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListMeshes lists Meshes in a given project and location.
func (c *restClient) ListMeshes(ctx context.Context, req *networkservicespb.ListMeshesRequest, opts ...gax.CallOption) *MeshIterator {
	it := &MeshIterator{}
	req = proto.Clone(req).(*networkservicespb.ListMeshesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkservicespb.Mesh, string, error) {
		resp := &networkservicespb.ListMeshesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/meshes", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetMeshes(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetMesh gets details of a single Mesh.
func (c *restClient) GetMesh(ctx context.Context, req *networkservicespb.GetMeshRequest, opts ...gax.CallOption) (*networkservicespb.Mesh, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetMesh[0:len((*c.CallOptions).GetMesh):len((*c.CallOptions).GetMesh)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &networkservicespb.Mesh{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateMesh creates a new Mesh in a given project and location.
func (c *restClient) CreateMesh(ctx context.Context, req *networkservicespb.CreateMeshRequest, opts ...gax.CallOption) (*CreateMeshOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetMesh()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/meshes", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("meshId", fmt.Sprintf("%v", req.GetMeshId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateMeshOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateMesh updates the parameters of a single Mesh.
func (c *restClient) UpdateMesh(ctx context.Context, req *networkservicespb.UpdateMeshRequest, opts ...gax.CallOption) (*UpdateMeshOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetMesh()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetMesh().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		updateMask, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(updateMask[1:len(updateMask)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "mesh.name", url.QueryEscape(req.GetMesh().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateMeshOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteMesh deletes a single Mesh.
func (c *restClient) DeleteMesh(ctx context.Context, req *networkservicespb.DeleteMeshRequest, opts ...gax.CallOption) (*DeleteMeshOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteMeshOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetLocation gets information about a location.
func (c *restClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &locationpb.Location{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListLocations lists information about the supported locations for this service.
func (c *restClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/locations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetIamPolicy gets the access control policy for a resource. Returns an empty policy
// if the resource exists and does not have a policy set.
func (c *restClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:getIamPolicy", req.GetResource())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetOptions().GetRequestedPolicyVersion() != 0 {
		params.Add("options.requestedPolicyVersion", fmt.Sprintf("%v", req.GetOptions().GetRequestedPolicyVersion()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &iampb.Policy{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// SetIamPolicy sets the access control policy on the specified resource. Replaces
// any existing policy.
//
// Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED
// errors.
func (c *restClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:setIamPolicy", req.GetResource())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &iampb.Policy{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// TestIamPermissions returns permissions that a caller has on the specified resource. If the
// resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.
//
// Note: This operation is designed to be used for building
// permission-aware UIs and command-line tools, not for authorization
// checking. This operation may “fail open” without warning.
func (c *restClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:testIamPermissions", req.GetResource())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &iampb.TestIamPermissionsResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *restClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *restClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *restClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *restClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/operations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateEndpointPolicyOperation returns a new CreateEndpointPolicyOperation from a given name.
// The name must be that of a previously created CreateEndpointPolicyOperation, possibly from a different process.
func (c *gRPCClient) CreateEndpointPolicyOperation(name string) *CreateEndpointPolicyOperation {
	return &CreateEndpointPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateEndpointPolicyOperation returns a new CreateEndpointPolicyOperation from a given name.
// The name must be that of a previously created CreateEndpointPolicyOperation, possibly from a different process.
func (c *restClient) CreateEndpointPolicyOperation(name string) *CreateEndpointPolicyOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateEndpointPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateGatewayOperation returns a new CreateGatewayOperation from a given name.
// The name must be that of a previously created CreateGatewayOperation, possibly from a different process.
func (c *gRPCClient) CreateGatewayOperation(name string) *CreateGatewayOperation {
	return &CreateGatewayOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateGatewayOperation returns a new CreateGatewayOperation from a given name.
// The name must be that of a previously created CreateGatewayOperation, possibly from a different process.
func (c *restClient) CreateGatewayOperation(name string) *CreateGatewayOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateGatewayOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateGrpcRouteOperation returns a new CreateGrpcRouteOperation from a given name.
// The name must be that of a previously created CreateGrpcRouteOperation, possibly from a different process.
func (c *gRPCClient) CreateGrpcRouteOperation(name string) *CreateGrpcRouteOperation {
	return &CreateGrpcRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateGrpcRouteOperation returns a new CreateGrpcRouteOperation from a given name.
// The name must be that of a previously created CreateGrpcRouteOperation, possibly from a different process.
func (c *restClient) CreateGrpcRouteOperation(name string) *CreateGrpcRouteOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateGrpcRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateHttpRouteOperation returns a new CreateHttpRouteOperation from a given name.
// The name must be that of a previously created CreateHttpRouteOperation, possibly from a different process.
func (c *gRPCClient) CreateHttpRouteOperation(name string) *CreateHttpRouteOperation {
	return &CreateHttpRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateHttpRouteOperation returns a new CreateHttpRouteOperation from a given name.
// The name must be that of a previously created CreateHttpRouteOperation, possibly from a different process.
func (c *restClient) CreateHttpRouteOperation(name string) *CreateHttpRouteOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateHttpRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateMeshOperation returns a new CreateMeshOperation from a given name.
// The name must be that of a previously created CreateMeshOperation, possibly from a different process.
func (c *gRPCClient) CreateMeshOperation(name string) *CreateMeshOperation {
	return &CreateMeshOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateMeshOperation returns a new CreateMeshOperation from a given name.
// The name must be that of a previously created CreateMeshOperation, possibly from a different process.
func (c *restClient) CreateMeshOperation(name string) *CreateMeshOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateMeshOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateServiceBindingOperation returns a new CreateServiceBindingOperation from a given name.
// The name must be that of a previously created CreateServiceBindingOperation, possibly from a different process.
func (c *gRPCClient) CreateServiceBindingOperation(name string) *CreateServiceBindingOperation {
	return &CreateServiceBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateServiceBindingOperation returns a new CreateServiceBindingOperation from a given name.
// The name must be that of a previously created CreateServiceBindingOperation, possibly from a different process.
func (c *restClient) CreateServiceBindingOperation(name string) *CreateServiceBindingOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateServiceBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateTcpRouteOperation returns a new CreateTcpRouteOperation from a given name.
// The name must be that of a previously created CreateTcpRouteOperation, possibly from a different process.
func (c *gRPCClient) CreateTcpRouteOperation(name string) *CreateTcpRouteOperation {
	return &CreateTcpRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateTcpRouteOperation returns a new CreateTcpRouteOperation from a given name.
// The name must be that of a previously created CreateTcpRouteOperation, possibly from a different process.
func (c *restClient) CreateTcpRouteOperation(name string) *CreateTcpRouteOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateTcpRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateTlsRouteOperation returns a new CreateTlsRouteOperation from a given name.
// The name must be that of a previously created CreateTlsRouteOperation, possibly from a different process.
func (c *gRPCClient) CreateTlsRouteOperation(name string) *CreateTlsRouteOperation {
	return &CreateTlsRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateTlsRouteOperation returns a new CreateTlsRouteOperation from a given name.
// The name must be that of a previously created CreateTlsRouteOperation, possibly from a different process.
func (c *restClient) CreateTlsRouteOperation(name string) *CreateTlsRouteOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateTlsRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteEndpointPolicyOperation returns a new DeleteEndpointPolicyOperation from a given name.
// The name must be that of a previously created DeleteEndpointPolicyOperation, possibly from a different process.
func (c *gRPCClient) DeleteEndpointPolicyOperation(name string) *DeleteEndpointPolicyOperation {
	return &DeleteEndpointPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteEndpointPolicyOperation returns a new DeleteEndpointPolicyOperation from a given name.
// The name must be that of a previously created DeleteEndpointPolicyOperation, possibly from a different process.
func (c *restClient) DeleteEndpointPolicyOperation(name string) *DeleteEndpointPolicyOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteEndpointPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteGatewayOperation returns a new DeleteGatewayOperation from a given name.
// The name must be that of a previously created DeleteGatewayOperation, possibly from a different process.
func (c *gRPCClient) DeleteGatewayOperation(name string) *DeleteGatewayOperation {
	return &DeleteGatewayOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteGatewayOperation returns a new DeleteGatewayOperation from a given name.
// The name must be that of a previously created DeleteGatewayOperation, possibly from a different process.
func (c *restClient) DeleteGatewayOperation(name string) *DeleteGatewayOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteGatewayOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteGrpcRouteOperation returns a new DeleteGrpcRouteOperation from a given name.
// The name must be that of a previously created DeleteGrpcRouteOperation, possibly from a different process.
func (c *gRPCClient) DeleteGrpcRouteOperation(name string) *DeleteGrpcRouteOperation {
	return &DeleteGrpcRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteGrpcRouteOperation returns a new DeleteGrpcRouteOperation from a given name.
// The name must be that of a previously created DeleteGrpcRouteOperation, possibly from a different process.
func (c *restClient) DeleteGrpcRouteOperation(name string) *DeleteGrpcRouteOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteGrpcRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteHttpRouteOperation returns a new DeleteHttpRouteOperation from a given name.
// The name must be that of a previously created DeleteHttpRouteOperation, possibly from a different process.
func (c *gRPCClient) DeleteHttpRouteOperation(name string) *DeleteHttpRouteOperation {
	return &DeleteHttpRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteHttpRouteOperation returns a new DeleteHttpRouteOperation from a given name.
// The name must be that of a previously created DeleteHttpRouteOperation, possibly from a different process.
func (c *restClient) DeleteHttpRouteOperation(name string) *DeleteHttpRouteOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteHttpRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteMeshOperation returns a new DeleteMeshOperation from a given name.
// The name must be that of a previously created DeleteMeshOperation, possibly from a different process.
func (c *gRPCClient) DeleteMeshOperation(name string) *DeleteMeshOperation {
	return &DeleteMeshOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteMeshOperation returns a new DeleteMeshOperation from a given name.
// The name must be that of a previously created DeleteMeshOperation, possibly from a different process.
func (c *restClient) DeleteMeshOperation(name string) *DeleteMeshOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteMeshOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteServiceBindingOperation returns a new DeleteServiceBindingOperation from a given name.
// The name must be that of a previously created DeleteServiceBindingOperation, possibly from a different process.
func (c *gRPCClient) DeleteServiceBindingOperation(name string) *DeleteServiceBindingOperation {
	return &DeleteServiceBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteServiceBindingOperation returns a new DeleteServiceBindingOperation from a given name.
// The name must be that of a previously created DeleteServiceBindingOperation, possibly from a different process.
func (c *restClient) DeleteServiceBindingOperation(name string) *DeleteServiceBindingOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteServiceBindingOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteTcpRouteOperation returns a new DeleteTcpRouteOperation from a given name.
// The name must be that of a previously created DeleteTcpRouteOperation, possibly from a different process.
func (c *gRPCClient) DeleteTcpRouteOperation(name string) *DeleteTcpRouteOperation {
	return &DeleteTcpRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteTcpRouteOperation returns a new DeleteTcpRouteOperation from a given name.
// The name must be that of a previously created DeleteTcpRouteOperation, possibly from a different process.
func (c *restClient) DeleteTcpRouteOperation(name string) *DeleteTcpRouteOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteTcpRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteTlsRouteOperation returns a new DeleteTlsRouteOperation from a given name.
// The name must be that of a previously created DeleteTlsRouteOperation, possibly from a different process.
func (c *gRPCClient) DeleteTlsRouteOperation(name string) *DeleteTlsRouteOperation {
	return &DeleteTlsRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteTlsRouteOperation returns a new DeleteTlsRouteOperation from a given name.
// The name must be that of a previously created DeleteTlsRouteOperation, possibly from a different process.
func (c *restClient) DeleteTlsRouteOperation(name string) *DeleteTlsRouteOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteTlsRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateEndpointPolicyOperation returns a new UpdateEndpointPolicyOperation from a given name.
// The name must be that of a previously created UpdateEndpointPolicyOperation, possibly from a different process.
func (c *gRPCClient) UpdateEndpointPolicyOperation(name string) *UpdateEndpointPolicyOperation {
	return &UpdateEndpointPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateEndpointPolicyOperation returns a new UpdateEndpointPolicyOperation from a given name.
// The name must be that of a previously created UpdateEndpointPolicyOperation, possibly from a different process.
func (c *restClient) UpdateEndpointPolicyOperation(name string) *UpdateEndpointPolicyOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateEndpointPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateGatewayOperation returns a new UpdateGatewayOperation from a given name.
// The name must be that of a previously created UpdateGatewayOperation, possibly from a different process.
func (c *gRPCClient) UpdateGatewayOperation(name string) *UpdateGatewayOperation {
	return &UpdateGatewayOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateGatewayOperation returns a new UpdateGatewayOperation from a given name.
// The name must be that of a previously created UpdateGatewayOperation, possibly from a different process.
func (c *restClient) UpdateGatewayOperation(name string) *UpdateGatewayOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateGatewayOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateGrpcRouteOperation returns a new UpdateGrpcRouteOperation from a given name.
// The name must be that of a previously created UpdateGrpcRouteOperation, possibly from a different process.
func (c *gRPCClient) UpdateGrpcRouteOperation(name string) *UpdateGrpcRouteOperation {
	return &UpdateGrpcRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateGrpcRouteOperation returns a new UpdateGrpcRouteOperation from a given name.
// The name must be that of a previously created UpdateGrpcRouteOperation, possibly from a different process.
func (c *restClient) UpdateGrpcRouteOperation(name string) *UpdateGrpcRouteOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateGrpcRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateHttpRouteOperation returns a new UpdateHttpRouteOperation from a given name.
// The name must be that of a previously created UpdateHttpRouteOperation, possibly from a different process.
func (c *gRPCClient) UpdateHttpRouteOperation(name string) *UpdateHttpRouteOperation {
	return &UpdateHttpRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateHttpRouteOperation returns a new UpdateHttpRouteOperation from a given name.
// The name must be that of a previously created UpdateHttpRouteOperation, possibly from a different process.
func (c *restClient) UpdateHttpRouteOperation(name string) *UpdateHttpRouteOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateHttpRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateMeshOperation returns a new UpdateMeshOperation from a given name.
// The name must be that of a previously created UpdateMeshOperation, possibly from a different process.
func (c *gRPCClient) UpdateMeshOperation(name string) *UpdateMeshOperation {
	return &UpdateMeshOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateMeshOperation returns a new UpdateMeshOperation from a given name.
// The name must be that of a previously created UpdateMeshOperation, possibly from a different process.
func (c *restClient) UpdateMeshOperation(name string) *UpdateMeshOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateMeshOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateTcpRouteOperation returns a new UpdateTcpRouteOperation from a given name.
// The name must be that of a previously created UpdateTcpRouteOperation, possibly from a different process.
func (c *gRPCClient) UpdateTcpRouteOperation(name string) *UpdateTcpRouteOperation {
	return &UpdateTcpRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateTcpRouteOperation returns a new UpdateTcpRouteOperation from a given name.
// The name must be that of a previously created UpdateTcpRouteOperation, possibly from a different process.
func (c *restClient) UpdateTcpRouteOperation(name string) *UpdateTcpRouteOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateTcpRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateTlsRouteOperation returns a new UpdateTlsRouteOperation from a given name.
// The name must be that of a previously created UpdateTlsRouteOperation, possibly from a different process.
func (c *gRPCClient) UpdateTlsRouteOperation(name string) *UpdateTlsRouteOperation {
	return &UpdateTlsRouteOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateTlsRouteOperation returns a new UpdateTlsRouteOperation from a given name.
// The name must be that of a previously created UpdateTlsRouteOperation, possibly from a different process.
func (c *restClient) UpdateTlsRouteOperation(name string) *UpdateTlsRouteOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateTlsRouteOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
