import unittest
import warnings

from iotas.attachment import Attachment

warnings.filterwarnings("ignore", "version")


class Test(unittest.TestCase):

    def test_duplicate(self) -> None:
        attachment = Attachment()
        attachment.note_id = 1
        attachment.note_remote_id = 2
        attachment.path = "image.png"

        dupe = attachment.duplicate()
        self.assertIsNotNone(dupe)
        self.assertEqual(dupe.note_id, 1)
        self.assertEqual(dupe.note_remote_id, 2)
        self.assertEqual(dupe.path, "image.png")

    def test_filename(self) -> None:
        attachment = Attachment()
        attachment.path = "dir/subdir/image.png"
        self.assertEqual(attachment.filename, "image.png")

    def test_path_quoted(self) -> None:
        attachment = Attachment()
        attachment.path = "image (1).png"
        self.assertEqual(attachment.path_quoted, "image%20%281%29.png")
