; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=arm-linux-gnueabi -asm-verbose=false -verify-machineinstrs | FileCheck %s -check-prefix=CHECK-ARM
; RUN: llc < %s -mtriple=thumb-linux-gnueabi -asm-verbose=false -verify-machineinstrs | FileCheck %s -check-prefix=CHECK-THUMB

; RUN: llc < %s -mtriple=armv6-linux-gnueabi -asm-verbose=false -verify-machineinstrs | FileCheck %s -check-prefix=CHECK-ARMV6
; RUN: llc < %s -mtriple=thumbv6-linux-gnueabi -asm-verbose=false -verify-machineinstrs | FileCheck %s -check-prefix=CHECK-THUMBV6

; RUN: llc < %s -mtriple=armv7-linux-gnueabi -asm-verbose=false -verify-machineinstrs | FileCheck %s -check-prefix=CHECK-ARMV7
; RUN: llc < %s -mtriple=thumbv7-linux-gnueabi -asm-verbose=false -verify-machineinstrs | FileCheck %s -check-prefix=CHECK-THUMBV7

define zeroext i1 @test_cmpxchg_res_i8(ptr %addr, i8 %desired, i8 zeroext %new) {
; CHECK-ARM-LABEL: test_cmpxchg_res_i8:
; CHECK-ARM:         .save {r4, lr}
; CHECK-ARM-NEXT:    push {r4, lr}
; CHECK-ARM-NEXT:    mov r4, r1
; CHECK-ARM-NEXT:    bl __sync_val_compare_and_swap_1
; CHECK-ARM-NEXT:    and r1, r4, #255
; CHECK-ARM-NEXT:    sub r0, r0, r1
; CHECK-ARM-NEXT:    rsbs r1, r0, #0
; CHECK-ARM-NEXT:    adc r0, r0, r1
; CHECK-ARM-NEXT:    pop {r4, lr}
; CHECK-ARM-NEXT:    mov pc, lr
;
; CHECK-THUMB-LABEL: test_cmpxchg_res_i8:
; CHECK-THUMB:         .save {r4, lr}
; CHECK-THUMB-NEXT:    push {r4, lr}
; CHECK-THUMB-NEXT:    movs r4, r1
; CHECK-THUMB-NEXT:    bl __sync_val_compare_and_swap_1
; CHECK-THUMB-NEXT:    movs r1, #255
; CHECK-THUMB-NEXT:    ands r1, r4
; CHECK-THUMB-NEXT:    subs r1, r0, r1
; CHECK-THUMB-NEXT:    rsbs r0, r1, #0
; CHECK-THUMB-NEXT:    adcs r0, r1
; CHECK-THUMB-NEXT:    pop {r4}
; CHECK-THUMB-NEXT:    pop {r1}
; CHECK-THUMB-NEXT:    bx r1
;
; CHECK-ARMV6-LABEL: test_cmpxchg_res_i8:
; CHECK-ARMV6:         .fnstart
; CHECK-ARMV6-NEXT:    uxtb r12, r1
; CHECK-ARMV6-NEXT:  .LBB0_1:
; CHECK-ARMV6-NEXT:    ldrexb r1, [r0]
; CHECK-ARMV6-NEXT:    cmp r1, r12
; CHECK-ARMV6-NEXT:    movne r0, #0
; CHECK-ARMV6-NEXT:    bxne lr
; CHECK-ARMV6-NEXT:  .LBB0_2:
; CHECK-ARMV6-NEXT:    strexb r3, r2, [r0]
; CHECK-ARMV6-NEXT:    mov r1, #1
; CHECK-ARMV6-NEXT:    cmp r3, #0
; CHECK-ARMV6-NEXT:    moveq r0, r1
; CHECK-ARMV6-NEXT:    bxeq lr
; CHECK-ARMV6-NEXT:    b .LBB0_1
;
; CHECK-THUMBV6-LABEL: test_cmpxchg_res_i8:
; CHECK-THUMBV6:         .save {r4, lr}
; CHECK-THUMBV6-NEXT:    push {r4, lr}
; CHECK-THUMBV6-NEXT:    mov r4, r1
; CHECK-THUMBV6-NEXT:    bl __sync_val_compare_and_swap_1
; CHECK-THUMBV6-NEXT:    uxtb r1, r4
; CHECK-THUMBV6-NEXT:    subs r1, r0, r1
; CHECK-THUMBV6-NEXT:    rsbs r0, r1, #0
; CHECK-THUMBV6-NEXT:    adcs r0, r1
; CHECK-THUMBV6-NEXT:    pop {r4, pc}
;
; CHECK-ARMV7-LABEL: test_cmpxchg_res_i8:
; CHECK-ARMV7:         .fnstart
; CHECK-ARMV7-NEXT:    uxtb r12, r1
; CHECK-ARMV7-NEXT:  .LBB0_1:
; CHECK-ARMV7-NEXT:    ldrexb r1, [r0]
; CHECK-ARMV7-NEXT:    cmp r1, r12
; CHECK-ARMV7-NEXT:    bne .LBB0_4
; CHECK-ARMV7-NEXT:    strexb r3, r2, [r0]
; CHECK-ARMV7-NEXT:    mov r1, #1
; CHECK-ARMV7-NEXT:    cmp r3, #0
; CHECK-ARMV7-NEXT:    bne .LBB0_1 
; CHECK-ARMV7-NEXT:    mov r0, r1
; CHECK-ARMV7-NEXT:    bx lr
; CHECK-ARMV7-NEXT:  .LBB0_4:
; CHECK-ARMV7-NEXT:    mov r1, #0
; CHECK-ARMV7-NEXT:    clrex
; CHECK-ARMV7-NEXT:    mov r0, r1
; CHECK-ARMV7-NEXT:    bx lr
;
; CHECK-THUMBV7-LABEL: test_cmpxchg_res_i8:
; CHECK-THUMBV7:         uxtb r1, r1
; CHECK-THUMBV7-NEXT:  .LBB0_1:
; CHECK-THUMBV7-NEXT:    ldrexb r3, [r0]
; CHECK-THUMBV7-NEXT:    cmp r3, r1
; CHECK-THUMBV7-NEXT:    bne .LBB0_3
; CHECK-THUMBV7-NEXT:    strexb r3, r2, [r0]
; CHECK-THUMBV7-NEXT:    cmp r3, #0
; CHECK-THUMBV7-NEXT:    itt eq
; CHECK-THUMBV7-NEXT:    moveq r0, #1
; CHECK-THUMBV7-NEXT:    bxeq lr
; CHECK-THUMBV7-NEXT:    b .LBB0_1
; CHECK-THUMBV7-NEXT:  .LBB0_3:
; CHECK-THUMBV7-NEXT:    movs r0, #0
; CHECK-THUMBV7-NEXT:    clrex
; CHECK-THUMBV7-NEXT:    bx lr
entry:
  %0 = cmpxchg ptr %addr, i8 %desired, i8 %new monotonic monotonic
  %1 = extractvalue { i8, i1 } %0, 1
  ret i1 %1
}
