import numpy
from numpy import array, nan, inf

version = '2.0.0'
cuda    = '7.0'
device  = 'Kepler K40c'
cpu     = '2x8 core Sandy Bridge E5-2670'

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/cgeqrf.txt
# numactl --interleave=all ../testing/testing_cgeqrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeqrf = array([
	[    10,     10,  nan,  nan,     0.03,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.21,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.63,   0.00,  nan ],
	[    40,     40,  nan,  nan,     1.38,   0.00,  nan ],
	[    50,     50,  nan,  nan,     2.33,   0.00,  nan ],
	[    60,     60,  nan,  nan,     3.39,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.95,   0.00,  nan ],
	[    80,     80,  nan,  nan,     2.80,   0.00,  nan ],
	[    90,     90,  nan,  nan,     3.22,   0.00,  nan ],
	[   100,    100,  nan,  nan,     4.96,   0.00,  nan ],
	[   200,    200,  nan,  nan,    17.26,   0.00,  nan ],
	[   300,    300,  nan,  nan,    39.33,   0.00,  nan ],
	[   400,    400,  nan,  nan,    62.66,   0.01,  nan ],
	[   500,    500,  nan,  nan,    92.62,   0.01,  nan ],
	[   600,    600,  nan,  nan,   120.91,   0.01,  nan ],
	[   700,    700,  nan,  nan,   154.35,   0.01,  nan ],
	[   800,    800,  nan,  nan,   183.25,   0.01,  nan ],
	[   900,    900,  nan,  nan,   216.61,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,   251.76,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   637.35,   0.07,  nan ],
	[  3000,   3000,  nan,  nan,   835.71,   0.17,  nan ],
	[  4000,   4000,  nan,  nan,  1139.10,   0.30,  nan ],
	[  5000,   5000,  nan,  nan,  1614.96,   0.41,  nan ],
	[  6000,   6000,  nan,  nan,  1849.25,   0.62,  nan ],
	[  7000,   7000,  nan,  nan,  2001.77,   0.91,  nan ],
	[  8000,   8000,  nan,  nan,  2121.95,   1.29,  nan ],
	[  9000,   9000,  nan,  nan,  2194.95,   1.77,  nan ],
	[ 10000,  10000,  nan,  nan,  2253.10,   2.37,  nan ],
	[ 12000,  12000,  nan,  nan,  2335.09,   3.95,  nan ],
	[ 14000,  14000,  nan,  nan,  2384.30,   6.14,  nan ],
	[ 16000,  16000,  nan,  nan,  2407.06,   9.08,  nan ],
	[ 18000,  18000,  nan,  nan,  2422.32,  12.84,  nan ],
	[ 20000,  20000,  nan,  nan,  2459.15,  17.35,  nan ],
])

# numactl --interleave=all ../testing/testing_cgeqrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.00,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.04,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.12,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.27,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.50,   0.00,  nan ],
	[    60,     60,  nan,  nan,     0.85,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.06,   0.00,  nan ],
	[    80,     80,  nan,  nan,     1.55,   0.00,  nan ],
	[    90,     90,  nan,  nan,     2.09,   0.00,  nan ],
	[   100,    100,  nan,  nan,     5.61,   0.00,  nan ],
	[   200,    200,  nan,  nan,    12.84,   0.00,  nan ],
	[   300,    300,  nan,  nan,    31.01,   0.00,  nan ],
	[   400,    400,  nan,  nan,    51.59,   0.01,  nan ],
	[   500,    500,  nan,  nan,    77.84,   0.01,  nan ],
	[   600,    600,  nan,  nan,   105.33,   0.01,  nan ],
	[   700,    700,  nan,  nan,   137.06,   0.01,  nan ],
	[   800,    800,  nan,  nan,   167.70,   0.02,  nan ],
	[   900,    900,  nan,  nan,   196.97,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,   234.10,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   604.80,   0.07,  nan ],
	[  3000,   3000,  nan,  nan,  1014.24,   0.14,  nan ],
	[  4000,   4000,  nan,  nan,  1392.96,   0.25,  nan ],
	[  5000,   5000,  nan,  nan,  1410.27,   0.47,  nan ],
	[  6000,   6000,  nan,  nan,  1696.41,   0.68,  nan ],
	[  7000,   7000,  nan,  nan,  1928.78,   0.95,  nan ],
	[  8000,   8000,  nan,  nan,  2048.87,   1.33,  nan ],
	[  9000,   9000,  nan,  nan,  2133.31,   1.82,  nan ],
	[ 10000,  10000,  nan,  nan,  2208.32,   2.42,  nan ],
	[ 12000,  12000,  nan,  nan,  2320.47,   3.97,  nan ],
	[ 14000,  14000,  nan,  nan,  2378.70,   6.15,  nan ],
	[ 16000,  16000,  nan,  nan,  2411.01,   9.06,  nan ],
	[ 18000,  18000,  nan,  nan,  2430.66,  12.80,  nan ],
	[ 20000,  20000,  nan,  nan,  2474.69,  17.24,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/cgesvd.txt
# numactl --interleave=all ../testing/testing_cgesvd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
cgesvd_UN = array([
	[ nan,      10,      10,  nan,   0.00,  nan ],
	[ nan,      20,      20,  nan,   0.00,  nan ],
	[ nan,      30,      30,  nan,   0.00,  nan ],
	[ nan,      40,      40,  nan,   0.00,  nan ],
	[ nan,      50,      50,  nan,   0.00,  nan ],
	[ nan,      60,      60,  nan,   0.00,  nan ],
	[ nan,      70,      70,  nan,   0.00,  nan ],
	[ nan,      80,      80,  nan,   0.00,  nan ],
	[ nan,      90,      90,  nan,   0.00,  nan ],
	[ nan,     100,     100,  nan,   0.00,  nan ],
	[ nan,     200,     200,  nan,   0.01,  nan ],
	[ nan,     300,     300,  nan,   0.03,  nan ],
	[ nan,     400,     400,  nan,   0.05,  nan ],
	[ nan,     500,     500,  nan,   0.08,  nan ],
	[ nan,     600,     600,  nan,   0.11,  nan ],
	[ nan,     700,     700,  nan,   0.15,  nan ],
	[ nan,     800,     800,  nan,   0.19,  nan ],
	[ nan,     900,     900,  nan,   0.24,  nan ],
	[ nan,    1000,    1000,  nan,   0.29,  nan ],
	[ nan,    2000,    2000,  nan,   1.14,  nan ],
	[ nan,    3000,    3000,  nan,   2.94,  nan ],
	[ nan,    4000,    4000,  nan,   5.85,  nan ],
	[ nan,    5000,    5000,  nan,  10.14,  nan ],
	[ nan,    6000,    6000,  nan,  16.06,  nan ],
	[ nan,    7000,    7000,  nan,  23.87,  nan ],
	[ nan,    8000,    8000,  nan,  34.14,  nan ],
	[ nan,    9000,    9000,  nan,  46.82,  nan ],
	[ nan,   10000,   10000,  nan,  62.64,  nan ],
	[ nan,     300,     100,  nan,   0.00,  nan ],
	[ nan,     600,     200,  nan,   0.02,  nan ],
	[ nan,     900,     300,  nan,   0.04,  nan ],
	[ nan,    1200,     400,  nan,   0.07,  nan ],
	[ nan,    1500,     500,  nan,   0.10,  nan ],
	[ nan,    1800,     600,  nan,   0.14,  nan ],
	[ nan,    2100,     700,  nan,   0.19,  nan ],
	[ nan,    2400,     800,  nan,   0.25,  nan ],
	[ nan,    2700,     900,  nan,   0.33,  nan ],
	[ nan,    3000,    1000,  nan,   0.40,  nan ],
	[ nan,    6000,    2000,  nan,   1.74,  nan ],
	[ nan,    9000,    3000,  nan,   4.66,  nan ],
	[ nan,   12000,    4000,  nan,   9.57,  nan ],
	[ nan,   15000,    5000,  nan,  17.05,  nan ],
	[ nan,   18000,    6000,  nan,  27.53,  nan ],
	[ nan,   21000,    7000,  nan,  41.54,  nan ],
	[ nan,   24000,    8000,  nan,  60.43,  nan ],
	[ nan,   27000,    9000,  nan,  83.63,  nan ],
	[ nan,     100,     300,  nan,   0.00,  nan ],
	[ nan,     200,     600,  nan,   0.02,  nan ],
	[ nan,     300,     900,  nan,   0.04,  nan ],
	[ nan,     400,    1200,  nan,   0.07,  nan ],
	[ nan,     500,    1500,  nan,   0.11,  nan ],
	[ nan,     600,    1800,  nan,   0.16,  nan ],
	[ nan,     700,    2100,  nan,   0.21,  nan ],
	[ nan,     800,    2400,  nan,   0.27,  nan ],
	[ nan,     900,    2700,  nan,   0.33,  nan ],
	[ nan,    1000,    3000,  nan,   0.41,  nan ],
	[ nan,    2000,    6000,  nan,   1.76,  nan ],
	[ nan,    3000,    9000,  nan,   4.72,  nan ],
	[ nan,    4000,   12000,  nan,   9.72,  nan ],
	[ nan,    5000,   15000,  nan,  17.39,  nan ],
	[ nan,    6000,   18000,  nan,  28.11,  nan ],
	[ nan,    7000,   21000,  nan,  42.57,  nan ],
	[ nan,    8000,   24000,  nan,  61.30,  nan ],
	[ nan,    9000,   27000,  nan,  85.19,  nan ],
	[ nan,   10000,     100,  nan,   0.03,  nan ],
	[ nan,   20000,     200,  nan,   0.08,  nan ],
	[ nan,   30000,     300,  nan,   0.27,  nan ],
	[ nan,   40000,     400,  nan,   0.51,  nan ],
	[ nan,   50000,     500,  nan,   1.11,  nan ],
	[ nan,   60000,     600,  nan,   1.19,  nan ],
	[ nan,   70000,     700,  nan,   1.62,  nan ],
	[ nan,   80000,     800,  nan,   2.20,  nan ],
	[ nan,   90000,     900,  nan,   3.32,  nan ],
	[ nan,  100000,    1000,  nan,   4.15,  nan ],
	[ nan,  200000,    2000,  nan,  24.47,  nan ],
	[ nan,     100,   10000,  nan,   0.02,  nan ],
	[ nan,     200,   20000,  nan,   0.09,  nan ],
	[ nan,     300,   30000,  nan,   0.23,  nan ],
	[ nan,     400,   40000,  nan,   0.45,  nan ],
	[ nan,     500,   50000,  nan,   0.78,  nan ],
	[ nan,     600,   60000,  nan,   1.26,  nan ],
	[ nan,     700,   70000,  nan,   1.90,  nan ],
	[ nan,     800,   80000,  nan,   2.82,  nan ],
	[ nan,     900,   90000,  nan,   3.48,  nan ],
	[ nan,    1000,  100000,  nan,   4.47,  nan ],
	[ nan,    2000,  200000,  nan,  28.57,  nan ],
])

# numactl --interleave=all ../testing/testing_cgesvd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
cgesvd_US = array([
	[ nan,      10,      10,  nan,     0.00,  nan ],
	[ nan,      20,      20,  nan,     0.00,  nan ],
	[ nan,      30,      30,  nan,     0.00,  nan ],
	[ nan,      40,      40,  nan,     0.00,  nan ],
	[ nan,      50,      50,  nan,     0.00,  nan ],
	[ nan,      60,      60,  nan,     0.01,  nan ],
	[ nan,      70,      70,  nan,     0.01,  nan ],
	[ nan,      80,      80,  nan,     0.01,  nan ],
	[ nan,      90,      90,  nan,     0.01,  nan ],
	[ nan,     100,     100,  nan,     0.02,  nan ],
	[ nan,     200,     200,  nan,     0.02,  nan ],
	[ nan,     300,     300,  nan,     0.05,  nan ],
	[ nan,     400,     400,  nan,     0.09,  nan ],
	[ nan,     500,     500,  nan,     0.15,  nan ],
	[ nan,     600,     600,  nan,     0.21,  nan ],
	[ nan,     700,     700,  nan,     0.29,  nan ],
	[ nan,     800,     800,  nan,     0.38,  nan ],
	[ nan,     900,     900,  nan,     0.49,  nan ],
	[ nan,    1000,    1000,  nan,     0.62,  nan ],
	[ nan,    2000,    2000,  nan,     3.06,  nan ],
	[ nan,    3000,    3000,  nan,     9.19,  nan ],
	[ nan,    4000,    4000,  nan,    19.73,  nan ],
	[ nan,    5000,    5000,  nan,    38.32,  nan ],
	[ nan,    6000,    6000,  nan,    64.95,  nan ],
	[ nan,    7000,    7000,  nan,   104.35,  nan ],
	[ nan,    8000,    8000,  nan,   152.36,  nan ],
	[ nan,    9000,    9000,  nan,   228.85,  nan ],
	[ nan,   10000,   10000,  nan,   318.21,  nan ],
	[ nan,     300,     100,  nan,     0.03,  nan ],
	[ nan,     600,     200,  nan,     0.04,  nan ],
	[ nan,     900,     300,  nan,     0.08,  nan ],
	[ nan,    1200,     400,  nan,     0.15,  nan ],
	[ nan,    1500,     500,  nan,     0.23,  nan ],
	[ nan,    1800,     600,  nan,     0.35,  nan ],
	[ nan,    2100,     700,  nan,     0.49,  nan ],
	[ nan,    2400,     800,  nan,     0.65,  nan ],
	[ nan,    2700,     900,  nan,     0.85,  nan ],
	[ nan,    3000,    1000,  nan,     1.16,  nan ],
	[ nan,    6000,    2000,  nan,     6.55,  nan ],
	[ nan,    9000,    3000,  nan,    18.25,  nan ],
	[ nan,   12000,    4000,  nan,    32.23,  nan ],
	[ nan,   15000,    5000,  nan,    54.41,  nan ],
	[ nan,   18000,    6000,  nan,    91.60,  nan ],
	[ nan,   21000,    7000,  nan,   142.99,  nan ],
	[ nan,   24000,    8000,  nan,   199.30,  nan ],
	[ nan,   27000,    9000,  nan,   291.64,  nan ],
	[ nan,     100,     300,  nan,     0.02,  nan ],
	[ nan,     200,     600,  nan,     0.07,  nan ],
	[ nan,     300,     900,  nan,     0.20,  nan ],
	[ nan,     400,    1200,  nan,     0.42,  nan ],
	[ nan,     500,    1500,  nan,     0.76,  nan ],
	[ nan,     600,    1800,  nan,     1.26,  nan ],
	[ nan,     700,    2100,  nan,     2.00,  nan ],
	[ nan,     800,    2400,  nan,     2.84,  nan ],
	[ nan,     900,    2700,  nan,     3.92,  nan ],
	[ nan,    1000,    3000,  nan,     5.81,  nan ],
	[ nan,    2000,    6000,  nan,    45.92,  nan ],
	[ nan,    3000,    9000,  nan,   150.94,  nan ],
	[ nan,    4000,   12000,  nan,   344.05,  nan ],
	[ nan,    5000,   15000,  nan,   662.96,  nan ],
	[ nan,    6000,   18000,  nan,  1134.65,  nan ],
	[ nan,    7000,   21000,  nan,  1763.91,  nan ],
	[ nan,    8000,   24000,  nan,  2454.96,  nan ],
	[ nan,    9000,   27000,  nan,  3673.78,  nan ],
	[ nan,   10000,     100,  nan,     0.07,  nan ],
	[ nan,   20000,     200,  nan,     0.20,  nan ],
	[ nan,   30000,     300,  nan,     0.53,  nan ],
	[ nan,   40000,     400,  nan,     1.18,  nan ],
	[ nan,   50000,     500,  nan,     1.98,  nan ],
	[ nan,   60000,     600,  nan,     3.21,  nan ],
	[ nan,   70000,     700,  nan,     4.66,  nan ],
	[ nan,   80000,     800,  nan,     6.69,  nan ],
	[ nan,   90000,     900,  nan,     9.56,  nan ],
	[ nan,  100000,    1000,  nan,    12.59,  nan ],
	[ nan,  200000,    2000,  nan,    88.63,  nan ],
	[ nan,     100,   10000,  nan,     0.23,  nan ],
	[ nan,     200,   20000,  nan,     1.97,  nan ],
	[ nan,     300,   30000,  nan,     6.28,  nan ],
	[ nan,     400,   40000,  nan,    14.25,  nan ],
	[ nan,     500,   50000,  nan,    25.16,  nan ],
	[ nan,     600,   60000,  nan,    44.44,  nan ],
	[ nan,     700,   70000,  nan,    67.91,  nan ],
	[ nan,     800,   80000,  nan,   104.45,  nan ],
	[ nan,     900,   90000,  nan,   144.65,  nan ],
	[ nan,    1000,  100000,  nan,   191.75,  nan ],
	[ nan,    2000,  200000,  nan,  1503.65,  nan ],
])

# numactl --interleave=all ../testing/testing_cgesdd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
cgesdd_UN = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.00,  nan ],
	[ nan,      80,      80,  nan,    0.00,  nan ],
	[ nan,      90,      90,  nan,    0.00,  nan ],
	[ nan,     100,     100,  nan,    0.00,  nan ],
	[ nan,     200,     200,  nan,    0.01,  nan ],
	[ nan,     300,     300,  nan,    0.03,  nan ],
	[ nan,     400,     400,  nan,    0.05,  nan ],
	[ nan,     500,     500,  nan,    0.08,  nan ],
	[ nan,     600,     600,  nan,    0.11,  nan ],
	[ nan,     700,     700,  nan,    0.15,  nan ],
	[ nan,     800,     800,  nan,    0.19,  nan ],
	[ nan,     900,     900,  nan,    0.24,  nan ],
	[ nan,    1000,    1000,  nan,    0.29,  nan ],
	[ nan,    2000,    2000,  nan,    1.13,  nan ],
	[ nan,    3000,    3000,  nan,    2.92,  nan ],
	[ nan,    4000,    4000,  nan,    5.83,  nan ],
	[ nan,    5000,    5000,  nan,   10.13,  nan ],
	[ nan,    6000,    6000,  nan,   16.08,  nan ],
	[ nan,    7000,    7000,  nan,   23.89,  nan ],
	[ nan,    8000,    8000,  nan,   34.17,  nan ],
	[ nan,    9000,    9000,  nan,   46.88,  nan ],
	[ nan,   10000,   10000,  nan,   62.73,  nan ],
	[ nan,     300,     100,  nan,    0.00,  nan ],
	[ nan,     600,     200,  nan,    0.02,  nan ],
	[ nan,     900,     300,  nan,    0.04,  nan ],
	[ nan,    1200,     400,  nan,    0.07,  nan ],
	[ nan,    1500,     500,  nan,    0.10,  nan ],
	[ nan,    1800,     600,  nan,    0.14,  nan ],
	[ nan,    2100,     700,  nan,    0.19,  nan ],
	[ nan,    2400,     800,  nan,    0.24,  nan ],
	[ nan,    2700,     900,  nan,    0.32,  nan ],
	[ nan,    3000,    1000,  nan,    0.39,  nan ],
	[ nan,    6000,    2000,  nan,    1.73,  nan ],
	[ nan,    9000,    3000,  nan,    4.65,  nan ],
	[ nan,   12000,    4000,  nan,    9.58,  nan ],
	[ nan,   15000,    5000,  nan,   17.05,  nan ],
	[ nan,   18000,    6000,  nan,   27.46,  nan ],
	[ nan,   21000,    7000,  nan,   41.66,  nan ],
	[ nan,   24000,    8000,  nan,   74.53,  nan ],
	[ nan,   27000,    9000,  nan,  103.25,  nan ],
	[ nan,     100,     300,  nan,    0.00,  nan ],
	[ nan,     200,     600,  nan,    0.02,  nan ],
	[ nan,     300,     900,  nan,    0.04,  nan ],
	[ nan,     400,    1200,  nan,    0.08,  nan ],
	[ nan,     500,    1500,  nan,    0.12,  nan ],
	[ nan,     600,    1800,  nan,    0.17,  nan ],
	[ nan,     700,    2100,  nan,    0.22,  nan ],
	[ nan,     800,    2400,  nan,    0.29,  nan ],
	[ nan,     900,    2700,  nan,    0.37,  nan ],
	[ nan,    1000,    3000,  nan,    0.45,  nan ],
	[ nan,    2000,    6000,  nan,    2.10,  nan ],
	[ nan,    3000,    9000,  nan,    5.90,  nan ],
	[ nan,    4000,   12000,  nan,   12.55,  nan ],
	[ nan,    5000,   15000,  nan,   22.87,  nan ],
	[ nan,    6000,   18000,  nan,   37.76,  nan ],
	[ nan,    7000,   21000,  nan,   57.64,  nan ],
	[ nan,    8000,   24000,  nan,   82.74,  nan ],
	[ nan,    9000,   27000,  nan,   85.03,  nan ],
	[ nan,   10000,     100,  nan,    0.02,  nan ],
	[ nan,   20000,     200,  nan,    0.08,  nan ],
	[ nan,   30000,     300,  nan,    0.19,  nan ],
	[ nan,   40000,     400,  nan,    0.51,  nan ],
	[ nan,   50000,     500,  nan,    0.79,  nan ],
	[ nan,   60000,     600,  nan,    1.16,  nan ],
	[ nan,   70000,     700,  nan,    1.62,  nan ],
	[ nan,   80000,     800,  nan,    2.21,  nan ],
	[ nan,   90000,     900,  nan,    3.36,  nan ],
	[ nan,  100000,    1000,  nan,    4.19,  nan ],
	[ nan,  200000,    2000,  nan,   24.51,  nan ],
	[ nan,     100,   10000,  nan,    0.02,  nan ],
	[ nan,     200,   20000,  nan,    0.09,  nan ],
	[ nan,     300,   30000,  nan,    0.23,  nan ],
	[ nan,     400,   40000,  nan,    0.44,  nan ],
	[ nan,     500,   50000,  nan,    0.74,  nan ],
	[ nan,     600,   60000,  nan,    1.20,  nan ],
	[ nan,     700,   70000,  nan,    1.86,  nan ],
	[ nan,     800,   80000,  nan,    2.77,  nan ],
	[ nan,     900,   90000,  nan,    3.33,  nan ],
	[ nan,    1000,  100000,  nan,    4.32,  nan ],
	[ nan,    2000,  200000,  nan,   28.52,  nan ],
])

# numactl --interleave=all ../testing/testing_cgesdd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
cgesdd_US = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.00,  nan ],
	[ nan,      80,      80,  nan,    0.00,  nan ],
	[ nan,      90,      90,  nan,    0.00,  nan ],
	[ nan,     100,     100,  nan,    0.00,  nan ],
	[ nan,     200,     200,  nan,    0.02,  nan ],
	[ nan,     300,     300,  nan,    0.05,  nan ],
	[ nan,     400,     400,  nan,    0.08,  nan ],
	[ nan,     500,     500,  nan,    0.11,  nan ],
	[ nan,     600,     600,  nan,    0.16,  nan ],
	[ nan,     700,     700,  nan,    0.21,  nan ],
	[ nan,     800,     800,  nan,    0.27,  nan ],
	[ nan,     900,     900,  nan,    0.34,  nan ],
	[ nan,    1000,    1000,  nan,    0.43,  nan ],
	[ nan,    2000,    2000,  nan,    1.69,  nan ],
	[ nan,    3000,    3000,  nan,    4.31,  nan ],
	[ nan,    4000,    4000,  nan,    8.28,  nan ],
	[ nan,    5000,    5000,  nan,   13.79,  nan ],
	[ nan,    6000,    6000,  nan,   21.55,  nan ],
	[ nan,    7000,    7000,  nan,   31.66,  nan ],
	[ nan,    8000,    8000,  nan,   44.57,  nan ],
	[ nan,    9000,    9000,  nan,   60.54,  nan ],
	[ nan,   10000,   10000,  nan,   80.15,  nan ],
	[ nan,     300,     100,  nan,    0.01,  nan ],
	[ nan,     600,     200,  nan,    0.03,  nan ],
	[ nan,     900,     300,  nan,    0.06,  nan ],
	[ nan,    1200,     400,  nan,    0.10,  nan ],
	[ nan,    1500,     500,  nan,    0.15,  nan ],
	[ nan,    1800,     600,  nan,    0.21,  nan ],
	[ nan,    2100,     700,  nan,    0.29,  nan ],
	[ nan,    2400,     800,  nan,    0.37,  nan ],
	[ nan,    2700,     900,  nan,    0.50,  nan ],
	[ nan,    3000,    1000,  nan,    0.62,  nan ],
	[ nan,    6000,    2000,  nan,    2.97,  nan ],
	[ nan,    9000,    3000,  nan,    8.21,  nan ],
	[ nan,   12000,    4000,  nan,   17.17,  nan ],
	[ nan,   15000,    5000,  nan,   30.84,  nan ],
	[ nan,   18000,    6000,  nan,   50.12,  nan ],
	[ nan,   21000,    7000,  nan,   76.50,  nan ],
	[ nan,   24000,    8000,  nan,  141.47,  nan ],
	[ nan,   27000,    9000,  nan,  153.96,  nan ],
	[ nan,     100,     300,  nan,    0.01,  nan ],
	[ nan,     200,     600,  nan,    0.03,  nan ],
	[ nan,     300,     900,  nan,    0.06,  nan ],
	[ nan,     400,    1200,  nan,    0.11,  nan ],
	[ nan,     500,    1500,  nan,    0.16,  nan ],
	[ nan,     600,    1800,  nan,    0.23,  nan ],
	[ nan,     700,    2100,  nan,    0.32,  nan ],
	[ nan,     800,    2400,  nan,    0.41,  nan ],
	[ nan,     900,    2700,  nan,    0.53,  nan ],
	[ nan,    1000,    3000,  nan,    0.65,  nan ],
	[ nan,    2000,    6000,  nan,    3.04,  nan ],
	[ nan,    3000,    9000,  nan,    8.42,  nan ],
	[ nan,    4000,   12000,  nan,   17.51,  nan ],
	[ nan,    5000,   15000,  nan,   31.34,  nan ],
	[ nan,    6000,   18000,  nan,   68.91,  nan ],
	[ nan,    7000,   21000,  nan,   77.48,  nan ],
	[ nan,    8000,   24000,  nan,  112.14,  nan ],
	[ nan,    9000,   27000,  nan,  155.68,  nan ],
	[ nan,   10000,     100,  nan,    0.04,  nan ],
	[ nan,   20000,     200,  nan,    0.18,  nan ],
	[ nan,   30000,     300,  nan,    0.46,  nan ],
	[ nan,   40000,     400,  nan,    1.07,  nan ],
	[ nan,   50000,     500,  nan,    1.78,  nan ],
	[ nan,   60000,     600,  nan,    2.94,  nan ],
	[ nan,   70000,     700,  nan,    4.08,  nan ],
	[ nan,   80000,     800,  nan,    5.89,  nan ],
	[ nan,   90000,     900,  nan,    8.13,  nan ],
	[ nan,  100000,    1000,  nan,   10.32,  nan ],
	[ nan,  200000,    2000,  nan,   69.11,  nan ],
	[ nan,     100,   10000,  nan,    0.06,  nan ],
	[ nan,     200,   20000,  nan,    0.24,  nan ],
	[ nan,     300,   30000,  nan,    0.65,  nan ],
	[ nan,     400,   40000,  nan,    1.29,  nan ],
	[ nan,     500,   50000,  nan,    2.28,  nan ],
	[ nan,     600,   60000,  nan,    3.92,  nan ],
	[ nan,     700,   70000,  nan,    5.86,  nan ],
	[ nan,     800,   80000,  nan,    7.78,  nan ],
	[ nan,     900,   90000,  nan,    7.62,  nan ],
	[ nan,    1000,  100000,  nan,    9.68,  nan ],
	[ nan,    2000,  200000,  nan,   57.84,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/cgetrf.txt
# numactl --interleave=all ../testing/testing_cgetrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgetrf = array([
	[    10,     10,  nan,  nan,     0.24,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.75,  0.00,  nan ],
	[    30,     30,  nan,  nan,     1.79,  0.00,  nan ],
	[    40,     40,  nan,  nan,     3.53,  0.00,  nan ],
	[    50,     50,  nan,  nan,     4.87,  0.00,  nan ],
	[    60,     60,  nan,  nan,     5.56,  0.00,  nan ],
	[    70,     70,  nan,  nan,     1.04,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.50,  0.00,  nan ],
	[    90,     90,  nan,  nan,     2.07,  0.00,  nan ],
	[   100,    100,  nan,  nan,     2.68,  0.00,  nan ],
	[   200,    200,  nan,  nan,    12.27,  0.00,  nan ],
	[   300,    300,  nan,  nan,    28.70,  0.00,  nan ],
	[   400,    400,  nan,  nan,    47.89,  0.00,  nan ],
	[   500,    500,  nan,  nan,    71.91,  0.00,  nan ],
	[   600,    600,  nan,  nan,    96.13,  0.01,  nan ],
	[   700,    700,  nan,  nan,   123.22,  0.01,  nan ],
	[   800,    800,  nan,  nan,   151.84,  0.01,  nan ],
	[   900,    900,  nan,  nan,   180.86,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   211.73,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   528.57,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,   882.00,  0.08,  nan ],
	[  4000,   4000,  nan,  nan,  1134.12,  0.15,  nan ],
	[  5000,   5000,  nan,  nan,  1295.05,  0.26,  nan ],
	[  6000,   6000,  nan,  nan,  1537.40,  0.37,  nan ],
	[  7000,   7000,  nan,  nan,  1710.51,  0.53,  nan ],
	[  8000,   8000,  nan,  nan,  1861.76,  0.73,  nan ],
	[  9000,   9000,  nan,  nan,  1918.72,  1.01,  nan ],
	[ 10000,  10000,  nan,  nan,  2032.62,  1.31,  nan ],
	[ 12000,  12000,  nan,  nan,  2204.18,  2.09,  nan ],
	[ 14000,  14000,  nan,  nan,  2327.20,  3.14,  nan ],
	[ 16000,  16000,  nan,  nan,  2409.66,  4.53,  nan ],
	[ 18000,  18000,  nan,  nan,  2464.08,  6.31,  nan ],
	[ 20000,  20000,  nan,  nan,  2521.36,  8.46,  nan ],
])

# numactl --interleave=all ../testing/testing_cgetrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.06,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.20,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.45,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.79,  0.00,  nan ],
	[    60,     60,  nan,  nan,     1.24,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.45,  0.00,  nan ],
	[    80,     80,  nan,  nan,     0.67,  0.00,  nan ],
	[    90,     90,  nan,  nan,     0.92,  0.00,  nan ],
	[   100,    100,  nan,  nan,     1.22,  0.00,  nan ],
	[   200,    200,  nan,  nan,     6.40,  0.00,  nan ],
	[   300,    300,  nan,  nan,    16.85,  0.00,  nan ],
	[   400,    400,  nan,  nan,    31.71,  0.01,  nan ],
	[   500,    500,  nan,  nan,    49.86,  0.01,  nan ],
	[   600,    600,  nan,  nan,    70.11,  0.01,  nan ],
	[   700,    700,  nan,  nan,    92.57,  0.01,  nan ],
	[   800,    800,  nan,  nan,   118.35,  0.01,  nan ],
	[   900,    900,  nan,  nan,   143.45,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   176.99,  0.02,  nan ],
	[  2000,   2000,  nan,  nan,   474.03,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,   821.59,  0.09,  nan ],
	[  4000,   4000,  nan,  nan,  1153.80,  0.15,  nan ],
	[  5000,   5000,  nan,  nan,  1450.97,  0.23,  nan ],
	[  6000,   6000,  nan,  nan,  1739.32,  0.33,  nan ],
	[  7000,   7000,  nan,  nan,  1932.86,  0.47,  nan ],
	[  8000,   8000,  nan,  nan,  2097.77,  0.65,  nan ],
	[  9000,   9000,  nan,  nan,  2053.40,  0.95,  nan ],
	[ 10000,  10000,  nan,  nan,  2184.81,  1.22,  nan ],
	[ 12000,  12000,  nan,  nan,  2374.47,  1.94,  nan ],
	[ 14000,  14000,  nan,  nan,  2499.31,  2.93,  nan ],
	[ 16000,  16000,  nan,  nan,  2582.38,  4.23,  nan ],
	[ 18000,  18000,  nan,  nan,  2627.16,  5.92,  nan ],
	[ 20000,  20000,  nan,  nan,  2676.83,  7.97,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/cheevd.txt
# numactl --interleave=all ../testing/testing_cheevd -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_cheevd -JN -N 123 -N 1234 --range 12000:20000:2000
cheevd_JN = array([
	[    10,  nan,    0.0000,  nan,  nan,  nan,  nan ],
	[    20,  nan,    0.0001,  nan,  nan,  nan,  nan ],
	[    30,  nan,    0.0001,  nan,  nan,  nan,  nan ],
	[    40,  nan,    0.0001,  nan,  nan,  nan,  nan ],
	[    50,  nan,    0.0002,  nan,  nan,  nan,  nan ],
	[    60,  nan,    0.0003,  nan,  nan,  nan,  nan ],
	[    70,  nan,    0.0005,  nan,  nan,  nan,  nan ],
	[    80,  nan,    0.0007,  nan,  nan,  nan,  nan ],
	[    90,  nan,    0.0009,  nan,  nan,  nan,  nan ],
	[   100,  nan,    0.0012,  nan,  nan,  nan,  nan ],
	[   200,  nan,    0.0048,  nan,  nan,  nan,  nan ],
	[   300,  nan,    0.0094,  nan,  nan,  nan,  nan ],
	[   400,  nan,    0.0156,  nan,  nan,  nan,  nan ],
	[   500,  nan,    0.0229,  nan,  nan,  nan,  nan ],
	[   600,  nan,    0.0324,  nan,  nan,  nan,  nan ],
	[   700,  nan,    0.0442,  nan,  nan,  nan,  nan ],
	[   800,  nan,    0.0572,  nan,  nan,  nan,  nan ],
	[   900,  nan,    0.0739,  nan,  nan,  nan,  nan ],
	[  1000,  nan,    0.0906,  nan,  nan,  nan,  nan ],
	[  2000,  nan,    0.4168,  nan,  nan,  nan,  nan ],
	[  3000,  nan,    1.2620,  nan,  nan,  nan,  nan ],
	[  4000,  nan,    2.2903,  nan,  nan,  nan,  nan ],
	[  5000,  nan,    3.7342,  nan,  nan,  nan,  nan ],
	[  6000,  nan,    5.5810,  nan,  nan,  nan,  nan ],
	[  7000,  nan,    8.0046,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   10.9571,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   14.7192,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,   19.1044,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,   30.6692,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,   45.5317,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,   65.0317,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,   90.1935,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  118.9253,  nan,  nan,  nan,  nan ],
])

# numactl --interleave=all ../testing/testing_cheevd -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_cheevd -JV -N 123 -N 1234 --range 12000:20000:2000
cheevd_JV = array([
	[    10,  nan,    0.0001,  nan,  nan,  nan,  nan ],
	[    20,  nan,    0.0002,  nan,  nan,  nan,  nan ],
	[    30,  nan,    0.0002,  nan,  nan,  nan,  nan ],
	[    40,  nan,    0.0004,  nan,  nan,  nan,  nan ],
	[    50,  nan,    0.0005,  nan,  nan,  nan,  nan ],
	[    60,  nan,    0.0006,  nan,  nan,  nan,  nan ],
	[    70,  nan,    0.0009,  nan,  nan,  nan,  nan ],
	[    80,  nan,    0.0011,  nan,  nan,  nan,  nan ],
	[    90,  nan,    0.0014,  nan,  nan,  nan,  nan ],
	[   100,  nan,    0.0017,  nan,  nan,  nan,  nan ],
	[   200,  nan,    0.0092,  nan,  nan,  nan,  nan ],
	[   300,  nan,    0.0148,  nan,  nan,  nan,  nan ],
	[   400,  nan,    0.0242,  nan,  nan,  nan,  nan ],
	[   500,  nan,    0.0347,  nan,  nan,  nan,  nan ],
	[   600,  nan,    0.0421,  nan,  nan,  nan,  nan ],
	[   700,  nan,    0.0556,  nan,  nan,  nan,  nan ],
	[   800,  nan,    0.0705,  nan,  nan,  nan,  nan ],
	[   900,  nan,    0.0886,  nan,  nan,  nan,  nan ],
	[  1000,  nan,    0.1098,  nan,  nan,  nan,  nan ],
	[  2000,  nan,    0.4374,  nan,  nan,  nan,  nan ],
	[  3000,  nan,    1.4212,  nan,  nan,  nan,  nan ],
	[  4000,  nan,    2.6029,  nan,  nan,  nan,  nan ],
	[  5000,  nan,    4.2259,  nan,  nan,  nan,  nan ],
	[  6000,  nan,    6.4208,  nan,  nan,  nan,  nan ],
	[  7000,  nan,    9.2599,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   12.7538,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   17.2134,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,   22.4110,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,   36.7797,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,   54.8882,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,   78.0173,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,  108.8207,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  143.8242,  nan,  nan,  nan,  nan ],
])

# numactl --interleave=all ../testing/testing_cheevd_gpu -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_cheevd_gpu -JN -N 123 -N 1234 --range 12000:20000:2000
cheevd_gpu_JN = array([
	[    10,  nan,    0.0002,  nan,  nan,  nan,  nan ],
	[    20,  nan,    0.0002,  nan,  nan,  nan,  nan ],
	[    30,  nan,    0.0002,  nan,  nan,  nan,  nan ],
	[    40,  nan,    0.0003,  nan,  nan,  nan,  nan ],
	[    50,  nan,    0.0003,  nan,  nan,  nan,  nan ],
	[    60,  nan,    0.0004,  nan,  nan,  nan,  nan ],
	[    70,  nan,    0.0007,  nan,  nan,  nan,  nan ],
	[    80,  nan,    0.0009,  nan,  nan,  nan,  nan ],
	[    90,  nan,    0.0011,  nan,  nan,  nan,  nan ],
	[   100,  nan,    0.0014,  nan,  nan,  nan,  nan ],
	[   200,  nan,    0.0049,  nan,  nan,  nan,  nan ],
	[   300,  nan,    0.0095,  nan,  nan,  nan,  nan ],
	[   400,  nan,    0.0159,  nan,  nan,  nan,  nan ],
	[   500,  nan,    0.0230,  nan,  nan,  nan,  nan ],
	[   600,  nan,    0.0317,  nan,  nan,  nan,  nan ],
	[   700,  nan,    0.0431,  nan,  nan,  nan,  nan ],
	[   800,  nan,    0.0546,  nan,  nan,  nan,  nan ],
	[   900,  nan,    0.0697,  nan,  nan,  nan,  nan ],
	[  1000,  nan,    0.0843,  nan,  nan,  nan,  nan ],
	[  2000,  nan,    0.3551,  nan,  nan,  nan,  nan ],
	[  3000,  nan,    1.2662,  nan,  nan,  nan,  nan ],
	[  4000,  nan,    2.2914,  nan,  nan,  nan,  nan ],
	[  5000,  nan,    3.7343,  nan,  nan,  nan,  nan ],
	[  6000,  nan,    5.5809,  nan,  nan,  nan,  nan ],
	[  7000,  nan,    7.9963,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   10.9362,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   14.7066,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,   19.0569,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,   30.6401,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,   45.3730,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,   65.0345,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,   89.8408,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  118.9498,  nan,  nan,  nan,  nan ],
])

# numactl --interleave=all ../testing/testing_cheevd_gpu -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_cheevd_gpu -JV -N 123 -N 1234 --range 12000:20000:2000
cheevd_gpu_JV = array([
	[    10,  nan,    0.0004,  nan,  nan,  nan,  nan ],
	[    20,  nan,    0.0004,  nan,  nan,  nan,  nan ],
	[    30,  nan,    0.0005,  nan,  nan,  nan,  nan ],
	[    40,  nan,    0.0007,  nan,  nan,  nan,  nan ],
	[    50,  nan,    0.0008,  nan,  nan,  nan,  nan ],
	[    60,  nan,    0.0010,  nan,  nan,  nan,  nan ],
	[    70,  nan,    0.0013,  nan,  nan,  nan,  nan ],
	[    80,  nan,    0.0015,  nan,  nan,  nan,  nan ],
	[    90,  nan,    0.0019,  nan,  nan,  nan,  nan ],
	[   100,  nan,    0.0023,  nan,  nan,  nan,  nan ],
	[   200,  nan,    0.0104,  nan,  nan,  nan,  nan ],
	[   300,  nan,    0.0174,  nan,  nan,  nan,  nan ],
	[   400,  nan,    0.0289,  nan,  nan,  nan,  nan ],
	[   500,  nan,    0.0409,  nan,  nan,  nan,  nan ],
	[   600,  nan,    0.0516,  nan,  nan,  nan,  nan ],
	[   700,  nan,    0.0696,  nan,  nan,  nan,  nan ],
	[   800,  nan,    0.0879,  nan,  nan,  nan,  nan ],
	[   900,  nan,    0.1108,  nan,  nan,  nan,  nan ],
	[  1000,  nan,    0.1354,  nan,  nan,  nan,  nan ],
	[  2000,  nan,    0.5875,  nan,  nan,  nan,  nan ],
	[  3000,  nan,    1.4799,  nan,  nan,  nan,  nan ],
	[  4000,  nan,    2.6911,  nan,  nan,  nan,  nan ],
	[  5000,  nan,    4.3855,  nan,  nan,  nan,  nan ],
	[  6000,  nan,    6.6081,  nan,  nan,  nan,  nan ],
	[  7000,  nan,    9.4027,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   12.9168,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   17.3143,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,   22.7453,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,   36.8039,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,   55.2819,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,   79.4427,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,  110.5094,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  148.1804,  nan,  nan,  nan,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/cheevd_2stage.txt
# numactl --interleave=all ../testing/testing_cheevdx_2stage -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevdx_2stage_JN = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.00 ],
	[   300,    300,   0.02 ],
	[   400,    400,   0.04 ],
	[   500,    500,   0.06 ],
	[   600,    600,   0.09 ],
	[   700,    700,   0.11 ],
	[   800,    800,   0.13 ],
	[   900,    900,   0.16 ],
	[  1000,   1000,   0.17 ],
	[  2000,   2000,   0.45 ],
	[  3000,   3000,   0.81 ],
	[  4000,   4000,   1.26 ],
	[  5000,   5000,   1.91 ],
	[  6000,   6000,   2.46 ],
	[  7000,   7000,   3.21 ],
	[  8000,   8000,   4.15 ],
	[  9000,   9000,   5.31 ],
	[ 10000,  10000,   6.75 ],
	[ 12000,  12000,   9.83 ],
	[ 14000,  14000,  13.76 ],
	[ 16000,  16000,  18.61 ],
	[ 18000,  18000,  24.65 ],
	[ 20000,  20000,  32.06 ],
])

# numactl --interleave=all ../testing/testing_cheevdx_2stage -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevdx_2stage_JV = array([
	[    10,     10,    0.00 ],
	[    20,     20,    0.00 ],
	[    30,     30,    0.00 ],
	[    40,     40,    0.00 ],
	[    50,     50,    0.00 ],
	[    60,     60,    0.00 ],
	[    70,     70,    0.00 ],
	[    80,     80,    0.00 ],
	[    90,     90,    0.00 ],
	[   100,    100,    0.00 ],
	[   200,    200,    0.01 ],
	[   300,    300,    0.03 ],
	[   400,    400,    0.05 ],
	[   500,    500,    0.08 ],
	[   600,    600,    0.10 ],
	[   700,    700,    0.12 ],
	[   800,    800,    0.15 ],
	[   900,    900,    0.18 ],
	[  1000,   1000,    0.21 ],
	[  2000,   2000,    0.60 ],
	[  3000,   3000,    1.16 ],
	[  4000,   4000,    2.03 ],
	[  5000,   5000,    3.25 ],
	[  6000,   6000,    4.99 ],
	[  7000,   7000,    7.15 ],
	[  8000,   8000,    9.77 ],
	[  9000,   9000,   13.08 ],
	[ 10000,  10000,   17.55 ],
	[ 12000,  12000,   28.13 ],
	[ 14000,  14000,   42.38 ],
	[ 16000,  16000,   61.25 ],
	[ 18000,  18000,   86.19 ],
	[ 20000,  20000,  116.90 ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/chemv.txt
# numactl --interleave=all ../testing/testing_chemv -L -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
chemv_L = array([
	[    10,    0.03,   0.03,    0.03,   0.03,   0.04,   0.02,   0.48,    0.00,  2.13e-07,  2.13e-07,  2.70e-07,  nan ],
	[    11,    0.04,   0.03,    0.04,   0.03,   0.05,   0.02,   0.58,    0.00,  1.94e-07,  1.85e-07,  1.23e-07,  nan ],
	[    12,    0.04,   0.03,    0.04,   0.03,   0.06,   0.02,   0.68,    0.00,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[    13,    0.05,   0.03,    0.05,   0.03,   0.07,   0.02,   0.79,    0.00,  1.64e-07,  2.07e-07,  1.64e-07,  nan ],
	[    14,    0.06,   0.03,    0.06,   0.03,   0.08,   0.02,   0.91,    0.00,  2.81e-07,  2.46e-07,  2.81e-07,  nan ],
	[    15,    0.06,   0.03,    0.07,   0.03,   0.09,   0.02,   0.64,    0.00,  1.42e-07,  1.80e-07,  2.84e-07,  nan ],
	[    16,    0.07,   0.03,    0.08,   0.03,   0.11,   0.02,   1.17,    0.00,  1.69e-07,  1.69e-07,  1.69e-07,  nan ],
	[    17,    0.07,   0.04,    0.08,   0.03,   0.11,   0.02,   1.17,    0.00,  1.59e-07,  2.51e-07,  1.59e-07,  nan ],
	[    18,    0.08,   0.03,    0.09,   0.03,   0.12,   0.02,   1.47,    0.00,  2.14e-07,  2.18e-07,  2.18e-07,  nan ],
	[    19,    0.09,   0.03,    0.10,   0.03,   0.13,   0.02,   1.09,    0.00,  2.04e-07,  2.01e-07,  1.25e-07,  nan ],
	[    20,    0.10,   0.03,    0.11,   0.03,   0.14,   0.02,   1.80,    0.00,  1.97e-07,  2.13e-07,  1.97e-07,  nan ],
	[    21,    0.11,   0.03,    0.12,   0.03,   0.16,   0.02,   1.22,    0.00,  2.03e-07,  2.57e-07,  2.57e-07,  nan ],
	[    22,    0.12,   0.03,    0.13,   0.03,   0.18,   0.02,   1.33,    0.00,  1.94e-07,  2.33e-07,  1.94e-07,  nan ],
	[    23,    0.13,   0.03,    0.14,   0.03,   0.19,   0.02,   1.58,    0.00,  1.71e-07,  1.67e-07,  2.49e-07,  nan ],
	[    24,    0.14,   0.03,    0.15,   0.03,   0.21,   0.02,   2.57,    0.00,  1.64e-07,  2.44e-07,  1.87e-07,  nan ],
	[    25,    0.15,   0.04,    0.17,   0.03,   0.22,   0.02,   1.71,    0.00,  2.56e-07,  2.29e-07,  2.16e-07,  nan ],
	[    26,    0.18,   0.03,    0.18,   0.03,   0.23,   0.03,   1.85,    0.00,  1.64e-07,  1.55e-07,  1.64e-07,  nan ],
	[    27,    0.18,   0.03,    0.19,   0.03,   0.26,   0.02,   1.99,    0.00,  2.15e-07,  1.58e-07,  2.23e-07,  nan ],
	[    28,    0.21,   0.03,    0.21,   0.03,   0.30,   0.02,   2.13,    0.00,  2.15e-07,  2.46e-07,  1.52e-07,  nan ],
	[    29,    0.22,   0.03,    0.23,   0.03,   0.31,   0.02,   2.28,    0.00,  2.94e-07,  2.71e-07,  2.21e-07,  nan ],
	[    30,    0.24,   0.03,    0.24,   0.03,   0.34,   0.02,   2.64,    0.00,  2.29e-07,  2.29e-07,  2.62e-07,  nan ],
	[    31,    0.26,   0.03,    0.26,   0.03,   0.35,   0.02,   1.99,    0.00,  1.54e-07,  2.54e-07,  1.54e-07,  nan ],
	[    32,    0.27,   0.03,    0.29,   0.03,   0.39,   0.02,   2.77,    0.00,  1.33e-07,  2.46e-07,  1.49e-07,  nan ],
	[    33,    0.27,   0.03,    0.24,   0.04,   0.37,   0.02,   2.25,    0.00,  2.55e-07,  2.33e-07,  2.08e-07,  nan ],
	[    34,    0.30,   0.03,    0.26,   0.04,   0.40,   0.02,   3.38,    0.00,  2.80e-07,  2.31e-07,  3.17e-07,  nan ],
	[    35,    0.33,   0.03,    0.28,   0.04,   0.42,   0.02,   2.52,    0.00,  2.25e-07,  2.44e-07,  2.44e-07,  nan ],
	[    36,    0.33,   0.03,    0.28,   0.04,   0.43,   0.03,   2.66,    0.00,  3.35e-07,  2.37e-07,  2.37e-07,  nan ],
	[    37,    0.36,   0.03,    0.31,   0.04,   0.44,   0.03,   2.81,    0.00,  2.31e-07,  3.26e-07,  2.13e-07,  nan ],
	[    38,    0.36,   0.03,    0.33,   0.04,   0.48,   0.03,   2.96,    0.00,  3.62e-07,  3.17e-07,  3.05e-07,  nan ],
	[    39,    0.40,   0.03,    0.34,   0.04,   0.49,   0.03,   2.52,    0.01,  2.19e-07,  2.19e-07,  1.96e-07,  nan ],
	[    40,    0.40,   0.03,    0.36,   0.04,   0.54,   0.02,   4.28,    0.00,  2.90e-07,  3.02e-07,  2.90e-07,  nan ],
	[    41,    0.42,   0.03,    0.38,   0.04,   0.56,   0.03,   3.65,    0.00,  3.12e-07,  2.83e-07,  2.83e-07,  nan ],
	[    42,    0.44,   0.03,    0.41,   0.04,   0.56,   0.03,   2.92,    0.01,  2.76e-07,  2.72e-07,  1.87e-07,  nan ],
	[    43,    0.44,   0.04,    0.41,   0.04,   0.59,   0.03,   3.78,    0.00,  2.81e-07,  2.81e-07,  2.88e-07,  nan ],
	[    44,    0.44,   0.04,    0.43,   0.04,   0.65,   0.02,   3.95,    0.00,  2.82e-07,  2.68e-07,  1.94e-07,  nan ],
	[    45,    0.51,   0.03,    0.45,   0.04,   0.64,   0.03,   4.13,    0.00,  3.42e-07,  2.62e-07,  2.12e-07,  nan ],
	[    46,    0.53,   0.03,    0.47,   0.04,   0.70,   0.03,   3.49,    0.01,  2.52e-07,  2.62e-07,  3.52e-07,  nan ],
	[    47,    0.52,   0.04,    0.49,   0.04,   0.73,   0.03,   3.64,    0.01,  2.19e-07,  2.47e-07,  2.72e-07,  nan ],
	[    48,    0.56,   0.03,    0.51,   0.04,   0.76,   0.03,   3.80,    0.01,  2.87e-07,  3.55e-07,  2.87e-07,  nan ],
	[    49,    0.58,   0.03,    0.54,   0.04,   0.73,   0.03,   3.95,    0.01,  2.81e-07,  2.34e-07,  2.37e-07,  nan ],
	[    50,    0.61,   0.03,    0.55,   0.04,   0.73,   0.03,   4.11,    0.01,  3.08e-07,  2.75e-07,  2.44e-07,  nan ],
	[    51,    0.62,   0.03,    0.56,   0.04,   0.82,   0.03,   3.59,    0.01,  3.74e-07,  2.72e-07,  2.70e-07,  nan ],
	[    52,    0.62,   0.04,    0.58,   0.04,   0.80,   0.03,   4.45,    0.01,  2.75e-07,  2.23e-07,  1.83e-07,  nan ],
	[    53,    0.64,   0.04,    0.61,   0.04,   0.85,   0.03,   4.62,    0.01,  2.62e-07,  3.62e-07,  3.62e-07,  nan ],
	[    54,    0.73,   0.03,    0.61,   0.04,   0.92,   0.03,   4.79,    0.01,  3.53e-07,  3.00e-07,  3.16e-07,  nan ],
	[    55,    0.71,   0.04,    0.66,   0.04,   0.92,   0.03,   4.17,    0.01,  2.54e-07,  3.47e-07,  2.50e-07,  nan ],
	[    56,    0.74,   0.04,    0.66,   0.04,   0.95,   0.03,   5.15,    0.01,  2.91e-07,  2.07e-07,  2.91e-07,  nan ],
	[    57,    0.79,   0.03,    0.70,   0.04,   0.99,   0.03,   4.48,    0.01,  2.24e-07,  2.70e-07,  2.70e-07,  nan ],
	[    58,    0.81,   0.03,    0.71,   0.04,   1.06,   0.03,   3.99,    0.01,  2.71e-07,  2.71e-07,  2.37e-07,  nan ],
	[    59,    0.86,   0.03,    0.73,   0.04,   1.06,   0.03,   3.99,    0.01,  2.74e-07,  3.77e-07,  4.34e-07,  nan ],
	[    60,    0.89,   0.03,    0.76,   0.04,   1.10,   0.03,   5.90,    0.01,  2.62e-07,  2.62e-07,  2.72e-07,  nan ],
	[    61,    0.85,   0.04,    0.78,   0.04,   1.09,   0.03,   6.09,    0.01,  2.50e-07,  2.52e-07,  2.25e-07,  nan ],
	[    62,    0.90,   0.03,    0.81,   0.04,   1.17,   0.03,   4.40,    0.01,  2.75e-07,  2.54e-07,  2.75e-07,  nan ],
	[    63,    0.95,   0.03,    0.83,   0.04,   1.21,   0.03,   5.45,    0.01,  2.71e-07,  2.71e-07,  3.03e-07,  nan ],
	[    64,    1.16,   0.03,    0.91,   0.04,   1.23,   0.03,   5.63,    0.01,  4.00e-07,  3.77e-07,  3.63e-07,  nan ],
	[    65,    0.94,   0.04,    0.88,   0.04,   1.23,   0.03,   5.80,    0.01,  3.16e-07,  2.42e-07,  2.93e-07,  nan ],
	[    66,    0.96,   0.04,    0.92,   0.04,   1.28,   0.03,   5.15,    0.01,  4.62e-07,  3.66e-07,  2.89e-07,  nan ],
	[    67,    1.02,   0.04,    0.94,   0.04,   1.32,   0.03,   6.16,    0.01,  3.42e-07,  3.43e-07,  3.43e-07,  nan ],
	[    68,    1.02,   0.04,    0.94,   0.04,   1.31,   0.03,   6.34,    0.01,  4.52e-07,  3.55e-07,  2.80e-07,  nan ],
	[    69,    1.05,   0.04,    1.00,   0.04,   1.31,   0.03,   7.77,    0.01,  2.76e-07,  2.47e-07,  3.36e-07,  nan ],
	[    70,    1.08,   0.04,    1.02,   0.04,   1.33,   0.03,   5.79,    0.01,  4.39e-07,  4.49e-07,  4.39e-07,  nan ],
	[    71,    1.08,   0.04,    1.03,   0.04,   1.37,   0.03,   5.76,    0.01,  6.65e-07,  7.60e-07,  7.99e-07,  nan ],
	[    72,    1.15,   0.04,    1.06,   0.04,   1.41,   0.03,   7.10,    0.01,  3.18e-07,  3.28e-07,  3.18e-07,  nan ],
	[    73,    1.18,   0.04,    1.09,   0.04,   1.45,   0.03,   6.29,    0.01,  3.77e-07,  3.30e-07,  3.30e-07,  nan ],
	[    74,    1.14,   0.04,    1.12,   0.04,   1.44,   0.03,   5.51,    0.01,  3.26e-07,  3.14e-07,  3.46e-07,  nan ],
	[    75,    1.24,   0.04,    1.15,   0.04,   1.54,   0.03,   5.07,    0.01,  3.22e-07,  3.05e-07,  3.26e-07,  nan ],
	[    76,    1.24,   0.04,    1.18,   0.04,   1.57,   0.03,   6.59,    0.01,  4.14e-07,  3.05e-07,  3.17e-07,  nan ],
	[    77,    1.27,   0.04,    1.21,   0.04,   1.62,   0.03,   6.99,    0.01,  4.03e-07,  3.99e-07,  3.22e-07,  nan ],
	[    78,    1.30,   0.04,    1.24,   0.04,   1.60,   0.03,   6.94,    0.01,  3.09e-07,  4.18e-07,  3.28e-07,  nan ],
	[    79,    1.33,   0.04,    1.27,   0.04,   1.64,   0.03,   7.11,    0.01,  3.05e-07,  3.98e-07,  3.24e-07,  nan ],
	[    80,    1.30,   0.04,    1.30,   0.04,   1.74,   0.03,   6.43,    0.01,  2.90e-07,  3.81e-07,  3.44e-07,  nan ],
	[    81,    1.40,   0.04,    1.30,   0.04,   1.72,   0.03,   7.47,    0.01,  3.16e-07,  3.40e-07,  3.16e-07,  nan ],
	[    82,    1.34,   0.04,    1.38,   0.04,   1.70,   0.03,   6.76,    0.01,  3.75e-07,  3.97e-07,  3.72e-07,  nan ],
	[    83,    1.40,   0.04,    1.37,   0.04,   1.76,   0.03,   7.13,    0.01,  4.11e-07,  4.11e-07,  4.69e-07,  nan ],
	[    84,    1.51,   0.04,    1.43,   0.04,   1.65,   0.03,   7.09,    0.01,  3.74e-07,  2.87e-07,  3.27e-07,  nan ],
	[    85,    1.59,   0.04,    1.47,   0.04,   1.90,   0.03,   8.51,    0.01,  4.23e-07,  2.84e-07,  2.69e-07,  nan ],
	[    86,    1.58,   0.04,    1.50,   0.04,   1.94,   0.03,   8.42,    0.01,  2.66e-07,  2.74e-07,  3.58e-07,  nan ],
	[    87,    1.67,   0.04,    1.50,   0.04,   1.93,   0.03,   8.61,    0.01,  3.62e-07,  3.51e-07,  2.77e-07,  nan ],
	[    88,    1.65,   0.04,    1.54,   0.04,   2.03,   0.03,   6.95,    0.01,  3.47e-07,  4.36e-07,  3.57e-07,  nan ],
	[    89,    1.47,   0.04,    1.53,   0.04,   2.02,   0.03,   8.19,    0.01,  2.71e-07,  3.53e-07,  3.46e-07,  nan ],
	[    90,    1.70,   0.04,    1.57,   0.04,   2.06,   0.03,   7.27,    0.01,  5.09e-07,  3.42e-07,  4.24e-07,  nan ],
	[   100,    1.94,   0.04,    1.94,   0.04,   2.32,   0.04,  10.32,    0.01,  2.41e-07,  2.41e-07,  2.16e-07,  nan ],
	[   110,    2.39,   0.04,    2.34,   0.04,   2.82,   0.03,   8.95,    0.01,  4.39e-07,  3.47e-07,  3.92e-07,  nan ],
	[   120,    2.91,   0.04,    2.70,   0.04,   3.16,   0.04,  11.65,    0.01,  4.26e-07,  2.72e-07,  2.84e-07,  nan ],
	[   130,    2.91,   0.05,    3.19,   0.04,   3.50,   0.04,  11.25,    0.01,  4.84e-07,  5.01e-07,  4.84e-07,  nan ],
	[   140,    3.52,   0.05,    3.61,   0.04,   4.05,   0.04,  11.27,    0.01,  4.39e-07,  4.36e-07,  5.45e-07,  nan ],
	[   150,    4.03,   0.05,    3.95,   0.05,   4.33,   0.04,  13.15,    0.01,  5.48e-07,  6.12e-07,  5.31e-07,  nan ],
	[   160,    4.49,   0.05,    4.93,   0.04,   5.16,   0.04,  14.70,    0.01,  4.98e-07,  4.05e-07,  4.77e-07,  nan ],
	[   170,    4.94,   0.05,    5.20,   0.04,   5.69,   0.04,  11.12,    0.02,  5.46e-07,  6.35e-07,  5.46e-07,  nan ],
	[   180,    5.45,   0.05,    5.56,   0.05,   5.80,   0.05,  14.62,    0.02,  5.36e-07,  6.17e-07,  5.24e-07,  nan ],
	[   190,    5.93,   0.05,    6.07,   0.05,   6.46,   0.05,  14.53,    0.02,  5.68e-07,  4.89e-07,  5.64e-07,  nan ],
	[   200,    5.98,   0.05,    6.73,   0.05,   6.86,   0.05,  15.37,    0.02,  6.15e-07,  6.88e-07,  5.35e-07,  nan ],
	[   210,    6.84,   0.05,    7.57,   0.05,   7.23,   0.05,  16.02,    0.02,  5.09e-07,  4.11e-07,  4.36e-07,  nan ],
	[   220,    7.37,   0.05,    8.30,   0.05,   7.94,   0.05,  17.03,    0.02,  6.33e-07,  5.93e-07,  5.81e-07,  nan ],
	[   230,    7.73,   0.06,    8.89,   0.05,   8.51,   0.05,  15.81,    0.03,  5.47e-07,  6.77e-07,  5.47e-07,  nan ],
	[   240,    8.42,   0.06,    9.44,   0.05,   9.09,   0.05,  17.21,    0.03,  5.55e-07,  6.74e-07,  5.55e-07,  nan ],
	[   250,    8.68,   0.06,   10.09,   0.05,   9.50,   0.05,  15.29,    0.03,  7.32e-07,  6.13e-07,  6.10e-07,  nan ],
	[   260,    9.09,   0.06,   10.66,   0.05,   9.88,   0.06,  17.55,    0.03,  8.24e-07,  5.98e-07,  8.30e-07,  nan ],
	[   270,    9.76,   0.06,   11.77,   0.05,  10.65,   0.06,  17.82,    0.03,  6.09e-07,  8.09e-07,  7.15e-07,  nan ],
	[   280,   10.17,   0.06,   12.13,   0.05,  11.07,   0.06,  19.03,    0.03,  5.69e-07,  6.63e-07,  6.74e-07,  nan ],
	[   290,   10.91,   0.06,   12.50,   0.05,  11.48,   0.06,  18.30,    0.04,  8.01e-07,  8.44e-07,  7.31e-07,  nan ],
	[   300,   11.50,   0.06,   13.61,   0.05,  12.09,   0.06,  18.07,    0.04,  8.15e-07,  8.28e-07,  8.28e-07,  nan ],
	[   310,   12.46,   0.06,   14.86,   0.05,  12.86,   0.06,  18.41,    0.04,  7.50e-07,  7.94e-07,  8.47e-07,  nan ],
	[   320,   13.70,   0.06,   15.84,   0.05,  13.28,   0.06,  19.18,    0.04,  7.64e-07,  7.64e-07,  6.69e-07,  nan ],
	[   330,   13.25,   0.07,   15.96,   0.05,  13.90,   0.06,  18.26,    0.05,  7.63e-07,  7.75e-07,  8.53e-07,  nan ],
	[   340,   14.07,   0.07,   17.16,   0.05,  14.27,   0.07,  19.78,    0.05,  9.91e-07,  8.09e-07,  8.09e-07,  nan ],
	[   350,   14.23,   0.07,   16.19,   0.06,  15.12,   0.07,  18.59,    0.05,  7.45e-07,  8.27e-07,  7.03e-07,  nan ],
	[   360,   15.11,   0.07,   18.27,   0.06,  15.54,   0.07,  19.32,    0.05,  9.13e-07,  7.58e-07,  7.82e-07,  nan ],
	[   370,   15.96,   0.07,   19.63,   0.06,  16.13,   0.07,  19.30,    0.06,  6.91e-07,  7.05e-07,  7.70e-07,  nan ],
	[   380,   16.60,   0.07,   19.69,   0.06,  16.60,   0.07,  20.35,    0.06,  1.22e-06,  8.04e-07,  8.83e-07,  nan ],
	[   390,   16.96,   0.07,   21.08,   0.06,  17.19,   0.07,  18.23,    0.07,  1.02e-06,  8.75e-07,  8.75e-07,  nan ],
	[   400,   12.22,   0.11,   21.38,   0.06,  18.08,   0.07,  20.03,    0.06,  9.92e-07,  8.53e-07,  8.39e-07,  nan ],
	[   410,   18.26,   0.07,   22.11,   0.06,  18.50,   0.07,  20.44,    0.07,  8.22e-07,  8.93e-07,  8.22e-07,  nan ],
	[   420,   18.86,   0.08,   23.20,   0.06,  18.62,   0.08,  21.14,    0.07,  6.70e-07,  7.41e-07,  6.89e-07,  nan ],
	[   430,   19.04,   0.08,   23.95,   0.06,  19.52,   0.08,  19.52,    0.08,  8.70e-07,  9.99e-07,  9.23e-07,  nan ],
	[   440,   20.50,   0.08,   24.60,   0.06,  20.18,   0.08,  21.03,    0.07,  8.69e-07,  8.09e-07,  8.12e-07,  nan ],
	[   450,   20.05,   0.08,   24.61,   0.07,  19.82,   0.08,  20.60,    0.08,  8.92e-07,  7.58e-07,  7.53e-07,  nan ],
	[   460,   21.26,   0.08,   26.58,   0.06,  20.95,   0.08,  21.20,    0.08,  1.01e-06,  8.31e-07,  8.68e-07,  nan ],
	[   470,   21.87,   0.08,   26.84,   0.07,  21.06,   0.08,  20.60,    0.09,  7.93e-07,  8.60e-07,  8.47e-07,  nan ],
	[   480,   22.03,   0.08,   28.51,   0.06,  22.03,   0.08,  21.48,    0.09,  8.04e-07,  8.65e-07,  9.26e-07,  nan ],
	[   490,   22.89,   0.08,   28.76,   0.07,  22.14,   0.09,  21.15,    0.09,  1.07e-06,  9.26e-07,  9.34e-07,  nan ],
	[   500,   23.90,   0.08,   29.42,   0.07,  22.74,   0.09,  21.57,    0.09,  8.54e-07,  7.55e-07,  7.55e-07,  nan ],
	[   510,   24.59,   0.08,   30.71,   0.07,  23.98,   0.09,  20.84,    0.10,  9.81e-07,  9.59e-07,  9.81e-07,  nan ],
	[   520,   24.39,   0.09,   30.95,   0.07,  23.82,   0.09,  21.72,    0.10,  1.00e-06,  9.46e-07,  9.46e-07,  nan ],
	[   530,   25.90,   0.09,   32.71,   0.07,  23.22,   0.10,  20.64,    0.11,  9.50e-07,  1.05e-06,  1.05e-06,  nan ],
	[   540,   26.59,   0.09,   32.49,   0.07,  25.16,   0.09,  21.47,    0.11,  1.29e-06,  9.72e-07,  1.24e-06,  nan ],
	[   550,   26.37,   0.09,   34.62,   0.07,  25.77,   0.09,  21.25,    0.11,  1.32e-06,  1.14e-06,  1.24e-06,  nan ],
	[   560,   26.78,   0.09,   35.41,   0.07,  25.92,   0.10,  21.10,    0.12,  1.42e-06,  1.32e-06,  1.31e-06,  nan ],
	[   570,   27.74,   0.09,   35.26,   0.07,  26.59,   0.10,  21.18,    0.12,  1.39e-06,  1.50e-06,  1.28e-06,  nan ],
	[   580,   27.01,   0.10,   36.51,   0.07,  26.95,   0.10,  21.76,    0.12,  9.60e-07,  8.68e-07,  9.60e-07,  nan ],
	[   590,   28.49,   0.10,   37.77,   0.07,  27.62,   0.10,  21.18,    0.13,  1.35e-06,  1.45e-06,  1.27e-06,  nan ],
	[   600,   29.46,   0.10,   39.06,   0.07,  28.29,   0.10,  21.86,    0.13,  1.13e-06,  1.17e-06,  1.12e-06,  nan ],
	[   610,   29.24,   0.10,   38.75,   0.08,  28.19,   0.11,  21.62,    0.14,  1.10e-06,  1.12e-06,  1.12e-06,  nan ],
	[   620,   29.93,   0.10,   40.03,   0.08,  29.39,   0.10,  22.03,    0.14,  1.35e-06,  1.21e-06,  1.12e-06,  nan ],
	[   630,   30.27,   0.11,   39.38,   0.08,  29.21,   0.11,  21.67,    0.15,  8.12e-07,  8.93e-07,  8.93e-07,  nan ],
	[   640,   32.88,   0.10,   43.19,   0.08,  29.88,   0.11,  22.33,    0.15,  1.17e-06,  1.30e-06,  1.17e-06,  nan ],
	[   650,   31.37,   0.11,   42.29,   0.08,  29.98,   0.11,  21.05,    0.16,  1.17e-06,  1.07e-06,  1.05e-06,  nan ],
	[   660,   31.44,   0.11,   43.09,   0.08,  30.39,   0.11,  22.13,    0.16,  1.30e-06,  1.21e-06,  1.32e-06,  nan ],
	[   670,   32.12,   0.11,   42.89,   0.08,  31.32,   0.11,  21.69,    0.17,  1.48e-06,  1.39e-06,  1.56e-06,  nan ],
	[   680,   32.00,   0.12,   43.68,   0.08,  31.41,   0.12,  22.18,    0.17,  1.21e-06,  1.27e-06,  1.26e-06,  nan ],
	[   690,   32.34,   0.12,   45.48,   0.08,  31.77,   0.12,  21.93,    0.17,  1.24e-06,  1.16e-06,  1.24e-06,  nan ],
	[   700,   33.02,   0.12,   44.65,   0.09,  32.18,   0.12,  21.71,    0.18,  1.35e-06,  1.21e-06,  1.28e-06,  nan ],
	[   710,   33.97,   0.12,   46.44,   0.09,  32.60,   0.12,  21.73,    0.19,  1.25e-06,  1.22e-06,  1.13e-06,  nan ],
	[   720,   35.21,   0.12,   48.28,   0.09,  34.11,   0.12,  22.61,    0.18,  1.78e-06,  1.54e-06,  1.53e-06,  nan ],
	[   730,   35.34,   0.12,   47.91,   0.09,  33.12,   0.13,  21.69,    0.20,  1.78e-06,  1.85e-06,  1.93e-06,  nan ],
	[   740,   35.41,   0.12,   48.84,   0.09,  34.03,   0.13,  22.18,    0.20,  1.41e-06,  1.33e-06,  1.41e-06,  nan ],
	[   750,   36.94,   0.12,   50.16,   0.09,  34.96,   0.13,  21.99,    0.21,  1.06e-06,  1.22e-06,  1.17e-06,  nan ],
	[   760,   37.34,   0.12,   51.37,   0.09,  34.80,   0.13,  21.94,    0.21,  1.54e-06,  1.72e-06,  1.71e-06,  nan ],
	[   770,   37.68,   0.13,   52.32,   0.09,  35.16,   0.14,  22.20,    0.21,  1.04e-06,  1.04e-06,  1.11e-06,  nan ],
	[   780,   38.09,   0.13,   53.13,   0.09,  36.14,   0.13,  22.48,    0.22,  1.12e-06,  1.28e-06,  1.18e-06,  nan ],
	[   790,   38.50,   0.13,   54.36,   0.09,  36.24,   0.14,  22.04,    0.23,  1.52e-06,  1.35e-06,  1.42e-06,  nan ],
	[   800,   38.91,   0.13,   56.47,   0.09,  36.90,   0.14,  22.79,    0.23,  1.38e-06,  1.30e-06,  1.30e-06,  nan ],
	[   810,   39.53,   0.13,   55.98,   0.09,  37.26,   0.14,  22.19,    0.24,  1.30e-06,  1.36e-06,  1.23e-06,  nan ],
	[   820,   40.80,   0.13,   57.22,   0.09,  37.67,   0.14,  22.27,    0.24,  1.16e-06,  1.15e-06,  1.36e-06,  nan ],
	[   830,   41.50,   0.13,   57.46,   0.10,  38.85,   0.14,  21.83,    0.25,  1.28e-06,  1.11e-06,  1.12e-06,  nan ],
	[   840,   40.96,   0.14,   58.28,   0.10,  39.01,   0.14,  22.33,    0.25,  1.38e-06,  1.38e-06,  1.45e-06,  nan ],
	[   850,   41.66,   0.14,   59.82,   0.10,  39.36,   0.15,  22.10,    0.26,  1.01e-06,  1.08e-06,  1.08e-06,  nan ],
	[   860,   42.35,   0.14,   60.34,   0.10,  40.10,   0.15,  22.36,    0.27,  1.21e-06,  1.07e-06,  1.07e-06,  nan ],
	[   870,   43.64,   0.14,   61.16,   0.10,  39.88,   0.15,  22.22,    0.27,  1.19e-06,  1.47e-06,  1.12e-06,  nan ],
	[   880,   44.65,   0.14,   62.72,   0.10,  41.65,   0.15,  22.00,    0.28,  1.32e-06,  1.18e-06,  1.26e-06,  nan ],
	[   890,   45.05,   0.14,   63.39,   0.10,  41.47,   0.15,  22.20,    0.29,  1.24e-06,  1.15e-06,  1.26e-06,  nan ],
	[   900,   45.07,   0.14,   64.97,   0.10,  42.14,   0.15,  22.15,    0.29,  1.43e-06,  1.32e-06,  1.38e-06,  nan ],
	[  1000,   49.49,   0.16,   73.53,   0.11,  46.54,   0.17,  22.64,    0.35,  1.26e-06,  1.39e-06,  1.43e-06,  nan ],
	[  1100,   54.72,   0.18,   82.13,   0.12,  30.78,   0.31,  22.80,    0.43,  1.62e-06,  1.48e-06,  1.48e-06,  nan ],
	[  1200,   61.32,   0.19,   92.33,   0.12,  33.81,   0.34,  22.36,    0.52,  1.53e-06,  1.53e-06,  1.43e-06,  nan ],
	[  1300,   66.01,   0.21,   98.05,   0.14,  35.07,   0.39,  23.54,    0.58,  2.10e-06,  2.18e-06,  2.00e-06,  nan ],
	[  1400,   72.35,   0.22,  109.91,   0.14,  38.57,   0.41,  23.46,    0.67,  2.37e-06,  2.09e-06,  2.06e-06,  nan ],
	[  1500,   76.34,   0.24,  117.71,   0.15,  40.76,   0.44,  23.52,    0.77,  2.01e-06,  1.73e-06,  1.81e-06,  nan ],
	[  1600,   81.34,   0.25,  125.89,   0.16,  42.54,   0.48,  22.21,    0.92,  1.84e-06,  1.98e-06,  1.99e-06,  nan ],
	[  1700,   86.35,   0.27,  132.23,   0.17,  44.08,   0.52,  19.70,    1.17,  1.90e-06,  2.09e-06,  1.96e-06,  nan ],
	[  1800,   91.05,   0.28,  138.08,   0.19,  46.66,   0.56,  17.99,    1.44,  2.27e-06,  2.32e-06,  2.11e-06,  nan ],
	[  1900,   96.29,   0.30,  147.48,   0.20,  49.50,   0.58,  17.34,    1.67,  2.27e-06,  2.08e-06,  1.94e-06,  nan ],
	[  2000,  100.69,   0.32,  149.74,   0.21,  51.56,   0.62,  17.13,    1.87,  2.41e-06,  2.20e-06,  2.13e-06,  nan ],
	[  2100,  103.26,   0.34,  155.55,   0.23,  38.66,   0.91,  17.13,    2.06,  2.33e-06,  2.47e-06,  2.34e-06,  nan ],
	[  2200,  110.70,   0.35,  164.32,   0.24,  40.87,   0.95,  16.86,    2.30,  2.41e-06,  2.62e-06,  2.43e-06,  nan ],
	[  2300,  114.45,   0.37,  170.13,   0.25,  42.47,   1.00,  17.55,    2.41,  2.65e-06,  2.50e-06,  2.51e-06,  nan ],
	[  2400,  120.34,   0.38,  179.40,   0.26,  44.12,   1.04,  17.28,    2.67,  2.51e-06,  2.74e-06,  2.62e-06,  nan ],
	[  2500,  124.76,   0.40,  182.63,   0.27,  45.90,   1.09,  17.29,    2.89,  2.87e-06,  2.60e-06,  2.58e-06,  nan ],
	[  2600,  130.06,   0.42,  191.85,   0.28,  47.76,   1.13,  17.24,    3.14,  2.64e-06,  2.72e-06,  2.90e-06,  nan ],
	[  2700,  134.18,   0.43,  195.80,   0.30,  49.24,   1.19,  17.55,    3.32,  2.82e-06,  2.94e-06,  2.77e-06,  nan ],
	[  2800,  138.53,   0.45,  199.85,   0.31,  50.32,   1.25,  17.70,    3.55,  2.73e-06,  2.55e-06,  2.66e-06,  nan ],
	[  2900,  142.31,   0.47,  208.37,   0.32,  52.30,   1.29,  18.28,    3.68,  2.62e-06,  2.53e-06,  2.53e-06,  nan ],
	[  3000,  145.82,   0.49,  215.66,   0.33,  53.84,   1.34,  17.49,    4.12,  3.28e-06,  2.94e-06,  3.06e-06,  nan ],
	[  3100,  152.03,   0.51,  222.95,   0.34,  43.46,   1.77,  17.07,    4.51,  2.84e-06,  2.84e-06,  2.76e-06,  nan ],
	[  3200,  155.83,   0.53,  232.90,   0.35,  45.13,   1.82,  17.71,    4.63,  2.50e-06,  2.83e-06,  2.70e-06,  nan ],
	[  3300,  161.12,   0.54,  228.77,   0.38,  46.44,   1.88,  17.74,    4.91,  3.05e-06,  2.75e-06,  2.67e-06,  nan ],
	[  3400,  164.29,   0.56,  241.48,   0.38,  47.64,   1.94,  17.81,    5.20,  3.29e-06,  3.45e-06,  2.87e-06,  nan ],
	[  3500,  167.64,   0.58,  247.57,   0.40,  48.85,   2.01,  17.77,    5.52,  2.75e-06,  2.74e-06,  2.73e-06,  nan ],
	[  3600,  172.30,   0.60,  246.35,   0.42,  50.13,   2.07,  16.44,    6.31,  2.92e-06,  3.01e-06,  2.92e-06,  nan ],
	[  3700,  174.47,   0.63,  255.45,   0.43,  51.23,   2.14,  17.86,    6.13,  2.64e-06,  2.66e-06,  2.71e-06,  nan ],
	[  3800,  180.53,   0.64,  255.65,   0.45,  52.46,   2.20,  17.72,    6.52,  2.87e-06,  3.09e-06,  2.99e-06,  nan ],
	[  3900,  177.22,   0.69,  252.50,   0.48,  53.72,   2.27,  17.93,    6.79,  3.52e-06,  3.90e-06,  3.58e-06,  nan ],
	[  4000,  175.40,   0.73,  262.37,   0.49,  54.72,   2.34,  17.59,    7.28,  3.26e-06,  3.19e-06,  3.56e-06,  nan ],
	[  4100,  179.59,   0.75,  265.28,   0.51,  46.14,   2.92,  17.97,    7.49,  3.35e-06,  3.85e-06,  3.38e-06,  nan ],
	[  4200,  176.70,   0.80,  259.02,   0.55,  47.23,   2.99,  17.82,    7.92,  3.97e-06,  3.47e-06,  3.72e-06,  nan ],
	[  4300,  180.89,   0.82,  258.71,   0.57,  48.43,   3.06,  17.94,    8.25,  3.72e-06,  4.09e-06,  4.02e-06,  nan ],
	[  4400,  184.19,   0.84,  255.64,   0.61,  49.39,   3.14,  18.05,    8.58,  3.89e-06,  4.00e-06,  4.11e-06,  nan ],
	[  4500,  184.15,   0.88,  254.38,   0.64,  50.42,   3.21,  17.92,    9.04,  3.50e-06,  3.78e-06,  3.92e-06,  nan ],
	[  4600,  186.46,   0.91,  254.29,   0.67,  51.61,   3.28,  16.77,   10.10,  3.67e-06,  4.01e-06,  3.83e-06,  nan ],
	[  4700,  186.86,   0.95,  257.27,   0.69,  52.44,   3.37,  17.87,    9.89,  3.25e-06,  3.96e-06,  3.58e-06,  nan ],
	[  4800,  189.13,   0.97,  260.82,   0.71,  53.61,   3.44,  16.83,   10.96,  3.40e-06,  3.51e-06,  3.21e-06,  nan ],
	[  4900,  187.07,   1.03,  259.63,   0.74,  54.29,   3.54,  17.88,   10.75,  3.81e-06,  3.63e-06,  3.46e-06,  nan ],
	[  5000,  188.40,   1.06,  260.84,   0.77,  54.99,   3.64,  17.64,   11.34,  3.82e-06,  3.93e-06,  3.68e-06,  nan ],
	[  5100,  191.66,   1.09,  257.90,   0.81,  55.91,   3.72,  17.68,   11.78,  4.54e-06,  4.33e-06,  4.23e-06,  nan ],
	[  5200,  191.47,   1.13,  258.20,   0.84,  48.62,   4.45,  17.26,   12.54,  4.56e-06,  3.60e-06,  3.79e-06,  nan ],
	[  5300,  191.94,   1.17,  262.04,   0.86,  49.76,   4.52,  17.82,   12.62,  4.35e-06,  4.20e-06,  3.78e-06,  nan ],
	[  5400,  194.27,   1.20,  259.81,   0.90,  50.70,   4.60,  17.99,   12.97,  4.37e-06,  4.19e-06,  4.00e-06,  nan ],
	[  5500,  194.28,   1.25,  260.00,   0.93,  51.46,   4.70,  17.94,   13.49,  3.96e-06,  4.21e-06,  3.79e-06,  nan ],
	[  5600,  198.22,   1.27,  268.37,   0.94,  52.12,   4.82,  17.86,   14.05,  4.30e-06,  4.23e-06,  4.11e-06,  nan ],
	[  5700,  200.45,   1.30,  262.64,   0.99,  52.79,   4.93,  17.82,   14.59,  4.82e-06,  4.57e-06,  4.38e-06,  nan ],
	[  5800,  199.09,   1.35,  267.61,   1.01,  53.51,   5.03,  17.96,   14.99,  4.72e-06,  4.16e-06,  4.47e-06,  nan ],
	[  5900,  203.15,   1.37,  266.56,   1.04,  54.17,   5.14,  18.07,   15.42,  4.44e-06,  4.57e-06,  4.30e-06,  nan ],
	[  6000,  202.69,   1.42,  269.76,   1.07,  54.76,   5.26,  18.14,   15.88,  3.96e-06,  4.19e-06,  4.37e-06,  nan ],
	[  6100,  205.20,   1.45,  266.80,   1.12,  56.28,   5.29,  17.88,   16.65,  4.42e-06,  4.36e-06,  4.26e-06,  nan ],
	[  6200,  207.12,   1.49,  270.98,   1.14,  50.06,   6.14,  17.99,   17.09,  4.30e-06,  3.72e-06,  3.63e-06,  nan ],
	[  6300,  208.37,   1.52,  271.91,   1.17,  50.13,   6.34,  17.94,   17.71,  4.10e-06,  3.97e-06,  3.92e-06,  nan ],
	[  6400,  209.85,   1.56,  271.57,   1.21,  51.56,   6.36,  19.63,   16.70,  4.27e-06,  4.06e-06,  4.05e-06,  nan ],
	[  6500,  212.24,   1.59,  276.25,   1.22,  51.80,   6.53,  18.00,   18.78,  4.34e-06,  4.60e-06,  4.33e-06,  nan ],
	[  6600,  213.18,   1.64,  274.91,   1.27,  51.85,   6.72,  18.11,   19.25,  4.47e-06,  4.21e-06,  4.24e-06,  nan ],
	[  6700,  214.71,   1.67,  273.98,   1.31,  52.51,   6.84,  18.11,   19.84,  4.60e-06,  3.92e-06,  4.02e-06,  nan ],
	[  6800,  212.88,   1.74,  275.89,   1.34,  53.18,   6.96,  18.16,   20.37,  5.02e-06,  4.63e-06,  4.52e-06,  nan ],
	[  6900,  216.07,   1.76,  277.31,   1.37,  53.74,   7.09,  18.00,   21.17,  4.32e-06,  4.04e-06,  4.02e-06,  nan ],
	[  7000,  218.19,   1.80,  278.26,   1.41,  54.96,   7.13,  18.11,   21.65,  3.98e-06,  4.41e-06,  4.03e-06,  nan ],
	[  7100,  216.76,   1.86,  283.29,   1.42,  55.11,   7.32,  18.08,   22.31,  3.96e-06,  4.29e-06,  3.91e-06,  nan ],
	[  7200,  219.23,   1.89,  282.76,   1.47,  50.10,   8.28,  17.71,   23.42,  4.42e-06,  4.70e-06,  4.28e-06,  nan ],
	[  7300,  223.14,   1.91,  284.65,   1.50,  50.74,   8.40,  17.67,   24.14,  4.03e-06,  3.88e-06,  4.05e-06,  nan ],
	[  7400,  222.20,   1.97,  284.49,   1.54,  51.15,   8.57,  17.91,   24.46,  4.23e-06,  4.36e-06,  4.13e-06,  nan ],
	[  7500,  224.39,   2.01,  282.23,   1.59,  51.94,   8.67,  17.97,   25.05,  5.06e-06,  4.69e-06,  4.76e-06,  nan ],
	[  7600,  228.22,   2.03,  281.63,   1.64,  52.31,   8.84,  17.87,   25.87,  4.94e-06,  5.63e-06,  4.68e-06,  nan ],
	[  7700,  225.17,   2.11,  280.73,   1.69,  53.66,   8.84,  16.44,   28.86,  4.60e-06,  4.57e-06,  4.48e-06,  nan ],
	[  7800,  224.26,   2.17,  283.87,   1.71,  53.24,   9.14,  17.82,   27.32,  4.75e-06,  4.47e-06,  4.67e-06,  nan ],
	[  7900,  224.83,   2.22,  282.47,   1.77,  54.19,   9.22,  17.83,   28.00,  5.08e-06,  4.45e-06,  4.40e-06,  nan ],
	[  8000,  226.50,   2.26,  282.77,   1.81,  54.30,   9.43,  17.73,   28.88,  5.85e-06,  5.49e-06,  5.44e-06,  nan ],
	[  8100,  226.77,   2.32,  284.08,   1.85,  55.60,   9.44,  17.26,   30.41,  5.83e-06,  5.85e-06,  5.67e-06,  nan ],
	[  8200,  224.83,   2.39,  286.92,   1.88,  49.90,  10.78,  16.65,   32.32,  4.92e-06,  4.59e-06,  5.16e-06,  nan ],
	[  8300,  227.40,   2.42,  285.61,   1.93,  50.76,  10.86,  17.03,   32.37,  5.43e-06,  5.51e-06,  5.73e-06,  nan ],
	[  8400,  225.12,   2.51,  286.44,   1.97,  51.50,  10.96,  16.65,   33.90,  4.96e-06,  5.60e-06,  4.89e-06,  nan ],
	[  8500,  229.40,   2.52,  284.63,   2.03,  52.00,  11.12,  17.78,   32.51,  5.41e-06,  5.41e-06,  5.64e-06,  nan ],
	[  8600,  227.86,   2.60,  286.32,   2.07,  52.61,  11.25,  17.80,   33.25,  5.15e-06,  4.98e-06,  5.36e-06,  nan ],
	[  8700,  226.74,   2.67,  289.05,   2.10,  52.73,  11.49,  18.19,   33.30,  5.43e-06,  5.18e-06,  5.32e-06,  nan ],
	[  8800,  224.33,   2.76,  285.81,   2.17,  53.56,  11.57,  17.92,   34.58,  5.13e-06,  5.60e-06,  5.29e-06,  nan ],
	[  8900,  227.91,   2.78,  287.04,   2.21,  54.03,  11.73,  17.85,   35.50,  5.01e-06,  4.99e-06,  5.17e-06,  nan ],
	[  9000,  226.85,   2.86,  283.02,   2.29,  54.48,  11.90,  17.94,   36.13,  5.66e-06,  5.96e-06,  6.03e-06,  nan ],
	[ 10000,  234.22,   3.42,  285.95,   2.80,  54.54,  14.67,  17.67,   45.27,  5.57e-06,  5.37e-06,  5.49e-06,  nan ],
	[ 12000,  238.44,   4.83,  291.02,   3.96,  54.29,  21.22,  17.40,   66.22,  7.29e-06,  6.05e-06,  6.06e-06,  nan ],
	[ 14000,  248.44,   6.31,  293.55,   5.34,  54.85,  28.59,  16.85,   93.08,  6.63e-06,  6.07e-06,  7.14e-06,  nan ],
	[ 16000,  253.09,   8.09,  291.10,   7.04,  54.93,  37.29,  15.65,  130.87,  6.96e-06,  8.01e-06,  7.32e-06,  nan ],
	[ 18000,  252.46,  10.27,  296.09,   8.75,  54.98,  47.15,  16.55,  156.62,  8.14e-06,  8.25e-06,  7.92e-06,  nan ],
	[ 20000,  255.45,  12.53,  294.49,  10.87,  54.14,  59.11,  17.20,  186.02,  8.79e-06,  8.79e-06,  9.47e-06,  nan ],
])

# numactl --interleave=all ../testing/testing_chemv -U -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
chemv_U = array([
	[    10,    0.03,   0.03,    0.03,   0.03,   0.04,   0.02,   0.48,    0.00,  2.13e-07,  1.07e-07,  2.86e-07,  nan ],
	[    11,    0.04,   0.03,    0.04,   0.03,   0.05,   0.02,   0.58,    0.00,  1.94e-07,  1.23e-07,  1.73e-07,  nan ],
	[    12,    0.04,   0.03,    0.04,   0.03,   0.06,   0.02,   1.36,    0.00,  1.78e-07,  1.59e-07,  1.78e-07,  nan ],
	[    13,    0.05,   0.03,    0.05,   0.03,   0.07,   0.02,   0.70,    0.00,  2.07e-07,  1.49e-07,  1.51e-07,  nan ],
	[    14,    0.05,   0.03,    0.06,   0.03,   0.09,   0.02,   0.91,    0.00,  1.52e-07,  1.52e-07,  2.04e-07,  nan ],
	[    15,    0.07,   0.03,    0.07,   0.03,   0.10,   0.02,   1.04,    0.00,  1.95e-07,  1.42e-07,  1.80e-07,  nan ],
	[    16,    0.07,   0.03,    0.08,   0.03,   0.12,   0.02,   1.17,    0.00,  1.33e-07,  2.40e-07,  2.38e-07,  nan ],
	[    17,    0.08,   0.03,    0.09,   0.03,   0.11,   0.02,   1.17,    0.00,  1.59e-07,  1.62e-07,  1.59e-07,  nan ],
	[    18,    0.09,   0.03,    0.10,   0.03,   0.13,   0.02,   0.98,    0.00,  2.37e-07,  2.12e-07,  2.37e-07,  nan ],
	[    19,    0.10,   0.03,    0.11,   0.03,   0.13,   0.02,   0.45,    0.01,  3.17e-07,  2.24e-07,  2.24e-07,  nan ],
	[    20,    0.12,   0.03,    0.12,   0.03,   0.16,   0.02,   1.80,    0.00,  1.97e-07,  1.55e-07,  2.13e-07,  nan ],
	[    21,    0.12,   0.03,    0.13,   0.03,   0.16,   0.02,   1.76,    0.00,  2.84e-07,  1.83e-07,  2.75e-07,  nan ],
	[    22,    0.13,   0.03,    0.14,   0.03,   0.18,   0.02,   1.93,    0.00,  2.60e-07,  3.57e-07,  1.94e-07,  nan ],
	[    23,    0.15,   0.03,    0.15,   0.03,   0.20,   0.02,   2.36,    0.00,  2.99e-07,  1.85e-07,  2.52e-07,  nan ],
	[    24,    0.15,   0.03,    0.16,   0.03,   0.21,   0.02,   2.28,    0.00,  2.41e-07,  2.38e-07,  2.40e-07,  nan ],
	[    25,    0.16,   0.03,    0.17,   0.03,   0.22,   0.02,   2.47,    0.00,  2.36e-07,  2.41e-07,  2.41e-07,  nan ],
	[    26,    0.17,   0.03,    0.19,   0.03,   0.25,   0.02,   2.67,    0.00,  1.85e-07,  1.64e-07,  1.64e-07,  nan ],
	[    27,    0.18,   0.03,    0.20,   0.03,   0.26,   0.02,   3.23,    0.00,  2.23e-07,  2.13e-07,  2.55e-07,  nan ],
	[    28,    0.20,   0.03,    0.21,   0.03,   0.28,   0.02,   2.13,    0.00,  2.46e-07,  2.28e-07,  2.75e-07,  nan ],
	[    29,    0.22,   0.03,    0.22,   0.03,   0.28,   0.03,   2.47,    0.00,  1.97e-07,  2.71e-07,  1.47e-07,  nan ],
	[    30,    0.24,   0.03,    0.24,   0.03,   0.33,   0.02,   2.44,    0.00,  2.01e-07,  1.42e-07,  2.29e-07,  nan ],
	[    31,    0.26,   0.03,    0.26,   0.03,   0.32,   0.03,   2.60,    0.00,  1.95e-07,  2.54e-07,  2.63e-07,  nan ],
	[    32,    0.26,   0.03,    0.24,   0.04,   0.36,   0.02,   2.77,    0.00,  2.15e-07,  2.46e-07,  1.81e-07,  nan ],
	[    33,    0.27,   0.03,    0.23,   0.04,   0.35,   0.03,   2.94,    0.00,  2.33e-07,  1.83e-07,  2.38e-07,  nan ],
	[    34,    0.31,   0.03,    0.24,   0.04,   0.39,   0.03,   2.38,    0.00,  3.37e-07,  2.31e-07,  3.41e-07,  nan ],
	[    35,    0.32,   0.03,    0.26,   0.04,   0.41,   0.03,   2.52,    0.00,  3.31e-07,  3.45e-07,  3.31e-07,  nan ],
	[    36,    0.34,   0.03,    0.28,   0.04,   0.44,   0.02,   3.77,    0.00,  3.35e-07,  3.18e-07,  2.37e-07,  nan ],
	[    37,    0.36,   0.03,    0.29,   0.04,   0.47,   0.02,   2.81,    0.00,  2.31e-07,  3.46e-07,  2.92e-07,  nan ],
	[    38,    0.35,   0.03,    0.31,   0.04,   0.50,   0.02,   3.15,    0.00,  3.05e-07,  2.37e-07,  3.62e-07,  nan ],
	[    39,    0.37,   0.03,    0.32,   0.04,   0.50,   0.03,   3.12,    0.00,  3.09e-07,  3.09e-07,  1.97e-07,  nan ],
	[    40,    0.41,   0.03,    0.35,   0.04,   0.53,   0.03,   4.28,    0.00,  2.13e-07,  2.13e-07,  2.38e-07,  nan ],
	[    41,    0.41,   0.03,    0.36,   0.04,   0.56,   0.02,   3.65,    0.00,  3.35e-07,  2.83e-07,  2.33e-07,  nan ],
	[    42,    0.43,   0.03,    0.36,   0.04,   0.58,   0.03,   3.61,    0.00,  3.05e-07,  2.76e-07,  2.81e-07,  nan ],
	[    43,    0.48,   0.03,    0.40,   0.04,   0.61,   0.03,   3.78,    0.00,  4.70e-07,  3.66e-07,  3.75e-07,  nan ],
	[    44,    0.50,   0.03,    0.43,   0.04,   0.64,   0.03,   3.95,    0.00,  2.76e-07,  2.68e-07,  3.48e-07,  nan ],
	[    45,    0.54,   0.03,    0.45,   0.04,   0.67,   0.03,   3.34,    0.01,  2.68e-07,  3.39e-07,  3.06e-07,  nan ],
	[    46,    0.55,   0.03,    0.46,   0.04,   0.73,   0.02,   4.58,    0.00,  2.78e-07,  2.62e-07,  4.15e-07,  nan ],
	[    47,    0.55,   0.03,    0.48,   0.04,   0.76,   0.02,   3.64,    0.01,  3.42e-07,  4.08e-07,  2.57e-07,  nan ],
	[    48,    0.61,   0.03,    0.51,   0.04,   0.80,   0.02,   3.99,    0.00,  3.28e-07,  3.20e-07,  2.51e-07,  nan ],
	[    49,    0.62,   0.03,    0.54,   0.04,   0.79,   0.03,   3.95,    0.01,  3.90e-07,  3.48e-07,  3.40e-07,  nan ],
	[    50,    0.63,   0.03,    0.50,   0.04,   0.79,   0.03,   4.11,    0.01,  3.08e-07,  3.15e-07,  3.24e-07,  nan ],
	[    51,    0.65,   0.03,    0.56,   0.04,   0.82,   0.03,   4.28,    0.01,  2.92e-07,  3.08e-07,  3.08e-07,  nan ],
	[    52,    0.70,   0.03,    0.60,   0.04,   0.86,   0.03,   5.83,    0.00,  3.10e-07,  3.69e-07,  2.94e-07,  nan ],
	[    53,    0.70,   0.03,    0.63,   0.04,   0.92,   0.03,   4.62,    0.01,  3.86e-07,  3.60e-07,  3.60e-07,  nan ],
	[    54,    0.72,   0.03,    0.63,   0.04,   0.92,   0.03,   4.02,    0.01,  3.60e-07,  2.55e-07,  2.30e-07,  nan ],
	[    55,    0.76,   0.03,    0.64,   0.04,   0.96,   0.03,   4.17,    0.01,  2.94e-07,  2.77e-07,  4.04e-07,  nan ],
	[    56,    0.74,   0.04,    0.66,   0.04,   0.96,   0.03,   4.32,    0.01,  3.47e-07,  2.81e-07,  3.47e-07,  nan ],
	[    57,    0.79,   0.03,    0.69,   0.04,   0.99,   0.03,   5.33,    0.01,  2.76e-07,  2.68e-07,  2.76e-07,  nan ],
	[    58,    0.75,   0.04,    0.71,   0.04,   1.02,   0.03,   5.51,    0.01,  2.94e-07,  2.63e-07,  2.37e-07,  nan ],
	[    59,    0.79,   0.04,    0.73,   0.04,   1.02,   0.03,   4.79,    0.01,  2.76e-07,  2.67e-07,  2.04e-07,  nan ],
	[    60,    0.80,   0.04,    0.74,   0.04,   0.95,   0.03,   4.76,    0.01,  2.70e-07,  3.18e-07,  2.29e-07,  nan ],
	[    61,    0.90,   0.03,    0.76,   0.04,   1.12,   0.03,   5.12,    0.01,  3.26e-07,  3.13e-07,  3.15e-07,  nan ],
	[    62,    0.85,   0.04,    0.79,   0.04,   1.12,   0.03,   6.29,    0.01,  3.48e-07,  2.75e-07,  3.31e-07,  nan ],
	[    63,    0.90,   0.04,    0.82,   0.04,   1.16,   0.03,   5.45,    0.01,  3.09e-07,  3.63e-07,  3.09e-07,  nan ],
	[    64,    1.12,   0.03,    0.93,   0.04,   1.24,   0.03,   4.85,    0.01,  3.37e-07,  4.00e-07,  3.77e-07,  nan ],
	[    65,    0.94,   0.04,    0.84,   0.04,   1.19,   0.03,   5.58,    0.01,  2.95e-07,  3.71e-07,  3.52e-07,  nan ],
	[    66,    0.99,   0.04,    0.87,   0.04,   1.19,   0.03,   4.98,    0.01,  3.52e-07,  3.66e-07,  3.52e-07,  nan ],
	[    67,    0.99,   0.04,    0.90,   0.04,   1.22,   0.03,   6.16,    0.01,  5.09e-07,  3.42e-07,  2.90e-07,  nan ],
	[    68,    1.02,   0.04,    0.94,   0.04,   1.27,   0.03,   5.47,    0.01,  3.39e-07,  3.39e-07,  3.37e-07,  nan ],
	[    69,    1.02,   0.04,    0.95,   0.04,   1.30,   0.03,   5.44,    0.01,  5.10e-07,  3.99e-07,  4.46e-07,  nan ],
	[    70,    1.06,   0.04,    0.93,   0.04,   1.33,   0.03,   4.94,    0.01,  3.49e-07,  4.37e-07,  3.93e-07,  nan ],
	[    71,    1.14,   0.04,    0.98,   0.04,   1.38,   0.03,   5.08,    0.01,  4.43e-07,  3.27e-07,  3.27e-07,  nan ],
	[    72,    1.18,   0.04,    1.03,   0.04,   1.41,   0.03,   6.12,    0.01,  3.44e-07,  4.25e-07,  3.35e-07,  nan ],
	[    73,    1.12,   0.04,    1.06,   0.04,   1.40,   0.03,   6.29,    0.01,  5.23e-07,  3.30e-07,  4.25e-07,  nan ],
	[    74,    1.24,   0.04,    1.12,   0.04,   1.54,   0.03,   8.93,    0.01,  5.26e-07,  4.16e-07,  4.25e-07,  nan ],
	[    75,    1.27,   0.04,    1.15,   0.04,   1.53,   0.03,   5.07,    0.01,  3.67e-07,  3.67e-07,  3.67e-07,  nan ],
	[    76,    1.28,   0.04,    1.15,   0.04,   1.63,   0.03,   6.59,    0.01,  3.62e-07,  4.02e-07,  5.03e-07,  nan ],
	[    77,    1.39,   0.03,    1.21,   0.04,   1.68,   0.03,   8.11,    0.01,  4.43e-07,  4.23e-07,  4.23e-07,  nan ],
	[    78,    1.38,   0.04,    1.18,   0.04,   1.42,   0.04,   6.31,    0.01,  4.15e-07,  3.53e-07,  4.03e-07,  nan ],
	[    79,    1.38,   0.04,    1.24,   0.04,   1.81,   0.03,   5.62,    0.01,  4.13e-07,  3.05e-07,  3.09e-07,  nan ],
	[    80,    1.38,   0.04,    1.30,   0.04,   1.74,   0.03,   7.54,    0.01,  3.44e-07,  3.84e-07,  3.81e-07,  nan ],
	[    81,    1.37,   0.04,    1.30,   0.04,   1.72,   0.03,   8.62,    0.01,  3.83e-07,  3.02e-07,  4.71e-07,  nan ],
	[    82,    1.44,   0.04,    1.31,   0.04,   1.71,   0.03,   9.19,    0.01,  3.79e-07,  3.79e-07,  3.84e-07,  nan ],
	[    83,    1.44,   0.04,    1.23,   0.05,   1.74,   0.03,   6.92,    0.01,  4.95e-07,  3.68e-07,  4.60e-07,  nan ],
	[    84,    1.48,   0.04,    1.41,   0.04,   1.85,   0.03,   5.74,    0.01,  3.85e-07,  3.74e-07,  3.74e-07,  nan ],
	[    85,    1.50,   0.04,    1.43,   0.04,   1.84,   0.03,   8.51,    0.01,  3.81e-07,  3.59e-07,  2.84e-07,  nan ],
	[    86,    1.55,   0.04,    1.43,   0.04,   1.94,   0.03,   5.49,    0.01,  3.56e-07,  3.59e-07,  3.66e-07,  nan ],
	[    87,    1.67,   0.04,    1.47,   0.04,   1.93,   0.03,   6.80,    0.01,  5.37e-07,  3.51e-07,  3.57e-07,  nan ],
	[    88,    1.61,   0.04,    1.54,   0.04,   1.97,   0.03,   7.77,    0.01,  3.47e-07,  2.74e-07,  2.91e-07,  nan ],
	[    89,    1.70,   0.04,    1.54,   0.04,   2.02,   0.03,   9.32,    0.01,  3.66e-07,  3.83e-07,  4.29e-07,  nan ],
	[    90,    1.68,   0.04,    1.61,   0.04,   2.06,   0.03,   8.37,    0.01,  5.09e-07,  4.43e-07,  4.32e-07,  nan ],
	[   100,    2.20,   0.04,    1.98,   0.04,   2.32,   0.04,   6.31,    0.01,  3.89e-07,  3.15e-07,  4.58e-07,  nan ],
	[   110,    2.66,   0.04,    2.22,   0.04,   2.80,   0.04,   9.80,    0.01,  3.54e-07,  4.16e-07,  4.17e-07,  nan ],
	[   120,    3.06,   0.04,    2.78,   0.04,   3.24,   0.04,  11.65,    0.01,  4.52e-07,  4.45e-07,  3.83e-07,  nan ],
	[   130,    3.19,   0.04,    3.05,   0.04,   3.70,   0.04,  11.25,    0.01,  5.25e-07,  4.84e-07,  5.01e-07,  nan ],
	[   140,    3.44,   0.05,    3.44,   0.05,   4.05,   0.04,  11.46,    0.01,  4.41e-07,  4.61e-07,  4.46e-07,  nan ],
	[   150,    4.06,   0.04,    3.77,   0.05,   4.57,   0.04,  12.92,    0.01,  5.09e-07,  5.09e-07,  4.10e-07,  nan ],
	[   160,    4.59,   0.05,    4.82,   0.04,   5.16,   0.04,  14.70,    0.01,  5.33e-07,  4.98e-07,  4.98e-07,  nan ],
	[   170,    4.97,   0.05,    4.84,   0.05,   5.56,   0.04,  13.04,    0.02,  5.46e-07,  5.40e-07,  5.55e-07,  nan ],
	[   180,    5.68,   0.05,    5.45,   0.05,   5.96,   0.04,  12.46,    0.02,  6.99e-07,  5.99e-07,  6.99e-07,  nan ],
	[   190,    6.46,   0.05,    5.96,   0.05,   6.64,   0.04,  15.45,    0.02,  4.90e-07,  5.02e-07,  4.84e-07,  nan ],
	[   200,    6.35,   0.05,    6.73,   0.05,   7.19,   0.04,  16.10,    0.02,  5.35e-07,  6.52e-07,  5.39e-07,  nan ],
	[   210,    6.96,   0.05,    7.27,   0.05,   7.57,   0.05,  16.20,    0.02,  6.50e-07,  6.54e-07,  6.58e-07,  nan ],
	[   220,    7.23,   0.05,    7.94,   0.05,   8.13,   0.05,  17.03,    0.02,  6.28e-07,  6.95e-07,  6.94e-07,  nan ],
	[   230,    8.01,   0.05,    7.60,   0.06,   8.51,   0.05,  16.39,    0.03,  7.33e-07,  7.99e-07,  7.99e-07,  nan ],
	[   240,    8.61,   0.05,    8.92,   0.05,   9.09,   0.05,  17.21,    0.03,  6.36e-07,  8.92e-07,  6.76e-07,  nan ],
	[   250,    9.68,   0.05,    9.63,   0.05,   9.68,   0.05,  17.88,    0.03,  6.57e-07,  6.22e-07,  6.13e-07,  nan ],
	[   260,    9.39,   0.06,   10.28,   0.05,   9.88,   0.06,  17.55,    0.03,  7.07e-07,  5.88e-07,  5.93e-07,  nan ],
	[   270,   10.12,   0.06,   10.25,   0.06,  10.47,   0.06,  16.73,    0.04,  7.24e-07,  5.90e-07,  7.15e-07,  nan ],
	[   280,   10.71,   0.06,   11.70,   0.05,  11.25,   0.06,  17.99,    0.04,  6.68e-07,  6.78e-07,  6.74e-07,  nan ],
	[   290,   11.63,   0.06,   12.28,   0.06,  11.87,   0.06,  17.73,    0.04,  6.74e-07,  7.39e-07,  7.37e-07,  nan ],
	[   300,   12.29,   0.06,   12.91,   0.06,  12.24,   0.06,  18.62,    0.04,  7.41e-07,  7.41e-07,  7.19e-07,  nan ],
	[   310,   13.12,   0.06,   12.86,   0.06,  12.91,   0.06,  19.29,    0.04,  8.25e-07,  7.88e-07,  8.01e-07,  nan ],
	[   320,   14.21,   0.06,   16.13,   0.05,  13.75,   0.06,  19.18,    0.04,  9.54e-07,  8.59e-07,  9.54e-07,  nan ],
	[   330,   13.45,   0.07,   15.04,   0.06,  13.90,   0.06,  19.52,    0.04,  6.94e-07,  6.63e-07,  7.41e-07,  nan ],
	[   340,   13.30,   0.07,   16.03,   0.06,  14.27,   0.07,  19.78,    0.05,  8.09e-07,  8.08e-07,  8.13e-07,  nan ],
	[   350,   14.90,   0.07,   15.40,   0.06,  15.40,   0.06,  20.14,    0.05,  7.19e-07,  8.04e-07,  8.04e-07,  nan ],
	[   360,   15.54,   0.07,   17.33,   0.06,  15.76,   0.07,  19.67,    0.05,  9.17e-07,  8.52e-07,  8.73e-07,  nan ],
	[   370,   15.96,   0.07,   18.38,   0.06,  16.41,   0.07,  19.63,    0.06,  8.49e-07,  8.50e-07,  7.82e-07,  nan ],
	[   380,   17.56,   0.07,   19.61,   0.06,  17.07,   0.07,  19.30,    0.06,  8.87e-07,  8.14e-07,  9.08e-07,  nan ],
	[   390,   15.67,   0.08,   17.19,   0.07,  17.43,   0.07,  20.66,    0.06,  8.92e-07,  8.75e-07,  8.64e-07,  nan ],
	[   400,   12.36,   0.10,   20.41,   0.06,  18.33,   0.07,  20.41,    0.06,  9.56e-07,  8.70e-07,  8.93e-07,  nan ],
	[   410,   18.26,   0.07,   21.44,   0.06,  18.50,   0.07,  20.74,    0.07,  8.22e-07,  8.21e-07,  8.22e-07,  nan ],
	[   420,   18.39,   0.08,   21.76,   0.07,  19.16,   0.07,  20.20,    0.07,  9.47e-07,  8.75e-07,  8.75e-07,  nan ],
	[   430,   19.28,   0.08,   20.62,   0.07,  19.83,   0.07,  20.96,    0.07,  9.25e-07,  9.33e-07,  9.23e-07,  nan ],
	[   440,   20.43,   0.08,   23.20,   0.07,  20.43,   0.08,  21.03,    0.07,  1.11e-06,  1.05e-06,  1.11e-06,  nan ],
	[   450,   20.05,   0.08,   23.27,   0.07,  20.85,   0.08,  20.85,    0.08,  9.22e-07,  9.87e-07,  1.10e-06,  nan ],
	[   460,   20.41,   0.08,   24.56,   0.07,  21.46,   0.08,  21.26,    0.08,  8.93e-07,  9.38e-07,  8.85e-07,  nan ],
	[   470,   21.68,   0.08,   23.91,   0.07,  21.87,   0.08,  20.43,    0.09,  1.09e-06,  1.04e-06,  1.02e-06,  nan ],
	[   480,   22.03,   0.08,   29.26,   0.06,  23.08,   0.08,  21.48,    0.09,  8.33e-07,  9.56e-07,  8.94e-07,  nan ],
	[   490,   22.89,   0.08,   26.32,   0.07,  22.39,   0.09,  21.21,    0.09,  1.00e-06,  1.00e-06,  1.06e-06,  nan ],
	[   500,   23.84,   0.08,   27.86,   0.07,  23.63,   0.08,  21.35,    0.09,  9.53e-07,  1.15e-06,  1.12e-06,  nan ],
	[   510,   24.25,   0.09,   26.13,   0.08,  23.98,   0.09,  21.30,    0.10,  8.90e-07,  9.11e-07,  8.57e-07,  nan ],
	[   520,   24.39,   0.09,   28.98,   0.07,  24.39,   0.09,  21.06,    0.10,  9.99e-07,  8.82e-07,  9.39e-07,  nan ],
	[   530,   25.34,   0.09,   30.49,   0.07,  25.27,   0.09,  21.05,    0.11,  9.50e-07,  8.56e-07,  9.94e-07,  nan ],
	[   540,   25.68,   0.09,   31.15,   0.08,  25.68,   0.09,  21.90,    0.11,  1.17e-06,  1.19e-06,  1.19e-06,  nan ],
	[   550,   25.26,   0.10,   27.29,   0.09,  26.10,   0.09,  21.47,    0.11,  1.22e-06,  1.01e-06,  1.12e-06,  nan ],
	[   560,   26.25,   0.10,   32.27,   0.08,  26.44,   0.10,  21.67,    0.12,  1.20e-06,  1.32e-06,  1.20e-06,  nan ],
	[   570,   28.03,   0.09,   33.84,   0.08,  27.46,   0.09,  21.90,    0.12,  1.21e-06,  1.10e-06,  1.18e-06,  nan ],
	[   580,   27.27,   0.10,   35.04,   0.08,  28.15,   0.10,  21.76,    0.12,  1.16e-06,  1.27e-06,  1.16e-06,  nan ],
	[   590,   27.68,   0.10,   30.98,   0.09,  27.88,   0.10,  21.85,    0.13,  1.34e-06,  1.45e-06,  1.55e-06,  nan ],
	[   600,   28.03,   0.10,   35.72,   0.08,  28.83,   0.10,  22.18,    0.13,  1.12e-06,  1.10e-06,  1.19e-06,  nan ],
	[   610,   29.31,   0.10,   35.06,   0.09,  28.97,   0.10,  21.65,    0.14,  1.18e-06,  1.13e-06,  1.14e-06,  nan ],
	[   620,   29.39,   0.10,   36.32,   0.08,  29.65,   0.10,  22.18,    0.14,  1.28e-06,  1.28e-06,  1.19e-06,  nan ],
	[   630,   30.62,   0.10,   34.23,   0.09,  30.34,   0.10,  21.92,    0.15,  1.07e-06,  1.07e-06,  1.16e-06,  nan ],
	[   640,   31.89,   0.10,   43.32,   0.08,  30.68,   0.11,  21.63,    0.15,  1.15e-06,  1.24e-06,  1.15e-06,  nan ],
	[   650,   30.82,   0.11,   38.51,   0.09,  31.03,   0.11,  22.13,    0.15,  1.13e-06,  1.05e-06,  1.04e-06,  nan ],
	[   660,   31.78,   0.11,   39.70,   0.09,  31.78,   0.11,  22.23,    0.16,  1.20e-06,  1.19e-06,  1.21e-06,  nan ],
	[   670,   31.58,   0.11,   36.03,   0.10,  32.12,   0.11,  22.23,    0.16,  1.28e-06,  1.28e-06,  1.28e-06,  nan ],
	[   680,   33.08,   0.11,   40.71,   0.09,  32.81,   0.11,  22.34,    0.17,  1.26e-06,  1.35e-06,  1.26e-06,  nan ],
	[   690,   34.43,   0.11,   42.47,   0.09,  33.22,   0.11,  22.17,    0.17,  1.19e-06,  1.35e-06,  1.16e-06,  nan ],
	[   700,   34.76,   0.11,   43.13,   0.09,  33.56,   0.12,  22.33,    0.18,  1.52e-06,  1.41e-06,  1.40e-06,  nan ],
	[   710,   33.97,   0.12,   36.14,   0.11,  34.24,   0.12,  22.33,    0.18,  1.21e-06,  1.39e-06,  1.22e-06,  nan ],
	[   720,   35.21,   0.12,   44.69,   0.09,  34.93,   0.12,  21.73,    0.19,  1.27e-06,  1.27e-06,  1.28e-06,  nan ],
	[   730,   36.20,   0.12,   45.83,   0.09,  33.94,   0.13,  22.01,    0.19,  1.43e-06,  1.42e-06,  1.34e-06,  nan ],
	[   740,   35.96,   0.12,   46.26,   0.09,  34.87,   0.13,  22.40,    0.20,  1.66e-06,  1.52e-06,  1.59e-06,  nan ],
	[   750,   36.94,   0.12,   40.67,   0.11,  35.22,   0.13,  22.54,    0.20,  1.32e-06,  1.26e-06,  1.30e-06,  nan ],
	[   760,   38.61,   0.12,   47.25,   0.10,  36.16,   0.13,  21.94,    0.21,  1.29e-06,  1.37e-06,  1.27e-06,  nan ],
	[   770,   37.12,   0.13,   47.92,   0.10,  36.57,   0.13,  22.30,    0.21,  1.43e-06,  1.43e-06,  1.51e-06,  nan ],
	[   780,   37.46,   0.13,   49.29,   0.10,  36.39,   0.13,  22.06,    0.22,  1.33e-06,  1.25e-06,  1.41e-06,  nan ],
	[   790,   39.36,   0.13,   44.26,   0.11,  37.60,   0.13,  22.13,    0.23,  1.28e-06,  1.47e-06,  1.32e-06,  nan ],
	[   800,   40.44,   0.13,   58.31,   0.09,  38.28,   0.13,  22.60,    0.23,  1.53e-06,  1.37e-06,  1.60e-06,  nan ],
	[   810,   40.47,   0.13,   52.02,   0.10,  38.42,   0.14,  22.67,    0.23,  1.26e-06,  1.29e-06,  1.21e-06,  nan ],
	[   820,   41.47,   0.13,   52.32,   0.10,  39.04,   0.14,  22.45,    0.24,  1.36e-06,  1.42e-06,  1.42e-06,  nan ],
	[   830,   42.73,   0.13,   47.94,   0.12,  39.72,   0.14,  22.44,    0.25,  1.25e-06,  1.35e-06,  1.22e-06,  nan ],
	[   840,   41.04,   0.14,   54.40,   0.10,  40.06,   0.14,  22.81,    0.25,  1.37e-06,  1.29e-06,  1.32e-06,  nan ],
	[   850,   42.61,   0.14,   54.70,   0.11,  41.09,   0.14,  21.94,    0.26,  1.32e-06,  1.50e-06,  1.43e-06,  nan ],
	[   860,   43.61,   0.14,   56.89,   0.10,  41.43,   0.14,  22.02,    0.27,  1.19e-06,  1.16e-06,  1.21e-06,  nan ],
	[   870,   42.69,   0.14,   45.27,   0.13,  39.94,   0.15,  17.43,    0.35,  1.20e-06,  1.40e-06,  1.33e-06,  nan ],
	[   880,   43.67,   0.14,   56.96,   0.11,  40.04,   0.15,  21.62,    0.29,  1.39e-06,  1.39e-06,  1.36e-06,  nan ],
	[   890,   46.06,   0.14,   59.43,   0.11,  42.06,   0.15,  22.20,    0.29,  1.27e-06,  1.24e-06,  1.24e-06,  nan ],
	[   900,   45.07,   0.14,   60.63,   0.11,  43.56,   0.15,  22.61,    0.29,  1.24e-06,  1.24e-06,  1.37e-06,  nan ],
	[  1000,   50.99,   0.16,   66.81,   0.12,  48.28,   0.17,  22.77,    0.35,  1.53e-06,  1.32e-06,  1.44e-06,  nan ],
	[  1100,   54.72,   0.18,   74.06,   0.13,  31.06,   0.31,  22.39,    0.43,  1.35e-06,  1.34e-06,  1.46e-06,  nan ],
	[  1200,   62.02,   0.19,   81.72,   0.14,  33.93,   0.34,  22.14,    0.52,  2.06e-06,  1.82e-06,  2.04e-06,  nan ],
	[  1300,   64.44,   0.21,   89.69,   0.15,  35.07,   0.39,  23.54,    0.58,  1.88e-06,  1.78e-06,  1.88e-06,  nan ],
	[  1400,   72.99,   0.22,  100.67,   0.16,  38.66,   0.41,  23.71,    0.66,  1.92e-06,  1.86e-06,  1.86e-06,  nan ],
	[  1500,   77.04,   0.23,  106.59,   0.17,  41.05,   0.44,  23.25,    0.78,  2.00e-06,  1.68e-06,  1.72e-06,  nan ],
	[  1600,   82.99,   0.25,  125.70,   0.16,  42.35,   0.48,  22.73,    0.90,  2.14e-06,  1.91e-06,  1.86e-06,  nan ],
	[  1700,   87.60,   0.26,  121.17,   0.19,  44.58,   0.52,  21.41,    1.08,  2.16e-06,  1.93e-06,  2.13e-06,  nan ],
	[  1800,   90.37,   0.29,  128.31,   0.20,  46.98,   0.55,  19.86,    1.31,  1.97e-06,  1.90e-06,  2.03e-06,  nan ],
	[  1900,   98.00,   0.29,  131.34,   0.22,  49.66,   0.58,  19.24,    1.50,  2.03e-06,  2.07e-06,  2.06e-06,  nan ],
	[  2000,  100.99,   0.32,  134.45,   0.24,  52.24,   0.61,  17.68,    1.81,  2.38e-06,  2.45e-06,  2.27e-06,  nan ],
	[  2100,  106.30,   0.33,  135.73,   0.26,  39.32,   0.90,  17.01,    2.08,  2.10e-06,  2.10e-06,  2.16e-06,  nan ],
	[  2200,  111.31,   0.35,  141.93,   0.27,  40.54,   0.96,  17.00,    2.28,  2.00e-06,  2.33e-06,  1.90e-06,  nan ],
	[  2300,  116.32,   0.36,  141.19,   0.30,  41.76,   1.01,  16.57,    2.56,  2.33e-06,  2.28e-06,  2.56e-06,  nan ],
	[  2400,  120.72,   0.38,  179.40,   0.26,  43.99,   1.05,  16.39,    2.81,  2.71e-06,  2.67e-06,  2.75e-06,  nan ],
	[  2500,  123.58,   0.40,  153.50,   0.33,  46.03,   1.09,  16.65,    3.01,  3.04e-06,  3.15e-06,  2.94e-06,  nan ],
	[  2600,  129.10,   0.42,  155.45,   0.35,  46.88,   1.15,  16.59,    3.26,  2.45e-06,  2.44e-06,  2.45e-06,  nan ],
	[  2700,  133.52,   0.44,  159.86,   0.37,  49.45,   1.18,  16.59,    3.52,  2.81e-06,  2.80e-06,  2.90e-06,  nan ],
	[  2800,  132.40,   0.47,  159.71,   0.39,  49.81,   1.26,  16.68,    3.76,  3.14e-06,  2.89e-06,  3.23e-06,  nan ],
	[  2900,  145.39,   0.46,  164.53,   0.41,  52.63,   1.28,  16.90,    3.98,  3.03e-06,  2.95e-06,  2.95e-06,  nan ],
	[  3000,  149.21,   0.48,  171.96,   0.42,  54.61,   1.32,  16.77,    4.30,  2.65e-06,  2.92e-06,  2.77e-06,  nan ],
	[  3100,  152.03,   0.51,  175.62,   0.44,  43.23,   1.78,  17.39,    4.42,  3.07e-06,  3.39e-06,  3.23e-06,  nan ],
	[  3200,  156.68,   0.52,  202.81,   0.40,  44.30,   1.85,  17.07,    4.80,  3.16e-06,  3.15e-06,  2.85e-06,  nan ],
	[  3300,  162.62,   0.54,  184.73,   0.47,  46.24,   1.88,  17.00,    5.13,  3.85e-06,  3.85e-06,  4.00e-06,  nan ],
	[  3400,  164.64,   0.56,  184.70,   0.50,  47.52,   1.95,  16.97,    5.45,  2.96e-06,  2.87e-06,  2.95e-06,  nan ],
	[  3500,  170.84,   0.57,  186.75,   0.52,  48.68,   2.01,  17.10,    5.73,  2.93e-06,  2.66e-06,  2.86e-06,  nan ],
	[  3600,  169.74,   0.61,  190.31,   0.55,  49.91,   2.08,  16.32,    6.36,  3.42e-06,  3.34e-06,  3.80e-06,  nan ],
	[  3700,  177.29,   0.62,  193.98,   0.56,  51.39,   2.13,  17.12,    6.40,  2.87e-06,  2.78e-06,  3.11e-06,  nan ],
	[  3800,  179.19,   0.64,  197.52,   0.59,  52.65,   2.19,  17.13,    6.75,  2.70e-06,  2.64e-06,  2.83e-06,  nan ],
	[  3900,  186.13,   0.65,  196.60,   0.62,  53.84,   2.26,  17.18,    7.08,  3.01e-06,  3.01e-06,  3.20e-06,  nan ],
	[  4000,  185.84,   0.69,  217.79,   0.59,  54.91,   2.33,  17.54,    7.30,  3.19e-06,  3.50e-06,  3.35e-06,  nan ],
	[  4100,  185.79,   0.72,  190.82,   0.71,  47.69,   2.82,  17.54,    7.67,  3.16e-06,  3.20e-06,  3.25e-06,  nan ],
	[  4200,  190.51,   0.74,  196.91,   0.72,  46.90,   3.01,  17.25,    8.19,  2.94e-06,  3.14e-06,  3.05e-06,  nan ],
	[  4300,  193.16,   0.77,  202.69,   0.73,  48.01,   3.08,  17.38,    8.51,  4.10e-06,  3.99e-06,  3.66e-06,  nan ],
	[  4400,  200.44,   0.77,  197.34,   0.79,  48.81,   3.17,  17.31,    8.95,  3.93e-06,  4.10e-06,  4.22e-06,  nan ],
	[  4500,  203.32,   0.80,  203.87,   0.79,  50.34,   3.22,  17.41,    9.31,  3.64e-06,  3.49e-06,  3.36e-06,  nan ],
	[  4600,  211.19,   0.80,  204.27,   0.83,  51.20,   3.31,  15.79,   10.73,  3.72e-06,  4.14e-06,  3.93e-06,  nan ],
	[  4700,  208.98,   0.85,  207.46,   0.85,  52.02,   3.40,  17.36,   10.18,  3.53e-06,  3.32e-06,  3.45e-06,  nan ],
	[  4800,  213.39,   0.86,  231.68,   0.80,  53.27,   3.46,  17.28,   10.67,  3.75e-06,  3.49e-06,  4.00e-06,  nan ],
	[  4900,  217.34,   0.88,  211.35,   0.91,  54.31,   3.54,  17.43,   11.02,  4.77e-06,  4.12e-06,  4.09e-06,  nan ],
	[  5000,  217.89,   0.92,  212.16,   0.94,  55.40,   3.61,  17.54,   11.41,  3.91e-06,  4.21e-06,  4.11e-06,  nan ],
	[  5100,  224.54,   0.93,  214.13,   0.97,  55.88,   3.73,  17.49,   11.90,  3.84e-06,  4.02e-06,  4.12e-06,  nan ],
	[  5200,  225.88,   0.96,  216.40,   1.00,  48.07,   4.50,  17.31,   12.50,  3.98e-06,  3.85e-06,  3.95e-06,  nan ],
	[  5300,  225.23,   1.00,  215.94,   1.04,  49.22,   4.57,  17.42,   12.90,  4.05e-06,  4.15e-06,  3.98e-06,  nan ],
	[  5400,  229.69,   1.02,  220.13,   1.06,  50.30,   4.64,  17.49,   13.34,  4.03e-06,  4.35e-06,  4.22e-06,  nan ],
	[  5500,  226.23,   1.07,  218.30,   1.11,  50.83,   4.76,  17.49,   13.84,  4.02e-06,  3.92e-06,  3.92e-06,  nan ],
	[  5600,  235.21,   1.07,  245.52,   1.02,  51.96,   4.83,  17.57,   14.28,  4.29e-06,  4.24e-06,  4.10e-06,  nan ],
	[  5700,  236.80,   1.10,  227.04,   1.15,  52.89,   4.92,  17.69,   14.70,  4.77e-06,  5.23e-06,  4.91e-06,  nan ],
	[  5800,  241.20,   1.12,  220.65,   1.22,  53.98,   4.99,  17.51,   15.37,  4.00e-06,  3.68e-06,  3.88e-06,  nan ],
	[  5900,  244.98,   1.14,  223.90,   1.24,  54.50,   5.11,  17.87,   15.59,  3.98e-06,  4.41e-06,  4.33e-06,  nan ],
	[  6000,  248.77,   1.16,  226.31,   1.27,  55.54,   5.19,  17.71,   16.27,  4.32e-06,  4.43e-06,  4.41e-06,  nan ],
	[  6100,  245.26,   1.21,  225.22,   1.32,  55.91,   5.33,  17.79,   16.74,  4.43e-06,  4.31e-06,  4.45e-06,  nan ],
	[  6200,  251.93,   1.22,  228.87,   1.34,  49.58,   6.20,  17.61,   17.46,  4.39e-06,  4.14e-06,  4.38e-06,  nan ],
	[  6300,  255.29,   1.24,  223.06,   1.42,  49.94,   6.36,  17.99,   17.66,  4.73e-06,  4.70e-06,  4.44e-06,  nan ],
	[  6400,  254.91,   1.29,  251.92,   1.30,  50.96,   6.43,  19.16,   17.10,  4.45e-06,  4.46e-06,  4.65e-06,  nan ],
	[  6500,  256.51,   1.32,  223.59,   1.51,  51.72,   6.54,  17.76,   19.03,  4.66e-06,  4.47e-06,  4.30e-06,  nan ],
	[  6600,  262.24,   1.33,  229.47,   1.52,  52.71,   6.61,  17.72,   19.67,  4.92e-06,  4.68e-06,  4.92e-06,  nan ],
	[  6700,  268.03,   1.34,  226.32,   1.59,  53.08,   6.77,  17.92,   20.05,  4.93e-06,  4.88e-06,  4.53e-06,  nan ],
	[  6800,  264.83,   1.40,  222.46,   1.66,  53.98,   6.86,  17.62,   21.00,  4.60e-06,  4.45e-06,  4.74e-06,  nan ],
	[  6900,  273.66,   1.39,  228.40,   1.67,  54.07,   7.05,  17.91,   21.28,  4.67e-06,  4.89e-06,  4.82e-06,  nan ],
	[  7000,  270.04,   1.45,  231.85,   1.69,  55.39,   7.08,  17.64,   22.23,  4.26e-06,  4.55e-06,  4.46e-06,  nan ],
	[  7100,  274.60,   1.47,  228.16,   1.77,  56.22,   7.17,  17.91,   22.53,  4.55e-06,  4.41e-06,  4.72e-06,  nan ],
	[  7200,  278.24,   1.49,  262.18,   1.58,  49.93,   8.31,  17.81,   23.29,  4.22e-06,  4.27e-06,  4.23e-06,  nan ],
	[  7300,  276.34,   1.54,  233.27,   1.83,  50.93,   8.37,  17.48,   24.39,  5.24e-06,  5.12e-06,  5.05e-06,  nan ],
	[  7400,  278.54,   1.57,  233.55,   1.88,  51.69,   8.48,  17.52,   25.02,  4.60e-06,  4.37e-06,  4.52e-06,  nan ],
	[  7500,  277.82,   1.62,  236.78,   1.90,  52.17,   8.63,  17.72,   25.39,  5.21e-06,  4.73e-06,  4.96e-06,  nan ],
	[  7600,  287.78,   1.61,  236.63,   1.95,  52.87,   8.74,  17.58,   26.28,  4.72e-06,  4.69e-06,  5.04e-06,  nan ],
	[  7700,  286.97,   1.65,  233.36,   2.03,  53.61,   8.85,  16.69,   28.43,  4.32e-06,  4.09e-06,  4.32e-06,  nan ],
	[  7800,  289.09,   1.68,  235.05,   2.07,  54.32,   8.96,  16.92,   28.77,  4.46e-06,  4.44e-06,  4.60e-06,  nan ],
	[  7900,  284.54,   1.75,  237.69,   2.10,  54.72,   9.13,  17.60,   28.38,  4.46e-06,  4.52e-06,  4.59e-06,  nan ],
	[  8000,  285.28,   1.80,  263.84,   1.94,  55.41,   9.24,  17.69,   28.95,  5.27e-06,  4.86e-06,  4.44e-06,  nan ],
	[  8100,  287.83,   1.82,  240.83,   2.18,  56.06,   9.37,  17.41,   30.16,  4.34e-06,  4.73e-06,  4.32e-06,  nan ],
	[  8200,  281.69,   1.91,  236.72,   2.27,  51.54,  10.44,  16.13,   33.37,  4.80e-06,  4.50e-06,  4.70e-06,  nan ],
	[  8300,  283.71,   1.94,  235.15,   2.34,  50.99,  10.81,  16.31,   33.80,  5.24e-06,  4.67e-06,  4.83e-06,  nan ],
	[  8400,  275.83,   2.05,  238.62,   2.37,  51.84,  10.89,  17.53,   32.21,  5.19e-06,  4.73e-06,  5.06e-06,  nan ],
	[  8500,  284.49,   2.03,  241.77,   2.39,  52.51,  11.01,  17.66,   32.73,  5.19e-06,  5.32e-06,  5.76e-06,  nan ],
	[  8600,  277.18,   2.14,  240.07,   2.47,  53.13,  11.14,  17.56,   33.71,  5.26e-06,  5.40e-06,  5.18e-06,  nan ],
	[  8700,  282.21,   2.15,  238.54,   2.54,  53.54,  11.31,  17.64,   34.34,  5.61e-06,  5.89e-06,  5.39e-06,  nan ],
	[  8800,  271.06,   2.29,  271.17,   2.29,  54.14,  11.45,  17.79,   34.83,  5.56e-06,  6.12e-06,  5.77e-06,  nan ],
	[  8900,  273.99,   2.31,  243.10,   2.61,  54.83,  11.56,  17.77,   35.67,  5.21e-06,  5.30e-06,  5.21e-06,  nan ],
	[  9000,  275.19,   2.36,  239.25,   2.71,  55.31,  11.72,  17.52,   36.99,  5.86e-06,  5.36e-06,  5.32e-06,  nan ],
	[ 10000,  273.06,   2.93,  246.20,   3.25,  54.78,  14.61,  17.44,   45.89,  6.36e-06,  6.46e-06,  6.26e-06,  nan ],
	[ 12000,  272.96,   4.22,  281.82,   4.09,  55.21,  20.87,  17.47,   65.96,  6.27e-06,  6.43e-06,  6.34e-06,  nan ],
	[ 14000,  292.80,   5.36,  251.79,   6.23,  55.43,  28.29,  16.95,   92.53,  6.79e-06,  6.49e-06,  6.86e-06,  nan ],
	[ 16000,  295.56,   6.93,  286.86,   7.14,  55.23,  37.08,  15.47,  132.36,  8.87e-06,  8.64e-06,  9.27e-06,  nan ],
	[ 18000,  286.28,   9.05,  260.26,   9.96,  54.47,  47.59,  16.31,  158.92,  7.91e-06,  8.04e-06,  8.33e-06,  nan ],
	[ 20000,  290.03,  11.03,  292.17,  10.95,  53.57,  59.74,  17.22,  185.87,  9.58e-06,  1.02e-05,  9.49e-06,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/cpotrf.txt
# numactl --interleave=all ../testing/testing_cpotrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cpotrf = array([
	[    10,  nan,  nan,     0.33,  0.00,  nan ],
	[    20,  nan,  nan,     1.19,  0.00,  nan ],
	[    30,  nan,  nan,     2.58,  0.00,  nan ],
	[    40,  nan,  nan,     4.56,  0.00,  nan ],
	[    50,  nan,  nan,     3.01,  0.00,  nan ],
	[    60,  nan,  nan,     5.43,  0.00,  nan ],
	[    70,  nan,  nan,     6.45,  0.00,  nan ],
	[    80,  nan,  nan,     6.88,  0.00,  nan ],
	[    90,  nan,  nan,     8.10,  0.00,  nan ],
	[   100,  nan,  nan,     8.69,  0.00,  nan ],
	[   200,  nan,  nan,    41.02,  0.00,  nan ],
	[   300,  nan,  nan,    17.59,  0.00,  nan ],
	[   400,  nan,  nan,    33.80,  0.00,  nan ],
	[   500,  nan,  nan,    58.03,  0.00,  nan ],
	[   600,  nan,  nan,    70.90,  0.00,  nan ],
	[   700,  nan,  nan,    99.63,  0.00,  nan ],
	[   800,  nan,  nan,   111.37,  0.01,  nan ],
	[   900,  nan,  nan,   145.55,  0.01,  nan ],
	[  1000,  nan,  nan,   187.16,  0.01,  nan ],
	[  2000,  nan,  nan,   573.72,  0.02,  nan ],
	[  3000,  nan,  nan,  1011.85,  0.04,  nan ],
	[  4000,  nan,  nan,  1318.35,  0.06,  nan ],
	[  5000,  nan,  nan,  1545.89,  0.11,  nan ],
	[  6000,  nan,  nan,  1759.68,  0.16,  nan ],
	[  7000,  nan,  nan,  1899.25,  0.24,  nan ],
	[  8000,  nan,  nan,  2032.99,  0.34,  nan ],
	[  9000,  nan,  nan,  2145.05,  0.45,  nan ],
	[ 10000,  nan,  nan,  2229.54,  0.60,  nan ],
	[ 12000,  nan,  nan,  2387.09,  0.97,  nan ],
	[ 14000,  nan,  nan,  2504.14,  1.46,  nan ],
	[ 16000,  nan,  nan,  2598.13,  2.10,  nan ],
	[ 18000,  nan,  nan,  2649.71,  2.94,  nan ],
	[ 20000,  nan,  nan,  2710.26,  3.94,  nan ],
])

# numactl --interleave=all ../testing/testing_cpotrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.03,  0.00,  nan ],
	[    40,  nan,  nan,     0.08,  0.00,  nan ],
	[    50,  nan,  nan,     0.14,  0.00,  nan ],
	[    60,  nan,  nan,     0.24,  0.00,  nan ],
	[    70,  nan,  nan,     0.37,  0.00,  nan ],
	[    80,  nan,  nan,     0.51,  0.00,  nan ],
	[    90,  nan,  nan,     0.75,  0.00,  nan ],
	[   100,  nan,  nan,     0.99,  0.00,  nan ],
	[   200,  nan,  nan,    17.26,  0.00,  nan ],
	[   300,  nan,  nan,    12.99,  0.00,  nan ],
	[   400,  nan,  nan,    26.48,  0.00,  nan ],
	[   500,  nan,  nan,    45.74,  0.00,  nan ],
	[   600,  nan,  nan,    61.09,  0.00,  nan ],
	[   700,  nan,  nan,    89.28,  0.01,  nan ],
	[   800,  nan,  nan,   105.37,  0.01,  nan ],
	[   900,  nan,  nan,   137.82,  0.01,  nan ],
	[  1000,  nan,  nan,   174.87,  0.01,  nan ],
	[  2000,  nan,  nan,   631.87,  0.02,  nan ],
	[  3000,  nan,  nan,  1150.55,  0.03,  nan ],
	[  4000,  nan,  nan,  1507.42,  0.06,  nan ],
	[  5000,  nan,  nan,  1770.97,  0.09,  nan ],
	[  6000,  nan,  nan,  1989.97,  0.14,  nan ],
	[  7000,  nan,  nan,  2145.11,  0.21,  nan ],
	[  8000,  nan,  nan,  2273.88,  0.30,  nan ],
	[  9000,  nan,  nan,  2363.62,  0.41,  nan ],
	[ 10000,  nan,  nan,  2431.79,  0.55,  nan ],
	[ 12000,  nan,  nan,  2566.33,  0.90,  nan ],
	[ 14000,  nan,  nan,  2682.30,  1.36,  nan ],
	[ 16000,  nan,  nan,  2764.15,  1.98,  nan ],
	[ 18000,  nan,  nan,  2796.48,  2.78,  nan ],
	[ 20000,  nan,  nan,  2846.62,  3.75,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/dgeqrf.txt
# numactl --interleave=all ../testing/testing_dgeqrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeqrf = array([
	[    10,     10,  nan,  nan,     0.01,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.05,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.16,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.36,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.64,   0.00,  nan ],
	[    60,     60,  nan,  nan,     0.99,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.53,   0.00,  nan ],
	[    80,     80,  nan,  nan,     0.78,   0.00,  nan ],
	[    90,     90,  nan,  nan,     1.04,   0.00,  nan ],
	[   100,    100,  nan,  nan,     1.33,   0.00,  nan ],
	[   200,    200,  nan,  nan,     4.94,   0.00,  nan ],
	[   300,    300,  nan,  nan,    11.41,   0.00,  nan ],
	[   400,    400,  nan,  nan,    18.41,   0.00,  nan ],
	[   500,    500,  nan,  nan,    27.28,   0.01,  nan ],
	[   600,    600,  nan,  nan,    36.17,   0.01,  nan ],
	[   700,    700,  nan,  nan,    46.54,   0.01,  nan ],
	[   800,    800,  nan,  nan,    56.05,   0.01,  nan ],
	[   900,    900,  nan,  nan,    65.84,   0.01,  nan ],
	[  1000,   1000,  nan,  nan,    78.03,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   200.11,   0.05,  nan ],
	[  3000,   3000,  nan,  nan,   318.52,   0.11,  nan ],
	[  4000,   4000,  nan,  nan,   416.39,   0.21,  nan ],
	[  5000,   5000,  nan,  nan,   532.87,   0.31,  nan ],
	[  6000,   6000,  nan,  nan,   637.28,   0.45,  nan ],
	[  7000,   7000,  nan,  nan,   707.45,   0.65,  nan ],
	[  8000,   8000,  nan,  nan,   761.67,   0.90,  nan ],
	[  9000,   9000,  nan,  nan,   805.55,   1.21,  nan ],
	[ 10000,  10000,  nan,  nan,   840.49,   1.59,  nan ],
	[ 12000,  12000,  nan,  nan,   918.36,   2.51,  nan ],
	[ 14000,  14000,  nan,  nan,   958.36,   3.82,  nan ],
	[ 16000,  16000,  nan,  nan,   986.38,   5.54,  nan ],
	[ 18000,  18000,  nan,  nan,  1006.20,   7.73,  nan ],
	[ 20000,  20000,  nan,  nan,  1026.70,  10.39,  nan ],
])

# numactl --interleave=all ../testing/testing_dgeqrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.00,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.01,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.03,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.07,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.13,   0.00,  nan ],
	[    60,     60,  nan,  nan,     0.23,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.28,   0.00,  nan ],
	[    80,     80,  nan,  nan,     0.41,   0.00,  nan ],
	[    90,     90,  nan,  nan,     0.57,   0.00,  nan ],
	[   100,    100,  nan,  nan,     1.55,   0.00,  nan ],
	[   200,    200,  nan,  nan,     3.55,   0.00,  nan ],
	[   300,    300,  nan,  nan,     8.66,   0.00,  nan ],
	[   400,    400,  nan,  nan,    15.07,   0.01,  nan ],
	[   500,    500,  nan,  nan,    23.08,   0.01,  nan ],
	[   600,    600,  nan,  nan,    31.25,   0.01,  nan ],
	[   700,    700,  nan,  nan,    40.84,   0.01,  nan ],
	[   800,    800,  nan,  nan,    51.02,   0.01,  nan ],
	[   900,    900,  nan,  nan,    59.29,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,    71.68,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   191.68,   0.06,  nan ],
	[  3000,   3000,  nan,  nan,   315.89,   0.11,  nan ],
	[  4000,   4000,  nan,  nan,   401.12,   0.21,  nan ],
	[  5000,   5000,  nan,  nan,   522.65,   0.32,  nan ],
	[  6000,   6000,  nan,  nan,   629.81,   0.46,  nan ],
	[  7000,   7000,  nan,  nan,   700.79,   0.65,  nan ],
	[  8000,   8000,  nan,  nan,   763.90,   0.89,  nan ],
	[  9000,   9000,  nan,  nan,   808.15,   1.20,  nan ],
	[ 10000,  10000,  nan,  nan,   844.01,   1.58,  nan ],
	[ 12000,  12000,  nan,  nan,   902.83,   2.55,  nan ],
	[ 14000,  14000,  nan,  nan,   952.47,   3.84,  nan ],
	[ 16000,  16000,  nan,  nan,   984.75,   5.55,  nan ],
	[ 18000,  18000,  nan,  nan,  1006.21,   7.73,  nan ],
	[ 20000,  20000,  nan,  nan,  1031.65,  10.34,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/dgesvd.txt
# numactl --interleave=all ../testing/testing_dgesvd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
dgesvd_UN = array([
	[ nan,      10,      10,  nan,   0.00,  nan ],
	[ nan,      20,      20,  nan,   0.00,  nan ],
	[ nan,      30,      30,  nan,   0.00,  nan ],
	[ nan,      40,      40,  nan,   0.00,  nan ],
	[ nan,      50,      50,  nan,   0.00,  nan ],
	[ nan,      60,      60,  nan,   0.00,  nan ],
	[ nan,      70,      70,  nan,   0.00,  nan ],
	[ nan,      80,      80,  nan,   0.00,  nan ],
	[ nan,      90,      90,  nan,   0.00,  nan ],
	[ nan,     100,     100,  nan,   0.00,  nan ],
	[ nan,     200,     200,  nan,   0.01,  nan ],
	[ nan,     300,     300,  nan,   0.03,  nan ],
	[ nan,     400,     400,  nan,   0.05,  nan ],
	[ nan,     500,     500,  nan,   0.07,  nan ],
	[ nan,     600,     600,  nan,   0.09,  nan ],
	[ nan,     700,     700,  nan,   0.13,  nan ],
	[ nan,     800,     800,  nan,   0.15,  nan ],
	[ nan,     900,     900,  nan,   0.19,  nan ],
	[ nan,    1000,    1000,  nan,   0.23,  nan ],
	[ nan,    2000,    2000,  nan,   0.89,  nan ],
	[ nan,    3000,    3000,  nan,   2.29,  nan ],
	[ nan,    4000,    4000,  nan,   4.62,  nan ],
	[ nan,    5000,    5000,  nan,   8.25,  nan ],
	[ nan,    6000,    6000,  nan,  13.23,  nan ],
	[ nan,    7000,    7000,  nan,  19.88,  nan ],
	[ nan,    8000,    8000,  nan,  28.43,  nan ],
	[ nan,    9000,    9000,  nan,  39.52,  nan ],
	[ nan,   10000,   10000,  nan,  52.77,  nan ],
	[ nan,     300,     100,  nan,   0.00,  nan ],
	[ nan,     600,     200,  nan,   0.02,  nan ],
	[ nan,     900,     300,  nan,   0.03,  nan ],
	[ nan,    1200,     400,  nan,   0.06,  nan ],
	[ nan,    1500,     500,  nan,   0.08,  nan ],
	[ nan,    1800,     600,  nan,   0.11,  nan ],
	[ nan,    2100,     700,  nan,   0.15,  nan ],
	[ nan,    2400,     800,  nan,   0.18,  nan ],
	[ nan,    2700,     900,  nan,   0.24,  nan ],
	[ nan,    3000,    1000,  nan,   0.29,  nan ],
	[ nan,    6000,    2000,  nan,   1.24,  nan ],
	[ nan,    9000,    3000,  nan,   3.30,  nan ],
	[ nan,   12000,    4000,  nan,   6.74,  nan ],
	[ nan,   15000,    5000,  nan,  12.11,  nan ],
	[ nan,   18000,    6000,  nan,  19.56,  nan ],
	[ nan,   21000,    7000,  nan,  29.55,  nan ],
	[ nan,   24000,    8000,  nan,  43.21,  nan ],
	[ nan,   27000,    9000,  nan,  59.53,  nan ],
	[ nan,     100,     300,  nan,   0.00,  nan ],
	[ nan,     200,     600,  nan,   0.02,  nan ],
	[ nan,     300,     900,  nan,   0.04,  nan ],
	[ nan,     400,    1200,  nan,   0.06,  nan ],
	[ nan,     500,    1500,  nan,   0.09,  nan ],
	[ nan,     600,    1800,  nan,   0.12,  nan ],
	[ nan,     700,    2100,  nan,   0.17,  nan ],
	[ nan,     800,    2400,  nan,   0.20,  nan ],
	[ nan,     900,    2700,  nan,   0.26,  nan ],
	[ nan,    1000,    3000,  nan,   0.31,  nan ],
	[ nan,    2000,    6000,  nan,   1.31,  nan ],
	[ nan,    3000,    9000,  nan,   3.46,  nan ],
	[ nan,    4000,   12000,  nan,   7.03,  nan ],
	[ nan,    5000,   15000,  nan,  12.58,  nan ],
	[ nan,    6000,   18000,  nan,  20.59,  nan ],
	[ nan,    7000,   21000,  nan,  31.25,  nan ],
	[ nan,    8000,   24000,  nan,  44.75,  nan ],
	[ nan,    9000,   27000,  nan,  62.03,  nan ],
	[ nan,   10000,     100,  nan,   0.01,  nan ],
	[ nan,   20000,     200,  nan,   0.06,  nan ],
	[ nan,   30000,     300,  nan,   0.15,  nan ],
	[ nan,   40000,     400,  nan,   0.38,  nan ],
	[ nan,   50000,     500,  nan,   0.62,  nan ],
	[ nan,   60000,     600,  nan,   0.93,  nan ],
	[ nan,   70000,     700,  nan,   1.30,  nan ],
	[ nan,   80000,     800,  nan,   1.74,  nan ],
	[ nan,   90000,     900,  nan,   2.46,  nan ],
	[ nan,  100000,    1000,  nan,   3.10,  nan ],
	[ nan,  200000,    2000,  nan,  18.29,  nan ],
	[ nan,     100,   10000,  nan,   0.01,  nan ],
	[ nan,     200,   20000,  nan,   0.05,  nan ],
	[ nan,     300,   30000,  nan,   0.16,  nan ],
	[ nan,     400,   40000,  nan,   0.32,  nan ],
	[ nan,     500,   50000,  nan,   0.58,  nan ],
	[ nan,     600,   60000,  nan,   0.89,  nan ],
	[ nan,     700,   70000,  nan,   1.40,  nan ],
	[ nan,     800,   80000,  nan,   1.84,  nan ],
	[ nan,     900,   90000,  nan,   2.20,  nan ],
	[ nan,    1000,  100000,  nan,   2.85,  nan ],
	[ nan,    2000,  200000,  nan,  19.86,  nan ],
])

# numactl --interleave=all ../testing/testing_dgesvd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
dgesvd_US = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.01,  nan ],
	[ nan,      60,      60,  nan,    0.01,  nan ],
	[ nan,      70,      70,  nan,    0.01,  nan ],
	[ nan,      80,      80,  nan,    0.01,  nan ],
	[ nan,      90,      90,  nan,    0.02,  nan ],
	[ nan,     100,     100,  nan,    0.02,  nan ],
	[ nan,     200,     200,  nan,    0.08,  nan ],
	[ nan,     300,     300,  nan,    0.06,  nan ],
	[ nan,     400,     400,  nan,    0.10,  nan ],
	[ nan,     500,     500,  nan,    0.15,  nan ],
	[ nan,     600,     600,  nan,    0.23,  nan ],
	[ nan,     700,     700,  nan,    0.31,  nan ],
	[ nan,     800,     800,  nan,    0.40,  nan ],
	[ nan,     900,     900,  nan,    0.51,  nan ],
	[ nan,    1000,    1000,  nan,    0.64,  nan ],
	[ nan,    2000,    2000,  nan,    3.17,  nan ],
	[ nan,    3000,    3000,  nan,    8.43,  nan ],
	[ nan,    4000,    4000,  nan,   17.26,  nan ],
	[ nan,    5000,    5000,  nan,   30.03,  nan ],
	[ nan,    6000,    6000,  nan,   48.01,  nan ],
	[ nan,    7000,    7000,  nan,   71.13,  nan ],
	[ nan,    8000,    8000,  nan,  100.03,  nan ],
	[ nan,    9000,    9000,  nan,  138.28,  nan ],
	[ nan,   10000,   10000,  nan,  184.97,  nan ],
	[ nan,     300,     100,  nan,    0.02,  nan ],
	[ nan,     600,     200,  nan,    0.10,  nan ],
	[ nan,     900,     300,  nan,    0.08,  nan ],
	[ nan,    1200,     400,  nan,    0.14,  nan ],
	[ nan,    1500,     500,  nan,    0.23,  nan ],
	[ nan,    1800,     600,  nan,    0.35,  nan ],
	[ nan,    2100,     700,  nan,    0.47,  nan ],
	[ nan,    2400,     800,  nan,    0.63,  nan ],
	[ nan,    2700,     900,  nan,    0.81,  nan ],
	[ nan,    3000,    1000,  nan,    1.07,  nan ],
	[ nan,    6000,    2000,  nan,    5.81,  nan ],
	[ nan,    9000,    3000,  nan,   16.38,  nan ],
	[ nan,   12000,    4000,  nan,   33.27,  nan ],
	[ nan,   15000,    5000,  nan,   48.81,  nan ],
	[ nan,   18000,    6000,  nan,   75.32,  nan ],
	[ nan,   21000,    7000,  nan,  112.07,  nan ],
	[ nan,   24000,    8000,  nan,  156.84,  nan ],
	[ nan,   27000,    9000,  nan,  222.43,  nan ],
	[ nan,     100,     300,  nan,    0.02,  nan ],
	[ nan,     200,     600,  nan,    0.08,  nan ],
	[ nan,     300,     900,  nan,    0.09,  nan ],
	[ nan,     400,    1200,  nan,    0.16,  nan ],
	[ nan,     500,    1500,  nan,    0.26,  nan ],
	[ nan,     600,    1800,  nan,    0.40,  nan ],
	[ nan,     700,    2100,  nan,    0.55,  nan ],
	[ nan,     800,    2400,  nan,    0.70,  nan ],
	[ nan,     900,    2700,  nan,    0.90,  nan ],
	[ nan,    1000,    3000,  nan,    1.13,  nan ],
	[ nan,    2000,    6000,  nan,    6.18,  nan ],
	[ nan,    3000,    9000,  nan,   15.90,  nan ],
	[ nan,    4000,   12000,  nan,   31.34,  nan ],
	[ nan,    5000,   15000,  nan,   53.58,  nan ],
	[ nan,    6000,   18000,  nan,   88.90,  nan ],
	[ nan,    7000,   21000,  nan,  132.87,  nan ],
	[ nan,    8000,   24000,  nan,  187.01,  nan ],
	[ nan,    9000,   27000,  nan,  254.09,  nan ],
	[ nan,   10000,     100,  nan,    0.06,  nan ],
	[ nan,   20000,     200,  nan,    0.28,  nan ],
	[ nan,   30000,     300,  nan,    0.48,  nan ],
	[ nan,   40000,     400,  nan,    1.01,  nan ],
	[ nan,   50000,     500,  nan,    1.84,  nan ],
	[ nan,   60000,     600,  nan,    2.61,  nan ],
	[ nan,   70000,     700,  nan,    4.08,  nan ],
	[ nan,   80000,     800,  nan,    5.43,  nan ],
	[ nan,   90000,     900,  nan,    7.95,  nan ],
	[ nan,  100000,    1000,  nan,   10.22,  nan ],
	[ nan,  200000,    2000,  nan,   70.82,  nan ],
	[ nan,     100,   10000,  nan,    0.06,  nan ],
	[ nan,     200,   20000,  nan,    0.39,  nan ],
	[ nan,     300,   30000,  nan,    0.62,  nan ],
	[ nan,     400,   40000,  nan,    1.20,  nan ],
	[ nan,     500,   50000,  nan,    3.25,  nan ],
	[ nan,     600,   60000,  nan,    4.00,  nan ],
	[ nan,     700,   70000,  nan,    5.34,  nan ],
	[ nan,     800,   80000,  nan,    7.31,  nan ],
	[ nan,     900,   90000,  nan,    8.49,  nan ],
	[ nan,    1000,  100000,  nan,   14.48,  nan ],
	[ nan,    2000,  200000,  nan,   83.46,  nan ],
])

# numactl --interleave=all ../testing/testing_dgesdd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
dgesdd_UN = array([
	[ nan,      10,      10,  nan,   0.00,  nan ],
	[ nan,      20,      20,  nan,   0.00,  nan ],
	[ nan,      30,      30,  nan,   0.00,  nan ],
	[ nan,      40,      40,  nan,   0.00,  nan ],
	[ nan,      50,      50,  nan,   0.00,  nan ],
	[ nan,      60,      60,  nan,   0.00,  nan ],
	[ nan,      70,      70,  nan,   0.00,  nan ],
	[ nan,      80,      80,  nan,   0.00,  nan ],
	[ nan,      90,      90,  nan,   0.00,  nan ],
	[ nan,     100,     100,  nan,   0.00,  nan ],
	[ nan,     200,     200,  nan,   0.01,  nan ],
	[ nan,     300,     300,  nan,   0.03,  nan ],
	[ nan,     400,     400,  nan,   0.05,  nan ],
	[ nan,     500,     500,  nan,   0.07,  nan ],
	[ nan,     600,     600,  nan,   0.09,  nan ],
	[ nan,     700,     700,  nan,   0.12,  nan ],
	[ nan,     800,     800,  nan,   0.15,  nan ],
	[ nan,     900,     900,  nan,   0.19,  nan ],
	[ nan,    1000,    1000,  nan,   0.23,  nan ],
	[ nan,    2000,    2000,  nan,   0.89,  nan ],
	[ nan,    3000,    3000,  nan,   2.30,  nan ],
	[ nan,    4000,    4000,  nan,   4.65,  nan ],
	[ nan,    5000,    5000,  nan,   8.29,  nan ],
	[ nan,    6000,    6000,  nan,  13.32,  nan ],
	[ nan,    7000,    7000,  nan,  20.01,  nan ],
	[ nan,    8000,    8000,  nan,  28.62,  nan ],
	[ nan,    9000,    9000,  nan,  39.78,  nan ],
	[ nan,   10000,   10000,  nan,  53.14,  nan ],
	[ nan,     300,     100,  nan,   0.00,  nan ],
	[ nan,     600,     200,  nan,   0.02,  nan ],
	[ nan,     900,     300,  nan,   0.03,  nan ],
	[ nan,    1200,     400,  nan,   0.06,  nan ],
	[ nan,    1500,     500,  nan,   0.08,  nan ],
	[ nan,    1800,     600,  nan,   0.12,  nan ],
	[ nan,    2100,     700,  nan,   0.16,  nan ],
	[ nan,    2400,     800,  nan,   0.20,  nan ],
	[ nan,    2700,     900,  nan,   0.26,  nan ],
	[ nan,    3000,    1000,  nan,   0.29,  nan ],
	[ nan,    6000,    2000,  nan,   1.35,  nan ],
	[ nan,    9000,    3000,  nan,   3.65,  nan ],
	[ nan,   12000,    4000,  nan,   7.62,  nan ],
	[ nan,   15000,    5000,  nan,  13.86,  nan ],
	[ nan,   18000,    6000,  nan,  22.81,  nan ],
	[ nan,   21000,    7000,  nan,  34.07,  nan ],
	[ nan,   24000,    8000,  nan,  49.03,  nan ],
	[ nan,   27000,    9000,  nan,  59.73,  nan ],
	[ nan,     100,     300,  nan,   0.00,  nan ],
	[ nan,     200,     600,  nan,   0.02,  nan ],
	[ nan,     300,     900,  nan,   0.04,  nan ],
	[ nan,     400,    1200,  nan,   0.06,  nan ],
	[ nan,     500,    1500,  nan,   0.09,  nan ],
	[ nan,     600,    1800,  nan,   0.12,  nan ],
	[ nan,     700,    2100,  nan,   0.17,  nan ],
	[ nan,     800,    2400,  nan,   0.20,  nan ],
	[ nan,     900,    2700,  nan,   0.26,  nan ],
	[ nan,    1000,    3000,  nan,   0.31,  nan ],
	[ nan,    2000,    6000,  nan,   1.30,  nan ],
	[ nan,    3000,    9000,  nan,   3.45,  nan ],
	[ nan,    4000,   12000,  nan,   7.02,  nan ],
	[ nan,    5000,   15000,  nan,  12.59,  nan ],
	[ nan,    6000,   18000,  nan,  20.60,  nan ],
	[ nan,    7000,   21000,  nan,  31.25,  nan ],
	[ nan,    8000,   24000,  nan,  44.72,  nan ],
	[ nan,    9000,   27000,  nan,  61.98,  nan ],
	[ nan,   10000,     100,  nan,   0.01,  nan ],
	[ nan,   20000,     200,  nan,   0.06,  nan ],
	[ nan,   30000,     300,  nan,   0.15,  nan ],
	[ nan,   40000,     400,  nan,   0.38,  nan ],
	[ nan,   50000,     500,  nan,   0.61,  nan ],
	[ nan,   60000,     600,  nan,   0.93,  nan ],
	[ nan,   70000,     700,  nan,   1.33,  nan ],
	[ nan,   80000,     800,  nan,   1.78,  nan ],
	[ nan,   90000,     900,  nan,   2.42,  nan ],
	[ nan,  100000,    1000,  nan,   3.13,  nan ],
	[ nan,  200000,    2000,  nan,  18.41,  nan ],
	[ nan,     100,   10000,  nan,   0.01,  nan ],
	[ nan,     200,   20000,  nan,   0.05,  nan ],
	[ nan,     300,   30000,  nan,   0.16,  nan ],
	[ nan,     400,   40000,  nan,   0.32,  nan ],
	[ nan,     500,   50000,  nan,   0.58,  nan ],
	[ nan,     600,   60000,  nan,   0.90,  nan ],
	[ nan,     700,   70000,  nan,   1.41,  nan ],
	[ nan,     800,   80000,  nan,   1.86,  nan ],
	[ nan,     900,   90000,  nan,   2.20,  nan ],
	[ nan,    1000,  100000,  nan,   2.85,  nan ],
	[ nan,    2000,  200000,  nan,  19.71,  nan ],
])

# numactl --interleave=all ../testing/testing_dgesdd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
dgesdd_US = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.00,  nan ],
	[ nan,      80,      80,  nan,    0.00,  nan ],
	[ nan,      90,      90,  nan,    0.00,  nan ],
	[ nan,     100,     100,  nan,    0.01,  nan ],
	[ nan,     200,     200,  nan,    0.03,  nan ],
	[ nan,     300,     300,  nan,    0.05,  nan ],
	[ nan,     400,     400,  nan,    0.09,  nan ],
	[ nan,     500,     500,  nan,    0.13,  nan ],
	[ nan,     600,     600,  nan,    0.18,  nan ],
	[ nan,     700,     700,  nan,    0.24,  nan ],
	[ nan,     800,     800,  nan,    0.31,  nan ],
	[ nan,     900,     900,  nan,    0.38,  nan ],
	[ nan,    1000,    1000,  nan,    0.47,  nan ],
	[ nan,    2000,    2000,  nan,    1.88,  nan ],
	[ nan,    3000,    3000,  nan,    5.33,  nan ],
	[ nan,    4000,    4000,  nan,    9.18,  nan ],
	[ nan,    5000,    5000,  nan,   15.73,  nan ],
	[ nan,    6000,    6000,  nan,   23.32,  nan ],
	[ nan,    7000,    7000,  nan,   33.88,  nan ],
	[ nan,    8000,    8000,  nan,   47.62,  nan ],
	[ nan,    9000,    9000,  nan,   64.52,  nan ],
	[ nan,   10000,   10000,  nan,   84.79,  nan ],
	[ nan,     300,     100,  nan,    0.01,  nan ],
	[ nan,     600,     200,  nan,    0.03,  nan ],
	[ nan,     900,     300,  nan,    0.06,  nan ],
	[ nan,    1200,     400,  nan,    0.10,  nan ],
	[ nan,    1500,     500,  nan,    0.16,  nan ],
	[ nan,    1800,     600,  nan,    0.22,  nan ],
	[ nan,    2100,     700,  nan,    0.30,  nan ],
	[ nan,    2400,     800,  nan,    0.37,  nan ],
	[ nan,    2700,     900,  nan,    0.48,  nan ],
	[ nan,    3000,    1000,  nan,    0.62,  nan ],
	[ nan,    6000,    2000,  nan,    2.68,  nan ],
	[ nan,    9000,    3000,  nan,    6.89,  nan ],
	[ nan,   12000,    4000,  nan,   13.83,  nan ],
	[ nan,   15000,    5000,  nan,   24.11,  nan ],
	[ nan,   18000,    6000,  nan,   39.47,  nan ],
	[ nan,   21000,    7000,  nan,   58.52,  nan ],
	[ nan,   24000,    8000,  nan,   83.76,  nan ],
	[ nan,   27000,    9000,  nan,  114.69,  nan ],
	[ nan,     100,     300,  nan,    0.01,  nan ],
	[ nan,     200,     600,  nan,    0.03,  nan ],
	[ nan,     300,     900,  nan,    0.07,  nan ],
	[ nan,     400,    1200,  nan,    0.11,  nan ],
	[ nan,     500,    1500,  nan,    0.17,  nan ],
	[ nan,     600,    1800,  nan,    0.23,  nan ],
	[ nan,     700,    2100,  nan,    0.33,  nan ],
	[ nan,     800,    2400,  nan,    0.39,  nan ],
	[ nan,     900,    2700,  nan,    0.50,  nan ],
	[ nan,    1000,    3000,  nan,    0.65,  nan ],
	[ nan,    2000,    6000,  nan,    2.76,  nan ],
	[ nan,    3000,    9000,  nan,    7.10,  nan ],
	[ nan,    4000,   12000,  nan,   14.07,  nan ],
	[ nan,    5000,   15000,  nan,   24.53,  nan ],
	[ nan,    6000,   18000,  nan,   40.57,  nan ],
	[ nan,    7000,   21000,  nan,   60.37,  nan ],
	[ nan,    8000,   24000,  nan,   85.93,  nan ],
	[ nan,    9000,   27000,  nan,  117.67,  nan ],
	[ nan,   10000,     100,  nan,    0.03,  nan ],
	[ nan,   20000,     200,  nan,    0.18,  nan ],
	[ nan,   30000,     300,  nan,    0.32,  nan ],
	[ nan,   40000,     400,  nan,    0.65,  nan ],
	[ nan,   50000,     500,  nan,    1.56,  nan ],
	[ nan,   60000,     600,  nan,    1.98,  nan ],
	[ nan,   70000,     700,  nan,    2.51,  nan ],
	[ nan,   80000,     800,  nan,    3.18,  nan ],
	[ nan,   90000,     900,  nan,    4.16,  nan ],
	[ nan,  100000,    1000,  nan,    6.71,  nan ],
	[ nan,  200000,    2000,  nan,   36.14,  nan ],
	[ nan,     100,   10000,  nan,    0.04,  nan ],
	[ nan,     200,   20000,  nan,    0.23,  nan ],
	[ nan,     300,   30000,  nan,    0.42,  nan ],
	[ nan,     400,   40000,  nan,    0.67,  nan ],
	[ nan,     500,   50000,  nan,    2.56,  nan ],
	[ nan,     600,   60000,  nan,    2.99,  nan ],
	[ nan,     700,   70000,  nan,    3.50,  nan ],
	[ nan,     800,   80000,  nan,    3.78,  nan ],
	[ nan,     900,   90000,  nan,    4.42,  nan ],
	[ nan,    1000,  100000,  nan,    9.12,  nan ],
	[ nan,    2000,  200000,  nan,   41.81,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/dgetrf.txt
# numactl --interleave=all ../testing/testing_dgetrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgetrf = array([
	[    10,     10,  nan,  nan,    0.03,  0.00,  nan ],
	[    20,     20,  nan,  nan,    0.18,  0.00,  nan ],
	[    30,     30,  nan,  nan,    0.36,  0.00,  nan ],
	[    40,     40,  nan,  nan,    0.91,  0.00,  nan ],
	[    50,     50,  nan,  nan,    1.42,  0.00,  nan ],
	[    60,     60,  nan,  nan,    2.00,  0.00,  nan ],
	[    70,     70,  nan,  nan,    1.75,  0.00,  nan ],
	[    80,     80,  nan,  nan,    2.43,  0.00,  nan ],
	[    90,     90,  nan,  nan,    3.05,  0.00,  nan ],
	[   100,    100,  nan,  nan,    3.70,  0.00,  nan ],
	[   200,    200,  nan,  nan,    3.47,  0.00,  nan ],
	[   300,    300,  nan,  nan,    8.27,  0.00,  nan ],
	[   400,    400,  nan,  nan,   14.01,  0.00,  nan ],
	[   500,    500,  nan,  nan,   21.65,  0.00,  nan ],
	[   600,    600,  nan,  nan,   28.58,  0.01,  nan ],
	[   700,    700,  nan,  nan,   37.02,  0.01,  nan ],
	[   800,    800,  nan,  nan,   45.15,  0.01,  nan ],
	[   900,    900,  nan,  nan,   54.03,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   62.55,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,  153.45,  0.03,  nan ],
	[  3000,   3000,  nan,  nan,  260.01,  0.07,  nan ],
	[  4000,   4000,  nan,  nan,  347.38,  0.12,  nan ],
	[  5000,   5000,  nan,  nan,  444.73,  0.19,  nan ],
	[  6000,   6000,  nan,  nan,  529.58,  0.27,  nan ],
	[  7000,   7000,  nan,  nan,  594.63,  0.38,  nan ],
	[  8000,   8000,  nan,  nan,  652.53,  0.52,  nan ],
	[  9000,   9000,  nan,  nan,  694.22,  0.70,  nan ],
	[ 10000,  10000,  nan,  nan,  737.16,  0.90,  nan ],
	[ 12000,  12000,  nan,  nan,  811.39,  1.42,  nan ],
	[ 14000,  14000,  nan,  nan,  854.75,  2.14,  nan ],
	[ 16000,  16000,  nan,  nan,  891.71,  3.06,  nan ],
	[ 18000,  18000,  nan,  nan,  915.62,  4.25,  nan ],
	[ 20000,  20000,  nan,  nan,  942.41,  5.66,  nan ],
])

# numactl --interleave=all ../testing/testing_dgetrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.02,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.07,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.16,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.27,  0.00,  nan ],
	[    60,     60,  nan,  nan,     0.47,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.59,  0.00,  nan ],
	[    80,     80,  nan,  nan,     0.86,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.10,  0.00,  nan ],
	[   100,    100,  nan,  nan,     1.43,  0.00,  nan ],
	[   200,    200,  nan,  nan,     2.26,  0.00,  nan ],
	[   300,    300,  nan,  nan,     5.95,  0.00,  nan ],
	[   400,    400,  nan,  nan,    11.38,  0.00,  nan ],
	[   500,    500,  nan,  nan,    18.16,  0.00,  nan ],
	[   600,    600,  nan,  nan,    26.82,  0.01,  nan ],
	[   700,    700,  nan,  nan,    35.30,  0.01,  nan ],
	[   800,    800,  nan,  nan,    44.51,  0.01,  nan ],
	[   900,    900,  nan,  nan,    54.18,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    63.98,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   178.98,  0.03,  nan ],
	[  3000,   3000,  nan,  nan,   315.08,  0.06,  nan ],
	[  4000,   4000,  nan,  nan,   407.04,  0.10,  nan ],
	[  5000,   5000,  nan,  nan,   526.51,  0.16,  nan ],
	[  6000,   6000,  nan,  nan,   640.55,  0.22,  nan ],
	[  7000,   7000,  nan,  nan,   718.58,  0.32,  nan ],
	[  8000,   8000,  nan,  nan,   779.09,  0.44,  nan ],
	[  9000,   9000,  nan,  nan,   815.55,  0.60,  nan ],
	[ 10000,  10000,  nan,  nan,   861.60,  0.77,  nan ],
	[ 12000,  12000,  nan,  nan,   932.31,  1.24,  nan ],
	[ 14000,  14000,  nan,  nan,   972.53,  1.88,  nan ],
	[ 16000,  16000,  nan,  nan,  1005.85,  2.71,  nan ],
	[ 18000,  18000,  nan,  nan,  1021.26,  3.81,  nan ],
	[ 20000,  20000,  nan,  nan,  1041.20,  5.12,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/dpotrf.txt
# numactl --interleave=all ../testing/testing_dpotrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dpotrf = array([
	[    10,  nan,  nan,     0.08,  0.00,  nan ],
	[    20,  nan,  nan,     0.33,  0.00,  nan ],
	[    30,  nan,  nan,     0.67,  0.00,  nan ],
	[    40,  nan,  nan,     0.82,  0.00,  nan ],
	[    50,  nan,  nan,     1.86,  0.00,  nan ],
	[    60,  nan,  nan,     2.18,  0.00,  nan ],
	[    70,  nan,  nan,     1.82,  0.00,  nan ],
	[    80,  nan,  nan,     2.56,  0.00,  nan ],
	[    90,  nan,  nan,     2.50,  0.00,  nan ],
	[   100,  nan,  nan,     2.66,  0.00,  nan ],
	[   200,  nan,  nan,    13.10,  0.00,  nan ],
	[   300,  nan,  nan,     5.00,  0.00,  nan ],
	[   400,  nan,  nan,     9.81,  0.00,  nan ],
	[   500,  nan,  nan,    16.93,  0.00,  nan ],
	[   600,  nan,  nan,    20.47,  0.00,  nan ],
	[   700,  nan,  nan,    28.69,  0.00,  nan ],
	[   800,  nan,  nan,    33.21,  0.01,  nan ],
	[   900,  nan,  nan,    42.32,  0.01,  nan ],
	[  1000,  nan,  nan,    55.57,  0.01,  nan ],
	[  2000,  nan,  nan,   169.70,  0.02,  nan ],
	[  3000,  nan,  nan,   296.46,  0.03,  nan ],
	[  4000,  nan,  nan,   476.04,  0.04,  nan ],
	[  5000,  nan,  nan,   567.42,  0.07,  nan ],
	[  6000,  nan,  nan,   661.73,  0.11,  nan ],
	[  7000,  nan,  nan,   719.67,  0.16,  nan ],
	[  8000,  nan,  nan,   786.40,  0.22,  nan ],
	[  9000,  nan,  nan,   827.97,  0.29,  nan ],
	[ 10000,  nan,  nan,   864.94,  0.39,  nan ],
	[ 12000,  nan,  nan,   931.65,  0.62,  nan ],
	[ 14000,  nan,  nan,   982.09,  0.93,  nan ],
	[ 16000,  nan,  nan,  1024.56,  1.33,  nan ],
	[ 18000,  nan,  nan,  1045.70,  1.86,  nan ],
	[ 20000,  nan,  nan,  1072.76,  2.49,  nan ],
])

# numactl --interleave=all ../testing/testing_dpotrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.00,  0.00,  nan ],
	[    30,  nan,  nan,     0.01,  0.00,  nan ],
	[    40,  nan,  nan,     0.02,  0.00,  nan ],
	[    50,  nan,  nan,     0.04,  0.00,  nan ],
	[    60,  nan,  nan,     0.06,  0.00,  nan ],
	[    70,  nan,  nan,     0.09,  0.00,  nan ],
	[    80,  nan,  nan,     0.14,  0.00,  nan ],
	[    90,  nan,  nan,     0.19,  0.00,  nan ],
	[   100,  nan,  nan,     0.25,  0.00,  nan ],
	[   200,  nan,  nan,     5.02,  0.00,  nan ],
	[   300,  nan,  nan,     3.66,  0.00,  nan ],
	[   400,  nan,  nan,     7.40,  0.00,  nan ],
	[   500,  nan,  nan,    13.39,  0.00,  nan ],
	[   600,  nan,  nan,    17.87,  0.00,  nan ],
	[   700,  nan,  nan,    26.15,  0.00,  nan ],
	[   800,  nan,  nan,    31.48,  0.01,  nan ],
	[   900,  nan,  nan,    41.97,  0.01,  nan ],
	[  1000,  nan,  nan,    54.41,  0.01,  nan ],
	[  2000,  nan,  nan,   200.03,  0.01,  nan ],
	[  3000,  nan,  nan,   358.55,  0.03,  nan ],
	[  4000,  nan,  nan,   585.91,  0.04,  nan ],
	[  5000,  nan,  nan,   693.11,  0.06,  nan ],
	[  6000,  nan,  nan,   803.28,  0.09,  nan ],
	[  7000,  nan,  nan,   864.01,  0.13,  nan ],
	[  8000,  nan,  nan,   935.87,  0.18,  nan ],
	[  9000,  nan,  nan,   969.98,  0.25,  nan ],
	[ 10000,  nan,  nan,   998.77,  0.33,  nan ],
	[ 12000,  nan,  nan,  1053.51,  0.55,  nan ],
	[ 14000,  nan,  nan,  1095.34,  0.84,  nan ],
	[ 16000,  nan,  nan,  1128.53,  1.21,  nan ],
	[ 18000,  nan,  nan,  1139.54,  1.71,  nan ],
	[ 20000,  nan,  nan,  1159.31,  2.30,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/dsyevd.txt
# numactl --interleave=all ../testing/testing_dsyevd -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_dsyevd -JN -N 123 -N 1234 --range 12000:20000:2000
dsyevd_JN = array([
	[    10,  nan,    0.0000,  nan,  nan,  nan,  nan ],
	[    20,  nan,    0.0001,  nan,  nan,  nan,  nan ],
	[    30,  nan,    0.0001,  nan,  nan,  nan,  nan ],
	[    40,  nan,    0.0001,  nan,  nan,  nan,  nan ],
	[    50,  nan,    0.0002,  nan,  nan,  nan,  nan ],
	[    60,  nan,    0.0003,  nan,  nan,  nan,  nan ],
	[    70,  nan,    0.0004,  nan,  nan,  nan,  nan ],
	[    80,  nan,    0.0005,  nan,  nan,  nan,  nan ],
	[    90,  nan,    0.0007,  nan,  nan,  nan,  nan ],
	[   100,  nan,    0.0010,  nan,  nan,  nan,  nan ],
	[   200,  nan,    0.0049,  nan,  nan,  nan,  nan ],
	[   300,  nan,    0.0097,  nan,  nan,  nan,  nan ],
	[   400,  nan,    0.0162,  nan,  nan,  nan,  nan ],
	[   500,  nan,    0.0247,  nan,  nan,  nan,  nan ],
	[   600,  nan,    0.0335,  nan,  nan,  nan,  nan ],
	[   700,  nan,    0.0448,  nan,  nan,  nan,  nan ],
	[   800,  nan,    0.0585,  nan,  nan,  nan,  nan ],
	[   900,  nan,    0.0740,  nan,  nan,  nan,  nan ],
	[  1000,  nan,    0.0918,  nan,  nan,  nan,  nan ],
	[  2000,  nan,    0.3935,  nan,  nan,  nan,  nan ],
	[  3000,  nan,    1.3113,  nan,  nan,  nan,  nan ],
	[  4000,  nan,    2.3401,  nan,  nan,  nan,  nan ],
	[  5000,  nan,    3.7926,  nan,  nan,  nan,  nan ],
	[  6000,  nan,    5.7090,  nan,  nan,  nan,  nan ],
	[  7000,  nan,    8.1075,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   11.0877,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   14.7262,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,   19.0244,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,   30.4198,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,   44.7864,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,   63.6517,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,   87.5615,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  114.6263,  nan,  nan,  nan,  nan ],
])

# numactl --interleave=all ../testing/testing_dsyevd -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_dsyevd -JV -N 123 -N 1234 --range 12000:20000:2000
dsyevd_JV = array([
	[    10,  nan,    0.0001,  nan,  nan,  nan,  nan ],
	[    20,  nan,    0.0001,  nan,  nan,  nan,  nan ],
	[    30,  nan,    0.0003,  nan,  nan,  nan,  nan ],
	[    40,  nan,    0.0004,  nan,  nan,  nan,  nan ],
	[    50,  nan,    0.0005,  nan,  nan,  nan,  nan ],
	[    60,  nan,    0.0007,  nan,  nan,  nan,  nan ],
	[    70,  nan,    0.0009,  nan,  nan,  nan,  nan ],
	[    80,  nan,    0.0011,  nan,  nan,  nan,  nan ],
	[    90,  nan,    0.0016,  nan,  nan,  nan,  nan ],
	[   100,  nan,    0.0024,  nan,  nan,  nan,  nan ],
	[   200,  nan,    0.0095,  nan,  nan,  nan,  nan ],
	[   300,  nan,    0.0155,  nan,  nan,  nan,  nan ],
	[   400,  nan,    0.0241,  nan,  nan,  nan,  nan ],
	[   500,  nan,    0.0349,  nan,  nan,  nan,  nan ],
	[   600,  nan,    0.0413,  nan,  nan,  nan,  nan ],
	[   700,  nan,    0.0547,  nan,  nan,  nan,  nan ],
	[   800,  nan,    0.0690,  nan,  nan,  nan,  nan ],
	[   900,  nan,    0.0897,  nan,  nan,  nan,  nan ],
	[  1000,  nan,    0.1082,  nan,  nan,  nan,  nan ],
	[  2000,  nan,    0.4302,  nan,  nan,  nan,  nan ],
	[  3000,  nan,    1.4400,  nan,  nan,  nan,  nan ],
	[  4000,  nan,    2.4758,  nan,  nan,  nan,  nan ],
	[  5000,  nan,    3.9899,  nan,  nan,  nan,  nan ],
	[  6000,  nan,    6.0522,  nan,  nan,  nan,  nan ],
	[  7000,  nan,    8.7300,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   12.2179,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   16.2830,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,   21.0444,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,   33.7725,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,   48.9610,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,   70.3212,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,   97.6670,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  129.6026,  nan,  nan,  nan,  nan ],
])

# numactl --interleave=all ../testing/testing_dsyevd_gpu -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_dsyevd_gpu -JN -N 123 -N 1234 --range 12000:20000:2000
dsyevd_gpu_JN = array([
	[    10,  nan,    0.0003,  nan,  nan,  nan,  nan ],
	[    20,  nan,    0.0003,  nan,  nan,  nan,  nan ],
	[    30,  nan,    0.0003,  nan,  nan,  nan,  nan ],
	[    40,  nan,    0.0004,  nan,  nan,  nan,  nan ],
	[    50,  nan,    0.0005,  nan,  nan,  nan,  nan ],
	[    60,  nan,    0.0006,  nan,  nan,  nan,  nan ],
	[    70,  nan,    0.0007,  nan,  nan,  nan,  nan ],
	[    80,  nan,    0.0008,  nan,  nan,  nan,  nan ],
	[    90,  nan,    0.0011,  nan,  nan,  nan,  nan ],
	[   100,  nan,    0.0014,  nan,  nan,  nan,  nan ],
	[   200,  nan,    0.0053,  nan,  nan,  nan,  nan ],
	[   300,  nan,    0.0109,  nan,  nan,  nan,  nan ],
	[   400,  nan,    0.0183,  nan,  nan,  nan,  nan ],
	[   500,  nan,    0.0275,  nan,  nan,  nan,  nan ],
	[   600,  nan,    0.0384,  nan,  nan,  nan,  nan ],
	[   700,  nan,    0.0511,  nan,  nan,  nan,  nan ],
	[   800,  nan,    0.0662,  nan,  nan,  nan,  nan ],
	[   900,  nan,    0.0836,  nan,  nan,  nan,  nan ],
	[  1000,  nan,    0.1031,  nan,  nan,  nan,  nan ],
	[  2000,  nan,    0.4390,  nan,  nan,  nan,  nan ],
	[  3000,  nan,    1.3023,  nan,  nan,  nan,  nan ],
	[  4000,  nan,    2.3194,  nan,  nan,  nan,  nan ],
	[  5000,  nan,    3.7612,  nan,  nan,  nan,  nan ],
	[  6000,  nan,    5.6569,  nan,  nan,  nan,  nan ],
	[  7000,  nan,    7.9992,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   10.9571,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   14.5415,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,   18.8142,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,   30.2485,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,   44.3241,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,   63.1912,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,   86.6927,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  114.4557,  nan,  nan,  nan,  nan ],
])

# numactl --interleave=all ../testing/testing_dsyevd_gpu -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_dsyevd_gpu -JV -N 123 -N 1234 --range 12000:20000:2000
dsyevd_gpu_JV = array([
	[    10,  nan,    0.0003,  nan,  nan,  nan,  nan ],
	[    20,  nan,    0.0003,  nan,  nan,  nan,  nan ],
	[    30,  nan,    0.0004,  nan,  nan,  nan,  nan ],
	[    40,  nan,    0.0006,  nan,  nan,  nan,  nan ],
	[    50,  nan,    0.0007,  nan,  nan,  nan,  nan ],
	[    60,  nan,    0.0009,  nan,  nan,  nan,  nan ],
	[    70,  nan,    0.0011,  nan,  nan,  nan,  nan ],
	[    80,  nan,    0.0013,  nan,  nan,  nan,  nan ],
	[    90,  nan,    0.0018,  nan,  nan,  nan,  nan ],
	[   100,  nan,    0.0022,  nan,  nan,  nan,  nan ],
	[   200,  nan,    0.0089,  nan,  nan,  nan,  nan ],
	[   300,  nan,    0.0147,  nan,  nan,  nan,  nan ],
	[   400,  nan,    0.0233,  nan,  nan,  nan,  nan ],
	[   500,  nan,    0.0343,  nan,  nan,  nan,  nan ],
	[   600,  nan,    0.0407,  nan,  nan,  nan,  nan ],
	[   700,  nan,    0.0541,  nan,  nan,  nan,  nan ],
	[   800,  nan,    0.0702,  nan,  nan,  nan,  nan ],
	[   900,  nan,    0.1030,  nan,  nan,  nan,  nan ],
	[  1000,  nan,    0.1247,  nan,  nan,  nan,  nan ],
	[  2000,  nan,    0.4084,  nan,  nan,  nan,  nan ],
	[  3000,  nan,    1.3218,  nan,  nan,  nan,  nan ],
	[  4000,  nan,    2.4399,  nan,  nan,  nan,  nan ],
	[  5000,  nan,    3.9356,  nan,  nan,  nan,  nan ],
	[  6000,  nan,    6.0690,  nan,  nan,  nan,  nan ],
	[  7000,  nan,    8.7427,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   12.2263,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   16.3056,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,   21.5106,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,   34.9720,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,   52.3683,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,   77.9785,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,  105.1761,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  141.3858,  nan,  nan,  nan,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/dsyevd_2stage.txt
# numactl --interleave=all ../testing/testing_dsyevdx_2stage -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevdx_2stage_JN = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.00 ],
	[   300,    300,   0.02 ],
	[   400,    400,   0.03 ],
	[   500,    500,   0.05 ],
	[   600,    600,   0.07 ],
	[   700,    700,   0.09 ],
	[   800,    800,   0.11 ],
	[   900,    900,   0.12 ],
	[  1000,   1000,   0.14 ],
	[  2000,   2000,   0.48 ],
	[  3000,   3000,   0.86 ],
	[  4000,   4000,   1.27 ],
	[  5000,   5000,   1.86 ],
	[  6000,   6000,   2.67 ],
	[  7000,   7000,   3.50 ],
	[  8000,   8000,   4.55 ],
	[  9000,   9000,   5.45 ],
	[ 10000,  10000,   6.73 ],
	[ 12000,  12000,   9.83 ],
	[ 14000,  14000,  13.61 ],
	[ 16000,  16000,  18.00 ],
	[ 18000,  18000,  23.60 ],
	[ 20000,  20000,  30.02 ],
])

# numactl --interleave=all ../testing/testing_dsyevdx_2stage -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevdx_2stage_JV = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.01 ],
	[   300,    300,   0.03 ],
	[   400,    400,   0.05 ],
	[   500,    500,   0.06 ],
	[   600,    600,   0.08 ],
	[   700,    700,   0.10 ],
	[   800,    800,   0.13 ],
	[   900,    900,   0.15 ],
	[  1000,   1000,   0.18 ],
	[  2000,   2000,   0.52 ],
	[  3000,   3000,   1.03 ],
	[  4000,   4000,   1.78 ],
	[  5000,   5000,   2.76 ],
	[  6000,   6000,   4.09 ],
	[  7000,   7000,   5.84 ],
	[  8000,   8000,   8.14 ],
	[  9000,   9000,  10.56 ],
	[ 10000,  10000,  13.82 ],
	[ 12000,  12000,  22.20 ],
	[ 14000,  14000,  33.41 ],
	[ 16000,  16000,  47.43 ],
	[ 18000,  18000,  66.80 ],
	[ 20000,  20000,  90.45 ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/dsymv.txt
# numactl --interleave=all ../testing/testing_dsymv -L -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
dsymv_L = array([
	[    10,   0.01,   0.04,   0.01,   0.03,   0.01,   0.02,   0.08,   0.00,  1.78e-16,  8.88e-17,  8.88e-17,  nan ],
	[    11,   0.01,   0.03,   0.01,   0.03,   0.01,   0.02,   0.14,   0.00,  4.04e-17,  8.07e-17,  8.07e-17,  nan ],
	[    12,   0.01,   0.03,   0.01,   0.03,   0.02,   0.02,   0.10,   0.00,  1.11e-16,  3.70e-17,  3.70e-17,  nan ],
	[    13,   0.01,   0.03,   0.01,   0.03,   0.02,   0.02,   0.12,   0.00,  6.83e-17,  6.83e-17,  6.83e-17,  nan ],
	[    14,   0.01,   0.03,   0.01,   0.03,   0.02,   0.02,   0.22,   0.00,  6.34e-17,  6.34e-17,  6.34e-17,  nan ],
	[    15,   0.02,   0.03,   0.02,   0.03,   0.02,   0.02,   0.15,   0.00,  1.18e-16,  1.18e-16,  1.18e-16,  nan ],
	[    16,   0.02,   0.03,   0.02,   0.03,   0.03,   0.02,   0.29,   0.00,  1.11e-16,  1.11e-16,  1.11e-16,  nan ],
	[    17,   0.02,   0.03,   0.02,   0.03,   0.03,   0.02,   0.29,   0.00,  1.04e-16,  1.04e-16,  1.57e-16,  nan ],
	[    18,   0.02,   0.03,   0.02,   0.03,   0.03,   0.02,   0.24,   0.00,  9.87e-17,  1.48e-16,  9.87e-17,  nan ],
	[    19,   0.02,   0.04,   0.02,   0.03,   0.03,   0.02,   0.35,   0.00,  4.67e-17,  4.67e-17,  4.67e-17,  nan ],
	[    20,   0.02,   0.03,   0.03,   0.03,   0.04,   0.02,   0.44,   0.00,  8.88e-17,  8.88e-17,  8.88e-17,  nan ],
	[    21,   0.03,   0.03,   0.03,   0.03,   0.04,   0.02,   0.30,   0.00,  8.46e-17,  1.69e-16,  8.46e-17,  nan ],
	[    22,   0.03,   0.03,   0.03,   0.03,   0.05,   0.02,   0.33,   0.00,  1.61e-16,  1.61e-16,  1.61e-16,  nan ],
	[    23,   0.03,   0.03,   0.03,   0.03,   0.05,   0.02,   0.36,   0.00,  1.54e-16,  1.54e-16,  1.54e-16,  nan ],
	[    24,   0.04,   0.03,   0.04,   0.03,   0.05,   0.02,   0.42,   0.00,  1.48e-16,  1.48e-16,  1.48e-16,  nan ],
	[    25,   0.04,   0.03,   0.04,   0.03,   0.05,   0.02,   0.42,   0.00,  7.11e-17,  7.11e-17,  7.11e-17,  nan ],
	[    26,   0.04,   0.04,   0.04,   0.03,   0.06,   0.02,   0.49,   0.00,  1.37e-16,  1.37e-16,  1.37e-16,  nan ],
	[    27,   0.04,   0.03,   0.04,   0.03,   0.07,   0.02,   0.37,   0.00,  1.32e-16,  1.32e-16,  1.32e-16,  nan ],
	[    28,   0.05,   0.04,   0.05,   0.03,   0.07,   0.02,   0.57,   0.00,  1.90e-16,  1.90e-16,  1.27e-16,  nan ],
	[    29,   0.05,   0.03,   0.04,   0.04,   0.07,   0.02,   0.56,   0.00,  1.23e-16,  1.23e-16,  1.23e-16,  nan ],
	[    30,   0.06,   0.03,   0.06,   0.03,   0.08,   0.02,   0.65,   0.00,  1.18e-16,  1.18e-16,  1.18e-16,  nan ],
	[    31,   0.06,   0.03,   0.06,   0.03,   0.09,   0.02,   0.49,   0.00,  1.15e-16,  1.15e-16,  1.15e-16,  nan ],
	[    32,   0.07,   0.03,   0.06,   0.03,   0.09,   0.02,   0.68,   0.00,  1.11e-16,  1.11e-16,  1.11e-16,  nan ],
	[    33,   0.06,   0.04,   0.05,   0.04,   0.09,   0.03,   0.78,   0.00,  1.61e-16,  1.08e-16,  1.08e-16,  nan ],
	[    34,   0.07,   0.04,   0.06,   0.04,   0.10,   0.02,   0.62,   0.00,  2.09e-16,  2.09e-16,  1.57e-16,  nan ],
	[    35,   0.08,   0.03,   0.06,   0.04,   0.10,   0.02,   0.88,   0.00,  1.02e-16,  1.52e-16,  1.02e-16,  nan ],
	[    36,   0.09,   0.03,   0.07,   0.04,   0.12,   0.02,   0.70,   0.00,  1.48e-16,  1.48e-16,  1.48e-16,  nan ],
	[    37,   0.09,   0.03,   0.07,   0.04,   0.12,   0.02,   0.98,   0.00,  1.44e-16,  9.60e-17,  1.44e-16,  nan ],
	[    38,   0.09,   0.03,   0.07,   0.04,   0.14,   0.02,   0.73,   0.00,  1.40e-16,  9.35e-17,  1.40e-16,  nan ],
	[    39,   0.10,   0.03,   0.08,   0.04,   0.11,   0.03,   0.77,   0.00,  1.37e-16,  9.11e-17,  9.11e-17,  nan ],
	[    40,   0.10,   0.03,   0.08,   0.04,   0.14,   0.02,   1.06,   0.00,  8.88e-17,  1.33e-16,  8.88e-17,  nan ],
	[    41,   0.11,   0.03,   0.09,   0.04,   0.14,   0.02,   0.85,   0.00,  1.73e-16,  1.73e-16,  1.73e-16,  nan ],
	[    42,   0.12,   0.03,   0.09,   0.04,   0.15,   0.02,   0.89,   0.00,  2.11e-16,  1.27e-16,  8.46e-17,  nan ],
	[    43,   0.12,   0.03,   0.10,   0.04,   0.16,   0.02,   0.93,   0.00,  1.65e-16,  1.65e-16,  1.65e-16,  nan ],
	[    44,   0.12,   0.03,   0.10,   0.04,   0.16,   0.02,   1.38,   0.00,  1.21e-16,  1.61e-16,  1.61e-16,  nan ],
	[    45,   0.13,   0.03,   0.11,   0.04,   0.17,   0.02,   1.02,   0.00,  1.18e-16,  1.58e-16,  1.18e-16,  nan ],
	[    46,   0.12,   0.04,   0.11,   0.04,   0.18,   0.02,   1.13,   0.00,  1.54e-16,  1.54e-16,  1.54e-16,  nan ],
	[    47,   0.14,   0.03,   0.11,   0.04,   0.17,   0.03,   0.90,   0.01,  1.51e-16,  1.51e-16,  1.51e-16,  nan ],
	[    48,   0.13,   0.04,   0.12,   0.04,   0.20,   0.02,   1.16,   0.00,  2.22e-16,  2.22e-16,  2.22e-16,  nan ],
	[    49,   0.14,   0.04,   0.12,   0.04,   0.20,   0.03,   1.21,   0.00,  1.45e-16,  2.18e-16,  1.45e-16,  nan ],
	[    50,   0.16,   0.03,   0.12,   0.04,   0.20,   0.03,   1.02,   0.01,  2.13e-16,  2.13e-16,  1.42e-16,  nan ],
	[    51,   0.16,   0.03,   0.13,   0.04,   0.20,   0.03,   1.31,   0.00,  2.09e-16,  1.39e-16,  1.39e-16,  nan ],
	[    52,   0.16,   0.04,   0.13,   0.04,   0.22,   0.03,   1.10,   0.01,  1.37e-16,  1.37e-16,  1.37e-16,  nan ],
	[    53,   0.16,   0.04,   0.14,   0.04,   0.23,   0.03,   1.14,   0.01,  1.34e-16,  2.01e-16,  1.34e-16,  nan ],
	[    54,   0.17,   0.03,   0.14,   0.04,   0.24,   0.03,   1.19,   0.01,  1.32e-16,  1.32e-16,  1.32e-16,  nan ],
	[    55,   0.19,   0.03,   0.15,   0.04,   0.25,   0.02,   0.76,   0.01,  1.29e-16,  1.94e-16,  1.29e-16,  nan ],
	[    56,   0.19,   0.03,   0.16,   0.04,   0.27,   0.02,   1.58,   0.00,  3.17e-16,  1.90e-16,  1.90e-16,  nan ],
	[    57,   0.19,   0.04,   0.16,   0.04,   0.26,   0.03,   1.32,   0.01,  1.87e-16,  1.87e-16,  1.87e-16,  nan ],
	[    58,   0.20,   0.03,   0.17,   0.04,   0.28,   0.02,   1.37,   0.01,  1.23e-16,  1.23e-16,  1.23e-16,  nan ],
	[    59,   0.20,   0.04,   0.17,   0.04,   0.28,   0.03,   1.41,   0.01,  1.81e-16,  1.81e-16,  1.20e-16,  nan ],
	[    60,   0.23,   0.03,   0.17,   0.04,   0.29,   0.03,   1.81,   0.00,  1.78e-16,  1.18e-16,  1.18e-16,  nan ],
	[    61,   0.23,   0.03,   0.18,   0.04,   0.30,   0.03,   1.51,   0.01,  2.33e-16,  1.75e-16,  1.75e-16,  nan ],
	[    62,   0.22,   0.04,   0.19,   0.04,   0.31,   0.03,   1.56,   0.01,  1.72e-16,  1.72e-16,  1.15e-16,  nan ],
	[    63,   0.23,   0.04,   0.19,   0.04,   0.32,   0.03,   1.35,   0.01,  1.13e-16,  1.13e-16,  1.13e-16,  nan ],
	[    64,   0.24,   0.04,   0.21,   0.04,   0.33,   0.03,   1.66,   0.01,  1.67e-16,  1.11e-16,  2.22e-16,  nan ],
	[    65,   0.21,   0.04,   0.19,   0.04,   0.33,   0.03,   1.71,   0.01,  2.19e-16,  1.64e-16,  1.64e-16,  nan ],
	[    66,   0.23,   0.04,   0.20,   0.04,   0.33,   0.03,   1.48,   0.01,  2.15e-16,  2.69e-16,  2.15e-16,  nan ],
	[    67,   0.23,   0.04,   0.22,   0.04,   0.32,   0.03,   1.82,   0.01,  1.59e-16,  1.59e-16,  1.59e-16,  nan ],
	[    68,   0.25,   0.04,   0.21,   0.04,   0.35,   0.03,   1.57,   0.01,  1.57e-16,  1.57e-16,  1.04e-16,  nan ],
	[    69,   0.24,   0.04,   0.22,   0.04,   0.37,   0.03,   1.56,   0.01,  1.54e-16,  1.54e-16,  1.54e-16,  nan ],
	[    70,   0.26,   0.04,   0.24,   0.04,   0.37,   0.03,   1.67,   0.01,  2.03e-16,  2.54e-16,  2.54e-16,  nan ],
	[    71,   0.27,   0.04,   0.24,   0.04,   0.39,   0.03,   1.72,   0.01,  2.50e-16,  2.00e-16,  2.00e-16,  nan ],
	[    72,   0.28,   0.04,   0.24,   0.04,   0.40,   0.03,   1.76,   0.01,  1.97e-16,  1.97e-16,  1.48e-16,  nan ],
	[    73,   0.26,   0.04,   0.25,   0.04,   0.39,   0.03,   1.81,   0.01,  1.95e-16,  1.95e-16,  1.95e-16,  nan ],
	[    74,   0.28,   0.04,   0.25,   0.04,   0.39,   0.03,   1.61,   0.01,  1.44e-16,  1.92e-16,  1.92e-16,  nan ],
	[    75,   0.28,   0.04,   0.27,   0.04,   0.40,   0.03,   1.65,   0.01,  2.37e-16,  1.89e-16,  1.89e-16,  nan ],
	[    76,   0.29,   0.04,   0.27,   0.04,   0.42,   0.03,   1.69,   0.01,  1.40e-16,  2.34e-16,  1.87e-16,  nan ],
	[    77,   0.29,   0.04,   0.28,   0.04,   0.42,   0.03,   2.02,   0.01,  2.77e-16,  1.85e-16,  1.85e-16,  nan ],
	[    78,   0.29,   0.04,   0.29,   0.04,   0.43,   0.03,   1.78,   0.01,  2.28e-16,  2.73e-16,  2.28e-16,  nan ],
	[    79,   0.30,   0.04,   0.29,   0.04,   0.43,   0.03,   1.56,   0.01,  1.80e-16,  2.25e-16,  1.80e-16,  nan ],
	[    80,   0.33,   0.04,   0.29,   0.04,   0.45,   0.03,   1.87,   0.01,  2.66e-16,  1.78e-16,  1.78e-16,  nan ],
	[    81,   0.32,   0.04,   0.30,   0.04,   0.48,   0.03,   1.92,   0.01,  2.63e-16,  2.19e-16,  1.75e-16,  nan ],
	[    82,   0.34,   0.04,   0.30,   0.05,   0.49,   0.03,   1.97,   0.01,  1.73e-16,  1.73e-16,  1.30e-16,  nan ],
	[    83,   0.35,   0.04,   0.31,   0.05,   0.50,   0.03,   1.72,   0.01,  1.71e-16,  1.71e-16,  1.71e-16,  nan ],
	[    84,   0.36,   0.04,   0.32,   0.04,   0.53,   0.03,   1.81,   0.01,  2.11e-16,  2.11e-16,  1.69e-16,  nan ],
	[    85,   0.37,   0.04,   0.33,   0.04,   0.50,   0.03,   2.36,   0.01,  1.67e-16,  1.67e-16,  2.09e-16,  nan ],
	[    86,   0.39,   0.04,   0.34,   0.04,   0.53,   0.03,   1.85,   0.01,  1.65e-16,  2.07e-16,  1.65e-16,  nan ],
	[    87,   0.39,   0.04,   0.35,   0.04,   0.55,   0.03,   2.21,   0.01,  2.45e-16,  2.45e-16,  2.45e-16,  nan ],
	[    88,   0.39,   0.04,   0.35,   0.04,   0.58,   0.03,   2.63,   0.01,  1.61e-16,  1.61e-16,  1.61e-16,  nan ],
	[    89,   0.39,   0.04,   0.36,   0.05,   0.55,   0.03,   2.04,   0.01,  2.40e-16,  1.60e-16,  1.60e-16,  nan ],
	[    90,   0.41,   0.04,   0.36,   0.05,   0.59,   0.03,   2.08,   0.01,  2.37e-16,  2.37e-16,  1.58e-16,  nan ],
	[   100,   0.50,   0.04,   0.43,   0.05,   0.68,   0.03,   2.29,   0.01,  1.78e-16,  2.13e-16,  2.13e-16,  nan ],
	[   110,   0.61,   0.04,   0.53,   0.05,   0.76,   0.03,   2.44,   0.01,  2.58e-16,  2.58e-16,  3.23e-16,  nan ],
	[   120,   0.67,   0.04,   0.62,   0.05,   0.91,   0.03,   2.65,   0.01,  2.37e-16,  2.96e-16,  2.37e-16,  nan ],
	[   130,   0.69,   0.05,   0.71,   0.05,   1.03,   0.03,   3.11,   0.01,  2.19e-16,  2.73e-16,  2.19e-16,  nan ],
	[   140,   0.84,   0.05,   0.80,   0.05,   1.16,   0.03,   3.01,   0.01,  3.05e-16,  2.54e-16,  3.05e-16,  nan ],
	[   150,   0.93,   0.05,   0.89,   0.05,   1.38,   0.03,   3.02,   0.02,  2.37e-16,  2.37e-16,  2.84e-16,  nan ],
	[   160,   1.12,   0.05,   1.08,   0.05,   1.57,   0.03,   3.23,   0.02,  2.22e-16,  1.78e-16,  1.78e-16,  nan ],
	[   170,   1.26,   0.05,   1.14,   0.05,   1.66,   0.04,   2.00,   0.03,  4.18e-16,  4.18e-16,  4.18e-16,  nan ],
	[   180,   1.31,   0.05,   1.16,   0.06,   1.76,   0.04,   2.51,   0.03,  2.37e-16,  2.76e-16,  2.37e-16,  nan ],
	[   190,   1.55,   0.05,   1.37,   0.05,   2.02,   0.04,   2.27,   0.03,  3.74e-16,  3.74e-16,  3.74e-16,  nan ],
	[   200,   1.43,   0.06,   1.49,   0.05,   2.07,   0.04,   2.11,   0.04,  5.68e-16,  6.39e-16,  5.68e-16,  nan ],
	[   210,   1.67,   0.05,   1.67,   0.05,   2.40,   0.04,   2.55,   0.03,  4.74e-16,  4.74e-16,  4.74e-16,  nan ],
	[   220,   1.87,   0.05,   1.80,   0.05,   2.57,   0.04,   2.70,   0.04,  4.52e-16,  3.88e-16,  3.88e-16,  nan ],
	[   230,   2.01,   0.05,   1.90,   0.06,   2.67,   0.04,   2.72,   0.04,  4.33e-16,  4.33e-16,  3.71e-16,  nan ],
	[   240,   2.06,   0.06,   2.06,   0.06,   2.82,   0.04,   2.74,   0.04,  3.55e-16,  2.96e-16,  3.55e-16,  nan ],
	[   250,   2.24,   0.06,   2.20,   0.06,   3.06,   0.04,   3.06,   0.04,  3.41e-16,  3.41e-16,  3.41e-16,  nan ],
	[   260,   2.30,   0.06,   2.38,   0.06,   3.16,   0.04,   3.01,   0.05,  3.83e-16,  3.28e-16,  3.28e-16,  nan ],
	[   270,   2.45,   0.06,   2.61,   0.06,   3.34,   0.04,   2.99,   0.05,  4.74e-16,  4.21e-16,  4.21e-16,  nan ],
	[   280,   2.62,   0.06,   2.67,   0.06,   3.73,   0.04,   3.14,   0.05,  4.57e-16,  4.06e-16,  3.55e-16,  nan ],
	[   290,   2.72,   0.06,   2.81,   0.06,   3.75,   0.05,   3.39,   0.05,  4.41e-16,  3.43e-16,  4.41e-16,  nan ],
	[   300,   2.96,   0.06,   3.02,   0.06,   3.61,   0.05,   3.47,   0.05,  6.63e-16,  4.74e-16,  4.74e-16,  nan ],
	[   310,   3.26,   0.06,   3.21,   0.06,   4.40,   0.04,   3.95,   0.05,  4.13e-16,  4.58e-16,  4.58e-16,  nan ],
	[   320,   3.37,   0.06,   3.42,   0.06,   4.56,   0.05,   3.37,   0.06,  4.00e-16,  4.00e-16,  3.55e-16,  nan ],
	[   330,   3.31,   0.07,   3.47,   0.06,   4.56,   0.05,   3.65,   0.06,  6.03e-16,  5.17e-16,  5.17e-16,  nan ],
	[   340,   3.41,   0.07,   3.62,   0.06,   4.81,   0.05,   3.31,   0.07,  5.02e-16,  4.60e-16,  5.02e-16,  nan ],
	[   350,   3.62,   0.07,   3.83,   0.06,   5.23,   0.05,   4.17,   0.06,  4.06e-16,  4.06e-16,  4.87e-16,  nan ],
	[   360,   3.83,   0.07,   4.01,   0.06,   5.09,   0.05,   3.83,   0.07,  6.32e-16,  4.74e-16,  5.53e-16,  nan ],
	[   370,   4.10,   0.07,   4.16,   0.07,   5.38,   0.05,   3.81,   0.07,  5.38e-16,  5.38e-16,  5.38e-16,  nan ],
	[   380,   4.32,   0.07,   4.45,   0.07,   5.78,   0.05,   3.92,   0.07,  5.98e-16,  5.98e-16,  6.73e-16,  nan ],
	[   390,   3.91,   0.08,   4.43,   0.07,   5.64,   0.05,   4.85,   0.06,  6.56e-16,  5.83e-16,  5.10e-16,  nan ],
	[   400,   2.69,   0.12,   4.79,   0.07,   6.06,   0.05,   5.18,   0.06,  8.53e-16,  7.82e-16,  7.11e-16,  nan ],
	[   410,   4.43,   0.08,   4.82,   0.07,   6.48,   0.05,   4.82,   0.07,  4.85e-16,  4.85e-16,  4.85e-16,  nan ],
	[   420,   4.77,   0.07,   4.99,   0.07,   6.53,   0.05,   5.11,   0.07,  6.77e-16,  6.77e-16,  5.41e-16,  nan ],
	[   430,   4.89,   0.08,   5.29,   0.07,   6.73,   0.06,   5.89,   0.06,  6.61e-16,  7.27e-16,  5.95e-16,  nan ],
	[   440,   5.10,   0.08,   5.39,   0.07,   7.05,   0.06,   6.36,   0.06,  5.17e-16,  5.17e-16,  5.17e-16,  nan ],
	[   450,   5.14,   0.08,   5.47,   0.07,   6.98,   0.06,   5.49,   0.07,  5.05e-16,  5.05e-16,  5.05e-16,  nan ],
	[   460,   5.17,   0.08,   5.67,   0.07,   7.06,   0.06,   5.97,   0.07,  8.65e-16,  8.03e-16,  7.41e-16,  nan ],
	[   470,   5.32,   0.08,   5.91,   0.07,   7.25,   0.06,   6.15,   0.07,  6.05e-16,  6.05e-16,  6.05e-16,  nan ],
	[   480,   5.76,   0.08,   6.15,   0.08,   7.69,   0.06,   6.80,   0.07,  6.51e-16,  6.51e-16,  6.51e-16,  nan ],
	[   490,   5.80,   0.08,   6.25,   0.08,   7.18,   0.07,   6.43,   0.07,  7.54e-16,  7.54e-16,  7.54e-16,  nan ],
	[   500,   6.11,   0.08,   6.51,   0.08,   7.84,   0.06,   6.18,   0.08,  8.53e-16,  7.96e-16,  8.53e-16,  nan ],
	[   510,   6.43,   0.08,   6.77,   0.08,   8.25,   0.06,   7.24,   0.07,  8.36e-16,  7.80e-16,  7.80e-16,  nan ],
	[   520,   6.23,   0.09,   6.87,   0.08,   8.09,   0.07,   6.87,   0.08,  7.65e-16,  6.01e-16,  5.47e-16,  nan ],
	[   530,   6.54,   0.09,   7.03,   0.08,   8.40,   0.07,   6.86,   0.08,  6.97e-16,  6.44e-16,  6.44e-16,  nan ],
	[   540,   6.71,   0.09,   7.29,   0.08,   8.48,   0.07,   7.21,   0.08,  6.84e-16,  5.79e-16,  5.26e-16,  nan ],
	[   550,   6.67,   0.09,   7.39,   0.08,   8.68,   0.07,   7.87,   0.08,  5.17e-16,  5.17e-16,  6.20e-16,  nan ],
	[   560,   7.14,   0.09,   7.75,   0.08,   8.73,   0.07,   8.16,   0.08,  5.58e-16,  5.58e-16,  6.09e-16,  nan ],
	[   570,   7.07,   0.09,   7.73,   0.08,   9.04,   0.07,   7.32,   0.09,  8.48e-16,  6.98e-16,  7.98e-16,  nan ],
	[   580,   6.88,   0.10,   7.92,   0.09,   9.36,   0.07,   7.74,   0.09,  6.86e-16,  6.86e-16,  6.37e-16,  nan ],
	[   590,   7.19,   0.10,   8.22,   0.08,   9.69,   0.07,   8.10,   0.09,  8.19e-16,  8.19e-16,  7.23e-16,  nan ],
	[   600,   7.52,   0.10,   8.38,   0.09,   9.85,   0.07,   7.84,   0.09,  7.58e-16,  7.58e-16,  7.58e-16,  nan ],
	[   610,   7.61,   0.10,   8.29,   0.09,   9.68,   0.08,   7.61,   0.10,  6.52e-16,  5.13e-16,  6.06e-16,  nan ],
	[   620,   7.55,   0.10,   8.66,   0.09,  10.12,   0.08,   7.19,   0.11,  5.96e-16,  6.42e-16,  5.96e-16,  nan ],
	[   630,   8.02,   0.10,   8.64,   0.09,  10.49,   0.08,   8.53,   0.09,  6.77e-16,  7.22e-16,  6.77e-16,  nan ],
	[   640,   8.04,   0.10,   9.01,   0.09,  10.82,   0.08,   8.29,   0.10,  5.77e-16,  6.22e-16,  5.77e-16,  nan ],
	[   650,   7.98,   0.11,   9.10,   0.09,  10.86,   0.08,   7.91,   0.11,  7.00e-16,  6.12e-16,  6.12e-16,  nan ],
	[   660,   8.17,   0.11,   9.10,   0.10,  11.16,   0.08,   8.08,   0.11,  7.32e-16,  6.46e-16,  6.46e-16,  nan ],
	[   670,   8.23,   0.11,   9.38,   0.10,  11.36,   0.08,   8.65,   0.10,  5.51e-16,  5.51e-16,  5.51e-16,  nan ],
	[   680,   8.50,   0.11,   9.64,   0.10,  11.60,   0.08,   8.75,   0.11,  5.85e-16,  5.85e-16,  6.69e-16,  nan ],
	[   690,   8.75,   0.11,   9.73,   0.10,  11.90,   0.08,   8.44,   0.11,  6.18e-16,  5.77e-16,  4.94e-16,  nan ],
	[   700,   9.01,   0.11,   9.99,   0.10,  12.25,   0.08,   8.93,   0.11,  6.50e-16,  6.90e-16,  7.31e-16,  nan ],
	[   710,   8.86,   0.11,  10.20,   0.10,  12.17,   0.08,   9.54,   0.11,  1.04e-15,  9.61e-16,  8.81e-16,  nan ],
	[   720,   9.19,   0.11,  10.49,   0.10,  12.34,   0.08,   9.11,   0.11,  9.47e-16,  9.47e-16,  9.47e-16,  nan ],
	[   730,   9.04,   0.12,  10.46,   0.10,  12.00,   0.09,   8.68,   0.12,  8.57e-16,  7.79e-16,  7.01e-16,  nan ],
	[   740,   9.39,   0.12,  10.65,   0.10,  12.47,   0.09,   8.91,   0.12,  7.68e-16,  6.91e-16,  6.91e-16,  nan ],
	[   750,   9.62,   0.12,  10.84,   0.10,  12.40,   0.09,   9.62,   0.12,  7.58e-16,  7.58e-16,  8.34e-16,  nan ],
	[   760,   9.72,   0.12,  10.93,   0.11,  12.84,   0.09,   9.03,   0.13,  6.73e-16,  5.98e-16,  5.98e-16,  nan ],
	[   770,   9.82,   0.12,  11.09,   0.11,  13.17,   0.09,   8.72,   0.14,  7.38e-16,  5.91e-16,  6.64e-16,  nan ],
	[   780,   9.75,   0.12,  11.51,   0.11,  12.97,   0.09,   8.71,   0.14,  1.02e-15,  1.02e-15,  9.47e-16,  nan ],
	[   790,   9.93,   0.13,  11.57,   0.11,  13.58,   0.09,   8.99,   0.14,  7.91e-16,  7.20e-16,  7.91e-16,  nan ],
	[   800,  10.34,   0.12,  11.97,   0.11,  14.07,   0.09,   8.96,   0.14,  8.53e-16,  8.53e-16,  7.82e-16,  nan ],
	[   810,  10.50,   0.13,  12.03,   0.11,  13.57,   0.10,   9.26,   0.14,  9.82e-16,  8.42e-16,  8.42e-16,  nan ],
	[   820,  10.86,   0.12,  12.47,   0.11,  14.19,   0.09,   8.92,   0.15,  8.32e-16,  8.32e-16,  8.32e-16,  nan ],
	[   830,  10.88,   0.13,  12.21,   0.11,  14.36,   0.10,   9.01,   0.15,  1.03e-15,  9.59e-16,  8.90e-16,  nan ],
	[   840,  10.70,   0.13,  12.40,   0.11,  14.56,   0.10,   9.60,   0.15,  7.44e-16,  8.12e-16,  8.80e-16,  nan ],
	[   850,  10.80,   0.13,  12.80,   0.11,  14.91,   0.10,   9.34,   0.15,  8.69e-16,  9.36e-16,  9.36e-16,  nan ],
	[   860,  11.23,   0.13,  12.97,   0.11,  15.26,   0.10,   9.62,   0.15,  9.91e-16,  9.25e-16,  1.06e-15,  nan ],
	[   870,  11.39,   0.13,  13.30,   0.11,  15.03,   0.10,   9.96,   0.15,  9.80e-16,  7.84e-16,  7.84e-16,  nan ],
	[   880,  11.66,   0.13,  13.49,   0.11,  15.52,   0.10,   9.52,   0.16,  8.40e-16,  9.04e-16,  9.04e-16,  nan ],
	[   890,  12.03,   0.13,  13.66,   0.12,  15.54,   0.10,   9.84,   0.16,  9.58e-16,  8.94e-16,  9.58e-16,  nan ],
	[   900,  11.43,   0.14,  13.74,   0.12,  16.04,   0.10,   9.01,   0.18,  1.01e-15,  1.01e-15,  1.01e-15,  nan ],
	[  1000,  12.90,   0.16,  15.90,   0.13,  17.28,   0.12,  10.06,   0.20,  1.08e-15,  9.66e-16,  1.02e-15,  nan ],
	[  1100,  14.17,   0.17,  17.82,   0.14,  11.99,   0.20,   9.93,   0.24,  1.09e-15,  9.30e-16,  9.82e-16,  nan ],
	[  1200,  16.01,   0.18,  20.02,   0.14,  12.82,   0.22,  10.19,   0.28,  9.47e-16,  9.47e-16,  9.00e-16,  nan ],
	[  1300,  17.07,   0.20,  21.66,   0.16,  13.49,   0.25,   9.48,   0.36,  8.31e-16,  9.62e-16,  1.01e-15,  nan ],
	[  1400,  18.87,   0.21,  23.91,   0.16,  15.03,   0.26,  10.06,   0.39,  1.14e-15,  1.22e-15,  1.06e-15,  nan ],
	[  1500,  20.11,   0.22,  25.73,   0.17,  15.91,   0.28,   9.81,   0.46,  1.29e-15,  1.06e-15,  1.21e-15,  nan ],
	[  1600,  21.09,   0.24,  27.13,   0.19,  16.47,   0.31,   9.72,   0.53,  1.28e-15,  1.28e-15,  1.28e-15,  nan ],
	[  1700,  22.15,   0.26,  29.05,   0.20,  17.06,   0.34,  10.20,   0.57,  1.20e-15,  1.27e-15,  1.27e-15,  nan ],
	[  1800,  23.65,   0.27,  30.56,   0.21,  18.01,   0.36,   9.87,   0.66,  1.14e-15,  1.33e-15,  1.26e-15,  nan ],
	[  1900,  25.81,   0.28,  33.11,   0.22,  19.47,   0.37,   9.98,   0.72,  1.56e-15,  1.56e-15,  1.62e-15,  nan ],
	[  2000,  26.66,   0.30,  33.91,   0.24,  20.31,   0.39,  10.01,   0.80,  1.53e-15,  1.53e-15,  1.48e-15,  nan ],
	[  2100,  27.85,   0.32,  35.59,   0.25,  15.35,   0.57,  10.41,   0.85,  1.57e-15,  1.57e-15,  1.52e-15,  nan ],
	[  2200,  29.18,   0.33,  37.27,   0.26,  16.09,   0.60,  10.38,   0.93,  1.65e-15,  1.86e-15,  1.71e-15,  nan ],
	[  2300,  30.77,   0.34,  38.64,   0.27,  16.70,   0.63,  10.37,   1.02,  1.58e-15,  1.43e-15,  1.43e-15,  nan ],
	[  2400,  32.01,   0.36,  40.28,   0.29,  17.54,   0.66,  10.52,   1.10,  1.47e-15,  1.37e-15,  1.47e-15,  nan ],
	[  2500,  33.26,   0.38,  41.40,   0.30,  18.28,   0.68,  10.55,   1.19,  1.64e-15,  1.59e-15,  1.59e-15,  nan ],
	[  2600,  33.39,   0.41,  42.94,   0.31,  18.81,   0.72,  10.74,   1.26,  1.62e-15,  1.62e-15,  1.49e-15,  nan ],
	[  2700,  35.48,   0.41,  44.62,   0.33,  19.66,   0.74,  10.76,   1.36,  1.39e-15,  1.35e-15,  1.52e-15,  nan ],
	[  2800,  36.39,   0.43,  42.17,   0.37,  20.03,   0.78,  11.81,   1.33,  1.54e-15,  1.54e-15,  1.62e-15,  nan ],
	[  2900,  37.56,   0.45,  47.02,   0.36,  20.98,   0.80,  10.81,   1.56,  1.72e-15,  1.72e-15,  1.65e-15,  nan ],
	[  3000,  38.89,   0.46,  48.13,   0.37,  21.53,   0.84,  11.14,   1.62,  1.67e-15,  1.59e-15,  1.59e-15,  nan ],
	[  3100,  39.55,   0.49,  49.66,   0.39,  17.43,   1.10,  10.67,   1.80,  2.05e-15,  2.05e-15,  2.13e-15,  nan ],
	[  3200,  40.98,   0.50,  50.96,   0.40,  18.08,   1.13,  11.10,   1.85,  1.85e-15,  1.99e-15,  1.71e-15,  nan ],
	[  3300,  43.06,   0.51,  52.10,   0.42,  18.56,   1.17,  11.19,   1.95,  2.00e-15,  1.86e-15,  1.86e-15,  nan ],
	[  3400,  43.56,   0.53,  52.69,   0.44,  19.05,   1.21,  11.67,   1.98,  1.94e-15,  2.14e-15,  2.01e-15,  nan ],
	[  3500,  44.48,   0.55,  54.44,   0.45,  19.59,   1.25,  10.86,   2.26,  2.01e-15,  2.08e-15,  2.21e-15,  nan ],
	[  3600,  45.65,   0.57,  55.03,   0.47,  20.18,   1.29,  11.16,   2.32,  2.21e-15,  2.15e-15,  2.15e-15,  nan ],
	[  3700,  46.26,   0.59,  57.18,   0.48,  20.68,   1.32,  11.55,   2.37,  2.09e-15,  2.09e-15,  2.03e-15,  nan ],
	[  3800,  47.83,   0.60,  58.59,   0.49,  21.15,   1.37,  11.90,   2.43,  2.21e-15,  1.97e-15,  2.09e-15,  nan ],
	[  3900,  47.83,   0.64,  58.30,   0.52,  21.66,   1.41,  11.34,   2.68,  2.16e-15,  2.16e-15,  2.10e-15,  nan ],
	[  4000,  47.27,   0.68,  58.96,   0.54,  22.23,   1.44,  11.73,   2.73,  2.22e-15,  2.22e-15,  2.16e-15,  nan ],
	[  4100,  47.16,   0.71,  61.03,   0.55,  18.17,   1.85,  11.03,   3.05,  1.94e-15,  2.05e-15,  2.05e-15,  nan ],
	[  4200,  47.68,   0.74,  61.36,   0.58,  18.89,   1.87,  11.27,   3.13,  1.84e-15,  2.11e-15,  2.11e-15,  nan ],
	[  4300,  47.78,   0.77,  63.22,   0.59,  19.49,   1.90,  11.43,   3.24,  2.54e-15,  2.59e-15,  2.54e-15,  nan ],
	[  4400,  48.96,   0.79,  63.70,   0.61,  19.77,   1.96,  11.45,   3.38,  2.22e-15,  2.17e-15,  2.17e-15,  nan ],
	[  4500,  48.41,   0.84,  63.09,   0.64,  20.29,   2.00,  11.57,   3.50,  2.37e-15,  2.27e-15,  2.27e-15,  nan ],
	[  4600,  50.03,   0.85,  63.93,   0.66,  20.77,   2.04,  12.17,   3.48,  2.22e-15,  2.13e-15,  2.13e-15,  nan ],
	[  4700,  49.54,   0.89,  64.87,   0.68,  21.11,   2.09,  11.82,   3.74,  2.90e-15,  2.47e-15,  2.47e-15,  nan ],
	[  4800,  50.15,   0.92,  65.49,   0.70,  21.45,   2.15,  11.96,   3.85,  2.27e-15,  2.37e-15,  2.46e-15,  nan ],
	[  4900,  50.04,   0.96,  65.26,   0.74,  21.90,   2.19,  11.67,   4.12,  2.27e-15,  2.23e-15,  2.32e-15,  nan ],
	[  5000,  50.21,   1.00,  65.18,   0.77,  22.34,   2.24,  11.81,   4.24,  2.32e-15,  2.27e-15,  2.27e-15,  nan ],
	[  5100,  51.47,   1.01,  65.95,   0.79,  22.68,   2.29,  12.06,   4.31,  2.14e-15,  2.14e-15,  2.10e-15,  nan ],
	[  5200,  51.42,   1.05,  66.38,   0.81,  19.73,   2.74,  11.80,   4.59,  2.54e-15,  2.54e-15,  2.45e-15,  nan ],
	[  5300,  50.59,   1.11,  66.50,   0.84,  20.08,   2.80,  11.78,   4.77,  2.15e-15,  1.93e-15,  2.19e-15,  nan ],
	[  5400,  51.71,   1.13,  66.88,   0.87,  20.29,   2.88,  11.55,   5.05,  2.11e-15,  1.98e-15,  1.94e-15,  nan ],
	[  5500,  51.90,   1.17,  66.63,   0.91,  20.77,   2.91,  11.85,   5.11,  1.98e-15,  2.23e-15,  2.03e-15,  nan ],
	[  5600,  53.21,   1.18,  66.80,   0.94,  21.23,   2.95,  11.92,   5.26,  2.19e-15,  2.44e-15,  2.44e-15,  nan ],
	[  5700,  53.62,   1.21,  67.62,   0.96,  21.44,   3.03,  11.51,   5.65,  2.55e-15,  2.39e-15,  2.47e-15,  nan ],
	[  5800,  52.81,   1.27,  66.61,   1.01,  21.83,   3.08,  11.57,   5.82,  2.43e-15,  2.35e-15,  2.20e-15,  nan ],
	[  5900,  53.60,   1.30,  66.89,   1.04,  21.42,   3.25,  11.56,   6.02,  2.54e-15,  2.31e-15,  2.31e-15,  nan ],
	[  6000,  53.86,   1.34,  67.43,   1.07,  22.57,   3.19,  12.20,   5.90,  2.80e-15,  2.50e-15,  2.58e-15,  nan ],
	[  6100,  54.13,   1.37,  67.66,   1.10,  22.77,   3.27,  11.63,   6.40,  2.53e-15,  2.16e-15,  2.16e-15,  nan ],
	[  6200,  55.08,   1.40,  67.27,   1.14,  20.19,   3.81,  11.64,   6.60,  2.49e-15,  2.57e-15,  2.49e-15,  nan ],
	[  6300,  55.33,   1.43,  67.39,   1.18,  20.63,   3.85,  11.58,   6.86,  2.53e-15,  2.45e-15,  2.67e-15,  nan ],
	[  6400,  55.14,   1.49,  67.21,   1.22,  20.59,   3.98,  11.68,   7.01,  2.98e-15,  2.70e-15,  2.49e-15,  nan ],
	[  6500,  56.27,   1.50,  67.28,   1.26,  21.03,   4.02,  11.59,   7.29,  2.59e-15,  2.59e-15,  2.52e-15,  nan ],
	[  6600,  56.51,   1.54,  68.35,   1.27,  21.40,   4.07,  11.78,   7.40,  2.82e-15,  3.03e-15,  3.17e-15,  nan ],
	[  6700,  56.93,   1.58,  68.39,   1.31,  21.55,   4.17,  11.48,   7.82,  3.67e-15,  3.46e-15,  3.60e-15,  nan ],
	[  6800,  56.85,   1.63,  68.36,   1.35,  21.91,   4.22,  11.71,   7.90,  3.21e-15,  3.21e-15,  3.34e-15,  nan ],
	[  6900,  57.23,   1.66,  68.61,   1.39,  22.17,   4.30,  11.62,   8.20,  3.23e-15,  2.83e-15,  3.03e-15,  nan ],
	[  7000,  58.03,   1.69,  68.59,   1.43,  22.56,   4.34,  11.81,   8.30,  2.99e-15,  2.79e-15,  2.73e-15,  nan ],
	[  7100,  57.98,   1.74,  68.87,   1.46,  22.63,   4.46,  11.57,   8.71,  2.82e-15,  3.07e-15,  2.82e-15,  nan ],
	[  7200,  58.68,   1.77,  68.68,   1.51,  20.52,   5.05,  11.49,   9.02,  3.16e-15,  2.91e-15,  2.97e-15,  nan ],
	[  7300,  58.92,   1.81,  69.04,   1.54,  20.59,   5.18,  11.55,   9.23,  3.05e-15,  2.87e-15,  2.68e-15,  nan ],
	[  7400,  59.08,   1.85,  69.41,   1.58,  21.08,   5.20,  11.69,   9.37,  3.13e-15,  3.13e-15,  3.01e-15,  nan ],
	[  7500,  59.16,   1.90,  68.77,   1.64,  21.31,   5.28,  11.61,   9.69,  2.97e-15,  3.03e-15,  3.27e-15,  nan ],
	[  7600,  60.42,   1.91,  69.81,   1.66,  21.58,   5.35,  11.72,   9.86,  3.23e-15,  3.35e-15,  3.29e-15,  nan ],
	[  7700,  60.08,   1.97,  69.68,   1.70,  21.82,   5.44,  11.45,  10.35,  2.78e-15,  2.60e-15,  2.66e-15,  nan ],
	[  7800,  60.07,   2.03,  69.58,   1.75,  22.09,   5.51,  11.65,  10.45,  2.62e-15,  2.80e-15,  3.09e-15,  nan ],
	[  7900,  59.19,   2.11,  69.74,   1.79,  21.89,   5.70,  11.58,  10.78,  2.88e-15,  3.28e-15,  3.22e-15,  nan ],
	[  8000,  59.26,   2.16,  69.09,   1.85,  22.44,   5.70,  11.55,  11.09,  2.90e-15,  3.01e-15,  3.30e-15,  nan ],
	[  8100,  60.01,   2.19,  70.52,   1.86,  22.68,   5.79,  11.43,  11.48,  3.26e-15,  2.92e-15,  2.92e-15,  nan ],
	[  8200,  59.56,   2.26,  71.13,   1.89,  20.60,   6.53,  11.45,  11.74,  3.33e-15,  3.11e-15,  3.33e-15,  nan ],
	[  8300,  60.30,   2.29,  70.92,   1.94,  21.03,   6.55,  11.49,  11.99,  3.51e-15,  3.51e-15,  3.34e-15,  nan ],
	[  8400,  59.26,   2.38,  70.74,   2.00,  21.17,   6.67,  11.67,  12.09,  2.92e-15,  3.03e-15,  2.87e-15,  nan ],
	[  8500,  60.85,   2.38,  72.08,   2.00,  21.31,   6.78,  11.53,  12.54,  3.69e-15,  3.42e-15,  3.37e-15,  nan ],
	[  8600,  60.36,   2.45,  72.34,   2.04,  21.70,   6.82,  11.63,  12.72,  2.86e-15,  3.23e-15,  3.07e-15,  nan ],
	[  8700,  60.10,   2.52,  73.17,   2.07,  21.82,   6.94,  11.75,  12.89,  3.55e-15,  3.76e-15,  3.66e-15,  nan ],
	[  8800,  59.12,   2.62,  71.88,   2.16,  21.35,   7.26,  11.65,  13.30,  3.36e-15,  3.36e-15,  3.57e-15,  nan ],
	[  8900,  60.15,   2.63,  73.73,   2.15,  22.31,   7.10,  11.68,  13.57,  3.37e-15,  3.58e-15,  3.27e-15,  nan ],
	[  9000,  59.98,   2.70,  71.82,   2.26,  22.37,   7.24,  11.75,  13.79,  4.19e-15,  4.60e-15,  4.50e-15,  nan ],
	[ 10000,  61.97,   3.23,  72.50,   2.76,  22.36,   8.94,  11.82,  16.92,  3.41e-15,  3.59e-15,  3.46e-15,  nan ],
	[ 12000,  63.02,   4.57,  72.94,   3.95,  22.08,  13.04,  12.07,  23.86,  3.87e-15,  3.79e-15,  4.24e-15,  nan ],
	[ 14000,  66.04,   5.94,  74.04,   5.30,  21.91,  17.90,  12.00,  32.66,  4.09e-15,  3.90e-15,  3.90e-15,  nan ],
	[ 16000,  66.91,   7.65,  73.62,   6.96,  22.53,  22.72,  11.50,  44.52,  4.72e-15,  4.89e-15,  4.77e-15,  nan ],
	[ 18000,  66.61,   9.73,  74.82,   8.66,  21.98,  29.49,  11.98,  54.08,  5.41e-15,  5.10e-15,  5.15e-15,  nan ],
	[ 20000,  68.25,  11.72,  74.67,  10.71,  21.32,  37.53,  12.31,  64.99,  5.32e-15,  5.73e-15,  5.87e-15,  nan ],
])

# numactl --interleave=all ../testing/testing_dsymv -U -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
dsymv_U = array([
	[    10,   0.01,   0.03,   0.01,   0.03,   0.01,   0.02,   0.12,   0.00,  8.88e-17,  4.44e-17,  8.88e-17,  nan ],
	[    11,   0.01,   0.03,   0.01,   0.03,   0.01,   0.02,   0.14,   0.00,  4.04e-17,  8.07e-17,  8.07e-17,  nan ],
	[    12,   0.01,   0.03,   0.01,   0.03,   0.02,   0.02,   0.16,   0.00,  7.40e-17,  3.70e-17,  3.70e-17,  nan ],
	[    13,   0.01,   0.03,   0.01,   0.03,   0.02,   0.02,   0.17,   0.00,  6.83e-17,  6.83e-17,  6.83e-17,  nan ],
	[    14,   0.01,   0.03,   0.02,   0.03,   0.02,   0.02,   0.20,   0.00,  6.34e-17,  6.34e-17,  6.34e-17,  nan ],
	[    15,   0.02,   0.03,   0.02,   0.03,   0.02,   0.02,   0.15,   0.00,  5.92e-17,  5.92e-17,  1.18e-16,  nan ],
	[    16,   0.02,   0.03,   0.02,   0.03,   0.03,   0.02,   0.29,   0.00,  1.11e-16,  1.11e-16,  5.55e-17,  nan ],
	[    17,   0.02,   0.03,   0.02,   0.03,   0.03,   0.02,   0.32,   0.00,  1.57e-16,  2.09e-16,  1.04e-16,  nan ],
	[    18,   0.02,   0.03,   0.02,   0.03,   0.04,   0.02,   0.32,   0.00,  1.48e-16,  9.87e-17,  9.87e-17,  nan ],
	[    19,   0.02,   0.03,   0.03,   0.03,   0.04,   0.02,   0.40,   0.00,  9.35e-17,  9.35e-17,  9.35e-17,  nan ],
	[    20,   0.03,   0.03,   0.03,   0.03,   0.04,   0.02,   0.29,   0.00,  8.88e-17,  8.88e-17,  8.88e-17,  nan ],
	[    21,   0.03,   0.03,   0.03,   0.03,   0.05,   0.02,   0.48,   0.00,  1.69e-16,  8.46e-17,  8.46e-17,  nan ],
	[    22,   0.03,   0.03,   0.03,   0.03,   0.05,   0.02,   0.33,   0.00,  1.61e-16,  1.61e-16,  1.61e-16,  nan ],
	[    23,   0.04,   0.03,   0.04,   0.03,   0.06,   0.02,   0.51,   0.00,  1.54e-16,  7.72e-17,  7.72e-17,  nan ],
	[    24,   0.04,   0.03,   0.04,   0.03,   0.06,   0.02,   0.56,   0.00,  1.48e-16,  2.22e-16,  1.48e-16,  nan ],
	[    25,   0.04,   0.03,   0.04,   0.03,   0.06,   0.02,   0.68,   0.00,  1.42e-16,  1.42e-16,  1.42e-16,  nan ],
	[    26,   0.04,   0.03,   0.05,   0.03,   0.07,   0.02,   0.45,   0.00,  2.05e-16,  1.37e-16,  2.05e-16,  nan ],
	[    27,   0.05,   0.03,   0.05,   0.03,   0.08,   0.02,   0.49,   0.00,  1.32e-16,  1.32e-16,  1.97e-16,  nan ],
	[    28,   0.05,   0.03,   0.05,   0.03,   0.08,   0.02,   0.52,   0.00,  1.27e-16,  1.90e-16,  1.27e-16,  nan ],
	[    29,   0.06,   0.03,   0.06,   0.03,   0.08,   0.02,   0.91,   0.00,  1.23e-16,  1.84e-16,  1.23e-16,  nan ],
	[    30,   0.06,   0.03,   0.06,   0.03,   0.09,   0.02,   0.65,   0.00,  1.78e-16,  1.18e-16,  1.78e-16,  nan ],
	[    31,   0.06,   0.03,   0.06,   0.03,   0.09,   0.02,   0.64,   0.00,  1.15e-16,  2.29e-16,  1.72e-16,  nan ],
	[    32,   0.07,   0.03,   0.07,   0.03,   0.11,   0.02,   0.74,   0.00,  1.67e-16,  1.67e-16,  1.67e-16,  nan ],
	[    33,   0.07,   0.03,   0.06,   0.04,   0.11,   0.02,   0.72,   0.00,  1.61e-16,  1.08e-16,  1.08e-16,  nan ],
	[    34,   0.07,   0.03,   0.06,   0.04,   0.11,   0.02,   0.77,   0.00,  2.09e-16,  2.61e-16,  1.57e-16,  nan ],
	[    35,   0.08,   0.03,   0.06,   0.04,   0.12,   0.02,   0.81,   0.00,  1.52e-16,  1.52e-16,  1.02e-16,  nan ],
	[    36,   0.09,   0.03,   0.07,   0.04,   0.13,   0.02,   0.86,   0.00,  1.48e-16,  1.97e-16,  9.87e-17,  nan ],
	[    37,   0.10,   0.03,   0.08,   0.04,   0.13,   0.02,   0.91,   0.00,  1.92e-16,  1.44e-16,  1.92e-16,  nan ],
	[    38,   0.10,   0.03,   0.08,   0.04,   0.15,   0.02,   1.04,   0.00,  1.87e-16,  1.40e-16,  1.40e-16,  nan ],
	[    39,   0.11,   0.03,   0.08,   0.04,   0.15,   0.02,   1.01,   0.00,  9.11e-17,  9.11e-17,  1.37e-16,  nan ],
	[    40,   0.12,   0.03,   0.09,   0.04,   0.16,   0.02,   1.15,   0.00,  1.33e-16,  1.78e-16,  1.78e-16,  nan ],
	[    41,   0.12,   0.03,   0.09,   0.04,   0.16,   0.02,   1.20,   0.00,  2.60e-16,  1.73e-16,  1.73e-16,  nan ],
	[    42,   0.13,   0.03,   0.10,   0.04,   0.17,   0.02,   0.89,   0.00,  1.69e-16,  1.27e-16,  1.27e-16,  nan ],
	[    43,   0.13,   0.03,   0.10,   0.04,   0.18,   0.02,   0.93,   0.00,  1.65e-16,  2.48e-16,  1.65e-16,  nan ],
	[    44,   0.14,   0.03,   0.11,   0.04,   0.20,   0.02,   1.28,   0.00,  1.61e-16,  1.61e-16,  2.42e-16,  nan ],
	[    45,   0.14,   0.03,   0.11,   0.04,   0.20,   0.02,   1.34,   0.00,  1.58e-16,  1.58e-16,  1.18e-16,  nan ],
	[    46,   0.15,   0.03,   0.11,   0.04,   0.21,   0.02,   1.40,   0.00,  1.54e-16,  1.54e-16,  1.54e-16,  nan ],
	[    47,   0.16,   0.03,   0.12,   0.04,   0.23,   0.02,   1.11,   0.00,  1.51e-16,  1.51e-16,  1.51e-16,  nan ],
	[    48,   0.17,   0.03,   0.13,   0.04,   0.22,   0.02,   1.16,   0.00,  1.48e-16,  1.48e-16,  1.48e-16,  nan ],
	[    49,   0.17,   0.03,   0.13,   0.04,   0.23,   0.02,   1.58,   0.00,  2.18e-16,  2.90e-16,  2.18e-16,  nan ],
	[    50,   0.17,   0.03,   0.13,   0.04,   0.22,   0.02,   1.34,   0.00,  2.13e-16,  2.13e-16,  2.13e-16,  nan ],
	[    51,   0.18,   0.03,   0.14,   0.04,   0.24,   0.02,   1.31,   0.00,  2.09e-16,  2.09e-16,  2.09e-16,  nan ],
	[    52,   0.17,   0.03,   0.14,   0.04,   0.25,   0.02,   1.36,   0.00,  2.73e-16,  2.05e-16,  2.05e-16,  nan ],
	[    53,   0.18,   0.03,   0.15,   0.04,   0.26,   0.02,   1.50,   0.00,  2.01e-16,  2.68e-16,  2.01e-16,  nan ],
	[    54,   0.19,   0.03,   0.15,   0.04,   0.27,   0.02,   1.56,   0.00,  1.97e-16,  2.63e-16,  1.97e-16,  nan ],
	[    55,   0.20,   0.03,   0.16,   0.04,   0.28,   0.02,   1.61,   0.00,  1.94e-16,  1.94e-16,  1.29e-16,  nan ],
	[    56,   0.22,   0.03,   0.17,   0.04,   0.29,   0.02,   1.58,   0.00,  2.54e-16,  2.54e-16,  2.54e-16,  nan ],
	[    57,   0.23,   0.03,   0.17,   0.04,   0.29,   0.02,   1.63,   0.00,  1.87e-16,  1.87e-16,  1.87e-16,  nan ],
	[    58,   0.24,   0.03,   0.18,   0.04,   0.31,   0.02,   1.69,   0.00,  2.45e-16,  1.84e-16,  1.84e-16,  nan ],
	[    59,   0.25,   0.03,   0.19,   0.04,   0.31,   0.02,   1.41,   0.01,  2.41e-16,  2.41e-16,  2.41e-16,  nan ],
	[    60,   0.25,   0.03,   0.19,   0.04,   0.32,   0.02,   1.81,   0.00,  2.96e-16,  2.96e-16,  2.96e-16,  nan ],
	[    61,   0.25,   0.03,   0.19,   0.04,   0.33,   0.02,   1.98,   0.00,  1.75e-16,  1.75e-16,  1.75e-16,  nan ],
	[    62,   0.27,   0.03,   0.20,   0.04,   0.34,   0.02,   1.93,   0.00,  2.29e-16,  1.72e-16,  1.72e-16,  nan ],
	[    63,   0.28,   0.03,   0.20,   0.04,   0.35,   0.02,   1.61,   0.01,  2.26e-16,  2.26e-16,  2.26e-16,  nan ],
	[    64,   0.29,   0.03,   0.23,   0.04,   0.36,   0.02,   1.66,   0.01,  2.78e-16,  2.22e-16,  2.22e-16,  nan ],
	[    65,   0.23,   0.04,   0.21,   0.04,   0.36,   0.02,   1.71,   0.01,  2.73e-16,  2.19e-16,  3.28e-16,  nan ],
	[    66,   0.25,   0.04,   0.21,   0.04,   0.37,   0.02,   1.77,   0.01,  2.15e-16,  1.61e-16,  2.15e-16,  nan ],
	[    67,   0.25,   0.04,   0.22,   0.04,   0.38,   0.02,   1.82,   0.01,  1.59e-16,  1.59e-16,  1.59e-16,  nan ],
	[    68,   0.26,   0.04,   0.23,   0.04,   0.36,   0.03,   1.87,   0.01,  2.09e-16,  2.09e-16,  1.57e-16,  nan ],
	[    69,   0.26,   0.04,   0.23,   0.04,   0.39,   0.02,   1.93,   0.01,  2.57e-16,  2.57e-16,  2.06e-16,  nan ],
	[    70,   0.26,   0.04,   0.23,   0.04,   0.40,   0.03,   1.99,   0.01,  3.55e-16,  2.54e-16,  2.54e-16,  nan ],
	[    71,   0.27,   0.04,   0.24,   0.04,   0.42,   0.02,   2.04,   0.01,  4.00e-16,  2.00e-16,  3.00e-16,  nan ],
	[    72,   0.29,   0.04,   0.26,   0.04,   0.42,   0.03,   2.10,   0.01,  1.97e-16,  1.97e-16,  1.97e-16,  nan ],
	[    73,   0.32,   0.03,   0.27,   0.04,   0.43,   0.03,   2.16,   0.01,  2.43e-16,  1.95e-16,  2.43e-16,  nan ],
	[    74,   0.32,   0.03,   0.28,   0.04,   0.47,   0.02,   1.86,   0.01,  2.88e-16,  2.40e-16,  1.92e-16,  nan ],
	[    75,   0.33,   0.04,   0.29,   0.04,   0.46,   0.03,   1.91,   0.01,  2.37e-16,  1.89e-16,  1.89e-16,  nan ],
	[    76,   0.34,   0.03,   0.30,   0.04,   0.49,   0.02,   2.34,   0.01,  1.87e-16,  2.34e-16,  2.34e-16,  nan ],
	[    77,   0.34,   0.04,   0.30,   0.04,   0.52,   0.02,   2.40,   0.01,  2.77e-16,  2.77e-16,  1.85e-16,  nan ],
	[    78,   0.34,   0.04,   0.30,   0.04,   0.49,   0.03,   2.07,   0.01,  2.28e-16,  2.28e-16,  2.28e-16,  nan ],
	[    79,   0.35,   0.04,   0.32,   0.04,   0.52,   0.02,   2.12,   0.01,  3.15e-16,  2.70e-16,  2.70e-16,  nan ],
	[    80,   0.36,   0.04,   0.32,   0.04,   0.52,   0.03,   2.59,   0.01,  3.55e-16,  3.11e-16,  2.66e-16,  nan ],
	[    81,   0.37,   0.04,   0.32,   0.04,   0.51,   0.03,   2.23,   0.01,  2.19e-16,  2.19e-16,  2.19e-16,  nan ],
	[    82,   0.37,   0.04,   0.34,   0.04,   0.55,   0.02,   2.28,   0.01,  2.17e-16,  1.73e-16,  2.17e-16,  nan ],
	[    83,   0.36,   0.04,   0.34,   0.04,   0.54,   0.03,   2.02,   0.01,  3.00e-16,  2.57e-16,  2.57e-16,  nan ],
	[    84,   0.38,   0.04,   0.35,   0.04,   0.55,   0.03,   2.40,   0.01,  3.38e-16,  2.54e-16,  2.54e-16,  nan ],
	[    85,   0.37,   0.04,   0.35,   0.04,   0.56,   0.03,   2.36,   0.01,  2.51e-16,  2.51e-16,  2.51e-16,  nan ],
	[    86,   0.42,   0.04,   0.36,   0.04,   0.58,   0.03,   2.51,   0.01,  2.48e-16,  2.48e-16,  2.48e-16,  nan ],
	[    87,   0.39,   0.04,   0.36,   0.04,   0.57,   0.03,   3.06,   0.01,  3.27e-16,  2.45e-16,  2.45e-16,  nan ],
	[    88,   0.40,   0.04,   0.38,   0.04,   0.60,   0.03,   2.53,   0.01,  3.23e-16,  2.42e-16,  2.42e-16,  nan ],
	[    89,   0.43,   0.04,   0.39,   0.04,   0.62,   0.03,   2.24,   0.01,  2.40e-16,  2.40e-16,  2.40e-16,  nan ],
	[    90,   0.44,   0.04,   0.40,   0.04,   0.63,   0.03,   2.75,   0.01,  2.37e-16,  2.37e-16,  2.37e-16,  nan ],
	[   100,   0.55,   0.04,   0.48,   0.04,   0.72,   0.03,   3.39,   0.01,  2.13e-16,  2.13e-16,  2.13e-16,  nan ],
	[   110,   0.66,   0.04,   0.56,   0.04,   0.87,   0.03,   3.01,   0.01,  2.58e-16,  2.58e-16,  3.23e-16,  nan ],
	[   120,   0.79,   0.04,   0.68,   0.04,   1.00,   0.03,   3.21,   0.01,  3.55e-16,  2.96e-16,  3.55e-16,  nan ],
	[   130,   0.79,   0.04,   0.77,   0.04,   1.17,   0.03,   4.20,   0.01,  3.83e-16,  3.83e-16,  3.28e-16,  nan ],
	[   140,   0.92,   0.04,   0.84,   0.05,   1.36,   0.03,   3.94,   0.01,  4.06e-16,  4.57e-16,  4.57e-16,  nan ],
	[   150,   0.98,   0.05,   0.95,   0.05,   1.46,   0.03,   3.80,   0.01,  3.32e-16,  2.84e-16,  3.32e-16,  nan ],
	[   160,   1.17,   0.04,   1.12,   0.05,   1.72,   0.03,   3.93,   0.01,  5.33e-16,  4.00e-16,  4.00e-16,  nan ],
	[   170,   1.32,   0.04,   1.14,   0.05,   1.82,   0.03,   2.16,   0.03,  3.34e-16,  3.34e-16,  4.18e-16,  nan ],
	[   180,   1.45,   0.05,   1.36,   0.05,   1.98,   0.03,   2.51,   0.03,  3.95e-16,  3.16e-16,  2.76e-16,  nan ],
	[   190,   1.61,   0.05,   1.37,   0.05,   2.21,   0.03,   2.13,   0.03,  2.99e-16,  3.74e-16,  2.99e-16,  nan ],
	[   200,   1.58,   0.05,   1.49,   0.05,   2.31,   0.03,   2.76,   0.03,  4.26e-16,  4.26e-16,  3.55e-16,  nan ],
	[   210,   1.78,   0.05,   1.67,   0.05,   2.53,   0.04,   2.95,   0.03,  4.06e-16,  3.38e-16,  4.06e-16,  nan ],
	[   220,   1.94,   0.05,   1.98,   0.05,   2.79,   0.03,   2.63,   0.04,  5.17e-16,  4.52e-16,  4.52e-16,  nan ],
	[   230,   2.12,   0.05,   1.80,   0.06,   2.95,   0.04,   2.86,   0.04,  4.94e-16,  6.18e-16,  6.18e-16,  nan ],
	[   240,   2.19,   0.05,   2.19,   0.05,   3.13,   0.04,   2.89,   0.04,  4.74e-16,  5.33e-16,  4.74e-16,  nan ],
	[   250,   2.36,   0.05,   2.20,   0.06,   3.37,   0.04,   2.41,   0.05,  4.55e-16,  4.55e-16,  4.55e-16,  nan ],
	[   260,   2.34,   0.06,   2.19,   0.06,   3.41,   0.04,   3.16,   0.04,  4.37e-16,  4.92e-16,  4.37e-16,  nan ],
	[   270,   2.47,   0.06,   2.47,   0.06,   3.65,   0.04,   2.87,   0.05,  4.74e-16,  4.74e-16,  5.26e-16,  nan ],
	[   280,   2.76,   0.06,   2.76,   0.06,   3.93,   0.04,   3.49,   0.05,  5.08e-16,  5.08e-16,  5.08e-16,  nan ],
	[   290,   3.01,   0.06,   2.90,   0.06,   4.12,   0.04,   3.37,   0.05,  5.88e-16,  5.88e-16,  5.39e-16,  nan ],
	[   300,   2.96,   0.06,   2.96,   0.06,   4.19,   0.04,   3.68,   0.05,  6.16e-16,  6.63e-16,  6.63e-16,  nan ],
	[   310,   3.22,   0.06,   3.06,   0.06,   4.57,   0.04,   4.93,   0.04,  4.58e-16,  4.58e-16,  4.58e-16,  nan ],
	[   320,   3.53,   0.06,   3.61,   0.06,   4.90,   0.04,   4.87,   0.04,  4.88e-16,  4.88e-16,  4.44e-16,  nan ],
	[   330,   3.47,   0.06,   3.42,   0.06,   4.98,   0.04,   4.47,   0.05,  4.31e-16,  4.31e-16,  5.17e-16,  nan ],
	[   340,   3.68,   0.06,   3.80,   0.06,   5.17,   0.04,   4.63,   0.05,  5.02e-16,  5.02e-16,  5.02e-16,  nan ],
	[   350,   3.72,   0.07,   3.62,   0.07,   5.45,   0.05,   5.34,   0.05,  6.50e-16,  5.68e-16,  4.87e-16,  nan ],
	[   360,   3.88,   0.07,   3.83,   0.07,   5.53,   0.05,   5.40,   0.05,  6.32e-16,  4.74e-16,  4.74e-16,  nan ],
	[   370,   4.10,   0.07,   4.10,   0.07,   5.82,   0.05,   4.90,   0.06,  5.38e-16,  5.38e-16,  6.15e-16,  nan ],
	[   380,   4.53,   0.06,   4.67,   0.06,   6.16,   0.05,   5.37,   0.05,  5.98e-16,  5.24e-16,  5.24e-16,  nan ],
	[   390,   4.24,   0.07,   4.06,   0.08,   6.21,   0.05,   5.87,   0.05,  5.10e-16,  5.10e-16,  5.10e-16,  nan ],
	[   400,   3.15,   0.10,   4.52,   0.07,   6.41,   0.05,   6.06,   0.05,  5.68e-16,  5.68e-16,  4.97e-16,  nan ],
	[   410,   4.68,   0.07,   4.82,   0.07,   6.61,   0.05,   5.82,   0.06,  6.93e-16,  7.63e-16,  6.93e-16,  nan ],
	[   420,   4.98,   0.07,   5.13,   0.07,   6.80,   0.05,   5.98,   0.06,  5.41e-16,  5.41e-16,  5.41e-16,  nan ],
	[   430,   5.00,   0.07,   5.15,   0.07,   6.62,   0.06,   6.50,   0.06,  7.93e-16,  7.93e-16,  8.59e-16,  nan ],
	[   440,   5.32,   0.07,   5.39,   0.07,   7.30,   0.05,   6.59,   0.06,  5.81e-16,  5.81e-16,  6.46e-16,  nan ],
	[   450,   5.21,   0.08,   5.49,   0.07,   7.67,   0.05,   6.26,   0.06,  6.32e-16,  6.32e-16,  6.32e-16,  nan ],
	[   460,   5.23,   0.08,   5.89,   0.07,   7.57,   0.06,   6.24,   0.07,  6.80e-16,  6.80e-16,  6.80e-16,  nan ],
	[   470,   5.46,   0.08,   5.82,   0.08,   8.04,   0.06,   6.70,   0.07,  6.05e-16,  6.05e-16,  5.44e-16,  nan ],
	[   480,   5.92,   0.08,   6.61,   0.07,   8.42,   0.05,   6.80,   0.07,  8.29e-16,  7.70e-16,  7.70e-16,  nan ],
	[   490,   6.02,   0.08,   6.17,   0.08,   8.31,   0.06,   6.51,   0.07,  9.28e-16,  8.70e-16,  9.86e-16,  nan ],
	[   500,   6.13,   0.08,   6.18,   0.08,   8.65,   0.06,   6.33,   0.08,  9.09e-16,  8.53e-16,  7.96e-16,  nan ],
	[   510,   6.60,   0.08,   6.06,   0.09,   9.00,   0.06,   7.05,   0.07,  6.69e-16,  7.24e-16,  6.69e-16,  nan ],
	[   520,   6.38,   0.08,   6.30,   0.09,   8.88,   0.06,   6.68,   0.08,  6.56e-16,  7.11e-16,  6.01e-16,  nan ],
	[   530,   6.40,   0.09,   6.40,   0.09,   9.08,   0.06,   6.86,   0.08,  9.12e-16,  8.58e-16,  9.12e-16,  nan ],
	[   540,   6.71,   0.09,   6.94,   0.08,   9.43,   0.06,   7.21,   0.08,  7.37e-16,  7.37e-16,  8.42e-16,  nan ],
	[   550,   6.74,   0.09,   6.25,   0.10,   9.45,   0.06,   7.68,   0.08,  7.23e-16,  7.75e-16,  8.27e-16,  nan ],
	[   560,   6.85,   0.09,   7.30,   0.09,   9.65,   0.07,   7.96,   0.08,  6.60e-16,  7.61e-16,  7.11e-16,  nan ],
	[   570,   7.15,   0.09,   7.09,   0.09,  10.00,   0.07,   7.48,   0.09,  7.48e-16,  7.48e-16,  6.98e-16,  nan ],
	[   580,   6.95,   0.10,   7.58,   0.09,  10.39,   0.06,   7.83,   0.09,  7.35e-16,  7.84e-16,  7.35e-16,  nan ],
	[   590,   7.12,   0.10,   7.93,   0.09,  10.41,   0.07,   8.01,   0.09,  6.74e-16,  6.26e-16,  6.74e-16,  nan ],
	[   600,   7.34,   0.10,   7.94,   0.09,  10.61,   0.07,   8.09,   0.09,  9.00e-16,  7.58e-16,  7.58e-16,  nan ],
	[   610,   7.59,   0.10,   8.02,   0.09,  10.67,   0.07,   7.61,   0.10,  7.45e-16,  7.92e-16,  7.45e-16,  nan ],
	[   620,   7.78,   0.10,   7.86,   0.10,  10.99,   0.07,   8.01,   0.10,  9.17e-16,  9.17e-16,  8.71e-16,  nan ],
	[   630,   7.96,   0.10,   7.72,   0.10,  11.04,   0.07,   8.75,   0.09,  6.77e-16,  7.22e-16,  6.77e-16,  nan ],
	[   640,   8.21,   0.10,   8.73,   0.09,  11.40,   0.07,   7.97,   0.10,  7.99e-16,  7.11e-16,  7.55e-16,  nan ],
	[   650,   7.91,   0.11,   8.64,   0.10,  11.60,   0.07,   7.23,   0.12,  7.00e-16,  7.87e-16,  6.12e-16,  nan ],
	[   660,   8.15,   0.11,   8.63,   0.10,  11.81,   0.07,   7.92,   0.11,  7.32e-16,  7.32e-16,  6.46e-16,  nan ],
	[   670,   8.09,   0.11,   8.81,   0.10,  12.17,   0.07,   8.47,   0.11,  8.48e-16,  8.91e-16,  8.48e-16,  nan ],
	[   680,   8.58,   0.11,   9.27,   0.10,  12.49,   0.07,   8.35,   0.11,  7.52e-16,  7.11e-16,  7.52e-16,  nan ],
	[   690,   8.83,   0.11,   8.91,   0.11,  12.23,   0.08,   8.15,   0.12,  8.24e-16,  7.41e-16,  7.41e-16,  nan ],
	[   700,   9.09,   0.11,   9.62,   0.10,  12.59,   0.08,   8.17,   0.12,  8.12e-16,  7.31e-16,  7.31e-16,  nan ],
	[   710,   8.62,   0.12,   8.40,   0.12,  12.79,   0.08,   9.03,   0.11,  9.61e-16,  9.61e-16,  1.04e-15,  nan ],
	[   720,   9.03,   0.11,  10.08,   0.10,  13.32,   0.08,   9.27,   0.11,  8.68e-16,  7.89e-16,  8.68e-16,  nan ],
	[   730,   9.19,   0.12,  10.17,   0.10,  13.05,   0.08,   8.40,   0.13,  7.79e-16,  7.01e-16,  8.57e-16,  nan ],
	[   740,   9.46,   0.12,  10.36,   0.11,  12.92,   0.08,   8.76,   0.13,  8.45e-16,  9.22e-16,  9.99e-16,  nan ],
	[   750,   9.47,   0.12,  10.07,   0.11,  13.42,   0.08,   9.09,   0.12,  9.09e-16,  8.34e-16,  8.34e-16,  nan ],
	[   760,   9.96,   0.12,  10.13,   0.11,  13.33,   0.09,   9.33,   0.12,  8.98e-16,  8.23e-16,  8.98e-16,  nan ],
	[   770,   9.21,   0.13,  10.31,   0.12,  13.64,   0.09,   8.08,   0.15,  8.12e-16,  8.86e-16,  8.12e-16,  nan ],
	[   780,   9.83,   0.12,  10.87,   0.11,  13.66,   0.09,   8.40,   0.14,  9.47e-16,  1.02e-15,  1.02e-15,  nan ],
	[   790,  10.08,   0.12,  11.67,   0.11,  14.36,   0.09,   8.75,   0.14,  8.63e-16,  9.35e-16,  9.35e-16,  nan ],
	[   800,  10.42,   0.12,  11.34,   0.11,  14.73,   0.09,   8.90,   0.14,  1.28e-15,  1.28e-15,  1.14e-15,  nan ],
	[   810,  10.60,   0.12,  11.63,   0.11,  14.77,   0.09,   8.87,   0.15,  1.05e-15,  1.12e-15,  1.12e-15,  nan ],
	[   820,  10.94,   0.12,  11.62,   0.12,  14.94,   0.09,   8.87,   0.15,  1.11e-15,  1.04e-15,  1.11e-15,  nan ],
	[   830,  11.13,   0.12,  11.81,   0.12,  15.15,   0.09,   9.14,   0.15,  9.59e-16,  8.90e-16,  9.59e-16,  nan ],
	[   840,  10.87,   0.13,  12.50,   0.11,  15.35,   0.09,   9.36,   0.15,  8.80e-16,  8.80e-16,  8.80e-16,  nan ],
	[   850,  10.97,   0.13,  12.06,   0.12,  15.25,   0.09,   9.21,   0.16,  9.36e-16,  9.36e-16,  8.69e-16,  nan ],
	[   860,  11.31,   0.13,  12.99,   0.11,  15.26,   0.10,   9.44,   0.16,  1.26e-15,  1.26e-15,  1.19e-15,  nan ],
	[   870,  11.47,   0.13,  10.68,   0.14,  15.81,   0.10,   9.65,   0.16,  1.18e-15,  1.31e-15,  1.05e-15,  nan ],
	[   880,  11.57,   0.13,  13.03,   0.12,  16.14,   0.10,   9.52,   0.16,  8.40e-16,  9.04e-16,  9.04e-16,  nan ],
	[   890,  11.92,   0.13,  12.39,   0.13,  16.34,   0.10,   9.49,   0.17,  9.58e-16,  1.02e-15,  1.21e-15,  nan ],
	[   900,  11.75,   0.14,  13.85,   0.12,  16.55,   0.10,   9.01,   0.18,  1.07e-15,  1.01e-15,  1.01e-15,  nan ],
	[  1000,  13.35,   0.15,  14.60,   0.14,  18.02,   0.11,   9.76,   0.21,  1.08e-15,  1.08e-15,  1.14e-15,  nan ],
	[  1100,  14.60,   0.17,  15.73,   0.15,  12.30,   0.20,   9.93,   0.24,  1.14e-15,  1.19e-15,  1.19e-15,  nan ],
	[  1200,  16.29,   0.18,  18.37,   0.16,  13.46,   0.21,   9.71,   0.30,  1.18e-15,  1.28e-15,  1.28e-15,  nan ],
	[  1300,  17.43,   0.19,  21.66,   0.16,  13.69,   0.25,   9.42,   0.36,  1.27e-15,  1.18e-15,  1.27e-15,  nan ],
	[  1400,  19.13,   0.21,  23.61,   0.17,  15.08,   0.26,  10.22,   0.38,  1.14e-15,  1.06e-15,  1.06e-15,  nan ],
	[  1500,  20.20,   0.22,  24.21,   0.19,  16.03,   0.28,   9.90,   0.45,  1.36e-15,  1.29e-15,  1.29e-15,  nan ],
	[  1600,  21.42,   0.24,  25.49,   0.20,  16.63,   0.31,   9.74,   0.53,  1.35e-15,  1.42e-15,  1.42e-15,  nan ],
	[  1700,  22.50,   0.26,  26.54,   0.22,  17.31,   0.33,  10.61,   0.55,  1.34e-15,  1.40e-15,  1.40e-15,  nan ],
	[  1800,  24.11,   0.27,  30.02,   0.22,  18.26,   0.36,  10.51,   0.62,  1.83e-15,  1.89e-15,  1.71e-15,  nan ],
	[  1900,  25.53,   0.28,  30.48,   0.24,  19.21,   0.38,  11.09,   0.65,  1.62e-15,  1.38e-15,  1.50e-15,  nan ],
	[  2000,  26.33,   0.30,  30.33,   0.26,  20.37,   0.39,  11.35,   0.71,  1.82e-15,  1.82e-15,  1.65e-15,  nan ],
	[  2100,  27.50,   0.32,  32.21,   0.27,  15.62,   0.57,  11.52,   0.77,  1.84e-15,  1.79e-15,  1.62e-15,  nan ],
	[  2200,  29.01,   0.33,  34.11,   0.28,  16.06,   0.60,  11.45,   0.85,  1.76e-15,  1.76e-15,  1.81e-15,  nan ],
	[  2300,  31.05,   0.34,  36.12,   0.29,  16.91,   0.63,  11.75,   0.90,  1.78e-15,  1.73e-15,  1.78e-15,  nan ],
	[  2400,  31.84,   0.36,  36.34,   0.32,  17.65,   0.65,  11.40,   1.01,  1.61e-15,  1.52e-15,  1.56e-15,  nan ],
	[  2500,  32.58,   0.38,  38.74,   0.32,  18.34,   0.68,  11.95,   1.05,  1.91e-15,  1.59e-15,  1.77e-15,  nan ],
	[  2600,  33.06,   0.41,  39.42,   0.34,  18.68,   0.72,  11.35,   1.19,  1.53e-15,  1.66e-15,  1.62e-15,  nan ],
	[  2700,  34.90,   0.42,  42.39,   0.34,  19.68,   0.74,  11.70,   1.25,  1.60e-15,  1.56e-15,  1.60e-15,  nan ],
	[  2800,  35.26,   0.44,  39.02,   0.40,  20.08,   0.78,  11.89,   1.32,  1.79e-15,  1.79e-15,  1.87e-15,  nan ],
	[  2900,  36.83,   0.46,  42.69,   0.39,  20.98,   0.80,  12.11,   1.39,  1.80e-15,  1.80e-15,  1.80e-15,  nan ],
	[  3000,  38.79,   0.46,  44.24,   0.41,  21.61,   0.83,  12.23,   1.47,  1.97e-15,  1.89e-15,  1.97e-15,  nan ],
	[  3100,  39.57,   0.49,  44.93,   0.43,  17.64,   1.09,  12.55,   1.53,  2.13e-15,  2.20e-15,  2.20e-15,  nan ],
	[  3200,  41.81,   0.49,  42.96,   0.48,  18.12,   1.13,  12.32,   1.66,  1.99e-15,  1.99e-15,  2.06e-15,  nan ],
	[  3300,  42.21,   0.52,  47.79,   0.46,  18.70,   1.17,  12.36,   1.76,  2.14e-15,  2.07e-15,  2.07e-15,  nan ],
	[  3400,  42.75,   0.54,  46.82,   0.49,  19.19,   1.20,  11.82,   1.96,  2.34e-15,  2.21e-15,  2.07e-15,  nan ],
	[  3500,  44.48,   0.55,  49.02,   0.50,  19.62,   1.25,  12.61,   1.94,  2.34e-15,  2.47e-15,  2.40e-15,  nan ],
	[  3600,  45.33,   0.57,  48.18,   0.54,  20.02,   1.29,  12.59,   2.06,  2.34e-15,  2.21e-15,  2.34e-15,  nan ],
	[  3700,  45.95,   0.60,  49.07,   0.56,  20.61,   1.33,  12.11,   2.26,  2.52e-15,  2.52e-15,  2.52e-15,  nan ],
	[  3800,  46.75,   0.62,  50.95,   0.57,  21.27,   1.36,  12.79,   2.26,  2.33e-15,  2.45e-15,  2.57e-15,  nan ],
	[  3900,  48.99,   0.62,  51.21,   0.59,  21.76,   1.40,  12.26,   2.48,  2.22e-15,  2.16e-15,  2.22e-15,  nan ],
	[  4000,  48.50,   0.66,  49.61,   0.65,  22.21,   1.44,  12.73,   2.51,  2.56e-15,  2.67e-15,  2.50e-15,  nan ],
	[  4100,  48.65,   0.69,  50.65,   0.66,  19.35,   1.74,  12.59,   2.67,  2.88e-15,  2.83e-15,  2.77e-15,  nan ],
	[  4200,  49.70,   0.71,  52.90,   0.67,  19.05,   1.85,  12.52,   2.82,  2.76e-15,  2.65e-15,  2.92e-15,  nan ],
	[  4300,  50.32,   0.74,  52.70,   0.70,  19.62,   1.88,  12.76,   2.90,  2.27e-15,  2.27e-15,  2.43e-15,  nan ],
	[  4400,  52.27,   0.74,  52.98,   0.73,  19.88,   1.95,  12.85,   3.01,  2.38e-15,  2.43e-15,  2.58e-15,  nan ],
	[  4500,  52.88,   0.77,  55.18,   0.73,  20.39,   1.99,  12.84,   3.16,  2.83e-15,  3.03e-15,  2.78e-15,  nan ],
	[  4600,  54.63,   0.77,  55.26,   0.77,  20.80,   2.04,  12.82,   3.30,  2.52e-15,  2.52e-15,  2.77e-15,  nan ],
	[  4700,  55.24,   0.80,  54.69,   0.81,  21.24,   2.08,  12.69,   3.48,  2.52e-15,  2.66e-15,  2.71e-15,  nan ],
	[  4800,  54.87,   0.84,  53.79,   0.86,  21.62,   2.13,  12.95,   3.56,  2.51e-15,  2.42e-15,  2.46e-15,  nan ],
	[  4900,  55.53,   0.86,  56.64,   0.85,  22.02,   2.18,  12.76,   3.76,  2.51e-15,  2.55e-15,  2.64e-15,  nan ],
	[  5000,  56.37,   0.89,  56.95,   0.88,  22.48,   2.22,  12.75,   3.92,  2.46e-15,  2.32e-15,  2.64e-15,  nan ],
	[  5100,  58.46,   0.89,  57.05,   0.91,  22.78,   2.28,  12.70,   4.10,  2.41e-15,  2.36e-15,  2.41e-15,  nan ],
	[  5200,  57.67,   0.94,  57.92,   0.93,  19.94,   2.71,  12.81,   4.22,  2.62e-15,  2.54e-15,  2.62e-15,  nan ],
	[  5300,  58.05,   0.97,  59.53,   0.94,  20.26,   2.77,  13.15,   4.27,  2.57e-15,  2.66e-15,  2.62e-15,  nan ],
	[  5400,  59.53,   0.98,  60.26,   0.97,  20.57,   2.84,  12.97,   4.50,  2.69e-15,  2.44e-15,  2.53e-15,  nan ],
	[  5500,  57.56,   1.05,  60.46,   1.00,  20.95,   2.89,  12.99,   4.66,  2.40e-15,  2.40e-15,  2.40e-15,  nan ],
	[  5600,  59.85,   1.05,  55.46,   1.13,  21.25,   2.95,  13.21,   4.75,  2.52e-15,  2.68e-15,  2.60e-15,  nan ],
	[  5700,  60.81,   1.07,  61.42,   1.06,  21.50,   3.02,  13.28,   4.89,  2.63e-15,  2.63e-15,  2.63e-15,  nan ],
	[  5800,  61.62,   1.09,  60.57,   1.11,  21.84,   3.08,  13.21,   5.09,  3.14e-15,  2.98e-15,  3.06e-15,  nan ],
	[  5900,  62.11,   1.12,  60.34,   1.15,  22.25,   3.13,  13.21,   5.27,  3.08e-15,  3.01e-15,  3.01e-15,  nan ],
	[  6000,  62.73,   1.15,  60.36,   1.19,  22.62,   3.18,  13.42,   5.37,  3.41e-15,  3.26e-15,  3.41e-15,  nan ],
	[  6100,  63.24,   1.18,  62.70,   1.19,  22.88,   3.25,  13.60,   5.47,  3.28e-15,  2.83e-15,  3.06e-15,  nan ],
	[  6200,  64.35,   1.19,  62.83,   1.22,  20.34,   3.78,  13.30,   5.78,  3.01e-15,  3.08e-15,  2.86e-15,  nan ],
	[  6300,  65.18,   1.22,  61.21,   1.30,  20.71,   3.83,  13.54,   5.86,  3.68e-15,  3.75e-15,  3.46e-15,  nan ],
	[  6400,  65.59,   1.25,  59.16,   1.38,  20.89,   3.92,  13.50,   6.07,  3.98e-15,  3.77e-15,  4.05e-15,  nan ],
	[  6500,  65.41,   1.29,  62.61,   1.35,  21.09,   4.01,  13.53,   6.25,  3.08e-15,  3.29e-15,  3.50e-15,  nan ],
	[  6600,  66.11,   1.32,  62.96,   1.38,  21.55,   4.04,  13.66,   6.38,  3.72e-15,  3.58e-15,  3.58e-15,  nan ],
	[  6700,  68.50,   1.31,  62.19,   1.44,  21.67,   4.14,  13.41,   6.70,  4.00e-15,  4.14e-15,  3.87e-15,  nan ],
	[  6800,  67.12,   1.38,  62.37,   1.48,  22.04,   4.20,  13.66,   6.77,  3.81e-15,  3.68e-15,  3.61e-15,  nan ],
	[  6900,  68.81,   1.38,  63.45,   1.50,  22.18,   4.29,  13.62,   6.99,  2.97e-15,  3.10e-15,  3.23e-15,  nan ],
	[  7000,  68.40,   1.43,  62.55,   1.57,  22.31,   4.39,  13.62,   7.20,  3.51e-15,  4.03e-15,  3.83e-15,  nan ],
	[  7100,  69.54,   1.45,  62.54,   1.61,  22.80,   4.42,  13.64,   7.39,  3.20e-15,  3.27e-15,  3.07e-15,  nan ],
	[  7200,  69.41,   1.49,  60.26,   1.72,  20.71,   5.01,  13.62,   7.61,  3.03e-15,  3.28e-15,  3.16e-15,  nan ],
	[  7300,  70.08,   1.52,  63.34,   1.68,  20.68,   5.15,  13.71,   7.77,  3.55e-15,  3.61e-15,  3.43e-15,  nan ],
	[  7400,  71.68,   1.53,  62.92,   1.74,  20.87,   5.25,  13.64,   8.03,  3.38e-15,  3.81e-15,  3.56e-15,  nan ],
	[  7500,  71.12,   1.58,  64.26,   1.75,  21.21,   5.31,  13.76,   8.18,  3.70e-15,  3.58e-15,  3.76e-15,  nan ],
	[  7600,  72.80,   1.59,  63.72,   1.81,  21.46,   5.38,  14.00,   8.26,  3.47e-15,  3.47e-15,  3.29e-15,  nan ],
	[  7700,  72.09,   1.65,  65.16,   1.82,  21.67,   5.47,  13.79,   8.60,  3.72e-15,  3.72e-15,  3.54e-15,  nan ],
	[  7800,  72.82,   1.67,  64.01,   1.90,  22.18,   5.49,  13.49,   9.02,  3.26e-15,  3.44e-15,  3.61e-15,  nan ],
	[  7900,  71.86,   1.74,  63.66,   1.96,  22.46,   5.56,  13.73,   9.09,  3.45e-15,  3.63e-15,  3.51e-15,  nan ],
	[  8000,  71.55,   1.79,  60.71,   2.11,  22.27,   5.75,  13.72,   9.33,  3.30e-15,  3.30e-15,  3.41e-15,  nan ],
	[  8100,  72.31,   1.81,  66.29,   1.98,  22.92,   5.73,  13.65,   9.62,  3.82e-15,  3.87e-15,  3.65e-15,  nan ],
	[  8200,  70.82,   1.90,  66.22,   2.03,  21.31,   6.31,  13.79,   9.76,  3.49e-15,  3.44e-15,  3.49e-15,  nan ],
	[  8300,  71.92,   1.92,  66.03,   2.09,  21.07,   6.54,  13.53,  10.18,  3.45e-15,  3.45e-15,  3.62e-15,  nan ],
	[  8400,  69.83,   2.02,  65.13,   2.17,  21.03,   6.71,  13.98,  10.10,  3.63e-15,  3.57e-15,  3.46e-15,  nan ],
	[  8500,  71.22,   2.03,  67.03,   2.16,  21.58,   6.70,  13.69,  10.55,  4.01e-15,  4.01e-15,  3.91e-15,  nan ],
	[  8600,  70.28,   2.10,  66.43,   2.23,  21.30,   6.95,  13.80,  10.72,  3.75e-15,  3.44e-15,  3.49e-15,  nan ],
	[  8700,  70.97,   2.13,  66.90,   2.26,  21.91,   6.91,  13.83,  10.95,  3.35e-15,  3.45e-15,  3.66e-15,  nan ],
	[  8800,  69.03,   2.24,  64.27,   2.41,  21.63,   7.16,  14.02,  11.05,  4.19e-15,  4.29e-15,  4.55e-15,  nan ],
	[  8900,  69.58,   2.28,  67.62,   2.34,  21.89,   7.24,  14.08,  11.26,  3.83e-15,  3.68e-15,  3.93e-15,  nan ],
	[  9000,  69.48,   2.33,  66.65,   2.43,  22.53,   7.19,  14.07,  11.52,  3.33e-15,  3.44e-15,  3.39e-15,  nan ],
	[ 10000,  69.04,   2.90,  68.06,   2.94,  22.26,   8.99,  14.24,  14.04,  3.87e-15,  3.68e-15,  3.82e-15,  nan ],
	[ 12000,  69.45,   4.15,  65.73,   4.38,  21.81,  13.20,  14.40,  20.00,  5.15e-15,  5.08e-15,  5.15e-15,  nan ],
	[ 14000,  73.33,   5.35,  71.39,   5.49,  22.58,  17.36,  14.79,  26.50,  5.07e-15,  5.26e-15,  4.94e-15,  nan ],
	[ 16000,  74.65,   6.86,  67.95,   7.54,  21.96,  23.31,  14.22,  36.00,  5.12e-15,  4.89e-15,  5.06e-15,  nan ],
	[ 18000,  72.16,   8.98,  73.26,   8.85,  21.83,  29.68,  14.77,  43.87,  6.11e-15,  6.27e-15,  6.72e-15,  nan ],
	[ 20000,  72.64,  11.01,  69.95,  11.44,  20.89,  38.30,  15.25,  52.47,  5.96e-15,  5.68e-15,  5.78e-15,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/log.txt
# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/setup.txt
# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/sgeqrf.txt
# numactl --interleave=all ../testing/testing_sgeqrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeqrf = array([
	[    10,     10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.02,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.06,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.25,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.42,  0.00,  nan ],
	[    60,     60,  nan,  nan,     0.69,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.88,  0.00,  nan ],
	[    80,     80,  nan,  nan,     0.84,  0.00,  nan ],
	[    90,     90,  nan,  nan,     0.99,  0.00,  nan ],
	[   100,    100,  nan,  nan,     0.97,  0.00,  nan ],
	[   200,    200,  nan,  nan,     4.62,  0.00,  nan ],
	[   300,    300,  nan,  nan,    10.57,  0.00,  nan ],
	[   400,    400,  nan,  nan,    19.32,  0.00,  nan ],
	[   500,    500,  nan,  nan,    29.73,  0.01,  nan ],
	[   600,    600,  nan,  nan,    41.45,  0.01,  nan ],
	[   700,    700,  nan,  nan,    55.58,  0.01,  nan ],
	[   800,    800,  nan,  nan,    67.12,  0.01,  nan ],
	[   900,    900,  nan,  nan,    91.96,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   119.32,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   330.72,  0.03,  nan ],
	[  3000,   3000,  nan,  nan,   570.95,  0.06,  nan ],
	[  4000,   4000,  nan,  nan,   725.82,  0.12,  nan ],
	[  5000,   5000,  nan,  nan,   897.94,  0.19,  nan ],
	[  6000,   6000,  nan,  nan,  1049.26,  0.27,  nan ],
	[  7000,   7000,  nan,  nan,  1111.54,  0.41,  nan ],
	[  8000,   8000,  nan,  nan,  1373.64,  0.50,  nan ],
	[  9000,   9000,  nan,  nan,  1485.26,  0.65,  nan ],
	[ 10000,  10000,  nan,  nan,  1581.15,  0.84,  nan ],
	[ 12000,  12000,  nan,  nan,  1719.35,  1.34,  nan ],
	[ 14000,  14000,  nan,  nan,  1792.15,  2.04,  nan ],
	[ 16000,  16000,  nan,  nan,  1886.77,  2.89,  nan ],
	[ 18000,  18000,  nan,  nan,  1909.49,  4.07,  nan ],
	[ 20000,  20000,  nan,  nan,  2045.64,  5.21,  nan ],
])

# numactl --interleave=all ../testing/testing_sgeqrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.03,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.07,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.13,  0.00,  nan ],
	[    60,     60,  nan,  nan,     0.21,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.33,  0.00,  nan ],
	[    80,     80,  nan,  nan,     0.49,  0.00,  nan ],
	[    90,     90,  nan,  nan,     0.65,  0.00,  nan ],
	[   100,    100,  nan,  nan,     0.72,  0.00,  nan ],
	[   200,    200,  nan,  nan,     6.29,  0.00,  nan ],
	[   300,    300,  nan,  nan,    13.58,  0.00,  nan ],
	[   400,    400,  nan,  nan,    23.77,  0.00,  nan ],
	[   500,    500,  nan,  nan,    27.62,  0.01,  nan ],
	[   600,    600,  nan,  nan,    40.84,  0.01,  nan ],
	[   700,    700,  nan,  nan,    51.96,  0.01,  nan ],
	[   800,    800,  nan,  nan,    69.73,  0.01,  nan ],
	[   900,    900,  nan,  nan,    82.84,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    99.61,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   296.04,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,   489.48,  0.07,  nan ],
	[  4000,   4000,  nan,  nan,   705.17,  0.12,  nan ],
	[  5000,   5000,  nan,  nan,   888.12,  0.19,  nan ],
	[  6000,   6000,  nan,  nan,  1021.01,  0.28,  nan ],
	[  7000,   7000,  nan,  nan,  1096.15,  0.42,  nan ],
	[  8000,   8000,  nan,  nan,  1309.73,  0.52,  nan ],
	[  9000,   9000,  nan,  nan,  1423.20,  0.68,  nan ],
	[ 10000,  10000,  nan,  nan,  1526.76,  0.87,  nan ],
	[ 12000,  12000,  nan,  nan,  1679.62,  1.37,  nan ],
	[ 14000,  14000,  nan,  nan,  1768.33,  2.07,  nan ],
	[ 16000,  16000,  nan,  nan,  1872.85,  2.92,  nan ],
	[ 18000,  18000,  nan,  nan,  1911.42,  4.07,  nan ],
	[ 20000,  20000,  nan,  nan,  1996.32,  5.34,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/sgesvd.txt
# numactl --interleave=all ../testing/testing_sgesvd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
sgesvd_UN = array([
	[ nan,      10,      10,  nan,   0.00,  nan ],
	[ nan,      20,      20,  nan,   0.00,  nan ],
	[ nan,      30,      30,  nan,   0.00,  nan ],
	[ nan,      40,      40,  nan,   0.00,  nan ],
	[ nan,      50,      50,  nan,   0.00,  nan ],
	[ nan,      60,      60,  nan,   0.00,  nan ],
	[ nan,      70,      70,  nan,   0.00,  nan ],
	[ nan,      80,      80,  nan,   0.00,  nan ],
	[ nan,      90,      90,  nan,   0.00,  nan ],
	[ nan,     100,     100,  nan,   0.00,  nan ],
	[ nan,     200,     200,  nan,   0.01,  nan ],
	[ nan,     300,     300,  nan,   0.03,  nan ],
	[ nan,     400,     400,  nan,   0.04,  nan ],
	[ nan,     500,     500,  nan,   0.06,  nan ],
	[ nan,     600,     600,  nan,   0.08,  nan ],
	[ nan,     700,     700,  nan,   0.11,  nan ],
	[ nan,     800,     800,  nan,   0.14,  nan ],
	[ nan,     900,     900,  nan,   0.19,  nan ],
	[ nan,    1000,    1000,  nan,   0.22,  nan ],
	[ nan,    2000,    2000,  nan,   0.74,  nan ],
	[ nan,    3000,    3000,  nan,   1.75,  nan ],
	[ nan,    4000,    4000,  nan,   3.30,  nan ],
	[ nan,    5000,    5000,  nan,   5.96,  nan ],
	[ nan,    6000,    6000,  nan,   9.46,  nan ],
	[ nan,    7000,    7000,  nan,  14.05,  nan ],
	[ nan,    8000,    8000,  nan,  19.90,  nan ],
	[ nan,    9000,    9000,  nan,  27.30,  nan ],
	[ nan,   10000,   10000,  nan,  36.58,  nan ],
	[ nan,     300,     100,  nan,   0.00,  nan ],
	[ nan,     600,     200,  nan,   0.02,  nan ],
	[ nan,     900,     300,  nan,   0.03,  nan ],
	[ nan,    1200,     400,  nan,   0.05,  nan ],
	[ nan,    1500,     500,  nan,   0.07,  nan ],
	[ nan,    1800,     600,  nan,   0.10,  nan ],
	[ nan,    2100,     700,  nan,   0.13,  nan ],
	[ nan,    2400,     800,  nan,   0.17,  nan ],
	[ nan,    2700,     900,  nan,   0.22,  nan ],
	[ nan,    3000,    1000,  nan,   0.26,  nan ],
	[ nan,    6000,    2000,  nan,   1.06,  nan ],
	[ nan,    9000,    3000,  nan,   2.61,  nan ],
	[ nan,   12000,    4000,  nan,   5.07,  nan ],
	[ nan,   15000,    5000,  nan,   8.24,  nan ],
	[ nan,   18000,    6000,  nan,  13.18,  nan ],
	[ nan,   21000,    7000,  nan,  19.68,  nan ],
	[ nan,   24000,    8000,  nan,  28.20,  nan ],
	[ nan,   27000,    9000,  nan,  38.52,  nan ],
	[ nan,     100,     300,  nan,   0.00,  nan ],
	[ nan,     200,     600,  nan,   0.02,  nan ],
	[ nan,     300,     900,  nan,   0.04,  nan ],
	[ nan,     400,    1200,  nan,   0.06,  nan ],
	[ nan,     500,    1500,  nan,   0.08,  nan ],
	[ nan,     600,    1800,  nan,   0.11,  nan ],
	[ nan,     700,    2100,  nan,   0.15,  nan ],
	[ nan,     800,    2400,  nan,   0.18,  nan ],
	[ nan,     900,    2700,  nan,   0.23,  nan ],
	[ nan,    1000,    3000,  nan,   0.28,  nan ],
	[ nan,    2000,    6000,  nan,   1.06,  nan ],
	[ nan,    3000,    9000,  nan,   2.64,  nan ],
	[ nan,    4000,   12000,  nan,   4.99,  nan ],
	[ nan,    5000,   15000,  nan,   9.06,  nan ],
	[ nan,    6000,   18000,  nan,  14.39,  nan ],
	[ nan,    7000,   21000,  nan,  21.74,  nan ],
	[ nan,    8000,   24000,  nan,  30.43,  nan ],
	[ nan,    9000,   27000,  nan,  41.90,  nan ],
	[ nan,   10000,     100,  nan,   0.01,  nan ],
	[ nan,   20000,     200,  nan,   0.04,  nan ],
	[ nan,   30000,     300,  nan,   0.09,  nan ],
	[ nan,   40000,     400,  nan,   0.21,  nan ],
	[ nan,   50000,     500,  nan,   0.33,  nan ],
	[ nan,   60000,     600,  nan,   0.49,  nan ],
	[ nan,   70000,     700,  nan,   0.69,  nan ],
	[ nan,   80000,     800,  nan,   0.94,  nan ],
	[ nan,   90000,     900,  nan,   1.32,  nan ],
	[ nan,  100000,    1000,  nan,   1.65,  nan ],
	[ nan,  200000,    2000,  nan,   9.03,  nan ],
	[ nan,     100,   10000,  nan,   0.01,  nan ],
	[ nan,     200,   20000,  nan,   0.05,  nan ],
	[ nan,     300,   30000,  nan,   0.13,  nan ],
	[ nan,     400,   40000,  nan,   0.25,  nan ],
	[ nan,     500,   50000,  nan,   0.45,  nan ],
	[ nan,     600,   60000,  nan,   0.68,  nan ],
	[ nan,     700,   70000,  nan,   1.06,  nan ],
	[ nan,     800,   80000,  nan,   1.29,  nan ],
	[ nan,     900,   90000,  nan,   1.60,  nan ],
	[ nan,    1000,  100000,  nan,   2.00,  nan ],
	[ nan,    2000,  200000,  nan,  12.29,  nan ],
])

# numactl --interleave=all ../testing/testing_sgesvd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
sgesvd_US = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.01,  nan ],
	[ nan,      70,      70,  nan,    0.01,  nan ],
	[ nan,      80,      80,  nan,    0.01,  nan ],
	[ nan,      90,      90,  nan,    0.02,  nan ],
	[ nan,     100,     100,  nan,    0.02,  nan ],
	[ nan,     200,     200,  nan,    0.08,  nan ],
	[ nan,     300,     300,  nan,    0.05,  nan ],
	[ nan,     400,     400,  nan,    0.08,  nan ],
	[ nan,     500,     500,  nan,    0.13,  nan ],
	[ nan,     600,     600,  nan,    0.18,  nan ],
	[ nan,     700,     700,  nan,    0.23,  nan ],
	[ nan,     800,     800,  nan,    0.31,  nan ],
	[ nan,     900,     900,  nan,    0.41,  nan ],
	[ nan,    1000,    1000,  nan,    0.49,  nan ],
	[ nan,    2000,    2000,  nan,    2.46,  nan ],
	[ nan,    3000,    3000,  nan,    7.44,  nan ],
	[ nan,    4000,    4000,  nan,   15.79,  nan ],
	[ nan,    5000,    5000,  nan,   29.23,  nan ],
	[ nan,    6000,    6000,  nan,   52.14,  nan ],
	[ nan,    7000,    7000,  nan,   64.01,  nan ],
	[ nan,    8000,    8000,  nan,   91.31,  nan ],
	[ nan,    9000,    9000,  nan,  128.34,  nan ],
	[ nan,   10000,   10000,  nan,  179.45,  nan ],
	[ nan,     300,     100,  nan,    0.03,  nan ],
	[ nan,     600,     200,  nan,    0.08,  nan ],
	[ nan,     900,     300,  nan,    0.06,  nan ],
	[ nan,    1200,     400,  nan,    0.10,  nan ],
	[ nan,    1500,     500,  nan,    0.17,  nan ],
	[ nan,    1800,     600,  nan,    0.25,  nan ],
	[ nan,    2100,     700,  nan,    0.34,  nan ],
	[ nan,    2400,     800,  nan,    0.40,  nan ],
	[ nan,    2700,     900,  nan,    0.54,  nan ],
	[ nan,    3000,    1000,  nan,    0.74,  nan ],
	[ nan,    6000,    2000,  nan,    3.26,  nan ],
	[ nan,    9000,    3000,  nan,    8.68,  nan ],
	[ nan,   12000,    4000,  nan,   17.44,  nan ],
	[ nan,   15000,    5000,  nan,   31.24,  nan ],
	[ nan,   18000,    6000,  nan,   53.73,  nan ],
	[ nan,   21000,    7000,  nan,   82.38,  nan ],
	[ nan,   24000,    8000,  nan,  110.54,  nan ],
	[ nan,   27000,    9000,  nan,  165.19,  nan ],
	[ nan,     100,     300,  nan,    0.02,  nan ],
	[ nan,     200,     600,  nan,    0.07,  nan ],
	[ nan,     300,     900,  nan,    0.08,  nan ],
	[ nan,     400,    1200,  nan,    0.13,  nan ],
	[ nan,     500,    1500,  nan,    0.20,  nan ],
	[ nan,     600,    1800,  nan,    0.27,  nan ],
	[ nan,     700,    2100,  nan,    0.39,  nan ],
	[ nan,     800,    2400,  nan,    0.50,  nan ],
	[ nan,     900,    2700,  nan,    0.63,  nan ],
	[ nan,    1000,    3000,  nan,    0.78,  nan ],
	[ nan,    2000,    6000,  nan,    3.81,  nan ],
	[ nan,    3000,    9000,  nan,    9.76,  nan ],
	[ nan,    4000,   12000,  nan,   20.42,  nan ],
	[ nan,    5000,   15000,  nan,   37.34,  nan ],
	[ nan,    6000,   18000,  nan,   62.36,  nan ],
	[ nan,    7000,   21000,  nan,   97.75,  nan ],
	[ nan,    8000,   24000,  nan,  144.67,  nan ],
	[ nan,    9000,   27000,  nan,  202.69,  nan ],
	[ nan,   10000,     100,  nan,    0.05,  nan ],
	[ nan,   20000,     200,  nan,    0.19,  nan ],
	[ nan,   30000,     300,  nan,    0.29,  nan ],
	[ nan,   40000,     400,  nan,    0.58,  nan ],
	[ nan,   50000,     500,  nan,    1.03,  nan ],
	[ nan,   60000,     600,  nan,    1.59,  nan ],
	[ nan,   70000,     700,  nan,    2.15,  nan ],
	[ nan,   80000,     800,  nan,    3.09,  nan ],
	[ nan,   90000,     900,  nan,    4.30,  nan ],
	[ nan,  100000,    1000,  nan,    5.67,  nan ],
	[ nan,  200000,    2000,  nan,   38.28,  nan ],
	[ nan,     100,   10000,  nan,    0.07,  nan ],
	[ nan,     200,   20000,  nan,    0.35,  nan ],
	[ nan,     300,   30000,  nan,    0.56,  nan ],
	[ nan,     400,   40000,  nan,    0.89,  nan ],
	[ nan,     500,   50000,  nan,    2.49,  nan ],
	[ nan,     600,   60000,  nan,    3.38,  nan ],
	[ nan,     700,   70000,  nan,    4.27,  nan ],
	[ nan,     800,   80000,  nan,    5.83,  nan ],
	[ nan,     900,   90000,  nan,    7.41,  nan ],
	[ nan,    1000,  100000,  nan,   15.30,  nan ],
	[ nan,    2000,  200000,  nan,  107.41,  nan ],
])

# numactl --interleave=all ../testing/testing_sgesdd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
sgesdd_UN = array([
	[ nan,      10,      10,  nan,   0.00,  nan ],
	[ nan,      20,      20,  nan,   0.00,  nan ],
	[ nan,      30,      30,  nan,   0.00,  nan ],
	[ nan,      40,      40,  nan,   0.00,  nan ],
	[ nan,      50,      50,  nan,   0.00,  nan ],
	[ nan,      60,      60,  nan,   0.00,  nan ],
	[ nan,      70,      70,  nan,   0.00,  nan ],
	[ nan,      80,      80,  nan,   0.00,  nan ],
	[ nan,      90,      90,  nan,   0.00,  nan ],
	[ nan,     100,     100,  nan,   0.00,  nan ],
	[ nan,     200,     200,  nan,   0.01,  nan ],
	[ nan,     300,     300,  nan,   0.03,  nan ],
	[ nan,     400,     400,  nan,   0.04,  nan ],
	[ nan,     500,     500,  nan,   0.06,  nan ],
	[ nan,     600,     600,  nan,   0.08,  nan ],
	[ nan,     700,     700,  nan,   0.10,  nan ],
	[ nan,     800,     800,  nan,   0.13,  nan ],
	[ nan,     900,     900,  nan,   0.17,  nan ],
	[ nan,    1000,    1000,  nan,   0.20,  nan ],
	[ nan,    2000,    2000,  nan,   0.75,  nan ],
	[ nan,    3000,    3000,  nan,   1.75,  nan ],
	[ nan,    4000,    4000,  nan,   3.32,  nan ],
	[ nan,    5000,    5000,  nan,   5.98,  nan ],
	[ nan,    6000,    6000,  nan,   9.49,  nan ],
	[ nan,    7000,    7000,  nan,  14.10,  nan ],
	[ nan,    8000,    8000,  nan,  19.96,  nan ],
	[ nan,    9000,    9000,  nan,  27.30,  nan ],
	[ nan,   10000,   10000,  nan,  36.36,  nan ],
	[ nan,     300,     100,  nan,   0.00,  nan ],
	[ nan,     600,     200,  nan,   0.01,  nan ],
	[ nan,     900,     300,  nan,   0.03,  nan ],
	[ nan,    1200,     400,  nan,   0.05,  nan ],
	[ nan,    1500,     500,  nan,   0.07,  nan ],
	[ nan,    1800,     600,  nan,   0.09,  nan ],
	[ nan,    2100,     700,  nan,   0.13,  nan ],
	[ nan,    2400,     800,  nan,   0.16,  nan ],
	[ nan,    2700,     900,  nan,   0.21,  nan ],
	[ nan,    3000,    1000,  nan,   0.24,  nan ],
	[ nan,    6000,    2000,  nan,   1.02,  nan ],
	[ nan,    9000,    3000,  nan,   2.58,  nan ],
	[ nan,   12000,    4000,  nan,   5.11,  nan ],
	[ nan,   15000,    5000,  nan,   9.16,  nan ],
	[ nan,   18000,    6000,  nan,  13.59,  nan ],
	[ nan,   21000,    7000,  nan,  21.94,  nan ],
	[ nan,   24000,    8000,  nan,  31.62,  nan ],
	[ nan,   27000,    9000,  nan,  43.79,  nan ],
	[ nan,     100,     300,  nan,   0.00,  nan ],
	[ nan,     200,     600,  nan,   0.02,  nan ],
	[ nan,     300,     900,  nan,   0.04,  nan ],
	[ nan,     400,    1200,  nan,   0.06,  nan ],
	[ nan,     500,    1500,  nan,   0.09,  nan ],
	[ nan,     600,    1800,  nan,   0.12,  nan ],
	[ nan,     700,    2100,  nan,   0.16,  nan ],
	[ nan,     800,    2400,  nan,   0.19,  nan ],
	[ nan,     900,    2700,  nan,   0.25,  nan ],
	[ nan,    1000,    3000,  nan,   0.30,  nan ],
	[ nan,    2000,    6000,  nan,   1.21,  nan ],
	[ nan,    3000,    9000,  nan,   3.10,  nan ],
	[ nan,    4000,   12000,  nan,   5.95,  nan ],
	[ nan,    5000,   15000,  nan,  10.80,  nan ],
	[ nan,    6000,   18000,  nan,  17.28,  nan ],
	[ nan,    7000,   21000,  nan,  26.20,  nan ],
	[ nan,    8000,   24000,  nan,  35.64,  nan ],
	[ nan,    9000,   27000,  nan,  49.67,  nan ],
	[ nan,   10000,     100,  nan,   0.01,  nan ],
	[ nan,   20000,     200,  nan,   0.04,  nan ],
	[ nan,   30000,     300,  nan,   0.10,  nan ],
	[ nan,   40000,     400,  nan,   0.21,  nan ],
	[ nan,   50000,     500,  nan,   0.33,  nan ],
	[ nan,   60000,     600,  nan,   0.48,  nan ],
	[ nan,   70000,     700,  nan,   0.67,  nan ],
	[ nan,   80000,     800,  nan,   0.92,  nan ],
	[ nan,   90000,     900,  nan,   1.29,  nan ],
	[ nan,  100000,    1000,  nan,   1.61,  nan ],
	[ nan,  200000,    2000,  nan,  10.96,  nan ],
	[ nan,     100,   10000,  nan,   0.01,  nan ],
	[ nan,     200,   20000,  nan,   0.06,  nan ],
	[ nan,     300,   30000,  nan,   0.17,  nan ],
	[ nan,     400,   40000,  nan,   0.33,  nan ],
	[ nan,     500,   50000,  nan,   0.61,  nan ],
	[ nan,     600,   60000,  nan,   0.93,  nan ],
	[ nan,     700,   70000,  nan,   1.46,  nan ],
	[ nan,     800,   80000,  nan,   1.75,  nan ],
	[ nan,     900,   90000,  nan,   2.36,  nan ],
	[ nan,    1000,  100000,  nan,   2.97,  nan ],
	[ nan,    2000,  200000,  nan,  18.77,  nan ],
])

# numactl --interleave=all ../testing/testing_sgesdd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
sgesdd_US = array([
	[ nan,      10,      10,  nan,   0.00,  nan ],
	[ nan,      20,      20,  nan,   0.00,  nan ],
	[ nan,      30,      30,  nan,   0.00,  nan ],
	[ nan,      40,      40,  nan,   0.00,  nan ],
	[ nan,      50,      50,  nan,   0.00,  nan ],
	[ nan,      60,      60,  nan,   0.00,  nan ],
	[ nan,      70,      70,  nan,   0.00,  nan ],
	[ nan,      80,      80,  nan,   0.00,  nan ],
	[ nan,      90,      90,  nan,   0.00,  nan ],
	[ nan,     100,     100,  nan,   0.00,  nan ],
	[ nan,     200,     200,  nan,   0.02,  nan ],
	[ nan,     300,     300,  nan,   0.04,  nan ],
	[ nan,     400,     400,  nan,   0.06,  nan ],
	[ nan,     500,     500,  nan,   0.09,  nan ],
	[ nan,     600,     600,  nan,   0.12,  nan ],
	[ nan,     700,     700,  nan,   0.16,  nan ],
	[ nan,     800,     800,  nan,   0.21,  nan ],
	[ nan,     900,     900,  nan,   0.27,  nan ],
	[ nan,    1000,    1000,  nan,   0.34,  nan ],
	[ nan,    2000,    2000,  nan,   1.25,  nan ],
	[ nan,    3000,    3000,  nan,   2.95,  nan ],
	[ nan,    4000,    4000,  nan,   5.38,  nan ],
	[ nan,    5000,    5000,  nan,   9.73,  nan ],
	[ nan,    6000,    6000,  nan,  14.35,  nan ],
	[ nan,    7000,    7000,  nan,  20.93,  nan ],
	[ nan,    8000,    8000,  nan,  28.99,  nan ],
	[ nan,    9000,    9000,  nan,  38.69,  nan ],
	[ nan,   10000,   10000,  nan,  50.61,  nan ],
	[ nan,     300,     100,  nan,   0.01,  nan ],
	[ nan,     600,     200,  nan,   0.02,  nan ],
	[ nan,     900,     300,  nan,   0.04,  nan ],
	[ nan,    1200,     400,  nan,   0.07,  nan ],
	[ nan,    1500,     500,  nan,   0.10,  nan ],
	[ nan,    1800,     600,  nan,   0.14,  nan ],
	[ nan,    2100,     700,  nan,   0.20,  nan ],
	[ nan,    2400,     800,  nan,   0.25,  nan ],
	[ nan,    2700,     900,  nan,   0.32,  nan ],
	[ nan,    3000,    1000,  nan,   0.40,  nan ],
	[ nan,    6000,    2000,  nan,   1.73,  nan ],
	[ nan,    9000,    3000,  nan,   4.16,  nan ],
	[ nan,   12000,    4000,  nan,   8.09,  nan ],
	[ nan,   15000,    5000,  nan,  14.18,  nan ],
	[ nan,   18000,    6000,  nan,  23.02,  nan ],
	[ nan,   21000,    7000,  nan,  33.96,  nan ],
	[ nan,   24000,    8000,  nan,  47.74,  nan ],
	[ nan,   27000,    9000,  nan,  64.54,  nan ],
	[ nan,     100,     300,  nan,   0.01,  nan ],
	[ nan,     200,     600,  nan,   0.03,  nan ],
	[ nan,     300,     900,  nan,   0.05,  nan ],
	[ nan,     400,    1200,  nan,   0.08,  nan ],
	[ nan,     500,    1500,  nan,   0.12,  nan ],
	[ nan,     600,    1800,  nan,   0.17,  nan ],
	[ nan,     700,    2100,  nan,   0.23,  nan ],
	[ nan,     800,    2400,  nan,   0.28,  nan ],
	[ nan,     900,    2700,  nan,   0.36,  nan ],
	[ nan,    1000,    3000,  nan,   0.46,  nan ],
	[ nan,    2000,    6000,  nan,   1.76,  nan ],
	[ nan,    3000,    9000,  nan,   4.37,  nan ],
	[ nan,    4000,   12000,  nan,   8.32,  nan ],
	[ nan,    5000,   15000,  nan,  14.78,  nan ],
	[ nan,    6000,   18000,  nan,  23.99,  nan ],
	[ nan,    7000,   21000,  nan,  35.67,  nan ],
	[ nan,    8000,   24000,  nan,  49.53,  nan ],
	[ nan,    9000,   27000,  nan,  67.04,  nan ],
	[ nan,   10000,     100,  nan,   0.02,  nan ],
	[ nan,   20000,     200,  nan,   0.10,  nan ],
	[ nan,   30000,     300,  nan,   0.18,  nan ],
	[ nan,   40000,     400,  nan,   0.35,  nan ],
	[ nan,   50000,     500,  nan,   0.75,  nan ],
	[ nan,   60000,     600,  nan,   0.98,  nan ],
	[ nan,   70000,     700,  nan,   1.28,  nan ],
	[ nan,   80000,     800,  nan,   1.61,  nan ],
	[ nan,   90000,     900,  nan,   2.16,  nan ],
	[ nan,  100000,    1000,  nan,   3.45,  nan ],
	[ nan,  200000,    2000,  nan,  17.92,  nan ],
	[ nan,     100,   10000,  nan,   0.04,  nan ],
	[ nan,     200,   20000,  nan,   0.18,  nan ],
	[ nan,     300,   30000,  nan,   0.37,  nan ],
	[ nan,     400,   40000,  nan,   0.54,  nan ],
	[ nan,     500,   50000,  nan,   1.84,  nan ],
	[ nan,     600,   60000,  nan,   2.13,  nan ],
	[ nan,     700,   70000,  nan,   2.53,  nan ],
	[ nan,     800,   80000,  nan,   2.65,  nan ],
	[ nan,     900,   90000,  nan,   3.06,  nan ],
	[ nan,    1000,  100000,  nan,   6.52,  nan ],
	[ nan,    2000,  200000,  nan,  26.37,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/sgetrf.txt
# numactl --interleave=all ../testing/testing_sgetrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgetrf = array([
	[    10,     10,  nan,  nan,     0.03,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.08,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.46,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.69,  0.00,  nan ],
	[    50,     50,  nan,  nan,     1.55,  0.00,  nan ],
	[    60,     60,  nan,  nan,     2.41,  0.00,  nan ],
	[    70,     70,  nan,  nan,     1.89,  0.00,  nan ],
	[    80,     80,  nan,  nan,     3.22,  0.00,  nan ],
	[    90,     90,  nan,  nan,     3.83,  0.00,  nan ],
	[   100,    100,  nan,  nan,     4.70,  0.00,  nan ],
	[   200,    200,  nan,  nan,    17.09,  0.00,  nan ],
	[   300,    300,  nan,  nan,    10.21,  0.00,  nan ],
	[   400,    400,  nan,  nan,    20.55,  0.00,  nan ],
	[   500,    500,  nan,  nan,    30.92,  0.00,  nan ],
	[   600,    600,  nan,  nan,    41.22,  0.00,  nan ],
	[   700,    700,  nan,  nan,    53.89,  0.00,  nan ],
	[   800,    800,  nan,  nan,    68.44,  0.00,  nan ],
	[   900,    900,  nan,  nan,    82.98,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    98.87,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   259.86,  0.02,  nan ],
	[  3000,   3000,  nan,  nan,   434.36,  0.04,  nan ],
	[  4000,   4000,  nan,  nan,   611.21,  0.07,  nan ],
	[  5000,   5000,  nan,  nan,   747.73,  0.11,  nan ],
	[  6000,   6000,  nan,  nan,   918.61,  0.16,  nan ],
	[  7000,   7000,  nan,  nan,  1058.44,  0.22,  nan ],
	[  8000,   8000,  nan,  nan,  1189.63,  0.29,  nan ],
	[  9000,   9000,  nan,  nan,  1290.44,  0.38,  nan ],
	[ 10000,  10000,  nan,  nan,  1374.99,  0.48,  nan ],
	[ 12000,  12000,  nan,  nan,  1515.55,  0.76,  nan ],
	[ 14000,  14000,  nan,  nan,  1622.48,  1.13,  nan ],
	[ 16000,  16000,  nan,  nan,  1701.52,  1.60,  nan ],
	[ 18000,  18000,  nan,  nan,  1772.35,  2.19,  nan ],
	[ 20000,  20000,  nan,  nan,  1955.54,  2.73,  nan ],
])

# numactl --interleave=all ../testing/testing_sgetrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.02,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.07,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.15,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.30,  0.00,  nan ],
	[    60,     60,  nan,  nan,     0.49,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.62,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.02,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.28,  0.00,  nan ],
	[   100,    100,  nan,  nan,     1.63,  0.00,  nan ],
	[   200,    200,  nan,  nan,     7.12,  0.00,  nan ],
	[   300,    300,  nan,  nan,     7.40,  0.00,  nan ],
	[   400,    400,  nan,  nan,    13.95,  0.00,  nan ],
	[   500,    500,  nan,  nan,    23.01,  0.00,  nan ],
	[   600,    600,  nan,  nan,    33.22,  0.00,  nan ],
	[   700,    700,  nan,  nan,    45.55,  0.01,  nan ],
	[   800,    800,  nan,  nan,    57.58,  0.01,  nan ],
	[   900,    900,  nan,  nan,    72.55,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    86.70,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   259.14,  0.02,  nan ],
	[  3000,   3000,  nan,  nan,   458.04,  0.04,  nan ],
	[  4000,   4000,  nan,  nan,   662.44,  0.06,  nan ],
	[  5000,   5000,  nan,  nan,   782.17,  0.11,  nan ],
	[  6000,   6000,  nan,  nan,   986.56,  0.15,  nan ],
	[  7000,   7000,  nan,  nan,  1158.16,  0.20,  nan ],
	[  8000,   8000,  nan,  nan,  1310.63,  0.26,  nan ],
	[  9000,   9000,  nan,  nan,  1423.20,  0.34,  nan ],
	[ 10000,  10000,  nan,  nan,  1528.95,  0.44,  nan ],
	[ 12000,  12000,  nan,  nan,  1678.63,  0.69,  nan ],
	[ 14000,  14000,  nan,  nan,  1792.04,  1.02,  nan ],
	[ 16000,  16000,  nan,  nan,  1871.16,  1.46,  nan ],
	[ 18000,  18000,  nan,  nan,  1942.72,  2.00,  nan ],
	[ 20000,  20000,  nan,  nan,  2063.41,  2.58,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/spotrf.txt
# numactl --interleave=all ../testing/testing_spotrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
spotrf = array([
	[    10,  nan,  nan,     0.08,  0.00,  nan ],
	[    20,  nan,  nan,     0.48,  0.00,  nan ],
	[    30,  nan,  nan,     0.97,  0.00,  nan ],
	[    40,  nan,  nan,     1.47,  0.00,  nan ],
	[    50,  nan,  nan,     2.05,  0.00,  nan ],
	[    60,  nan,  nan,     2.62,  0.00,  nan ],
	[    70,  nan,  nan,     3.24,  0.00,  nan ],
	[    80,  nan,  nan,     3.70,  0.00,  nan ],
	[    90,  nan,  nan,     4.11,  0.00,  nan ],
	[   100,  nan,  nan,     4.62,  0.00,  nan ],
	[   200,  nan,  nan,    14.21,  0.00,  nan ],
	[   300,  nan,  nan,     5.86,  0.00,  nan ],
	[   400,  nan,  nan,    13.02,  0.00,  nan ],
	[   500,  nan,  nan,    23.00,  0.00,  nan ],
	[   600,  nan,  nan,    25.45,  0.00,  nan ],
	[   700,  nan,  nan,    37.27,  0.00,  nan ],
	[   800,  nan,  nan,    41.51,  0.00,  nan ],
	[   900,  nan,  nan,    56.13,  0.00,  nan ],
	[  1000,  nan,  nan,    73.14,  0.00,  nan ],
	[  2000,  nan,  nan,   285.91,  0.01,  nan ],
	[  3000,  nan,  nan,   534.96,  0.02,  nan ],
	[  4000,  nan,  nan,   801.25,  0.03,  nan ],
	[  5000,  nan,  nan,  1001.93,  0.04,  nan ],
	[  6000,  nan,  nan,  1189.53,  0.06,  nan ],
	[  7000,  nan,  nan,  1338.30,  0.09,  nan ],
	[  8000,  nan,  nan,  1485.15,  0.11,  nan ],
	[  9000,  nan,  nan,  1590.04,  0.15,  nan ],
	[ 10000,  nan,  nan,  1685.62,  0.20,  nan ],
	[ 12000,  nan,  nan,  1844.96,  0.31,  nan ],
	[ 14000,  nan,  nan,  1985.70,  0.46,  nan ],
	[ 16000,  nan,  nan,  2093.90,  0.65,  nan ],
	[ 18000,  nan,  nan,  2175.25,  0.89,  nan ],
	[ 20000,  nan,  nan,  2261.66,  1.18,  nan ],
])

# numactl --interleave=all ../testing/testing_spotrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
spotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.00,  0.00,  nan ],
	[    30,  nan,  nan,     0.01,  0.00,  nan ],
	[    40,  nan,  nan,     0.02,  0.00,  nan ],
	[    50,  nan,  nan,     0.03,  0.00,  nan ],
	[    60,  nan,  nan,     0.06,  0.00,  nan ],
	[    70,  nan,  nan,     0.09,  0.00,  nan ],
	[    80,  nan,  nan,     0.14,  0.00,  nan ],
	[    90,  nan,  nan,     0.19,  0.00,  nan ],
	[   100,  nan,  nan,     0.26,  0.00,  nan ],
	[   200,  nan,  nan,     5.24,  0.00,  nan ],
	[   300,  nan,  nan,     4.10,  0.00,  nan ],
	[   400,  nan,  nan,     9.09,  0.00,  nan ],
	[   500,  nan,  nan,    16.56,  0.00,  nan ],
	[   600,  nan,  nan,    20.83,  0.00,  nan ],
	[   700,  nan,  nan,    31.40,  0.00,  nan ],
	[   800,  nan,  nan,    36.79,  0.00,  nan ],
	[   900,  nan,  nan,    50.27,  0.00,  nan ],
	[  1000,  nan,  nan,    66.30,  0.01,  nan ],
	[  2000,  nan,  nan,   300.63,  0.01,  nan ],
	[  3000,  nan,  nan,   627.97,  0.01,  nan ],
	[  4000,  nan,  nan,   952.86,  0.02,  nan ],
	[  5000,  nan,  nan,  1170.66,  0.04,  nan ],
	[  6000,  nan,  nan,  1407.59,  0.05,  nan ],
	[  7000,  nan,  nan,  1564.87,  0.07,  nan ],
	[  8000,  nan,  nan,  1748.87,  0.10,  nan ],
	[  9000,  nan,  nan,  1858.51,  0.13,  nan ],
	[ 10000,  nan,  nan,  1957.65,  0.17,  nan ],
	[ 12000,  nan,  nan,  2109.81,  0.27,  nan ],
	[ 14000,  nan,  nan,  2253.65,  0.41,  nan ],
	[ 16000,  nan,  nan,  2340.03,  0.58,  nan ],
	[ 18000,  nan,  nan,  2402.42,  0.81,  nan ],
	[ 20000,  nan,  nan,  2477.84,  1.08,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/ssyevd.txt
# numactl --interleave=all ../testing/testing_ssyevd -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_ssyevd -JN -N 123 -N 1234 --range 12000:20000:2000
ssyevd_JN = array([
	[    10,  nan,   0.0000,  nan,  nan,  nan,  nan ],
	[    20,  nan,   0.0000,  nan,  nan,  nan,  nan ],
	[    30,  nan,   0.0001,  nan,  nan,  nan,  nan ],
	[    40,  nan,   0.0001,  nan,  nan,  nan,  nan ],
	[    50,  nan,   0.0001,  nan,  nan,  nan,  nan ],
	[    60,  nan,   0.0002,  nan,  nan,  nan,  nan ],
	[    70,  nan,   0.0003,  nan,  nan,  nan,  nan ],
	[    80,  nan,   0.0003,  nan,  nan,  nan,  nan ],
	[    90,  nan,   0.0004,  nan,  nan,  nan,  nan ],
	[   100,  nan,   0.0005,  nan,  nan,  nan,  nan ],
	[   200,  nan,   0.0036,  nan,  nan,  nan,  nan ],
	[   300,  nan,   0.0066,  nan,  nan,  nan,  nan ],
	[   400,  nan,   0.0109,  nan,  nan,  nan,  nan ],
	[   500,  nan,   0.0166,  nan,  nan,  nan,  nan ],
	[   600,  nan,   0.0221,  nan,  nan,  nan,  nan ],
	[   700,  nan,   0.0282,  nan,  nan,  nan,  nan ],
	[   800,  nan,   0.0361,  nan,  nan,  nan,  nan ],
	[   900,  nan,   0.0448,  nan,  nan,  nan,  nan ],
	[  1000,  nan,   0.0547,  nan,  nan,  nan,  nan ],
	[  2000,  nan,   0.2286,  nan,  nan,  nan,  nan ],
	[  3000,  nan,   0.8753,  nan,  nan,  nan,  nan ],
	[  4000,  nan,   1.5114,  nan,  nan,  nan,  nan ],
	[  5000,  nan,   2.4695,  nan,  nan,  nan,  nan ],
	[  6000,  nan,   3.6914,  nan,  nan,  nan,  nan ],
	[  7000,  nan,   5.2513,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   7.1277,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   9.4860,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,  12.0984,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,  19.1925,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,  28.1555,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,  39.5701,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,  54.4460,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  71.2115,  nan,  nan,  nan,  nan ],
])

# numactl --interleave=all ../testing/testing_ssyevd -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_ssyevd -JV -N 123 -N 1234 --range 12000:20000:2000
ssyevd_JV = array([
	[    10,  nan,   0.0001,  nan,  nan,  nan,  nan ],
	[    20,  nan,   0.0001,  nan,  nan,  nan,  nan ],
	[    30,  nan,   0.0002,  nan,  nan,  nan,  nan ],
	[    40,  nan,   0.0003,  nan,  nan,  nan,  nan ],
	[    50,  nan,   0.0004,  nan,  nan,  nan,  nan ],
	[    60,  nan,   0.0004,  nan,  nan,  nan,  nan ],
	[    70,  nan,   0.0006,  nan,  nan,  nan,  nan ],
	[    80,  nan,   0.0007,  nan,  nan,  nan,  nan ],
	[    90,  nan,   0.0008,  nan,  nan,  nan,  nan ],
	[   100,  nan,   0.0010,  nan,  nan,  nan,  nan ],
	[   200,  nan,   0.0075,  nan,  nan,  nan,  nan ],
	[   300,  nan,   0.0113,  nan,  nan,  nan,  nan ],
	[   400,  nan,   0.0181,  nan,  nan,  nan,  nan ],
	[   500,  nan,   0.0253,  nan,  nan,  nan,  nan ],
	[   600,  nan,   0.0292,  nan,  nan,  nan,  nan ],
	[   700,  nan,   0.0371,  nan,  nan,  nan,  nan ],
	[   800,  nan,   0.0449,  nan,  nan,  nan,  nan ],
	[   900,  nan,   0.0563,  nan,  nan,  nan,  nan ],
	[  1000,  nan,   0.0668,  nan,  nan,  nan,  nan ],
	[  2000,  nan,   0.2178,  nan,  nan,  nan,  nan ],
	[  3000,  nan,   0.8985,  nan,  nan,  nan,  nan ],
	[  4000,  nan,   1.5710,  nan,  nan,  nan,  nan ],
	[  5000,  nan,   2.5299,  nan,  nan,  nan,  nan ],
	[  6000,  nan,   3.8416,  nan,  nan,  nan,  nan ],
	[  7000,  nan,   5.4748,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   7.3099,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   9.6490,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,  12.4513,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,  20.1533,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,  29.5625,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,  41.5526,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,  57.5692,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  74.9994,  nan,  nan,  nan,  nan ],
])

# numactl --interleave=all ../testing/testing_ssyevd_gpu -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_ssyevd_gpu -JN -N 123 -N 1234 --range 12000:20000:2000
ssyevd_gpu_JN = array([
	[    10,  nan,   0.0002,  nan,  nan,  nan,  nan ],
	[    20,  nan,   0.0002,  nan,  nan,  nan,  nan ],
	[    30,  nan,   0.0002,  nan,  nan,  nan,  nan ],
	[    40,  nan,   0.0003,  nan,  nan,  nan,  nan ],
	[    50,  nan,   0.0003,  nan,  nan,  nan,  nan ],
	[    60,  nan,   0.0004,  nan,  nan,  nan,  nan ],
	[    70,  nan,   0.0004,  nan,  nan,  nan,  nan ],
	[    80,  nan,   0.0005,  nan,  nan,  nan,  nan ],
	[    90,  nan,   0.0006,  nan,  nan,  nan,  nan ],
	[   100,  nan,   0.0007,  nan,  nan,  nan,  nan ],
	[   200,  nan,   0.0035,  nan,  nan,  nan,  nan ],
	[   300,  nan,   0.0068,  nan,  nan,  nan,  nan ],
	[   400,  nan,   0.0114,  nan,  nan,  nan,  nan ],
	[   500,  nan,   0.0167,  nan,  nan,  nan,  nan ],
	[   600,  nan,   0.0229,  nan,  nan,  nan,  nan ],
	[   700,  nan,   0.0300,  nan,  nan,  nan,  nan ],
	[   800,  nan,   0.0380,  nan,  nan,  nan,  nan ],
	[   900,  nan,   0.0462,  nan,  nan,  nan,  nan ],
	[  1000,  nan,   0.0571,  nan,  nan,  nan,  nan ],
	[  2000,  nan,   0.2297,  nan,  nan,  nan,  nan ],
	[  3000,  nan,   0.8690,  nan,  nan,  nan,  nan ],
	[  4000,  nan,   1.5042,  nan,  nan,  nan,  nan ],
	[  5000,  nan,   2.4603,  nan,  nan,  nan,  nan ],
	[  6000,  nan,   3.6922,  nan,  nan,  nan,  nan ],
	[  7000,  nan,   5.2239,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   7.1195,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   9.4281,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,  12.0485,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,  19.1882,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,  28.0731,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,  39.2928,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,  54.2887,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  70.8357,  nan,  nan,  nan,  nan ],
])

# numactl --interleave=all ../testing/testing_ssyevd_gpu -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_ssyevd_gpu -JV -N 123 -N 1234 --range 12000:20000:2000
ssyevd_gpu_JV = array([
	[    10,  nan,   0.0003,  nan,  nan,  nan,  nan ],
	[    20,  nan,   0.0003,  nan,  nan,  nan,  nan ],
	[    30,  nan,   0.0004,  nan,  nan,  nan,  nan ],
	[    40,  nan,   0.0005,  nan,  nan,  nan,  nan ],
	[    50,  nan,   0.0005,  nan,  nan,  nan,  nan ],
	[    60,  nan,   0.0006,  nan,  nan,  nan,  nan ],
	[    70,  nan,   0.0008,  nan,  nan,  nan,  nan ],
	[    80,  nan,   0.0009,  nan,  nan,  nan,  nan ],
	[    90,  nan,   0.0011,  nan,  nan,  nan,  nan ],
	[   100,  nan,   0.0012,  nan,  nan,  nan,  nan ],
	[   200,  nan,   0.0067,  nan,  nan,  nan,  nan ],
	[   300,  nan,   0.0110,  nan,  nan,  nan,  nan ],
	[   400,  nan,   0.0178,  nan,  nan,  nan,  nan ],
	[   500,  nan,   0.0250,  nan,  nan,  nan,  nan ],
	[   600,  nan,   0.0289,  nan,  nan,  nan,  nan ],
	[   700,  nan,   0.0370,  nan,  nan,  nan,  nan ],
	[   800,  nan,   0.0454,  nan,  nan,  nan,  nan ],
	[   900,  nan,   0.0577,  nan,  nan,  nan,  nan ],
	[  1000,  nan,   0.0684,  nan,  nan,  nan,  nan ],
	[  2000,  nan,   0.2455,  nan,  nan,  nan,  nan ],
	[  3000,  nan,   0.9087,  nan,  nan,  nan,  nan ],
	[  4000,  nan,   1.5867,  nan,  nan,  nan,  nan ],
	[  5000,  nan,   2.5830,  nan,  nan,  nan,  nan ],
	[  6000,  nan,   3.9431,  nan,  nan,  nan,  nan ],
	[  7000,  nan,   5.6448,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   7.7442,  nan,  nan,  nan,  nan ],
	[  9000,  nan,  10.3376,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,  13.3178,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,  21.3168,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,  31.3873,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,  44.8046,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,  62.8077,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  82.5465,  nan,  nan,  nan,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/ssyevd_2stage.txt
# numactl --interleave=all ../testing/testing_ssyevdx_2stage -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevdx_2stage_JN = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.00 ],
	[   300,    300,   0.02 ],
	[   400,    400,   0.03 ],
	[   500,    500,   0.04 ],
	[   600,    600,   0.05 ],
	[   700,    700,   0.06 ],
	[   800,    800,   0.08 ],
	[   900,    900,   0.09 ],
	[  1000,   1000,   0.10 ],
	[  2000,   2000,   0.29 ],
	[  3000,   3000,   0.58 ],
	[  4000,   4000,   0.89 ],
	[  5000,   5000,   1.27 ],
	[  6000,   6000,   1.61 ],
	[  7000,   7000,   2.22 ],
	[  8000,   8000,   2.73 ],
	[  9000,   9000,   3.57 ],
	[ 10000,  10000,   4.32 ],
	[ 12000,  12000,   6.14 ],
	[ 14000,  14000,   8.60 ],
	[ 16000,  16000,  11.57 ],
	[ 18000,  18000,  15.06 ],
	[ 20000,  20000,  19.16 ],
])

# numactl --interleave=all ../testing/testing_ssyevdx_2stage -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevdx_2stage_JV = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.00 ],
	[   300,    300,   0.02 ],
	[   400,    400,   0.04 ],
	[   500,    500,   0.05 ],
	[   600,    600,   0.06 ],
	[   700,    700,   0.08 ],
	[   800,    800,   0.10 ],
	[   900,    900,   0.11 ],
	[  1000,   1000,   0.13 ],
	[  2000,   2000,   0.38 ],
	[  3000,   3000,   0.75 ],
	[  4000,   4000,   1.30 ],
	[  5000,   5000,   1.99 ],
	[  6000,   6000,   2.72 ],
	[  7000,   7000,   3.83 ],
	[  8000,   8000,   5.36 ],
	[  9000,   9000,   6.90 ],
	[ 10000,  10000,   8.89 ],
	[ 12000,  12000,  14.34 ],
	[ 14000,  14000,  20.46 ],
	[ 16000,  16000,  29.42 ],
	[ 18000,  18000,  40.68 ],
	[ 20000,  20000,  54.31 ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/ssymv.txt
# numactl --interleave=all ../testing/testing_ssymv -L -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
ssymv_L = array([
	[    10,    0.01,  0.03,    0.01,  0.03,   0.01,   0.02,   0.12,   0.00,  4.77e-08,  4.77e-08,  4.77e-08,  nan ],
	[    11,    0.01,  0.03,    0.01,  0.03,   0.02,   0.02,   0.12,   0.00,  4.33e-08,  8.67e-08,  4.33e-08,  nan ],
	[    12,    0.01,  0.03,    0.01,  0.03,   0.02,   0.02,   0.15,   0.00,  3.97e-08,  1.99e-08,  3.97e-08,  nan ],
	[    13,    0.01,  0.03,    0.01,  0.03,   0.02,   0.02,   0.17,   0.00,  3.67e-08,  3.67e-08,  7.34e-08,  nan ],
	[    14,    0.02,  0.03,    0.01,  0.03,   0.02,   0.02,   0.22,   0.00,  6.81e-08,  3.41e-08,  6.81e-08,  nan ],
	[    15,    0.02,  0.03,    0.02,  0.03,   0.03,   0.02,   0.22,   0.00,  6.36e-08,  6.36e-08,  6.36e-08,  nan ],
	[    16,    0.02,  0.03,    0.02,  0.03,   0.03,   0.02,   0.29,   0.00,  5.96e-08,  5.96e-08,  5.96e-08,  nan ],
	[    17,    0.02,  0.03,    0.02,  0.03,   0.03,   0.02,   0.20,   0.00,  1.12e-07,  5.61e-08,  5.61e-08,  nan ],
	[    18,    0.02,  0.03,    0.02,  0.03,   0.03,   0.02,   0.24,   0.00,  5.30e-08,  5.30e-08,  5.30e-08,  nan ],
	[    19,    0.03,  0.03,    0.02,  0.03,   0.04,   0.02,   0.40,   0.00,  5.02e-08,  5.02e-08,  5.02e-08,  nan ],
	[    20,    0.03,  0.03,    0.03,  0.03,   0.04,   0.02,   0.27,   0.00,  7.15e-08,  4.77e-08,  7.15e-08,  nan ],
	[    21,    0.03,  0.03,    0.03,  0.03,   0.05,   0.02,   0.30,   0.00,  9.08e-08,  1.36e-07,  6.81e-08,  nan ],
	[    22,    0.04,  0.03,    0.03,  0.03,   0.05,   0.02,   0.53,   0.00,  4.33e-08,  8.67e-08,  4.33e-08,  nan ],
	[    23,    0.04,  0.03,    0.03,  0.03,   0.06,   0.02,   0.36,   0.00,  8.29e-08,  8.29e-08,  8.29e-08,  nan ],
	[    24,    0.04,  0.03,    0.04,  0.03,   0.06,   0.02,   0.63,   0.00,  7.95e-08,  7.95e-08,  7.95e-08,  nan ],
	[    25,    0.04,  0.03,    0.04,  0.03,   0.06,   0.02,   0.68,   0.00,  7.63e-08,  7.63e-08,  3.81e-08,  nan ],
	[    26,    0.05,  0.03,    0.04,  0.03,   0.07,   0.02,   0.45,   0.00,  7.34e-08,  7.34e-08,  3.67e-08,  nan ],
	[    27,    0.05,  0.03,    0.05,  0.03,   0.07,   0.02,   0.53,   0.00,  7.06e-08,  7.06e-08,  7.06e-08,  nan ],
	[    28,    0.06,  0.03,    0.05,  0.03,   0.08,   0.02,   0.76,   0.00,  3.41e-08,  6.81e-08,  6.81e-08,  nan ],
	[    29,    0.06,  0.03,    0.05,  0.03,   0.08,   0.02,   0.56,   0.00,  9.87e-08,  1.32e-07,  6.58e-08,  nan ],
	[    30,    0.07,  0.03,    0.06,  0.03,   0.09,   0.02,   0.46,   0.00,  6.36e-08,  6.36e-08,  6.36e-08,  nan ],
	[    31,    0.07,  0.03,    0.06,  0.03,   0.09,   0.02,   0.69,   0.00,  6.15e-08,  9.23e-08,  9.23e-08,  nan ],
	[    32,    0.07,  0.03,    0.06,  0.03,   0.11,   0.02,   0.74,   0.00,  5.96e-08,  5.96e-08,  5.96e-08,  nan ],
	[    33,    0.08,  0.03,    0.07,  0.03,   0.11,   0.02,   0.72,   0.00,  5.78e-08,  5.78e-08,  5.78e-08,  nan ],
	[    34,    0.09,  0.03,    0.07,  0.03,   0.11,   0.02,   0.83,   0.00,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[    35,    0.10,  0.03,    0.08,  0.03,   0.11,   0.02,   0.88,   0.00,  5.45e-08,  5.45e-08,  8.17e-08,  nan ],
	[    36,    0.10,  0.03,    0.08,  0.03,   0.13,   0.02,   0.66,   0.00,  7.95e-08,  5.30e-08,  7.95e-08,  nan ],
	[    37,    0.11,  0.03,    0.08,  0.03,   0.13,   0.02,   0.69,   0.00,  7.73e-08,  5.15e-08,  7.73e-08,  nan ],
	[    38,    0.11,  0.03,    0.09,  0.03,   0.14,   0.02,   0.73,   0.00,  7.53e-08,  1.00e-07,  1.00e-07,  nan ],
	[    39,    0.11,  0.03,    0.09,  0.03,   0.15,   0.02,   0.77,   0.00,  4.89e-08,  4.89e-08,  4.89e-08,  nan ],
	[    40,    0.12,  0.03,    0.10,  0.03,   0.14,   0.02,   0.81,   0.00,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[    41,    0.13,  0.03,    0.10,  0.04,   0.15,   0.02,   1.11,   0.00,  6.98e-08,  9.30e-08,  6.98e-08,  nan ],
	[    42,    0.12,  0.03,    0.11,  0.03,   0.16,   0.02,   0.95,   0.00,  6.81e-08,  4.54e-08,  6.81e-08,  nan ],
	[    43,    0.14,  0.03,    0.11,  0.03,   0.17,   0.02,   0.93,   0.00,  8.87e-08,  8.87e-08,  8.87e-08,  nan ],
	[    44,    0.15,  0.03,    0.11,  0.04,   0.18,   0.02,   0.98,   0.00,  1.08e-07,  1.08e-07,  6.50e-08,  nan ],
	[    45,    0.14,  0.03,    0.12,  0.03,   0.18,   0.02,   1.09,   0.00,  8.48e-08,  6.36e-08,  8.48e-08,  nan ],
	[    46,    0.16,  0.03,    0.13,  0.03,   0.19,   0.02,   1.07,   0.00,  8.29e-08,  8.29e-08,  8.29e-08,  nan ],
	[    47,    0.16,  0.03,    0.13,  0.03,   0.21,   0.02,   1.11,   0.00,  1.01e-07,  1.22e-07,  8.12e-08,  nan ],
	[    48,    0.16,  0.03,    0.14,  0.03,   0.20,   0.02,   1.16,   0.00,  7.95e-08,  7.95e-08,  7.95e-08,  nan ],
	[    49,    0.17,  0.03,    0.14,  0.03,   0.20,   0.02,   1.21,   0.00,  7.79e-08,  7.79e-08,  7.79e-08,  nan ],
	[    50,    0.18,  0.03,    0.15,  0.04,   0.21,   0.02,   1.26,   0.00,  1.14e-07,  7.63e-08,  7.63e-08,  nan ],
	[    51,    0.20,  0.03,    0.16,  0.03,   0.22,   0.02,   1.31,   0.00,  7.48e-08,  1.12e-07,  7.48e-08,  nan ],
	[    52,    0.19,  0.03,    0.16,  0.03,   0.24,   0.02,   1.10,   0.01,  1.10e-07,  1.10e-07,  1.47e-07,  nan ],
	[    53,    0.20,  0.03,    0.17,  0.03,   0.23,   0.03,   1.14,   0.01,  1.08e-07,  1.08e-07,  7.20e-08,  nan ],
	[    54,    0.20,  0.03,    0.17,  0.03,   0.26,   0.02,   1.19,   0.01,  7.06e-08,  1.06e-07,  7.06e-08,  nan ],
	[    55,    0.22,  0.03,    0.18,  0.03,   0.26,   0.02,   1.23,   0.01,  6.94e-08,  6.94e-08,  6.94e-08,  nan ],
	[    56,    0.23,  0.03,    0.19,  0.03,   0.27,   0.02,   1.58,   0.00,  6.81e-08,  6.81e-08,  6.81e-08,  nan ],
	[    57,    0.23,  0.03,    0.19,  0.03,   0.28,   0.02,   1.32,   0.01,  6.69e-08,  6.69e-08,  6.69e-08,  nan ],
	[    58,    0.23,  0.03,    0.20,  0.04,   0.27,   0.03,   1.37,   0.01,  6.58e-08,  6.58e-08,  6.58e-08,  nan ],
	[    59,    0.27,  0.03,    0.22,  0.03,   0.29,   0.02,   1.75,   0.00,  6.47e-08,  9.70e-08,  9.70e-08,  nan ],
	[    60,    0.28,  0.03,    0.21,  0.03,   0.32,   0.02,   1.46,   0.01,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[    61,    0.29,  0.03,    0.22,  0.03,   0.32,   0.02,   1.22,   0.01,  9.38e-08,  9.38e-08,  1.25e-07,  nan ],
	[    62,    0.29,  0.03,    0.23,  0.03,   0.32,   0.02,   1.64,   0.00,  9.23e-08,  9.23e-08,  9.23e-08,  nan ],
	[    63,    0.31,  0.03,    0.24,  0.03,   0.32,   0.03,   1.35,   0.01,  9.08e-08,  9.08e-08,  9.08e-08,  nan ],
	[    64,    0.33,  0.03,    0.25,  0.03,   0.35,   0.02,   2.05,   0.00,  8.94e-08,  8.94e-08,  8.94e-08,  nan ],
	[    65,    0.28,  0.03,    0.21,  0.04,   0.34,   0.03,   1.71,   0.01,  1.47e-07,  1.47e-07,  1.47e-07,  nan ],
	[    66,    0.29,  0.03,    0.22,  0.04,   0.33,   0.03,   2.18,   0.00,  1.44e-07,  1.73e-07,  1.44e-07,  nan ],
	[    67,    0.29,  0.03,    0.23,  0.04,   0.34,   0.03,   1.82,   0.01,  1.42e-07,  8.54e-08,  8.54e-08,  nan ],
	[    68,    0.27,  0.04,    0.21,  0.05,   0.31,   0.03,   1.87,   0.01,  1.12e-07,  8.41e-08,  1.40e-07,  nan ],
	[    69,    0.28,  0.03,    0.24,  0.04,   0.31,   0.03,   1.93,   0.01,  8.29e-08,  8.29e-08,  1.11e-07,  nan ],
	[    70,    0.32,  0.03,    0.25,  0.04,   0.37,   0.03,   1.67,   0.01,  1.09e-07,  8.17e-08,  8.17e-08,  nan ],
	[    71,    0.34,  0.03,    0.26,  0.04,   0.38,   0.03,   2.52,   0.00,  1.61e-07,  1.07e-07,  1.07e-07,  nan ],
	[    72,    0.32,  0.03,    0.26,  0.04,   0.40,   0.03,   2.10,   0.01,  1.06e-07,  1.06e-07,  1.06e-07,  nan ],
	[    73,    0.35,  0.03,    0.26,  0.04,   0.42,   0.03,   2.16,   0.01,  1.57e-07,  1.05e-07,  1.05e-07,  nan ],
	[    74,    0.34,  0.03,    0.28,  0.04,   0.41,   0.03,   2.22,   0.01,  7.73e-08,  5.15e-08,  7.73e-08,  nan ],
	[    75,    0.34,  0.03,    0.28,  0.04,   0.42,   0.03,   2.28,   0.01,  1.02e-07,  7.63e-08,  1.02e-07,  nan ],
	[    76,    0.38,  0.03,    0.29,  0.04,   0.45,   0.03,   1.96,   0.01,  1.00e-07,  1.00e-07,  7.53e-08,  nan ],
	[    77,    0.38,  0.03,    0.30,  0.04,   0.45,   0.03,   2.02,   0.01,  7.43e-08,  7.43e-08,  9.91e-08,  nan ],
	[    78,    0.37,  0.03,    0.30,  0.04,   0.47,   0.03,   2.07,   0.01,  9.78e-08,  9.78e-08,  9.78e-08,  nan ],
	[    79,    0.41,  0.03,    0.32,  0.04,   0.47,   0.03,   1.77,   0.01,  1.45e-07,  9.66e-08,  9.66e-08,  nan ],
	[    80,    0.39,  0.03,    0.32,  0.04,   0.48,   0.03,   2.59,   0.01,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[    81,    0.43,  0.03,    0.33,  0.04,   0.43,   0.03,   2.65,   0.01,  9.42e-08,  9.42e-08,  1.41e-07,  nan ],
	[    82,    0.44,  0.03,    0.33,  0.04,   0.51,   0.03,   2.28,   0.01,  1.16e-07,  9.30e-08,  9.30e-08,  nan ],
	[    83,    0.46,  0.03,    0.35,  0.04,   0.52,   0.03,   2.25,   0.01,  9.19e-08,  9.19e-08,  6.89e-08,  nan ],
	[    84,    0.46,  0.03,    0.36,  0.04,   0.53,   0.03,   2.40,   0.01,  9.08e-08,  1.36e-07,  9.08e-08,  nan ],
	[    85,    0.46,  0.03,    0.37,  0.04,   0.56,   0.03,   2.36,   0.01,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[    86,    0.47,  0.03,    0.38,  0.04,   0.58,   0.03,   2.09,   0.01,  1.33e-07,  8.87e-08,  8.87e-08,  nan ],
	[    87,    0.46,  0.03,    0.38,  0.04,   0.58,   0.03,   2.21,   0.01,  8.77e-08,  1.32e-07,  1.32e-07,  nan ],
	[    88,    0.51,  0.03,    0.39,  0.04,   0.56,   0.03,   2.63,   0.01,  1.30e-07,  1.30e-07,  1.30e-07,  nan ],
	[    89,    0.49,  0.03,    0.40,  0.04,   0.62,   0.03,   2.32,   0.01,  8.57e-08,  1.29e-07,  8.57e-08,  nan ],
	[    90,    0.51,  0.03,    0.41,  0.04,   0.53,   0.03,   2.64,   0.01,  8.48e-08,  8.48e-08,  8.48e-08,  nan ],
	[   100,    0.68,  0.03,    0.50,  0.04,   0.72,   0.03,   2.49,   0.01,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[   110,    0.76,  0.03,    0.60,  0.04,   0.84,   0.03,   2.70,   0.01,  1.04e-07,  1.04e-07,  1.04e-07,  nan ],
	[   120,    0.97,  0.03,    0.71,  0.04,   1.00,   0.03,   4.20,   0.01,  1.27e-07,  1.27e-07,  1.27e-07,  nan ],
	[   130,    0.95,  0.04,    0.83,  0.04,   1.10,   0.03,   4.76,   0.01,  1.76e-07,  1.76e-07,  1.47e-07,  nan ],
	[   140,    1.06,  0.04,    0.96,  0.04,   1.24,   0.03,   4.87,   0.01,  1.36e-07,  1.36e-07,  1.36e-07,  nan ],
	[   150,    1.23,  0.04,    1.05,  0.04,   1.29,   0.04,   5.59,   0.01,  2.03e-07,  1.53e-07,  1.27e-07,  nan ],
	[   160,    1.36,  0.04,    1.19,  0.04,   1.61,   0.03,   4.70,   0.01,  1.43e-07,  1.43e-07,  1.43e-07,  nan ],
	[   170,    1.57,  0.04,    1.33,  0.04,   1.71,   0.03,   4.43,   0.01,  1.80e-07,  1.35e-07,  1.80e-07,  nan ],
	[   180,    1.76,  0.04,    1.45,  0.05,   1.67,   0.04,   5.47,   0.01,  1.48e-07,  1.91e-07,  1.48e-07,  nan ],
	[   190,    1.91,  0.04,    1.65,  0.04,   2.14,   0.03,   6.09,   0.01,  2.01e-07,  1.61e-07,  1.61e-07,  nan ],
	[   200,    1.96,  0.04,    1.78,  0.05,   2.23,   0.04,   8.03,   0.01,  2.29e-07,  2.29e-07,  1.91e-07,  nan ],
	[   210,    2.01,  0.04,    2.01,  0.04,   2.46,   0.04,   7.91,   0.01,  1.82e-07,  1.45e-07,  1.45e-07,  nan ],
	[   220,    2.37,  0.04,    2.20,  0.04,   2.70,   0.04,   8.16,   0.01,  2.43e-07,  2.43e-07,  2.08e-07,  nan ],
	[   230,    2.59,  0.04,    2.41,  0.04,   2.95,   0.04,   7.55,   0.01,  2.65e-07,  2.32e-07,  2.32e-07,  nan ],
	[   240,    2.68,  0.04,    2.58,  0.04,   3.21,   0.04,   8.82,   0.01,  2.86e-07,  2.54e-07,  2.54e-07,  nan ],
	[   250,    3.06,  0.04,    2.51,  0.05,   3.31,   0.04,   7.41,   0.02,  1.53e-07,  1.53e-07,  1.83e-07,  nan ],
	[   260,    2.95,  0.05,    2.95,  0.05,   3.39,   0.04,   4.13,   0.03,  2.64e-07,  2.05e-07,  2.64e-07,  nan ],
	[   270,    3.18,  0.05,    3.18,  0.05,   3.65,   0.04,   3.77,   0.04,  2.54e-07,  2.83e-07,  2.83e-07,  nan ],
	[   280,    3.27,  0.05,    3.35,  0.05,   3.95,   0.04,   4.37,   0.04,  3.27e-07,  3.00e-07,  3.00e-07,  nan ],
	[   290,    3.67,  0.05,    3.59,  0.05,   4.02,   0.04,   4.12,   0.04,  3.16e-07,  2.63e-07,  3.16e-07,  nan ],
	[   300,    4.03,  0.04,    3.92,  0.05,   4.30,   0.04,   4.89,   0.04,  2.54e-07,  2.54e-07,  2.54e-07,  nan ],
	[   310,    4.19,  0.05,    4.00,  0.05,   4.60,   0.04,   4.28,   0.05,  2.46e-07,  2.46e-07,  2.21e-07,  nan ],
	[   320,    4.37,  0.05,    4.37,  0.05,   4.90,   0.04,   5.16,   0.04,  2.86e-07,  2.86e-07,  2.38e-07,  nan ],
	[   330,    4.30,  0.05,    4.56,  0.05,   4.95,   0.04,   4.75,   0.05,  2.54e-07,  2.31e-07,  2.31e-07,  nan ],
	[   340,    4.38,  0.05,    4.84,  0.05,   5.40,   0.04,   4.63,   0.05,  3.59e-07,  4.04e-07,  3.59e-07,  nan ],
	[   350,    4.91,  0.05,    5.10,  0.05,   5.73,   0.04,   4.62,   0.05,  2.18e-07,  2.18e-07,  2.18e-07,  nan ],
	[   360,    5.19,  0.05,    5.29,  0.05,   5.65,   0.05,   5.19,   0.05,  2.54e-07,  2.54e-07,  2.54e-07,  nan ],
	[   370,    5.51,  0.05,    5.59,  0.05,   6.09,   0.05,   4.98,   0.06,  2.89e-07,  2.47e-07,  2.89e-07,  nan ],
	[   380,    5.57,  0.05,    5.68,  0.05,   6.29,   0.05,   5.35,   0.05,  2.41e-07,  3.21e-07,  2.81e-07,  nan ],
	[   390,    5.64,  0.05,    6.24,  0.05,   6.49,   0.05,   6.46,   0.05,  3.13e-07,  2.35e-07,  2.35e-07,  nan ],
	[   400,    3.61,  0.09,    6.41,  0.05,   6.53,   0.05,   7.12,   0.05,  2.67e-07,  3.05e-07,  2.67e-07,  nan ],
	[   410,    6.15,  0.05,    6.76,  0.05,   7.03,   0.05,   6.86,   0.05,  2.98e-07,  2.61e-07,  2.61e-07,  nan ],
	[   420,    6.31,  0.06,    6.93,  0.05,   7.06,   0.05,   7.53,   0.05,  2.54e-07,  2.54e-07,  2.54e-07,  nan ],
	[   430,    6.76,  0.05,    7.44,  0.05,   7.55,   0.05,   7.26,   0.05,  3.19e-07,  3.55e-07,  3.19e-07,  nan ],
	[   440,    6.93,  0.06,    7.61,  0.05,   7.90,   0.05,   8.61,   0.05,  2.77e-07,  2.77e-07,  2.43e-07,  nan ],
	[   450,    6.65,  0.06,    7.81,  0.05,   7.81,   0.05,   6.65,   0.06,  2.71e-07,  2.71e-07,  2.71e-07,  nan ],
	[   460,    7.17,  0.06,    8.31,  0.05,   8.51,   0.05,   8.16,   0.05,  2.99e-07,  2.99e-07,  2.65e-07,  nan ],
	[   470,    7.37,  0.06,    8.33,  0.05,   8.36,   0.05,   7.77,   0.06,  3.57e-07,  3.57e-07,  3.57e-07,  nan ],
	[   480,    7.57,  0.06,    8.88,  0.05,   8.88,   0.05,   8.88,   0.05,  3.50e-07,  3.81e-07,  3.50e-07,  nan ],
	[   490,    7.62,  0.06,    9.05,  0.05,   9.09,   0.05,   8.44,   0.06,  3.74e-07,  3.43e-07,  3.43e-07,  nan ],
	[   500,    7.96,  0.06,    9.47,  0.05,   9.14,   0.05,   7.05,   0.07,  3.66e-07,  4.27e-07,  3.97e-07,  nan ],
	[   510,    8.68,  0.06,    9.85,  0.05,   9.30,   0.06,   6.96,   0.07,  3.29e-07,  3.59e-07,  3.59e-07,  nan ],
	[   520,    8.48,  0.06,   10.01,  0.05,   9.51,   0.06,   9.84,   0.06,  2.93e-07,  2.93e-07,  2.93e-07,  nan ],
	[   530,    8.81,  0.06,   10.63,  0.05,   9.37,   0.06,   9.68,   0.06,  3.17e-07,  3.17e-07,  3.17e-07,  nan ],
	[   540,    9.28,  0.06,   11.04,  0.05,   9.72,   0.06,  10.47,   0.06,  3.67e-07,  3.39e-07,  3.39e-07,  nan ],
	[   550,    9.31,  0.07,   11.25,  0.05,   9.63,   0.06,  10.59,   0.06,  3.61e-07,  3.61e-07,  3.61e-07,  nan ],
	[   560,    9.94,  0.06,   11.61,  0.05,  10.29,   0.06,  10.85,   0.06,  3.27e-07,  3.27e-07,  3.00e-07,  nan ],
	[   570,    9.86,  0.07,   11.62,  0.06,  10.71,   0.06,  10.00,   0.07,  3.75e-07,  3.48e-07,  3.75e-07,  nan ],
	[   580,    9.49,  0.07,   12.03,  0.06,  10.35,   0.07,  10.39,   0.06,  3.42e-07,  3.42e-07,  3.42e-07,  nan ],
	[   590,    9.98,  0.07,   12.45,  0.06,  10.71,   0.07,  10.26,   0.07,  4.14e-07,  3.88e-07,  3.62e-07,  nan ],
	[   600,   10.02,  0.07,   12.87,  0.06,  11.29,   0.06,  10.15,   0.07,  3.81e-07,  3.56e-07,  3.56e-07,  nan ],
	[   610,   10.49,  0.07,   12.81,  0.06,  10.97,   0.07,  10.22,   0.07,  3.25e-07,  3.50e-07,  3.25e-07,  nan ],
	[   620,   10.84,  0.07,   13.08,  0.06,  11.33,   0.07,   9.76,   0.08,  3.94e-07,  3.69e-07,  3.94e-07,  nan ],
	[   630,   11.34,  0.07,   13.50,  0.06,  11.70,   0.07,  10.20,   0.08,  3.63e-07,  2.91e-07,  3.15e-07,  nan ],
	[   640,   11.25,  0.07,   14.40,  0.06,  12.07,   0.07,  11.55,   0.07,  4.29e-07,  4.05e-07,  4.05e-07,  nan ],
	[   650,   11.27,  0.08,   14.14,  0.06,  11.91,   0.07,  10.86,   0.08,  3.52e-07,  3.52e-07,  3.05e-07,  nan ],
	[   660,   11.81,  0.07,   14.76,  0.06,  12.12,   0.07,  11.96,   0.07,  3.93e-07,  3.93e-07,  3.70e-07,  nan ],
	[   670,   11.82,  0.08,   14.97,  0.06,  12.13,   0.07,  11.68,   0.08,  4.10e-07,  3.42e-07,  3.64e-07,  nan ],
	[   680,   11.88,  0.08,   15.48,  0.06,  12.86,   0.07,  12.18,   0.08,  4.04e-07,  4.04e-07,  3.59e-07,  nan ],
	[   690,   12.38,  0.08,   15.87,  0.06,  12.90,   0.07,  11.63,   0.08,  5.31e-07,  5.31e-07,  4.87e-07,  nan ],
	[   700,   12.74,  0.08,   16.14,  0.06,  13.07,   0.08,  12.11,   0.08,  3.71e-07,  3.49e-07,  3.27e-07,  nan ],
	[   710,   12.60,  0.08,   16.80,  0.06,  13.27,   0.08,  12.45,   0.08,  3.44e-07,  3.44e-07,  3.44e-07,  nan ],
	[   720,   13.00,  0.08,   17.01,  0.06,  13.48,   0.08,  13.16,   0.08,  4.24e-07,  4.24e-07,  4.66e-07,  nan ],
	[   730,   13.01,  0.08,   17.49,  0.06,  14.03,   0.08,  12.72,   0.08,  5.02e-07,  4.60e-07,  4.60e-07,  nan ],
	[   740,   13.22,  0.08,   17.97,  0.06,  14.02,   0.08,  12.60,   0.09,  4.12e-07,  4.12e-07,  4.12e-07,  nan ],
	[   750,   13.74,  0.08,   18.82,  0.06,  14.27,   0.08,  12.67,   0.09,  3.66e-07,  3.66e-07,  3.66e-07,  nan ],
	[   760,   13.94,  0.08,   18.66,  0.06,  14.66,   0.08,  13.01,   0.09,  4.02e-07,  4.02e-07,  4.02e-07,  nan ],
	[   770,   13.32,  0.09,   18.51,  0.06,  14.48,   0.08,  12.24,   0.10,  6.74e-07,  6.34e-07,  5.94e-07,  nan ],
	[   780,   13.52,  0.09,   18.72,  0.07,  15.03,   0.08,  12.71,   0.10,  4.30e-07,  3.91e-07,  3.91e-07,  nan ],
	[   790,   14.36,  0.09,   20.16,  0.06,  15.46,   0.08,  13.58,   0.09,  4.25e-07,  4.25e-07,  3.86e-07,  nan ],
	[   800,   14.73,  0.09,   20.06,  0.06,  15.45,   0.08,  13.21,   0.10,  4.58e-07,  4.20e-07,  4.58e-07,  nan ],
	[   810,   14.62,  0.09,   20.49,  0.06,  15.61,   0.08,  13.67,   0.10,  4.90e-07,  3.77e-07,  3.77e-07,  nan ],
	[   820,   15.14,  0.09,   20.39,  0.07,  16.04,   0.08,  14.33,   0.09,  3.72e-07,  3.72e-07,  3.72e-07,  nan ],
	[   830,   15.51,  0.09,   20.89,  0.07,  16.44,   0.08,  13.15,   0.10,  4.04e-07,  4.41e-07,  4.04e-07,  nan ],
	[   840,   15.04,  0.09,   21.09,  0.07,  16.42,   0.09,  14.42,   0.10,  4.00e-07,  4.00e-07,  4.00e-07,  nan ],
	[   850,   15.56,  0.09,   21.29,  0.07,  17.04,   0.08,  14.45,   0.10,  5.39e-07,  5.03e-07,  5.03e-07,  nan ],
	[   860,   15.41,  0.10,   22.10,  0.07,  17.02,   0.09,  14.35,   0.10,  5.32e-07,  5.32e-07,  5.32e-07,  nan ],
	[   870,   16.13,  0.09,   21.92,  0.07,  17.23,   0.09,  14.58,   0.10,  3.86e-07,  4.21e-07,  3.86e-07,  nan ],
	[   880,   16.14,  0.10,   22.82,  0.07,  17.62,   0.09,  13.87,   0.11,  4.51e-07,  4.16e-07,  4.16e-07,  nan ],
	[   890,   16.88,  0.09,   22.94,  0.07,  17.79,   0.09,  14.15,   0.11,  4.80e-07,  4.80e-07,  4.80e-07,  nan ],
	[   900,   15.60,  0.10,   23.14,  0.07,  17.81,   0.09,  13.42,   0.12,  3.73e-07,  4.41e-07,  4.07e-07,  nan ],
	[  1000,   18.33,  0.11,   27.44,  0.07,  19.62,   0.10,  14.81,   0.14,  6.71e-07,  6.41e-07,  6.10e-07,  nan ],
	[  1100,   19.39,  0.12,   30.24,  0.08,  21.62,   0.11,  15.14,   0.16,  5.55e-07,  5.83e-07,  5.83e-07,  nan ],
	[  1200,   21.98,  0.13,   34.74,  0.08,  24.23,   0.12,  16.38,   0.18,  6.61e-07,  6.36e-07,  5.85e-07,  nan ],
	[  1300,   23.33,  0.14,   37.63,  0.09,  26.42,   0.13,  15.57,   0.22,  5.87e-07,  5.63e-07,  5.40e-07,  nan ],
	[  1400,   25.95,  0.15,   42.19,  0.09,  29.07,   0.13,  17.45,   0.22,  5.67e-07,  5.67e-07,  5.23e-07,  nan ],
	[  1500,   27.45,  0.16,   46.41,  0.10,  29.24,   0.15,  16.03,   0.28,  6.51e-07,  5.70e-07,  6.10e-07,  nan ],
	[  1600,   29.60,  0.17,   50.68,  0.10,  31.60,   0.16,  17.14,   0.30,  6.10e-07,  6.10e-07,  6.48e-07,  nan ],
	[  1700,   31.26,  0.19,   54.03,  0.11,  33.64,   0.17,  17.58,   0.33,  6.46e-07,  6.10e-07,  5.74e-07,  nan ],
	[  1800,   33.41,  0.19,   57.86,  0.11,  35.46,   0.18,  16.80,   0.39,  8.14e-07,  8.48e-07,  8.14e-07,  nan ],
	[  1900,   35.07,  0.21,   60.24,  0.12,  37.83,   0.19,  18.01,   0.40,  7.39e-07,  7.39e-07,  7.07e-07,  nan ],
	[  2000,   37.05,  0.22,   59.31,  0.13,  36.73,   0.22,  18.70,   0.43,  7.32e-07,  8.54e-07,  8.85e-07,  nan ],
	[  2100,   37.88,  0.23,   63.48,  0.14,  24.37,   0.36,  17.79,   0.50,  8.43e-07,  7.85e-07,  7.85e-07,  nan ],
	[  2200,   39.71,  0.24,   66.81,  0.14,  25.21,   0.38,  18.51,   0.52,  7.21e-07,  7.77e-07,  8.05e-07,  nan ],
	[  2300,   41.84,  0.25,   69.15,  0.15,  26.13,   0.41,  18.97,   0.56,  8.49e-07,  7.70e-07,  7.70e-07,  nan ],
	[  2400,   43.35,  0.27,   73.02,  0.16,  27.19,   0.42,  20.99,   0.55,  6.36e-07,  6.87e-07,  7.12e-07,  nan ],
	[  2500,   44.98,  0.28,   76.68,  0.16,  28.05,   0.45,  21.52,   0.58,  9.03e-07,  8.06e-07,  8.06e-07,  nan ],
	[  2600,   47.27,  0.29,   79.56,  0.17,  28.97,   0.47,  21.64,   0.63,  8.92e-07,  8.45e-07,  8.45e-07,  nan ],
	[  2700,   48.44,  0.30,   83.35,  0.17,  30.08,   0.48,  21.33,   0.68,  7.69e-07,  7.01e-07,  6.78e-07,  nan ],
	[  2800,   51.93,  0.30,   88.07,  0.18,  31.43,   0.50,  21.81,   0.72,  9.37e-07,  9.37e-07,  8.72e-07,  nan ],
	[  2900,   52.12,  0.32,   89.56,  0.19,  32.22,   0.52,  21.57,   0.78,  1.05e-06,  1.05e-06,  1.05e-06,  nan ],
	[  3000,   53.75,  0.33,   92.33,  0.20,  33.91,   0.53,  21.46,   0.84,  9.36e-07,  8.95e-07,  7.73e-07,  nan ],
	[  3100,   55.88,  0.34,   97.16,  0.20,  34.21,   0.56,  22.43,   0.86,  9.06e-07,  9.84e-07,  9.45e-07,  nan ],
	[  3200,   57.71,  0.36,   98.43,  0.21,  35.39,   0.58,  22.56,   0.91,  9.16e-07,  8.77e-07,  9.16e-07,  nan ],
	[  3300,   59.38,  0.37,  100.86,  0.22,  36.26,   0.60,  23.13,   0.94,  9.62e-07,  9.62e-07,  9.25e-07,  nan ],
	[  3400,   61.86,  0.37,  103.19,  0.22,  37.42,   0.62,  22.79,   1.01,  1.15e-06,  1.11e-06,  1.15e-06,  nan ],
	[  3500,   62.68,  0.39,  107.97,  0.23,  38.83,   0.63,  23.72,   1.03,  8.72e-07,  9.42e-07,  8.72e-07,  nan ],
	[  3600,   64.35,  0.40,  110.74,  0.23,  39.34,   0.66,  23.92,   1.08,  1.19e-06,  1.15e-06,  1.12e-06,  nan ],
	[  3700,   66.63,  0.41,  109.92,  0.25,  40.28,   0.68,  23.69,   1.16,  8.58e-07,  8.91e-07,  8.91e-07,  nan ],
	[  3800,   68.61,  0.42,  111.98,  0.26,  41.27,   0.70,  23.66,   1.22,  1.09e-06,  1.03e-06,  1.06e-06,  nan ],
	[  3900,   68.84,  0.44,  110.21,  0.28,  42.50,   0.72,  23.75,   1.28,  1.41e-06,  1.28e-06,  1.31e-06,  nan ],
	[  4000,   69.45,  0.46,  111.14,  0.29,  43.43,   0.74,  22.80,   1.40,  1.13e-06,  1.16e-06,  1.10e-06,  nan ],
	[  4100,   70.66,  0.48,  111.76,  0.30,  31.34,   1.07,  23.47,   1.43,  1.13e-06,  1.10e-06,  1.07e-06,  nan ],
	[  4200,   72.31,  0.49,  114.91,  0.31,  32.71,   1.08,  23.49,   1.50,  1.13e-06,  1.13e-06,  1.13e-06,  nan ],
	[  4300,   74.12,  0.50,  112.02,  0.33,  33.75,   1.10,  23.96,   1.54,  1.02e-06,  1.08e-06,  1.05e-06,  nan ],
	[  4400,   75.94,  0.51,  113.59,  0.34,  34.42,   1.13,  24.76,   1.56,  1.25e-06,  1.22e-06,  1.33e-06,  nan ],
	[  4500,   77.76,  0.52,  114.11,  0.36,  35.41,   1.14,  24.67,   1.64,  1.17e-06,  1.09e-06,  1.09e-06,  nan ],
	[  4600,   80.34,  0.53,  114.10,  0.37,  36.06,   1.17,  23.39,   1.81,  1.41e-06,  1.51e-06,  1.49e-06,  nan ],
	[  4700,   81.22,  0.54,  117.53,  0.38,  36.55,   1.21,  24.15,   1.83,  1.40e-06,  1.22e-06,  1.27e-06,  nan ],
	[  4800,   82.72,  0.56,  115.20,  0.40,  37.44,   1.23,  23.82,   1.94,  1.22e-06,  1.09e-06,  1.12e-06,  nan ],
	[  4900,   80.74,  0.59,  114.92,  0.42,  38.18,   1.26,  24.18,   1.99,  1.35e-06,  1.20e-06,  1.15e-06,  nan ],
	[  5000,   81.46,  0.61,  114.94,  0.44,  38.95,   1.28,  24.09,   2.08,  1.07e-06,  1.07e-06,  1.05e-06,  nan ],
	[  5100,   81.80,  0.64,  116.70,  0.45,  39.63,   1.31,  24.99,   2.08,  1.20e-06,  1.32e-06,  1.24e-06,  nan ],
	[  5200,   81.70,  0.66,  116.05,  0.47,  40.07,   1.35,  24.96,   2.17,  1.29e-06,  1.46e-06,  1.34e-06,  nan ],
	[  5300,   81.07,  0.69,  115.87,  0.48,  40.95,   1.37,  25.50,   2.20,  1.20e-06,  1.27e-06,  1.15e-06,  nan ],
	[  5400,   81.93,  0.71,  121.72,  0.48,  40.62,   1.44,  25.02,   2.33,  1.54e-06,  1.60e-06,  1.58e-06,  nan ],
	[  5500,   82.32,  0.74,  111.02,  0.55,  42.41,   1.43,  25.21,   2.40,  1.40e-06,  1.46e-06,  1.35e-06,  nan ],
	[  5600,   83.08,  0.76,  121.81,  0.51,  42.96,   1.46,  25.48,   2.46,  1.53e-06,  1.31e-06,  1.40e-06,  nan ],
	[  5700,   83.85,  0.78,  119.93,  0.54,  43.39,   1.50,  25.26,   2.57,  1.46e-06,  1.54e-06,  1.50e-06,  nan ],
	[  5800,   82.77,  0.81,  121.03,  0.56,  44.25,   1.52,  24.64,   2.73,  1.47e-06,  1.43e-06,  1.35e-06,  nan ],
	[  5900,   83.78,  0.83,  120.88,  0.58,  44.84,   1.55,  25.27,   2.76,  1.28e-06,  1.24e-06,  1.20e-06,  nan ],
	[  6000,   84.32,  0.85,  121.64,  0.59,  45.67,   1.58,  25.36,   2.84,  1.30e-06,  1.34e-06,  1.34e-06,  nan ],
	[  6100,   84.77,  0.88,  124.88,  0.60,  45.95,   1.62,  25.21,   2.95,  1.52e-06,  1.44e-06,  1.44e-06,  nan ],
	[  6200,   86.79,  0.89,  125.44,  0.61,  36.08,   2.13,  24.87,   3.09,  1.42e-06,  1.30e-06,  1.38e-06,  nan ],
	[  6300,   87.15,  0.91,  125.61,  0.63,  37.59,   2.11,  24.37,   3.26,  1.98e-06,  1.98e-06,  1.98e-06,  nan ],
	[  6400,   87.27,  0.94,  125.28,  0.65,  38.29,   2.14,  24.79,   3.30,  1.49e-06,  1.37e-06,  1.41e-06,  nan ],
	[  6500,   88.13,  0.96,  126.10,  0.67,  38.66,   2.19,  25.06,   3.37,  1.65e-06,  1.50e-06,  1.50e-06,  nan ],
	[  6600,   88.38,  0.99,  126.63,  0.69,  39.37,   2.21,  25.13,   3.47,  1.66e-06,  1.70e-06,  1.66e-06,  nan ],
	[  6700,   88.80,  1.01,  126.64,  0.71,  39.44,   2.28,  25.04,   3.59,  1.49e-06,  1.57e-06,  1.60e-06,  nan ],
	[  6800,   88.61,  1.04,  128.08,  0.72,  40.16,   2.30,  25.38,   3.64,  1.65e-06,  1.69e-06,  1.62e-06,  nan ],
	[  6900,   88.08,  1.08,  128.69,  0.74,  40.89,   2.33,  25.12,   3.79,  1.59e-06,  1.63e-06,  1.56e-06,  nan ],
	[  7000,   89.51,  1.10,  131.72,  0.74,  41.53,   2.36,  25.32,   3.87,  1.36e-06,  1.40e-06,  1.33e-06,  nan ],
	[  7100,   90.20,  1.12,  131.67,  0.77,  41.99,   2.40,  25.03,   4.03,  1.65e-06,  1.55e-06,  1.48e-06,  nan ],
	[  7200,   91.52,  1.13,  132.28,  0.78,  42.57,   2.44,  25.35,   4.09,  2.14e-06,  2.17e-06,  2.17e-06,  nan ],
	[  7300,   91.56,  1.16,  132.24,  0.81,  43.05,   2.48,  25.36,   4.20,  1.64e-06,  1.54e-06,  1.47e-06,  nan ],
	[  7400,   91.05,  1.20,  131.64,  0.83,  43.67,   2.51,  25.72,   4.26,  1.68e-06,  1.68e-06,  1.65e-06,  nan ],
	[  7500,   92.46,  1.22,  131.60,  0.85,  44.32,   2.54,  25.40,   4.43,  1.73e-06,  1.66e-06,  1.76e-06,  nan ],
	[  7600,   93.93,  1.23,  130.72,  0.88,  43.45,   2.66,  25.05,   4.61,  1.73e-06,  1.61e-06,  1.57e-06,  nan ],
	[  7700,   93.01,  1.28,  132.65,  0.89,  44.99,   2.64,  25.44,   4.66,  1.68e-06,  1.68e-06,  1.78e-06,  nan ],
	[  7800,   94.93,  1.28,  131.72,  0.92,  45.44,   2.68,  25.36,   4.80,  1.50e-06,  1.53e-06,  1.57e-06,  nan ],
	[  7900,   94.43,  1.32,  132.52,  0.94,  46.06,   2.71,  25.39,   4.92,  1.51e-06,  1.48e-06,  1.45e-06,  nan ],
	[  8000,   94.07,  1.36,  134.03,  0.96,  46.77,   2.74,  25.81,   4.96,  1.71e-06,  1.86e-06,  1.89e-06,  nan ],
	[  8100,   95.93,  1.37,  135.74,  0.97,  46.55,   2.82,  24.99,   5.25,  1.48e-06,  1.45e-06,  1.39e-06,  nan ],
	[  8200,   96.76,  1.39,  134.89,  1.00,  38.45,   3.50,  24.65,   5.46,  1.58e-06,  1.46e-06,  1.55e-06,  nan ],
	[  8300,   97.66,  1.41,  133.79,  1.03,  39.84,   3.46,  25.37,   5.43,  1.68e-06,  1.65e-06,  1.68e-06,  nan ],
	[  8400,   97.73,  1.44,  133.90,  1.05,  39.19,   3.60,  25.43,   5.55,  1.71e-06,  1.71e-06,  1.80e-06,  nan ],
	[  8500,   98.11,  1.47,  134.31,  1.08,  40.18,   3.60,  25.12,   5.75,  1.67e-06,  1.58e-06,  1.58e-06,  nan ],
	[  8600,   98.82,  1.50,  134.98,  1.10,  41.25,   3.59,  24.53,   6.03,  1.65e-06,  1.67e-06,  1.65e-06,  nan ],
	[  8700,   98.18,  1.54,  132.35,  1.14,  41.45,   3.65,  25.11,   6.03,  1.99e-06,  1.91e-06,  1.85e-06,  nan ],
	[  8800,   97.61,  1.59,  133.98,  1.16,  41.94,   3.69,  24.86,   6.23,  2.03e-06,  1.89e-06,  1.75e-06,  nan ],
	[  8900,   99.10,  1.60,  134.71,  1.18,  41.20,   3.85,  24.50,   6.47,  1.84e-06,  1.73e-06,  1.76e-06,  nan ],
	[  9000,  100.32,  1.62,  133.35,  1.21,  42.00,   3.86,  24.85,   6.52,  1.65e-06,  1.60e-06,  1.55e-06,  nan ],
	[ 10000,  103.15,  1.94,  134.51,  1.49,  46.59,   4.29,  24.76,   8.08,  1.71e-06,  1.95e-06,  1.76e-06,  nan ],
	[ 12000,  103.38,  2.79,  139.21,  2.07,  45.93,   6.27,  24.42,  11.79,  2.08e-06,  1.87e-06,  1.95e-06,  nan ],
	[ 14000,  111.09,  3.53,  140.81,  2.78,  46.68,   8.40,  24.32,  16.12,  2.58e-06,  2.27e-06,  2.55e-06,  nan ],
	[ 16000,  112.26,  4.56,  139.66,  3.67,  47.13,  10.86,  23.76,  21.55,  2.62e-06,  2.59e-06,  2.59e-06,  nan ],
	[ 18000,  113.15,  5.73,  143.27,  4.52,  46.33,  13.99,  24.10,  26.88,  2.50e-06,  2.50e-06,  2.41e-06,  nan ],
	[ 20000,  116.15,  6.89,  143.68,  5.57,  46.93,  17.05,  24.47,  32.69,  2.69e-06,  2.64e-06,  2.64e-06,  nan ],
])

# numactl --interleave=all ../testing/testing_ssymv -U -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
ssymv_U = array([
	[    10,    0.01,  0.03,    0.01,  0.03,   0.01,   0.02,   0.10,   0.00,  9.54e-08,  9.54e-08,  4.77e-08,  nan ],
	[    11,    0.01,  0.03,    0.01,  0.03,   0.01,   0.02,   0.09,   0.00,  4.33e-08,  4.33e-08,  4.33e-08,  nan ],
	[    12,    0.01,  0.03,    0.01,  0.03,   0.02,   0.02,   0.15,   0.00,  1.99e-08,  1.99e-08,  3.97e-08,  nan ],
	[    13,    0.01,  0.03,    0.01,  0.03,   0.02,   0.02,   0.17,   0.00,  3.67e-08,  3.67e-08,  7.34e-08,  nan ],
	[    14,    0.02,  0.03,    0.01,  0.03,   0.02,   0.02,   0.22,   0.00,  6.81e-08,  6.81e-08,  6.81e-08,  nan ],
	[    15,    0.02,  0.03,    0.01,  0.03,   0.03,   0.02,   0.25,   0.00,  9.54e-08,  6.36e-08,  9.54e-08,  nan ],
	[    16,    0.02,  0.03,    0.02,  0.03,   0.03,   0.02,   0.18,   0.00,  2.98e-08,  2.98e-08,  5.96e-08,  nan ],
	[    17,    0.02,  0.03,    0.02,  0.04,   0.03,   0.02,   0.29,   0.00,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[    18,    0.03,  0.03,    0.02,  0.03,   0.03,   0.02,   0.24,   0.00,  5.30e-08,  7.95e-08,  7.95e-08,  nan ],
	[    19,    0.03,  0.03,    0.03,  0.03,   0.04,   0.02,   0.40,   0.00,  2.51e-08,  5.02e-08,  5.02e-08,  nan ],
	[    20,    0.03,  0.03,    0.03,  0.03,   0.04,   0.02,   0.44,   0.00,  7.15e-08,  7.15e-08,  7.15e-08,  nan ],
	[    21,    0.04,  0.03,    0.03,  0.03,   0.05,   0.02,   0.32,   0.00,  9.08e-08,  9.08e-08,  4.54e-08,  nan ],
	[    22,    0.04,  0.03,    0.04,  0.03,   0.05,   0.02,   0.53,   0.00,  4.33e-08,  8.67e-08,  8.67e-08,  nan ],
	[    23,    0.04,  0.03,    0.04,  0.03,   0.06,   0.02,   0.36,   0.00,  4.15e-08,  4.15e-08,  8.29e-08,  nan ],
	[    24,    0.04,  0.03,    0.04,  0.03,   0.07,   0.02,   0.42,   0.00,  7.95e-08,  7.95e-08,  7.95e-08,  nan ],
	[    25,    0.05,  0.03,    0.05,  0.03,   0.07,   0.02,   0.68,   0.00,  7.63e-08,  7.63e-08,  7.63e-08,  nan ],
	[    26,    0.05,  0.03,    0.05,  0.03,   0.07,   0.02,   0.49,   0.00,  1.10e-07,  1.10e-07,  1.10e-07,  nan ],
	[    27,    0.06,  0.03,    0.05,  0.03,   0.07,   0.02,   0.79,   0.00,  1.06e-07,  7.06e-08,  1.06e-07,  nan ],
	[    28,    0.06,  0.03,    0.05,  0.03,   0.08,   0.02,   0.85,   0.00,  6.81e-08,  6.81e-08,  1.02e-07,  nan ],
	[    29,    0.06,  0.03,    0.06,  0.03,   0.09,   0.02,   0.56,   0.00,  9.87e-08,  1.32e-07,  6.58e-08,  nan ],
	[    30,    0.07,  0.03,    0.06,  0.03,   0.09,   0.02,   0.87,   0.00,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[    31,    0.07,  0.03,    0.07,  0.03,   0.10,   0.02,   1.04,   0.00,  9.23e-08,  9.23e-08,  6.15e-08,  nan ],
	[    32,    0.08,  0.03,    0.07,  0.03,   0.11,   0.02,   0.68,   0.00,  5.96e-08,  5.96e-08,  8.94e-08,  nan ],
	[    33,    0.09,  0.03,    0.07,  0.03,   0.10,   0.02,   0.72,   0.00,  8.67e-08,  8.67e-08,  8.67e-08,  nan ],
	[    34,    0.09,  0.03,    0.08,  0.03,   0.10,   0.02,   0.77,   0.00,  8.41e-08,  1.12e-07,  1.12e-07,  nan ],
	[    35,    0.09,  0.03,    0.08,  0.03,   0.11,   0.02,   0.88,   0.00,  8.17e-08,  8.17e-08,  5.45e-08,  nan ],
	[    36,    0.09,  0.03,    0.09,  0.03,   0.12,   0.02,   1.24,   0.00,  7.95e-08,  1.06e-07,  7.95e-08,  nan ],
	[    37,    0.11,  0.03,    0.09,  0.03,   0.13,   0.02,   0.91,   0.00,  7.73e-08,  7.73e-08,  7.73e-08,  nan ],
	[    38,    0.10,  0.03,    0.10,  0.03,   0.14,   0.02,   0.73,   0.00,  1.00e-07,  1.00e-07,  1.00e-07,  nan ],
	[    39,    0.11,  0.03,    0.10,  0.03,   0.14,   0.02,   1.09,   0.00,  7.34e-08,  4.89e-08,  4.89e-08,  nan ],
	[    40,    0.11,  0.03,    0.11,  0.03,   0.14,   0.02,   1.06,   0.00,  9.54e-08,  7.15e-08,  9.54e-08,  nan ],
	[    41,    0.13,  0.03,    0.11,  0.03,   0.16,   0.02,   0.85,   0.00,  6.98e-08,  9.30e-08,  9.30e-08,  nan ],
	[    42,    0.13,  0.03,    0.12,  0.03,   0.16,   0.02,   1.17,   0.00,  9.08e-08,  9.08e-08,  9.08e-08,  nan ],
	[    43,    0.13,  0.03,    0.12,  0.03,   0.17,   0.02,   0.99,   0.00,  8.87e-08,  8.87e-08,  8.87e-08,  nan ],
	[    44,    0.14,  0.03,    0.13,  0.03,   0.18,   0.02,   1.28,   0.00,  1.30e-07,  1.30e-07,  1.08e-07,  nan ],
	[    45,    0.15,  0.03,    0.13,  0.03,   0.19,   0.02,   1.45,   0.00,  1.06e-07,  8.48e-08,  8.48e-08,  nan ],
	[    46,    0.17,  0.03,    0.14,  0.03,   0.19,   0.02,   1.40,   0.00,  8.29e-08,  8.29e-08,  8.29e-08,  nan ],
	[    47,    0.18,  0.02,    0.15,  0.03,   0.20,   0.02,   1.11,   0.00,  1.22e-07,  1.22e-07,  1.22e-07,  nan ],
	[    48,    0.18,  0.03,    0.16,  0.03,   0.21,   0.02,   1.16,   0.00,  7.95e-08,  1.19e-07,  1.19e-07,  nan ],
	[    49,    0.19,  0.03,    0.16,  0.03,   0.21,   0.02,   1.21,   0.00,  1.56e-07,  1.56e-07,  1.56e-07,  nan ],
	[    50,    0.20,  0.03,    0.16,  0.03,   0.21,   0.02,   1.26,   0.00,  1.14e-07,  7.63e-08,  1.14e-07,  nan ],
	[    51,    0.20,  0.03,    0.16,  0.03,   0.23,   0.02,   1.71,   0.00,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[    52,    0.22,  0.03,    0.18,  0.03,   0.25,   0.02,   1.36,   0.00,  1.10e-07,  7.34e-08,  7.34e-08,  nan ],
	[    53,    0.21,  0.03,    0.18,  0.03,   0.26,   0.02,   1.50,   0.00,  1.44e-07,  1.44e-07,  1.44e-07,  nan ],
	[    54,    0.22,  0.03,    0.18,  0.03,   0.26,   0.02,   1.56,   0.00,  1.06e-07,  1.06e-07,  1.06e-07,  nan ],
	[    55,    0.23,  0.03,    0.19,  0.03,   0.25,   0.03,   1.52,   0.00,  1.39e-07,  1.04e-07,  1.39e-07,  nan ],
	[    56,    0.23,  0.03,    0.19,  0.03,   0.27,   0.02,   1.58,   0.00,  1.36e-07,  1.36e-07,  1.02e-07,  nan ],
	[    57,    0.23,  0.03,    0.20,  0.03,   0.28,   0.02,   1.63,   0.00,  6.69e-08,  1.00e-07,  1.00e-07,  nan ],
	[    58,    0.24,  0.03,    0.21,  0.03,   0.27,   0.03,   1.69,   0.00,  1.32e-07,  9.87e-08,  1.32e-07,  nan ],
	[    59,    0.26,  0.03,    0.21,  0.03,   0.28,   0.03,   1.86,   0.00,  1.29e-07,  1.29e-07,  9.70e-08,  nan ],
	[    60,    0.25,  0.03,    0.21,  0.03,   0.30,   0.02,   1.81,   0.00,  1.27e-07,  1.27e-07,  9.54e-08,  nan ],
	[    61,    0.29,  0.03,    0.22,  0.03,   0.30,   0.03,   1.87,   0.00,  9.38e-08,  9.38e-08,  9.38e-08,  nan ],
	[    62,    0.30,  0.03,    0.22,  0.04,   0.32,   0.02,   1.93,   0.00,  1.23e-07,  1.23e-07,  1.23e-07,  nan ],
	[    63,    0.28,  0.03,    0.24,  0.03,   0.31,   0.03,   1.99,   0.00,  1.51e-07,  9.08e-08,  1.21e-07,  nan ],
	[    64,    0.26,  0.03,    0.25,  0.03,   0.33,   0.03,   2.05,   0.00,  8.94e-08,  8.94e-08,  8.94e-08,  nan ],
	[    65,    0.27,  0.03,    0.20,  0.04,   0.34,   0.03,   1.71,   0.01,  1.17e-07,  8.80e-08,  1.17e-07,  nan ],
	[    66,    0.29,  0.03,    0.21,  0.04,   0.34,   0.03,   1.77,   0.01,  1.73e-07,  1.44e-07,  1.16e-07,  nan ],
	[    67,    0.29,  0.03,    0.22,  0.04,   0.35,   0.03,   2.25,   0.00,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[    68,    0.30,  0.03,    0.23,  0.04,   0.37,   0.03,   2.32,   0.00,  1.40e-07,  1.12e-07,  1.12e-07,  nan ],
	[    69,    0.28,  0.03,    0.24,  0.04,   0.37,   0.03,   2.03,   0.00,  1.38e-07,  1.11e-07,  1.11e-07,  nan ],
	[    70,    0.32,  0.03,    0.24,  0.04,   0.40,   0.03,   2.61,   0.00,  1.09e-07,  1.09e-07,  1.09e-07,  nan ],
	[    71,    0.32,  0.03,    0.25,  0.04,   0.39,   0.03,   2.04,   0.01,  1.34e-07,  1.61e-07,  1.34e-07,  nan ],
	[    72,    0.32,  0.03,    0.26,  0.04,   0.40,   0.03,   2.59,   0.00,  1.59e-07,  1.32e-07,  1.32e-07,  nan ],
	[    73,    0.33,  0.03,    0.26,  0.04,   0.43,   0.03,   2.67,   0.00,  1.57e-07,  1.05e-07,  1.31e-07,  nan ],
	[    74,    0.36,  0.03,    0.26,  0.04,   0.41,   0.03,   2.22,   0.01,  1.80e-07,  1.03e-07,  1.29e-07,  nan ],
	[    75,    0.38,  0.03,    0.28,  0.04,   0.47,   0.02,   2.28,   0.01,  1.53e-07,  1.02e-07,  1.02e-07,  nan ],
	[    76,    0.39,  0.03,    0.29,  0.04,   0.49,   0.02,   2.34,   0.01,  1.00e-07,  1.00e-07,  1.51e-07,  nan ],
	[    77,    0.40,  0.03,    0.31,  0.04,   0.50,   0.02,   2.40,   0.01,  1.49e-07,  1.49e-07,  1.49e-07,  nan ],
	[    78,    0.41,  0.03,    0.32,  0.04,   0.50,   0.02,   2.46,   0.01,  1.22e-07,  9.78e-08,  9.78e-08,  nan ],
	[    79,    0.42,  0.03,    0.31,  0.04,   0.50,   0.03,   2.52,   0.01,  1.45e-07,  1.45e-07,  1.45e-07,  nan ],
	[    80,    0.42,  0.03,    0.32,  0.04,   0.54,   0.02,   2.59,   0.01,  1.43e-07,  1.43e-07,  1.43e-07,  nan ],
	[    81,    0.43,  0.03,    0.33,  0.04,   0.53,   0.03,   2.65,   0.01,  1.41e-07,  9.42e-08,  1.18e-07,  nan ],
	[    82,    0.44,  0.03,    0.34,  0.04,   0.54,   0.03,   2.28,   0.01,  1.63e-07,  1.40e-07,  9.30e-08,  nan ],
	[    83,    0.46,  0.03,    0.34,  0.04,   0.58,   0.02,   2.34,   0.01,  1.38e-07,  1.38e-07,  1.15e-07,  nan ],
	[    84,    0.48,  0.03,    0.36,  0.04,   0.55,   0.03,   2.85,   0.01,  1.82e-07,  1.82e-07,  1.82e-07,  nan ],
	[    85,    0.46,  0.03,    0.36,  0.04,   0.58,   0.03,   2.92,   0.01,  1.35e-07,  1.57e-07,  1.35e-07,  nan ],
	[    86,    0.47,  0.03,    0.36,  0.04,   0.60,   0.03,   2.99,   0.01,  1.33e-07,  1.33e-07,  1.33e-07,  nan ],
	[    87,    0.48,  0.03,    0.37,  0.04,   0.59,   0.03,   3.06,   0.01,  1.75e-07,  1.32e-07,  1.32e-07,  nan ],
	[    88,    0.49,  0.03,    0.38,  0.04,   0.58,   0.03,   2.63,   0.01,  1.30e-07,  1.30e-07,  1.73e-07,  nan ],
	[    89,    0.50,  0.03,    0.40,  0.04,   0.62,   0.03,   2.69,   0.01,  1.71e-07,  1.71e-07,  1.71e-07,  nan ],
	[    90,    0.51,  0.03,    0.39,  0.04,   0.63,   0.03,   3.27,   0.01,  1.27e-07,  1.27e-07,  1.27e-07,  nan ],
	[   100,    0.65,  0.03,    0.49,  0.04,   0.69,   0.03,   3.26,   0.01,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[   110,    0.74,  0.03,    0.60,  0.04,   0.85,   0.03,   3.41,   0.01,  1.73e-07,  2.08e-07,  1.73e-07,  nan ],
	[   120,    0.85,  0.03,    0.71,  0.04,   0.97,   0.03,   3.58,   0.01,  1.91e-07,  1.59e-07,  1.91e-07,  nan ],
	[   130,    0.90,  0.04,    0.79,  0.04,   1.07,   0.03,   4.20,   0.01,  2.35e-07,  1.76e-07,  1.76e-07,  nan ],
	[   140,    0.99,  0.04,    0.92,  0.04,   1.19,   0.03,   4.48,   0.01,  1.63e-07,  1.91e-07,  1.91e-07,  nan ],
	[   150,    1.22,  0.04,    1.06,  0.04,   1.37,   0.03,   5.76,   0.01,  1.78e-07,  2.03e-07,  1.78e-07,  nan ],
	[   160,    1.39,  0.04,    1.17,  0.04,   1.61,   0.03,   5.69,   0.01,  1.91e-07,  1.91e-07,  2.15e-07,  nan ],
	[   170,    1.49,  0.04,    1.32,  0.04,   1.72,   0.03,   6.42,   0.01,  2.24e-07,  2.24e-07,  1.80e-07,  nan ],
	[   180,    1.81,  0.04,    1.51,  0.04,   1.97,   0.03,   8.28,   0.01,  1.70e-07,  1.48e-07,  1.48e-07,  nan ],
	[   190,    1.96,  0.04,    1.65,  0.04,   2.21,   0.03,   6.62,   0.01,  3.21e-07,  2.81e-07,  2.41e-07,  nan ],
	[   200,    1.87,  0.04,    1.82,  0.04,   2.36,   0.03,   8.03,   0.01,  2.29e-07,  2.29e-07,  2.29e-07,  nan ],
	[   210,    1.97,  0.05,    1.97,  0.05,   2.40,   0.04,   8.08,   0.01,  2.54e-07,  2.91e-07,  2.54e-07,  nan ],
	[   220,    2.17,  0.04,    2.17,  0.04,   2.70,   0.04,   8.87,   0.01,  2.77e-07,  2.77e-07,  2.43e-07,  nan ],
	[   230,    2.41,  0.04,    2.36,  0.05,   2.88,   0.04,   8.91,   0.01,  3.32e-07,  2.65e-07,  2.99e-07,  nan ],
	[   240,    2.58,  0.04,    2.51,  0.05,   3.13,   0.04,   9.51,   0.01,  2.23e-07,  2.54e-07,  2.54e-07,  nan ],
	[   250,    2.80,  0.04,    2.79,  0.05,   3.29,   0.04,   8.36,   0.02,  2.14e-07,  2.14e-07,  2.14e-07,  nan ],
	[   260,    2.83,  0.05,    2.95,  0.05,   3.47,   0.04,   4.13,   0.03,  2.93e-07,  2.93e-07,  2.93e-07,  nan ],
	[   270,    3.04,  0.05,    3.26,  0.04,   3.84,   0.04,   4.58,   0.03,  2.83e-07,  2.83e-07,  2.83e-07,  nan ],
	[   280,    3.28,  0.05,    3.35,  0.05,   3.93,   0.04,   4.62,   0.03,  3.00e-07,  2.72e-07,  2.45e-07,  nan ],
	[   290,    3.50,  0.05,    3.59,  0.05,   4.02,   0.04,   4.14,   0.04,  2.63e-07,  2.37e-07,  2.37e-07,  nan ],
	[   300,    3.70,  0.05,    3.85,  0.05,   4.30,   0.04,   5.02,   0.04,  3.31e-07,  3.56e-07,  3.05e-07,  nan ],
	[   310,    4.00,  0.05,    4.11,  0.05,   4.70,   0.04,   4.60,   0.04,  2.71e-07,  2.95e-07,  3.20e-07,  nan ],
	[   320,    4.29,  0.05,    4.46,  0.05,   4.90,   0.04,   4.90,   0.04,  3.34e-07,  3.10e-07,  3.10e-07,  nan ],
	[   330,    4.20,  0.05,    4.54,  0.05,   5.21,   0.04,   4.85,   0.05,  2.54e-07,  2.77e-07,  3.01e-07,  nan ],
	[   340,    4.30,  0.05,    4.84,  0.05,   5.26,   0.04,   5.15,   0.05,  3.59e-07,  2.69e-07,  3.59e-07,  nan ],
	[   350,    4.46,  0.06,    5.10,  0.05,   5.60,   0.04,   5.03,   0.05,  2.83e-07,  2.62e-07,  2.62e-07,  nan ],
	[   360,    4.64,  0.06,    5.29,  0.05,   5.65,   0.05,   4.91,   0.05,  2.97e-07,  2.54e-07,  2.97e-07,  nan ],
	[   370,    5.28,  0.05,    5.62,  0.05,   6.22,   0.04,   5.19,   0.05,  2.89e-07,  2.47e-07,  2.47e-07,  nan ],
	[   380,    5.17,  0.06,    5.78,  0.05,   6.43,   0.05,   5.08,   0.06,  4.02e-07,  3.21e-07,  3.61e-07,  nan ],
	[   390,    5.02,  0.06,    6.09,  0.05,   6.49,   0.05,   7.44,   0.04,  3.13e-07,  3.52e-07,  3.13e-07,  nan ],
	[   400,    3.49,  0.09,    6.44,  0.05,   6.83,   0.05,   8.06,   0.04,  3.43e-07,  2.67e-07,  3.05e-07,  nan ],
	[   410,    5.79,  0.06,    6.73,  0.05,   7.32,   0.05,   7.85,   0.04,  4.09e-07,  4.09e-07,  4.47e-07,  nan ],
	[   420,    5.79,  0.06,    6.93,  0.05,   6.80,   0.05,   7.69,   0.05,  3.27e-07,  3.27e-07,  3.27e-07,  nan ],
	[   430,    6.19,  0.06,    7.40,  0.05,   7.58,   0.05,   7.40,   0.05,  3.55e-07,  3.90e-07,  3.90e-07,  nan ],
	[   440,    6.56,  0.06,    7.61,  0.05,   7.90,   0.05,   7.43,   0.05,  3.81e-07,  3.47e-07,  3.47e-07,  nan ],
	[   450,    6.45,  0.06,    8.30,  0.05,   8.26,   0.05,   7.24,   0.06,  3.73e-07,  4.07e-07,  3.73e-07,  nan ],
	[   460,    6.52,  0.07,    8.31,  0.05,   8.31,   0.05,   7.57,   0.06,  3.32e-07,  3.65e-07,  3.65e-07,  nan ],
	[   470,    6.83,  0.06,    8.52,  0.05,   8.52,   0.05,   7.25,   0.06,  4.55e-07,  3.57e-07,  3.90e-07,  nan ],
	[   480,    7.23,  0.06,    9.05,  0.05,   9.27,   0.05,   7.45,   0.06,  3.18e-07,  3.50e-07,  3.18e-07,  nan ],
	[   490,    7.08,  0.07,    9.05,  0.05,   9.09,   0.05,   6.77,   0.07,  4.36e-07,  4.05e-07,  4.36e-07,  nan ],
	[   500,    7.84,  0.06,    9.47,  0.05,   9.26,   0.05,   7.25,   0.07,  3.97e-07,  4.27e-07,  3.97e-07,  nan ],
	[   510,    7.67,  0.07,    9.63,  0.05,   9.30,   0.06,   6.85,   0.08,  4.19e-07,  3.59e-07,  3.59e-07,  nan ],
	[   520,    7.63,  0.07,   10.42,  0.05,   9.67,   0.06,  10.62,   0.05,  3.52e-07,  3.81e-07,  3.81e-07,  nan ],
	[   530,    8.14,  0.07,   11.03,  0.05,   9.88,   0.06,  10.45,   0.05,  4.89e-07,  4.89e-07,  4.89e-07,  nan ],
	[   540,    8.48,  0.07,   11.04,  0.05,   9.88,   0.06,  10.61,   0.06,  3.96e-07,  3.67e-07,  4.24e-07,  nan ],
	[   550,    7.99,  0.08,   10.64,  0.06,   9.45,   0.06,   9.78,   0.06,  4.44e-07,  4.72e-07,  4.44e-07,  nan ],
	[   560,    8.73,  0.07,   11.41,  0.06,  10.29,   0.06,  10.10,   0.06,  4.36e-07,  4.09e-07,  3.81e-07,  nan ],
	[   570,    9.04,  0.07,   12.03,  0.05,  10.50,   0.06,   9.72,   0.07,  3.75e-07,  3.75e-07,  3.21e-07,  nan ],
	[   580,    9.09,  0.07,   11.83,  0.06,  10.35,   0.07,   9.61,   0.07,  3.95e-07,  3.95e-07,  3.68e-07,  nan ],
	[   590,    9.29,  0.08,   12.94,  0.05,  10.91,   0.06,   8.63,   0.08,  3.62e-07,  4.14e-07,  3.62e-07,  nan ],
	[   600,    9.89,  0.07,   13.15,  0.05,  11.41,   0.06,   8.59,   0.08,  3.81e-07,  3.81e-07,  4.58e-07,  nan ],
	[   610,    9.42,  0.08,   13.08,  0.06,  11.29,   0.07,   7.76,   0.10,  3.75e-07,  3.75e-07,  3.25e-07,  nan ],
	[   620,   10.25,  0.08,   13.51,  0.06,  11.83,   0.07,   8.37,   0.09,  4.18e-07,  3.45e-07,  3.94e-07,  nan ],
	[   630,   10.32,  0.08,   13.72,  0.06,  11.83,   0.07,   8.19,   0.10,  3.88e-07,  4.12e-07,  3.88e-07,  nan ],
	[   640,   10.92,  0.08,   14.40,  0.06,  12.42,   0.07,  11.40,   0.07,  3.58e-07,  4.05e-07,  3.58e-07,  nan ],
	[   650,   10.32,  0.08,   14.37,  0.06,  12.24,   0.07,  11.91,   0.07,  4.46e-07,  4.46e-07,  4.46e-07,  nan ],
	[   660,   10.64,  0.08,   14.58,  0.06,  12.84,   0.07,  12.28,   0.07,  3.70e-07,  3.70e-07,  3.70e-07,  nan ],
	[   670,   10.96,  0.08,   15.21,  0.06,  12.83,   0.07,  11.97,   0.08,  3.64e-07,  3.87e-07,  3.64e-07,  nan ],
	[   680,   11.33,  0.08,   15.42,  0.06,  13.21,   0.07,  12.03,   0.08,  3.59e-07,  3.59e-07,  3.59e-07,  nan ],
	[   690,   11.49,  0.08,   16.13,  0.06,  13.60,   0.07,  11.76,   0.08,  3.98e-07,  3.10e-07,  3.54e-07,  nan ],
	[   700,   11.53,  0.09,   16.08,  0.06,  13.63,   0.07,  11.83,   0.08,  3.71e-07,  3.92e-07,  3.71e-07,  nan ],
	[   710,   11.32,  0.09,   16.54,  0.06,  13.66,   0.07,  11.23,   0.09,  4.30e-07,  4.73e-07,  5.16e-07,  nan ],
	[   720,   12.06,  0.09,   17.08,  0.06,  14.23,   0.07,  11.17,   0.09,  3.81e-07,  4.24e-07,  3.81e-07,  nan ],
	[   730,   12.00,  0.09,   17.83,  0.06,  14.39,   0.07,  11.00,   0.10,  4.18e-07,  4.18e-07,  4.60e-07,  nan ],
	[   740,   11.79,  0.09,   17.97,  0.06,  14.24,   0.08,  10.75,   0.10,  4.54e-07,  4.12e-07,  4.54e-07,  nan ],
	[   750,   12.12,  0.09,   18.75,  0.06,  14.81,   0.08,  10.94,   0.10,  4.48e-07,  4.48e-07,  4.48e-07,  nan ],
	[   760,   12.04,  0.10,   18.38,  0.06,  15.02,   0.08,  10.32,   0.11,  4.42e-07,  4.42e-07,  4.42e-07,  nan ],
	[   770,   12.36,  0.10,   19.15,  0.06,  15.42,   0.08,  13.21,   0.09,  4.76e-07,  4.36e-07,  4.36e-07,  nan ],
	[   780,   12.31,  0.10,   19.65,  0.06,  15.63,   0.08,  12.97,   0.09,  5.48e-07,  5.09e-07,  5.09e-07,  nan ],
	[   790,   12.75,  0.10,   20.48,  0.06,  16.23,   0.08,  14.36,   0.09,  4.64e-07,  4.64e-07,  3.86e-07,  nan ],
	[   800,   12.83,  0.10,   20.36,  0.06,  16.44,   0.08,  13.75,   0.09,  4.96e-07,  5.72e-07,  5.34e-07,  nan ],
	[   810,   13.41,  0.10,   20.79,  0.06,  16.60,   0.08,  13.81,   0.10,  5.27e-07,  6.40e-07,  5.65e-07,  nan ],
	[   820,   13.32,  0.10,   20.69,  0.07,  16.66,   0.08,  14.01,   0.10,  5.58e-07,  5.21e-07,  5.21e-07,  nan ],
	[   830,   13.68,  0.10,   21.51,  0.06,  17.02,   0.08,  13.27,   0.10,  5.88e-07,  5.52e-07,  5.52e-07,  nan ],
	[   840,   13.44,  0.11,   22.11,  0.06,  17.03,   0.08,  13.59,   0.10,  7.27e-07,  6.90e-07,  6.90e-07,  nan ],
	[   850,   13.39,  0.11,   22.23,  0.07,  17.24,   0.08,  12.83,   0.11,  5.03e-07,  4.67e-07,  5.39e-07,  nan ],
	[   860,   13.86,  0.11,   22.42,  0.07,  17.65,   0.08,  12.75,   0.12,  5.68e-07,  5.68e-07,  5.68e-07,  nan ],
	[   870,   14.19,  0.11,   23.37,  0.06,  17.61,   0.09,  12.87,   0.12,  5.96e-07,  5.61e-07,  5.61e-07,  nan ],
	[   880,   14.23,  0.11,   23.48,  0.07,  18.02,   0.09,  12.29,   0.13,  4.86e-07,  4.86e-07,  4.86e-07,  nan ],
	[   890,   14.56,  0.11,   24.01,  0.07,  18.48,   0.09,  12.18,   0.13,  5.83e-07,  5.83e-07,  5.49e-07,  nan ],
	[   900,   14.35,  0.11,   24.21,  0.07,  18.43,   0.09,  15.15,   0.11,  5.09e-07,  5.09e-07,  5.09e-07,  nan ],
	[  1000,   16.40,  0.12,   27.80,  0.07,  20.23,   0.10,  14.11,   0.14,  5.80e-07,  5.80e-07,  5.49e-07,  nan ],
	[  1100,   17.67,  0.14,   29.19,  0.08,  21.80,   0.11,  15.92,   0.15,  5.83e-07,  5.83e-07,  5.83e-07,  nan ],
	[  1200,   20.15,  0.14,   34.74,  0.08,  24.42,   0.12,  17.47,   0.16,  5.59e-07,  5.59e-07,  5.85e-07,  nan ],
	[  1300,   21.96,  0.15,   39.85,  0.08,  26.67,   0.13,  17.07,   0.20,  5.63e-07,  5.87e-07,  6.34e-07,  nan ],
	[  1400,   24.09,  0.16,   42.74,  0.09,  29.28,   0.13,  16.42,   0.24,  6.54e-07,  6.98e-07,  6.10e-07,  nan ],
	[  1500,   25.87,  0.17,   47.34,  0.10,  30.46,   0.15,  17.67,   0.25,  7.32e-07,  6.10e-07,  6.51e-07,  nan ],
	[  1600,   27.83,  0.18,   49.74,  0.10,  32.41,   0.16,  18.83,   0.27,  8.77e-07,  8.01e-07,  8.39e-07,  nan ],
	[  1700,   29.51,  0.20,   57.76,  0.10,  34.65,   0.17,  19.09,   0.30,  7.90e-07,  7.90e-07,  7.54e-07,  nan ],
	[  1800,   31.29,  0.21,   60.03,  0.11,  36.45,   0.18,  19.65,   0.33,  9.16e-07,  8.82e-07,  8.82e-07,  nan ],
	[  1900,   32.97,  0.22,   60.24,  0.12,  38.65,   0.19,  18.61,   0.39,  8.35e-07,  7.71e-07,  8.03e-07,  nan ],
	[  2000,   34.05,  0.24,   61.15,  0.13,  38.63,   0.21,  21.01,   0.38,  8.85e-07,  9.16e-07,  8.54e-07,  nan ],
	[  2100,   36.29,  0.24,   60.48,  0.15,  24.79,   0.36,  19.96,   0.44,  1.02e-06,  1.08e-06,  1.02e-06,  nan ],
	[  2200,   37.68,  0.26,   64.99,  0.15,  26.10,   0.37,  19.68,   0.49,  8.60e-07,  8.60e-07,  8.32e-07,  nan ],
	[  2300,   40.10,  0.26,   63.79,  0.17,  26.33,   0.40,  20.39,   0.52,  8.49e-07,  9.02e-07,  9.02e-07,  nan ],
	[  2400,   41.14,  0.28,   70.36,  0.16,  27.51,   0.42,  21.58,   0.53,  8.65e-07,  8.39e-07,  8.65e-07,  nan ],
	[  2500,   42.54,  0.29,   71.46,  0.17,  28.68,   0.44,  21.56,   0.58,  8.30e-07,  8.79e-07,  8.54e-07,  nan ],
	[  2600,   44.35,  0.30,   74.35,  0.18,  29.53,   0.46,  22.85,   0.59,  7.98e-07,  7.51e-07,  7.75e-07,  nan ],
	[  2700,   45.42,  0.32,   76.37,  0.19,  30.57,   0.48,  22.90,   0.64,  9.27e-07,  8.59e-07,  8.36e-07,  nan ],
	[  2800,   47.99,  0.33,   78.41,  0.20,  31.55,   0.50,  22.83,   0.69,  9.81e-07,  9.81e-07,  9.81e-07,  nan ],
	[  2900,   48.77,  0.34,   81.68,  0.21,  32.60,   0.52,  23.93,   0.70,  1.05e-06,  1.09e-06,  1.14e-06,  nan ],
	[  3000,   50.72,  0.36,   82.99,  0.22,  34.03,   0.53,  24.17,   0.75,  1.10e-06,  9.77e-07,  9.36e-07,  nan ],
	[  3100,   53.12,  0.36,   84.35,  0.23,  34.70,   0.55,  24.80,   0.78,  1.10e-06,  1.14e-06,  1.14e-06,  nan ],
	[  3200,   54.31,  0.38,   85.33,  0.24,  36.07,   0.57,  24.36,   0.84,  1.07e-06,  1.14e-06,  1.07e-06,  nan ],
	[  3300,   56.30,  0.39,   91.56,  0.24,  37.06,   0.59,  24.68,   0.88,  1.18e-06,  1.26e-06,  1.18e-06,  nan ],
	[  3400,   57.40,  0.40,   91.77,  0.25,  37.91,   0.61,  23.82,   0.97,  1.11e-06,  1.18e-06,  1.11e-06,  nan ],
	[  3500,   59.94,  0.41,   93.87,  0.26,  38.91,   0.63,  23.74,   1.03,  1.15e-06,  1.08e-06,  1.12e-06,  nan ],
	[  3600,   60.72,  0.43,   97.88,  0.26,  40.01,   0.65,  25.44,   1.02,  1.19e-06,  1.19e-06,  1.29e-06,  nan ],
	[  3700,   61.96,  0.44,   97.18,  0.28,  41.07,   0.67,  24.52,   1.12,  1.19e-06,  1.19e-06,  1.12e-06,  nan ],
	[  3800,   63.60,  0.45,  100.63,  0.29,  42.23,   0.68,  24.80,   1.16,  1.41e-06,  1.41e-06,  1.35e-06,  nan ],
	[  3900,   65.58,  0.46,   98.47,  0.31,  43.35,   0.70,  24.34,   1.25,  1.22e-06,  1.19e-06,  1.28e-06,  nan ],
	[  4000,   66.40,  0.48,  100.94,  0.32,  44.40,   0.72,  21.00,   1.52,  1.53e-06,  1.28e-06,  1.34e-06,  nan ],
	[  4100,   66.34,  0.51,   92.13,  0.37,  34.18,   0.98,  24.13,   1.39,  1.40e-06,  1.37e-06,  1.31e-06,  nan ],
	[  4200,   69.46,  0.51,  101.45,  0.35,  33.32,   1.06,  22.22,   1.59,  1.31e-06,  1.34e-06,  1.34e-06,  nan ],
	[  4300,   69.95,  0.53,  102.20,  0.36,  33.84,   1.09,  23.09,   1.60,  1.42e-06,  1.50e-06,  1.48e-06,  nan ],
	[  4400,   72.81,  0.53,  104.40,  0.37,  34.90,   1.11,  23.53,   1.65,  1.28e-06,  1.28e-06,  1.28e-06,  nan ],
	[  4500,   73.14,  0.55,  105.21,  0.39,  35.60,   1.14,  23.46,   1.73,  1.36e-06,  1.36e-06,  1.41e-06,  nan ],
	[  4600,   74.01,  0.57,  102.98,  0.41,  36.21,   1.17,  23.79,   1.78,  1.17e-06,  1.25e-06,  1.25e-06,  nan ],
	[  4700,   76.05,  0.58,  107.01,  0.41,  36.89,   1.20,  23.95,   1.84,  1.45e-06,  1.43e-06,  1.45e-06,  nan ],
	[  4800,   76.56,  0.60,  105.00,  0.44,  37.57,   1.23,  24.53,   1.88,  1.55e-06,  1.60e-06,  1.55e-06,  nan ],
	[  4900,   77.84,  0.62,  107.90,  0.45,  38.39,   1.25,  24.69,   1.95,  1.42e-06,  1.49e-06,  1.42e-06,  nan ],
	[  5000,   79.00,  0.63,  108.29,  0.46,  39.38,   1.27,  23.94,   2.09,  1.37e-06,  1.42e-06,  1.46e-06,  nan ],
	[  5100,   79.82,  0.65,  111.40,  0.47,  40.02,   1.30,  24.84,   2.09,  1.39e-06,  1.39e-06,  1.39e-06,  nan ],
	[  5200,   81.84,  0.66,  112.20,  0.48,  40.85,   1.32,  24.73,   2.19,  1.39e-06,  1.39e-06,  1.39e-06,  nan ],
	[  5300,   82.75,  0.68,  113.31,  0.50,  41.65,   1.35,  24.94,   2.25,  1.57e-06,  1.36e-06,  1.40e-06,  nan ],
	[  5400,   83.93,  0.69,  114.38,  0.51,  41.99,   1.39,  26.03,   2.24,  1.51e-06,  1.51e-06,  1.60e-06,  nan ],
	[  5500,   84.74,  0.71,  108.28,  0.56,  43.13,   1.40,  24.22,   2.50,  1.27e-06,  1.31e-06,  1.31e-06,  nan ],
	[  5600,   86.41,  0.73,  116.16,  0.54,  43.53,   1.44,  24.78,   2.53,  1.48e-06,  1.48e-06,  1.44e-06,  nan ],
	[  5700,   87.48,  0.74,  118.42,  0.55,  43.97,   1.48,  25.09,   2.59,  1.54e-06,  1.41e-06,  1.50e-06,  nan ],
	[  5800,   88.31,  0.76,  118.04,  0.57,  44.56,   1.51,  24.76,   2.72,  1.56e-06,  1.56e-06,  1.47e-06,  nan ],
	[  5900,   89.73,  0.78,  116.26,  0.60,  45.42,   1.53,  25.06,   2.78,  1.45e-06,  1.49e-06,  1.53e-06,  nan ],
	[  6000,   91.25,  0.79,  115.37,  0.62,  46.10,   1.56,  25.12,   2.87,  1.79e-06,  1.83e-06,  1.79e-06,  nan ],
	[  6100,   91.44,  0.81,  117.23,  0.63,  46.52,   1.60,  25.42,   2.93,  1.60e-06,  1.56e-06,  1.60e-06,  nan ],
	[  6200,   93.32,  0.82,  118.48,  0.65,  36.76,   2.09,  25.32,   3.04,  1.73e-06,  1.69e-06,  1.65e-06,  nan ],
	[  6300,   94.07,  0.84,  119.05,  0.67,  38.21,   2.08,  25.63,   3.10,  1.78e-06,  1.59e-06,  1.67e-06,  nan ],
	[  6400,   95.97,  0.85,  118.58,  0.69,  38.67,   2.12,  25.90,   3.16,  1.87e-06,  1.95e-06,  1.87e-06,  nan ],
	[  6500,   94.32,  0.90,  120.36,  0.70,  39.05,   2.16,  25.85,   3.27,  1.73e-06,  1.92e-06,  1.84e-06,  nan ],
	[  6600,   97.25,  0.90,  120.38,  0.72,  39.77,   2.19,  26.26,   3.32,  1.89e-06,  1.89e-06,  1.89e-06,  nan ],
	[  6700,   98.80,  0.91,  122.32,  0.73,  40.10,   2.24,  25.99,   3.45,  1.71e-06,  1.60e-06,  1.64e-06,  nan ],
	[  6800,   98.49,  0.94,  121.58,  0.76,  39.37,   2.35,  26.90,   3.44,  1.72e-06,  1.72e-06,  1.76e-06,  nan ],
	[  6900,  101.43,  0.94,  122.26,  0.78,  40.98,   2.32,  26.12,   3.65,  1.56e-06,  1.63e-06,  1.63e-06,  nan ],
	[  7000,  100.54,  0.97,  123.01,  0.80,  42.17,   2.32,  26.21,   3.74,  1.74e-06,  1.74e-06,  1.67e-06,  nan ],
	[  7100,  103.94,  0.97,  122.55,  0.82,  42.63,   2.37,  25.74,   3.92,  1.82e-06,  1.79e-06,  1.65e-06,  nan ],
	[  7200,  103.70,  1.00,  125.66,  0.83,  42.65,   2.43,  25.51,   4.06,  1.86e-06,  1.86e-06,  1.83e-06,  nan ],
	[  7300,  105.65,  1.01,  124.82,  0.85,  43.17,   2.47,  26.50,   4.02,  1.74e-06,  1.81e-06,  1.91e-06,  nan ],
	[  7400,  104.11,  1.05,  126.18,  0.87,  44.10,   2.48,  26.01,   4.21,  1.78e-06,  1.81e-06,  1.85e-06,  nan ],
	[  7500,  107.47,  1.05,  126.42,  0.89,  43.80,   2.57,  26.59,   4.23,  1.86e-06,  1.92e-06,  1.82e-06,  nan ],
	[  7600,  108.39,  1.07,  127.79,  0.90,  45.15,   2.56,  26.66,   4.33,  1.61e-06,  1.57e-06,  1.61e-06,  nan ],
	[  7700,  107.23,  1.11,  127.68,  0.93,  45.18,   2.62,  26.72,   4.44,  2.03e-06,  1.97e-06,  2.03e-06,  nan ],
	[  7800,  109.23,  1.11,  125.07,  0.97,  45.84,   2.66,  26.85,   4.53,  1.82e-06,  1.82e-06,  1.88e-06,  nan ],
	[  7900,  106.97,  1.17,  127.64,  0.98,  46.55,   2.68,  26.89,   4.64,  1.82e-06,  1.92e-06,  1.82e-06,  nan ],
	[  8000,  107.41,  1.19,  124.06,  1.03,  47.13,   2.72,  26.94,   4.75,  1.95e-06,  1.92e-06,  1.95e-06,  nan ],
	[  8100,  107.32,  1.22,  129.15,  1.02,  47.45,   2.77,  26.56,   4.94,  1.87e-06,  1.90e-06,  1.96e-06,  nan ],
	[  8200,  107.08,  1.26,  129.21,  1.04,  41.00,   3.28,  26.50,   5.07,  1.79e-06,  1.79e-06,  1.73e-06,  nan ],
	[  8300,  106.65,  1.29,  127.81,  1.08,  40.33,   3.42,  25.98,   5.30,  2.35e-06,  2.32e-06,  2.26e-06,  nan ],
	[  8400,  104.77,  1.35,  128.08,  1.10,  40.74,   3.46,  26.65,   5.30,  1.83e-06,  1.80e-06,  1.80e-06,  nan ],
	[  8500,  106.42,  1.36,  128.56,  1.12,  41.24,   3.50,  26.93,   5.37,  2.01e-06,  2.13e-06,  2.07e-06,  nan ],
	[  8600,  104.55,  1.42,  130.22,  1.14,  41.71,   3.55,  27.36,   5.41,  1.73e-06,  1.70e-06,  1.73e-06,  nan ],
	[  8700,  104.70,  1.45,  129.83,  1.17,  42.03,   3.60,  27.42,   5.52,  1.96e-06,  1.99e-06,  1.91e-06,  nan ],
	[  8800,  103.13,  1.50,  129.94,  1.19,  41.57,   3.73,  27.05,   5.73,  1.97e-06,  1.91e-06,  1.97e-06,  nan ],
	[  8900,  103.49,  1.53,  129.56,  1.22,  42.71,   3.71,  27.50,   5.76,  1.92e-06,  1.89e-06,  1.89e-06,  nan ],
	[  9000,  104.74,  1.55,  129.71,  1.25,  42.53,   3.81,  27.66,   5.86,  2.12e-06,  1.95e-06,  1.98e-06,  nan ],
	[ 10000,  103.25,  1.94,  131.85,  1.52,  47.52,   4.21,  27.63,   7.24,  2.32e-06,  2.34e-06,  2.37e-06,  nan ],
	[ 12000,  104.28,  2.76,  138.14,  2.08,  46.86,   6.15,  28.20,  10.21,  2.20e-06,  2.36e-06,  2.24e-06,  nan ],
	[ 14000,  110.00,  3.56,  140.47,  2.79,  47.26,   8.30,  28.60,  13.71,  2.69e-06,  2.86e-06,  2.93e-06,  nan ],
	[ 16000,  111.32,  4.60,  140.06,  3.66,  46.57,  10.99,  28.70,  17.84,  2.72e-06,  2.69e-06,  2.66e-06,  nan ],
	[ 18000,  108.82,  5.95,  144.85,  4.47,  47.66,  13.60,  29.10,  22.27,  2.63e-06,  2.77e-06,  2.63e-06,  nan ],
	[ 20000,  110.59,  7.23,  146.55,  5.46,  48.07,  16.64,  29.69,  26.94,  2.93e-06,  2.95e-06,  3.03e-06,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/zgeqrf.txt
# numactl --interleave=all ../testing/testing_zgeqrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeqrf = array([
	[    10,     10,  nan,  nan,     0.03,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.20,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.60,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.67,   0.00,  nan ],
	[    50,     50,  nan,  nan,     1.19,   0.00,  nan ],
	[    60,     60,  nan,  nan,     1.82,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.67,   0.00,  nan ],
	[    80,     80,  nan,  nan,     2.33,   0.00,  nan ],
	[    90,     90,  nan,  nan,     3.05,   0.00,  nan ],
	[   100,    100,  nan,  nan,     4.02,   0.00,  nan ],
	[   200,    200,  nan,  nan,    13.25,   0.00,  nan ],
	[   300,    300,  nan,  nan,    28.80,   0.01,  nan ],
	[   400,    400,  nan,  nan,    45.63,   0.01,  nan ],
	[   500,    500,  nan,  nan,    64.89,   0.01,  nan ],
	[   600,    600,  nan,  nan,    83.71,   0.01,  nan ],
	[   700,    700,  nan,  nan,   104.84,   0.02,  nan ],
	[   800,    800,  nan,  nan,   124.62,   0.02,  nan ],
	[   900,    900,  nan,  nan,   142.89,   0.03,  nan ],
	[  1000,   1000,  nan,  nan,   166.61,   0.03,  nan ],
	[  2000,   2000,  nan,  nan,   392.27,   0.11,  nan ],
	[  3000,   3000,  nan,  nan,   617.21,   0.23,  nan ],
	[  4000,   4000,  nan,  nan,   752.86,   0.45,  nan ],
	[  5000,   5000,  nan,  nan,   843.50,   0.79,  nan ],
	[  6000,   6000,  nan,  nan,   919.89,   1.25,  nan ],
	[  7000,   7000,  nan,  nan,   963.62,   1.90,  nan ],
	[  8000,   8000,  nan,  nan,  1001.74,   2.73,  nan ],
	[  9000,   9000,  nan,  nan,  1013.66,   3.84,  nan ],
	[ 10000,  10000,  nan,  nan,  1025.90,   5.20,  nan ],
	[ 12000,  12000,  nan,  nan,  1060.31,   8.69,  nan ],
	[ 14000,  14000,  nan,  nan,  1065.46,  13.74,  nan ],
	[ 16000,  16000,  nan,  nan,  1086.57,  20.11,  nan ],
	[ 18000,  18000,  nan,  nan,  1052.68,  29.55,  nan ],
	[ 20000,  20000,  nan,  nan,  1086.37,  39.28,  nan ],
])

# numactl --interleave=all ../testing/testing_zgeqrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.00,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.04,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.12,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.27,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.50,   0.00,  nan ],
	[    60,     60,  nan,  nan,     0.81,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.87,   0.00,  nan ],
	[    80,     80,  nan,  nan,     2.68,   0.00,  nan ],
	[    90,     90,  nan,  nan,     3.38,   0.00,  nan ],
	[   100,    100,  nan,  nan,     2.44,   0.00,  nan ],
	[   200,    200,  nan,  nan,    10.65,   0.00,  nan ],
	[   300,    300,  nan,  nan,    24.62,   0.01,  nan ],
	[   400,    400,  nan,  nan,    40.02,   0.01,  nan ],
	[   500,    500,  nan,  nan,    58.90,   0.01,  nan ],
	[   600,    600,  nan,  nan,    76.82,   0.02,  nan ],
	[   700,    700,  nan,  nan,    96.76,   0.02,  nan ],
	[   800,    800,  nan,  nan,   116.19,   0.02,  nan ],
	[   900,    900,  nan,  nan,   133.96,   0.03,  nan ],
	[  1000,   1000,  nan,  nan,   156.90,   0.03,  nan ],
	[  2000,   2000,  nan,  nan,   380.77,   0.11,  nan ],
	[  3000,   3000,  nan,  nan,   619.00,   0.23,  nan ],
	[  4000,   4000,  nan,  nan,   753.39,   0.45,  nan ],
	[  5000,   5000,  nan,  nan,   811.99,   0.82,  nan ],
	[  6000,   6000,  nan,  nan,   901.27,   1.28,  nan ],
	[  7000,   7000,  nan,  nan,   954.28,   1.92,  nan ],
	[  8000,   8000,  nan,  nan,   997.31,   2.74,  nan ],
	[  9000,   9000,  nan,  nan,  1012.29,   3.84,  nan ],
	[ 10000,  10000,  nan,  nan,  1028.54,   5.19,  nan ],
	[ 12000,  12000,  nan,  nan,  1066.20,   8.65,  nan ],
	[ 14000,  14000,  nan,  nan,  1076.92,  13.59,  nan ],
	[ 16000,  16000,  nan,  nan,  1099.34,  19.87,  nan ],
	[ 18000,  18000,  nan,  nan,  1059.24,  29.37,  nan ],
	[ 20000,  20000,  nan,  nan,  1092.57,  39.06,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/zgesvd.txt
# numactl --interleave=all ../testing/testing_zgesvd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
zgesvd_UN = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.00,  nan ],
	[ nan,      80,      80,  nan,    0.00,  nan ],
	[ nan,      90,      90,  nan,    0.00,  nan ],
	[ nan,     100,     100,  nan,    0.00,  nan ],
	[ nan,     200,     200,  nan,    0.02,  nan ],
	[ nan,     300,     300,  nan,    0.04,  nan ],
	[ nan,     400,     400,  nan,    0.07,  nan ],
	[ nan,     500,     500,  nan,    0.10,  nan ],
	[ nan,     600,     600,  nan,    0.14,  nan ],
	[ nan,     700,     700,  nan,    0.19,  nan ],
	[ nan,     800,     800,  nan,    0.24,  nan ],
	[ nan,     900,     900,  nan,    0.31,  nan ],
	[ nan,    1000,    1000,  nan,    0.38,  nan ],
	[ nan,    2000,    2000,  nan,    1.65,  nan ],
	[ nan,    3000,    3000,  nan,    4.43,  nan ],
	[ nan,    4000,    4000,  nan,    9.16,  nan ],
	[ nan,    5000,    5000,  nan,   16.45,  nan ],
	[ nan,    6000,    6000,  nan,   26.95,  nan ],
	[ nan,    7000,    7000,  nan,   40.59,  nan ],
	[ nan,    8000,    8000,  nan,   59.34,  nan ],
	[ nan,    9000,    9000,  nan,   81.91,  nan ],
	[ nan,   10000,   10000,  nan,  113.08,  nan ],
	[ nan,     300,     100,  nan,    0.00,  nan ],
	[ nan,     600,     200,  nan,    0.02,  nan ],
	[ nan,     900,     300,  nan,    0.05,  nan ],
	[ nan,    1200,     400,  nan,    0.09,  nan ],
	[ nan,    1500,     500,  nan,    0.14,  nan ],
	[ nan,    1800,     600,  nan,    0.19,  nan ],
	[ nan,    2100,     700,  nan,    0.26,  nan ],
	[ nan,    2400,     800,  nan,    0.33,  nan ],
	[ nan,    2700,     900,  nan,    0.45,  nan ],
	[ nan,    3000,    1000,  nan,    0.55,  nan ],
	[ nan,    6000,    2000,  nan,    2.72,  nan ],
	[ nan,    9000,    3000,  nan,    7.58,  nan ],
	[ nan,   12000,    4000,  nan,   16.04,  nan ],
	[ nan,   15000,    5000,  nan,   29.34,  nan ],
	[ nan,   18000,    6000,  nan,   48.41,  nan ],
	[ nan,   21000,    7000,  nan,   74.00,  nan ],
	[ nan,   24000,    8000,  nan,  109.63,  nan ],
	[ nan,   27000,    9000,  nan,  152.19,  nan ],
	[ nan,     100,     300,  nan,    0.00,  nan ],
	[ nan,     200,     600,  nan,    0.03,  nan ],
	[ nan,     300,     900,  nan,    0.06,  nan ],
	[ nan,     400,    1200,  nan,    0.09,  nan ],
	[ nan,     500,    1500,  nan,    0.14,  nan ],
	[ nan,     600,    1800,  nan,    0.20,  nan ],
	[ nan,     700,    2100,  nan,    0.27,  nan ],
	[ nan,     800,    2400,  nan,    0.35,  nan ],
	[ nan,     900,    2700,  nan,    0.44,  nan ],
	[ nan,    1000,    3000,  nan,    0.54,  nan ],
	[ nan,    2000,    6000,  nan,    2.65,  nan ],
	[ nan,    3000,    9000,  nan,    7.45,  nan ],
	[ nan,    4000,   12000,  nan,   15.92,  nan ],
	[ nan,    5000,   15000,  nan,   29.27,  nan ],
	[ nan,    6000,   18000,  nan,   48.93,  nan ],
	[ nan,    7000,   21000,  nan,   75.28,  nan ],
	[ nan,    8000,   24000,  nan,  111.25,  nan ],
	[ nan,    9000,   27000,  nan,  154.86,  nan ],
	[ nan,   10000,     100,  nan,    0.04,  nan ],
	[ nan,   20000,     200,  nan,    0.14,  nan ],
	[ nan,   30000,     300,  nan,    0.34,  nan ],
	[ nan,   40000,     400,  nan,    0.92,  nan ],
	[ nan,   50000,     500,  nan,    1.51,  nan ],
	[ nan,   60000,     600,  nan,    2.24,  nan ],
	[ nan,   70000,     700,  nan,    3.17,  nan ],
	[ nan,   80000,     800,  nan,    4.32,  nan ],
	[ nan,   90000,     900,  nan,    6.39,  nan ],
	[ nan,  100000,    1000,  nan,    8.07,  nan ],
	[ nan,  200000,    2000,  nan,   46.25,  nan ],
	[ nan,     100,   10000,  nan,    0.03,  nan ],
	[ nan,     200,   20000,  nan,    0.14,  nan ],
	[ nan,     300,   30000,  nan,    0.37,  nan ],
	[ nan,     400,   40000,  nan,    0.76,  nan ],
	[ nan,     500,   50000,  nan,    1.42,  nan ],
	[ nan,     600,   60000,  nan,    2.40,  nan ],
	[ nan,     700,   70000,  nan,    3.65,  nan ],
	[ nan,     800,   80000,  nan,    5.71,  nan ],
	[ nan,     900,   90000,  nan,    6.29,  nan ],
	[ nan,    1000,  100000,  nan,    8.23,  nan ],
	[ nan,    2000,  200000,  nan,   52.39,  nan ],
])

# numactl --interleave=all ../testing/testing_zgesvd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
zgesvd_US = array([
	[ nan,      10,      10,  nan,     0.00,  nan ],
	[ nan,      20,      20,  nan,     0.00,  nan ],
	[ nan,      30,      30,  nan,     0.00,  nan ],
	[ nan,      40,      40,  nan,     0.00,  nan ],
	[ nan,      50,      50,  nan,     0.01,  nan ],
	[ nan,      60,      60,  nan,     0.01,  nan ],
	[ nan,      70,      70,  nan,     0.01,  nan ],
	[ nan,      80,      80,  nan,     0.01,  nan ],
	[ nan,      90,      90,  nan,     0.02,  nan ],
	[ nan,     100,     100,  nan,     0.02,  nan ],
	[ nan,     200,     200,  nan,     0.03,  nan ],
	[ nan,     300,     300,  nan,     0.08,  nan ],
	[ nan,     400,     400,  nan,     0.13,  nan ],
	[ nan,     500,     500,  nan,     0.21,  nan ],
	[ nan,     600,     600,  nan,     0.30,  nan ],
	[ nan,     700,     700,  nan,     0.44,  nan ],
	[ nan,     800,     800,  nan,     0.56,  nan ],
	[ nan,     900,     900,  nan,     0.73,  nan ],
	[ nan,    1000,    1000,  nan,     0.91,  nan ],
	[ nan,    2000,    2000,  nan,     4.42,  nan ],
	[ nan,    3000,    3000,  nan,    11.70,  nan ],
	[ nan,    4000,    4000,  nan,    23.44,  nan ],
	[ nan,    5000,    5000,  nan,    42.13,  nan ],
	[ nan,    6000,    6000,  nan,    67.29,  nan ],
	[ nan,    7000,    7000,  nan,   102.72,  nan ],
	[ nan,    8000,    8000,  nan,   144.77,  nan ],
	[ nan,    9000,    9000,  nan,   204.11,  nan ],
	[ nan,   10000,   10000,  nan,   269.33,  nan ],
	[ nan,     300,     100,  nan,     0.03,  nan ],
	[ nan,     600,     200,  nan,     0.05,  nan ],
	[ nan,     900,     300,  nan,     0.11,  nan ],
	[ nan,    1200,     400,  nan,     0.20,  nan ],
	[ nan,    1500,     500,  nan,     0.32,  nan ],
	[ nan,    1800,     600,  nan,     0.47,  nan ],
	[ nan,    2100,     700,  nan,     0.69,  nan ],
	[ nan,    2400,     800,  nan,     0.92,  nan ],
	[ nan,    2700,     900,  nan,     1.21,  nan ],
	[ nan,    3000,    1000,  nan,     1.56,  nan ],
	[ nan,    6000,    2000,  nan,     8.36,  nan ],
	[ nan,    9000,    3000,  nan,    24.47,  nan ],
	[ nan,   12000,    4000,  nan,    50.80,  nan ],
	[ nan,   15000,    5000,  nan,    95.80,  nan ],
	[ nan,   18000,    6000,  nan,   155.11,  nan ],
	[ nan,   21000,    7000,  nan,   247.36,  nan ],
	[ nan,   24000,    8000,  nan,   349.44,  nan ],
	[ nan,   27000,    9000,  nan,   505.15,  nan ],
	[ nan,     100,     300,  nan,     0.02,  nan ],
	[ nan,     200,     600,  nan,     0.09,  nan ],
	[ nan,     300,     900,  nan,     0.26,  nan ],
	[ nan,     400,    1200,  nan,     0.55,  nan ],
	[ nan,     500,    1500,  nan,     1.01,  nan ],
	[ nan,     600,    1800,  nan,     1.68,  nan ],
	[ nan,     700,    2100,  nan,     2.80,  nan ],
	[ nan,     800,    2400,  nan,     4.25,  nan ],
	[ nan,     900,    2700,  nan,     6.30,  nan ],
	[ nan,    1000,    3000,  nan,     8.68,  nan ],
	[ nan,    2000,    6000,  nan,    67.62,  nan ],
	[ nan,    3000,    9000,  nan,   218.64,  nan ],
	[ nan,    4000,   12000,  nan,   522.39,  nan ],
	[ nan,    5000,   15000,  nan,   978.86,  nan ],
	[ nan,    6000,   18000,  nan,  1689.01,  nan ],
	[ nan,    7000,   21000,  nan,  2645.05,  nan ],
	[ nan,    8000,   24000,  nan,  3888.23,  nan ],
	[ nan,    9000,   27000,  nan,  5567.58,  nan ],
	[ nan,   10000,     100,  nan,     0.12,  nan ],
	[ nan,   20000,     200,  nan,     0.37,  nan ],
	[ nan,   30000,     300,  nan,     0.93,  nan ],
	[ nan,   40000,     400,  nan,     2.19,  nan ],
	[ nan,   50000,     500,  nan,     3.85,  nan ],
	[ nan,   60000,     600,  nan,     6.07,  nan ],
	[ nan,   70000,     700,  nan,     9.08,  nan ],
	[ nan,   80000,     800,  nan,    12.51,  nan ],
	[ nan,   90000,     900,  nan,    18.42,  nan ],
	[ nan,  100000,    1000,  nan,    23.63,  nan ],
	[ nan,  200000,    2000,  nan,   162.04,  nan ],
	[ nan,     100,   10000,  nan,     0.30,  nan ],
	[ nan,     200,   20000,  nan,     3.03,  nan ],
	[ nan,     300,   30000,  nan,     9.53,  nan ],
	[ nan,     400,   40000,  nan,    20.84,  nan ],
	[ nan,     500,   50000,  nan,    41.41,  nan ],
	[ nan,     600,   60000,  nan,    67.98,  nan ],
	[ nan,     700,   70000,  nan,   103.39,  nan ],
	[ nan,     800,   80000,  nan,   160.38,  nan ],
	[ nan,     900,   90000,  nan,   226.14,  nan ],
	[ nan,    1000,  100000,  nan,   298.09,  nan ],
	[ nan,    2000,  200000,  nan,  2272.09,  nan ],
])

# numactl --interleave=all ../testing/testing_zgesdd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
zgesdd_UN = array([
	[ nan,      10,      10,  nan,    0.00,  nan ],
	[ nan,      20,      20,  nan,    0.00,  nan ],
	[ nan,      30,      30,  nan,    0.00,  nan ],
	[ nan,      40,      40,  nan,    0.00,  nan ],
	[ nan,      50,      50,  nan,    0.00,  nan ],
	[ nan,      60,      60,  nan,    0.00,  nan ],
	[ nan,      70,      70,  nan,    0.00,  nan ],
	[ nan,      80,      80,  nan,    0.00,  nan ],
	[ nan,      90,      90,  nan,    0.00,  nan ],
	[ nan,     100,     100,  nan,    0.00,  nan ],
	[ nan,     200,     200,  nan,    0.02,  nan ],
	[ nan,     300,     300,  nan,    0.04,  nan ],
	[ nan,     400,     400,  nan,    0.07,  nan ],
	[ nan,     500,     500,  nan,    0.11,  nan ],
	[ nan,     600,     600,  nan,    0.15,  nan ],
	[ nan,     700,     700,  nan,    0.20,  nan ],
	[ nan,     800,     800,  nan,    0.25,  nan ],
	[ nan,     900,     900,  nan,    0.32,  nan ],
	[ nan,    1000,    1000,  nan,    0.39,  nan ],
	[ nan,    2000,    2000,  nan,    1.68,  nan ],
	[ nan,    3000,    3000,  nan,    4.49,  nan ],
	[ nan,    4000,    4000,  nan,    9.27,  nan ],
	[ nan,    5000,    5000,  nan,   16.59,  nan ],
	[ nan,    6000,    6000,  nan,   27.14,  nan ],
	[ nan,    7000,    7000,  nan,   40.88,  nan ],
	[ nan,    8000,    8000,  nan,   59.86,  nan ],
	[ nan,    9000,    9000,  nan,   82.61,  nan ],
	[ nan,   10000,   10000,  nan,  113.91,  nan ],
	[ nan,     300,     100,  nan,    0.00,  nan ],
	[ nan,     600,     200,  nan,    0.03,  nan ],
	[ nan,     900,     300,  nan,    0.05,  nan ],
	[ nan,    1200,     400,  nan,    0.10,  nan ],
	[ nan,    1500,     500,  nan,    0.14,  nan ],
	[ nan,    1800,     600,  nan,    0.21,  nan ],
	[ nan,    2100,     700,  nan,    0.29,  nan ],
	[ nan,    2400,     800,  nan,    0.38,  nan ],
	[ nan,    2700,     900,  nan,    0.51,  nan ],
	[ nan,    3000,    1000,  nan,    0.65,  nan ],
	[ nan,    6000,    2000,  nan,    3.16,  nan ],
	[ nan,    9000,    3000,  nan,    9.35,  nan ],
	[ nan,   12000,    4000,  nan,   19.92,  nan ],
	[ nan,   15000,    5000,  nan,   36.61,  nan ],
	[ nan,   18000,    6000,  nan,   59.62,  nan ],
	[ nan,   21000,    7000,  nan,   92.49,  nan ],
	[ nan,   24000,    8000,  nan,  117.98,  nan ],
	[ nan,   27000,    9000,  nan,  187.83,  nan ],
	[ nan,     100,     300,  nan,    0.01,  nan ],
	[ nan,     200,     600,  nan,    0.03,  nan ],
	[ nan,     300,     900,  nan,    0.06,  nan ],
	[ nan,     400,    1200,  nan,    0.10,  nan ],
	[ nan,     500,    1500,  nan,    0.15,  nan ],
	[ nan,     600,    1800,  nan,    0.22,  nan ],
	[ nan,     700,    2100,  nan,    0.30,  nan ],
	[ nan,     800,    2400,  nan,    0.40,  nan ],
	[ nan,     900,    2700,  nan,    0.52,  nan ],
	[ nan,    1000,    3000,  nan,    0.65,  nan ],
	[ nan,    2000,    6000,  nan,    3.49,  nan ],
	[ nan,    3000,    9000,  nan,   10.22,  nan ],
	[ nan,    4000,   12000,  nan,   22.45,  nan ],
	[ nan,    5000,   15000,  nan,   42.14,  nan ],
	[ nan,    6000,   18000,  nan,   70.81,  nan ],
	[ nan,    7000,   21000,  nan,  110.01,  nan ],
	[ nan,    8000,   24000,  nan,  162.02,  nan ],
	[ nan,    9000,   27000,  nan,  159.23,  nan ],
	[ nan,   10000,     100,  nan,    0.04,  nan ],
	[ nan,   20000,     200,  nan,    0.14,  nan ],
	[ nan,   30000,     300,  nan,    0.33,  nan ],
	[ nan,   40000,     400,  nan,    0.93,  nan ],
	[ nan,   50000,     500,  nan,    1.50,  nan ],
	[ nan,   60000,     600,  nan,    2.25,  nan ],
	[ nan,   70000,     700,  nan,    3.18,  nan ],
	[ nan,   80000,     800,  nan,    4.28,  nan ],
	[ nan,   90000,     900,  nan,    6.37,  nan ],
	[ nan,  100000,    1000,  nan,    8.06,  nan ],
	[ nan,  200000,    2000,  nan,   46.19,  nan ],
	[ nan,     100,   10000,  nan,    0.03,  nan ],
	[ nan,     200,   20000,  nan,    0.14,  nan ],
	[ nan,     300,   30000,  nan,    0.37,  nan ],
	[ nan,     400,   40000,  nan,    0.77,  nan ],
	[ nan,     500,   50000,  nan,    1.42,  nan ],
	[ nan,     600,   60000,  nan,    2.36,  nan ],
	[ nan,     700,   70000,  nan,    3.63,  nan ],
	[ nan,     800,   80000,  nan,    5.75,  nan ],
	[ nan,     900,   90000,  nan,    6.28,  nan ],
	[ nan,    1000,  100000,  nan,    8.15,  nan ],
	[ nan,    2000,  200000,  nan,   52.04,  nan ],
])

# numactl --interleave=all ../testing/testing_zgesdd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000
zgesdd_US = array([
	[ nan,    10,    10,  nan,    0.00,  nan ],
	[ nan,    20,    20,  nan,    0.00,  nan ],
	[ nan,    30,    30,  nan,    0.00,  nan ],
	[ nan,    40,    40,  nan,    0.00,  nan ],
	[ nan,    50,    50,  nan,    0.00,  nan ],
	[ nan,    60,    60,  nan,    0.00,  nan ],
	[ nan,    70,    70,  nan,    0.01,  nan ],
	[ nan,    80,    80,  nan,    0.01,  nan ],
	[ nan,    90,    90,  nan,    0.01,  nan ],
	[ nan,   100,   100,  nan,    0.01,  nan ],
	[ nan,   200,   200,  nan,    0.04,  nan ],
	[ nan,   300,   300,  nan,    0.08,  nan ],
	[ nan,   400,   400,  nan,    0.13,  nan ],
	[ nan,   500,   500,  nan,    0.19,  nan ],
	[ nan,   600,   600,  nan,    0.27,  nan ],
	[ nan,   700,   700,  nan,    0.35,  nan ],
	[ nan,   800,   800,  nan,    0.42,  nan ],
	[ nan,   900,   900,  nan,    0.52,  nan ],
	[ nan,  1000,  1000,  nan,    0.65,  nan ],
	[ nan,  2000,  2000,  nan,    2.84,  nan ],
	[ nan,  3000,  3000,  nan,    7.86,  nan ],
	[ nan,  4000,  4000,  nan,   14.50,  nan ],
	[ nan,  5000,  5000,  nan,   25.34,  nan ],
	[ nan,  6000,  6000,  nan,   40.82,  nan ],
	[ nan,  7000,  7000,  nan,   60.47,  nan ],
	[ nan,  8000,  8000,  nan,   87.49,  nan ],
	[ nan,  9000,  9000,  nan,  114.55,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/zgetrf.txt
# numactl --interleave=all ../testing/testing_zgetrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgetrf = array([
	[    10,     10,  nan,  nan,     0.24,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.70,   0.00,  nan ],
	[    30,     30,  nan,  nan,     1.65,   0.00,  nan ],
	[    40,     40,  nan,  nan,     2.92,   0.00,  nan ],
	[    50,     50,  nan,  nan,     2.67,   0.00,  nan ],
	[    60,     60,  nan,  nan,     4.04,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.99,   0.00,  nan ],
	[    80,     80,  nan,  nan,     1.38,   0.00,  nan ],
	[    90,     90,  nan,  nan,     1.86,   0.00,  nan ],
	[   100,    100,  nan,  nan,     2.37,   0.00,  nan ],
	[   200,    200,  nan,  nan,    10.08,   0.00,  nan ],
	[   300,    300,  nan,  nan,    22.19,   0.00,  nan ],
	[   400,    400,  nan,  nan,    35.50,   0.00,  nan ],
	[   500,    500,  nan,  nan,    51.16,   0.01,  nan ],
	[   600,    600,  nan,  nan,    67.19,   0.01,  nan ],
	[   700,    700,  nan,  nan,    85.26,   0.01,  nan ],
	[   800,    800,  nan,  nan,   104.65,   0.01,  nan ],
	[   900,    900,  nan,  nan,   121.40,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,   140.36,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   337.28,   0.06,  nan ],
	[  3000,   3000,  nan,  nan,   518.22,   0.14,  nan ],
	[  4000,   4000,  nan,  nan,   628.86,   0.27,  nan ],
	[  5000,   5000,  nan,  nan,   679.77,   0.49,  nan ],
	[  6000,   6000,  nan,  nan,   773.23,   0.74,  nan ],
	[  7000,   7000,  nan,  nan,   830.05,   1.10,  nan ],
	[  8000,   8000,  nan,  nan,   883.49,   1.55,  nan ],
	[  9000,   9000,  nan,  nan,   895.76,   2.17,  nan ],
	[ 10000,  10000,  nan,  nan,   934.98,   2.85,  nan ],
	[ 12000,  12000,  nan,  nan,   988.22,   4.66,  nan ],
	[ 14000,  14000,  nan,  nan,  1023.69,   7.15,  nan ],
	[ 16000,  16000,  nan,  nan,  1051.55,  10.39,  nan ],
	[ 18000,  18000,  nan,  nan,  1060.84,  14.66,  nan ],
	[ 20000,  20000,  nan,  nan,  1077.25,  19.80,  nan ],
])

# numactl --interleave=all ../testing/testing_zgetrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.08,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.26,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.58,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.89,   0.00,  nan ],
	[    60,     60,  nan,  nan,     1.43,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.51,   0.00,  nan ],
	[    80,     80,  nan,  nan,     0.82,   0.00,  nan ],
	[    90,     90,  nan,  nan,     1.11,   0.00,  nan ],
	[   100,    100,  nan,  nan,     1.45,   0.00,  nan ],
	[   200,    200,  nan,  nan,     7.00,   0.00,  nan ],
	[   300,    300,  nan,  nan,    17.59,   0.00,  nan ],
	[   400,    400,  nan,  nan,    31.04,   0.01,  nan ],
	[   500,    500,  nan,  nan,    49.68,   0.01,  nan ],
	[   600,    600,  nan,  nan,    67.35,   0.01,  nan ],
	[   700,    700,  nan,  nan,    88.73,   0.01,  nan ],
	[   800,    800,  nan,  nan,   110.91,   0.01,  nan ],
	[   900,    900,  nan,  nan,   134.44,   0.01,  nan ],
	[  1000,   1000,  nan,  nan,   163.87,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   412.29,   0.05,  nan ],
	[  3000,   3000,  nan,  nan,   635.10,   0.11,  nan ],
	[  4000,   4000,  nan,  nan,   755.79,   0.23,  nan ],
	[  5000,   5000,  nan,  nan,   796.58,   0.42,  nan ],
	[  6000,   6000,  nan,  nan,   888.50,   0.65,  nan ],
	[  7000,   7000,  nan,  nan,   942.64,   0.97,  nan ],
	[  8000,   8000,  nan,  nan,   995.14,   1.37,  nan ],
	[  9000,   9000,  nan,  nan,  1005.68,   1.93,  nan ],
	[ 10000,  10000,  nan,  nan,  1040.82,   2.56,  nan ],
	[ 12000,  12000,  nan,  nan,  1082.99,   4.25,  nan ],
	[ 14000,  14000,  nan,  nan,  1109.47,   6.60,  nan ],
	[ 16000,  16000,  nan,  nan,  1130.70,   9.66,  nan ],
	[ 18000,  18000,  nan,  nan,  1130.42,  13.76,  nan ],
	[ 20000,  20000,  nan,  nan,  1141.78,  18.68,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/zheevd.txt
# numactl --interleave=all ../testing/testing_zheevd -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_zheevd -JN -N 123 -N 1234 --range 12000:20000:2000
zheevd_JN = array([
	[    10,  nan,    0.0000,  nan,  nan,  nan,  nan ],
	[    20,  nan,    0.0001,  nan,  nan,  nan,  nan ],
	[    30,  nan,    0.0001,  nan,  nan,  nan,  nan ],
	[    40,  nan,    0.0002,  nan,  nan,  nan,  nan ],
	[    50,  nan,    0.0003,  nan,  nan,  nan,  nan ],
	[    60,  nan,    0.0004,  nan,  nan,  nan,  nan ],
	[    70,  nan,    0.0006,  nan,  nan,  nan,  nan ],
	[    80,  nan,    0.0009,  nan,  nan,  nan,  nan ],
	[    90,  nan,    0.0012,  nan,  nan,  nan,  nan ],
	[   100,  nan,    0.0016,  nan,  nan,  nan,  nan ],
	[   200,  nan,    0.0066,  nan,  nan,  nan,  nan ],
	[   300,  nan,    0.0135,  nan,  nan,  nan,  nan ],
	[   400,  nan,    0.0236,  nan,  nan,  nan,  nan ],
	[   500,  nan,    0.0363,  nan,  nan,  nan,  nan ],
	[   600,  nan,    0.0522,  nan,  nan,  nan,  nan ],
	[   700,  nan,    0.0729,  nan,  nan,  nan,  nan ],
	[   800,  nan,    0.0957,  nan,  nan,  nan,  nan ],
	[   900,  nan,    0.1250,  nan,  nan,  nan,  nan ],
	[  1000,  nan,    0.1551,  nan,  nan,  nan,  nan ],
	[  2000,  nan,    0.7983,  nan,  nan,  nan,  nan ],
	[  3000,  nan,    2.0276,  nan,  nan,  nan,  nan ],
	[  4000,  nan,    3.9053,  nan,  nan,  nan,  nan ],
	[  5000,  nan,    6.5959,  nan,  nan,  nan,  nan ],
	[  6000,  nan,   10.3139,  nan,  nan,  nan,  nan ],
	[  7000,  nan,   15.0515,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   21.1750,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   28.9088,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,   38.1991,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,   60.9986,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,   92.8384,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,  134.8674,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,  189.3054,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  257.6523,  nan,  nan,  nan,  nan ],
])

# numactl --interleave=all ../testing/testing_zheevd -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_zheevd -JV -N 123 -N 1234 --range 12000:20000:2000
zheevd_JV = array([
	[    10,  nan,    0.0002,  nan,  nan,  nan,  nan ],
	[    20,  nan,    0.0002,  nan,  nan,  nan,  nan ],
	[    30,  nan,    0.0004,  nan,  nan,  nan,  nan ],
	[    40,  nan,    0.0006,  nan,  nan,  nan,  nan ],
	[    50,  nan,    0.0008,  nan,  nan,  nan,  nan ],
	[    60,  nan,    0.0010,  nan,  nan,  nan,  nan ],
	[    70,  nan,    0.0015,  nan,  nan,  nan,  nan ],
	[    80,  nan,    0.0020,  nan,  nan,  nan,  nan ],
	[    90,  nan,    0.0025,  nan,  nan,  nan,  nan ],
	[   100,  nan,    0.0031,  nan,  nan,  nan,  nan ],
	[   200,  nan,    0.0151,  nan,  nan,  nan,  nan ],
	[   300,  nan,    0.0254,  nan,  nan,  nan,  nan ],
	[   400,  nan,    0.0427,  nan,  nan,  nan,  nan ],
	[   500,  nan,    0.0637,  nan,  nan,  nan,  nan ],
	[   600,  nan,    0.0841,  nan,  nan,  nan,  nan ],
	[   700,  nan,    0.1146,  nan,  nan,  nan,  nan ],
	[   800,  nan,    0.1469,  nan,  nan,  nan,  nan ],
	[   900,  nan,    0.1908,  nan,  nan,  nan,  nan ],
	[  1000,  nan,    0.2328,  nan,  nan,  nan,  nan ],
	[  2000,  nan,    1.0885,  nan,  nan,  nan,  nan ],
	[  3000,  nan,    2.4379,  nan,  nan,  nan,  nan ],
	[  4000,  nan,    4.6361,  nan,  nan,  nan,  nan ],
	[  5000,  nan,    7.7226,  nan,  nan,  nan,  nan ],
	[  6000,  nan,   12.1252,  nan,  nan,  nan,  nan ],
	[  7000,  nan,   17.9808,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   25.4648,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   34.8593,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,   46.1960,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,   74.9908,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,  114.6719,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,  167.3222,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,  240.0484,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,  325.0192,  nan,  nan,  nan,  nan ],
])

# numactl --interleave=all ../testing/testing_zheevd_gpu -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_zheevd_gpu -JN -N 123 -N 1234 --range 12000:20000:2000
zheevd_gpu_JN = array([
	[    10,  nan,    0.0002,  nan,  nan,  nan,  nan ],
	[    20,  nan,    0.0002,  nan,  nan,  nan,  nan ],
	[    30,  nan,    0.0003,  nan,  nan,  nan,  nan ],
	[    40,  nan,    0.0003,  nan,  nan,  nan,  nan ],
	[    50,  nan,    0.0005,  nan,  nan,  nan,  nan ],
	[    60,  nan,    0.0006,  nan,  nan,  nan,  nan ],
	[    70,  nan,    0.0009,  nan,  nan,  nan,  nan ],
	[    80,  nan,    0.0012,  nan,  nan,  nan,  nan ],
	[    90,  nan,    0.0015,  nan,  nan,  nan,  nan ],
	[   100,  nan,    0.0019,  nan,  nan,  nan,  nan ],
	[   200,  nan,    0.0073,  nan,  nan,  nan,  nan ],
	[   300,  nan,    0.0147,  nan,  nan,  nan,  nan ],
	[   400,  nan,    0.0257,  nan,  nan,  nan,  nan ],
	[   500,  nan,    0.0396,  nan,  nan,  nan,  nan ],
	[   600,  nan,    0.0567,  nan,  nan,  nan,  nan ],
	[   700,  nan,    0.0788,  nan,  nan,  nan,  nan ],
	[   800,  nan,    0.1032,  nan,  nan,  nan,  nan ],
	[   900,  nan,    0.1339,  nan,  nan,  nan,  nan ],
	[  1000,  nan,    0.1665,  nan,  nan,  nan,  nan ],
	[  2000,  nan,    0.8288,  nan,  nan,  nan,  nan ],
	[  3000,  nan,    2.0168,  nan,  nan,  nan,  nan ],
	[  4000,  nan,    3.8777,  nan,  nan,  nan,  nan ],
	[  5000,  nan,    6.5738,  nan,  nan,  nan,  nan ],
	[  6000,  nan,   10.2345,  nan,  nan,  nan,  nan ],
	[  7000,  nan,   15.0260,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   21.0258,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   28.6735,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,   37.7639,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,   60.8922,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,   92.3358,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,  134.6948,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,  188.2464,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,       nan,  nan,  nan,  nan,  nan ],  # failed to run
])

# numactl --interleave=all ../testing/testing_zheevd_gpu -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_zheevd_gpu -JV -N 123 -N 1234 --range 12000:20000:2000
zheevd_gpu_JV = array([
	[    10,  nan,    0.0004,  nan,  nan,  nan,  nan ],
	[    20,  nan,    0.0005,  nan,  nan,  nan,  nan ],
	[    30,  nan,    0.0006,  nan,  nan,  nan,  nan ],
	[    40,  nan,    0.0008,  nan,  nan,  nan,  nan ],
	[    50,  nan,    0.0010,  nan,  nan,  nan,  nan ],
	[    60,  nan,    0.0013,  nan,  nan,  nan,  nan ],
	[    70,  nan,    0.0017,  nan,  nan,  nan,  nan ],
	[    80,  nan,    0.0022,  nan,  nan,  nan,  nan ],
	[    90,  nan,    0.0026,  nan,  nan,  nan,  nan ],
	[   100,  nan,    0.0032,  nan,  nan,  nan,  nan ],
	[   200,  nan,    0.0139,  nan,  nan,  nan,  nan ],
	[   300,  nan,    0.0217,  nan,  nan,  nan,  nan ],
	[   400,  nan,    0.0347,  nan,  nan,  nan,  nan ],
	[   500,  nan,    0.0518,  nan,  nan,  nan,  nan ],
	[   600,  nan,    0.0695,  nan,  nan,  nan,  nan ],
	[   700,  nan,    0.0948,  nan,  nan,  nan,  nan ],
	[   800,  nan,    0.1221,  nan,  nan,  nan,  nan ],
	[   900,  nan,    0.1565,  nan,  nan,  nan,  nan ],
	[  1000,  nan,    0.1968,  nan,  nan,  nan,  nan ],
	[  2000,  nan,    0.9374,  nan,  nan,  nan,  nan ],
	[  3000,  nan,    2.3136,  nan,  nan,  nan,  nan ],
	[  4000,  nan,    4.4228,  nan,  nan,  nan,  nan ],
	[  5000,  nan,    7.6197,  nan,  nan,  nan,  nan ],
	[  6000,  nan,   11.9714,  nan,  nan,  nan,  nan ],
	[  7000,  nan,   17.6985,  nan,  nan,  nan,  nan ],
	[  8000,  nan,   25.1101,  nan,  nan,  nan,  nan ],
	[  9000,  nan,   34.8214,  nan,  nan,  nan,  nan ],
	[ 10000,  nan,   45.9189,  nan,  nan,  nan,  nan ],
	[ 12000,  nan,   76.1595,  nan,  nan,  nan,  nan ],
	[ 14000,  nan,  117.6711,  nan,  nan,  nan,  nan ],
	[ 16000,  nan,  169.1880,  nan,  nan,  nan,  nan ],
	[ 18000,  nan,  238.5689,  nan,  nan,  nan,  nan ],
	[ 20000,  nan,       nan,  nan,  nan,  nan,  nan ],  # failed to run
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/zheevd_2stage.txt
# numactl --interleave=all ../testing/testing_zheevdx_2stage -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevdx_2stage_JN = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.01 ],
	[   300,    300,   0.04 ],
	[   400,    400,   0.07 ],
	[   500,    500,   0.10 ],
	[   600,    600,   0.14 ],
	[   700,    700,   0.18 ],
	[   800,    800,   0.22 ],
	[   900,    900,   0.28 ],
	[  1000,   1000,   0.31 ],
	[  2000,   2000,   0.73 ],
	[  3000,   3000,   1.38 ],
	[  4000,   4000,   2.21 ],
	[  5000,   5000,   3.24 ],
	[  6000,   6000,   4.56 ],
	[  7000,   7000,   6.06 ],
	[  8000,   8000,   7.71 ],
	[  9000,   9000,  10.22 ],
	[ 10000,  10000,  12.83 ],
	[ 12000,  12000,  19.36 ],
	[ 14000,  14000,  27.85 ],
	[ 16000,  16000,  39.63 ],
	[ 18000,  18000,  54.54 ],
	[ 20000,  20000,  72.02 ],
])

# numactl --interleave=all ../testing/testing_zheevdx_2stage -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevdx_2stage_JV = array([
	[    10,     10,    0.00 ],
	[    20,     20,    0.00 ],
	[    30,     30,    0.00 ],
	[    40,     40,    0.00 ],
	[    50,     50,    0.00 ],
	[    60,     60,    0.00 ],
	[    70,     70,    0.00 ],
	[    80,     80,    0.00 ],
	[    90,     90,    0.00 ],
	[   100,    100,    0.00 ],
	[   200,    200,    0.01 ],
	[   300,    300,    0.05 ],
	[   400,    400,    0.08 ],
	[   500,    500,    0.13 ],
	[   600,    600,    0.16 ],
	[   700,    700,    0.21 ],
	[   800,    800,    0.25 ],
	[   900,    900,    0.31 ],
	[  1000,   1000,    0.36 ],
	[  2000,   2000,    0.99 ],
	[  3000,   3000,    2.05 ],
	[  4000,   4000,    3.70 ],
	[  5000,   5000,    5.96 ],
	[  6000,   6000,    9.13 ],
	[  7000,   7000,   12.63 ],
	[  8000,   8000,   17.80 ],
	[  9000,   9000,   24.84 ],
	[ 10000,  10000,   32.58 ],
	[ 12000,  12000,   53.73 ],
	[ 14000,  14000,   85.04 ],
	[ 16000,  16000,  122.13 ],
	[ 18000,  18000,  179.24 ],
	[ 20000,  20000,  185.08 ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/zhemv.txt
# numactl --interleave=all ../testing/testing_zhemv -L -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
zhemv_L = array([
	[    10,    0.02,   0.04,   0.03,   0.03,   0.04,   0.03,   0.30,    0.00,  7.12e-16,  3.55e-16,  7.12e-16,  nan ],
	[    11,    0.03,   0.04,   0.04,   0.03,   0.05,   0.02,   0.51,    0.00,  2.28e-16,  2.28e-16,  2.42e-16,  nan ],
	[    12,    0.04,   0.03,   0.04,   0.03,   0.06,   0.02,   0.60,    0.00,  3.99e-16,  4.50e-16,  3.05e-16,  nan ],
	[    13,    0.04,   0.04,   0.05,   0.03,   0.07,   0.02,   0.53,    0.00,  3.06e-16,  5.47e-16,  2.82e-16,  nan ],
	[    14,    0.05,   0.04,   0.06,   0.03,   0.08,   0.02,   0.81,    0.00,  2.84e-16,  3.59e-16,  2.84e-16,  nan ],
	[    15,    0.06,   0.03,   0.06,   0.03,   0.09,   0.02,   0.64,    0.00,  2.65e-16,  2.96e-16,  2.96e-16,  nan ],
	[    16,    0.07,   0.03,   0.07,   0.03,   0.10,   0.02,   0.72,    0.00,  2.48e-16,  4.46e-16,  2.48e-16,  nan ],
	[    17,    0.07,   0.03,   0.08,   0.03,   0.11,   0.02,   1.32,    0.00,  4.67e-16,  7.01e-16,  4.31e-16,  nan ],
	[    18,    0.08,   0.03,   0.09,   0.03,   0.12,   0.02,   1.31,    0.00,  2.21e-16,  4.07e-16,  4.07e-16,  nan ],
	[    19,    0.09,   0.03,   0.10,   0.03,   0.13,   0.02,   1.09,    0.00,  3.74e-16,  4.18e-16,  3.74e-16,  nan ],
	[    20,    0.10,   0.04,   0.11,   0.03,   0.15,   0.02,   1.11,    0.00,  4.19e-16,  4.19e-16,  3.97e-16,  nan ],
	[    21,    0.10,   0.04,   0.12,   0.03,   0.16,   0.02,   1.32,    0.00,  3.49e-16,  4.79e-16,  4.23e-16,  nan ],
	[    22,    0.11,   0.04,   0.13,   0.03,   0.18,   0.02,   1.33,    0.00,  5.11e-16,  4.84e-16,  5.82e-16,  nan ],
	[    23,    0.13,   0.03,   0.14,   0.03,   0.19,   0.02,   1.45,    0.00,  2.18e-16,  3.45e-16,  3.45e-16,  nan ],
	[    24,    0.14,   0.03,   0.15,   0.03,   0.22,   0.02,   1.58,    0.00,  7.55e-16,  3.05e-16,  3.31e-16,  nan ],
	[    25,    0.16,   0.03,   0.17,   0.03,   0.22,   0.02,   1.71,    0.00,  3.18e-16,  3.55e-16,  3.04e-16,  nan ],
	[    26,    0.17,   0.03,   0.18,   0.03,   0.24,   0.02,   1.41,    0.00,  4.32e-16,  3.86e-16,  3.42e-16,  nan ],
	[    27,    0.18,   0.04,   0.20,   0.03,   0.27,   0.02,   1.52,    0.00,  5.62e-16,  3.29e-16,  3.96e-16,  nan ],
	[    28,    0.20,   0.03,   0.21,   0.03,   0.27,   0.02,   2.31,    0.00,  3.86e-16,  4.57e-16,  4.57e-16,  nan ],
	[    29,    0.20,   0.04,   0.23,   0.03,   0.29,   0.02,   1.75,    0.00,  3.87e-16,  4.90e-16,  3.87e-16,  nan ],
	[    30,    0.23,   0.03,   0.24,   0.03,   0.32,   0.02,   1.87,    0.00,  5.30e-16,  4.27e-16,  4.74e-16,  nan ],
	[    31,    0.22,   0.04,   0.25,   0.03,   0.32,   0.03,   1.99,    0.00,  5.13e-16,  4.73e-16,  2.72e-16,  nan ],
	[    32,    0.24,   0.04,   0.29,   0.03,   0.34,   0.03,   2.12,    0.00,  2.48e-16,  4.58e-16,  4.00e-16,  nan ],
	[    33,    0.25,   0.04,   0.21,   0.04,   0.35,   0.03,   1.82,    0.01,  4.44e-16,  4.44e-16,  4.44e-16,  nan ],
	[    34,    0.25,   0.04,   0.24,   0.04,   0.39,   0.03,   1.93,    0.01,  8.93e-16,  4.67e-16,  8.62e-16,  nan ],
	[    35,    0.29,   0.03,   0.25,   0.04,   0.41,   0.02,   2.04,    0.01,  4.09e-16,  4.54e-16,  6.11e-16,  nan ],
	[    36,    0.30,   0.04,   0.26,   0.04,   0.42,   0.03,   2.16,    0.01,  4.41e-16,  4.93e-16,  5.94e-16,  nan ],
	[    37,    0.31,   0.04,   0.28,   0.04,   0.42,   0.03,   2.28,    0.01,  6.07e-16,  4.29e-16,  3.96e-16,  nan ],
	[    38,    0.34,   0.04,   0.29,   0.04,   0.46,   0.03,   2.40,    0.01,  3.85e-16,  5.91e-16,  4.18e-16,  nan ],
	[    39,    0.33,   0.04,   0.31,   0.04,   0.49,   0.03,   2.12,    0.01,  5.76e-16,  3.67e-16,  3.76e-16,  nan ],
	[    40,    0.38,   0.04,   0.32,   0.04,   0.53,   0.03,   2.23,    0.01,  5.02e-16,  4.78e-16,  4.78e-16,  nan ],
	[    41,    0.37,   0.04,   0.34,   0.04,   0.56,   0.02,   2.78,    0.01,  5.48e-16,  5.27e-16,  5.48e-16,  nan ],
	[    42,    0.37,   0.04,   0.36,   0.04,   0.58,   0.03,   2.45,    0.01,  5.67e-16,  6.10e-16,  5.67e-16,  nan ],
	[    43,    0.40,   0.04,   0.38,   0.04,   0.59,   0.03,   3.06,    0.01,  4.13e-16,  5.54e-16,  4.67e-16,  nan ],
	[    44,    0.44,   0.04,   0.39,   0.04,   0.62,   0.03,   2.69,    0.01,  6.66e-16,  4.84e-16,  5.11e-16,  nan ],
	[    45,    0.48,   0.03,   0.41,   0.04,   0.64,   0.03,   2.81,    0.01,  4.47e-16,  4.99e-16,  6.75e-16,  nan ],
	[    46,    0.47,   0.04,   0.41,   0.04,   0.67,   0.03,   3.49,    0.01,  6.19e-16,  6.18e-16,  4.65e-16,  nan ],
	[    47,    0.48,   0.04,   0.43,   0.04,   0.70,   0.03,   1.82,    0.01,  6.76e-16,  7.56e-16,  5.07e-16,  nan ],
	[    48,    0.53,   0.04,   0.44,   0.04,   0.73,   0.03,   3.19,    0.01,  4.68e-16,  5.92e-16,  4.68e-16,  nan ],
	[    49,    0.55,   0.04,   0.47,   0.04,   0.73,   0.03,   2.44,    0.01,  4.59e-16,  4.37e-16,  3.63e-16,  nan ],
	[    50,    0.54,   0.04,   0.48,   0.04,   0.73,   0.03,   4.11,    0.01,  4.02e-16,  4.32e-16,  4.49e-16,  nan ],
	[    51,    0.59,   0.04,   0.50,   0.04,   0.80,   0.03,   2.99,    0.01,  6.23e-16,  6.86e-16,  6.86e-16,  nan ],
	[    52,    0.60,   0.04,   0.53,   0.04,   0.83,   0.03,   3.22,    0.01,  5.84e-16,  4.44e-16,  4.37e-16,  nan ],
	[    53,    0.61,   0.04,   0.54,   0.04,   0.86,   0.03,   3.34,    0.01,  5.40e-16,  5.73e-16,  4.50e-16,  nan ],
	[    54,    0.63,   0.04,   0.56,   0.04,   0.86,   0.03,   3.35,    0.01,  6.71e-16,  5.43e-16,  5.30e-16,  nan ],
	[    55,    0.65,   0.04,   0.58,   0.04,   0.89,   0.03,   3.48,    0.01,  4.66e-16,  4.66e-16,  4.66e-16,  nan ],
	[    56,    0.70,   0.04,   0.59,   0.04,   0.92,   0.03,   3.73,    0.01,  5.11e-16,  4.01e-16,  3.92e-16,  nan ],
	[    57,    0.74,   0.04,   0.62,   0.04,   0.92,   0.03,   2.94,    0.01,  3.94e-16,  3.94e-16,  3.79e-16,  nan ],
	[    58,    0.77,   0.04,   0.66,   0.04,   1.02,   0.03,   4.63,    0.01,  3.68e-16,  4.42e-16,  3.87e-16,  nan ],
	[    59,    0.77,   0.04,   0.68,   0.04,   1.06,   0.03,   3.63,    0.01,  4.34e-16,  4.85e-16,  5.55e-16,  nan ],
	[    60,    0.82,   0.04,   0.66,   0.05,   1.14,   0.03,   3.64,    0.01,  4.27e-16,  4.27e-16,  5.30e-16,  nan ],
	[    61,    0.85,   0.04,   0.71,   0.04,   1.12,   0.03,   3.76,    0.01,  4.80e-16,  4.70e-16,  5.21e-16,  nan ],
	[    62,    0.87,   0.04,   0.73,   0.04,   1.13,   0.03,   3.48,    0.01,  5.73e-16,  5.84e-16,  5.13e-16,  nan ],
	[    63,    0.93,   0.03,   0.75,   0.04,   1.17,   0.03,   4.13,    0.01,  6.77e-16,  5.04e-16,  5.04e-16,  nan ],
	[    64,    1.08,   0.03,   0.80,   0.04,   1.29,   0.03,   4.14,    0.01,  5.55e-16,  6.68e-16,  4.74e-16,  nan ],
	[    65,    0.82,   0.04,   0.77,   0.05,   1.23,   0.03,   3.82,    0.01,  4.51e-16,  4.67e-16,  4.51e-16,  nan ],
	[    66,    0.76,   0.05,   0.77,   0.05,   1.19,   0.03,   4.04,    0.01,  6.46e-16,  5.80e-16,  6.81e-16,  nan ],
	[    67,    0.85,   0.04,   0.81,   0.05,   1.18,   0.03,   4.53,    0.01,  4.74e-16,  5.30e-16,  4.74e-16,  nan ],
	[    68,    0.84,   0.04,   0.82,   0.05,   1.27,   0.03,   4.17,    0.01,  6.27e-16,  4.31e-16,  4.67e-16,  nan ],
	[    69,    0.91,   0.04,   0.85,   0.05,   1.30,   0.03,   4.41,    0.01,  6.26e-16,  6.37e-16,  6.51e-16,  nan ],
	[    70,    0.93,   0.04,   0.87,   0.05,   1.33,   0.03,   4.94,    0.01,  6.60e-16,  6.42e-16,  6.42e-16,  nan ],
	[    71,    0.91,   0.05,   0.89,   0.05,   1.37,   0.03,   4.11,    0.01,  1.00e-15,  8.07e-16,  7.22e-16,  nan ],
	[    72,    0.94,   0.05,   0.94,   0.05,   1.41,   0.03,   4.67,    0.01,  8.14e-16,  7.89e-16,  6.24e-16,  nan ],
	[    73,    0.97,   0.05,   0.95,   0.05,   1.40,   0.03,   5.53,    0.01,  7.02e-16,  5.92e-16,  7.02e-16,  nan ],
	[    74,    0.97,   0.05,   0.97,   0.05,   1.44,   0.03,   4.46,    0.01,  7.74e-16,  7.74e-16,  6.15e-16,  nan ],
	[    75,    1.02,   0.05,   1.02,   0.05,   1.48,   0.03,   4.19,    0.01,  1.07e-15,  8.04e-16,  8.04e-16,  nan ],
	[    76,    1.05,   0.05,   1.00,   0.05,   1.52,   0.03,   4.71,    0.01,  6.27e-16,  7.71e-16,  7.71e-16,  nan ],
	[    77,    1.10,   0.04,   1.05,   0.05,   1.68,   0.03,   5.34,    0.01,  6.65e-16,  7.44e-16,  5.61e-16,  nan ],
	[    78,    1.16,   0.04,   1.08,   0.05,   1.71,   0.03,   4.43,    0.01,  6.57e-16,  5.54e-16,  5.15e-16,  nan ],
	[    79,    1.19,   0.04,   1.11,   0.05,   1.71,   0.03,   5.20,    0.01,  7.42e-16,  9.17e-16,  7.68e-16,  nan ],
	[    80,    1.21,   0.04,   1.13,   0.05,   1.79,   0.03,   3.47,    0.02,  6.40e-16,  5.62e-16,  5.62e-16,  nan ],
	[    81,    1.19,   0.05,   1.12,   0.05,   1.67,   0.03,   4.87,    0.01,  7.49e-16,  7.23e-16,  7.23e-16,  nan ],
	[    82,    1.22,   0.05,   1.14,   0.05,   1.66,   0.03,   5.47,    0.01,  5.48e-16,  6.99e-16,  5.48e-16,  nan ],
	[    83,    1.22,   0.05,   1.17,   0.05,   1.69,   0.03,   5.60,    0.01,  7.26e-16,  7.66e-16,  7.26e-16,  nan ],
	[    84,    1.28,   0.04,   1.17,   0.05,   1.80,   0.03,   5.24,    0.01,  6.16e-16,  7.18e-16,  5.35e-16,  nan ],
	[    85,    1.33,   0.04,   1.22,   0.05,   1.79,   0.03,   4.84,    0.01,  6.89e-16,  8.52e-16,  6.89e-16,  nan ],
	[    86,    1.31,   0.05,   1.26,   0.05,   1.87,   0.03,   5.05,    0.01,  5.23e-16,  5.23e-16,  5.96e-16,  nan ],
	[    87,    1.31,   0.05,   1.28,   0.05,   1.87,   0.03,   5.17,    0.01,  6.53e-16,  6.85e-16,  5.48e-16,  nan ],
	[    88,    1.43,   0.04,   1.26,   0.05,   1.97,   0.03,   5.29,    0.01,  5.11e-16,  6.66e-16,  5.82e-16,  nan ],
	[    89,    1.37,   0.05,   1.34,   0.05,   1.96,   0.03,   6.43,    0.01,  7.14e-16,  5.05e-16,  5.05e-16,  nan ],
	[    90,    1.40,   0.05,   1.37,   0.05,   1.99,   0.03,   5.53,    0.01,  7.93e-16,  8.14e-16,  8.24e-16,  nan ],
	[   100,    1.73,   0.05,   1.69,   0.05,   2.38,   0.03,   5.87,    0.01,  6.55e-16,  5.17e-16,  6.03e-16,  nan ],
	[   110,    2.13,   0.05,   1.89,   0.05,   2.90,   0.03,   6.14,    0.02,  5.33e-16,  5.78e-16,  6.59e-16,  nan ],
	[   120,    2.48,   0.05,   2.24,   0.05,   3.33,   0.04,   7.77,    0.02,  7.32e-16,  7.11e-16,  5.59e-16,  nan ],
	[   130,    2.48,   0.06,   2.54,   0.05,   3.52,   0.04,   6.83,    0.02,  9.78e-16,  8.54e-16,  8.90e-16,  nan ],
	[   140,    2.88,   0.06,   2.89,   0.05,   4.08,   0.04,   7.91,    0.02,  6.42e-16,  8.67e-16,  8.37e-16,  nan ],
	[   150,    3.30,   0.06,   3.13,   0.06,   4.43,   0.04,   7.94,    0.02,  8.09e-16,  9.52e-16,  8.94e-16,  nan ],
	[   160,    3.45,   0.06,   3.77,   0.05,   5.16,   0.04,   7.35,    0.03,  8.88e-16,  9.06e-16,  9.57e-16,  nan ],
	[   170,    3.96,   0.06,   3.90,   0.06,   5.43,   0.04,   8.58,    0.03,  1.02e-15,  1.17e-15,  9.00e-16,  nan ],
	[   180,    4.37,   0.06,   4.35,   0.06,   5.80,   0.05,   8.43,    0.03,  9.68e-16,  9.99e-16,  1.03e-15,  nan ],
	[   190,    5.11,   0.06,   4.70,   0.06,   6.75,   0.04,   8.54,    0.03,  1.08e-15,  1.09e-15,  1.09e-15,  nan ],
	[   200,    5.20,   0.06,   5.12,   0.06,   6.86,   0.05,   8.96,    0.04,  1.14e-15,  9.95e-16,  9.10e-16,  nan ],
	[   210,    5.48,   0.06,   5.46,   0.07,   7.41,   0.05,   9.14,    0.04,  1.12e-15,  1.21e-15,  1.03e-15,  nan ],
	[   220,    5.82,   0.07,   5.99,   0.07,   7.94,   0.05,   9.24,    0.04,  1.05e-15,  1.04e-15,  9.32e-16,  nan ],
	[   230,    6.27,   0.07,   6.45,   0.07,   8.51,   0.05,   9.45,    0.05,  1.38e-15,  1.17e-15,  1.41e-15,  nan ],
	[   240,    6.92,   0.07,   6.92,   0.07,   9.44,   0.05,   9.26,    0.05,  1.19e-15,  1.09e-15,  1.21e-15,  nan ],
	[   250,    7.20,   0.07,   7.27,   0.07,   9.34,   0.05,   9.46,    0.05,  1.16e-15,  1.27e-15,  1.04e-15,  nan ],
	[   260,    7.27,   0.07,   7.76,   0.07,   9.92,   0.05,   9.39,    0.06,  1.35e-15,  1.11e-15,  1.11e-15,  nan ],
	[   270,    7.91,   0.07,   8.25,   0.07,  10.47,   0.06,   9.80,    0.06,  1.28e-15,  1.26e-15,  1.10e-15,  nan ],
	[   280,    8.64,   0.07,   8.76,   0.07,  11.50,   0.05,   9.41,    0.07,  1.06e-15,  1.09e-15,  1.28e-15,  nan ],
	[   290,    8.54,   0.08,   8.78,   0.08,  11.30,   0.06,   9.95,    0.07,  1.38e-15,  1.96e-15,  1.58e-15,  nan ],
	[   300,    9.17,   0.08,   9.28,   0.08,  11.86,   0.06,  10.05,    0.07,  1.36e-15,  1.20e-15,  1.41e-15,  nan ],
	[   310,    9.79,   0.08,   9.79,   0.08,  12.46,   0.06,   9.76,    0.08,  1.44e-15,  1.48e-15,  1.31e-15,  nan ],
	[   320,   11.10,   0.07,  10.72,   0.08,  13.08,   0.06,  10.04,    0.08,  2.05e-15,  2.08e-15,  2.08e-15,  nan ],
	[   330,   10.17,   0.09,  10.55,   0.08,  13.25,   0.07,  10.08,    0.09,  1.72e-15,  1.57e-15,  1.39e-15,  nan ],
	[   340,   10.91,   0.09,  11.20,   0.08,  13.86,   0.07,  10.20,    0.09,  1.35e-15,  1.53e-15,  1.38e-15,  nan ],
	[   350,   11.56,   0.09,  11.56,   0.09,  14.69,   0.07,   9.64,    0.10,  1.31e-15,  1.34e-15,  1.31e-15,  nan ],
	[   360,   11.83,   0.09,  11.83,   0.09,  14.85,   0.07,  10.02,    0.10,  1.41e-15,  1.61e-15,  1.47e-15,  nan ],
	[   370,   12.37,   0.09,  12.78,   0.09,  15.69,   0.07,  10.27,    0.11,  1.54e-15,  1.24e-15,  1.40e-15,  nan ],
	[   380,   12.60,   0.09,  12.90,   0.09,  15.90,   0.07,  10.18,    0.11,  1.67e-15,  1.67e-15,  1.67e-15,  nan ],
	[   390,   12.87,   0.09,  13.41,   0.09,  16.53,   0.07,  10.09,    0.12,  1.46e-15,  1.89e-15,  1.46e-15,  nan ],
	[   400,    9.96,   0.13,  13.96,   0.09,  17.38,   0.07,  10.21,    0.13,  1.48e-15,  1.73e-15,  1.56e-15,  nan ],
	[   410,   13.35,   0.10,  14.19,   0.10,  17.31,   0.08,  10.15,    0.13,  1.58e-15,  1.55e-15,  1.80e-15,  nan ],
	[   420,   13.62,   0.10,  14.59,   0.10,  18.39,   0.08,  10.12,    0.14,  1.33e-15,  1.33e-15,  1.28e-15,  nan ],
	[   430,   13.90,   0.11,  15.15,   0.10,  18.75,   0.08,   9.96,    0.15,  1.76e-15,  1.72e-15,  1.67e-15,  nan ],
	[   440,   14.65,   0.11,  15.37,   0.10,  19.40,   0.08,   9.97,    0.16,  1.43e-15,  1.43e-15,  1.42e-15,  nan ],
	[   450,   14.51,   0.11,  15.78,   0.10,  19.82,   0.08,  10.28,    0.16,  1.48e-15,  1.69e-15,  1.66e-15,  nan ],
	[   460,   15.03,   0.11,  16.49,   0.10,  20.24,   0.08,  10.29,    0.16,  1.98e-15,  1.86e-15,  1.87e-15,  nan ],
	[   470,   15.56,   0.11,  16.90,   0.10,  21.12,   0.08,  10.43,    0.17,  1.93e-15,  1.53e-15,  1.47e-15,  nan ],
	[   480,   15.79,   0.12,  17.59,   0.11,  21.48,   0.09,  10.57,    0.17,  1.88e-15,  1.70e-15,  1.62e-15,  nan ],
	[   490,   16.03,   0.12,  17.49,   0.11,  20.72,   0.09,  10.26,    0.19,  1.77e-15,  1.72e-15,  1.94e-15,  nan ],
	[   500,   16.73,   0.12,  18.09,   0.11,  21.80,   0.09,  10.44,    0.19,  2.06e-15,  1.82e-15,  1.59e-15,  nan ],
	[   510,   16.70,   0.12,  18.62,   0.11,  22.16,   0.09,  10.03,    0.21,  1.56e-15,  1.62e-15,  1.41e-15,  nan ],
	[   520,   17.20,   0.13,  18.84,   0.12,  22.81,   0.10,   9.99,    0.22,  1.99e-15,  1.77e-15,  1.82e-15,  nan ],
	[   530,   17.87,   0.13,  19.61,   0.11,  23.51,   0.10,  10.39,    0.22,  2.27e-15,  2.27e-15,  2.45e-15,  nan ],
	[   540,   18.14,   0.13,  20.19,   0.12,  23.87,   0.10,  10.44,    0.22,  1.84e-15,  1.80e-15,  1.76e-15,  nan ],
	[   550,   18.54,   0.13,  20.56,   0.12,  24.00,   0.10,  10.28,    0.24,  1.89e-15,  1.91e-15,  1.89e-15,  nan ],
	[   560,   18.77,   0.13,  20.98,   0.12,  25.18,   0.10,  10.56,    0.24,  1.65e-15,  1.64e-15,  1.63e-15,  nan ],
	[   570,   19.01,   0.14,  21.35,   0.12,  25.84,   0.10,  10.30,    0.25,  2.06e-15,  2.11e-15,  2.06e-15,  nan ],
	[   580,   19.28,   0.14,  21.76,   0.12,  24.98,   0.11,  10.54,    0.26,  2.48e-15,  2.48e-15,  2.26e-15,  nan ],
	[   590,   19.65,   0.14,  22.35,   0.12,  26.61,   0.10,  10.62,    0.26,  1.94e-15,  2.34e-15,  2.32e-15,  nan ],
	[   600,   20.35,   0.14,  22.76,   0.13,  26.97,   0.11,  10.61,    0.27,  1.95e-15,  1.95e-15,  2.16e-15,  nan ],
	[   610,   20.19,   0.15,  23.14,   0.13,  27.39,   0.11,  10.54,    0.28,  2.15e-15,  1.59e-15,  1.72e-15,  nan ],
	[   620,   21.13,   0.15,  23.55,   0.13,  28.29,   0.11,  10.59,    0.29,  2.22e-15,  2.12e-15,  2.21e-15,  nan ],
	[   630,   21.53,   0.15,  24.10,   0.13,  27.64,   0.12,  10.61,    0.30,  1.99e-15,  1.99e-15,  1.99e-15,  nan ],
	[   640,   22.51,   0.15,  25.28,   0.13,  29.31,   0.11,  10.70,    0.31,  1.80e-15,  1.88e-15,  1.99e-15,  nan ],
	[   650,   22.00,   0.15,  25.06,   0.14,  29.98,   0.11,  10.49,    0.32,  1.99e-15,  1.93e-15,  1.80e-15,  nan ],
	[   660,   22.26,   0.16,  25.66,   0.14,  30.08,   0.12,  10.65,    0.33,  2.21e-15,  1.83e-15,  1.83e-15,  nan ],
	[   670,   22.91,   0.16,  26.48,   0.14,  30.75,   0.12,  10.62,    0.34,  2.43e-15,  2.21e-15,  2.10e-15,  nan ],
	[   680,   23.31,   0.16,  26.09,   0.14,  31.41,   0.12,  10.42,    0.36,  2.01e-15,  2.02e-15,  1.84e-15,  nan ],
	[   690,   23.54,   0.16,  27.09,   0.14,  31.58,   0.12,  10.52,    0.36,  2.38e-15,  2.38e-15,  2.22e-15,  nan ],
	[   700,   23.67,   0.17,  27.46,   0.14,  32.50,   0.12,  10.71,    0.37,  2.36e-15,  2.44e-15,  2.28e-15,  nan ],
	[   710,   24.49,   0.16,  26.95,   0.15,  33.11,   0.12,  10.55,    0.38,  1.96e-15,  2.41e-15,  2.12e-15,  nan ],
	[   720,   24.45,   0.17,  28.30,   0.15,  33.26,   0.12,  10.65,    0.39,  2.08e-15,  2.38e-15,  2.44e-15,  nan ],
	[   730,   25.27,   0.17,  28.85,   0.15,  32.88,   0.13,  10.68,    0.40,  2.34e-15,  2.32e-15,  2.19e-15,  nan ],
	[   740,   24.95,   0.18,  28.50,   0.15,  33.00,   0.13,   6.52,    0.67,  2.35e-15,  2.62e-15,  2.48e-15,  nan ],
	[   750,   26.05,   0.17,  29.46,   0.15,  33.89,   0.13,  10.61,    0.43,  2.29e-15,  2.06e-15,  2.02e-15,  nan ],
	[   760,   26.64,   0.17,  30.06,   0.15,  34.25,   0.14,  10.31,    0.45,  2.72e-15,  2.85e-15,  2.69e-15,  nan ],
	[   770,   26.86,   0.18,  30.25,   0.16,  34.67,   0.14,  10.59,    0.45,  2.25e-15,  2.58e-15,  1.92e-15,  nan ],
	[   780,   26.53,   0.18,  31.08,   0.16,  35.08,   0.14,  10.74,    0.45,  2.17e-15,  2.15e-15,  2.10e-15,  nan ],
	[   790,   26.46,   0.19,  30.90,   0.16,  34.97,   0.14,  10.69,    0.47,  2.55e-15,  2.65e-15,  2.51e-15,  nan ],
	[   800,   27.58,   0.19,  31.69,   0.16,  35.33,   0.15,   9.79,    0.52,  2.42e-15,  2.03e-15,  2.11e-15,  nan ],
	[   810,   28.13,   0.19,  32.68,   0.16,  37.01,   0.14,  10.62,    0.49,  2.39e-15,  2.26e-15,  2.27e-15,  nan ],
	[   820,   28.68,   0.19,  33.09,   0.16,  37.42,   0.14,  10.76,    0.50,  2.92e-15,  2.91e-15,  2.77e-15,  nan ],
	[   830,   28.91,   0.19,  33.66,   0.16,  38.09,   0.14,   6.63,    0.83,  1.94e-15,  2.20e-15,  2.20e-15,  nan ],
	[   840,   29.14,   0.19,  33.45,   0.17,  37.71,   0.15,   6.52,    0.87,  2.50e-15,  2.34e-15,  2.40e-15,  nan ],
	[   850,   30.02,   0.19,  34.84,   0.17,  38.86,   0.15,  10.64,    0.54,  2.43e-15,  2.21e-15,  2.04e-15,  nan ],
	[   860,   30.58,   0.19,  35.26,   0.17,  38.97,   0.15,   8.38,    0.71,  2.66e-15,  2.60e-15,  2.60e-15,  nan ],
	[   870,   30.80,   0.20,  29.90,   0.20,  38.14,   0.16,  10.57,    0.57,  2.61e-15,  2.62e-15,  2.36e-15,  nan ],
	[   880,   30.88,   0.20,  36.05,   0.17,  39.02,   0.16,  10.56,    0.59,  2.15e-15,  2.25e-15,  2.10e-15,  nan ],
	[   890,   31.14,   0.20,  35.64,   0.18,  38.47,   0.16,   6.48,    0.98,  2.23e-15,  2.30e-15,  2.39e-15,  nan ],
	[   900,   31.36,   0.21,  36.44,   0.18,  39.86,   0.16,  10.52,    0.62,  2.49e-15,  2.58e-15,  2.54e-15,  nan ],
	[  1000,   34.54,   0.23,  40.25,   0.20,  43.53,   0.18,   7.94,    1.01,  2.91e-15,  2.52e-15,  2.56e-15,  nan ],
	[  1100,   37.58,   0.26,  44.24,   0.22,  27.85,   0.35,   9.69,    1.00,  3.65e-15,  2.94e-15,  2.90e-15,  nan ],
	[  1200,   40.89,   0.28,  49.07,   0.24,  30.37,   0.38,   9.19,    1.26,  3.29e-15,  3.26e-15,  3.42e-15,  nan ],
	[  1300,   43.94,   0.31,  54.12,   0.25,  31.86,   0.42,   8.49,    1.59,  2.97e-15,  2.80e-15,  2.83e-15,  nan ],
	[  1400,   48.88,   0.32,  58.37,   0.27,  31.59,   0.50,   8.30,    1.89,  3.26e-15,  3.47e-15,  3.08e-15,  nan ],
	[  1500,   52.37,   0.34,  62.30,   0.29,  36.69,   0.49,   8.18,    2.20,  2.93e-15,  3.07e-15,  3.05e-15,  nan ],
	[  1600,   55.54,   0.37,  68.13,   0.30,  38.75,   0.53,   6.83,    3.00,  3.13e-15,  3.02e-15,  3.13e-15,  nan ],
	[  1700,   59.04,   0.39,  71.84,   0.32,  42.31,   0.55,   8.33,    2.78,  3.36e-15,  3.41e-15,  3.21e-15,  nan ],
	[  1800,   61.61,   0.42,  73.92,   0.35,  42.52,   0.61,   5.49,    4.72,  4.38e-15,  4.54e-15,  4.69e-15,  nan ],
	[  1900,   65.81,   0.44,  75.86,   0.38,  43.67,   0.66,   8.38,    3.45,  3.59e-15,  3.83e-15,  4.08e-15,  nan ],
	[  2000,   64.05,   0.50,  75.89,   0.42,  45.49,   0.70,   7.75,    4.13,  3.65e-15,  3.67e-15,  3.89e-15,  nan ],
	[  2100,   65.00,   0.54,  77.25,   0.46,  34.75,   1.02,   8.39,    4.21,  6.07e-15,  5.02e-15,  6.11e-15,  nan ],
	[  2200,   66.22,   0.59,  77.65,   0.50,  36.94,   1.05,   7.73,    5.01,  3.96e-15,  3.89e-15,  3.69e-15,  nan ],
	[  2300,   66.90,   0.63,  77.43,   0.55,  37.81,   1.12,   5.59,    7.58,  4.81e-15,  4.26e-15,  4.36e-15,  nan ],
	[  2400,   68.92,   0.67,  78.42,   0.59,  39.96,   1.15,   7.60,    6.07,  4.94e-15,  6.12e-15,  5.35e-15,  nan ],
	[  2500,   70.75,   0.71,  78.04,   0.64,  41.18,   1.21,   7.93,    6.31,  4.82e-15,  4.92e-15,  5.28e-15,  nan ],
	[  2600,   71.48,   0.76,  78.32,   0.69,  40.66,   1.33,   8.25,    6.56,  4.04e-15,  4.36e-15,  4.12e-15,  nan ],
	[  2700,   72.95,   0.80,  78.34,   0.74,  44.07,   1.32,   8.38,    6.96,  5.41e-15,  4.79e-15,  5.22e-15,  nan ],
	[  2800,   75.35,   0.83,  80.05,   0.78,  39.39,   1.59,   8.08,    7.76,  5.05e-15,  5.05e-15,  5.24e-15,  nan ],
	[  2900,   74.46,   0.90,  80.71,   0.83,  46.52,   1.45,   8.46,    7.96,  5.33e-15,  5.35e-15,  6.32e-15,  nan ],
	[  3000,   77.47,   0.93,  81.59,   0.88,  47.36,   1.52,   8.35,    8.63,  4.80e-15,  4.72e-15,  4.70e-15,  nan ],
	[  3100,   78.48,   0.98,  82.81,   0.93,  39.22,   1.96,   8.36,    9.20,  5.19e-15,  5.50e-15,  5.79e-15,  nan ],
	[  3200,   79.65,   1.03,  83.56,   0.98,  40.98,   2.00,   5.82,   14.09,  5.40e-15,  5.92e-15,  5.41e-15,  nan ],
	[  3300,   81.60,   1.07,  84.45,   1.03,  41.60,   2.10,   5.63,   15.47,  4.76e-15,  5.11e-15,  5.52e-15,  nan ],
	[  3400,   81.24,   1.14,  85.99,   1.08,  42.24,   2.19,   5.59,   16.56,  4.99e-15,  4.91e-15,  5.40e-15,  nan ],
	[  3500,   83.51,   1.17,  86.68,   1.13,  43.52,   2.25,   5.58,   17.56,  5.52e-15,  5.19e-15,  5.35e-15,  nan ],
	[  3600,   86.15,   1.20,  86.96,   1.19,  43.86,   2.37,   7.94,   13.06,  5.32e-15,  4.66e-15,  4.84e-15,  nan ],
	[  3700,   86.89,   1.26,  87.30,   1.26,  44.48,   2.46,   8.40,   13.05,  5.90e-15,  5.96e-15,  5.50e-15,  nan ],
	[  3800,   88.55,   1.31,  88.15,   1.31,  45.73,   2.53,   8.32,   13.90,  6.32e-15,  6.32e-15,  5.75e-15,  nan ],
	[  3900,   87.07,   1.40,  88.01,   1.38,  47.38,   2.57,   8.35,   14.58,  5.69e-15,  5.87e-15,  5.85e-15,  nan ],
	[  4000,   87.23,   1.47,  88.36,   1.45,  46.94,   2.73,   7.58,   16.90,  6.07e-15,  6.24e-15,  6.19e-15,  nan ],
	[  4100,   87.52,   1.54,  88.33,   1.52,  37.67,   3.57,   7.85,   17.13,  7.58e-15,  6.75e-15,  6.77e-15,  nan ],
	[  4200,   88.07,   1.60,  89.23,   1.58,  41.55,   3.40,   8.25,   17.12,  5.38e-15,  5.44e-15,  5.83e-15,  nan ],
	[  4300,   89.30,   1.66,  89.20,   1.66,  42.70,   3.47,   8.40,   17.62,  7.09e-15,  7.48e-15,  6.85e-15,  nan ],
	[  4400,   90.71,   1.71,  89.30,   1.73,  42.42,   3.65,   8.04,   19.26,  8.27e-15,  8.48e-15,  7.80e-15,  nan ],
	[  4500,   90.28,   1.80,  89.33,   1.81,  45.28,   3.58,   8.43,   19.22,  6.07e-15,  6.87e-15,  6.12e-15,  nan ],
	[  4600,   91.19,   1.86,  89.41,   1.89,  45.53,   3.72,   8.33,   20.34,  6.07e-15,  5.73e-15,  6.42e-15,  nan ],
	[  4700,   92.80,   1.90,  90.05,   1.96,  45.66,   3.87,   8.54,   20.70,  7.42e-15,  9.41e-15,  8.83e-15,  nan ],
	[  4800,   92.74,   1.99,  89.29,   2.06,  45.55,   4.05,   6.95,   26.52,  6.90e-15,  7.21e-15,  7.61e-15,  nan ],
	[  4900,   91.98,   2.09,  89.49,   2.15,  47.22,   4.07,   8.53,   22.52,  6.72e-15,  7.17e-15,  6.81e-15,  nan ],
	[  5000,   92.62,   2.16,  90.20,   2.22,  47.63,   4.20,   8.46,   23.66,  7.08e-15,  6.39e-15,  6.63e-15,  nan ],
	[  5100,   93.76,   2.22,  90.73,   2.29,  47.86,   4.35,   8.48,   24.54,  6.77e-15,  7.20e-15,  7.69e-15,  nan ],
	[  5200,   94.54,   2.29,  91.77,   2.36,  43.47,   4.98,   8.18,   26.44,  7.67e-15,  7.32e-15,  7.63e-15,  nan ],
	[  5300,   94.45,   2.38,  91.60,   2.45,  44.28,   5.08,   8.57,   26.22,  8.51e-15,  8.42e-15,  7.62e-15,  nan ],
	[  5400,   95.78,   2.44,  91.94,   2.54,  43.81,   5.33,   8.37,   27.88,  6.74e-15,  7.04e-15,  6.80e-15,  nan ],
	[  5500,   95.67,   2.53,  91.52,   2.65,  44.36,   5.46,   8.55,   28.33,  7.61e-15,  7.40e-15,  6.95e-15,  nan ],
	[  5600,   97.12,   2.58,  91.29,   2.75,  46.51,   5.40,   7.70,   32.58,  8.96e-15,  8.30e-15,  8.46e-15,  nan ],
	[  5700,   98.86,   2.63,  91.67,   2.84,  46.12,   5.64,   8.56,   30.37,  7.18e-15,  8.18e-15,  6.99e-15,  nan ],
	[  5800,   97.15,   2.77,  92.31,   2.92,  47.35,   5.69,   8.60,   31.31,  8.33e-15,  7.19e-15,  7.67e-15,  nan ],
	[  5900,   97.39,   2.86,  91.63,   3.04,  47.63,   5.85,   8.62,   32.30,  8.18e-15,  9.25e-15,  8.50e-15,  nan ],
	[  6000,   99.27,   2.90,  92.66,   3.11,  48.69,   5.92,   8.36,   34.47,  6.85e-15,  7.70e-15,  7.40e-15,  nan ],
	[  6100,   98.34,   3.03,  92.15,   3.23,  48.68,   6.12,   8.32,   35.80,  7.53e-15,  7.95e-15,  7.67e-15,  nan ],
	[  6200,   99.10,   3.10,  92.96,   3.31,  43.80,   7.02,   8.77,   35.06,  8.04e-15,  7.28e-15,  7.09e-15,  nan ],
	[  6300,   99.16,   3.20,  92.67,   3.43,  45.00,   7.06,   8.64,   36.74,  8.91e-15,  8.75e-15,  8.88e-15,  nan ],
	[  6400,   98.99,   3.31,  91.71,   3.57,  45.70,   7.17,   8.64,   37.95,  7.11e-15,  7.39e-15,  7.25e-15,  nan ],
	[  6500,  100.53,   3.36,  92.07,   3.67,  45.77,   7.39,   8.11,   41.68,  7.85e-15,  8.97e-15,  8.12e-15,  nan ],
	[  6600,  100.24,   3.48,  92.70,   3.76,  45.52,   7.66,   8.63,   40.39,  7.30e-15,  7.44e-15,  7.23e-15,  nan ],
	[  6700,  100.08,   3.59,  92.08,   3.90,  46.94,   7.65,   8.33,   43.10,  9.14e-15,  9.40e-15,  9.01e-15,  nan ],
	[  6800,   99.89,   3.70,  92.41,   4.00,  46.87,   7.89,   8.30,   44.57,  9.71e-15,  9.71e-15,  9.50e-15,  nan ],
	[  6900,  100.20,   3.80,  92.72,   4.11,  47.01,   8.10,   8.25,   46.19,  8.25e-15,  8.55e-15,  8.49e-15,  nan ],
	[  7000,  100.51,   3.90,  92.58,   4.24,  48.37,   8.11,   8.58,   45.70,  8.67e-15,  7.43e-15,  7.18e-15,  nan ],
	[  7100,   99.50,   4.05,  93.56,   4.31,  48.75,   8.27,   8.22,   49.05,  8.33e-15,  8.20e-15,  7.80e-15,  nan ],
	[  7200,  101.15,   4.10,  92.59,   4.48,  45.01,   9.21,   8.57,   48.43,  8.59e-15,  7.78e-15,  8.09e-15,  nan ],
	[  7300,  102.98,   4.14,  93.63,   4.55,  45.49,   9.37,   7.83,   54.46,  8.85e-15,  7.86e-15,  8.49e-15,  nan ],
	[  7400,  102.21,   4.29,  92.64,   4.73,  45.72,   9.58,   8.21,   53.37,  8.38e-15,  8.65e-15,  8.61e-15,  nan ],
	[  7500,  103.83,   4.33,  93.32,   4.82,  45.07,   9.99,   8.10,   55.58,  9.37e-15,  9.78e-15,  9.40e-15,  nan ],
	[  7600,  104.14,   4.44,  93.48,   4.94,  46.66,   9.91,   8.06,   57.33,  9.15e-15,  8.27e-15,  8.71e-15,  nan ],
	[  7700,  102.22,   4.64,  93.22,   5.09,  47.43,  10.00,   7.98,   59.45,  8.84e-15,  8.34e-15,  9.13e-15,  nan ],
	[  7800,  102.55,   4.75,  93.12,   5.23,  46.95,  10.37,   7.58,   64.18,  8.12e-15,  9.13e-15,  8.24e-15,  nan ],
	[  7900,  103.03,   4.85,  93.32,   5.35,  47.35,  10.55,   7.67,   65.14,  1.04e-14,  1.05e-14,  1.02e-14,  nan ],
	[  8000,  103.28,   4.96,  93.21,   5.49,  48.22,  10.62,   7.51,   68.17,  1.06e-14,  9.34e-15,  1.04e-14,  nan ],
	[  8100,  104.39,   5.03,  93.05,   5.64,  48.42,  10.84,   7.51,   69.95,  1.12e-14,  1.27e-14,  1.19e-14,  nan ],
	[  8200,  103.54,   5.20,  93.49,   5.75,  44.13,  12.19,   7.39,   72.83,  9.85e-15,  9.72e-15,  9.66e-15,  nan ],
	[  8300,  105.09,   5.24,  94.31,   5.85,  45.41,  12.14,   7.23,   76.21,  9.43e-15,  9.61e-15,  8.37e-15,  nan ],
	[  8400,  104.40,   5.41,  93.95,   6.01,  45.43,  12.43,   7.60,   74.30,  9.52e-15,  9.29e-15,  1.09e-14,  nan ],
	[  8500,  103.71,   5.57,  93.48,   6.18,  46.69,  12.38,   7.50,   77.09,  8.73e-15,  9.08e-15,  9.32e-15,  nan ],
	[  8600,  104.80,   5.65,  94.29,   6.28,  47.48,  12.47,   7.70,   76.88,  9.74e-15,  1.02e-14,  9.12e-15,  nan ],
	[  8700,  103.79,   5.84,  93.76,   6.46,  46.31,  13.08,   7.42,   81.64,  9.92e-15,  9.88e-15,  9.97e-15,  nan ],
	[  8800,  104.70,   5.92,  92.90,   6.67,  48.09,  12.89,   7.97,   77.74,  9.75e-15,  9.41e-15,  9.49e-15,  nan ],
	[  8900,  105.58,   6.00,  94.13,   6.73,  47.02,  13.48,   8.09,   78.38,  9.93e-15,  9.80e-15,  1.04e-14,  nan ],
	[  9000,  105.37,   6.15,  94.21,   6.88,  47.84,  13.55,   8.09,   80.12,  1.05e-14,  1.03e-14,  1.03e-14,  nan ],
	[ 10000,  106.67,   7.50,  94.23,   8.49,  47.90,  16.70,   8.34,   95.91,  9.28e-15,  1.01e-14,  9.12e-15,  nan ],
	[ 12000,  110.03,  10.47,  93.53,  12.32,  48.67,  23.67,   8.28,  139.09,  1.42e-14,  1.38e-14,  1.26e-14,  nan ],
	[ 14000,  112.51,  13.94,  95.20,  16.47,  47.70,  32.87,   8.44,  185.70,  1.34e-14,  1.27e-14,  1.30e-14,  nan ],
	[ 16000,  111.07,  18.44,  94.31,  21.72,  46.89,  43.68,   9.01,  227.37,  1.32e-14,  1.36e-14,  1.29e-14,  nan ],
	[ 18000,  108.35,  23.92,  94.94,  27.31,  47.51,  54.56,   8.41,  308.12,  1.44e-14,  1.48e-14,  1.40e-14,  nan ],
	[ 20000,  110.84,  28.87,  94.36,  33.92,  47.35,  67.59,   8.33,  383.95,  1.64e-14,  1.48e-14,  1.55e-14,  nan ],
])

# numactl --interleave=all ../testing/testing_zhemv -U -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
zhemv_U = array([
	[    10,    0.03,   0.03,    0.03,   0.03,   0.04,   0.02,   0.48,    0.00,  7.16e-16,  3.66e-16,  7.16e-16,  nan ],
	[    11,    0.03,   0.03,    0.04,   0.03,   0.05,   0.02,   0.58,    0.00,  3.33e-16,  2.91e-16,  2.28e-16,  nan ],
	[    12,    0.04,   0.03,    0.04,   0.03,   0.06,   0.02,   0.68,    0.00,  5.78e-16,  3.31e-16,  2.96e-16,  nan ],
	[    13,    0.05,   0.03,    0.05,   0.03,   0.07,   0.02,   0.79,    0.00,  3.42e-16,  5.51e-16,  2.05e-16,  nan ],
	[    14,    0.05,   0.03,    0.06,   0.03,   0.08,   0.02,   0.61,    0.00,  2.84e-16,  2.54e-16,  2.84e-16,  nan ],
	[    15,    0.06,   0.04,    0.07,   0.03,   0.09,   0.02,   0.92,    0.00,  3.74e-16,  3.60e-16,  3.74e-16,  nan ],
	[    16,    0.07,   0.03,    0.08,   0.03,   0.11,   0.02,   1.17,    0.00,  3.33e-16,  4.44e-16,  3.51e-16,  nan ],
	[    17,    0.07,   0.03,    0.08,   0.03,   0.11,   0.02,   1.17,    0.00,  4.31e-16,  2.34e-16,  4.31e-16,  nan ],
	[    18,    0.08,   0.04,    0.09,   0.03,   0.12,   0.02,   1.31,    0.00,  2.79e-16,  4.07e-16,  4.07e-16,  nan ],
	[    19,    0.09,   0.03,    0.10,   0.03,   0.14,   0.02,   1.09,    0.00,  4.18e-16,  4.18e-16,  4.18e-16,  nan ],
	[    20,    0.10,   0.03,    0.11,   0.03,   0.15,   0.02,   1.20,    0.00,  3.97e-16,  5.35e-16,  3.97e-16,  nan ],
	[    21,    0.11,   0.03,    0.12,   0.03,   0.16,   0.02,   1.22,    0.00,  3.49e-16,  3.78e-16,  3.49e-16,  nan ],
	[    22,    0.12,   0.04,    0.13,   0.03,   0.17,   0.02,   1.33,    0.00,  5.11e-16,  4.91e-16,  4.04e-16,  nan ],
	[    23,    0.13,   0.03,    0.15,   0.03,   0.19,   0.02,   1.58,    0.00,  3.18e-16,  5.57e-16,  3.09e-16,  nan ],
	[    24,    0.14,   0.03,    0.16,   0.03,   0.20,   0.02,   1.58,    0.00,  4.68e-16,  4.68e-16,  3.05e-16,  nan ],
	[    25,    0.16,   0.03,    0.17,   0.03,   0.22,   0.02,   1.85,    0.00,  4.26e-16,  5.68e-16,  4.26e-16,  nan ],
	[    26,    0.16,   0.04,    0.19,   0.03,   0.23,   0.03,   2.00,    0.00,  3.42e-16,  4.32e-16,  4.58e-16,  nan ],
	[    27,    0.19,   0.03,    0.20,   0.03,   0.27,   0.02,   1.52,    0.00,  5.43e-16,  5.43e-16,  3.96e-16,  nan ],
	[    28,    0.20,   0.03,    0.21,   0.03,   0.29,   0.02,   2.13,    0.00,  4.26e-16,  3.83e-16,  4.01e-16,  nan ],
	[    29,    0.21,   0.03,    0.24,   0.03,   0.29,   0.02,   1.75,    0.00,  3.68e-16,  3.47e-16,  2.88e-16,  nan ],
	[    30,    0.23,   0.03,    0.25,   0.03,   0.30,   0.02,   1.98,    0.00,  3.35e-16,  3.35e-16,  5.92e-16,  nan ],
	[    31,    0.24,   0.03,    0.26,   0.03,   0.35,   0.02,   2.11,    0.00,  4.73e-16,  3.44e-16,  3.44e-16,  nan ],
	[    32,    0.27,   0.03,    0.28,   0.03,   0.37,   0.02,   2.12,    0.00,  4.58e-16,  4.58e-16,  4.58e-16,  nan ],
	[    33,    0.28,   0.03,    0.21,   0.04,   0.38,   0.02,   2.39,    0.00,  4.81e-16,  4.81e-16,  4.44e-16,  nan ],
	[    34,    0.29,   0.03,    0.22,   0.04,   0.40,   0.02,   2.38,    0.00,  7.01e-16,  7.01e-16,  4.93e-16,  nan ],
	[    35,    0.30,   0.03,    0.24,   0.04,   0.42,   0.02,   2.52,    0.00,  4.13e-16,  4.54e-16,  4.19e-16,  nan ],
	[    36,    0.32,   0.03,    0.26,   0.04,   0.43,   0.03,   2.66,    0.00,  4.22e-16,  4.41e-16,  6.00e-16,  nan ],
	[    37,    0.34,   0.03,    0.27,   0.04,   0.44,   0.03,   2.28,    0.01,  4.29e-16,  5.81e-16,  4.19e-16,  nan ],
	[    38,    0.33,   0.04,    0.29,   0.04,   0.48,   0.03,   2.40,    0.01,  7.54e-16,  7.48e-16,  6.27e-16,  nan ],
	[    39,    0.35,   0.04,    0.29,   0.04,   0.50,   0.03,   2.52,    0.01,  5.47e-16,  6.11e-16,  6.11e-16,  nan ],
	[    40,    0.37,   0.04,    0.32,   0.04,   0.51,   0.03,   2.65,    0.01,  6.40e-16,  5.02e-16,  5.62e-16,  nan ],
	[    41,    0.41,   0.03,    0.34,   0.04,   0.54,   0.03,   2.78,    0.01,  5.29e-16,  5.27e-16,  5.21e-16,  nan ],
	[    42,    0.41,   0.04,    0.35,   0.04,   0.58,   0.03,   2.92,    0.01,  5.15e-16,  5.15e-16,  3.78e-16,  nan ],
	[    43,    0.45,   0.03,    0.36,   0.04,   0.61,   0.03,   2.57,    0.01,  5.03e-16,  5.03e-16,  5.03e-16,  nan ],
	[    44,    0.44,   0.04,    0.38,   0.04,   0.62,   0.03,   2.69,    0.01,  5.11e-16,  4.91e-16,  6.46e-16,  nan ],
	[    45,    0.45,   0.04,    0.40,   0.04,   0.64,   0.03,   2.81,    0.01,  8.50e-16,  8.05e-16,  8.50e-16,  nan ],
	[    46,    0.50,   0.04,    0.42,   0.04,   0.70,   0.03,   3.67,    0.00,  5.18e-16,  6.29e-16,  4.88e-16,  nan ],
	[    47,    0.49,   0.04,    0.43,   0.04,   0.70,   0.03,   2.94,    0.01,  6.46e-16,  7.57e-16,  6.06e-16,  nan ],
	[    48,    0.54,   0.04,    0.46,   0.04,   0.71,   0.03,   2.75,    0.01,  4.97e-16,  4.68e-16,  5.34e-16,  nan ],
	[    49,    0.56,   0.04,    0.47,   0.04,   0.71,   0.03,   2.86,    0.01,  7.25e-16,  5.80e-16,  5.85e-16,  nan ],
	[    50,    0.57,   0.04,    0.49,   0.04,   0.74,   0.03,   2.98,    0.01,  5.68e-16,  5.70e-16,  6.03e-16,  nan ],
	[    51,    0.59,   0.04,    0.51,   0.04,   0.77,   0.03,   3.10,    0.01,  5.74e-16,  5.57e-16,  5.74e-16,  nan ],
	[    52,    0.62,   0.04,    0.53,   0.04,   0.83,   0.03,   2.83,    0.01,  7.36e-16,  6.83e-16,  6.83e-16,  nan ],
	[    53,    0.64,   0.04,    0.55,   0.04,   0.86,   0.03,   2.85,    0.01,  5.47e-16,  4.24e-16,  5.36e-16,  nan ],
	[    54,    0.67,   0.04,    0.56,   0.04,   0.86,   0.03,   4.02,    0.01,  6.87e-16,  6.61e-16,  6.71e-16,  nan ],
	[    55,    0.66,   0.04,    0.58,   0.04,   0.88,   0.03,   3.16,    0.01,  5.33e-16,  5.52e-16,  5.33e-16,  nan ],
	[    56,    0.72,   0.04,    0.60,   0.04,   0.92,   0.03,   4.32,    0.01,  5.38e-16,  4.57e-16,  4.57e-16,  nan ],
	[    57,    0.70,   0.04,    0.62,   0.04,   0.92,   0.03,   3.86,    0.01,  6.71e-16,  6.36e-16,  5.14e-16,  nan ],
	[    58,    0.73,   0.04,    0.64,   0.04,   0.98,   0.03,   4.63,    0.01,  7.35e-16,  6.93e-16,  7.38e-16,  nan ],
	[    59,    0.79,   0.04,    0.65,   0.04,   0.99,   0.03,   3.63,    0.01,  4.34e-16,  4.97e-16,  4.93e-16,  nan ],
	[    60,    0.77,   0.04,    0.67,   0.04,   1.05,   0.03,   3.64,    0.01,  5.30e-16,  4.88e-16,  4.74e-16,  nan ],
	[    61,    0.78,   0.04,    0.69,   0.04,   1.09,   0.03,   3.76,    0.01,  8.40e-16,  7.81e-16,  1.10e-15,  nan ],
	[    62,    0.90,   0.04,    0.72,   0.04,   1.13,   0.03,   4.40,    0.01,  6.88e-16,  6.88e-16,  5.84e-16,  nan ],
	[    63,    0.88,   0.04,    0.76,   0.04,   1.21,   0.03,   4.01,    0.01,  5.64e-16,  6.86e-16,  4.79e-16,  nan ],
	[    64,    1.08,   0.03,    0.86,   0.04,   1.24,   0.03,   4.85,    0.01,  5.55e-16,  4.97e-16,  4.97e-16,  nan ],
	[    65,    0.84,   0.04,    0.77,   0.04,   1.15,   0.03,   4.27,    0.01,  4.89e-16,  6.65e-16,  4.89e-16,  nan ],
	[    66,    0.89,   0.04,    0.76,   0.05,   1.19,   0.03,   4.98,    0.01,  5.62e-16,  6.89e-16,  4.81e-16,  nan ],
	[    67,    0.92,   0.04,    0.80,   0.05,   1.18,   0.03,   5.13,    0.01,  6.50e-16,  8.55e-16,  8.55e-16,  nan ],
	[    68,    0.88,   0.04,    0.82,   0.05,   1.26,   0.03,   5.47,    0.01,  6.36e-16,  5.33e-16,  5.22e-16,  nan ],
	[    69,    0.93,   0.04,    0.83,   0.05,   1.30,   0.03,   4.41,    0.01,  6.51e-16,  6.51e-16,  6.18e-16,  nan ],
	[    70,    0.95,   0.04,    0.85,   0.05,   1.33,   0.03,   4.42,    0.01,  6.42e-16,  6.11e-16,  6.28e-16,  nan ],
	[    71,    0.93,   0.04,    0.88,   0.05,   1.37,   0.03,   4.55,    0.01,  6.41e-16,  6.17e-16,  6.33e-16,  nan ],
	[    72,    0.94,   0.05,    0.90,   0.05,   1.37,   0.03,   4.80,    0.01,  1.01e-15,  9.92e-16,  7.96e-16,  nan ],
	[    73,    1.01,   0.04,    0.93,   0.05,   1.35,   0.03,   4.80,    0.01,  9.93e-16,  7.85e-16,  7.79e-16,  nan ],
	[    74,    1.00,   0.04,    0.95,   0.05,   1.44,   0.03,   4.93,    0.01,  9.06e-16,  8.59e-16,  7.92e-16,  nan ],
	[    75,    1.09,   0.04,    1.00,   0.05,   1.44,   0.03,   5.66,    0.01,  8.00e-16,  7.94e-16,  7.87e-16,  nan ],
	[    76,    1.10,   0.04,    1.00,   0.05,   1.57,   0.03,   4.71,    0.01,  7.54e-16,  5.91e-16,  7.48e-16,  nan ],
	[    77,    1.15,   0.04,    1.05,   0.05,   1.56,   0.03,   4.83,    0.01,  7.61e-16,  7.44e-16,  5.61e-16,  nan ],
	[    78,    1.10,   0.05,    1.06,   0.05,   1.60,   0.03,   4.95,    0.01,  8.15e-16,  7.29e-16,  7.78e-16,  nan ],
	[    79,    1.24,   0.04,    1.11,   0.05,   1.64,   0.03,   4.64,    0.01,  7.68e-16,  9.04e-16,  7.25e-16,  nan ],
	[    80,    1.24,   0.04,    1.16,   0.05,   1.74,   0.03,   3.98,    0.01,  7.32e-16,  6.40e-16,  5.62e-16,  nan ],
	[    81,    1.27,   0.04,    1.16,   0.05,   1.57,   0.03,   4.87,    0.01,  5.70e-16,  7.57e-16,  7.75e-16,  nan ],
	[    82,    1.31,   0.04,    1.19,   0.05,   1.71,   0.03,   6.05,    0.01,  6.25e-16,  6.93e-16,  5.30e-16,  nan ],
	[    83,    1.25,   0.05,    1.17,   0.05,   1.69,   0.03,   5.60,    0.01,  6.90e-16,  7.06e-16,  8.56e-16,  nan ],
	[    84,    1.28,   0.05,    1.22,   0.05,   1.75,   0.03,   5.74,    0.01,  7.80e-16,  6.98e-16,  5.67e-16,  nan ],
	[    85,    1.31,   0.05,    1.23,   0.05,   1.77,   0.03,   5.36,    0.01,  7.01e-16,  6.70e-16,  6.72e-16,  nan ],
	[    86,    1.40,   0.04,    1.26,   0.05,   1.83,   0.03,   5.49,    0.01,  7.79e-16,  8.26e-16,  9.95e-16,  nan ],
	[    87,    1.34,   0.05,    1.29,   0.05,   1.86,   0.03,   4.70,    0.01,  6.98e-16,  5.17e-16,  5.89e-16,  nan ],
	[    88,    1.43,   0.04,    1.31,   0.05,   1.97,   0.03,   5.75,    0.01,  1.03e-15,  8.43e-16,  7.22e-16,  nan ],
	[    89,    1.46,   0.04,    1.34,   0.05,   1.90,   0.03,   5.75,    0.01,  1.12e-15,  8.60e-16,  1.01e-15,  nan ],
	[    90,    1.43,   0.05,    1.32,   0.05,   2.00,   0.03,   4.68,    0.01,  8.14e-16,  7.89e-16,  7.06e-16,  nan ],
	[   100,    1.76,   0.05,    1.56,   0.05,   2.26,   0.04,   6.81,    0.01,  1.02e-15,  9.10e-16,  1.11e-15,  nan ],
	[   110,    2.19,   0.04,    1.85,   0.05,   2.45,   0.04,   6.53,    0.02,  9.08e-16,  7.79e-16,  6.53e-16,  nan ],
	[   120,    2.64,   0.04,    2.24,   0.05,   3.24,   0.04,   7.77,    0.02,  7.58e-16,  7.20e-16,  7.49e-16,  nan ],
	[   130,    2.73,   0.05,    2.48,   0.06,   3.61,   0.04,   7.97,    0.02,  1.32e-15,  1.11e-15,  1.34e-15,  nan ],
	[   140,    2.93,   0.05,    2.83,   0.06,   4.05,   0.04,   7.47,    0.02,  1.02e-15,  8.18e-16,  1.02e-15,  nan ],
	[   150,    3.30,   0.06,    3.09,   0.06,   4.43,   0.04,   7.86,    0.02,  1.14e-15,  1.14e-15,  9.89e-16,  nan ],
	[   160,    3.69,   0.06,    3.84,   0.05,   5.19,   0.04,   8.94,    0.02,  1.07e-15,  9.57e-16,  8.93e-16,  nan ],
	[   170,    4.33,   0.05,    3.65,   0.06,   5.43,   0.04,   8.66,    0.03,  1.03e-15,  1.02e-15,  1.02e-15,  nan ],
	[   180,    4.51,   0.06,    3.96,   0.07,   5.80,   0.05,   8.70,    0.03,  9.99e-16,  1.01e-15,  9.48e-16,  nan ],
	[   190,    5.20,   0.06,    4.34,   0.07,   6.46,   0.05,   9.39,    0.03,  1.25e-15,  1.06e-15,  1.05e-15,  nan ],
	[   200,    5.20,   0.06,    4.81,   0.07,   7.01,   0.05,   9.52,    0.03,  1.30e-15,  1.46e-15,  1.28e-15,  nan ],
	[   210,    5.38,   0.07,    5.30,   0.07,   7.41,   0.05,   9.14,    0.04,  1.03e-15,  1.35e-15,  1.09e-15,  nan ],
	[   220,    5.82,   0.07,    5.51,   0.07,   7.98,   0.05,   9.51,    0.04,  9.69e-16,  1.17e-15,  1.05e-15,  nan ],
	[   230,    6.45,   0.07,    5.32,   0.08,   8.67,   0.05,   9.66,    0.04,  1.11e-15,  1.17e-15,  1.11e-15,  nan ],
	[   240,    7.02,   0.07,    6.19,   0.07,   9.26,   0.05,   9.87,    0.05,  1.28e-15,  1.21e-15,  1.19e-15,  nan ],
	[   250,    7.73,   0.07,    6.61,   0.08,   9.86,   0.05,   9.90,    0.05,  1.60e-15,  1.38e-15,  1.37e-15,  nan ],
	[   260,    7.24,   0.08,    7.27,   0.07,  10.05,   0.05,   9.88,    0.06,  1.54e-15,  1.32e-15,  1.32e-15,  nan ],
	[   270,    8.04,   0.07,    7.93,   0.07,  10.47,   0.06,  10.12,    0.06,  1.34e-15,  1.32e-15,  1.28e-15,  nan ],
	[   280,    8.19,   0.08,    7.69,   0.08,  11.07,   0.06,  10.17,    0.06,  1.73e-15,  1.77e-15,  1.45e-15,  nan ],
	[   290,    9.12,   0.07,    8.44,   0.08,  11.44,   0.06,   9.92,    0.07,  1.98e-15,  2.16e-15,  1.96e-15,  nan ],
	[   300,    9.28,   0.08,    8.72,   0.08,  12.04,   0.06,  10.36,    0.07,  1.36e-15,  1.41e-15,  1.59e-15,  nan ],
	[   310,    9.91,   0.08,    8.88,   0.09,  12.46,   0.06,  10.03,    0.08,  1.30e-15,  1.47e-15,  1.30e-15,  nan ],
	[   320,   10.96,   0.08,   10.86,   0.08,  13.28,   0.06,  10.43,    0.08,  1.60e-15,  1.45e-15,  1.43e-15,  nan ],
	[   330,   10.06,   0.09,    9.74,   0.09,  13.45,   0.07,  10.17,    0.09,  1.72e-15,  1.48e-15,  1.46e-15,  nan ],
	[   340,   10.70,   0.09,   10.56,   0.09,  13.86,   0.07,  10.33,    0.09,  1.50e-15,  1.34e-15,  1.36e-15,  nan ],
	[   350,   11.56,   0.09,   10.83,   0.09,  14.90,   0.07,  10.24,    0.10,  1.50e-15,  1.70e-15,  1.50e-15,  nan ],
	[   360,   11.58,   0.09,   10.62,   0.10,  14.90,   0.07,  10.40,    0.10,  1.56e-15,  1.59e-15,  1.42e-15,  nan ],
	[   370,   12.23,   0.09,   11.59,   0.09,  15.53,   0.07,  10.36,    0.11,  2.48e-15,  1.92e-15,  2.00e-15,  nan ],
	[   380,   13.04,   0.09,   12.19,   0.10,  16.32,   0.07,  10.44,    0.11,  1.92e-15,  1.74e-15,  1.67e-15,  nan ],
	[   390,   12.87,   0.09,   11.21,   0.11,  16.69,   0.07,  10.35,    0.12,  1.90e-15,  1.76e-15,  1.60e-15,  nan ],
	[   400,   10.13,   0.13,   12.83,   0.10,  17.84,   0.07,  10.63,    0.12,  1.48e-15,  1.43e-15,  1.57e-15,  nan ],
	[   410,   13.77,   0.10,   14.08,   0.10,  17.80,   0.08,  10.39,    0.13,  1.68e-15,  1.62e-15,  1.58e-15,  nan ],
	[   420,   14.59,   0.10,   13.50,   0.10,  18.17,   0.08,  10.57,    0.13,  1.97e-15,  1.81e-15,  1.78e-15,  nan ],
	[   430,   14.55,   0.10,   13.74,   0.11,  18.98,   0.08,  10.61,    0.14,  1.72e-15,  1.67e-15,  1.84e-15,  nan ],
	[   440,   15.52,   0.10,   15.09,   0.10,  19.69,   0.08,  10.65,    0.15,  1.94e-15,  1.94e-15,  2.08e-15,  nan ],
	[   450,   15.49,   0.10,   14.66,   0.11,  19.59,   0.08,  10.28,    0.16,  1.97e-15,  2.16e-15,  1.88e-15,  nan ],
	[   460,   15.45,   0.11,   16.04,   0.11,  20.47,   0.08,  10.76,    0.16,  1.50e-15,  1.51e-15,  1.73e-15,  nan ],
	[   470,   15.82,   0.11,   15.69,   0.11,  20.83,   0.09,  10.55,    0.17,  2.21e-15,  2.23e-15,  2.19e-15,  nan ],
	[   480,   16.68,   0.11,   17.43,   0.11,  21.48,   0.09,  10.51,    0.18,  2.12e-15,  2.17e-15,  2.33e-15,  nan ],
	[   490,   17.34,   0.11,   15.66,   0.12,  21.90,   0.09,  10.65,    0.18,  2.37e-15,  2.62e-15,  2.35e-15,  nan ],
	[   500,   17.42,   0.12,   15.91,   0.13,  22.03,   0.09,  10.66,    0.19,  1.64e-15,  1.82e-15,  1.61e-15,  nan ],
	[   510,   18.31,   0.11,   15.80,   0.13,  22.68,   0.09,  10.18,    0.21,  1.58e-15,  1.57e-15,  1.80e-15,  nan ],
	[   520,   18.05,   0.12,   16.94,   0.13,  23.33,   0.09,  10.38,    0.21,  1.97e-15,  1.97e-15,  1.97e-15,  nan ],
	[   530,   18.75,   0.12,   17.19,   0.13,  23.51,   0.10,  10.68,    0.21,  1.93e-15,  1.77e-15,  1.59e-15,  nan ],
	[   540,   19.05,   0.12,   17.84,   0.13,  24.17,   0.10,  10.78,    0.22,  1.88e-15,  1.69e-15,  1.69e-15,  nan ],
	[   550,   19.42,   0.12,   15.44,   0.16,  24.29,   0.10,  10.68,    0.23,  2.28e-15,  1.88e-15,  2.09e-15,  nan ],
	[   560,   20.29,   0.12,   17.97,   0.14,  25.18,   0.10,  10.80,    0.23,  2.29e-15,  2.04e-15,  2.04e-15,  nan ],
	[   570,   21.02,   0.12,   18.10,   0.14,  25.54,   0.10,  10.63,    0.25,  2.59e-15,  2.60e-15,  2.60e-15,  nan ],
	[   580,   20.58,   0.13,   19.28,   0.14,  26.20,   0.10,  10.84,    0.25,  2.07e-15,  1.96e-15,  1.90e-15,  nan ],
	[   590,   21.29,   0.13,   19.13,   0.15,  26.55,   0.11,  10.78,    0.26,  2.04e-15,  2.26e-15,  2.01e-15,  nan ],
	[   600,   21.70,   0.13,   20.77,   0.14,  27.52,   0.10,  10.73,    0.27,  2.09e-15,  2.10e-15,  1.90e-15,  nan ],
	[   610,   22.43,   0.13,   20.32,   0.15,  27.63,   0.11,  10.66,    0.28,  2.08e-15,  2.15e-15,  2.22e-15,  nan ],
	[   620,   22.49,   0.14,   20.39,   0.15,  28.54,   0.11,  10.89,    0.28,  2.07e-15,  2.22e-15,  1.89e-15,  nan ],
	[   630,   23.10,   0.14,   20.54,   0.15,  28.96,   0.11,  10.86,    0.29,  1.82e-15,  2.00e-15,  1.90e-15,  nan ],
	[   640,   24.69,   0.13,   22.33,   0.15,  29.63,   0.11,  10.94,    0.30,  1.99e-15,  1.80e-15,  1.97e-15,  nan ],
	[   650,   23.53,   0.14,   21.59,   0.16,  29.73,   0.11,  10.79,    0.31,  2.23e-15,  2.31e-15,  2.46e-15,  nan ],
	[   660,   23.94,   0.15,   22.10,   0.16,  30.65,   0.11,  10.82,    0.32,  3.14e-15,  2.97e-15,  2.80e-15,  nan ],
	[   670,   24.79,   0.15,   23.66,   0.15,  30.75,   0.12,  10.74,    0.33,  2.60e-15,  2.74e-15,  2.59e-15,  nan ],
	[   680,   24.88,   0.15,   23.17,   0.16,  31.93,   0.12,  10.94,    0.34,  2.49e-15,  2.64e-15,  2.47e-15,  nan ],
	[   690,   25.45,   0.15,   24.78,   0.15,  32.02,   0.12,  10.75,    0.36,  2.49e-15,  2.31e-15,  2.32e-15,  nan ],
	[   700,   26.03,   0.15,   24.27,   0.16,  32.50,   0.12,  10.94,    0.36,  2.29e-15,  2.48e-15,  2.48e-15,  nan ],
	[   710,   26.44,   0.15,   21.73,   0.19,  32.91,   0.12,  10.80,    0.37,  2.08e-15,  2.24e-15,  2.05e-15,  nan ],
	[   720,   26.65,   0.16,   24.18,   0.17,  33.52,   0.12,  10.88,    0.38,  2.46e-15,  2.25e-15,  2.57e-15,  nan ],
	[   730,   26.70,   0.16,   24.28,   0.18,  33.68,   0.13,  10.87,    0.39,  2.83e-15,  2.65e-15,  2.66e-15,  nan ],
	[   740,   27.98,   0.16,   26.76,   0.16,  33.23,   0.13,  10.87,    0.40,  2.92e-15,  2.31e-15,  2.31e-15,  nan ],
	[   750,   28.57,   0.16,   26.52,   0.17,  33.18,   0.14,  10.84,    0.42,  2.43e-15,  2.29e-15,  2.32e-15,  nan ],
	[   760,   28.60,   0.16,   25.72,   0.18,  34.01,   0.14,  10.90,    0.42,  3.01e-15,  2.86e-15,  2.85e-15,  nan ],
	[   770,   28.64,   0.17,   27.65,   0.17,  34.67,   0.14,  10.56,    0.45,  3.40e-15,  3.40e-15,  3.11e-15,  nan ],
	[   780,   28.69,   0.17,   27.87,   0.17,  35.57,   0.14,  11.03,    0.44,  2.62e-15,  2.77e-15,  2.48e-15,  nan ],
	[   790,   29.76,   0.17,   28.43,   0.18,  36.24,   0.14,  10.97,    0.46,  2.23e-15,  2.41e-15,  2.32e-15,  nan ],
	[   800,   29.84,   0.17,   28.20,   0.18,  36.65,   0.14,  10.98,    0.47,  2.84e-15,  2.84e-15,  2.99e-15,  nan ],
	[   810,   30.38,   0.17,   27.99,   0.19,  36.76,   0.14,  10.86,    0.48,  2.89e-15,  2.45e-15,  2.49e-15,  nan ],
	[   820,   31.35,   0.17,   29.17,   0.18,  37.18,   0.14,  11.00,    0.49,  2.55e-15,  2.65e-15,  2.78e-15,  nan ],
	[   830,   32.12,   0.17,   28.62,   0.19,  38.34,   0.14,  10.93,    0.50,  2.38e-15,  2.39e-15,  2.51e-15,  nan ],
	[   840,   31.25,   0.18,   28.71,   0.20,  36.77,   0.15,  11.00,    0.51,  3.80e-15,  3.80e-15,  3.53e-15,  nan ],
	[   850,   32.34,   0.18,   29.08,   0.20,  37.08,   0.16,  10.88,    0.53,  2.54e-15,  2.41e-15,  2.56e-15,  nan ],
	[   860,   32.75,   0.18,   31.55,   0.19,  36.78,   0.16,  11.00,    0.54,  2.57e-15,  2.39e-15,  2.41e-15,  nan ],
	[   870,   33.34,   0.18,   23.51,   0.26,  39.38,   0.15,  10.99,    0.55,  2.61e-15,  2.49e-15,  2.62e-15,  nan ],
	[   880,   33.94,   0.18,   32.33,   0.19,  39.26,   0.16,  11.01,    0.56,  2.63e-15,  2.60e-15,  2.52e-15,  nan ],
	[   890,   34.13,   0.19,   31.25,   0.20,  39.68,   0.16,  10.87,    0.58,  2.17e-15,  2.23e-15,  2.20e-15,  nan ],
	[   900,   33.49,   0.19,   31.36,   0.21,  40.04,   0.16,  10.99,    0.59,  2.92e-15,  2.58e-15,  2.44e-15,  nan ],
	[  1000,   37.80,   0.21,   35.45,   0.23,  43.53,   0.18,  10.70,    0.75,  2.75e-15,  2.39e-15,  2.32e-15,  nan ],
	[  1100,   41.57,   0.23,   35.79,   0.27,  28.02,   0.35,  10.32,    0.94,  3.10e-15,  3.31e-15,  3.31e-15,  nan ],
	[  1200,   45.09,   0.26,   38.34,   0.30,  30.05,   0.38,   9.90,    1.16,  3.27e-15,  3.54e-15,  3.04e-15,  nan ],
	[  1300,   47.31,   0.29,   42.30,   0.32,  31.33,   0.43,   9.77,    1.38,  3.71e-15,  4.77e-15,  4.63e-15,  nan ],
	[  1400,   53.57,   0.29,   44.33,   0.35,  32.56,   0.48,   9.09,    1.73,  4.06e-15,  4.23e-15,  4.39e-15,  nan ],
	[  1500,   55.94,   0.32,   45.06,   0.40,  36.33,   0.50,   8.60,    2.09,  3.79e-15,  3.79e-15,  4.40e-15,  nan ],
	[  1600,   61.20,   0.33,   56.94,   0.36,  38.16,   0.54,   8.35,    2.46,  3.87e-15,  3.98e-15,  3.78e-15,  nan ],
	[  1700,   63.23,   0.37,   49.77,   0.46,  40.19,   0.58,   8.27,    2.80,  4.07e-15,  3.89e-15,  3.92e-15,  nan ],
	[  1800,   67.71,   0.38,   53.47,   0.49,  42.19,   0.61,   7.83,    3.31,  4.04e-15,  4.17e-15,  4.17e-15,  nan ],
	[  1900,   71.02,   0.41,   53.83,   0.54,  43.14,   0.67,   8.30,    3.48,  4.44e-15,  4.57e-15,  4.45e-15,  nan ],
	[  2000,   74.29,   0.43,   55.32,   0.58,  44.17,   0.73,   8.35,    3.84,  4.12e-15,  4.09e-15,  4.36e-15,  nan ],
	[  2100,   77.77,   0.45,   56.84,   0.62,  35.30,   1.00,   8.35,    4.23,  4.33e-15,  4.13e-15,  3.96e-15,  nan ],
	[  2200,   79.24,   0.49,   58.63,   0.66,  37.04,   1.05,   8.41,    4.61,  3.99e-15,  4.60e-15,  4.26e-15,  nan ],
	[  2300,   85.23,   0.50,   59.80,   0.71,  39.03,   1.09,   7.60,    5.57,  5.14e-15,  5.16e-15,  5.14e-15,  nan ],
	[  2400,   86.84,   0.53,   71.39,   0.65,  39.86,   1.16,   8.23,    5.60,  4.63e-15,  4.93e-15,  4.38e-15,  nan ],
	[  2500,   88.88,   0.56,   59.28,   0.84,  41.55,   1.20,   8.44,    5.93,  5.48e-15,  5.67e-15,  5.67e-15,  nan ],
	[  2600,   92.64,   0.58,   61.71,   0.88,  41.81,   1.29,   8.46,    6.40,  6.89e-15,  6.86e-15,  6.85e-15,  nan ],
	[  2700,   93.67,   0.62,   63.08,   0.93,  42.98,   1.36,   8.37,    6.98,  5.06e-15,  5.02e-15,  5.08e-15,  nan ],
	[  2800,   97.30,   0.64,   64.77,   0.97,  40.78,   1.54,   8.50,    7.39,  5.39e-15,  5.55e-15,  4.89e-15,  nan ],
	[  2900,  100.48,   0.67,   63.39,   1.06,  45.92,   1.47,   8.50,    7.92,  5.04e-15,  5.06e-15,  5.35e-15,  nan ],
	[  3000,  106.88,   0.67,   65.73,   1.10,  47.39,   1.52,   8.56,    8.41,  5.21e-15,  5.16e-15,  5.08e-15,  nan ],
	[  3100,  110.33,   0.70,   64.15,   1.20,  38.99,   1.97,   8.58,    8.97,  6.08e-15,  5.41e-15,  5.52e-15,  nan ],
	[  3200,  111.83,   0.73,   84.42,   0.97,  40.55,   2.02,   9.40,    8.71,  5.40e-15,  5.55e-15,  5.56e-15,  nan ],
	[  3300,  114.06,   0.76,   66.99,   1.30,  41.19,   2.12,   8.60,   10.14,  5.67e-15,  6.10e-15,  5.81e-15,  nan ],
	[  3400,  116.08,   0.80,   67.44,   1.37,  42.76,   2.16,   8.61,   10.74,  6.46e-15,  6.11e-15,  5.92e-15,  nan ],
	[  3500,  120.77,   0.81,   68.14,   1.44,  44.02,   2.23,   8.48,   11.56,  6.11e-15,  5.59e-15,  5.52e-15,  nan ],
	[  3600,  122.58,   0.85,   69.43,   1.49,  44.63,   2.32,   8.60,   12.06,  5.81e-15,  5.82e-15,  6.10e-15,  nan ],
	[  3700,  124.34,   0.88,   71.06,   1.54,  44.85,   2.44,   8.50,   12.90,  5.44e-15,  5.65e-15,  5.67e-15,  nan ],
	[  3800,  127.26,   0.91,   72.17,   1.60,  46.28,   2.50,   8.56,   13.51,  6.23e-15,  6.12e-15,  6.00e-15,  nan ],
	[  3900,  127.86,   0.95,   69.05,   1.76,  47.13,   2.58,   8.35,   14.57,  5.81e-15,  6.08e-15,  5.63e-15,  nan ],
	[  4000,  125.40,   1.02,   89.42,   1.43,  46.87,   2.73,   8.53,   15.01,  6.16e-15,  6.28e-15,  6.14e-15,  nan ],
	[  4100,  118.74,   1.13,   69.89,   1.92,  39.96,   3.37,   7.88,   17.07,  6.16e-15,  6.89e-15,  6.55e-15,  nan ],
	[  4200,  119.93,   1.18,   72.32,   1.95,  41.06,   3.44,   8.52,   16.57,  7.28e-15,  6.54e-15,  6.54e-15,  nan ],
	[  4300,  123.02,   1.20,   71.07,   2.08,  42.00,   3.52,   8.52,   17.36,  6.06e-15,  6.35e-15,  6.19e-15,  nan ],
	[  4400,  123.45,   1.26,   73.15,   2.12,  43.15,   3.59,   8.56,   18.11,  6.31e-15,  6.39e-15,  6.12e-15,  nan ],
	[  4500,  122.96,   1.32,   73.50,   2.20,  44.37,   3.65,   8.59,   18.86,  6.75e-15,  6.53e-15,  6.80e-15,  nan ],
	[  4600,  124.32,   1.36,   73.46,   2.31,  45.99,   3.68,   8.60,   19.70,  6.95e-15,  7.40e-15,  7.18e-15,  nan ],
	[  4700,  122.51,   1.44,   75.13,   2.35,  47.08,   3.76,   8.67,   20.40,  6.19e-15,  6.62e-15,  6.40e-15,  nan ],
	[  4800,  123.08,   1.50,   93.44,   1.97,  46.15,   3.99,   8.75,   21.08,  7.21e-15,  6.83e-15,  7.02e-15,  nan ],
	[  4900,  122.94,   1.56,   72.59,   2.65,  47.08,   4.08,   8.72,   22.04,  8.24e-15,  7.80e-15,  7.80e-15,  nan ],
	[  5000,  121.91,   1.64,   74.09,   2.70,  48.51,   4.12,   8.79,   22.75,  7.47e-15,  7.83e-15,  7.48e-15,  nan ],
	[  5100,  123.90,   1.68,   75.27,   2.77,  49.69,   4.19,   8.75,   23.80,  8.39e-15,  8.64e-15,  8.41e-15,  nan ],
	[  5200,  123.23,   1.76,   75.03,   2.88,  44.16,   4.90,   8.76,   24.71,  8.76e-15,  8.93e-15,  8.58e-15,  nan ],
	[  5300,  123.78,   1.82,   74.62,   3.01,  44.22,   5.08,   8.77,   25.64,  8.93e-15,  8.59e-15,  8.95e-15,  nan ],
	[  5400,  122.48,   1.91,   74.60,   3.13,  44.18,   5.28,   8.73,   26.73,  7.28e-15,  7.42e-15,  7.64e-15,  nan ],
	[  5500,  123.07,   1.97,   76.99,   3.14,  45.11,   5.37,   8.70,   27.84,  7.53e-15,  6.95e-15,  7.25e-15,  nan ],
	[  5600,  125.41,   2.00,   98.53,   2.55,  45.94,   5.46,   8.69,   28.87,  8.12e-15,  8.45e-15,  8.29e-15,  nan ],
	[  5700,  124.51,   2.09,   76.33,   3.41,  46.50,   5.59,   8.76,   29.69,  8.20e-15,  8.11e-15,  8.22e-15,  nan ],
	[  5800,  124.91,   2.16,   75.87,   3.55,  47.53,   5.66,   8.67,   31.03,  9.28e-15,  8.33e-15,  9.11e-15,  nan ],
	[  5900,  124.85,   2.23,   76.86,   3.62,  47.89,   5.82,   8.78,   31.73,  7.88e-15,  7.56e-15,  7.35e-15,  nan ],
	[  6000,  127.01,   2.27,   76.88,   3.75,  49.86,   5.78,   8.36,   34.48,  7.60e-15,  7.88e-15,  7.89e-15,  nan ],
	[  6100,  126.06,   2.36,   77.08,   3.86,  49.58,   6.01,   8.55,   34.81,  8.49e-15,  9.36e-15,  8.75e-15,  nan ],
	[  6200,  128.07,   2.40,   77.78,   3.95,  44.62,   6.89,   8.44,   36.44,  7.79e-15,  7.88e-15,  7.82e-15,  nan ],
	[  6300,  127.85,   2.48,   76.00,   4.18,  45.47,   6.98,   8.81,   36.04,  8.40e-15,  8.02e-15,  8.86e-15,  nan ],
	[  6400,  130.99,   2.50,  100.48,   3.26,  45.48,   7.21,   9.22,   35.54,  8.53e-15,  8.69e-15,  9.12e-15,  nan ],
	[  6500,  129.29,   2.61,   78.02,   4.33,  45.39,   7.45,   8.67,   38.98,  7.96e-15,  7.22e-15,  8.21e-15,  nan ],
	[  6600,  128.20,   2.72,   78.97,   4.41,  46.19,   7.55,   8.37,   41.64,  8.75e-15,  9.98e-15,  9.18e-15,  nan ],
	[  6700,  129.35,   2.78,   79.03,   4.54,  46.43,   7.74,   8.74,   41.11,  7.78e-15,  7.94e-15,  7.79e-15,  nan ],
	[  6800,  129.88,   2.85,   77.61,   4.77,  46.58,   7.94,   8.71,   42.46,  9.95e-15,  1.02e-14,  9.64e-15,  nan ],
	[  6900,  132.60,   2.87,   77.75,   4.90,  47.45,   8.03,   8.73,   43.62,  8.70e-15,  8.51e-15,  8.58e-15,  nan ],
	[  7000,  130.96,   2.99,   78.26,   5.01,  48.39,   8.10,   8.29,   47.29,  9.23e-15,  8.75e-15,  8.67e-15,  nan ],
	[  7100,  131.65,   3.06,   78.31,   5.15,  49.28,   8.19,   8.29,   48.67,  7.97e-15,  8.42e-15,  7.83e-15,  nan ],
	[  7200,  132.78,   3.12,  102.98,   4.03,  45.35,   9.15,   8.14,   50.94,  7.83e-15,  8.23e-15,  8.72e-15,  nan ],
	[  7300,  132.80,   3.21,   79.19,   5.38,  44.94,   9.49,   7.82,   54.51,  9.41e-15,  9.67e-15,  9.07e-15,  nan ],
	[  7400,  132.62,   3.30,   79.55,   5.51,  45.54,   9.62,   8.17,   53.61,  7.64e-15,  7.70e-15,  8.69e-15,  nan ],
	[  7500,  134.81,   3.34,   79.02,   5.70,  45.93,   9.80,   8.08,   55.71,  8.08e-15,  8.51e-15,  8.18e-15,  nan ],
	[  7600,  134.43,   3.44,   79.45,   5.82,  47.22,   9.79,   8.09,   57.16,  8.45e-15,  8.41e-15,  8.30e-15,  nan ],
	[  7700,  134.17,   3.54,   78.14,   6.07,  46.73,  10.15,   8.06,   58.88,  8.20e-15,  8.11e-15,  8.77e-15,  nan ],
	[  7800,  135.30,   3.60,   78.70,   6.19,  48.05,  10.13,   7.72,   63.08,  8.40e-15,  8.81e-15,  8.77e-15,  nan ],
	[  7900,  135.85,   3.68,   79.45,   6.29,  48.20,  10.36,   7.70,   64.87,  9.47e-15,  9.87e-15,  9.62e-15,  nan ],
	[  8000,  136.27,   3.76,  107.74,   4.75,  48.32,  10.60,   7.69,   66.61,  9.00e-15,  8.96e-15,  9.01e-15,  nan ],
	[  8100,  135.13,   3.89,   78.97,   6.65,  48.21,  10.89,   7.51,   69.86,  8.90e-15,  9.06e-15,  9.18e-15,  nan ],
	[  8200,  132.88,   4.05,   78.76,   6.83,  45.51,  11.82,   7.37,   73.03,  9.72e-15,  8.68e-15,  9.05e-15,  nan ],
	[  8300,  135.70,   4.06,   80.81,   6.82,  45.79,  12.04,   7.29,   75.65,  9.44e-15,  9.66e-15,  9.65e-15,  nan ],
	[  8400,  133.21,   4.24,   80.84,   6.98,  46.11,  12.24,   7.59,   74.38,  8.45e-15,  8.24e-15,  8.49e-15,  nan ],
	[  8500,  135.04,   4.28,   80.91,   7.14,  46.16,  12.52,   7.63,   75.79,  8.87e-15,  9.55e-15,  9.26e-15,  nan ],
	[  8600,  133.53,   4.43,   81.05,   7.30,  46.93,  12.61,   7.72,   76.69,  1.07e-14,  1.17e-14,  1.10e-14,  nan ],
	[  8700,  134.76,   4.49,   81.66,   7.42,  47.86,  12.65,   7.59,   79.79,  9.70e-15,  9.67e-15,  9.05e-15,  nan ],
	[  8800,  132.94,   4.66,  108.00,   5.74,  48.36,  12.81,   8.02,   77.27,  9.47e-15,  9.71e-15,  9.18e-15,  nan ],
	[  8900,  133.91,   4.73,   80.20,   7.90,  47.01,  13.48,   8.14,   77.84,  1.21e-14,  1.29e-14,  1.17e-14,  nan ],
	[  9000,  133.66,   4.85,   81.75,   7.93,  48.24,  13.43,   8.16,   79.46,  9.94e-15,  9.76e-15,  1.00e-14,  nan ],
	[ 10000,  133.73,   5.98,   81.51,   9.82,  48.79,  16.40,   8.47,   94.42,  1.00e-14,  1.21e-14,  1.12e-14,  nan ],
	[ 12000,  134.57,   8.56,  110.76,  10.40,  48.00,  24.00,   8.32,  138.49,  1.21e-14,  1.22e-14,  1.28e-14,  nan ],
	[ 14000,  130.07,  12.06,   82.60,  18.99,  47.31,  33.15,   8.54,  183.66,  1.34e-14,  1.31e-14,  1.34e-14,  nan ],
	[ 16000,  127.94,  16.01,  112.71,  18.17,  47.62,  43.01,   8.88,  230.69,  1.39e-14,  1.28e-14,  1.23e-14,  nan ],
	[ 18000,  124.97,  20.74,   84.81,  30.57,  47.48,  54.60,   7.85,  330.42,  1.60e-14,  1.45e-14,  1.56e-14,  nan ],
	[ 20000,  122.15,  26.20,  116.89,  27.38,  46.89,  68.25,   8.45,  378.62,  1.66e-14,  1.67e-14,  1.80e-14,  nan ],
])

# ------------------------------------------------------------
# file: v2.0.0/cuda7.0-k40c/zpotrf.txt
# numactl --interleave=all ../testing/testing_zpotrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zpotrf = array([
	[    10,  nan,  nan,     0.33,  0.00,  nan ],
	[    20,  nan,  nan,     1.09,  0.00,  nan ],
	[    30,  nan,  nan,     2.58,  0.00,  nan ],
	[    40,  nan,  nan,     2.57,  0.00,  nan ],
	[    50,  nan,  nan,     3.87,  0.00,  nan ],
	[    60,  nan,  nan,     4.75,  0.00,  nan ],
	[    70,  nan,  nan,     5.18,  0.00,  nan ],
	[    80,  nan,  nan,     5.61,  0.00,  nan ],
	[    90,  nan,  nan,     5.89,  0.00,  nan ],
	[   100,  nan,  nan,     6.06,  0.00,  nan ],
	[   200,  nan,  nan,    28.62,  0.00,  nan ],
	[   300,  nan,  nan,    12.87,  0.00,  nan ],
	[   400,  nan,  nan,    27.16,  0.00,  nan ],
	[   500,  nan,  nan,    43.19,  0.00,  nan ],
	[   600,  nan,  nan,    53.23,  0.01,  nan ],
	[   700,  nan,  nan,    74.00,  0.01,  nan ],
	[   800,  nan,  nan,    79.83,  0.01,  nan ],
	[   900,  nan,  nan,   107.22,  0.01,  nan ],
	[  1000,  nan,  nan,   131.66,  0.01,  nan ],
	[  2000,  nan,  nan,   375.51,  0.03,  nan ],
	[  3000,  nan,  nan,   550.82,  0.07,  nan ],
	[  4000,  nan,  nan,   680.12,  0.13,  nan ],
	[  5000,  nan,  nan,   764.24,  0.22,  nan ],
	[  6000,  nan,  nan,   828.03,  0.35,  nan ],
	[  7000,  nan,  nan,   882.55,  0.52,  nan ],
	[  8000,  nan,  nan,   922.54,  0.74,  nan ],
	[  9000,  nan,  nan,   950.90,  1.02,  nan ],
	[ 10000,  nan,  nan,   983.89,  1.36,  nan ],
	[ 12000,  nan,  nan,  1032.41,  2.23,  nan ],
	[ 14000,  nan,  nan,  1061.08,  3.45,  nan ],
	[ 16000,  nan,  nan,  1088.31,  5.02,  nan ],
	[ 18000,  nan,  nan,  1105.07,  7.04,  nan ],
	[ 20000,  nan,  nan,  1122.98,  9.50,  nan ],
])

# numactl --interleave=all ../testing/testing_zpotrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.03,  0.00,  nan ],
	[    40,  nan,  nan,     0.07,  0.00,  nan ],
	[    50,  nan,  nan,     0.14,  0.00,  nan ],
	[    60,  nan,  nan,     0.23,  0.00,  nan ],
	[    70,  nan,  nan,     0.36,  0.00,  nan ],
	[    80,  nan,  nan,     0.52,  0.00,  nan ],
	[    90,  nan,  nan,     0.71,  0.00,  nan ],
	[   100,  nan,  nan,     0.93,  0.00,  nan ],
	[   200,  nan,  nan,     5.95,  0.00,  nan ],
	[   300,  nan,  nan,    10.73,  0.00,  nan ],
	[   400,  nan,  nan,    23.17,  0.00,  nan ],
	[   500,  nan,  nan,    39.91,  0.00,  nan ],
	[   600,  nan,  nan,    50.84,  0.01,  nan ],
	[   700,  nan,  nan,    73.22,  0.01,  nan ],
	[   800,  nan,  nan,    82.49,  0.01,  nan ],
	[   900,  nan,  nan,   111.63,  0.01,  nan ],
	[  1000,  nan,  nan,   138.97,  0.01,  nan ],
	[  2000,  nan,  nan,   439.58,  0.02,  nan ],
	[  3000,  nan,  nan,   640.66,  0.06,  nan ],
	[  4000,  nan,  nan,   781.19,  0.11,  nan ],
	[  5000,  nan,  nan,   858.01,  0.19,  nan ],
	[  6000,  nan,  nan,   916.48,  0.31,  nan ],
	[  7000,  nan,  nan,   967.71,  0.47,  nan ],
	[  8000,  nan,  nan,  1005.48,  0.68,  nan ],
	[  9000,  nan,  nan,  1029.80,  0.94,  nan ],
	[ 10000,  nan,  nan,  1055.77,  1.26,  nan ],
	[ 12000,  nan,  nan,  1098.56,  2.10,  nan ],
	[ 14000,  nan,  nan,  1118.59,  3.27,  nan ],
	[ 16000,  nan,  nan,  1140.72,  4.79,  nan ],
	[ 18000,  nan,  nan,  1152.94,  6.75,  nan ],
	[ 20000,  nan,  nan,  1166.65,  9.14,  nan ],
])

