# Create a Client

## Single

### Basic Usage

@snippet api/mongocxx/examples/clients/create/single/basic.cpp Example

### With a Custom URI

@snippet api/mongocxx/examples/clients/create/single/with_uri.cpp Example

### With Client Options

#### Stable API Options

@snippet api/mongocxx/examples/clients/create/single/options/stable_api.cpp Example

#### TLS Options

@snippet api/mongocxx/examples/clients/create/single/options/tls.cpp Example

#### Automatic Encryption Options

@snippet api/mongocxx/examples/clients/create/single/options/auto_encryption.cpp Example

#### APM Options

@snippet api/mongocxx/examples/clients/create/single/options/apm.cpp Example

## Pool

### Basic Usage

@snippet api/mongocxx/examples/clients/create/pool/basic.cpp Example

### With Client Options

@snippet api/mongocxx/examples/clients/create/pool/options.cpp Example

### Try Acquire

@snippet api/mongocxx/examples/clients/create/pool/try_acquire.cpp Example

# Use a Client

## List Databases

@snippet api/mongocxx/examples/clients/use/list_databases.cpp Example

## List Databases With Options

@snippet api/mongocxx/examples/clients/use/list_databases_with_options.cpp Example

## List Database Names

@snippet api/mongocxx/examples/clients/use/list_database_names.cpp Example

## List Database Names With Options

@snippet api/mongocxx/examples/clients/use/list_database_names_with_options.cpp Example

# Error Handling

## Invalid Client

@snippet api/mongocxx/examples/clients/errors/invalid_client.cpp Example

## Wait Queue Timeout

@snippet api/mongocxx/examples/clients/errors/wait_queue_timeout.cpp Example

## Invalid Stable API Options

@snippet api/mongocxx/examples/clients/errors/stable_api.cpp Example

## TLS Not Enabled

@snippet api/mongocxx/examples/clients/errors/tls.cpp Example

## Invalid Auto Encryption Options

@snippet api/mongocxx/examples/clients/errors/auto_encryption.cpp Example
