find_package(PkgConfig)
if (PKG_CONFIG_FOUND)
    if (APPLE)
        # libffi is provided by base system so brew does not take the risk to override it
        # hence then need for an explicit look-up
        set(ENV{PKG_CONFIG_PATH} "$ENV{PKG_CONFIG_PATH}:/usr/local/opt/libffi/lib/pkgconfig")
    endif ()
    if (GLIB_FIND_REQUIRED)
        set(_pkgconfig_REQUIRED REQUIRED)
    endif ()
    pkg_check_modules(GLIB ${_pkgconfig_REQUIRED} glib-2.0)
    if (GLIB_LINK_LIBRARIES)
        set(GLIB_LIBRARIES ${GLIB_LINK_LIBRARIES}) # HACK
    endif ()
else ()
    find_path(GLIB_INCLUDE_DIRS glib.h)
    find_library(GLIB_LIBRARIES glib-2.0)
    if (GLIB_INCLUDE_DIRS AND GLIB_LIBRARIES)
        set(GLIB_FOUND 1)
        if (NOT GLIB_FIND_QUIETLY)
            message(STATUS "Found GLIB: ${GLIB_LIBRARIES}")
        endif ()
    elseif (GLIB_FIND_REQUIRED)
        message(SEND_ERROR "Could not find GLIB")
    elseif (NOT GLIB_FIND_QUIETLY)
        message(STATUS "Could not find GLIB")
    endif ()
endif ()
mark_as_advanced(GLIB_INCLUDE_DIRS GLIB_LIBRARIES)
