/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.CandidateInfoEdit;
import org.chefproject.service.DissertationService;
import org.chefproject.util.Sql;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Time;

public class DissertationDataListenerService
extends TurbineBaseService
implements Runnable {
    long m_lastQueryTime = -1L;
    protected static boolean m_listening = true;
    public static String SERVICE_NAME = "DissertationDataListenerService";
    String m_connect;
    String m_un;
    String m_pw;

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".init(ServletConfig)");
        }
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".init(RunData)");
        }
        this.m_connect = this.getProperties().getProperty("connect", this.m_connect);
        this.m_un = this.getProperties().getProperty("un", this.m_un);
        this.m_pw = this.getProperties().getProperty("pw", this.m_pw);
        Thread listenerThread = new Thread(this);
        listenerThread.start();
    }

    public void init() throws InitializationException {
        super.init();
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".init()");
        }
    }

    public void shutdown() {
        m_listening = false;
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".shutdown()");
        }
        super.shutdown();
    }

    public void run() {
        Calendar currentTime = null;
        CandidateInfoEdit lastQueryTimeInfoEdit = null;
        try {
            lastQueryTimeInfoEdit = DissertationService.getCandidateInfoEditForEmplid("lastquery");
            if (lastQueryTimeInfoEdit == null) {
                lastQueryTimeInfoEdit = DissertationService.addCandidateInfoFromListener("datalistener");
                lastQueryTimeInfoEdit.setEmplid("lastquery");
                lastQueryTimeInfoEdit.setParentSiteId("lastquery");
                lastQueryTimeInfoEdit.setChefId("lastquery");
                lastQueryTimeInfoEdit.setProgram("-1");
                DissertationService.commitEdit(lastQueryTimeInfoEdit);
            } else {
                this.m_lastQueryTime = Long.parseLong(lastQueryTimeInfoEdit.getProgram());
                DissertationService.cancelEdit(lastQueryTimeInfoEdit);
            }
        }
        catch (Exception e) {
            Log.warn("chef", "DISSERTATION : LISTENER SERVICE : RUN : EXCEPTION CREATING LAST QUERY TIME CANDIDATE INFO : " + e);
        }
        long nowLong = -1L;
        m_listening = true;
        while (m_listening) {
            try {
                if (this.m_lastQueryTime == -1L) {
                    this.findGoodTime();
                    this.queryDatabase();
                    lastQueryTimeInfoEdit = DissertationService.getCandidateInfoEditForEmplid("lastquery");
                    currentTime = Calendar.getInstance();
                    lastQueryTimeInfoEdit.setProgram("" + currentTime.getTimeInMillis());
                    DissertationService.commitEdit(lastQueryTimeInfoEdit);
                } else {
                    Calendar now = Calendar.getInstance();
                    if (now.get(7) == 2 && (nowLong = now.getTimeInMillis()) - this.m_lastQueryTime > 604700000L) {
                        this.findGoodTime();
                        this.queryDatabase();
                        lastQueryTimeInfoEdit = DissertationService.getCandidateInfoEditForEmplid("lastquery");
                        currentTime = Calendar.getInstance();
                        lastQueryTimeInfoEdit.setProgram("" + currentTime.getTimeInMillis());
                        DissertationService.commitEdit(lastQueryTimeInfoEdit);
                    }
                }
            }
            catch (Exception e) {
                Log.warn("chef", "DISSERTATION : LISTENER SERVICE : RUN : EXCEPTION : " + e);
            }
            try {
                Thread.sleep(360000000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void queryDatabase() {
        boolean reqMet = false;
        Connection con = null;
        Vector<CandidateInfoEdit> data = new Vector<CandidateInfoEdit>();
        List emplids = null;
        List list = null;
        String oneEmplid = null;
        String chefId = null;
        String program = null;
        String dataString = null;
        String sql = null;
        CandidateInfoEdit infoEdit = null;
        boolean commitEdit = false;
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
            con = DriverManager.getConnection(this.m_connect, this.m_un, this.m_pw);
            sql = "select umid from member";
            emplids = Sql.dbRead(con, sql, null, null);
        }
        catch (Exception e) {
            Log.warn("chef", "DISSERTATION : LISTENER : SELECT UMID FROM MEMBER : EXCEPTION : " + e);
        }
        if (emplids != null) {
            int x = 0;
            while (x < emplids.size()) {
                try {
                    commitEdit = false;
                    oneEmplid = (String)emplids.get(x);
                    infoEdit = DissertationService.getCandidateInfoEditForEmplid(oneEmplid);
                    if (infoEdit == null) {
                        infoEdit = DissertationService.addCandidateInfoFromListener("datalistener");
                        infoEdit.setEmplid(oneEmplid);
                        commitEdit = true;
                    }
                    try {
                        chefId = infoEdit.getChefId();
                        if (chefId.equals("")) {
                            sql = "select uniqname from member where ( umid = '" + oneEmplid + "' ) ";
                            list = this.executeQuery(con, sql);
                            if (list != null && list.size() > 0 && (chefId = (String)list.get(0)) != null) {
                                infoEdit.setChefId(chefId.toLowerCase());
                            }
                            commitEdit = true;
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : SELECT UNIQNAME FROM MEMBER WHERE UMID = ? : EXCEPTION : " + e);
                    }
                    try {
                        program = infoEdit.getProgram();
                        if (program.equals("")) {
                            sql = "select fos from oardextr where ( umid = '" + oneEmplid + "' ) ";
                            list = this.executeQuery(con, sql);
                            if (list != null && list.size() > 0) {
                                program = (String)list.get(0);
                                if (program != null) {
                                    infoEdit.setProgram(DissertationService.getProgram(program));
                                    infoEdit.setParentSiteId("diss" + program);
                                } else {
                                    sql = "select acad_prog from extractw where ( umid = '" + oneEmplid + "' ) ";
                                    list = this.executeQuery(con, sql);
                                    if (list != null && list.size() > 0 && (program = (String)list.get(0)) != null) {
                                        infoEdit.setProgram(DissertationService.getProgram(program));
                                        infoEdit.setParentSiteId("diss" + program);
                                    }
                                }
                            }
                            commitEdit = true;
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : SELECT FOS FROM OARDEXTR WHERE UMID = ? : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select degterm_trans from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setDegreeTermTrans(dataString);
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select oral_exam_date_time from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeOralExam(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select oral_exam_place from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setOralExamPlace(dataString);
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select committe_approved_date from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeCommitteeApproval(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select first_format_date from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeFirstFormat(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select binder_recept_date from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeBinderReceipt(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select fee_requirement_met from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            reqMet = false;
                            if (dataString.indexOf("true") != -1 || dataString.indexOf("TRUE") != -1) {
                                reqMet = true;
                            }
                            infoEdit.setFeeRequirementMet(reqMet);
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select fee_receipt_date_seen from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeReceiptSeen(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select pub_fee_date_received from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimePubFee(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select oral_report_return_date from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeOralReportReturned(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select unbound_date from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeUnbound(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select abstract_date from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeAbstract(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select bound_copy_received_date from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeBound(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select diploma_application_date from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeDiplomaApp(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select contract_received_date from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeContract(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select NSF_survey_date from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeSurvey(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select degree_conferred_date from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeDegreeConferred(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select final_format_recorder from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setFinalFormatRecorder(dataString);
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select comm_cert_date from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeCommitteeCert(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select eval_date from oardextr where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.addTimeCommitteeEval(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select anticipate from extractw where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setAdvCandDesc(dataString);
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select date_compl from extractw where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setTimeMilestoneCompleted(this.parseOracleTimeString(dataString));
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    try {
                        sql = "select milestone from extractw where ( umid = '" + oneEmplid + "' ) ";
                        list = this.executeQuery(con, sql);
                        if (list != null && list.size() > 0 && (dataString = (String)list.get(0)) != null) {
                            infoEdit.setMilestone(dataString);
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : LISTENER : GETTING STATUS DATA FROM NAVIGO : EXCEPTION : " + e);
                    }
                    if (commitEdit) {
                        DissertationService.commitEdit(infoEdit);
                        Log.warn("chef", "DISSERTATION : LISTENER : CANDIDATE INFO EDIT COMMITTED");
                    } else {
                        DissertationService.cancelEdit(infoEdit);
                        Log.warn("chef", "DISSERTATION : LISTENER : CANDIDATE INFO NOT MODIFIED - EDIT CANCELED");
                    }
                    data.add(infoEdit);
                }
                catch (Exception e) {
                    Log.warn("chef", "DISSERTATION : LISTENER : EXCEPTION WHILE PROCESSING EMPLID  :  " + oneEmplid + "  :  " + e);
                }
                ++x;
            }
            try {
                con.close();
            }
            catch (Exception e) {
                Log.warn("chef", "DISSERTATION : LISTENER : CLOSING CONNECTION TO NAVIGO : EXCEPTION : " + e);
            }
        }
        DissertationService.dumpData(data);
    }

    protected Time parseOracleTimeString(String timeString) {
        Time retVal = null;
        if (timeString != null) {
            int year = 0;
            int month = 0;
            int day = 0;
            int index = 0;
            String tempString = null;
            String dayString = null;
            String[] parts = StringUtil.split(timeString, "-");
            try {
                year = Integer.parseInt(parts[0]);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            try {
                month = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            try {
                tempString = parts[2];
                index = tempString.indexOf(" ");
                dayString = tempString.substring(0, index);
                day = Integer.parseInt(dayString);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            retVal = new Time(year, month, day, 0, 0, 0, 0);
        }
        return retVal;
    }

    protected void findGoodTime() {
        int hour = 24;
        Calendar now = null;
        boolean goodTime = false;
        while (!goodTime) {
            now = Calendar.getInstance();
            hour = now.get(11);
            if (hour > 0 && hour < 8) {
                goodTime = true;
                continue;
            }
            try {
                Thread.sleep(1800000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected List executeQuery(Connection conn, String sqlString) {
        List retVal = Sql.dbRead(conn, sqlString, null, null);
        return retVal;
    }

    public static void shutDownListener() {
        m_listening = false;
    }
}

