# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.avs import AVSClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAVSPlacementPoliciesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AVSClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_placement_policies_list(self, resource_group):
        response = self.client.placement_policies.list(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_placement_policies_get(self, resource_group):
        response = self.client.placement_policies.get(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
            placement_policy_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_placement_policies_begin_create_or_update(self, resource_group):
        response = self.client.placement_policies.begin_create_or_update(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
            placement_policy_name="str",
            placement_policy={
                "id": "str",
                "name": "str",
                "properties": "placement_policy_properties",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_placement_policies_begin_update(self, resource_group):
        response = self.client.placement_policies.begin_update(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
            placement_policy_name="str",
            placement_policy_update={
                "properties": {
                    "affinityStrength": "str",
                    "azureHybridBenefitType": "str",
                    "hostMembers": ["str"],
                    "state": "str",
                    "vmMembers": ["str"],
                }
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_placement_policies_begin_delete(self, resource_group):
        response = self.client.placement_policies.begin_delete(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
            placement_policy_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
