# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class Error(_Model):
    """The resource management error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.healthbot.models.ErrorError
    """

    error: Optional["_models.ErrorError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorError(_Model):
    """The error object.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.healthbot.models.Error]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.healthbot.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.Error"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.healthbot.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.healthbot.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthBot(TrackedResource):
    """Azure Health Bot resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.healthbot.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The set of properties specific to Azure Health Bot resource.
    :vartype properties: ~azure.mgmt.healthbot.models.HealthBotProperties
    :ivar sku: SKU of the Azure Health Bot. Required.
    :vartype sku: ~azure.mgmt.healthbot.models.Sku
    :ivar identity: The identity of the Azure Health Bot.
    :vartype identity: ~azure.mgmt.healthbot.models.Identity
    """

    properties: Optional["_models.HealthBotProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The set of properties specific to Azure Health Bot resource."""
    sku: "_models.Sku" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SKU of the Azure Health Bot. Required."""
    identity: Optional["_models.Identity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The identity of the Azure Health Bot."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.HealthBotProperties"] = None,
        identity: Optional["_models.Identity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthBotKey(_Model):
    """An entry of HealthBotKeysResponse.

    :ivar key_name: The name of the key.
    :vartype key_name: str
    :ivar value: The value of the key.
    :vartype value: str
    """

    key_name: Optional[str] = rest_field(name="keyName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the key."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the key."""

    @overload
    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthBotKeysResponse(_Model):
    """Health Bot Keys Response.

    :ivar secrets: Array of Azure Health Bot Secrets.
    :vartype secrets: list[~azure.mgmt.healthbot.models.HealthBotKey]
    """

    secrets: Optional[list["_models.HealthBotKey"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of Azure Health Bot Secrets."""

    @overload
    def __init__(
        self,
        *,
        secrets: Optional[list["_models.HealthBotKey"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthBotProperties(_Model):
    """The properties of a Azure Health Bot. The Health Bot Service is a cloud platform that empowers
    developers in Healthcare organizations to build and deploy their compliant, AI-powered virtual
    health assistants and health bots, that help them improve processes and reduce costs.

    :ivar provisioning_state: The provisioning state of the Azure Health Bot resource.
    :vartype provisioning_state: str
    :ivar bot_management_portal_link: The link.
    :vartype bot_management_portal_link: str
    :ivar key_vault_properties: KeyVault properties for the resource encryption.
    :vartype key_vault_properties: ~azure.mgmt.healthbot.models.KeyVaultProperties
    :ivar access_control_method: The access control method for the Azure Health Bot resource.
    :vartype access_control_method: str
    """

    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """The provisioning state of the Azure Health Bot resource."""
    bot_management_portal_link: Optional[str] = rest_field(name="botManagementPortalLink", visibility=["read"])
    """The link."""
    key_vault_properties: Optional["_models.KeyVaultProperties"] = rest_field(
        name="keyVaultProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """KeyVault properties for the resource encryption."""
    access_control_method: Optional[str] = rest_field(name="accessControlMethod", visibility=["read"])
    """The access control method for the Azure Health Bot resource."""

    @overload
    def __init__(
        self,
        *,
        key_vault_properties: Optional["_models.KeyVaultProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthBotUpdateParameters(_Model):
    """Parameters for updating a Azure Health Bot.

    :ivar properties: Properties of Azure Health Bot.
    :vartype properties: ~azure.mgmt.healthbot.models.HealthBotProperties
    :ivar tags: Tags for a Azure Health Bot.
    :vartype tags: dict[str, str]
    :ivar sku: SKU of the Azure Health Bot.
    :vartype sku: ~azure.mgmt.healthbot.models.Sku
    :ivar identity: The identity of the Azure Health Bot.
    :vartype identity: ~azure.mgmt.healthbot.models.Identity
    :ivar location:
    :vartype location: str
    """

    properties: Optional["_models.HealthBotProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of Azure Health Bot."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update"])
    """Tags for a Azure Health Bot."""
    sku: Optional["_models.Sku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SKU of the Azure Health Bot."""
    identity: Optional["_models.Identity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The identity of the Azure Health Bot."""
    location: Optional[str] = rest_field(visibility=["read", "create"])

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.HealthBotProperties"] = None,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.Identity"] = None,
        location: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Identity(_Model):
    """Identity for the resource.

    :ivar principal_id: The principal ID of resource identity. This property will only be provided
     for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource. This property will only be provided for a system
     assigned identity.
    :vartype tenant_id: str
    :ivar type: The identity type. The type 'SystemAssigned, UserAssigned' includes both an
     implicitly created identity and a set of user assigned identities. The type 'None' will remove
     any identities from the Azure Health Bot. Known values are: "SystemAssigned", "UserAssigned",
     "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.healthbot.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.healthbot.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of resource identity. This property will only be provided for a system
     assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of resource. This property will only be provided for a system assigned identity."""
    type: Optional[Union[str, "_models.ResourceIdentityType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity type. The type 'SystemAssigned, UserAssigned' includes both an implicitly created
     identity and a set of user assigned identities. The type 'None' will remove any identities from
     the Azure Health Bot. Known values are: \"SystemAssigned\", \"UserAssigned\", \"SystemAssigned,
     UserAssigned\", and \"None\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of user identities associated with the resource. The user identity dictionary key
     references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyVaultProperties(_Model):
    """Properties of the key vault.

    :ivar key_name: The name of the key vault key. Required.
    :vartype key_name: str
    :ivar key_version: The version of the key vault key.
    :vartype key_version: str
    :ivar key_vault_uri: The Uri of the key vault. Required.
    :vartype key_vault_uri: str
    :ivar user_identity: The user assigned identity (ARM resource id) that has access to the key.
    :vartype user_identity: str
    """

    key_name: str = rest_field(name="keyName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the key vault key. Required."""
    key_version: Optional[str] = rest_field(
        name="keyVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of the key vault key."""
    key_vault_uri: str = rest_field(name="keyVaultUri", visibility=["read", "create", "update", "delete", "query"])
    """The Uri of the key vault. Required."""
    user_identity: Optional[str] = rest_field(
        name="userIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user assigned identity (ARM resource id) that has access to the key."""

    @overload
    def __init__(
        self,
        *,
        key_name: str,
        key_vault_uri: str,
        key_version: Optional[str] = None,
        user_identity: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDetail(_Model):
    """Operation detail payload.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: Display of the operation.
    :vartype display: ~azure.mgmt.healthbot.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar properties: Additional properties.
    :vartype properties: any
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the operation."""
    is_data_action: Optional[bool] = rest_field(
        name="isDataAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the operation is a data action."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Display of the operation."""
    origin: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Origin of the operation."""
    properties: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Additional properties."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Operation display payload.

    :ivar provider: Resource provider of the operation.
    :vartype provider: str
    :ivar resource: Resource of the operation.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Localized friendly description for the operation.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource provider of the operation."""
    resource: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource of the operation."""
    operation: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Localized friendly name for the operation."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Localized friendly description for the operation."""

    @overload
    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Sku(_Model):
    """The resource model definition representing SKU.

    :ivar name: The name of the Azure Health Bot SKU. Required. Known values are: "F0", "C0",
     "PES", and "C1".
    :vartype name: str or ~azure.mgmt.healthbot.models.SkuName
    """

    name: Union[str, "_models.SkuName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the Azure Health Bot SKU. Required. Known values are: \"F0\", \"C0\", \"PES\", and
     \"C1\"."""

    @overload
    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.healthbot.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.healthbot.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """The details of the user assigned managed identity used by the Video Analyzer resource.

    :ivar principal_id: The principal ID of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of user assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of user assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of user assigned identity."""
