# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from azure.mgmt.keyvault.models import Key, KeyAttributes, KeyProperties, PrivateLinkResource
from azure.core.serialization import attribute_list


def test_model_initialization():
    key = Key(kty="EC", attributes=KeyAttributes(enabled=True), key_ops=["encrypt", "decrypt"])
    assert key.kty == "EC"
    assert key.properties.kty == "EC"
    assert key.attributes.enabled is True
    assert key.properties.attributes.enabled is True
    assert "encrypt" in key.key_ops
    assert "decrypt" in key.key_ops
    assert "encrypt" in key.properties.key_ops
    assert "decrypt" in key.properties.key_ops


def test_model_attribute_list_for_compatibility():
    expected_attributes = sorted(
        [
            "id",
            "name",
            "type",
            "system_data",
            "attributes",
            "kty",
            "key_ops",
            "key_size",
            "curve_name",
            "key_uri",
            "key_uri_with_version",
            "rotation_policy",
            "release_policy",
            "location",
            "tags",
        ]
    )
    assert expected_attributes == sorted(attribute_list(Key(properties=KeyProperties(kty="RSA"))))
    assert expected_attributes == sorted(attribute_list(Key(kty="RSA")))
    assert expected_attributes == sorted(attribute_list(Key()))


def test_private_link_resource_initialization():
    plr = PrivateLinkResource(
        group_id="vault", required_members=["member1", "member2"], required_zone_names=["zone1", "zone2"]
    )
    assert plr.group_id == "vault"
    assert plr.properties.group_id == "vault"
