% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R, R/subset.R
\name{stars_subset}
\alias{stars_subset}
\alias{[<-.stars_proxy}
\alias{[.stars}
\alias{[<-.stars}
\alias{st_flip}
\title{subset stars objects}
\usage{
\method{[}{stars_proxy}(x, i, downsample = 0) <- value

\method{[}{stars}(x, i = TRUE, ..., drop = FALSE, crop = !is_curvilinear(x))

\method{[}{stars}(x, i) <- value

st_flip(x, which = 1)
}
\arguments{
\item{x}{object of class \code{stars}}

\item{i}{first selector: integer, logical or character vector indicating attributes to select, or object of class \code{sf}, \code{sfc}, \code{bbox}, or \code{stars} used as spatial selector; see details}

\item{downsample}{downsampling rate used in case \code{i} is a \code{stars_proxy} object}

\item{value}{array of dimensions equal to those in \code{x}, or a vector or value that will be recycled to such an array}

\item{...}{further (logical or integer vector) selectors, matched by order, to select on individual dimensions}

\item{drop}{logical; if \code{TRUE}, degenerate dimensions (with only one value) are dropped}

\item{crop}{logical; if \code{TRUE} and parameter \code{i} is a spatial geometry (\code{sf} or \code{sfc}) object, the extent (bounding box) of the result is cropped to match the extent of \code{i} using \link{st_crop}. Cropping curvilinear grids is not supported.}

\item{which}{character or integer; dimension(s) to be flipped}
}
\value{
\code{st_flip} flips (reverts) the array values along the chosen dimension 
without(s) changing the dimension properties
}
\description{
subset stars objects
}
\details{
If \code{i} is an object of class \code{sf}, \code{sfc} or \code{bbox}, the spatial subset covering this geometry is selected, possibly followed by cropping the extent. Array values for which the cell centre is not inside the geometry are assigned \code{NA}. If \code{i} is of class \code{stars}, and attributes of \code{i} are \code{logical}, cells in \code{x} corresponding to \code{NA} or \code{FALSE} cells in \code{i} are assigned an \code{NA}. Dimension ranges containing negative values or \code{NA} may be partially supported. Character selectors are matched against the names of a dimension if it has names, otherwise to the dimension values.

in an assignment (or replacement form, \code{[<-}), argument \code{i} needs to be either (i) a \code{stars} object with logical attribute(s) that has dimensions matching (possibly after recycling) those of \code{x}, in which case the \code{TRUE} cells will be replaced and \code{i} and/or \code{value} will be recycled to the dimensions of the arrays in \code{x}, or (ii) a length-one integer or character vector indicating which array to replace, in which case \code{value} may be stars object or a vector or array (that will be recycled).
}
\examples{
tif = system.file("tif/L7_ETMs.tif", package = "stars")
x = read_stars(tif)
x[,,,1:3] # select bands
x[,1:100,100:200,] # select x and y by range
x["L7_ETMs.tif"] # select attribute
xy = structure(list(x = c(293253.999046018, 296400.196497684), y = c(9113801.64775462,
9111328.49619133)), .Names = c("x", "y"))
pts = st_as_sf(data.frame(do.call(cbind, xy)), coords = c("x", "y"), crs = st_crs(x))
image(x, axes = TRUE)
plot(st_as_sfc(st_bbox(pts)), col = NA, add = TRUE)
bb = st_bbox(pts)
(xx = x[bb])
image(xx)
plot(st_as_sfc(bb), add = TRUE, col = NA)
image(x)
pt = st_point(c(x = 290462.103109179, y = 9114202.32594085))
buf = st_buffer(st_sfc(pt, crs = st_crs(x)), 1500)
plot(buf, add = TRUE)

buf = st_sfc(st_polygon(list(st_buffer(pt, 1500)[[1]], st_buffer(pt, 1000)[[1]])),
   crs = st_crs(x))
image(x[buf])
plot(buf, add = TRUE, col = NA)
image(x[buf, crop=FALSE])
plot(buf, add = TRUE, col = NA)
# with i of class stars:
x[x > 75] # generates lots of NA's; pattern for each band
x[x[,,,1] > 75] # recycles a single band template for all bands
x = read_stars(tif)
# replace, using a logical stars selector: cuts all values above 90 to 90
x[x > 90] = 90
# replace a single attribute when there are more than one:
s = split(x)
names(s) = paste0("band", 1:6)
# rescale only band 1:
s[1] = s[1] * 0.75 
# rescale only attribute named "band2":
s["band2"] = s["band2"] * 0.85 
# create a new attribute from a numeric vector:
s["rnorm"] = rnorm(prod(dim(s))) 
s
lc = read_stars(system.file("tif/lc.tif", package = "stars"))
x = c(orig = lc, 
      flip_x = st_flip(lc, "x"), 
      flip_y = st_flip(lc, "y"), 
      flip_xy = st_flip(lc, c("x", "y")), 
      along = 3)
plot(x)
}
