<head>
  <meta charset="UTF-8">
  <meta name="description" content="ROCm API libraries & tools">
  <meta name="keywords" content="ROCm, API, libraries, tools, artificial intelligence, development,
  Communications, C++ primitives, Fast Fourier transforms, FFTs, random number generators, linear
  algebra, AMD">
</head>

# ROCm libraries

::::{grid} 1 2 2 2
:gutter: 3
:class-container: rocm-doc-grid

:::{grid-item-card} Machine Learning and Computer Vision
:class-body: rocm-card-banner rocm-hue-3

(artificial-intelligence-apis)=

* {doc}`Composable Kernel <composable_kernel:index>`
* {doc}`MIGraphX <amdmigraphx:index>`
* {doc}`MIOpen <miopen:index>`
* {doc}`MIVisionX <mivisionx:index>`
* {doc}`rocAL <rocal:index>`
* {doc}`rocDecode <rocdecode:index>`
* {doc}`rocPyDecode <rocpydecode:index>`
* {doc}`rocJPEG <rocjpeg:index>`
* {doc}`ROCm Performance Primitives (RPP) <rpp:index>`
:::

:::{grid-item-card} Primitives
:class-body: rocm-card-banner rocm-hue-12

(cpp-primitives)=

* {doc}`hipCUB <hipcub:index>`
* {doc}`hipTensor <hiptensor:index>`
* {doc}`rocPRIM <rocprim:index>`
* {doc}`rocThrust <rocthrust:index>`
:::

:::{grid-item-card} Communication
:class-body: rocm-card-banner rocm-hue-7

(communication-libraries)=

* {doc}`RCCL <rccl:index>`
* {doc}`rocSHMEM <rocshmem:index>`
:::

:::{grid-item-card} Math
:class-body: rocm-card-banner rocm-hue-6

(math-apis)=

* [half](https://github.com/ROCm/half)
* {doc}`hipBLAS <hipblas:index>` / {doc}`rocBLAS <rocblas:index>`
* {doc}`hipBLASLt <hipblaslt:index>`
* {doc}`hipFFT <hipfft:index>` / {doc}`rocFFT <rocfft:index>`
* {doc}`hipfort <hipfort:index>`
* {doc}`hipRAND <hiprand:index>` / {doc}`rocRAND <rocrand:index>`
* {doc}`hipSOLVER <hipsolver:index>` / {doc}`rocSOLVER <rocsolver:index>`
* {doc}`hipSPARSE <hipsparse:index>` / {doc}`rocSPARSE <rocsparse:index>`
* {doc}`hipSPARSELt <hipsparselt:index>`
* {doc}`rocALUTION <rocalution:index>`
* {doc}`rocWMMA <rocwmma:index>`
* {doc}`Tensile <tensile:src/index>`
:::

::::
