# 0.0.30

**Version:** 0.0.30
**Published:** 2025-03-08T13:54:44Z

## Release Notes

### 📦 **Rust Coreutils 0.0.30 Release:**
We are excited to announce the release of **Rust Coreutils 0.0.30**!
---
### Highlights:
- **Improved Compatibility**:
  - This release focused on compatibility with the upstream GNU Coreutils 9.6 release. This is why the number of passing tests didn't change much - our effort was directed at adapting to the new upstream version rather than fixing existing test failures.
  - Passing GNU tests increased to **507** (+1 compared to 0.0.29).
- **Contributions**: This release was made possible by the dedication of **22 contributors**, including **8 newcomers**.
-  We also announced at FOSDEM the extension of this project to cover other key Linux tools through our uutils initiative. This will extend the Rust rewrite effort to additional common Unix tools. See the presentation on [YouTube](https://www.youtube.com/watch?v=cXf31nFPo0U) ([slides](https://sylvestre.ledru.info/coreutils-fosdem-2025/)) or read the [LWN article](https://lwn.net/Articles/1007907/) for more details about our vision.

---
### GNU Test Suite Compatibility:
Here's how version 0.0.30 compares to the previous release:

| Result        | 0.0.29 | 0.0.30 | Change 0.0.29 to 0.0.30 | % Total 0.0.29 | % Total 0.0.30 | % Change 0.0.29 to 0.0.30 |
|---------------|--------|--------|-------------------------|----------------|----------------|--------------------------|
| Pass          | 506    | 507    | +1                      | 82.38%         | 82.17%         | -0.21%                   |
| Skip          | 41     | 41     | 0                       | 6.68%          | 6.65%          | -0.03%                   |
| Fail          | 67     | 69     | +2                      | 10.92%         | 11.18%         | +0.26%                   |
| Total         | 614    | 617    | +3 (new tests)                     |            |            |                        |

---
![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.svg?raw=true)
---
### Call to Action:
Support our work by sponsoring us on GitHub! Your contributions directly help maintain our infrastructure and enable faster development. [Sponsor us here](https://github.com/sponsors/uutils).
For more details and to download the latest release, visit our website: [https://uutils.github.io](https://uutils.github.io).

## What's Changed

### cat
* error when output is input and appending by @jfinkels in https://github.com/uutils/coreutils/pull/7260

### chgrp
* add option --from by @sylvestre in https://github.com/uutils/coreutils/pull/7129
* gnu/tests/chgrp/from.sh is now fixed by @sylvestre in https://github.com/uutils/coreutils/pull/7205

### cksum
* Fix #6375 and un-ignore now passing tests by @RenjiSann in https://github.com/uutils/coreutils/pull/7261
* Update error and flags handling to improver GNU's match by @RenjiSann in https://github.com/uutils/coreutils/pull/7192
* add CRC32B algorithm added in GNU 9.6 by @RenjiSann in https://github.com/uutils/coreutils/pull/7169
* replace `is_some_and` with `is_none_or` by @cakebaker in https://github.com/uutils/coreutils/pull/7403

### cp
* disabled verbose output if file has been skipped by @BigPapa314 in https://github.com/uutils/coreutils/pull/7347
* fix verbose output order after prompt by @aimerlief in https://github.com/uutils/coreutils/pull/7287

### csplit
* don't panic on missing suppressed file by @jfinkels in https://github.com/uutils/coreutils/pull/7292

### echo
* use uucore::format::parse_escape_only() by @jfinkels in https://github.com/uutils/coreutils/pull/7316

### expr
* Add tests by @RenjiSann in https://github.com/uutils/coreutils/pull/7356
* Evaluate parenthesis content before checking for closing parenthesis by @RenjiSann in https://github.com/uutils/coreutils/pull/7332
* Fix assorted test errors in tests/expr/expr.pl by @sargas in https://github.com/uutils/coreutils/pull/6134
* Get rid of clap for performance reasons by @RenjiSann in https://github.com/uutils/coreutils/pull/7352

### install
* Document install-C test failure by @sylvestre in https://github.com/uutils/coreutils/pull/7223

### head
* ensure stdin input stream is correct on exit by @karlmcdowall in https://github.com/uutils/coreutils/pull/7253
* Fix bug printing large non-seekable files by @karlmcdowall in https://github.com/uutils/coreutils/pull/7294
* fix bug reading back through files by @karlmcdowall in https://github.com/uutils/coreutils/pull/7248
* improve error mgmt. by @sylvestre in https://github.com/uutils/coreutils/pull/7408
* Remove a head test from the list of failure by @sylvestre in https://github.com/uutils/coreutils/pull/7414

### kill
* don't allow lowercase signal names with '-' by @cakebaker in https://github.com/uutils/coreutils/pull/7206
* fix the fail to use only least significant bits to identify signal with -l by @Felle33 in https://github.com/uutils/coreutils/pull/7225
* list signal `0` with `-l` and `-t` by @cakebaker in https://github.com/uutils/coreutils/pull/7193
* test "-l <number>" & adapt error messages by @cakebaker in https://github.com/uutils/coreutils/pull/7213

### ls
* display %Z alphabetic time zone abbreviation by @jfinkels in https://github.com/uutils/coreutils/pull/7154
* Refactoring ls and date by @Felle33 in https://github.com/uutils/coreutils/pull/7194
* gnu patches: adapt `tests_ls_no_cap.patch` to GNU `coreutils 9.6` by @cakebaker in https://github.com/uutils/coreutils/pull/7163

### mv
* show prompt for `-u --interactive` by @cakebaker in https://github.com/uutils/coreutils/pull/7178
* Make mv command fallback to copy only if the src and dst are on different device by @hamflx in https://github.com/uutils/coreutils/pull/6040

### numfmt
* extract test from other test & expand it by @cakebaker in https://github.com/uutils/coreutils/pull/7155
* fix Unit::SI uses lowercase `k` suffix for kilos by @alexsnaps in https://github.com/uutils/coreutils/pull/7322
* fix from iec-i without suffix are bytes by @alexsnaps in https://github.com/uutils/coreutils/pull/7323

### od
* remove custom implementations of PartialEq and Eq by @alexs-sh in https://github.com/uutils/coreutils/pull/7211

### printf
* (partially) fix hex format: exponent is decimal, correctly print negative numbers by @drinkcat in https://github.com/uutils/coreutils/pull/7365
* Show warning message in case of excess arguments by @RenjiSann in https://github.com/uutils/coreutils/pull/7239
* error on missing hexadecial escape value by @jfinkels in https://github.com/uutils/coreutils/pull/7259
* negative asterisk param changes alignment by @RenjiSann in https://github.com/uutils/coreutils/pull/7246
* Re-enable integer overflow test case for printf by @jfinkels in https://github.com/uutils/coreutils/pull/7168

### rm
* add two passing tests for -i option by @jfinkels in https://github.com/uutils/coreutils/pull/7306
* correct prompt for removing inaccessible dir by @jfinkels in https://github.com/uutils/coreutils/pull/7325
* simplify remove_dir() helper function by @jfinkels in https://github.com/uutils/coreutils/pull/7308
* use recursive directory traversal with --recursive by @jfinkels in https://github.com/uutils/coreutils/pull/7304

### seq
* remove timeout from seq test cases by @jfinkels in https://github.com/uutils/coreutils/pull/7171

### sort
* errors on overflowing -k argument but shouldn't by @ic3man5 in https://github.com/uutils/coreutils/pull/7188
* needs support for human-readable block size suffixes R and Q by @ic3man5 in https://github.com/uutils/coreutils/pull/7198
* options -C and -c should be mutually exclusive but aren't by @ic3man5 in https://github.com/uutils/coreutils/pull/7191
* support percent arguments to -S option by @jfinkels in https://github.com/uutils/coreutils/pull/7181

### split
* avoid extremely long format width in test by @jfinkels in https://github.com/uutils/coreutils/pull/7301

### tee
* fix -p behavior upon broken pipe stdout by @RenjiSann in https://github.com/uutils/coreutils/pull/7273
* fix usage of deprecated function in tests by @cakebaker in https://github.com/uutils/coreutils/pull/7341

### test
* add < and > operators for string comparison by @jfinkels in https://github.com/uutils/coreutils/pull/7315
* remove `sleep` from tests by @cakebaker in https://github.com/uutils/coreutils/pull/7327

### timeout
* add support for `-f` and `-p` short options by @cakebaker in https://github.com/uutils/coreutils/pull/7200

### touch
* support obsolete POSIX timestamp argument by @jfinkels in https://github.com/uutils/coreutils/pull/7274

### tr
* Fix GNU behavior deviation by @RenjiSann in https://github.com/uutils/coreutils/pull/7320

### uptime
* refactor, move some codes to uucore by @Bluemangoo in https://github.com/uutils/coreutils/pull/7289
* remove duplicate test by @cakebaker in https://github.com/uutils/coreutils/pull/7265

### yes
* fix use of deprecated function in test by @cakebaker in https://github.com/uutils/coreutils/pull/7348

### uucore
* Add missing dependencies by @sylvestre in https://github.com/uutils/coreutils/pull/7157
* Fix proc_info compilation by @dezgeg in https://github.com/uutils/coreutils/pull/7385
* Sync proc_info methods from procps by @dezgeg in https://github.com/uutils/coreutils/pull/7351
* remove `lazy_static` and use `LazyLock` instead by @cakebaker in https://github.com/uutils/coreutils/pull/7404
* replace `PanicInfo` with `PanicHookInfo` by @cakebaker in https://github.com/uutils/coreutils/pull/7395
* uucore/docs.rs: generate the doc for all features by @sylvestre in https://github.com/uutils/coreutils/pull/7220

### Documentation
* Fix usage strings for #5692 by @rwdj in https://github.com/uutils/coreutils/pull/7303
* why-error.md: document more errors by @sylvestre in https://github.com/uutils/coreutils/pull/7224

### Build & CI
* add words to `spell-checker:ignore` in two files by @cakebaker in https://github.com/uutils/coreutils/pull/7300
* build: restore uutils in GNU test files by @jfinkels in https://github.com/uutils/coreutils/pull/7170
* try upstream 9.6 by @sylvestre in https://github.com/uutils/coreutils/pull/7149
* .github: CICD: add workspace test to build matrix by @drinkcat in https://github.com/uutils/coreutils/pull/7386
* GNUmakefile: fix install error "argument list too long" by @blmaier in https://github.com/uutils/coreutils/pull/7321
* GNUmakefile: support skipping manpages and completions by @blmaier in https://github.com/uutils/coreutils/pull/7331
* gnu patches: move to use quilt by @sylvestre in https://github.com/uutils/coreutils/pull/7127
* Decrease more sleep by @sylvestre in https://github.com/uutils/coreutils/pull/7244
* Fixed Bugs When Not Using Default Target Directory by @zcg00 in https://github.com/uutils/coreutils/pull/7266
* Use ubuntu-24.04-arm to build/test linux arm64 by @sylvestre in https://github.com/uutils/coreutils/pull/7153
* prepare version 0.0.30 by @sylvestre in https://github.com/uutils/coreutils/pull/7418
* Add fails_with_code() function by @RenjiSann in https://github.com/uutils/coreutils/pull/7369
* Decrease the various sleeps by @sylvestre in https://github.com/uutils/coreutils/pull/7232
* make `wait_with_output` private by @cakebaker in https://github.com/uutils/coreutils/pull/7350
* use the new function fails_with_code by @sylvestre in https://github.com/uutils/coreutils/pull/7371
* Use the new function 'fails_with_code' - followup by @sylvestre in https://github.com/uutils/coreutils/pull/7391
* GNU test: don't generate an error if a new test passes by @sylvestre in https://github.com/uutils/coreutils/pull/7349
* deny.toml: remove `syn` from skip list by @cakebaker in https://github.com/uutils/coreutils/pull/7139
* deny.toml: remove three crates from skip list by @cakebaker in https://github.com/uutils/coreutils/pull/7390
* deny.toml: add `rustix` & `linux-raw-sys` to skip list by @cakebaker in https://github.com/uutils/coreutils/pull/7416
* Nix/Nixos development by @RenjiSann in https://github.com/uutils/coreutils/pull/6947
* mount temp fs by @matrixhead in https://github.com/uutils/coreutils/pull/7249
* github action: do not fail the GNU test if only intermittent by @sylvestre in https://github.com/uutils/coreutils/pull/7283
* Remove some replacements of touch in build script by @jfinkels in https://github.com/uutils/coreutils/pull/7243
* add two tests to the list of intermittent tests by @sylvestre in https://github.com/uutils/coreutils/pull/7195
* fix util/remaining-gnu-error.py by @sylvestre in https://github.com/uutils/coreutils/pull/7204


### fuzzing
* fuzz: update dependencies by @cakebaker in https://github.com/uutils/coreutils/pull/7245
* fuzz: use new `<`/`>` operators in `fuzz_test.rs` by @cakebaker in https://github.com/uutils/coreutils/pull/7330
* Improve fuzzer logging by @RenjiSann in https://github.com/uutils/coreutils/pull/7281

### Code quality
* clippy: fix warnings from `unnecessary_map_or` lint by @cakebaker in https://github.com/uutils/coreutils/pull/7398
* clippy: fix/disable warnings introduced with Rust `1.85` by @cakebaker in https://github.com/uutils/coreutils/pull/7329
* Cargo.toml: fix incorrect lint name by @cakebaker in https://github.com/uutils/coreutils/pull/7267
* Remove `once_cell` dependency and use `LazyLock` by @cakebaker in https://github.com/uutils/coreutils/pull/7405
* Remove `rand_pcg` by @cakebaker in https://github.com/uutils/coreutils/pull/7233
* Style fixes from cargo +nightly clippy by @jfinkels in https://github.com/uutils/coreutils/pull/7339
* Move other programs to thiserror by @sylvestre in https://github.com/uutils/coreutils/pull/7207
* Move some programs to thiserror by @sylvestre in https://github.com/uutils/coreutils/pull/7175
* minor code quality improvements by @danieleades in https://github.com/uutils/coreutils/pull/7177
* remove redundant clippy MSRV config by @danieleades in https://github.com/uutils/coreutils/pull/7176
* mktemp,tr: replace `repeat().take()` with `repeat_n()`  by @cakebaker in https://github.com/uutils/coreutils/pull/7400


## Dependency Updates
* Bump MSRV to 1.82.0 by @drinkcat in https://github.com/uutils/coreutils/pull/7394
* Bump `fts-sys` from `0.2.13` to `0.2.14` by @cakebaker in https://github.com/uutils/coreutils/pull/7279
* Bump `nom` and adapt `tr` to API changes by @cakebaker in https://github.com/uutils/coreutils/pull/7227
* Bump `rand` & `rand_core` to `0.9.0`, adapt code to API changes by @cakebaker in https://github.com/uutils/coreutils/pull/7242
* Bump `tempfile` & add two crates to the skip list in `deny.toml` by @cakebaker in https://github.com/uutils/coreutils/pull/7238
* fix(deps): update rust crate similar to v2.7.0 by @renovate in https://github.com/uutils/coreutils/pull/7164
* chore(deps): update rust crate parse_datetime to 0.7.0 by @renovate in https://github.com/uutils/coreutils/pull/7172
* chore(deps): update rust crate clap to v4.5.27 by @renovate in https://github.com/uutils/coreutils/pull/7189
* chore(deps): update dawidd6/action-download-artifact action to v8 by @renovate in https://github.com/uutils/coreutils/pull/7196
* chore(deps): update rust crate clap_complete to v4.5.43 by @renovate in https://github.com/uutils/coreutils/pull/7228
* chore(deps): update rust crate indicatif to v0.17.10 by @renovate in https://github.com/uutils/coreutils/pull/7234
* fix(deps): update rust crate libfuzzer-sys to v0.4.9 by @renovate in https://github.com/uutils/coreutils/pull/7236
* chore(deps): update rust crate indicatif to v0.17.11 by @renovate in https://github.com/uutils/coreutils/pull/7235
* chore(deps): update rust crate clap_complete to v4.5.44 by @renovate in https://github.com/uutils/coreutils/pull/7240
* fix(deps): update rust crate z85 to v3.0.6 by @renovate in https://github.com/uutils/coreutils/pull/7264
* chore(deps): update rust crate clap to v4.5.28 by @renovate in https://github.com/uutils/coreutils/pull/7263
* chore(deps): update rust crate blake2b_simd to v1.0.3 by @renovate in https://github.com/uutils/coreutils/pull/7268
* chore(deps): update rust crate selinux to 0.5.0 by @renovate in https://github.com/uutils/coreutils/pull/7278
* chore(deps): update rust crate once_cell to v1.20.3 by @renovate in https://github.com/uutils/coreutils/pull/7277
* fix(deps): update rust crate data-encoding-macro to v0.1.17 by @renovate in https://github.com/uutils/coreutils/pull/7290
* chore(deps): update rust crate clap to v4.5.29 by @renovate in https://github.com/uutils/coreutils/pull/7297
* chore(deps): update rust crate smallvec to v1.14.0 by @renovate in https://github.com/uutils/coreutils/pull/7302
* fix(deps): update rust crate tempfile to v3.17.0 by @renovate in https://github.com/uutils/coreutils/pull/7311
* chore(deps): update rust crate rand_core to v0.9.1 by @renovate in https://github.com/uutils/coreutils/pull/7310
* chore(deps): update rust crate parse_datetime to 0.8.0 by @renovate in https://github.com/uutils/coreutils/pull/7314
* fix(deps): update rust crate tempfile to v3.17.1 by @renovate in https://github.com/uutils/coreutils/pull/7313
* chore(deps): update rust crate clap to v4.5.30 by @renovate in https://github.com/uutils/coreutils/pull/7317
* chore(deps): update rust crate clap_complete to v4.5.45 by @renovate in https://github.com/uutils/coreutils/pull/7318
* chore(deps): update rust crate blake3 to v1.6.0 by @renovate in https://github.com/uutils/coreutils/pull/7319
* chore(deps): update rust crate serde to v1.0.218 by @renovate in https://github.com/uutils/coreutils/pull/7328
* fix(deps): update rust crate libc to v0.2.170 by @renovate in https://github.com/uutils/coreutils/pull/7346
* chore(deps): update rust crate rand_core to v0.9.2 by @renovate in https://github.com/uutils/coreutils/pull/7345
* chore(deps): update rust crate clap_complete to v4.5.46 by @renovate in https://github.com/uutils/coreutils/pull/7354
* chore(deps): update rust crate clap to v4.5.31 by @renovate in https://github.com/uutils/coreutils/pull/7353
* chore(deps): update rust crate zip to v2.2.3 by @renovate in https://github.com/uutils/coreutils/pull/7358
* chore(deps): update rust crate chrono to v0.4.40 by @renovate in https://github.com/uutils/coreutils/pull/7360
* chore(deps): update dawidd6/action-download-artifact action to v9 by @renovate in https://github.com/uutils/coreutils/pull/7367
* chore(deps): update rust crate blake3 to v1.6.1 by @renovate in https://github.com/uutils/coreutils/pull/7370
* fix(deps): update rust crate console to v0.15.11 by @renovate in https://github.com/uutils/coreutils/pull/7374
* chore(deps): update rust crate rand_core to v0.9.3 by @renovate in https://github.com/uutils/coreutils/pull/7373
* chore(deps): update rust crate rstest to 0.25.0 by @renovate in https://github.com/uutils/coreutils/pull/7377
* chore(deps): update rust crate thiserror to v2.0.12 by @renovate in https://github.com/uutils/coreutils/pull/7379
* fix(deps): update rust crate proc-macro2 to v1.0.94 by @renovate in https://github.com/uutils/coreutils/pull/7380
* fix(deps): update rust crate quote to v1.0.39 by @renovate in https://github.com/uutils/coreutils/pull/7381
* chore(deps): update rust crate textwrap to v0.16.2 by @renovate in https://github.com/uutils/coreutils/pull/7387
* chore(deps): update rust crate unindent to v0.2.4 by @renovate in https://github.com/uutils/coreutils/pull/7389
* chore(deps): update rust crate time to v0.3.38 by @renovate in https://github.com/uutils/coreutils/pull/7402
* chore(deps): update rust crate time to v0.3.39 by @renovate in https://github.com/uutils/coreutils/pull/7406
* chore(deps): update mozilla-actions/sccache-action action to v0.0.8 by @renovate in https://github.com/uutils/coreutils/pull/7415
* chore(deps): update rust crate xattr to v1.5.0 by @renovate in https://github.com/uutils/coreutils/pull/7409
* fix(deps): update rust crate tempfile to v3.18.0 by @renovate in https://github.com/uutils/coreutils/pull/7410

## New Contributors
* @ic3man5 made their first contribution in https://github.com/uutils/coreutils/pull/7188
* @rwdj made their first contribution in https://github.com/uutils/coreutils/pull/7303
* @alexsnaps made their first contribution in https://github.com/uutils/coreutils/pull/7323
* @blmaier made their first contribution in https://github.com/uutils/coreutils/pull/7321
* @Bluemangoo made their first contribution in https://github.com/uutils/coreutils/pull/7289
* @BigPapa314 made their first contribution in https://github.com/uutils/coreutils/pull/7347
* @drinkcat made their first contribution in https://github.com/uutils/coreutils/pull/7365
* @zcg00 made their first contribution in https://github.com/uutils/coreutils/pull/7266

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.29...0.0.30
