<template name="file-header">
    /*
        Generated by sbus code generator

        Copyright (C) 2017 Red Hat

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 3 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program.  If not, see <http://www.gnu.org/licenses/>.
    */

    #include <errno.h>
    #include <talloc.h>
    #include <dbus/dbus.h>

    #include "${sbus-path}/sbus_sync.h"
    #include "${sbus-path}/sbus_sync_private.h"
    #include "${sbus-path}/sbus_message.h"
    #include "${sbus-path}/interface/sbus_iterator_readers.h"
    #include "${sbus-path}/interface_dbus/sbus_dbus_client_sync.h"
    #include "${header:arguments}"
    #include "${header:client_properties}"

</template>

<template name="method-invoker">
    static errno_t
    sbus_method_in_${input-signature}_out_${output-signature}
        (<toggle name="if-use-talloc">TALLOC_CTX *mem_ctx,
         struct sbus_sync_connection *conn,
         <or>struct sbus_sync_connection *conn,
         </toggle><toggle name="if-raw-input">
         DBusMessage *raw_message<or>
         const char *bus,
         const char *path,
         const char *iface,
         const char *method<loop name="in">,
         ${type} arg${index}</loop></toggle>
         <toggle name="if-raw-output">,
         DBusMessage **_reply)
         <or><loop name="out">,
         ${type} _arg${index}</loop>)
         </toggle>
    {
        TALLOC_CTX *tmp_ctx;
        <toggle name="if-input-arguments">
        struct _sbus_invoker_args_${input-signature} in;
        </toggle>
        <toggle name="if-output-arguments">
        struct _sbus_invoker_args_${output-signature} *out;
        </toggle>
        DBusMessage *reply;
        errno_t ret;

        tmp_ctx = talloc_new(NULL);
        if (tmp_ctx == NULL) {
            DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
            return ENOMEM;
        }

        <toggle name="if-output-arguments">
        out = talloc_zero(tmp_ctx, struct _sbus_invoker_args_${output-signature});
        if (out == NULL) {
            DEBUG(SSSDBG_CRIT_FAILURE,
                  "Unable to allocate space for output parameters!\n");
            ret = ENOMEM;
            goto done;
        }

        </toggle>
        <loop name="in">
        in.arg${index} = arg${index};
        </loop>

        <toggle name="if-raw-input">
        ret = sbus_sync_call_method(tmp_ctx, conn, raw_message, NULL, NULL,
                                    dbus_message_get_path(raw_message),
                                    dbus_message_get_interface(raw_message),
                                    dbus_message_get_member(raw_message),
                                    NULL, &reply);
        </toggle>
        <toggle name="if-input-arguments">
        ret = sbus_sync_call_method(tmp_ctx, conn, NULL,
                                    (sbus_invoker_writer_fn)_sbus_invoker_write_${input-signature},
                                    bus, path, iface, method, &in, &reply);
        </toggle>
        <toggle name="if-empty-input">
        ret = sbus_sync_call_method(tmp_ctx, conn, NULL, NULL,
                                    bus, path, iface, method, NULL, &reply);
        </toggle>
        if (ret != EOK) {
            goto done;
        }

        <toggle name="if-raw-output">
        /* Bounded reference cannot be unreferenced with dbus_message_unref.
         * For that reason we do not allow NULL memory context as it would
         * result in leaking the message memory. */
        if (mem_ctx == NULL) {
            ret = EINVAL;
            goto done;
        }

        ret = sbus_message_bound_steal(mem_ctx, reply);
        if (ret != EOK) {
            DEBUG(SSSDBG_CRIT_FAILURE, "Unable to steal message [%d]: %s\n",
                  ret, sss_strerror(ret));
            goto done;
        }

        *_reply = reply;

        </toggle>
        <toggle name="if-output-arguments">
        ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_invoker_read_${output-signature}, out);
        if (ret != EOK) {
            goto done;
        }

        <loop name="out-static">
        *_arg${index} = out->arg${index};
        </loop>
        <loop name="out-talloc">
        *_arg${index} = talloc_steal(mem_ctx, out->arg${index});
        </loop>

        </toggle>
        ret = EOK;

    done:
        talloc_free(tmp_ctx);

        return ret;
    }

</template>

<template name="method-caller">
    errno_t
    sbus_call_${token}
        (<toggle name="if-use-talloc">TALLOC_CTX *mem_ctx,
         struct sbus_sync_connection *conn,
         <or>struct sbus_sync_connection *conn,
         </toggle><toggle name="if-raw-input">
         DBusMessage *raw_message<or>
         const char *busname,
         const char *object_path<loop name="in">,
         ${type} arg_${name}</loop></toggle>
         <toggle name="if-raw-output">,
         DBusMessage **_reply)
         <or><loop name="out">,
         ${type} _arg_${name}</loop>)
         </toggle>
    {
         return sbus_method_in_${input-signature}_out_${output-signature}(<toggle name="if-use-talloc">mem_ctx, </toggle>conn,
              <toggle name="if-raw-input">
              raw_message<or>
              busname, object_path, "${iface}", "${method}"<loop name="in">, arg_${name}</loop></toggle>
              <toggle name="if-raw-output">,
              _reply);
              <or><loop name="out">,
              _arg_${name}</loop>);
              </toggle>
    }

</template>

<template name="signal-invoker">
    static void
    sbus_emit_signal_${input-signature}
        (struct sbus_sync_connection *conn,
         <toggle name="if-raw-input">
         DBusMessage *raw_message)
         <or>
         const char *path,
         const char *iface,
         const char *signal_name<loop name="in">,
         ${type} arg${index}</loop>)
         </toggle>
    {
        <toggle name="if-input-arguments">
        struct _sbus_invoker_args_${input-signature} args;

        <loop name="in">
        args.arg${index} = arg${index};
        </loop>

        </toggle>
        <toggle name="if-raw-input">
        sbus_sync_call_signal(conn, raw_message, NULL,
                              dbus_message_get_path(raw_message),
                              dbus_message_get_interface(raw_message),
                              dbus_message_get_member(raw_message), NULL);
        </toggle>
        <toggle name="if-input-arguments">
        sbus_sync_call_signal(conn, NULL, (sbus_invoker_writer_fn)_sbus_invoker_write_${input-signature},
                              path, iface, signal_name, &args);
        </toggle>
        <toggle name="if-empty-input">
        sbus_sync_call_signal(conn, NULL, NULL, path, iface, signal_name, NULL);
        </toggle>
    }

</template>

<template name="signal-caller">
    void
    sbus_sync_emit_${token}
        (struct sbus_sync_connection *conn,
         <toggle name="if-raw-input">
         DBusMessage *raw_message)
         <or>
         const char *object_path<loop name="in">,
         ${type} arg_${name}</loop>)
         </toggle>
    {
        <toggle name="if-raw-input">
        sbus_emit_signal_${input-signature}(conn, raw_message);
        <or>
        sbus_emit_signal_${input-signature}(conn, object_path,
            "${iface}", "${signal}"<loop name="in">, arg_${name}</loop>);
        </toggle>
    }

</template>

<template name="get-invoker">
    static errno_t
    sbus_get_${output-signature}
        (<toggle name="if-use-talloc">TALLOC_CTX *mem_ctx,
         struct sbus_sync_connection *conn,
         <or>struct sbus_sync_connection *conn,
         </toggle>
         const char *bus,
         const char *path,
         const char *iface,
         const char *property,
         ${output-type} _value)
    {
        TALLOC_CTX *tmp_ctx;
        struct _sbus_invoker_args_${output-signature} *out;
        sbus_value_reader_fn reader;
        sbus_value_reader_talloc_fn reader_talloc;
        DBusMessage *reply;
        errno_t ret;

        tmp_ctx = talloc_new(NULL);
        if (tmp_ctx == NULL) {
            DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
            return ENOMEM;
        }

        out = talloc_zero(tmp_ctx, struct _sbus_invoker_args_${output-signature});
        if (out == NULL) {
            DEBUG(SSSDBG_CRIT_FAILURE,
                  "Unable to allocate space for output parameters!\n");
            ret = ENOMEM;
            goto done;
        }

        ret = sbus_call_DBusProperties_Get(tmp_ctx, conn,
                  bus, path, iface, property, &reply);
        if (ret != EOK) {
            goto done;
        }

        reader = <toggle line name="if-use-talloc">NULL<or>(sbus_value_reader_fn)sbus_iterator_read_${output-signature}</toggle>;
        reader_talloc = <toggle line name="if-use-talloc">(sbus_value_reader_talloc_fn)sbus_iterator_read_${output-signature}<or>NULL</toggle>;
        ret = sbus_parse_get_message(out, reader, reader_talloc, reply, &out->arg0);
        if (ret != EOK) {
            goto done;
        }

        *_value = <toggle line name="if-use-talloc">talloc_steal(mem_ctx, out->arg0)<or>out->arg0</toggle>;

        ret = EOK;

    done:
        talloc_free(tmp_ctx);

        return ret;
    }

</template>

<template name="set-invoker">
    static errno_t
    sbus_set_${input-signature}
        (struct sbus_sync_connection *conn,
         const char *bus,
         const char *path,
         const char *iface,
         const char *property,
         ${input-type} value)
    {
        TALLOC_CTX *tmp_ctx;
        struct _sbus_invoker_args_${input-signature} in;
        DBusMessage *raw_message;
        errno_t ret;

        tmp_ctx = talloc_new(NULL);
        if (tmp_ctx == NULL) {
            DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
            return ENOMEM;
        }

        in.arg0 = value;

        raw_message = sbus_create_set_call(tmp_ctx,
                          (sbus_invoker_writer_fn)_sbus_invoker_write_${input-signature},
                          bus, path, iface, property,
                          "${dbus-type}", &in);
        if (raw_message == NULL) {
            ret = ENOMEM;
            goto done;
        }

        ret = sbus_call_DBusProperties_Set(conn, raw_message);
        if (ret != EOK) {
            goto done;
        }

        ret = EOK;

    done:
        talloc_free(tmp_ctx);

        return ret;
    }

</template>

<template name="property-caller">
    <toggle name="get-static">
    errno_t
    sbus_get_${token}
        (struct sbus_sync_connection *conn,
         const char *busname,
         const char *object_path,
         ${output-type} _value)
    {
        return sbus_get_${output-signature}(conn, busname, object_path,
                    "${iface}", "${property}", _value);
    }

    </toggle>
    <toggle name="get-talloc">
    errno_t
    sbus_get_${token}
        (TALLOC_CTX *mem_ctx,
         struct sbus_sync_connection *conn,
         const char *busname,
         const char *object_path,
         ${output-type} _value)
    {
        return sbus_get_${output-signature}(mem_ctx, conn, busname, object_path,
                    "${iface}", "${property}", _value);
    }

    </toggle>
    <toggle name="set">
    errno_t
    sbus_set_${token}
        (struct sbus_sync_connection *conn,
         const char *busname,
         const char *object_path,
         ${input-type} value)
    {
        return sbus_set_${input-signature}(conn, busname, object_path,
                   "${iface}", "${property}", value);
    }

    </toggle>
</template>

<template name="getall-caller">
    errno_t
    sbus_getall_${token}
        (TALLOC_CTX *mem_ctx,
         struct sbus_sync_connection *conn,
         const char *busname,
         const char *object_path,
         struct sbus_all_${token} **_properties)
    {
        TALLOC_CTX *tmp_ctx;
        struct sbus_all_${token} *properties;
        DBusMessage *reply;
        errno_t ret;

        tmp_ctx = talloc_new(NULL);
        if (tmp_ctx == NULL) {
            DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
            return ENOMEM;
        }

        properties = talloc_zero(tmp_ctx, struct sbus_all_${token});
        if (properties == NULL) {
            ret = ENOMEM;
            goto done;
        }

        struct sbus_parse_getall_table table[] = {
            <loop name="property-static">
            {"${name}", (sbus_value_reader_fn)sbus_iterator_read_${output-signature}, NULL,
             &properties->${name}.value, &properties->${name}.is_set},
            </loop>
            <loop name="property-talloc">
            {"${name}", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_${output-signature},
             &properties->${name}.value, &properties->${name}.is_set},
            </loop>
            {NULL, NULL, NULL, NULL, NULL}
        };

        ret = sbus_call_DBusProperties_GetAll(tmp_ctx, conn,
                  busname, object_path, "${iface}", &reply);
        if (ret != EOK) {
            goto done;
        }

        ret = sbus_parse_getall_message(properties, table, reply);
        if (ret != EOK) {
            goto done;
        }

        *_properties = talloc_steal(mem_ctx, properties);

        ret = EOK;

    done:
        talloc_free(tmp_ctx);

        return ret;
    }

</template>
