\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{common99}[1999/09/08 v1 common class for 'eurobm' (EuroTeX 99)]

\PassOptionsToClass{a4paper,landscape,25pt}{foils}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{foils}}
\ProcessOptions*\relax
\LoadClass{foils}

\RequirePackage{graphicx,array,verbatim,afterpage,%
            tabularx,latexsym,url,calc}

\setlength{\abovetitleskip}{-100mm}
\addtolength{\textheight}{12mm}

\catcode`\^^Z=5

% color
\RequirePackage{color}
\definecolor{green}{rgb}{0,0.5,0}
\definecolor{violett}{rgb}{0.75,0,0.75}


% pdfinfo
\catcode`\^^A=\active
\catcode`\^^B=\active
\catcode`\^^C=\active
\def^^A#1!{#1}
\let^^B^^A
\let^^C^^A
\AtBeginDocument{\input{pdfinfo}}
\addto@hook{\every@verbatim}{%
  \catcode`\^^A=\active
  \def^^A#1!{\Blue{#1}}%
  \def^^B#1!{\Green{#1}}%
  \def^^C#1!{\Red{#1}}%
}

\begingroup
  \count0=\time
  \divide\count0 by 60
  \edef\x{\ifnum\count0<10 0\fi\the\count0}
  \multiply\count0 by 60
  \count1=\time
  \advance\count1 by -\count0
  \edef\x{\x\ifnum\count1<10 0\fi\the\count1}
  \edef\x{/ModDate (D:\the\year
    \ifnum\month<10 0\fi\the\month
    \ifnum\day<10 0\fi\the\day
    \x
    00-01'00')}
\expandafter\endgroup
\expandafter\pdfinfo\expandafter{\x}

\def\@ReturnAfterFi#1\fi{\fi#1}


%%% Navigation
\newcommand{\NavFull}{\AcroButton{FullScreen}{Full-screen}}
\newcommand{\NavPrev}{\AcroButton{PrevPage}{Back}}
\newcommand{\NavBack}{\AcroButton{GoBack}{\textless\textless}}
\newcommand{\NavNext}{\AcroButton{NextPage}{Next}}
\newcommand{\NavBookmarks}{\AcroButton{ShowBookmarks}{Bookmarks}}
\newcommand{\NavThumbnails}{\AcroButton{ShowThumbs}{Thumbnails}}
\newcommand{\NavPage}{\AcroButton{PageOnly}{Page Only}}
\newcommand{\NavQuit}{\AcroButton{Quit}{Quit}}
\newcommand{\NavInfo}{\AcroButton{GeneralInfo}{%
  General document information}}
\newcommand{\NavStart}{\AcroButton{NextPage}{\small Start}}


%%% Bookmarks

\newcommand{\org@foilhead}{}
\let\org@foilhead\foilhead
\renewcommand*{\foilhead}[2][]{%
  \ifx\\#1\\%
    \expandafter\org@foilhead
  \else
    \@ReturnAfterFi{%
      \org@foilhead[#1]%
    }%
  \fi
  {\foilsection{#2}}%
}
\newcommand*{\subfoilhead}[2][]{%
  \ifx\\#1\\%
    \expandafter\org@foilhead
  \else
    \@ReturnAfterFi{%
      \org@foilhead[#1]%
    }%
  \fi
  {\subfoilsection{#2}}%
}
\newcommand*{\subsubfoilhead}[2][]{%
  \ifx\\#1\\%
    \expandafter\org@foilhead
  \else
    \@ReturnAfterFi{%
      \org@foilhead[#1]%
    }%
  \fi
  {\subsubfoilsection{#2}}%
}

\newcounter{foilsec}
\newcommand*{\foilsection}[1]{%
  \stepcounter{foilsec}%
  \pdfbookmark{#1}{foil\arabic{foilsec}}%
  #1%
}
\newcommand*{\subfoilsection}[1]{%
  \stepcounter{foilsec}%
  \pdfbookmark[1]{#1}{subfoil\arabic{foilsec}}%
  #1%
}
\newcommand*{\subsubfoilsection}[1]{%
  \stepcounter{foilsec}%
  \pdfbookmark[2]{#1}{subsubfoil\arabic{foilsec}}%
  #1%
}

\setcounter{tocdepth}{3}


%%%
%%% Verbatim stuff
%%%

% Um Befehle in die Verbatim-Umgebung hineinzubekommen, sind
% $ als Backslash, und () als {} definiert:

\newcommand{\@org@verbatim@start}{}
\let\@org@verbatim@start\verbatim@start
\renewcommand*{\verbatim@start}{%
  \catcode`\$=0
  \catcode`\(=1
  \catcode`\)=2
  \@org@verbatim@start
}%


\newcommand\orgbraceleft{}
\newcommand\orgbraceright{}
\let\orgbraceleft\{%
\let\orgbraceright\}%
\edef\{{\string{}
\edef\}{\string}}
\begingroup
  \catcode`|=0
  \catcode`\\=12
  |def|x{|endgroup
    |DeclareRobustCommand*|BS{\}%
  }
|x

\newcommand*{\cms}[1]{\texorpdfstring{\texttt{\BS#1}}{\textbackslash#1}}
\newcommand*{\Code}[1]{\texttt{#1}}

\newcommand*{\code}[1][]{%
  \begingroup
    \def\@Farbe{#1}%
    \@sanitize
    \catcode`\ =10
    \catcode`\{=12
    \catcode`\}=12
    \@code
}
\def\@code<#1>{%
    \ifx\@Farbe\@empty
    \else
      \@ReturnAfterFi{%
        \textcolor{\@Farbe}%
      }%
    \fi
    {\texttt{#1}}%
  \endgroup
  \ignorespaces
}


%%%
%%% Markup commands
%%%
\newcommand*{\Package}[1]{\texttt{#1}}
\newcommand*{\Program}[1]{\textsf{#1}}
\newcommand*{\File}[1]{\texttt{#1}}
\newcommand*{\Class}[1]{\texttt{#1}}
\newcommand*{\Option}[1]{\texttt{#1}}
\newcommand*{\Value}[1]{\texttt{#1}}
\AtBeginDocument{%
  \newcommand\link{}%
  \let\link\url
}

\newcommand*{\KeyCtrl}[1]{\textless\textsf{CTRL}\textgreater\textsf{--#1}}
\newcommand*{\MenuItem}[1]{\textsf{#1}}
\newcommand*{\MenuNext}{\ensuremath{\rightarrow}}
\newcommand*{\WindowTitle}[1]{``\textsf{#1}''}

\newcommand*{\pdfTeX}{pdf\TeX}
\newcommand*{\commentchar}{\texttt{\textsl{\%}}}

\newenvironment{smallpar}{\small}{\par}

\newcommand*{\file}[1]{\texorpdfstring{\texttt{#1}}{`#1'}}


%%%
%%% Abbreviations
%%%
\newcommand*{\abbrdef}[1]{\@namedef{abbr@#1}}
\newcommand*{\abbr}[1]{%
  \@ifundefined{abbr@#1}{%
    \@latex@error{Abbreviation '#1' undefined!}\@ehc
  }{%
    \@nameuse{abbr@#1}%
  }%
  {}% because of toc spaces
}
\catcode`\*=\active
\def*#1*{\abbr{#1}}
\input{abbr}
\catcode`\*=12

\endinput
