// generated by diplomat-tool
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * An ICU4X Units Converter object, capable of converting between two [`MeasureUnit`]s.
 *
 * You can create an instance of this object using [`UnitsConverterFactory`] by calling the `converter` method.
 *
 * See the [Rust documentation for `UnitsConverter`](https://docs.rs/icu/latest/icu/experimental/units/converter/struct.UnitsConverter.html) for more information.
 */
const UnitsConverter_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_UnitsConverter_destroy_mv1(ptr);
});

export class UnitsConverter {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("UnitsConverter is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            UnitsConverter_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Converts the input value from the input unit to the output unit (that have been used to create this converter).
     * NOTE:
     * The conversion using floating-point operations is not as accurate as the conversion using ratios.
     *
     * See the [Rust documentation for `convert`](https://docs.rs/icu/latest/icu/experimental/units/converter/struct.UnitsConverter.html#method.convert) for more information.
     */
    convertNumber(value) {

        const result = wasm.icu4x_UnitsConverter_convert_double_mv1(this.ffiValue, value);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Clones the current [`UnitsConverter`] object.
     *
     * See the [Rust documentation for `clone`](https://docs.rs/icu/latest/icu/experimental/units/converter/struct.UnitsConverter.html#method.clone) for more information.
     */
    clone() {

        const result = wasm.icu4x_UnitsConverter_clone_mv1(this.ffiValue);

        try {
            return new UnitsConverter(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    constructor(symbol, ptr, selfEdge) {
        return this.#internalConstructor(...arguments)
    }
}