.TH udev-hid-bpf "1" "" "udev-hid-bpf @VERSION@" "udev-hid-bpf Manual"
.SH NAME
udev\-hid\-bpf - loader tool for HID eBPF programs
.SH SYNOPSIS
.B udev\-hid\-bpf [\-\-help|\-\-version] \fI<command>\fR \fI[args]\fR
.SH DESCRIPTION
.PP
.B udev\-hid\-bpf
is a loader and general utility tool for HID eBPF programs.
Typically it is invoked by udev to load and unload HID eBPF programs
that match a given device but it provides commands to ease development
of new eBPF programs and install specific eBPF programs that are
not installed by default.
.SH OPTIONS
.TP
.B \-\-help
Print help and exit
.TP
.B \-\-verbose
Enable verbose output for the given command
.TP
.B \-\-version
Print version and exit
.SH COMMANDS
.TP
.B add [\-\-bpfdir \fI/path/to/directory\fB]\fR \fIdevice\fR [\fI/path/to/program.bpf.o\fR]
Load HID eBPF programs for a device. This command is typically invoked
from a udev rule on the "add" action.
.IP
If no eBPF program is provided, matching eBPF programs are obtained
from the udev properties set on that device.
.IP
If multiple devices and/or eBPF programs are provided, devices and eBPF
programs must be separated by a literal '-'. For example:
.B udev-hid-bpf add dev1 dev2 - 1.bpf.o 2.bpf.o
.IP
If eBPF programs are specified without a full path they are searched for
in the directory given by the \fB\-\-bpfdir\fR option (if any) and
the built-in directories \fI@BPF_LOOKUP_DIRS@\fR, in that order.
.IP
The device must be specified as a syspath.
.RS 8
.TP
.B --bpfdir
Prepend a directory to the list of directories to search
for eBPF programs.
.TP
.B --property KEY=VALUE
Provide an arbitrary NAME=VALUE pair to the BPF program.
This NAME=VALUE pair is treated as if it was a
property set on the device, taking precedence over
any udev property of the same name.
This option may be specified multiple times to
supply multiple properties. Empty properties must be
the empty string (NAME="")
.TP
.B --replace
Remove current BPF programs for the device first.
This is equivalent to running \fBudev\-hid\-bpf remove\fR with the
same device argument first.
.RE
.TP
.B remove \fIdevice\fR
Remove all HID eBPF programs for a given device. This command is typically
invoked from a udev rule on the "remove" action.
.IP
The device must be specified as a syspath.
.TP
.B list\-bpf\-programs [\-\-bpfdir \fI/path/to/directory\fR]
List available HID eBPF programs in the (built-in) default lookup
directories or the given directory.
.TP
.B list\-devices
List available HID devices.
.TP
.B inspect \fIpath/to/program.bpf.o\fR
Inspect the given eBPF program.
.TP
.B install [options] \fIpath/to/program.bpf.o\fR
Install the given eBPF program into \fI/etc/udev-hid-bpf\fR with
a corresponding udev rule in \fI/etc/udev/rules.d\fR. This command
should be used for testing a single eBPF program or where
a full install of udev\-hid\-bpf is not suitable.
.IP
The following options are available for the
.B \-\-install
command:
.RS 8
.TP
.B \-\-dry-run
Do everything except actually creating directories and installing target files
.TP
.B \-\-install-exe
Also install the
.B udev\-hid\-bpf
executable in \fI$prefix/bin\fR. If the executable already exists at that path
this option does nothing.
.TP
.B \-\-force
Overwrite existing files with the same name
.TP
.B \-\-prefix \fI/path/to/prefix\fR
Install into the given prefix. Defaults to the built-in prefix \fI@PREFIX@\fR.
.RE
.SH SEE ALSO
udev\-hid\-bpf's online documentation:
.LP
.I https://libevdev.pages.freedesktop.org/udev-hid-bpf/
