/*
 *
 * Copyright (c) 2016-2021 The Khronos Group Inc.
 * Copyright (c) 2016-2021 Valve Corporation
 * Copyright (c) 2016-2021 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Mark Young <marky@lunarg.com>
 * Author: Lenny Komow <lenny@lunarg.com>
 * Author: Charles Giessen <charles@lunarg.com>
 *
 */

// This code is used to enable generic instance extensions which use a physical device
// as the first parameter.  If the extension is already known by the loader, it will
// not use this code, but instead use the more direct route.  However, if it is
// unknown to the loader, it will use this code.  Technically, this is not trampoline
// code since we don't want to optimize it out.

#include <vulkan/vulkan.h>

#if defined(__GNUC__) && !defined(__clang__)
#pragma GCC optimize(3)  // force gcc to use tail-calls
#endif

// The asm declaration prevents name mangling which is necessary for macOS
#if defined(MODIFY_UNKNOWN_FUNCTION_DECLS)
#define ASM_NAME(name) __asm(name)
#else
#define ASM_NAME(name)
#endif

// Declarations for the trampoline
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp0(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp0");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp1(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp1");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp2(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp2");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp3(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp3");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp4(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp4");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp5(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp5");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp6(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp6");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp7(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp7");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp8(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp8");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp9(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp9");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp10(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp10");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp11(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp11");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp12(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp12");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp13(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp13");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp14(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp14");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp15(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp15");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp16(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp16");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp17(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp17");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp18(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp18");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp19(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp19");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp20(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp20");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp21(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp21");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp22(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp22");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp23(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp23");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp24(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp24");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp25(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp25");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp26(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp26");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp27(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp27");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp28(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp28");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp29(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp29");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp30(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp30");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp31(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp31");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp32(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp32");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp33(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp33");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp34(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp34");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp35(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp35");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp36(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp36");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp37(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp37");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp38(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp38");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp39(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp39");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp40(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp40");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp41(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp41");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp42(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp42");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp43(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp43");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp44(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp44");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp45(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp45");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp46(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp46");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp47(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp47");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp48(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp48");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp49(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp49");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp50(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp50");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp51(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp51");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp52(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp52");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp53(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp53");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp54(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp54");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp55(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp55");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp56(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp56");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp57(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp57");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp58(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp58");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp59(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp59");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp60(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp60");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp61(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp61");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp62(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp62");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp63(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp63");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp64(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp64");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp65(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp65");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp66(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp66");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp67(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp67");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp68(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp68");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp69(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp69");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp70(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp70");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp71(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp71");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp72(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp72");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp73(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp73");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp74(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp74");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp75(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp75");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp76(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp76");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp77(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp77");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp78(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp78");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp79(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp79");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp80(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp80");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp81(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp81");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp82(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp82");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp83(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp83");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp84(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp84");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp85(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp85");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp86(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp86");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp87(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp87");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp88(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp88");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp89(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp89");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp90(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp90");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp91(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp91");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp92(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp92");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp93(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp93");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp94(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp94");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp95(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp95");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp96(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp96");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp97(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp97");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp98(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp98");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp99(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp99");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp100(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp100");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp101(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp101");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp102(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp102");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp103(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp103");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp104(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp104");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp105(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp105");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp106(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp106");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp107(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp107");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp108(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp108");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp109(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp109");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp110(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp110");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp111(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp111");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp112(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp112");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp113(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp113");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp114(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp114");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp115(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp115");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp116(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp116");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp117(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp117");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp118(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp118");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp119(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp119");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp120(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp120");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp121(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp121");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp122(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp122");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp123(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp123");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp124(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp124");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp125(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp125");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp126(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp126");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp127(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp127");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp128(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp128");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp129(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp129");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp130(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp130");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp131(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp131");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp132(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp132");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp133(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp133");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp134(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp134");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp135(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp135");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp136(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp136");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp137(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp137");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp138(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp138");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp139(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp139");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp140(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp140");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp141(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp141");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp142(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp142");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp143(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp143");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp144(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp144");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp145(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp145");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp146(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp146");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp147(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp147");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp148(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp148");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp149(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp149");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp150(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp150");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp151(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp151");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp152(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp152");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp153(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp153");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp154(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp154");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp155(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp155");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp156(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp156");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp157(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp157");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp158(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp158");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp159(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp159");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp160(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp160");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp161(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp161");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp162(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp162");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp163(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp163");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp164(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp164");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp165(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp165");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp166(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp166");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp167(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp167");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp168(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp168");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp169(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp169");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp170(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp170");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp171(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp171");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp172(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp172");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp173(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp173");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp174(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp174");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp175(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp175");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp176(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp176");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp177(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp177");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp178(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp178");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp179(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp179");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp180(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp180");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp181(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp181");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp182(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp182");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp183(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp183");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp184(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp184");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp185(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp185");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp186(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp186");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp187(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp187");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp188(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp188");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp189(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp189");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp190(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp190");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp191(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp191");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp192(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp192");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp193(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp193");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp194(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp194");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp195(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp195");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp196(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp196");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp197(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp197");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp198(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp198");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp199(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp199");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp200(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp200");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp201(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp201");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp202(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp202");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp203(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp203");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp204(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp204");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp205(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp205");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp206(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp206");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp207(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp207");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp208(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp208");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp209(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp209");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp210(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp210");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp211(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp211");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp212(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp212");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp213(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp213");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp214(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp214");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp215(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp215");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp216(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp216");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp217(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp217");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp218(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp218");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp219(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp219");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp220(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp220");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp221(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp221");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp222(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp222");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp223(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp223");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp224(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp224");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp225(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp225");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp226(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp226");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp227(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp227");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp228(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp228");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp229(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp229");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp230(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp230");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp231(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp231");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp232(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp232");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp233(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp233");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp234(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp234");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp235(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp235");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp236(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp236");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp237(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp237");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp238(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp238");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp239(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp239");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp240(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp240");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp241(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp241");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp242(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp242");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp243(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp243");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp244(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp244");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp245(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp245");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp246(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp246");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp247(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp247");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp248(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp248");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTramp249(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTramp249");

// Disable clang-format for lists of macros
// clang-format off

VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin0(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin0");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin1(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin1");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin2(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin2");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin3(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin3");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin4(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin4");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin5(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin5");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin6(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin6");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin7(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin7");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin8(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin8");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin9(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin9");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin10(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin10");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin11(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin11");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin12(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin12");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin13(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin13");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin14(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin14");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin15(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin15");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin16(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin16");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin17(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin17");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin18(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin18");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin19(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin19");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin20(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin20");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin21(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin21");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin22(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin22");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin23(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin23");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin24(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin24");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin25(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin25");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin26(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin26");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin27(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin27");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin28(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin28");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin29(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin29");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin30(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin30");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin31(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin31");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin32(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin32");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin33(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin33");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin34(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin34");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin35(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin35");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin36(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin36");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin37(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin37");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin38(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin38");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin39(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin39");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin40(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin40");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin41(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin41");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin42(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin42");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin43(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin43");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin44(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin44");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin45(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin45");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin46(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin46");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin47(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin47");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin48(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin48");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin49(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin49");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin50(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin50");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin51(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin51");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin52(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin52");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin53(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin53");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin54(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin54");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin55(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin55");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin56(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin56");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin57(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin57");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin58(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin58");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin59(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin59");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin60(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin60");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin61(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin61");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin62(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin62");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin63(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin63");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin64(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin64");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin65(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin65");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin66(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin66");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin67(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin67");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin68(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin68");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin69(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin69");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin70(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin70");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin71(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin71");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin72(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin72");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin73(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin73");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin74(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin74");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin75(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin75");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin76(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin76");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin77(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin77");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin78(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin78");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin79(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin79");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin80(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin80");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin81(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin81");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin82(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin82");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin83(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin83");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin84(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin84");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin85(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin85");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin86(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin86");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin87(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin87");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin88(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin88");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin89(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin89");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin90(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin90");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin91(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin91");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin92(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin92");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin93(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin93");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin94(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin94");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin95(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin95");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin96(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin96");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin97(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin97");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin98(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin98");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin99(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin99");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin100(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin100");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin101(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin101");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin102(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin102");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin103(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin103");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin104(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin104");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin105(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin105");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin106(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin106");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin107(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin107");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin108(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin108");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin109(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin109");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin110(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin110");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin111(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin111");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin112(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin112");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin113(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin113");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin114(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin114");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin115(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin115");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin116(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin116");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin117(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin117");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin118(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin118");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin119(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin119");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin120(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin120");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin121(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin121");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin122(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin122");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin123(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin123");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin124(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin124");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin125(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin125");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin126(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin126");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin127(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin127");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin128(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin128");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin129(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin129");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin130(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin130");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin131(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin131");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin132(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin132");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin133(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin133");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin134(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin134");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin135(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin135");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin136(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin136");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin137(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin137");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin138(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin138");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin139(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin139");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin140(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin140");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin141(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin141");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin142(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin142");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin143(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin143");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin144(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin144");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin145(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin145");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin146(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin146");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin147(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin147");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin148(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin148");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin149(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin149");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin150(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin150");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin151(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin151");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin152(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin152");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin153(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin153");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin154(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin154");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin155(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin155");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin156(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin156");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin157(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin157");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin158(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin158");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin159(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin159");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin160(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin160");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin161(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin161");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin162(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin162");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin163(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin163");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin164(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin164");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin165(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin165");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin166(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin166");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin167(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin167");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin168(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin168");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin169(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin169");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin170(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin170");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin171(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin171");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin172(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin172");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin173(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin173");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin174(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin174");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin175(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin175");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin176(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin176");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin177(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin177");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin178(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin178");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin179(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin179");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin180(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin180");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin181(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin181");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin182(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin182");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin183(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin183");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin184(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin184");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin185(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin185");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin186(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin186");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin187(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin187");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin188(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin188");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin189(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin189");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin190(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin190");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin191(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin191");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin192(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin192");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin193(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin193");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin194(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin194");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin195(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin195");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin196(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin196");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin197(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin197");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin198(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin198");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin199(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin199");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin200(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin200");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin201(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin201");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin202(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin202");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin203(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin203");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin204(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin204");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin205(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin205");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin206(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin206");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin207(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin207");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin208(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin208");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin209(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin209");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin210(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin210");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin211(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin211");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin212(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin212");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin213(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin213");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin214(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin214");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin215(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin215");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin216(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin216");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin217(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin217");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin218(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin218");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin219(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin219");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin220(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin220");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin221(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin221");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin222(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin222");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin223(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin223");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin224(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin224");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin225(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin225");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin226(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin226");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin227(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin227");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin228(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin228");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin229(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin229");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin230(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin230");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin231(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin231");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin232(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin232");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin233(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin233");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin234(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin234");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin235(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin235");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin236(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin236");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin237(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin237");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin238(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin238");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin239(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin239");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin240(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin240");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin241(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin241");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin242(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin242");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin243(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin243");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin244(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin244");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin245(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin245");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin246(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin246");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin247(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin247");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin248(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin248");
VKAPI_ATTR void VKAPI_CALL vkPhysDevExtTermin249(VkPhysicalDevice) ASM_NAME("vkPhysDevExtTermin249");


void *loader_get_phys_dev_ext_tramp(uint32_t index) {
    switch (index) {
#define TRAMP_CASE_HANDLE(num) case num: return vkPhysDevExtTramp##num
        TRAMP_CASE_HANDLE(0);
        TRAMP_CASE_HANDLE(1);
        TRAMP_CASE_HANDLE(2);
        TRAMP_CASE_HANDLE(3);
        TRAMP_CASE_HANDLE(4);
        TRAMP_CASE_HANDLE(5);
        TRAMP_CASE_HANDLE(6);
        TRAMP_CASE_HANDLE(7);
        TRAMP_CASE_HANDLE(8);
        TRAMP_CASE_HANDLE(9);
        TRAMP_CASE_HANDLE(10);
        TRAMP_CASE_HANDLE(11);
        TRAMP_CASE_HANDLE(12);
        TRAMP_CASE_HANDLE(13);
        TRAMP_CASE_HANDLE(14);
        TRAMP_CASE_HANDLE(15);
        TRAMP_CASE_HANDLE(16);
        TRAMP_CASE_HANDLE(17);
        TRAMP_CASE_HANDLE(18);
        TRAMP_CASE_HANDLE(19);
        TRAMP_CASE_HANDLE(20);
        TRAMP_CASE_HANDLE(21);
        TRAMP_CASE_HANDLE(22);
        TRAMP_CASE_HANDLE(23);
        TRAMP_CASE_HANDLE(24);
        TRAMP_CASE_HANDLE(25);
        TRAMP_CASE_HANDLE(26);
        TRAMP_CASE_HANDLE(27);
        TRAMP_CASE_HANDLE(28);
        TRAMP_CASE_HANDLE(29);
        TRAMP_CASE_HANDLE(30);
        TRAMP_CASE_HANDLE(31);
        TRAMP_CASE_HANDLE(32);
        TRAMP_CASE_HANDLE(33);
        TRAMP_CASE_HANDLE(34);
        TRAMP_CASE_HANDLE(35);
        TRAMP_CASE_HANDLE(36);
        TRAMP_CASE_HANDLE(37);
        TRAMP_CASE_HANDLE(38);
        TRAMP_CASE_HANDLE(39);
        TRAMP_CASE_HANDLE(40);
        TRAMP_CASE_HANDLE(41);
        TRAMP_CASE_HANDLE(42);
        TRAMP_CASE_HANDLE(43);
        TRAMP_CASE_HANDLE(44);
        TRAMP_CASE_HANDLE(45);
        TRAMP_CASE_HANDLE(46);
        TRAMP_CASE_HANDLE(47);
        TRAMP_CASE_HANDLE(48);
        TRAMP_CASE_HANDLE(49);
        TRAMP_CASE_HANDLE(50);
        TRAMP_CASE_HANDLE(51);
        TRAMP_CASE_HANDLE(52);
        TRAMP_CASE_HANDLE(53);
        TRAMP_CASE_HANDLE(54);
        TRAMP_CASE_HANDLE(55);
        TRAMP_CASE_HANDLE(56);
        TRAMP_CASE_HANDLE(57);
        TRAMP_CASE_HANDLE(58);
        TRAMP_CASE_HANDLE(59);
        TRAMP_CASE_HANDLE(60);
        TRAMP_CASE_HANDLE(61);
        TRAMP_CASE_HANDLE(62);
        TRAMP_CASE_HANDLE(63);
        TRAMP_CASE_HANDLE(64);
        TRAMP_CASE_HANDLE(65);
        TRAMP_CASE_HANDLE(66);
        TRAMP_CASE_HANDLE(67);
        TRAMP_CASE_HANDLE(68);
        TRAMP_CASE_HANDLE(69);
        TRAMP_CASE_HANDLE(70);
        TRAMP_CASE_HANDLE(71);
        TRAMP_CASE_HANDLE(72);
        TRAMP_CASE_HANDLE(73);
        TRAMP_CASE_HANDLE(74);
        TRAMP_CASE_HANDLE(75);
        TRAMP_CASE_HANDLE(76);
        TRAMP_CASE_HANDLE(77);
        TRAMP_CASE_HANDLE(78);
        TRAMP_CASE_HANDLE(79);
        TRAMP_CASE_HANDLE(80);
        TRAMP_CASE_HANDLE(81);
        TRAMP_CASE_HANDLE(82);
        TRAMP_CASE_HANDLE(83);
        TRAMP_CASE_HANDLE(84);
        TRAMP_CASE_HANDLE(85);
        TRAMP_CASE_HANDLE(86);
        TRAMP_CASE_HANDLE(87);
        TRAMP_CASE_HANDLE(88);
        TRAMP_CASE_HANDLE(89);
        TRAMP_CASE_HANDLE(90);
        TRAMP_CASE_HANDLE(91);
        TRAMP_CASE_HANDLE(92);
        TRAMP_CASE_HANDLE(93);
        TRAMP_CASE_HANDLE(94);
        TRAMP_CASE_HANDLE(95);
        TRAMP_CASE_HANDLE(96);
        TRAMP_CASE_HANDLE(97);
        TRAMP_CASE_HANDLE(98);
        TRAMP_CASE_HANDLE(99);
        TRAMP_CASE_HANDLE(100);
        TRAMP_CASE_HANDLE(101);
        TRAMP_CASE_HANDLE(102);
        TRAMP_CASE_HANDLE(103);
        TRAMP_CASE_HANDLE(104);
        TRAMP_CASE_HANDLE(105);
        TRAMP_CASE_HANDLE(106);
        TRAMP_CASE_HANDLE(107);
        TRAMP_CASE_HANDLE(108);
        TRAMP_CASE_HANDLE(109);
        TRAMP_CASE_HANDLE(110);
        TRAMP_CASE_HANDLE(111);
        TRAMP_CASE_HANDLE(112);
        TRAMP_CASE_HANDLE(113);
        TRAMP_CASE_HANDLE(114);
        TRAMP_CASE_HANDLE(115);
        TRAMP_CASE_HANDLE(116);
        TRAMP_CASE_HANDLE(117);
        TRAMP_CASE_HANDLE(118);
        TRAMP_CASE_HANDLE(119);
        TRAMP_CASE_HANDLE(120);
        TRAMP_CASE_HANDLE(121);
        TRAMP_CASE_HANDLE(122);
        TRAMP_CASE_HANDLE(123);
        TRAMP_CASE_HANDLE(124);
        TRAMP_CASE_HANDLE(125);
        TRAMP_CASE_HANDLE(126);
        TRAMP_CASE_HANDLE(127);
        TRAMP_CASE_HANDLE(128);
        TRAMP_CASE_HANDLE(129);
        TRAMP_CASE_HANDLE(130);
        TRAMP_CASE_HANDLE(131);
        TRAMP_CASE_HANDLE(132);
        TRAMP_CASE_HANDLE(133);
        TRAMP_CASE_HANDLE(134);
        TRAMP_CASE_HANDLE(135);
        TRAMP_CASE_HANDLE(136);
        TRAMP_CASE_HANDLE(137);
        TRAMP_CASE_HANDLE(138);
        TRAMP_CASE_HANDLE(139);
        TRAMP_CASE_HANDLE(140);
        TRAMP_CASE_HANDLE(141);
        TRAMP_CASE_HANDLE(142);
        TRAMP_CASE_HANDLE(143);
        TRAMP_CASE_HANDLE(144);
        TRAMP_CASE_HANDLE(145);
        TRAMP_CASE_HANDLE(146);
        TRAMP_CASE_HANDLE(147);
        TRAMP_CASE_HANDLE(148);
        TRAMP_CASE_HANDLE(149);
        TRAMP_CASE_HANDLE(150);
        TRAMP_CASE_HANDLE(151);
        TRAMP_CASE_HANDLE(152);
        TRAMP_CASE_HANDLE(153);
        TRAMP_CASE_HANDLE(154);
        TRAMP_CASE_HANDLE(155);
        TRAMP_CASE_HANDLE(156);
        TRAMP_CASE_HANDLE(157);
        TRAMP_CASE_HANDLE(158);
        TRAMP_CASE_HANDLE(159);
        TRAMP_CASE_HANDLE(160);
        TRAMP_CASE_HANDLE(161);
        TRAMP_CASE_HANDLE(162);
        TRAMP_CASE_HANDLE(163);
        TRAMP_CASE_HANDLE(164);
        TRAMP_CASE_HANDLE(165);
        TRAMP_CASE_HANDLE(166);
        TRAMP_CASE_HANDLE(167);
        TRAMP_CASE_HANDLE(168);
        TRAMP_CASE_HANDLE(169);
        TRAMP_CASE_HANDLE(170);
        TRAMP_CASE_HANDLE(171);
        TRAMP_CASE_HANDLE(172);
        TRAMP_CASE_HANDLE(173);
        TRAMP_CASE_HANDLE(174);
        TRAMP_CASE_HANDLE(175);
        TRAMP_CASE_HANDLE(176);
        TRAMP_CASE_HANDLE(177);
        TRAMP_CASE_HANDLE(178);
        TRAMP_CASE_HANDLE(179);
        TRAMP_CASE_HANDLE(180);
        TRAMP_CASE_HANDLE(181);
        TRAMP_CASE_HANDLE(182);
        TRAMP_CASE_HANDLE(183);
        TRAMP_CASE_HANDLE(184);
        TRAMP_CASE_HANDLE(185);
        TRAMP_CASE_HANDLE(186);
        TRAMP_CASE_HANDLE(187);
        TRAMP_CASE_HANDLE(188);
        TRAMP_CASE_HANDLE(189);
        TRAMP_CASE_HANDLE(190);
        TRAMP_CASE_HANDLE(191);
        TRAMP_CASE_HANDLE(192);
        TRAMP_CASE_HANDLE(193);
        TRAMP_CASE_HANDLE(194);
        TRAMP_CASE_HANDLE(195);
        TRAMP_CASE_HANDLE(196);
        TRAMP_CASE_HANDLE(197);
        TRAMP_CASE_HANDLE(198);
        TRAMP_CASE_HANDLE(199);
        TRAMP_CASE_HANDLE(200);
        TRAMP_CASE_HANDLE(201);
        TRAMP_CASE_HANDLE(202);
        TRAMP_CASE_HANDLE(203);
        TRAMP_CASE_HANDLE(204);
        TRAMP_CASE_HANDLE(205);
        TRAMP_CASE_HANDLE(206);
        TRAMP_CASE_HANDLE(207);
        TRAMP_CASE_HANDLE(208);
        TRAMP_CASE_HANDLE(209);
        TRAMP_CASE_HANDLE(210);
        TRAMP_CASE_HANDLE(211);
        TRAMP_CASE_HANDLE(212);
        TRAMP_CASE_HANDLE(213);
        TRAMP_CASE_HANDLE(214);
        TRAMP_CASE_HANDLE(215);
        TRAMP_CASE_HANDLE(216);
        TRAMP_CASE_HANDLE(217);
        TRAMP_CASE_HANDLE(218);
        TRAMP_CASE_HANDLE(219);
        TRAMP_CASE_HANDLE(220);
        TRAMP_CASE_HANDLE(221);
        TRAMP_CASE_HANDLE(222);
        TRAMP_CASE_HANDLE(223);
        TRAMP_CASE_HANDLE(224);
        TRAMP_CASE_HANDLE(225);
        TRAMP_CASE_HANDLE(226);
        TRAMP_CASE_HANDLE(227);
        TRAMP_CASE_HANDLE(228);
        TRAMP_CASE_HANDLE(229);
        TRAMP_CASE_HANDLE(230);
        TRAMP_CASE_HANDLE(231);
        TRAMP_CASE_HANDLE(232);
        TRAMP_CASE_HANDLE(233);
        TRAMP_CASE_HANDLE(234);
        TRAMP_CASE_HANDLE(235);
        TRAMP_CASE_HANDLE(236);
        TRAMP_CASE_HANDLE(237);
        TRAMP_CASE_HANDLE(238);
        TRAMP_CASE_HANDLE(239);
        TRAMP_CASE_HANDLE(240);
        TRAMP_CASE_HANDLE(241);
        TRAMP_CASE_HANDLE(242);
        TRAMP_CASE_HANDLE(243);
        TRAMP_CASE_HANDLE(244);
        TRAMP_CASE_HANDLE(245);
        TRAMP_CASE_HANDLE(246);
        TRAMP_CASE_HANDLE(247);
        TRAMP_CASE_HANDLE(248);
        TRAMP_CASE_HANDLE(249);
    }
    return NULL;
}

void *loader_get_phys_dev_ext_termin(uint32_t index) {
    switch (index) {
#define TERM_CASE_HANDLE(num) case num: return vkPhysDevExtTermin##num
        TERM_CASE_HANDLE(0);
        TERM_CASE_HANDLE(1);
        TERM_CASE_HANDLE(2);
        TERM_CASE_HANDLE(3);
        TERM_CASE_HANDLE(4);
        TERM_CASE_HANDLE(5);
        TERM_CASE_HANDLE(6);
        TERM_CASE_HANDLE(7);
        TERM_CASE_HANDLE(8);
        TERM_CASE_HANDLE(9);
        TERM_CASE_HANDLE(10);
        TERM_CASE_HANDLE(11);
        TERM_CASE_HANDLE(12);
        TERM_CASE_HANDLE(13);
        TERM_CASE_HANDLE(14);
        TERM_CASE_HANDLE(15);
        TERM_CASE_HANDLE(16);
        TERM_CASE_HANDLE(17);
        TERM_CASE_HANDLE(18);
        TERM_CASE_HANDLE(19);
        TERM_CASE_HANDLE(20);
        TERM_CASE_HANDLE(21);
        TERM_CASE_HANDLE(22);
        TERM_CASE_HANDLE(23);
        TERM_CASE_HANDLE(24);
        TERM_CASE_HANDLE(25);
        TERM_CASE_HANDLE(26);
        TERM_CASE_HANDLE(27);
        TERM_CASE_HANDLE(28);
        TERM_CASE_HANDLE(29);
        TERM_CASE_HANDLE(30);
        TERM_CASE_HANDLE(31);
        TERM_CASE_HANDLE(32);
        TERM_CASE_HANDLE(33);
        TERM_CASE_HANDLE(34);
        TERM_CASE_HANDLE(35);
        TERM_CASE_HANDLE(36);
        TERM_CASE_HANDLE(37);
        TERM_CASE_HANDLE(38);
        TERM_CASE_HANDLE(39);
        TERM_CASE_HANDLE(40);
        TERM_CASE_HANDLE(41);
        TERM_CASE_HANDLE(42);
        TERM_CASE_HANDLE(43);
        TERM_CASE_HANDLE(44);
        TERM_CASE_HANDLE(45);
        TERM_CASE_HANDLE(46);
        TERM_CASE_HANDLE(47);
        TERM_CASE_HANDLE(48);
        TERM_CASE_HANDLE(49);
        TERM_CASE_HANDLE(50);
        TERM_CASE_HANDLE(51);
        TERM_CASE_HANDLE(52);
        TERM_CASE_HANDLE(53);
        TERM_CASE_HANDLE(54);
        TERM_CASE_HANDLE(55);
        TERM_CASE_HANDLE(56);
        TERM_CASE_HANDLE(57);
        TERM_CASE_HANDLE(58);
        TERM_CASE_HANDLE(59);
        TERM_CASE_HANDLE(60);
        TERM_CASE_HANDLE(61);
        TERM_CASE_HANDLE(62);
        TERM_CASE_HANDLE(63);
        TERM_CASE_HANDLE(64);
        TERM_CASE_HANDLE(65);
        TERM_CASE_HANDLE(66);
        TERM_CASE_HANDLE(67);
        TERM_CASE_HANDLE(68);
        TERM_CASE_HANDLE(69);
        TERM_CASE_HANDLE(70);
        TERM_CASE_HANDLE(71);
        TERM_CASE_HANDLE(72);
        TERM_CASE_HANDLE(73);
        TERM_CASE_HANDLE(74);
        TERM_CASE_HANDLE(75);
        TERM_CASE_HANDLE(76);
        TERM_CASE_HANDLE(77);
        TERM_CASE_HANDLE(78);
        TERM_CASE_HANDLE(79);
        TERM_CASE_HANDLE(80);
        TERM_CASE_HANDLE(81);
        TERM_CASE_HANDLE(82);
        TERM_CASE_HANDLE(83);
        TERM_CASE_HANDLE(84);
        TERM_CASE_HANDLE(85);
        TERM_CASE_HANDLE(86);
        TERM_CASE_HANDLE(87);
        TERM_CASE_HANDLE(88);
        TERM_CASE_HANDLE(89);
        TERM_CASE_HANDLE(90);
        TERM_CASE_HANDLE(91);
        TERM_CASE_HANDLE(92);
        TERM_CASE_HANDLE(93);
        TERM_CASE_HANDLE(94);
        TERM_CASE_HANDLE(95);
        TERM_CASE_HANDLE(96);
        TERM_CASE_HANDLE(97);
        TERM_CASE_HANDLE(98);
        TERM_CASE_HANDLE(99);
        TERM_CASE_HANDLE(100);
        TERM_CASE_HANDLE(101);
        TERM_CASE_HANDLE(102);
        TERM_CASE_HANDLE(103);
        TERM_CASE_HANDLE(104);
        TERM_CASE_HANDLE(105);
        TERM_CASE_HANDLE(106);
        TERM_CASE_HANDLE(107);
        TERM_CASE_HANDLE(108);
        TERM_CASE_HANDLE(109);
        TERM_CASE_HANDLE(110);
        TERM_CASE_HANDLE(111);
        TERM_CASE_HANDLE(112);
        TERM_CASE_HANDLE(113);
        TERM_CASE_HANDLE(114);
        TERM_CASE_HANDLE(115);
        TERM_CASE_HANDLE(116);
        TERM_CASE_HANDLE(117);
        TERM_CASE_HANDLE(118);
        TERM_CASE_HANDLE(119);
        TERM_CASE_HANDLE(120);
        TERM_CASE_HANDLE(121);
        TERM_CASE_HANDLE(122);
        TERM_CASE_HANDLE(123);
        TERM_CASE_HANDLE(124);
        TERM_CASE_HANDLE(125);
        TERM_CASE_HANDLE(126);
        TERM_CASE_HANDLE(127);
        TERM_CASE_HANDLE(128);
        TERM_CASE_HANDLE(129);
        TERM_CASE_HANDLE(130);
        TERM_CASE_HANDLE(131);
        TERM_CASE_HANDLE(132);
        TERM_CASE_HANDLE(133);
        TERM_CASE_HANDLE(134);
        TERM_CASE_HANDLE(135);
        TERM_CASE_HANDLE(136);
        TERM_CASE_HANDLE(137);
        TERM_CASE_HANDLE(138);
        TERM_CASE_HANDLE(139);
        TERM_CASE_HANDLE(140);
        TERM_CASE_HANDLE(141);
        TERM_CASE_HANDLE(142);
        TERM_CASE_HANDLE(143);
        TERM_CASE_HANDLE(144);
        TERM_CASE_HANDLE(145);
        TERM_CASE_HANDLE(146);
        TERM_CASE_HANDLE(147);
        TERM_CASE_HANDLE(148);
        TERM_CASE_HANDLE(149);
        TERM_CASE_HANDLE(150);
        TERM_CASE_HANDLE(151);
        TERM_CASE_HANDLE(152);
        TERM_CASE_HANDLE(153);
        TERM_CASE_HANDLE(154);
        TERM_CASE_HANDLE(155);
        TERM_CASE_HANDLE(156);
        TERM_CASE_HANDLE(157);
        TERM_CASE_HANDLE(158);
        TERM_CASE_HANDLE(159);
        TERM_CASE_HANDLE(160);
        TERM_CASE_HANDLE(161);
        TERM_CASE_HANDLE(162);
        TERM_CASE_HANDLE(163);
        TERM_CASE_HANDLE(164);
        TERM_CASE_HANDLE(165);
        TERM_CASE_HANDLE(166);
        TERM_CASE_HANDLE(167);
        TERM_CASE_HANDLE(168);
        TERM_CASE_HANDLE(169);
        TERM_CASE_HANDLE(170);
        TERM_CASE_HANDLE(171);
        TERM_CASE_HANDLE(172);
        TERM_CASE_HANDLE(173);
        TERM_CASE_HANDLE(174);
        TERM_CASE_HANDLE(175);
        TERM_CASE_HANDLE(176);
        TERM_CASE_HANDLE(177);
        TERM_CASE_HANDLE(178);
        TERM_CASE_HANDLE(179);
        TERM_CASE_HANDLE(180);
        TERM_CASE_HANDLE(181);
        TERM_CASE_HANDLE(182);
        TERM_CASE_HANDLE(183);
        TERM_CASE_HANDLE(184);
        TERM_CASE_HANDLE(185);
        TERM_CASE_HANDLE(186);
        TERM_CASE_HANDLE(187);
        TERM_CASE_HANDLE(188);
        TERM_CASE_HANDLE(189);
        TERM_CASE_HANDLE(190);
        TERM_CASE_HANDLE(191);
        TERM_CASE_HANDLE(192);
        TERM_CASE_HANDLE(193);
        TERM_CASE_HANDLE(194);
        TERM_CASE_HANDLE(195);
        TERM_CASE_HANDLE(196);
        TERM_CASE_HANDLE(197);
        TERM_CASE_HANDLE(198);
        TERM_CASE_HANDLE(199);
        TERM_CASE_HANDLE(200);
        TERM_CASE_HANDLE(201);
        TERM_CASE_HANDLE(202);
        TERM_CASE_HANDLE(203);
        TERM_CASE_HANDLE(204);
        TERM_CASE_HANDLE(205);
        TERM_CASE_HANDLE(206);
        TERM_CASE_HANDLE(207);
        TERM_CASE_HANDLE(208);
        TERM_CASE_HANDLE(209);
        TERM_CASE_HANDLE(210);
        TERM_CASE_HANDLE(211);
        TERM_CASE_HANDLE(212);
        TERM_CASE_HANDLE(213);
        TERM_CASE_HANDLE(214);
        TERM_CASE_HANDLE(215);
        TERM_CASE_HANDLE(216);
        TERM_CASE_HANDLE(217);
        TERM_CASE_HANDLE(218);
        TERM_CASE_HANDLE(219);
        TERM_CASE_HANDLE(220);
        TERM_CASE_HANDLE(221);
        TERM_CASE_HANDLE(222);
        TERM_CASE_HANDLE(223);
        TERM_CASE_HANDLE(224);
        TERM_CASE_HANDLE(225);
        TERM_CASE_HANDLE(226);
        TERM_CASE_HANDLE(227);
        TERM_CASE_HANDLE(228);
        TERM_CASE_HANDLE(229);
        TERM_CASE_HANDLE(230);
        TERM_CASE_HANDLE(231);
        TERM_CASE_HANDLE(232);
        TERM_CASE_HANDLE(233);
        TERM_CASE_HANDLE(234);
        TERM_CASE_HANDLE(235);
        TERM_CASE_HANDLE(236);
        TERM_CASE_HANDLE(237);
        TERM_CASE_HANDLE(238);
        TERM_CASE_HANDLE(239);
        TERM_CASE_HANDLE(240);
        TERM_CASE_HANDLE(241);
        TERM_CASE_HANDLE(242);
        TERM_CASE_HANDLE(243);
        TERM_CASE_HANDLE(244);
        TERM_CASE_HANDLE(245);
        TERM_CASE_HANDLE(246);
        TERM_CASE_HANDLE(247);
        TERM_CASE_HANDLE(248);
        TERM_CASE_HANDLE(249);
    }
    return NULL;
}
