# eXtended CHange Process STate

`xchpst` extends _runit_'s `chpst` tool with options for hardening runit-supervised services with Linux facilities including:

- namespaces
- capabilities
- read-only bind mounts
- isolated and transient areas of the filesystem hierarchy

`xchpst` is written from scratch and is backwards compatible with the `chpst` command line options.

The documentation effort for this tool is exclusively on the
[man page](https://gitlab.com/init-tools/xchpst/-/jobs/artifacts/master/file/xchpst.8.txt?job=build-job)
([source](xchpst.8)).

Issues and merge requests welcome on the [project page](https://gitlab.com/init-tools/xchpst).

Releases will take the form of git tags signed by my OpenPGP key[^pgp1] or those of any other co-maintainers that may arise.

The [CHANGELOG](CHANGELOG) represents the notable net differences between releases. Semantic versioning is employed.

Thanks for your interest - please send feedback!

-- Andrew Bower, 1 January 2025.

## Build dependencies

Conforms with C dialect C23 with some features avoided to allow compilation with gcc-12 on Debian bookworm.

* GNU make
* gcc-12 or later
* libcap-dev[^libcap]

[^pgp1]: RSA/4096 [`06AB 786E 936C 6C73 F6D8 130C 4510 3394 30FC 9F34`](https://sw.cdefg.uk/xchpst/xchpst-signing-keys.gpg).
[^libcap]: Optional: build with `NO_CAP=1` to omit capabilities support
