/******************************************************************************
* Copyright (C) 2021-2022 Xilinx, Inc. All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


/*****************************************************************************/
/**
* @file xaie_lite_regdef_aie.h
* @{
*
* This header file defines register offsets for lightweight version for AIE
* APIs.
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who     Date     Changes
* ----- ------  -------- -----------------------------------------------------
* 1.0   Nishad  08/30/2021  Initial creation
* </pre>
*
******************************************************************************/
#ifndef XAIE_LITE_REGDEF_AIE_H
#define XAIE_LITE_REGDEF_AIE_H

/***************************** Include Files *********************************/
#include "xaiegbl_params.h"

/************************** Constant Definitions *****************************/
#define XAIE_EVENT_MASK					0x7F

#define XAIE_NOC_MOD_INTR_L2_ENABLE			XAIEGBL_NOC_INTCON2NDLEVENA
#define XAIE_NOC_MOD_INTR_L2_DISABLE			XAIEGBL_NOC_INTCON2NDLEVDIS
#define XAIE_NOC_MOD_INTR_L2_MASK			XAIEGBL_NOC_INTCON2NDLEVMSK
#define XAIE_NOC_MOD_INTR_L2_STATUS			XAIEGBL_NOC_INTCON2NDLEVSTA
#define XAIE_NOC_MOD_INTR_L2_IRQ			XAIEGBL_NOC_INTCON2NDLEVINT

#define XAIE_PL_MOD_INTR_L1_SW_REGOFF			0x30U
#define XAIE_PL_MOD_INTR_L1_STATUS			XAIEGBL_PL_INTCON1STLEVSTAA
#define XAIE_PL_MOD_INTR_L1_IRQ_EVENTA			XAIEGBL_PL_INTCON1STLEVIRQEVTA

#define XAIE_PL_MOD_EVENT_GROUP_ERROR0			62
#define XAIE_PL_MOD_EVENT_BROADCAST0			107

#define XAIE_PL_MOD_BASE_EVENT_STATUS			XAIEGBL_PL_EVTSTA0
#define XAIE_PL_MOD_GROUP_ERROR0_ENABLE			XAIEGBL_PL_EVTGRPERRENA

#define XAIE_PL_MOD_COL_RST_REGOFF			XAIEGBL_PL_AIETILCOLRST
#define XAIE_PL_MOD_COL_RST_LSB				XAIEGBL_PL_AIETILCOLRST_RST_LSB
#define XAIE_PL_MOD_COL_RST_MASK			XAIEGBL_PL_AIETILCOLRST_RST_MASK

#define XAIE_PL_MOD_SHIM_RST_ENA_REGOFF			XAIEGBL_PL_AIESHIRSTENA
#define XAIE_PL_MOD_SHIM_RST_ENA_LSB			XAIEGBL_PL_AIESHIRSTENA_RST_LSB
#define XAIE_PL_MOD_SHIM_RST_ENA_MASK			XAIEGBL_PL_AIESHIRSTENA_RST_MASK

#define XAIE_PL_MOD_COL_CLKCNTR_REGOFF			XAIEGBL_PL_TILCLOCTRL
#define XAIE_PL_MOD_COL_CLKCNTR_CLKBUF_ENABLE_LSB	XAIEGBL_PL_TILCLOCTRL_CLOBUFENA_LSB
#define XAIE_PL_MOD_COL_CLKCNTR_CLKBUF_ENABLE_MASK	XAIEGBL_PL_TILCLOCTRL_CLOBUFENA_MASK

#define XAIE_PL_MOD_TILE_CNTR_REGOFF			XAIEGBL_PL_TILCTRL
#define XAIE_PL_MOD_TILE_CNTR_ISOLATE_EAST_LSB		XAIEGBL_PL_TILCTRL_ISOFROEAS_LSB
#define XAIE_PL_MOD_TILE_CNTR_ISOLATE_EAST_MASK		XAIEGBL_PL_TILCTRL_ISOFROEAS_MASK
#define XAIE_PL_MOD_TILE_CNTR_ISOLATE_NORTH_LSB		XAIEGBL_PL_TILCTRL_ISOFRONOR_LSB
#define XAIE_PL_MOD_TILE_CNTR_ISOLATE_NORTH_MASK	XAIEGBL_PL_TILCTRL_ISOFRONOR_MASK
#define XAIE_PL_MOD_TILE_CNTR_ISOLATE_WEST_LSB		XAIEGBL_PL_TILCTRL_ISOFROWES_LSB
#define XAIE_PL_MOD_TILE_CNTR_ISOLATE_WEST_MASK		XAIEGBL_PL_TILCTRL_ISOFROWES_MASK
#define XAIE_PL_MOD_TILE_CNTR_ISOLATE_SOUTH_LSB		XAIEGBL_PL_TILCTRL_ISOFROSOU_LSB
#define XAIE_PL_MOD_TILE_CNTR_ISOLATE_SOUTH_MASK	XAIEGBL_PL_TILCTRL_ISOFROSOU_MASK

#define XAIE_NOC_AXIMM_CONF_REGOFF			XAIEGBL_NOC_MEAXICFG
#define XAIE_NOC_AXIMM_CONF_SLVERR_BLOCK_LSB		XAIEGBL_NOC_MEAXICFG_SLVBLK_LSB
#define XAIE_NOC_AXIMM_CONF_SLVERR_BLOCK_MASK		XAIEGBL_NOC_MEAXICFG_SLVBLK_MASK
#define XAIE_NOC_AXIMM_CONF_DECERR_BLOCK_LSB		XAIEGBL_NOC_MEAXICFG_DECBLK_LSB
#define XAIE_NOC_AXIMM_CONF_DECERR_BLOCK_MASK		XAIEGBL_NOC_MEAXICFG_DECBLK_MASK

#define XAIE_CORE_MOD_EVENT_GROUP_ERROR0		48
#define XAIE_CORE_MOD_EVENT_BROADCAST0			107

#define XAIE_CORE_MOD_BASE_EVENT_STATUS			XAIEGBL_CORE_EVTSTA0
#define XAIE_CORE_MOD_BASE_EVENT_BROADCAST		XAIEGBL_CORE_EVTBRDCAST0
#define XAIE_CORE_MOD_GROUP_ERROR0_ENABLE		XAIEGBL_CORE_EVTGRPERR0ENA

#define XAIE_CORE_MOD_TILE_CNTR_REGOFF			XAIEGBL_CORE_TILCTRL
#define XAIE_CORE_MOD_TILE_CNTR_ISOLATE_EAST_LSB	XAIEGBL_CORE_TILCTRL_ISOFROEAS_LSB
#define XAIE_CORE_MOD_TILE_CNTR_ISOLATE_EAST_MASK	XAIEGBL_CORE_TILCTRL_ISOFROEAS_MASK
#define XAIE_CORE_MOD_TILE_CNTR_ISOLATE_NORTH_LSB	XAIEGBL_CORE_TILCTRL_ISOFRONOR_LSB
#define XAIE_CORE_MOD_TILE_CNTR_ISOLATE_NORTH_MASK	XAIEGBL_CORE_TILCTRL_ISOFRONOR_MASK
#define XAIE_CORE_MOD_TILE_CNTR_ISOLATE_WEST_LSB	XAIEGBL_CORE_TILCTRL_ISOFROWES_LSB
#define XAIE_CORE_MOD_TILE_CNTR_ISOLATE_WEST_MASK	XAIEGBL_CORE_TILCTRL_ISOFROWES_MASK
#define XAIE_CORE_MOD_TILE_CNTR_ISOLATE_SOUTH_LSB	XAIEGBL_CORE_TILCTRL_ISOFROSOU_LSB
#define XAIE_CORE_MOD_TILE_CNTR_ISOLATE_SOUTH_MASK	XAIEGBL_CORE_TILCTRL_ISOFROSOU_MASK

#define XAIE_CORE_MOD_PMEM_START_ADDR			XAIEGBL_CORE_PRGMEM
#define XAIE_CORE_MOD_PMEM_SIZE				(16U * 1024U)
#define XAIE_MEM_MOD_DMEM_START_ADDR			XAIEGBL_MEM_DATMEM
#define XAIE_MEM_MOD_DMEM_SIZE				(32U * 1024U)

#define XAIE_MEM_MOD_BASE_EVENT_STATUS			XAIEGBL_MEM_EVTSTA0
#define XAIE_MEM_MOD_BASE_EVENT_BROADCAST		XAIEGBL_MEM_EVTBRDCAST0
#define XAIE_MEM_MOD_GROUP_ERROR0_ENABLE		XAIEGBL_MEM_EVTGRPERRENA

#define XAIE_MEM_TILE_EVENT_GROUP_ERROR0		0
#define XAIE_MEM_TILE_EVENT_BROADCAST0			0

#define XAIE_MEM_MOD_EVENT_GROUP_ERROR0			87
#define XAIE_MEM_MOD_EVENT_BROADCAST0			107

#define XAIE_MEM_TILE_BASE_EVENT_BROADCAST		0
#define XAIE_MEM_TILE_GROUP_ERROR0_ENABLE		0

#define XAIE_MEM_TILE_BASE_EVENT_STATUS			0

/* Tile control isolation bits are the same across tiles */
#define XAIE_TILE_CNTR_ISOLATE_EAST_MASK		XAIE_CORE_MOD_TILE_CNTR_ISOLATE_EAST_MASK
#define XAIE_TILE_CNTR_ISOLATE_WEST_MASK		XAIE_CORE_MOD_TILE_CNTR_ISOLATE_WEST_MASK

/* DMA Status Registers */
#define XAIE_TILE_DMA_S2MM_CHANNEL_STATUS_REGOFF	XAIEGBL_MEM_DMAS2MMSTA
#define XAIE_TILE_DMA_S2MM_CHANNEL_STATUS_0_MASK	XAIEGBL_MEM_DMAS2MMSTA_STA0_MASK
#define XAIE_TILE_DMA_S2MM_CHANNEL_STATUS_1_MASK	XAIEGBL_MEM_DMAS2MMSTA_STA1_MASK
#define XAIE_TILE_DMA_MM2S_CHANNEL_STATUS_REGOFF	XAIEGBL_MEM_DMAMM2SSTA
#define XAIE_TILE_DMA_MM2S_CHANNEL_STATUS_0_MASK	XAIEGBL_MEM_DMAMM2SSTA_STA0_MASK
#define XAIE_TILE_DMA_MM2S_CHANNEL_STATUS_1_MASK	XAIEGBL_MEM_DMAMM2SSTA_STA1_MASK

#define XAIE_SHIM_DMA_S2MM_CHANNEL_STATUS_REGOFF	XAIEGBL_NOC_DMAS2MMSTA
#define XAIE_SHIM_DMA_S2MM_CHANNEL_STATUS_0_MASK	XAIEGBL_NOC_DMAS2MMSTA_STA0_MASK
#define XAIE_SHIM_DMA_S2MM_CHANNEL_STATUS_1_MASK	XAIEGBL_NOC_DMAS2MMSTA_STA1_MASK
#define XAIE_SHIM_DMA_MM2S_CHANNEL_STATUS_REGOFF	XAIEGBL_NOC_DMAMM2SSTA
#define XAIE_SHIM_DMA_MM2S_CHANNEL_STATUS_0_MASK	XAIEGBL_NOC_DMAMM2SSTA_STA0_MASK
#define XAIE_SHIM_DMA_MM2S_CHANNEL_STATUS_1_MASK	XAIEGBL_NOC_DMAMM2SSTA_STA1_MASK

/************************** Variable Definitions *****************************/
/************************** Function Prototypes  *****************************/

#endif		/* end of protection macro */

/** @} */
