import { BinaryView, Read, Write } from "@ot-builder/bin-util";
import { Data } from "@ot-builder/prelude";
import { ReadTimeIVS } from "@ot-builder/var-store";
import { CffDrawCallRaw } from "../char-string/write/draw-call";
import { CffReadContext } from "../context/read";
import { CffWriteContext } from "../context/write";
import * as CffInterp from "../interp/ir";
import { CffStackMachine } from "../interp/stack-machine";
import { DictEncoder } from "./encoder";
export type CffDictInterpreterFactory<T> = (viewDict: BinaryView, ctx: CffReadContext) => CffInterp.Interpreter & CffDictInterpreter<T>;
export interface CffDictInterpreter<T> {
    getResult(): T;
}
export declare abstract class CffDictInterpreterBase extends CffInterp.Interpreter {
    st: CffStackMachine;
    constructor(ivs?: Data.Maybe<ReadTimeIVS>);
    doOperand(x: number): void;
}
export declare function CffDictReadT<T>(interpFactory: CffDictInterpreterFactory<T>): Read<T, [ctx: CffReadContext, dictSize: number]>;
export declare abstract class CffDictDataCollector<T, A = void> {
    abstract collectDrawCalls(dict: T, ctx: CffWriteContext, rest: A): Iterable<CffDrawCallRaw>;
    abstract processPointers(encoder: DictEncoder, dict: T, ctx: CffWriteContext, rest: A): void;
}
export declare function CffDictWriteT<T, A = void>(collector: CffDictDataCollector<T, A>): Write<T, [ctx: CffWriteContext, rest: A]>;
//# sourceMappingURL=general.d.ts.map