"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AvarIo = void 0;
const errors_1 = require("@ot-builder/errors");
const ot_metadata_1 = require("@ot-builder/ot-metadata");
const primitive_1 = require("@ot-builder/primitive");
const AxisSegmentMapList = {
    read(view) {
        const positionMapCount = view.uint16();
        const asg = [];
        for (let pm = 0; pm < positionMapCount; pm += 1) {
            const fromCoordinate = view.next(primitive_1.F2D14);
            const toCoordinate = view.next(primitive_1.F2D14);
            asg.push([fromCoordinate, toCoordinate]);
        }
        return asg;
    },
    write(frag, asg) {
        errors_1.Assert.NoGap("AvarTable::SegmentMaps", asg);
        frag.uint16(asg.length);
        for (const [from, to] of asg) {
            frag.push(primitive_1.F2D14, from);
            frag.push(primitive_1.F2D14, to);
        }
    }
};
exports.AvarIo = {
    read(view, designSpace) {
        const majorVersion = view.uint16();
        const minorVersion = view.uint16();
        errors_1.Assert.SubVersionSupported("AvarTable", majorVersion, minorVersion, [1, 0]);
        const reserved = view.uint16();
        const axisCount = view.uint16();
        errors_1.Assert.SizeMatch("AvarTable::axisCount", axisCount, designSpace.length);
        const table = new ot_metadata_1.Avar.Table();
        for (let aid = 0; aid < axisCount; aid++) {
            const asg = view.next(AxisSegmentMapList);
            table.segmentMaps.set(designSpace.at(aid), asg);
        }
        return table;
    },
    write(frag, avar, designSpace) {
        frag.uint16(1) // majorVersion
            .uint16(0) // minorVersion
            .uint16(0); // reserved
        frag.uint16(designSpace.length);
        for (const dim of designSpace) {
            const asg = avar.segmentMaps.get(dim);
            if (asg) {
                frag.push(AxisSegmentMapList, asg);
            }
            else {
                throw errors_1.Errors.Avar.MissingMapping(dim.tag);
            }
        }
    }
};
//# sourceMappingURL=index.js.map