"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = exports.AxisValue = exports.NameAssignment = exports.NameFlags = exports.Axis = exports.Tag = void 0;
exports.Tag = `STAT`;
class Axis {
    constructor(tag, axisNameID, axisOrdering) {
        this.tag = tag;
        this.axisNameID = axisNameID;
        this.axisOrdering = axisOrdering;
    }
}
exports.Axis = Axis;
var NameFlags;
(function (NameFlags) {
    NameFlags[NameFlags["OlderSiblingFontAttribute"] = 1] = "OlderSiblingFontAttribute";
    NameFlags[NameFlags["ElidableAxisValueName"] = 2] = "ElidableAxisValueName";
})(NameFlags || (exports.NameFlags = NameFlags = {}));
class NameAssignment {
    constructor(flags, valueNameID) {
        this.flags = flags;
        this.valueNameID = valueNameID;
    }
}
exports.NameAssignment = NameAssignment;
var AxisValue;
(function (AxisValue) {
    class General {
    }
    AxisValue.General = General;
    class Static extends General {
        constructor(axis, value) {
            super();
            this.axis = axis;
            this.value = value;
        }
    }
    AxisValue.Static = Static;
    class Linked extends General {
        constructor(axis, value, linkedValue) {
            super();
            this.axis = axis;
            this.value = value;
            this.linkedValue = linkedValue;
        }
    }
    AxisValue.Linked = Linked;
    class Variable extends General {
        constructor(axis, min, nominal, max) {
            super();
            this.axis = axis;
            this.min = min;
            this.nominal = nominal;
            this.max = max;
        }
    }
    AxisValue.Variable = Variable;
    class PolyAxis extends General {
        constructor(assignments) {
            super();
            this.assignments = assignments;
        }
    }
    AxisValue.PolyAxis = PolyAxis;
})(AxisValue || (exports.AxisValue = AxisValue = {}));
class Table {
    constructor(designAxes = [], 
    // TODO: make a value-based map?
    assignments = [], elidedFallbackNameID = 0xffff) {
        this.designAxes = designAxes;
        this.assignments = assignments;
        this.elidedFallbackNameID = elidedFallbackNameID;
    }
}
exports.Table = Table;
//# sourceMappingURL=stat.js.map