"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.searchConfig = searchConfig;
const tslib_1 = require("tslib");
const fs = tslib_1.__importStar(require("fs-extra"));
const path = tslib_1.__importStar(require("path"));
async function searchConfig(args, fileNames) {
    let { cwd, rulePath } = args;
    if (rulePath) {
        rulePath = require.resolve(path.resolve(rulePath));
        if (!fs.pathExistsSync(rulePath)) {
            throw new Error(`Rule file ${rulePath} does not exist.`);
        }
        return {
            cwd: cwd || path.dirname(rulePath),
            rulePath,
        };
    }
    else {
        if (!cwd)
            cwd = process.cwd();
        cwd = path.resolve(cwd);
        do {
            for (const fn of fileNames) {
                if (fs.pathExistsSync(path.join(cwd, fn))) {
                    return {
                        cwd: cwd,
                        rulePath: path.join(cwd, fn),
                    };
                }
            }
            if (path.resolve(cwd, "..") === cwd)
                break;
            cwd = path.resolve(cwd, "..");
        } while (true);
    }
    throw new Error(`Rule file ${fileNames} does not exist.`);
}
