/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QObject>
#include <QDialog>

/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/PolChemDef.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "PolChemDefWnd.hpp"


namespace MsXpS
{
namespace MassXpert
{


class AbstractPolChemDefDependentDlg : public QDialog
{
  Q_OBJECT

  public:
  AbstractPolChemDefDependentDlg(libXpertMassCore::PolChemDefSPtr pol_chem_def_csp,
                                 PolChemDefWnd *pol_chem_def_wnd,
                                 const QString &config_settings_file_path,
                                 const QString &wnd_type_name,
                                 const QString &application_name,
                                 const QString &description);

  ~AbstractPolChemDefDependentDlg();

  virtual bool initialize() = 0;

  virtual void setModified();

  protected:
  libXpertMassCore::PolChemDefSPtr msp_polChemDef;
  PolChemDefWnd *mp_pol_chem_def_wnd_p;

  QString m_settings_file_path;

  // This string will be of the form "AtomDefDlg" for example, and will be
  // used to create named sections in the QSettings-based configsettings file.
  QString m_wndTypeName;

  QString m_applicationName;
  QString m_windowDescription;

  virtual void writeSettings();
  virtual void readSettings();

  virtual void displayWindowTitle();

  virtual void closeEvent(QCloseEvent *event);
};

} // namespace MassXpert

} // namespace MsXpS
