/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009,...,2026 by Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QDebug>
#include <QObject>
#include <QAction>
#include <QSettings>
#include <QMainWindow>

/////////////////////// pappsomspp includes

/////////////////////// libXpertMassCore includes

/////////////////////// Local includes
#include "../nongui/ConfigSettings.hpp"
#include "FileSystemHierarchyPreferencesWidget.hpp"


namespace Ui
{
class ApplicationPreferencesWnd;
class ApplicationPreferencesWndGeneralPageWidget;
class DecimalPlacesPreferencesWidget;
class MaxThreadCountPreferencesWidget;
} // namespace Ui

namespace MsXpS
{
namespace MassXpert
{


class ApplicationPreferencesWnd: public QMainWindow
{
  Q_OBJECT

  public:
  enum Pages
  {
    GENERAL = 0x0,
    SHORTCUTS,
    FILESYSTEM_HIERARCHY,
    COUNT
  };

  ApplicationPreferencesWnd(const QString &application_name,
                            const QString &description,
                            QWidget *parent_p = nullptr);

  virtual ~ApplicationPreferencesWnd();

  void writeSettings() const;
  void readSettings();

  void setupWindow();

  // The Application preferences General page
  void setupGeneralPage();
  void setupMaxThreadCountWidget();
  void writeDecimalPlacesPreferences();
  void readDecimalPlacesPreferences();
  void setupDecimalPlacesPreferencesWidget();

  // The Application preferences Shortcuts page
  void setupShortcutsPage();

  // The Filesystem hierarchy preferences page
  void setupFileSystemHierarchyPreferencesWidget();

  int insertSectionListItem(const QString &label,
                            const QIcon &icon,
                            QWidget *section_widget_p,
                            int index);
  bool showSectionListItem(int index);

  void debugWidgetBounds();

  public slots:
  void apply();

  protected:
  Ui::ApplicationPreferencesWnd *mp_ui;
  Ui::ApplicationPreferencesWndGeneralPageWidget *mp_generalPage_ui;
  Ui::DecimalPlacesPreferencesWidget *mp_decimalPlacesPreferencesWidget_ui;
  Ui::MaxThreadCountPreferencesWidget *mp_maxThreadCountPreferencesWidget_ui;

  FileSystemHierarchyPreferencesWidget *mp_fileSystemHierarchyPreferencesWidget;

  bool eventFilter(QObject *obj, QEvent *event);

  QString m_applicationName;
  QString m_windowDescription;

  void applyGeneralPage();
  void applyShortcutsPage();
  void applyFileSystemHierarchyPage();
};


} // namespace MassXpert
} // namespace MsXpS
