/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QDebug>
#include <QSvgRenderer>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/CrossLink.hpp>
#include <MsXpS/libXpertMassCore/Monomer.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "ChemEntVignette.hpp"


int ChemEntVignetteMetaTypeId =
  qRegisterMetaType<MsXpS::MassXpert::ChemEntVignette>(
    "MsXpS::MassXpert::ChemEntVignette");


namespace MsXpS
{
namespace MassXpert
{

ChemEntVignette::ChemEntVignette(QGraphicsSvgItem *parent)
  : QGraphicsSvgItem(parent)
{
}


ChemEntVignette::ChemEntVignette(const QString &file_path,
                                 QGraphicsSvgItem *parent)
  : QGraphicsSvgItem(file_path, parent)
{
}


ChemEntVignette::~ChemEntVignette()
{
}

void
ChemEntVignette::setName(const QString &name)
{
  m_name = name;
}


const QString &
ChemEntVignette::getName() const
{
  return m_name;
}

void
ChemEntVignette::setUuid(const QString &uuid)
{
  m_uuid = uuid;
}

QString
ChemEntVignette::getUuid() const
{
  return m_uuid;
}

void
ChemEntVignette::setChemicalEntity(
  libXpertMassCore::Enums::ChemicalEntity chemical_entity)
{
  m_chemicalEntity = chemical_entity;
}

libXpertMassCore::Enums::ChemicalEntity
ChemEntVignette::getChemicalEntity()
{
  return m_chemicalEntity;
}

void
ChemEntVignette::setSharedRenderer(QSvgRendererSPtr renderer_sp)
{
  msp_renderer = renderer_sp;
  QGraphicsSvgItem::setSharedRenderer(renderer_sp.get());
}

QSvgRendererSPtr
ChemEntVignette::getSharedRenderer()
{
  return msp_renderer;
}


} // namespace MassXpert
} // namespace MsXpS
