/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "ui_SequenceEditorFindDlg.h"
#include "AbstractSeqEdWndDependentDlg.hpp"


namespace MsXpS
{
namespace MassXpert
{


class SequenceEditorWnd;

class SequenceEditorFindDlg : public AbstractSeqEdWndDependentDlg
{
  Q_OBJECT

  public:
  SequenceEditorFindDlg(SequenceEditorWnd *editorWnd,
                        libXpertMassCore::PolymerQSPtr polymer_sp,
                        /* no libXpertMassCore::PolChemDef **/
                        const QString &configSettingsFilePath,
                        const QString &application_name,
                        const QString &description);

  ~SequenceEditorFindDlg();

  bool initialize();

  public slots:
  void find();
  void next();
  void motifComboBoxEditTextChanged(const QString &);
  void clearHistory();

  private:
  Ui::SequenceEditorFindDlg m_ui;

  std::size_t m_startSearchIndex;
  std::size_t m_endSearchIndex;

  bool m_reprocessMotif;

  libXpertMassCore::Sequence m_motif;

  QStringList m_history;

  void writeSettings();
  void readSettings();
};


} // namespace MassXpert
} // namespace MsXpS
