/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QTableView>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/Oligomer.hpp>
#include <MsXpS/libXpertMassCore/OligomerPair.hpp>
#include <MsXpS/libXpertMassCore/OligomerCollection.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "MzLabOutputOligomerTableView.hpp"
#include "MzLabWnd.hpp"


namespace MsXpS
{
namespace MassXpert
{


enum
{
  MZ_LAB_OUTPUT_OLIGO_1_MASS_COLUMN,
  MZ_LAB_OUTPUT_OLIGO_1_CHARGE_COLUMN,
  MZ_LAB_OUTPUT_OLIGO_2_MASS_COLUMN,
  MZ_LAB_OUTPUT_OLIGO_2_CHARGE_COLUMN,
  MZ_LAB_OUTPUT_OLIGO_ERROR_COLUMN,
  MZ_LAB_OUTPUT_OLIGO_MATCH_COLUMN,
  MZ_LAB_OUTPUT_OLIGO_TOTAL_COLUMNS,
};


class MzLabWnd;


class MzLabOutputOligomerTableViewModel : public QAbstractTableModel
{
  Q_OBJECT

  public:
  MzLabOutputOligomerTableViewModel(
    std::vector<libXpertMassCore::OligomerPairSPtr> *oligomer_pairs_p, QObject *);
  ~MzLabOutputOligomerTableViewModel();

  void setParentDlg(MzLabOutputOligomerTableViewDlg *);
  MzLabOutputOligomerTableViewDlg *parentDlg();

  void setMzLabWnd(MzLabWnd *);
  MzLabWnd *mzLabWnd();

  void setTableView(MzLabOutputOligomerTableView *);
  MzLabOutputOligomerTableView *tableView();

  int rowCount(const QModelIndex &parent = QModelIndex()) const;
  int columnCount(const QModelIndex &parent = QModelIndex()) const;

  QVariant headerData(int, Qt::Orientation, int role = Qt::DisplayRole) const;

  bool setData(const QModelIndex &, const QVariant &, int role = Qt::EditRole);

  QVariant data(const QModelIndex &parent = QModelIndex(),
                int role                  = Qt::DisplayRole) const;

  void addOligomerPair(libXpertMassCore::OligomerPairSPtr);

  protected:
  std::vector<libXpertMassCore::OligomerPairSPtr> *mp_oligomerPairs;

  MzLabOutputOligomerTableView *mp_tableView;

  MzLabWnd *mp_mzLabWnd;
  MzLabOutputOligomerTableViewDlg *mp_parentDlg;

  // Fixme: does not this belong to the dialog? Maybe a pointer to
  // the other one should be better.
  libXpertMassCore::Enums::MassType m_massType;
};


} // namespace MassXpert
} // namespace MsXpS
