/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QString>
#include <QList>
#include <QTextStream>
#include <QRegularExpression>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/Ionizer.hpp>

/////////////////////// libXpertMassGui includes


/////////////////////// Local includes


////////////////////////////// Qt includes


/*
 * Bitwise stuff (from StackOverflow)

 * It is sometimes worth using an enum to name the bits:

 * enum ThingFlags = {
 * ThingMask  = 0x0000,
 * ThingFlag0 = 1 << 0,
 * ThingFlag1 = 1 << 1,
 * ThingError = 1 << 8,
 * }

 * Then use the names later on. I.e. write

 * thingstate |= ThingFlag1;
 * thingstate &= ~ThingFlag0;
 * if (thing & ThingError) {...}

 * to set, clear and test. This way you hide the magic numbers from the rest of
 * your code.
 */

namespace MsXpS
{
namespace MassXpert
{


// Macro to fake qFatal() << streaming in Qt 6.4
#if QT_VERSION < QT_VERSION_CHECK(6, 8, 0) // If Qt < 6.8
#define qFatalStream()                             \
  for(QString fatalMsg; fatalMsg.isEmpty();        \
      qFatal("%s", fatalMsg.toUtf8().constData())) \
  QDebug(&fatalMsg).noquote().nospace()
#else
#define qFatalStream() qFatal()
#endif


//! Type of user that makes use of resources.
/*!
 * When looking for resources, this enum variables allow defining if the
 * resources are to be searched in system directories or in the user $HOME
 * directory (or BOTH).
 */
enum class UserType
{
  USER   = 1 << 0, //!< User is a logon user
  SYSTEM = 1 << 1, //!< User is the system
  BOTH   = USER | SYSTEM
};


enum class ContainerItemAddMode
{
  PREPEND,
  APPEND,
};


extern QChar gConfigKeyStringPrefixDelimiter;


enum class MassSpectrumSynthesisActions
{
  LOAD_ISOTOPIC_DATA = 0,
  CONFIGURE_MASS_PEAK_SHAPER,
  SYNTHESIZE_MASS_SPECTRA,
  COPY_MASS_SPECTRUM_TO_CLIPBOARD,
  SAVE_MASS_SPECTRUM_TO_FILE
};


struct Ion
{
  double mono     = 0.0;
  double avg      = 0.0;
  QString formula = "";
  libXpertMassCore::IonizerSPtr ionizer_sp;
};

typedef std::shared_ptr<Ion> IonSPtr;


} // namespace MassXpert
} // namespace MsXpS
