/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2019 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QDebug>
#include <QStyleOptionSlider>
#include <QMouseEvent>

/////////////////////// pappsomspp includes


/////////////////////// libXpertMassGui includes
#include "MsXpS/libXpertMassCore/globals.hpp"


/////////////////////// Local includes
#include "VerticalRuleSlider.hpp"

namespace MsXpS
{
namespace MineXpert
{


VerticalRuleSlider::VerticalRuleSlider(QWidget *parent_p): QSlider(parent_p)
{
  setOrientation(Qt::Horizontal);

  mp_xPosLabel = new QLabel(this);
  mp_xPosLabel->setAlignment(Qt::AlignCenter);
  mp_xPosLabel->setStyleSheet(
    "QLabel {"
    "  background-color: rgba(255, 255, 255, 220);"
    "  border: 1px solid #666;"
    "  border-radius: 3px;"
    "  padding: 2px 6px;"
    "  font: bold 9px;"
    "}");
  mp_xPosLabel->setVisible(false);
}

VerticalRuleSlider::~VerticalRuleSlider()
{
}

void
VerticalRuleSlider::updatePosLabelXaxisValue(double x)
{
  // We may call this function manually from BasePlotWnd, with -1
  // as argument, in which case we use the last value updated.
  // This occurs when the lockXRangeToggle() and lockYMarkerToggle()
  // are called.
  if(x != -1)
    m_lastXaxisValue = x;

  mp_xPosLabel->setText(
    QString::number(m_lastXaxisValue, 'f', libXpertMassCore::MZ_DEC_PLACES));
  mp_xPosLabel->adjustSize();
  setXposLabelVisible(true);

  // int labelWidth  = mp_xPosLabel->width();
  int labelHeight = mp_xPosLabel->height();

  // qDebug() << "labelWidth:" << labelWidth << "labelHeight:" << labelHeight;

  QPoint label_pos = m_sliderHandleRect.center();

  label_pos.rx() = m_sliderHandleRect.right();
  label_pos.ry() = m_sliderHandleRect.center().y() - (labelHeight / 2);

  mp_xPosLabel->move(label_pos);
}

void
VerticalRuleSlider::setXposLabelVisible(bool visible)
{
  mp_xPosLabel->setVisible(visible);
}

void
VerticalRuleSlider::mouseMoveEvent(QMouseEvent *event)
{
  QSlider::mouseMoveEvent(event);

  QStyleOptionSlider opt;
  initStyleOption(&opt);

  m_sliderHandleRect = style()->subControlRect(
    QStyle::CC_Slider, &opt, QStyle::SC_SliderHandle, this);

  updatePosLabelXaxisValue(m_sliderHandleRect.center().x());

  // qDebug() << qSetRealNumberPrecision(5)
  //          << "In the slider, handle rect left:" << m_sliderHandleRect.left()
  //          << "center:" << m_sliderHandleRect.center().x();

  emit sliderHandleCenterPositionXChangedSignal(
    m_sliderHandleRect.center().x());
}

} // namespace MineXpert
} // namespace MsXpS
