from typing import List

from typing import overload
import mrpt.pymrpt.mrpt.system

class CConfigFile(CConfigFileBase):
    @overload
    def __init__(self, fileName: str) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CConfigFile) -> None: ...
    @overload
    def __init__(self, arg0: CConfigFile) -> None: ...
    def assign(self) -> CConfigFile: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def discardSavingChanges(self) -> None: ...
    @overload
    def discardSavingChanges() -> void: ...
    @overload
    def getAllKeys(self, section: str, keys: List[str]) -> None: ...
    @overload
    def getAllKeys(conststd, classstd) -> void: ...
    @overload
    def getAllSections(self, sections: List[str]) -> None: ...
    @overload
    def getAllSections(classstd) -> void: ...
    def getAssociatedFile(self) -> str: ...
    @overload
    def setFileName(self, fil_path: str) -> None: ...
    @overload
    def setFileName(conststd) -> void: ...
    @overload
    def writeNow(self) -> None: ...
    @overload
    def writeNow() -> void: ...

class CConfigFileBase:
    @overload
    def __init__(self, arg0: CConfigFileBase) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> CConfigFileBase: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def getAllKeys(self, section: str, keys: List[str]) -> None: ...
    @overload
    def getAllKeys(conststd, classstd) -> void: ...
    @overload
    def getAllSections(self, sections: List[str]) -> None: ...
    @overload
    def getAllSections(classstd) -> void: ...
    def getContentAsYAML(self) -> str: ...
    def keyExists(self, section: str, key: str) -> bool: ...
    def keys(self, section: str) -> List[str]: ...
    @overload
    def read_bool(self, section: str, name: str, defaultValue: bool) -> bool: ...
    @overload
    def read_bool(self, section: str, name: str, defaultValue: bool, failIfNotFound: bool) -> bool: ...
    @overload
    def read_double(self, section: str, name: str, defaultValue: float) -> float: ...
    @overload
    def read_double(self, section: str, name: str, defaultValue: float, failIfNotFound: bool) -> float: ...
    @overload
    def read_enum(self, section: str, name: str, defaultValue: mrpt.pymrpt.mrpt.system.VerbosityLevel) -> mrpt.pymrpt.mrpt.system.VerbosityLevel: ...
    @overload
    def read_enum(self, section: str, name: str, defaultValue: mrpt.pymrpt.mrpt.system.VerbosityLevel, failIfNotFound: bool) -> mrpt.pymrpt.mrpt.system.VerbosityLevel: ...
    @overload
    def read_float(self, section: str, name: str, defaultValue: float) -> float: ...
    @overload
    def read_float(self, section: str, name: str, defaultValue: float, failIfNotFound: bool) -> float: ...
    @overload
    def read_int(self, section: str, name: str, defaultValue: int) -> int: ...
    @overload
    def read_int(self, section: str, name: str, defaultValue: int, failIfNotFound: bool) -> int: ...
    @overload
    def read_string(self, section: str, name: str, defaultValue: str) -> str: ...
    @overload
    def read_string(self, section: str, name: str, defaultValue: str, failIfNotFound: bool) -> str: ...
    @overload
    def read_string_first_word(self, section: str, name: str, defaultValue: str) -> str: ...
    @overload
    def read_string_first_word(self, section: str, name: str, defaultValue: str, failIfNotFound: bool) -> str: ...
    @overload
    def read_uint64_t(self, section: str, name: str, defaultValue: int) -> int: ...
    @overload
    def read_uint64_t(self, section: str, name: str, defaultValue: int, failIfNotFound: bool) -> int: ...
    @overload
    def sectionExists(self, section_name: str) -> bool: ...
    @overload
    def sectionExists(conststd) -> bool: ...
    def sections(self) -> List[str]: ...
    @overload
    def setContentFromYAML(self, yaml_block: str) -> None: ...
    @overload
    def setContentFromYAML(conststd) -> void: ...
    @overload
    def write(self, section: str, name: str, value: float) -> None: ...
    @overload
    def write(self, section: str, name: str, value: float, name_padding_width: int) -> None: ...
    @overload
    def write(self, section: str, name: str, value: float, name_padding_width: int, value_padding_width: int) -> None: ...
    @overload
    def write(self, section: str, name: str, value: float, name_padding_width: int, value_padding_width: int, comment: str) -> None: ...
    @overload
    def write(self, section: str, name: str, value: float) -> None: ...
    @overload
    def write(self, section: str, name: str, value: float, name_padding_width: int) -> None: ...
    @overload
    def write(self, section: str, name: str, value: float, name_padding_width: int, value_padding_width: int) -> None: ...
    @overload
    def write(self, section: str, name: str, value: float, name_padding_width: int, value_padding_width: int, comment: str) -> None: ...

class CConfigFileMemory(CConfigFileBase):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, stringList: List[str]) -> None: ...
    @overload
    def __init__(self, str: str) -> None: ...
    @overload
    def __init__(self, arg0: CConfigFileMemory) -> None: ...
    @overload
    def __init__(self, arg0: CConfigFileMemory) -> None: ...
    def assign(self) -> CConfigFileMemory: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def getAllKeys(self, section: str, keys: List[str]) -> None: ...
    @overload
    def getAllKeys(conststd, classstd) -> void: ...
    @overload
    def getAllSections(self, sections: List[str]) -> None: ...
    @overload
    def getAllSections(classstd) -> void: ...
    @overload
    def getContent(self, str: str) -> None: ...
    @overload
    def getContent(std) -> void: ...
    @overload
    def getContent(self) -> str: ...
    @overload
    def setContent(self, stringList: List[str]) -> None: ...
    @overload
    def setContent(constclassstd) -> void: ...
    @overload
    def setContent(self, str: str) -> None: ...
    @overload
    def setContent(conststd) -> void: ...

class CConfigFilePrefixer(CConfigFileBase):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, o: CConfigFileBase, prefix_sections: str, prefix_keys: str) -> None: ...
    @overload
    def __init__(self, arg0: CConfigFilePrefixer) -> None: ...
    @overload
    def __init__(self, arg0: CConfigFilePrefixer) -> None: ...
    def assign(self) -> CConfigFilePrefixer: ...
    @overload
    def bind(self, o: CConfigFileBase) -> None: ...
    @overload
    def bind(constclassmrpt) -> void: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def getAllKeys(self, section: str, keys: List[str]) -> None: ...
    @overload
    def getAllKeys(conststd, classstd) -> void: ...
    @overload
    def getAllSections(self, sections: List[str]) -> None: ...
    @overload
    def getAllSections(classstd) -> void: ...
    def getBoundConfigFileBase(self) -> CConfigFileBase: ...
    def getKeyPrefix(self) -> str: ...
    def getSectionPrefix(self) -> str: ...
    def setPrefixes(self, prefix_sections: str, prefix_keys: str) -> None: ...

class CLoadableOptions:
    @overload
    def __init__(self, arg0: CLoadableOptions) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> CLoadableOptions: ...
    @overload
    def dumpToConsole(self) -> None: ...
    @overload
    def dumpToConsole() -> void: ...
    @overload
    def loadFromConfigFile(self, source, section: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    def loadFromConfigFileName(self, config_file: str, section: str) -> None: ...
    @overload
    def saveToConfigFile(self, target, section: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...
    def saveToConfigFileName(self, config_file: str, section: str) -> None: ...

@overload
def MRPT_SAVE_NAME_PADDING() -> int: ...
@overload
def MRPT_SAVE_NAME_PADDING() -> int: ...
@overload
def MRPT_SAVE_VALUE_PADDING() -> int: ...
@overload
def MRPT_SAVE_VALUE_PADDING() -> int: ...
def config_parser(input: str) -> str: ...
