#include <odyssey.h>

#include <machinarium/machinarium.h>

#include <setproctitle.h>
#include <util.h>

od_retcode_t od_setproctitlef(char **argv_ptr, int argv_len, char *fmt, ...)
{
	char title[OD_MAX_PROC_TITLE_LEN];
	va_list args;
	va_start(args, fmt);
	size_t title_len = od_vsnprintf(title, sizeof(title), fmt, args);
	va_end(args);

	/* dirty hack */
	title[title_len] = '\0';

	/* clean up previous string */
	memset(*argv_ptr, 0, argv_len);

	memcpy(*argv_ptr, title, title_len + 1);
	return OK_RESPONSE;
}
