%feature("docstring") OT::ExponentiallyDampedCosineModel
R"RAW(Exponentially damped cosine covariance function.

Available constructors:
    ExponentiallyDampedCosineModel(*spatialDim=1*)

    ExponentiallyDampedCosineModel(*scale, amplitude, f*)

Parameters
----------
spatialDim : int
    Spatial dimension :math:`n`.
    By default, equal to 1.
scale : sequence of floats
    Scale coefficient :math:`\vect{\theta}\in \Rset^n`.
    The size of :math:`\vect{\theta}` is the input dimension.
amplitude : sequence of positive floats
    Amplitude of the process :math:`\vect{\sigma} \in \Rset^d`.
    Must be of size equal to 1.
    By default, equal to :math:`[1]`.
f : positive float
    Frequency parameter.

Notes
-----
The *exponentially damped cosine* function is a stationary covariance function with dimension :math:`d=1`.

We consider the scalar stochastic process :math:`X: \Omega \times\cD \mapsto \Rset`, where :math:`\omega \in \Omega` is an event, :math:`\cD` is a domain of :math:`\Rset^n`.

The  *exponentially damped cosine* covariance function is defined by:

.. math::

    C(\vect{s}, \vect{t}) = \sigma^2 e^{\left(-\left\|\dfrac{\vect{s}-\vect{t}}{\vect{\theta}}\right\|_2\right)} \cos\left(2 \pi f \left\|\dfrac{\vect{s}-\vect{t}}{\vect{\theta}}\right\|_2 \right), \quad \forall (\vect{s}, \vect{t}) \in \cD

The correlation function :math:`\rho` writes:

.. math::

    \rho(\vect{s}, \vect{t}) = e^{\left(-\left\| \vect{s}- \vect{t}\right\|_2\right)} \cos\left(2 \pi f \left\| \vect{s}-\vect{t} \right\|_2 \right), \quad \forall (\vect{s}, \vect{t}) \in \cD




See Also
--------
CovarianceModel

Examples
--------
Create a standard exponentially damped cosine covariance function:

>>> import openturns as ot
>>> covModel = ot.ExponentiallyDampedCosineModel(2)
>>> t = [0.1, 0.3]
>>> s = [0.5, 0.4]
>>> print(covModel(s, t))
[[ -0.564137 ]]
>>> tau = [0.1, 0.1]
>>> print(covModel(tau))
[[ 0.547367 ]]

Create a exponentially damped cosine  covariance function specifying the amplitude and the scale:

>>> covModel2 = ot.ExponentiallyDampedCosineModel([3.3], [1.2], 5.0)

Create a  exponentially damped cosine  covariance function specifying the amplitude and the scale:

>>> covModel3 = ot.ExponentiallyDampedCosineModel([1.5, 2.5], [3.5], 5.0)
)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::ExponentiallyDampedCosineModel::setFrequency
"Frequency accessor.

Parameters
----------
f : positive float
    Frequency parameter."

// ---------------------------------------------------------------------

%feature("docstring") OT::ExponentiallyDampedCosineModel::getFrequency
"Frequency accessor.

Returns
-------
f : positive float
    Frequency parameter."
