# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appconfiguration import AppConfigurationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAppConfigurationManagementKeyValuesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AppConfigurationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_key_values_get(self, resource_group):
        response = self.client.key_values.get(
            resource_group_name=resource_group.name,
            config_store_name="str",
            key_value_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_key_values_create_or_update(self, resource_group):
        response = self.client.key_values.create_or_update(
            resource_group_name=resource_group.name,
            config_store_name="str",
            key_value_name="str",
            key_value_parameters={
                "id": "str",
                "name": "str",
                "properties": {
                    "contentType": "str",
                    "eTag": "str",
                    "key": "str",
                    "label": "str",
                    "lastModified": "2020-02-20 00:00:00",
                    "locked": bool,
                    "tags": {"str": "str"},
                    "value": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_key_values_begin_delete(self, resource_group):
        response = self.client.key_values.begin_delete(
            resource_group_name=resource_group.name,
            config_store_name="str",
            key_value_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
