% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/footnote.R
\name{footnote}
\alias{footnote}
\title{Add footnotes to flextable}
\usage{
footnote(
  x,
  i = NULL,
  j = NULL,
  value,
  ref_symbols = NULL,
  part = "body",
  inline = FALSE,
  sep = "; ",
  symbol_sep = ""
)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{value}{a call to function \code{\link[=as_paragraph]{as_paragraph()}}.}

\item{ref_symbols}{character value, symbols to append that will be used
as references to notes.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' is not allowed by the function.}

\item{inline}{whether to add footnote on same line as previous footnote or not}

\item{sep}{used only when inline = TRUE, character string to use as
a separator between footnotes.}

\item{symbol_sep}{separator to insert between multiple
footnote symbols in the same cell (e.g. \code{","} to
produce \verb{1,2} instead of \code{12}). Default is \code{""}
(no separator, backward compatible).}
}
\description{
The function let add footnotes to a flextable object
by adding some symbols in the flextable and associated notes in
the footer of the flextable.

Symbols are added to the cells designated by the selection \code{i}
and \code{j}. If you use i = c(1,3) and j = c(2,5), then you will
add the symbols (or the repeated symbol) to cells \verb{[1,2]}
and \verb{[3,5]}.

\if{html}{\out{
<img src="https://www.ardata.fr/img/flextable-imgs/flextable-016.png" alt="add_footer illustration" style="width:100\%;">

See https://www.ardata.fr/en/flextable-gallery/2022-06-23-separate-headers/ for the example
shown
}}
}
\examples{
ft_1 <- flextable(head(iris))
ft_1 <- footnote(ft_1,
  i = 1, j = 1:3,
  value = as_paragraph(
    c(
      "This is footnote one",
      "This is footnote two",
      "This is footnote three"
    )
  ),
  ref_symbols = c("a", "b", "c"),
  part = "header"
)
ft_1 <- valign(ft_1, valign = "bottom", part = "header")
ft_1 <- autofit(ft_1)

ft_2 <- flextable(head(iris))
ft_2 <- autofit(ft_2)
ft_2 <- footnote(ft_2,
  i = 1, j = 1:2,
  value = as_paragraph(
    c(
      "This is footnote one",
      "This is footnote two"
    )
  ),
  ref_symbols = c("a", "b"),
  part = "header", inline = TRUE
)
ft_2 <- footnote(ft_2,
  i = 1, j = 3:4,
  value = as_paragraph(
    c(
      "This is footnote three",
      "This is footnote four"
    )
  ),
  ref_symbols = c("c", "d"),
  part = "header", inline = TRUE
)
ft_2

ft_3 <- flextable(head(iris))
ft_3 <- autofit(ft_3)
ft_3 <- footnote(
  x = ft_3, i = 1:3, j = 1:3,
  ref_symbols = "a",
  value = as_paragraph("This is footnote one")
)
ft_3
}
