---
layout: post
title: Polyglot 1.7.0 and page_id front-matter for different permalinks by language
lang: en
---

I'm excited to announce Jekyll-Polyglot 1.7.0, which has a new feature to give pages language specific permalinks and to retain their association to other relative pages.

This new feature is provided by **[antoniovazquezblanco](https://github.com/antoniovazquezblanco)**, who is a gentleman and a scholar.

## use `page_id` frontmatter to associate pages with different permalinks

Polyglot associates pages by matching their permalinks or filenames.
However some site translations may instead desire pages with unique permalinks.

Polyglot already coordinates multiple copes of the same document across different languages. So keying off of a different property like `page_id` is no different than keying off of the permalink.

Using a `page_id` to coordinate similar pages with different permalinks ensures that custom permalinks can still be seen on language specific sites.

### redirects for unique permalinks

The challenge with unique permalinks comes with relativizing those urls. Polyglot avoids this problem entirely by suggesting consistent permalinks.

To help with this, polyglot sets `redirect_from` hidden frontmatter on these pages, listing the unique permalinks of corresponding pages.

When using the `jekyll-redirect-from` plugin, that frontmatter will be picked up, and intelligent redirects made to the page's custom permalink.

To see this in action, visit [this page with a long permalink in different languages](/a-really-long/permalink/).

## Other bug fixes

* This release should have a fix for [#151](https://github.com/untra/polyglot/issues/151) and [#184](https://github.com/untra/polyglot/issues/184), preventing crashes on startup when calling other jekyll commands.