---
layout: post
title: Polyglot 1.10 - améliorations de i18n_headers
lang: fr
description: Publication de Jekyll Polyglot 1.10.0, avec des améliorations SEO lors de l'utilisation du plugin i18n_headers
---

Jekyll-Polyglot 1.10 est maintenant disponible. Il apporte de vastes améliorations et changements au plugin liquid `i18n_headers` pour le SEO, ainsi que des ajustements mineurs pour l'idempotence lors des constructions parallèles. Les contributions de la communauté et le Vibe Coding ont aidé à une grande partie des fonctionnalités, des tests et de la rédaction de cet article.

## Améliorations de i18n_headers

Le plugin `i18n_headers` dispose désormais de capacités étendues dans cette version :

* Il ajoute `<link rel="canonical" ...>` pour chaque langue de page, afin que l'indexation soit unique sur tous les sites.
* Il ajoute `<link rel="alternate" hreflang="x-default" ...>` pour pointer vers la version par défaut du site lorsqu'aucune langue ne correspond à la demande du navigateur.
* Il définit correctement `<link rel="alternate" hreflang="...">` pour les pages et articles dans des collections avec des permaliens personnalisés.
* L'URL par défaut inclura désormais `site.baseUrl` si défini.

Cela corrige également un bug qui causait la modification involontaire de ces balises lors de la relativisation des URLs absolues.

## Contributions vibe-coded

L'utilisation de certains outils de [vibe coding](https://en.wikipedia.org/wiki/Vibe_coding) a permis de trouver, mesurer et vérifier les corrections de bugs et les fonctionnalités de cette version. C'est une nouvelle approche du développement logiciel, qui a permis d'écrire des tests Ruby avancés pour le code du plugin Jekyll exécuté sur de nombreux sites multilingues.

Les tests écrits avec vibe coding ont permis de maintenir une couverture de test élevée et d'ajouter des fonctionnalités complexes en toute confiance. L'automatisation des tests a permis de garantir la bonne construction de fonctionnalités délicates.

De plus, les outils de vibe coding ont aidé à traduire cet article de blog dans de nombreuses langues.

## Contributions de la communauté

Jekyll-Polyglot est soutenu par des humains. La documentation linguistique humaine est apportée par des personnes qui souhaitent voir ce plugin documenté dans leur langue maternelle. Les personnes qui contribuent à la correction de bugs et à la documentation ont permis à ce plugin d'atteindre des milliers de téléchargements à chaque version. La programmation assistée par l'IA, entre mes mains ou les vôtres, façonnera les logiciels que nous utilisons, et dans les nombreuses langues que nous écrivons et parlons. 

## ruby >= 3.1 requis

Les mises à jour de sécurité continues des dépendances de compilation de jekyll-polyglot ont nécessité une mise à niveau majeure vers ruby 3.1. Cela peut affecter les systèmes de build qui génèrent leur documentation avec jekyll-polyglot. C'est le bon moment pour passer à la dernière version majeure de ruby. Faites-nous savoir si ces changements posent des problèmes avec les builds jekyll. 