// Print out help message and exit; to be passed to the SOptions package.
class CDKDepictHelp extends VersionOption {

    CDKDepictHelp( String short_name, String long_name, OptionType opt_type )
    {
        super( short_name, long_name, opt_type );
    }

    int proc( String args[], int i ) {
        System.out.print
            ( "Depict molecules given as SMILES strings in\n" +
              "SVG, PDF PS (PostScript) or EPS (Encapsulated PS)\n" +
              "formats.\n\n" +

              "USAGE\n" +
              "    " + progName + " < input.smi\n" +
              "    " + progName + " inputs*.smi\n" +
              "OPTIONS:\n" +
              "    -a, --auto-kekulise\n" +
              "        Attempt to \"kekulise\" aromatic smiles, " +
              "switch to non-kekulised\n" +
              "        representation " +
              "if kekulisation fails (default)\n\n" +
              "    -k, --kekulise\n" +
              "        Always \"kekulise\" aromatic smiles\n\n" +
              "    -k-, --dont-kekulise, --do-not-kekulise\n" +
              "        Do not \"kekulise\" aromatic smiles, " +
              "leave input as it is\n\n" +
              "    --show-atom-numbers\n" +
              "        Display atom numbers in the output\n\n" +
              "    --no-show-atom-numbers\n" +
              "        Do not display atom numbers in the output (default)\n\n" +
              "    --smiles c1ccccc1\n" +
              "        Specify SMILES string to depict " +
              "instead of reading input files\n" +

              "\n" +
              "    -S, --svg-output Produce SVG output\n" +
              "    -E, --eps-output Produce EPS output\n" +
              "    -P, --pdf-output Produce PDF output\n" +

              "\n" +
              "    --supported-formats\n" +
              "        List formats supported for a given input\n\n" +
              "    --version  Print program version and exit\n" +
              "    --help     Print short help message (this message) and exit\n"
        );
        System.exit(0);
        return i;
    }
}
